/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.api;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.extranet.invoker.ApiClient;
import travel.wink.sdk.extranet.model.BookingTestRequest;
import travel.wink.sdk.extranet.model.BookingView;
import travel.wink.sdk.extranet.model.ChannelName;
import travel.wink.sdk.extranet.model.DailyRateListUpdate;
import travel.wink.sdk.extranet.model.DailyRateUpdate;
import travel.wink.sdk.extranet.model.DateRange;
import travel.wink.sdk.extranet.model.DescriptiveRoom;
import travel.wink.sdk.extranet.model.PageRate;
import travel.wink.sdk.extranet.model.Rate;
import travel.wink.sdk.extranet.model.RateTester;
import travel.wink.sdk.extranet.model.State;

public class DailyRateApi {
    private ApiClient apiClient;

    public DailyRateApi() {
        this(new ApiClient());
    }

    @Autowired
    public DailyRateApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec bulkUpdateRateRequestCreation(String hotelIdentifier, String masterRateIdentifier, DailyRateUpdate dailyRateUpdate) throws WebClientResponseException {
        DailyRateUpdate postBody = dailyRateUpdate;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling bulkUpdateRate", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (masterRateIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'masterRateIdentifier' when calling bulkUpdateRate", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (dailyRateUpdate == null) {
            throw new WebClientResponseException("Missing the required parameter 'dailyRateUpdate' when calling bulkUpdateRate", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("masterRateIdentifier", masterRateIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/vnd.platform-v1+json", "application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<Rate> localVarReturnType = new ParameterizedTypeReference<Rate>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/roomrate/{masterRateIdentifier}/rate/update", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<Rate> bulkUpdateRate(String hotelIdentifier, String masterRateIdentifier, DailyRateUpdate dailyRateUpdate) throws WebClientResponseException {
        ParameterizedTypeReference<Rate> localVarReturnType = new ParameterizedTypeReference<Rate>(){};
        return this.bulkUpdateRateRequestCreation(hotelIdentifier, masterRateIdentifier, dailyRateUpdate).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<Rate>>> bulkUpdateRateWithHttpInfo(String hotelIdentifier, String masterRateIdentifier, DailyRateUpdate dailyRateUpdate) throws WebClientResponseException {
        ParameterizedTypeReference<Rate> localVarReturnType = new ParameterizedTypeReference<Rate>(){};
        return this.bulkUpdateRateRequestCreation(hotelIdentifier, masterRateIdentifier, dailyRateUpdate).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec bulkUpdateRate1RequestCreation(String hotelIdentifier, String masterRateIdentifier, DailyRateListUpdate dailyRateListUpdate) throws WebClientResponseException {
        DailyRateListUpdate postBody = dailyRateListUpdate;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling bulkUpdateRate1", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (masterRateIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'masterRateIdentifier' when calling bulkUpdateRate1", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (dailyRateListUpdate == null) {
            throw new WebClientResponseException("Missing the required parameter 'dailyRateListUpdate' when calling bulkUpdateRate1", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("masterRateIdentifier", masterRateIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/vnd.platform-v1+json", "application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<Rate> localVarReturnType = new ParameterizedTypeReference<Rate>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/roomrate/{masterRateIdentifier}/rate/list/update", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<Rate> bulkUpdateRate1(String hotelIdentifier, String masterRateIdentifier, DailyRateListUpdate dailyRateListUpdate) throws WebClientResponseException {
        ParameterizedTypeReference<Rate> localVarReturnType = new ParameterizedTypeReference<Rate>(){};
        return this.bulkUpdateRate1RequestCreation(hotelIdentifier, masterRateIdentifier, dailyRateListUpdate).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<Rate>>> bulkUpdateRate1WithHttpInfo(String hotelIdentifier, String masterRateIdentifier, DailyRateListUpdate dailyRateListUpdate) throws WebClientResponseException {
        ParameterizedTypeReference<Rate> localVarReturnType = new ParameterizedTypeReference<Rate>(){};
        return this.bulkUpdateRate1RequestCreation(hotelIdentifier, masterRateIdentifier, dailyRateListUpdate).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec createTestBookingRequestCreation(String hotelIdentifier, BookingTestRequest bookingTestRequest) throws WebClientResponseException {
        BookingTestRequest postBody = bookingTestRequest;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling createTestBooking", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (bookingTestRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'bookingTestRequest' when calling createTestBooking", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/vnd.platform-v1+json", "application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<BookingView> localVarReturnType = new ParameterizedTypeReference<BookingView>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/sandbox/booking", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<BookingView> createTestBooking(String hotelIdentifier, BookingTestRequest bookingTestRequest) throws WebClientResponseException {
        ParameterizedTypeReference<BookingView> localVarReturnType = new ParameterizedTypeReference<BookingView>(){};
        return this.createTestBookingRequestCreation(hotelIdentifier, bookingTestRequest).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<BookingView>> createTestBookingWithHttpInfo(String hotelIdentifier, BookingTestRequest bookingTestRequest) throws WebClientResponseException {
        ParameterizedTypeReference<BookingView> localVarReturnType = new ParameterizedTypeReference<BookingView>(){};
        return this.createTestBookingRequestCreation(hotelIdentifier, bookingTestRequest).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showAllHotelRatesRequestCreation(String hotelIdentifier, DateRange dateRange) throws WebClientResponseException {
        DateRange postBody = dateRange;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showAllHotelRates", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (dateRange == null) {
            throw new WebClientResponseException("Missing the required parameter 'dateRange' when calling showAllHotelRates", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/vnd.platform-v1+json", "application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<Rate> localVarReturnType = new ParameterizedTypeReference<Rate>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/roomrate/rates/dates", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<Rate> showAllHotelRates(String hotelIdentifier, DateRange dateRange) throws WebClientResponseException {
        ParameterizedTypeReference<Rate> localVarReturnType = new ParameterizedTypeReference<Rate>(){};
        return this.showAllHotelRatesRequestCreation(hotelIdentifier, dateRange).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<Rate>>> showAllHotelRatesWithHttpInfo(String hotelIdentifier, DateRange dateRange) throws WebClientResponseException {
        ParameterizedTypeReference<Rate> localVarReturnType = new ParameterizedTypeReference<Rate>(){};
        return this.showAllHotelRatesRequestCreation(hotelIdentifier, dateRange).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showAllMasterRatesRatesRequestCreation(String hotelIdentifier, String masterRateIdentifier, DateRange dateRange) throws WebClientResponseException {
        DateRange postBody = dateRange;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showAllMasterRatesRates", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (masterRateIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'masterRateIdentifier' when calling showAllMasterRatesRates", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (dateRange == null) {
            throw new WebClientResponseException("Missing the required parameter 'dateRange' when calling showAllMasterRatesRates", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("masterRateIdentifier", masterRateIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/vnd.platform-v1+json", "application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<Rate> localVarReturnType = new ParameterizedTypeReference<Rate>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/roomrate/{masterRateIdentifier}/rates/dates", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<Rate> showAllMasterRatesRates(String hotelIdentifier, String masterRateIdentifier, DateRange dateRange) throws WebClientResponseException {
        ParameterizedTypeReference<Rate> localVarReturnType = new ParameterizedTypeReference<Rate>(){};
        return this.showAllMasterRatesRatesRequestCreation(hotelIdentifier, masterRateIdentifier, dateRange).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<Rate>>> showAllMasterRatesRatesWithHttpInfo(String hotelIdentifier, String masterRateIdentifier, DateRange dateRange) throws WebClientResponseException {
        ParameterizedTypeReference<Rate> localVarReturnType = new ParameterizedTypeReference<Rate>(){};
        return this.showAllMasterRatesRatesRequestCreation(hotelIdentifier, masterRateIdentifier, dateRange).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showChannelsRequestCreation(String hotelIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showChannels", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<ChannelName> localVarReturnType = new ParameterizedTypeReference<ChannelName>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/sandbox/channel/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<ChannelName> showChannels(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<ChannelName> localVarReturnType = new ParameterizedTypeReference<ChannelName>(){};
        return this.showChannelsRequestCreation(hotelIdentifier, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<ChannelName>>> showChannelsWithHttpInfo(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<ChannelName> localVarReturnType = new ParameterizedTypeReference<ChannelName>(){};
        return this.showChannelsRequestCreation(hotelIdentifier, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showDailyRatesPageRequestCreation(String hotelIdentifier, String masterRateIdentifier, State state) throws WebClientResponseException {
        State postBody = state;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showDailyRatesPage", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (masterRateIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'masterRateIdentifier' when calling showDailyRatesPage", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (state == null) {
            throw new WebClientResponseException("Missing the required parameter 'state' when calling showDailyRatesPage", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("masterRateIdentifier", masterRateIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/vnd.platform-v1+json", "application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<PageRate> localVarReturnType = new ParameterizedTypeReference<PageRate>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/roomrate/{masterRateIdentifier}/rate/grid", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PageRate> showDailyRatesPage(String hotelIdentifier, String masterRateIdentifier, State state) throws WebClientResponseException {
        ParameterizedTypeReference<PageRate> localVarReturnType = new ParameterizedTypeReference<PageRate>(){};
        return this.showDailyRatesPageRequestCreation(hotelIdentifier, masterRateIdentifier, state).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PageRate>> showDailyRatesPageWithHttpInfo(String hotelIdentifier, String masterRateIdentifier, State state) throws WebClientResponseException {
        ParameterizedTypeReference<PageRate> localVarReturnType = new ParameterizedTypeReference<PageRate>(){};
        return this.showDailyRatesPageRequestCreation(hotelIdentifier, masterRateIdentifier, state).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showDescriptiveInventoryRequestCreation(String hotelIdentifier, RateTester rateTester) throws WebClientResponseException {
        RateTester postBody = rateTester;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showDescriptiveInventory", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (rateTester == null) {
            throw new WebClientResponseException("Missing the required parameter 'rateTester' when calling showDescriptiveInventory", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/vnd.platform-v1+json", "application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<DescriptiveRoom> localVarReturnType = new ParameterizedTypeReference<DescriptiveRoom>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/sandbox/room/list", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<DescriptiveRoom> showDescriptiveInventory(String hotelIdentifier, RateTester rateTester) throws WebClientResponseException {
        ParameterizedTypeReference<DescriptiveRoom> localVarReturnType = new ParameterizedTypeReference<DescriptiveRoom>(){};
        return this.showDescriptiveInventoryRequestCreation(hotelIdentifier, rateTester).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<DescriptiveRoom>>> showDescriptiveInventoryWithHttpInfo(String hotelIdentifier, RateTester rateTester) throws WebClientResponseException {
        ParameterizedTypeReference<DescriptiveRoom> localVarReturnType = new ParameterizedTypeReference<DescriptiveRoom>(){};
        return this.showDescriptiveInventoryRequestCreation(hotelIdentifier, rateTester).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }
}

