/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.api;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.extranet.invoker.ApiClient;
import travel.wink.sdk.extranet.model.BasicHotelInformation;
import travel.wink.sdk.extranet.model.HotelStatus;
import travel.wink.sdk.extranet.model.HotelView;
import travel.wink.sdk.extranet.model.PropertyAmenities;
import travel.wink.sdk.extranet.model.UniqueResult;
import travel.wink.sdk.extranet.model.Wizard;

public class PropertyApi {
    private ApiClient apiClient;

    public PropertyApi() {
        this(new ApiClient());
    }

    @Autowired
    public PropertyApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec isHotelNameUniqueRequestCreation(String key, String hotelIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (key == null) {
            throw new WebClientResponseException("Missing the required parameter 'key' when calling isHotelNameUnique", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "key", key));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "hotelIdentifier", hotelIdentifier));
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<UniqueResult> localVarReturnType = new ParameterizedTypeReference<UniqueResult>(){};
        return this.apiClient.invokeAPI("/api/hotel/uniquename", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<UniqueResult> isHotelNameUnique(String key, String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<UniqueResult> localVarReturnType = new ParameterizedTypeReference<UniqueResult>(){};
        return this.isHotelNameUniqueRequestCreation(key, hotelIdentifier, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<UniqueResult>> isHotelNameUniqueWithHttpInfo(String key, String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<UniqueResult> localVarReturnType = new ParameterizedTypeReference<UniqueResult>(){};
        return this.isHotelNameUniqueRequestCreation(key, hotelIdentifier, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec onboardToKYCPathRequestCreation(String hotelIdentifier) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling onboardToKYCPath", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<Wizard> localVarReturnType = new ParameterizedTypeReference<Wizard>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/invite/kyc", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<Wizard> onboardToKYCPath(String hotelIdentifier) throws WebClientResponseException {
        ParameterizedTypeReference<Wizard> localVarReturnType = new ParameterizedTypeReference<Wizard>(){};
        return this.onboardToKYCPathRequestCreation(hotelIdentifier).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<Wizard>> onboardToKYCPathWithHttpInfo(String hotelIdentifier) throws WebClientResponseException {
        ParameterizedTypeReference<Wizard> localVarReturnType = new ParameterizedTypeReference<Wizard>(){};
        return this.onboardToKYCPathRequestCreation(hotelIdentifier).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showHotelByManagerRequestCreation(String hotelIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showHotelByManager", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<HotelView> localVarReturnType = new ParameterizedTypeReference<HotelView>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<HotelView> showHotelByManager(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<HotelView> localVarReturnType = new ParameterizedTypeReference<HotelView>(){};
        return this.showHotelByManagerRequestCreation(hotelIdentifier, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<HotelView>> showHotelByManagerWithHttpInfo(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<HotelView> localVarReturnType = new ParameterizedTypeReference<HotelView>(){};
        return this.showHotelByManagerRequestCreation(hotelIdentifier, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showHotelStatusRequestCreation(String hotelIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showHotelStatus", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<HotelStatus> localVarReturnType = new ParameterizedTypeReference<HotelStatus>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/status", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<HotelStatus> showHotelStatus(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<HotelStatus> localVarReturnType = new ParameterizedTypeReference<HotelStatus>(){};
        return this.showHotelStatusRequestCreation(hotelIdentifier, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<HotelStatus>> showHotelStatusWithHttpInfo(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<HotelStatus> localVarReturnType = new ParameterizedTypeReference<HotelStatus>(){};
        return this.showHotelStatusRequestCreation(hotelIdentifier, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showHotelsByManagerRequestCreation(String accept) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<HotelView> localVarReturnType = new ParameterizedTypeReference<HotelView>(){};
        return this.apiClient.invokeAPI("/api/hotel/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<HotelView> showHotelsByManager(String accept) throws WebClientResponseException {
        ParameterizedTypeReference<HotelView> localVarReturnType = new ParameterizedTypeReference<HotelView>(){};
        return this.showHotelsByManagerRequestCreation(accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<HotelView>>> showHotelsByManagerWithHttpInfo(String accept) throws WebClientResponseException {
        ParameterizedTypeReference<HotelView> localVarReturnType = new ParameterizedTypeReference<HotelView>(){};
        return this.showHotelsByManagerRequestCreation(accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec updateBasicsRequestCreation(String hotelIdentifier, BasicHotelInformation basicHotelInformation) throws WebClientResponseException {
        BasicHotelInformation postBody = basicHotelInformation;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling updateBasics", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (basicHotelInformation == null) {
            throw new WebClientResponseException("Missing the required parameter 'basicHotelInformation' when calling updateBasics", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/vnd.platform-v1+json", "application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<BasicHotelInformation> localVarReturnType = new ParameterizedTypeReference<BasicHotelInformation>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/info", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<BasicHotelInformation> updateBasics(String hotelIdentifier, BasicHotelInformation basicHotelInformation) throws WebClientResponseException {
        ParameterizedTypeReference<BasicHotelInformation> localVarReturnType = new ParameterizedTypeReference<BasicHotelInformation>(){};
        return this.updateBasicsRequestCreation(hotelIdentifier, basicHotelInformation).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<BasicHotelInformation>> updateBasicsWithHttpInfo(String hotelIdentifier, BasicHotelInformation basicHotelInformation) throws WebClientResponseException {
        ParameterizedTypeReference<BasicHotelInformation> localVarReturnType = new ParameterizedTypeReference<BasicHotelInformation>(){};
        return this.updateBasicsRequestCreation(hotelIdentifier, basicHotelInformation).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec updateHotelStatusRequestCreation(String hotelIdentifier, HotelStatus hotelStatus) throws WebClientResponseException {
        HotelStatus postBody = hotelStatus;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling updateHotelStatus", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (hotelStatus == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelStatus' when calling updateHotelStatus", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/vnd.platform-v1+json", "application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<HotelStatus> localVarReturnType = new ParameterizedTypeReference<HotelStatus>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/status", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<HotelStatus> updateHotelStatus(String hotelIdentifier, HotelStatus hotelStatus) throws WebClientResponseException {
        ParameterizedTypeReference<HotelStatus> localVarReturnType = new ParameterizedTypeReference<HotelStatus>(){};
        return this.updateHotelStatusRequestCreation(hotelIdentifier, hotelStatus).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<HotelStatus>> updateHotelStatusWithHttpInfo(String hotelIdentifier, HotelStatus hotelStatus) throws WebClientResponseException {
        ParameterizedTypeReference<HotelStatus> localVarReturnType = new ParameterizedTypeReference<HotelStatus>(){};
        return this.updateHotelStatusRequestCreation(hotelIdentifier, hotelStatus).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec updateServicesRequestCreation(String hotelIdentifier, PropertyAmenities propertyAmenities) throws WebClientResponseException {
        PropertyAmenities postBody = propertyAmenities;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling updateServices", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (propertyAmenities == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyAmenities' when calling updateServices", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/vnd.platform-v1+json", "application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<PropertyAmenities> localVarReturnType = new ParameterizedTypeReference<PropertyAmenities>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/services", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PropertyAmenities> updateServices(String hotelIdentifier, PropertyAmenities propertyAmenities) throws WebClientResponseException {
        ParameterizedTypeReference<PropertyAmenities> localVarReturnType = new ParameterizedTypeReference<PropertyAmenities>(){};
        return this.updateServicesRequestCreation(hotelIdentifier, propertyAmenities).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PropertyAmenities>> updateServicesWithHttpInfo(String hotelIdentifier, PropertyAmenities propertyAmenities) throws WebClientResponseException {
        ParameterizedTypeReference<PropertyAmenities> localVarReturnType = new ParameterizedTypeReference<PropertyAmenities>(){};
        return this.updateServicesRequestCreation(hotelIdentifier, propertyAmenities).toEntity((ParameterizedTypeReference)localVarReturnType);
    }
}

