/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import travel.wink.sdk.extranet.model.IdentifierNamePair;

@JsonPropertyOrder(value={"hotelIdentifier", "addOnIdentifier", "removable", "rateModifiers"})
public class AddOnRemovableResponse {
    public static final String JSON_PROPERTY_HOTEL_IDENTIFIER = "hotelIdentifier";
    private String hotelIdentifier;
    public static final String JSON_PROPERTY_ADD_ON_IDENTIFIER = "addOnIdentifier";
    private String addOnIdentifier;
    public static final String JSON_PROPERTY_REMOVABLE = "removable";
    private Boolean removable = false;
    public static final String JSON_PROPERTY_RATE_MODIFIERS = "rateModifiers";
    private List<IdentifierNamePair> rateModifiers = null;

    public AddOnRemovableResponse hotelIdentifier(String hotelIdentifier) {
        this.hotelIdentifier = hotelIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="hotel-1", required=true, value="Add-On owner identifier")
    @JsonProperty(value="hotelIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getHotelIdentifier() {
        return this.hotelIdentifier;
    }

    @JsonProperty(value="hotelIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setHotelIdentifier(String hotelIdentifier) {
        this.hotelIdentifier = hotelIdentifier;
    }

    public AddOnRemovableResponse addOnIdentifier(String addOnIdentifier) {
        this.addOnIdentifier = addOnIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="add-on-1", required=true, value="Add-On identifier to verify removable")
    @JsonProperty(value="addOnIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAddOnIdentifier() {
        return this.addOnIdentifier;
    }

    @JsonProperty(value="addOnIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAddOnIdentifier(String addOnIdentifier) {
        this.addOnIdentifier = addOnIdentifier;
    }

    public AddOnRemovableResponse removable(Boolean removable) {
        this.removable = removable;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="true", required=true, value="Whether add-on is removable or not")
    @JsonProperty(value="removable")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getRemovable() {
        return this.removable;
    }

    @JsonProperty(value="removable")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRemovable(Boolean removable) {
        this.removable = removable;
    }

    public AddOnRemovableResponse rateModifiers(List<IdentifierNamePair> rateModifiers) {
        this.rateModifiers = rateModifiers;
        return this;
    }

    public AddOnRemovableResponse addRateModifiersItem(IdentifierNamePair rateModifiersItem) {
        if (this.rateModifiers == null) {
            this.rateModifiers = new ArrayList<IdentifierNamePair>();
        }
        this.rateModifiers.add(rateModifiersItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="If add-on is not removable, this list will show promotions are currently linked to this add-on.")
    @JsonProperty(value="rateModifiers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<IdentifierNamePair> getRateModifiers() {
        return this.rateModifiers;
    }

    @JsonProperty(value="rateModifiers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRateModifiers(List<IdentifierNamePair> rateModifiers) {
        this.rateModifiers = rateModifiers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AddOnRemovableResponse addOnRemovableResponse = (AddOnRemovableResponse)o;
        return Objects.equals(this.hotelIdentifier, addOnRemovableResponse.hotelIdentifier) && Objects.equals(this.addOnIdentifier, addOnRemovableResponse.addOnIdentifier) && Objects.equals(this.removable, addOnRemovableResponse.removable) && Objects.equals(this.rateModifiers, addOnRemovableResponse.rateModifiers);
    }

    public int hashCode() {
        return Objects.hash(this.hotelIdentifier, this.addOnIdentifier, this.removable, this.rateModifiers);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AddOnRemovableResponse {\n");
        sb.append("    hotelIdentifier: ").append(this.toIndentedString(this.hotelIdentifier)).append("\n");
        sb.append("    addOnIdentifier: ").append(this.toIndentedString(this.addOnIdentifier)).append("\n");
        sb.append("    removable: ").append(this.toIndentedString(this.removable)).append("\n");
        sb.append("    rateModifiers: ").append(this.toIndentedString(this.rateModifiers)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

