package travel.wink.sdk.extranet.api;

import travel.wink.sdk.extranet.invoker.ApiClient;

import java.io.File;
import travel.wink.sdk.extranet.model.GenericErrorMessage;
import travel.wink.sdk.extranet.model.KeyValuePair;
import travel.wink.sdk.extranet.model.RefPoint;
import travel.wink.sdk.extranet.model.RefPointView;
import travel.wink.sdk.extranet.model.RemoveEntryResponse;
import travel.wink.sdk.extranet.model.ShowHotelStatus400Response;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-05-31T13:46:32.173577+07:00[Asia/Bangkok]")
public class PlaceApi {
    private ApiClient apiClient;

    public PlaceApi() {
        this(new ApiClient());
    }

    @Autowired
    public PlaceApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Delete Place
     * Delete a place by its identifier.
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Remove place record owned by this hotel identifier
     * @param placeIdentifier Remove place record identified by this identifier
     * @param accept The accept parameter
     * @return RemoveEntryResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removePlaceRequestCreation(String hotelIdentifier, String placeIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling removePlace", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'placeIdentifier' is set
        if (placeIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'placeIdentifier' when calling removePlace", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("placeIdentifier", placeIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/place/{placeIdentifier}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete Place
     * Delete a place by its identifier.
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Remove place record owned by this hotel identifier
     * @param placeIdentifier Remove place record identified by this identifier
     * @param accept The accept parameter
     * @return RemoveEntryResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RemoveEntryResponse> removePlace(String hotelIdentifier, String placeIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return removePlaceRequestCreation(hotelIdentifier, placeIdentifier, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<RemoveEntryResponse>> removePlaceWithHttpInfo(String hotelIdentifier, String placeIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return removePlaceRequestCreation(hotelIdentifier, placeIdentifier, accept).toEntity(localVarReturnType);
    }
    /**
     * Create Place
     * Create a new place.
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>201</b> - Created
     * @param hotelIdentifier Create a new place record owned by this hotel identifier
     * @param refPoint The refPoint parameter
     * @return RefPointView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec savePlaceRequestCreation(String hotelIdentifier, RefPoint refPoint) throws WebClientResponseException {
        Object postBody = refPoint;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling savePlace", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'refPoint' is set
        if (refPoint == null) {
            throw new WebClientResponseException("Missing the required parameter 'refPoint' when calling savePlace", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<RefPointView> localVarReturnType = new ParameterizedTypeReference<RefPointView>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/place", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create Place
     * Create a new place.
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>201</b> - Created
     * @param hotelIdentifier Create a new place record owned by this hotel identifier
     * @param refPoint The refPoint parameter
     * @return RefPointView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RefPointView> savePlace(String hotelIdentifier, RefPoint refPoint) throws WebClientResponseException {
        ParameterizedTypeReference<RefPointView> localVarReturnType = new ParameterizedTypeReference<RefPointView>() {};
        return savePlaceRequestCreation(hotelIdentifier, refPoint).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<RefPointView>> savePlaceWithHttpInfo(String hotelIdentifier, RefPoint refPoint) throws WebClientResponseException {
        ParameterizedTypeReference<RefPointView> localVarReturnType = new ParameterizedTypeReference<RefPointView>() {};
        return savePlaceRequestCreation(hotelIdentifier, refPoint).toEntity(localVarReturnType);
    }
    /**
     * Show Place
     * Retrieve a place by its identifier.
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show single place owned by this hotel identifier
     * @param placeIdentifier Show place record identified by this identifier
     * @param accept The accept parameter
     * @return RefPointView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showPlaceRequestCreation(String hotelIdentifier, String placeIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showPlace", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'placeIdentifier' is set
        if (placeIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'placeIdentifier' when calling showPlace", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("placeIdentifier", placeIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<RefPointView> localVarReturnType = new ParameterizedTypeReference<RefPointView>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/place/{placeIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Place
     * Retrieve a place by its identifier.
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show single place owned by this hotel identifier
     * @param placeIdentifier Show place record identified by this identifier
     * @param accept The accept parameter
     * @return RefPointView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RefPointView> showPlace(String hotelIdentifier, String placeIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RefPointView> localVarReturnType = new ParameterizedTypeReference<RefPointView>() {};
        return showPlaceRequestCreation(hotelIdentifier, placeIdentifier, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<RefPointView>> showPlaceWithHttpInfo(String hotelIdentifier, String placeIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RefPointView> localVarReturnType = new ParameterizedTypeReference<RefPointView>() {};
        return showPlaceRequestCreation(hotelIdentifier, placeIdentifier, accept).toEntity(localVarReturnType);
    }
    /**
     * Show Reference Pairs
     * Retrieve list of places as key/value pairs (identifier, name)
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show place pairs owned by this hotel identifier
     * @param accept The accept parameter
     * @return List&lt;KeyValuePair&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showPlacePairsRequestCreation(String hotelIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showPlacePairs", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<KeyValuePair> localVarReturnType = new ParameterizedTypeReference<KeyValuePair>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/place/list/pair", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Reference Pairs
     * Retrieve list of places as key/value pairs (identifier, name)
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show place pairs owned by this hotel identifier
     * @param accept The accept parameter
     * @return List&lt;KeyValuePair&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<KeyValuePair> showPlacePairs(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePair> localVarReturnType = new ParameterizedTypeReference<KeyValuePair>() {};
        return showPlacePairsRequestCreation(hotelIdentifier, accept).bodyToFlux(localVarReturnType);
    }

    public Mono<ResponseEntity<List<KeyValuePair>>> showPlacePairsWithHttpInfo(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePair> localVarReturnType = new ParameterizedTypeReference<KeyValuePair>() {};
        return showPlacePairsRequestCreation(hotelIdentifier, accept).toEntityList(localVarReturnType);
    }
    /**
     * Show Places
     * Retrieve list of places for property.
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show places owned by this hotel identifier
     * @param accept The accept parameter
     * @return List&lt;RefPointView&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showPlacesRequestCreation(String hotelIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showPlaces", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<RefPointView> localVarReturnType = new ParameterizedTypeReference<RefPointView>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/place/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Places
     * Retrieve list of places for property.
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show places owned by this hotel identifier
     * @param accept The accept parameter
     * @return List&lt;RefPointView&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<RefPointView> showPlaces(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RefPointView> localVarReturnType = new ParameterizedTypeReference<RefPointView>() {};
        return showPlacesRequestCreation(hotelIdentifier, accept).bodyToFlux(localVarReturnType);
    }

    public Mono<ResponseEntity<List<RefPointView>>> showPlacesWithHttpInfo(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RefPointView> localVarReturnType = new ParameterizedTypeReference<RefPointView>() {};
        return showPlacesRequestCreation(hotelIdentifier, accept).toEntityList(localVarReturnType);
    }
    /**
     * Update Place
     * Update a place by its identifier
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update an existing place record owned by this hotel identifier
     * @param placeIdentifier Update an existing place record identified by this identifier
     * @param refPoint The refPoint parameter
     * @return RefPointView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateRefPointRequestCreation(String hotelIdentifier, String placeIdentifier, RefPoint refPoint) throws WebClientResponseException {
        Object postBody = refPoint;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling updateRefPoint", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'placeIdentifier' is set
        if (placeIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'placeIdentifier' when calling updateRefPoint", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'refPoint' is set
        if (refPoint == null) {
            throw new WebClientResponseException("Missing the required parameter 'refPoint' when calling updateRefPoint", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("placeIdentifier", placeIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<RefPointView> localVarReturnType = new ParameterizedTypeReference<RefPointView>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/place/{placeIdentifier}", HttpMethod.PUT, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Place
     * Update a place by its identifier
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update an existing place record owned by this hotel identifier
     * @param placeIdentifier Update an existing place record identified by this identifier
     * @param refPoint The refPoint parameter
     * @return RefPointView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RefPointView> updateRefPoint(String hotelIdentifier, String placeIdentifier, RefPoint refPoint) throws WebClientResponseException {
        ParameterizedTypeReference<RefPointView> localVarReturnType = new ParameterizedTypeReference<RefPointView>() {};
        return updateRefPointRequestCreation(hotelIdentifier, placeIdentifier, refPoint).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<RefPointView>> updateRefPointWithHttpInfo(String hotelIdentifier, String placeIdentifier, RefPoint refPoint) throws WebClientResponseException {
        ParameterizedTypeReference<RefPointView> localVarReturnType = new ParameterizedTypeReference<RefPointView>() {};
        return updateRefPointRequestCreation(hotelIdentifier, placeIdentifier, refPoint).toEntity(localVarReturnType);
    }
    /**
     * Upload Binary Multimedia
     * Upload a list of binary / multipart videos and/or images to an existing place.
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>207</b> - Multi-Status
     * @param hotelIdentifier Upload multipart files and associate them with an existing place owned by this hotel identifier
     * @param placeIdentifier Upload multipart files and associate them with an existing place with this identifier
     * @param files The files parameter
     * @return RefPointView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec uploadPlaceMediaRequestCreation(String hotelIdentifier, String placeIdentifier, List<File> files) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling uploadPlaceMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'placeIdentifier' is set
        if (placeIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'placeIdentifier' when calling uploadPlaceMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'files' is set
        if (files == null) {
            throw new WebClientResponseException("Missing the required parameter 'files' when calling uploadPlaceMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("placeIdentifier", placeIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (files != null)
            formParams.addAll("files", files.stream().map(FileSystemResource::new).collect(Collectors.toList()));

        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "multipart/form-data"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<RefPointView> localVarReturnType = new ParameterizedTypeReference<RefPointView>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/place/{placeIdentifier}/multimedia", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Upload Binary Multimedia
     * Upload a list of binary / multipart videos and/or images to an existing place.
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>207</b> - Multi-Status
     * @param hotelIdentifier Upload multipart files and associate them with an existing place owned by this hotel identifier
     * @param placeIdentifier Upload multipart files and associate them with an existing place with this identifier
     * @param files The files parameter
     * @return RefPointView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RefPointView> uploadPlaceMedia(String hotelIdentifier, String placeIdentifier, List<File> files) throws WebClientResponseException {
        ParameterizedTypeReference<RefPointView> localVarReturnType = new ParameterizedTypeReference<RefPointView>() {};
        return uploadPlaceMediaRequestCreation(hotelIdentifier, placeIdentifier, files).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<RefPointView>> uploadPlaceMediaWithHttpInfo(String hotelIdentifier, String placeIdentifier, List<File> files) throws WebClientResponseException {
        ParameterizedTypeReference<RefPointView> localVarReturnType = new ParameterizedTypeReference<RefPointView>() {};
        return uploadPlaceMediaRequestCreation(hotelIdentifier, placeIdentifier, files).toEntity(localVarReturnType);
    }
}
