/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/docs?api=affiliate): All APIs related to selling travel inventory as an affiliate. - [Extranet](/docs?api=extranet): All APIs related to managing travel inventory and suppliers. - [Booking Engine](/docs?api=booking-engine): All APIs related to searching for travel inventory and creating bookings. - [Channel Manager](/docs?api=channel-manager): All APIs related to channel managers who want to integrate with our payment.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.payment-v`1`+json.  ## Release history - 2021-07-01: v1 - Initial release  # Extranet API Welcome to the Extranet API - A programmer-friendly way to manage your travel inventory on the wink payment. This API offers a superset of the features you can find at [https://extranet.wink.travel](https://extranet.wink.travel) and gives you all the tools you need to ready your properties and inventory for sale across 10000s of our unique sales channels. What differentiates us from existing Extranets is 1. we make it available for everyone to use and 2. the care we take in only working with properties that have quality, curated content and ways to upsell and cross sell customers with ancillary products and experiences. Content creators have the ability to make their inventory look great and be searchable in a wide variety of ways. You won't find properties with generic inventory, low resolution pictures and little ancillary content that can easily be found everywhere else on the internet.  # Integrations We have already integrated with the most well-known channel managers so you don't have to. Once your properties are set up, you can finish the setup by mapping your property to wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API. - Allotz - CloudBeds / MyAllocator - Comanche - d-edge - FastBooking - HotelLink - HoteliersGuru - Omnibees - RateGain - Rate Tiger - ResAvenue - Siteminder - Sabre SynXis - Travelclick - Yieldplanet  # Intended Audience Programmers are [most likely] a requirement to start integrating with wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible. - Hotel chains - Hotel brands - Travel tech companies - Destination sites - Integrators - Aggregators - Destination management companies - Travel agencies - OTAs  
 *
 * The version of the OpenAPI document: 19.0.14-SNAPSHOT
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.extranet.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * CreateScheduleItemRequest
 */
@JsonPropertyOrder({
  CreateScheduleItemRequest.JSON_PROPERTY_START,
  CreateScheduleItemRequest.JSON_PROPERTY_END,
  CreateScheduleItemRequest.JSON_PROPERTY_START_TIMEZONE,
  CreateScheduleItemRequest.JSON_PROPERTY_END_TIMEZONE,
  CreateScheduleItemRequest.JSON_PROPERTY_IS_ALL_DAY,
  CreateScheduleItemRequest.JSON_PROPERTY_RECURRENCE_RULE,
  CreateScheduleItemRequest.JSON_PROPERTY_RECURRENCE_ID,
  CreateScheduleItemRequest.JSON_PROPERTY_RECURRENCE_EXCEPTION,
  CreateScheduleItemRequest.JSON_PROPERTY_BOOKING_IDENTIFIER,
  CreateScheduleItemRequest.JSON_PROPERTY_TYPE,
  CreateScheduleItemRequest.JSON_PROPERTY_ATTENDEES
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-05-31T13:46:32.173577+07:00[Asia/Bangkok]")
public class CreateScheduleItemRequest {
  public static final String JSON_PROPERTY_START = "start";
  private OffsetDateTime start;

  public static final String JSON_PROPERTY_END = "end";
  private OffsetDateTime end;

  public static final String JSON_PROPERTY_START_TIMEZONE = "startTimezone";
  private String startTimezone;

  public static final String JSON_PROPERTY_END_TIMEZONE = "endTimezone";
  private String endTimezone;

  public static final String JSON_PROPERTY_IS_ALL_DAY = "isAllDay";
  private Boolean isAllDay = false;

  public static final String JSON_PROPERTY_RECURRENCE_RULE = "recurrenceRule";
  private String recurrenceRule;

  public static final String JSON_PROPERTY_RECURRENCE_ID = "recurrenceId";
  private String recurrenceId;

  public static final String JSON_PROPERTY_RECURRENCE_EXCEPTION = "recurrenceException";
  private List<OffsetDateTime> recurrenceException = null;

  public static final String JSON_PROPERTY_BOOKING_IDENTIFIER = "bookingIdentifier";
  private String bookingIdentifier;

  /**
   * The type of travel inventory.
   */
  public enum TypeEnum {
    MEETING_ROOM("MEETING_ROOM"),
    
    SPA("SPA"),
    
    RESTAURANT("RESTAURANT"),
    
    ACTIVITY("ACTIVITY"),
    
    ATTRACTION("ATTRACTION"),
    
    PLACE("PLACE");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public static final String JSON_PROPERTY_ATTENDEES = "attendees";
  private Integer attendees = 1;

  public CreateScheduleItemRequest() { 
  }

  public CreateScheduleItemRequest start(OffsetDateTime start) {
    
    this.start = start;
    return this;
  }

   /**
   * Start date time of scheduled event
   * @return start
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "Start date time of scheduled event")
  @JsonProperty(JSON_PROPERTY_START)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public OffsetDateTime getStart() {
    return start;
  }


  @JsonProperty(JSON_PROPERTY_START)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setStart(OffsetDateTime start) {
    this.start = start;
  }


  public CreateScheduleItemRequest end(OffsetDateTime end) {
    
    this.end = end;
    return this;
  }

   /**
   * End date time of scheduled event
   * @return end
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "End date time of scheduled event")
  @JsonProperty(JSON_PROPERTY_END)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public OffsetDateTime getEnd() {
    return end;
  }


  @JsonProperty(JSON_PROPERTY_END)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setEnd(OffsetDateTime end) {
    this.end = end;
  }


  public CreateScheduleItemRequest startTimezone(String startTimezone) {
    
    this.startTimezone = startTimezone;
    return this;
  }

   /**
   * Unique schedule identifier
   * @return startTimezone
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "schedule-1", required = true, value = "Unique schedule identifier")
  @JsonProperty(JSON_PROPERTY_START_TIMEZONE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getStartTimezone() {
    return startTimezone;
  }


  @JsonProperty(JSON_PROPERTY_START_TIMEZONE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setStartTimezone(String startTimezone) {
    this.startTimezone = startTimezone;
  }


  public CreateScheduleItemRequest endTimezone(String endTimezone) {
    
    this.endTimezone = endTimezone;
    return this;
  }

   /**
   * Unique schedule identifier
   * @return endTimezone
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "schedule-1", required = true, value = "Unique schedule identifier")
  @JsonProperty(JSON_PROPERTY_END_TIMEZONE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getEndTimezone() {
    return endTimezone;
  }


  @JsonProperty(JSON_PROPERTY_END_TIMEZONE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setEndTimezone(String endTimezone) {
    this.endTimezone = endTimezone;
  }


  public CreateScheduleItemRequest isAllDay(Boolean isAllDay) {
    
    this.isAllDay = isAllDay;
    return this;
  }

   /**
   * Flag indicating whether this is an all day event.
   * @return isAllDay
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "true", required = true, value = "Flag indicating whether this is an all day event.")
  @JsonProperty(JSON_PROPERTY_IS_ALL_DAY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getIsAllDay() {
    return isAllDay;
  }


  @JsonProperty(JSON_PROPERTY_IS_ALL_DAY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIsAllDay(Boolean isAllDay) {
    this.isAllDay = isAllDay;
  }


  public CreateScheduleItemRequest recurrenceRule(String recurrenceRule) {
    
    this.recurrenceRule = recurrenceRule;
    return this;
  }

   /**
   * If rule is present, indicates that scheduled event is a recurring event. For more details go to the [iCalendar website](https://icalendar.org/)
   * @return recurrenceRule
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "FREQ=DAILY;COUNT=5;", value = "If rule is present, indicates that scheduled event is a recurring event. For more details go to the [iCalendar website](https://icalendar.org/)")
  @JsonProperty(JSON_PROPERTY_RECURRENCE_RULE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRecurrenceRule() {
    return recurrenceRule;
  }


  @JsonProperty(JSON_PROPERTY_RECURRENCE_RULE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRecurrenceRule(String recurrenceRule) {
    this.recurrenceRule = recurrenceRule;
  }


  public CreateScheduleItemRequest recurrenceId(String recurrenceId) {
    
    this.recurrenceId = recurrenceId;
    return this;
  }

   /**
   * The parent ID of the recurring event.
   * @return recurrenceId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "schedule-parent-1", value = "The parent ID of the recurring event.")
  @JsonProperty(JSON_PROPERTY_RECURRENCE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRecurrenceId() {
    return recurrenceId;
  }


  @JsonProperty(JSON_PROPERTY_RECURRENCE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRecurrenceId(String recurrenceId) {
    this.recurrenceId = recurrenceId;
  }


  public CreateScheduleItemRequest recurrenceException(List<OffsetDateTime> recurrenceException) {
    
    this.recurrenceException = recurrenceException;
    return this;
  }

  public CreateScheduleItemRequest addRecurrenceExceptionItem(OffsetDateTime recurrenceExceptionItem) {
    if (this.recurrenceException == null) {
      this.recurrenceException = new ArrayList<>();
    }
    this.recurrenceException.add(recurrenceExceptionItem);
    return this;
  }

   /**
   * Exceptions to the recurrence rule.
   * @return recurrenceException
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(example = "[\"2017-12-22T03:07:58.742+0000\"]", value = "Exceptions to the recurrence rule.")
  @JsonProperty(JSON_PROPERTY_RECURRENCE_EXCEPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<OffsetDateTime> getRecurrenceException() {
    return recurrenceException;
  }


  @JsonProperty(JSON_PROPERTY_RECURRENCE_EXCEPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRecurrenceException(List<OffsetDateTime> recurrenceException) {
    this.recurrenceException = recurrenceException;
  }


  public CreateScheduleItemRequest bookingIdentifier(String bookingIdentifier) {
    
    this.bookingIdentifier = bookingIdentifier;
    return this;
  }

   /**
   * Booking identifier this scheduled event was created as part of.
   * @return bookingIdentifier
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "booking-1", required = true, value = "Booking identifier this scheduled event was created as part of.")
  @JsonProperty(JSON_PROPERTY_BOOKING_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getBookingIdentifier() {
    return bookingIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_BOOKING_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setBookingIdentifier(String bookingIdentifier) {
    this.bookingIdentifier = bookingIdentifier;
  }


  public CreateScheduleItemRequest type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * The type of travel inventory.
   * @return type
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "MEETING_ROOM", required = true, value = "The type of travel inventory.")
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  public CreateScheduleItemRequest attendees(Integer attendees) {
    
    this.attendees = attendees;
    return this;
  }

   /**
   * Number of guests attending this event.
   * minimum: 1
   * @return attendees
  **/
  @javax.annotation.Nonnull
  @NotNull
 @Min(1)  @ApiModelProperty(example = "2", required = true, value = "Number of guests attending this event.")
  @JsonProperty(JSON_PROPERTY_ATTENDEES)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getAttendees() {
    return attendees;
  }


  @JsonProperty(JSON_PROPERTY_ATTENDEES)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAttendees(Integer attendees) {
    this.attendees = attendees;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CreateScheduleItemRequest createScheduleItemRequest = (CreateScheduleItemRequest) o;
    return Objects.equals(this.start, createScheduleItemRequest.start) &&
        Objects.equals(this.end, createScheduleItemRequest.end) &&
        Objects.equals(this.startTimezone, createScheduleItemRequest.startTimezone) &&
        Objects.equals(this.endTimezone, createScheduleItemRequest.endTimezone) &&
        Objects.equals(this.isAllDay, createScheduleItemRequest.isAllDay) &&
        Objects.equals(this.recurrenceRule, createScheduleItemRequest.recurrenceRule) &&
        Objects.equals(this.recurrenceId, createScheduleItemRequest.recurrenceId) &&
        Objects.equals(this.recurrenceException, createScheduleItemRequest.recurrenceException) &&
        Objects.equals(this.bookingIdentifier, createScheduleItemRequest.bookingIdentifier) &&
        Objects.equals(this.type, createScheduleItemRequest.type) &&
        Objects.equals(this.attendees, createScheduleItemRequest.attendees);
  }

  @Override
  public int hashCode() {
    return Objects.hash(start, end, startTimezone, endTimezone, isAllDay, recurrenceRule, recurrenceId, recurrenceException, bookingIdentifier, type, attendees);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CreateScheduleItemRequest {\n");
    sb.append("    start: ").append(toIndentedString(start)).append("\n");
    sb.append("    end: ").append(toIndentedString(end)).append("\n");
    sb.append("    startTimezone: ").append(toIndentedString(startTimezone)).append("\n");
    sb.append("    endTimezone: ").append(toIndentedString(endTimezone)).append("\n");
    sb.append("    isAllDay: ").append(toIndentedString(isAllDay)).append("\n");
    sb.append("    recurrenceRule: ").append(toIndentedString(recurrenceRule)).append("\n");
    sb.append("    recurrenceId: ").append(toIndentedString(recurrenceId)).append("\n");
    sb.append("    recurrenceException: ").append(toIndentedString(recurrenceException)).append("\n");
    sb.append("    bookingIdentifier: ").append(toIndentedString(bookingIdentifier)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    attendees: ").append(toIndentedString(attendees)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

