/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/docs?api=affiliate): All APIs related to selling travel inventory as an affiliate. - [Extranet](/docs?api=extranet): All APIs related to managing travel inventory and suppliers. - [Booking Engine](/docs?api=booking-engine): All APIs related to searching for travel inventory and creating bookings. - [Channel Manager](/docs?api=channel-manager): All APIs related to channel managers who want to integrate with our payment.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.payment-v`1`+json.  ## Release history - 2021-07-01: v1 - Initial release  # Extranet API Welcome to the Extranet API - A programmer-friendly way to manage your travel inventory on the wink payment. This API offers a superset of the features you can find at [https://extranet.wink.travel](https://extranet.wink.travel) and gives you all the tools you need to ready your properties and inventory for sale across 10000s of our unique sales channels. What differentiates us from existing Extranets is 1. we make it available for everyone to use and 2. the care we take in only working with properties that have quality, curated content and ways to upsell and cross sell customers with ancillary products and experiences. Content creators have the ability to make their inventory look great and be searchable in a wide variety of ways. You won't find properties with generic inventory, low resolution pictures and little ancillary content that can easily be found everywhere else on the internet.  # Integrations We have already integrated with the most well-known channel managers so you don't have to. Once your properties are set up, you can finish the setup by mapping your property to wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API. - Allotz - CloudBeds / MyAllocator - Comanche - d-edge - FastBooking - HotelLink - HoteliersGuru - Omnibees - RateGain - Rate Tiger - ResAvenue - Siteminder - Sabre SynXis - Travelclick - Yieldplanet  # Intended Audience Programmers are [most likely] a requirement to start integrating with wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible. - Hotel chains - Hotel brands - Travel tech companies - Destination sites - Integrators - Aggregators - Destination management companies - Travel agencies - OTAs  
 *
 * The version of the OpenAPI document: 19.0.14-SNAPSHOT
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.extranet.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import travel.wink.sdk.extranet.model.AddOnOffer;
import travel.wink.sdk.extranet.model.CancellationPolicy;
import travel.wink.sdk.extranet.model.DescriptiveStayRate;
import travel.wink.sdk.extranet.model.ExtraCharges;
import travel.wink.sdk.extranet.model.Moneys;
import travel.wink.sdk.extranet.model.PackageOffer;
import travel.wink.sdk.extranet.model.RatePlan;
import travel.wink.sdk.extranet.model.RoomConfiguration;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * DescriptiveRoomConfigurationPrice
 */
@JsonPropertyOrder({
  DescriptiveRoomConfigurationPrice.JSON_PROPERTY_ADULTS,
  DescriptiveRoomConfigurationPrice.JSON_PROPERTY_CHILDREN,
  DescriptiveRoomConfigurationPrice.JSON_PROPERTY_START_DATE,
  DescriptiveRoomConfigurationPrice.JSON_PROPERTY_END_DATE,
  DescriptiveRoomConfigurationPrice.JSON_PROPERTY_ROOM_RATE_IDENTIFIER,
  DescriptiveRoomConfigurationPrice.JSON_PROPERTY_ROOM_RATE_INTERNAL_NAME,
  DescriptiveRoomConfigurationPrice.JSON_PROPERTY_RATE_PLAN,
  DescriptiveRoomConfigurationPrice.JSON_PROPERTY_PERK_TYPES,
  DescriptiveRoomConfigurationPrice.JSON_PROPERTY_PRICE,
  DescriptiveRoomConfigurationPrice.JSON_PROPERTY_EXTRA_CHARGES,
  DescriptiveRoomConfigurationPrice.JSON_PROPERTY_CONFIGURATION,
  DescriptiveRoomConfigurationPrice.JSON_PROPERTY_PACKAGE_OFFERS,
  DescriptiveRoomConfigurationPrice.JSON_PROPERTY_ADD_ON_OFFERS,
  DescriptiveRoomConfigurationPrice.JSON_PROPERTY_PERK_VALUE,
  DescriptiveRoomConfigurationPrice.JSON_PROPERTY_ACTIVE_CANCELLATION_POLICY,
  DescriptiveRoomConfigurationPrice.JSON_PROPERTY_ROOM_NIGHTS,
  DescriptiveRoomConfigurationPrice.JSON_PROPERTY_COMMISSIONNABLE,
  DescriptiveRoomConfigurationPrice.JSON_PROPERTY_COMMISSION,
  DescriptiveRoomConfigurationPrice.JSON_PROPERTY_PROMOTION,
  DescriptiveRoomConfigurationPrice.JSON_PROPERTY_AVAILABLE,
  DescriptiveRoomConfigurationPrice.JSON_PROPERTY_RATE_SOURCE,
  DescriptiveRoomConfigurationPrice.JSON_PROPERTY_USER_SPECIFIED_CURRENCY_TOTAL,
  DescriptiveRoomConfigurationPrice.JSON_PROPERTY_SOURCE_TOTAL,
  DescriptiveRoomConfigurationPrice.JSON_PROPERTY_INTERNAL_TOTAL
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-05-31T13:46:32.173577+07:00[Asia/Bangkok]")
public class DescriptiveRoomConfigurationPrice {
  public static final String JSON_PROPERTY_ADULTS = "adults";
  private Integer adults;

  public static final String JSON_PROPERTY_CHILDREN = "children";
  private Integer children;

  public static final String JSON_PROPERTY_START_DATE = "startDate";
  private LocalDate startDate;

  public static final String JSON_PROPERTY_END_DATE = "endDate";
  private LocalDate endDate;

  public static final String JSON_PROPERTY_ROOM_RATE_IDENTIFIER = "roomRateIdentifier";
  private String roomRateIdentifier;

  public static final String JSON_PROPERTY_ROOM_RATE_INTERNAL_NAME = "roomRateInternalName";
  private String roomRateInternalName;

  public static final String JSON_PROPERTY_RATE_PLAN = "ratePlan";
  private RatePlan ratePlan;

  /**
   * Gets or Sets perkTypes
   */
  public enum PerkTypesEnum {
    LOYALTY_POINTS("PERK_LOYALTY_POINTS"),
    
    WINE("PERK_WINE"),
    
    FREE_DRINK_VOUCHER("PERK_FREE_DRINK_VOUCHER"),
    
    FREE_MEAL_TWO_PEOPLE("PERK_FREE_MEAL_TWO_PEOPLE"),
    
    FREE_ONE_HOUR_MASSAGE("PERK_FREE_ONE_HOUR_MASSAGE"),
    
    TWENTY_PERCENT_FOOD_BEVERAGE_DISCOUNT("PERK_TWENTY_PERCENT_FOOD_BEVERAGE_DISCOUNT"),
    
    TWENTY_PERCENT_SPA_DISCOUNT_VOUCHER("PERK_TWENTY_PERCENT_SPA_DISCOUNT_VOUCHER"),
    
    GUARANTEED_UPGRADE("PERK_GUARANTEED_UPGRADE"),
    
    EARLY_CHECKIN("PERK_EARLY_CHECKIN"),
    
    ROOM_UPGRADE("PERK_ROOM_UPGRADE"),
    
    LATE_CHECKOUT("PERK_LATE_CHECKOUT"),
    
    AIRPORT_TRANSFER("PERK_AIRPORT_TRANSFER"),
    
    AIRPORT_PICK_UP("PERK_AIRPORT_PICK_UP"),
    
    BOTTLE_CHAMPAGNE_ON_ARRIVAL("PERK_BOTTLE_CHAMPAGNE_ON_ARRIVAL"),
    
    BOTTLE_SPARKLING_WINE_ON_ARRIVAL("PERK_BOTTLE_SPARKLING_WINE_ON_ARRIVAL"),
    
    BOTTLE_WINE_ON_ARRIVAL("PERK_BOTTLE_WINE_ON_ARRIVAL");

    private String value;

    PerkTypesEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PerkTypesEnum fromValue(String value) {
      for (PerkTypesEnum b : PerkTypesEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PERK_TYPES = "perkTypes";
  private List<PerkTypesEnum> perkTypes = null;

  public static final String JSON_PROPERTY_PRICE = "price";
  private DescriptiveStayRate price;

  public static final String JSON_PROPERTY_EXTRA_CHARGES = "extraCharges";
  private ExtraCharges extraCharges;

  public static final String JSON_PROPERTY_CONFIGURATION = "configuration";
  private RoomConfiguration _configuration;

  public static final String JSON_PROPERTY_PACKAGE_OFFERS = "packageOffers";
  private List<PackageOffer> packageOffers = null;

  public static final String JSON_PROPERTY_ADD_ON_OFFERS = "addOnOffers";
  private List<AddOnOffer> addOnOffers = null;

  public static final String JSON_PROPERTY_PERK_VALUE = "perkValue";
  private Integer perkValue;

  public static final String JSON_PROPERTY_ACTIVE_CANCELLATION_POLICY = "activeCancellationPolicy";
  private CancellationPolicy activeCancellationPolicy;

  public static final String JSON_PROPERTY_ROOM_NIGHTS = "roomNights";
  private Long roomNights;

  public static final String JSON_PROPERTY_COMMISSIONNABLE = "commissionnable";
  private Boolean commissionnable;

  public static final String JSON_PROPERTY_COMMISSION = "commission";
  private Float commission;

  public static final String JSON_PROPERTY_PROMOTION = "promotion";
  private List<String> promotion = null;

  public static final String JSON_PROPERTY_AVAILABLE = "available";
  private Boolean available;

  /**
   * Gets or Sets rateSource
   */
  public enum RateSourceEnum {
    TRAVELIKO("TRAVELIKO"),
    
    SITEMINDER("SITEMINDER"),
    
    FASTBOOKING("FASTBOOKING"),
    
    RATEGAIN("RATEGAIN"),
    
    CLOUD_BEDS("CLOUD_BEDS"),
    
    YIELD_PLANET("YIELD_PLANET"),
    
    TRAVELCLICK("TRAVELCLICK"),
    
    HOTEL_GURU("HOTEL_GURU"),
    
    OTHER_CHANNEL_MANAGER("OTHER_CHANNEL_MANAGER"),
    
    BOOKING_JINI("BOOKING_JINI"),
    
    HOTEL_LINK_SOLUTIONS("HOTEL_LINK_SOLUTIONS"),
    
    ALLOTZ("ALLOTZ"),
    
    DEDGE("DEDGE"),
    
    RATE_TIGER("RATE_TIGER"),
    
    RESAVENUE("RESAVENUE"),
    
    COMANCHE("COMANCHE"),
    
    OMNIBEES("OMNIBEES"),
    
    EZEE("EZEE"),
    
    SYNXIS("SYNXIS");

    private String value;

    RateSourceEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static RateSourceEnum fromValue(String value) {
      for (RateSourceEnum b : RateSourceEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_RATE_SOURCE = "rateSource";
  private RateSourceEnum rateSource;

  public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_TOTAL = "userSpecifiedCurrencyTotal";
  private Moneys userSpecifiedCurrencyTotal;

  public static final String JSON_PROPERTY_SOURCE_TOTAL = "sourceTotal";
  private Moneys sourceTotal;

  public static final String JSON_PROPERTY_INTERNAL_TOTAL = "internalTotal";
  private Moneys internalTotal;

  public DescriptiveRoomConfigurationPrice() { 
  }

  public DescriptiveRoomConfigurationPrice adults(Integer adults) {
    
    this.adults = adults;
    return this;
  }

   /**
   * Get adults
   * @return adults
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ADULTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getAdults() {
    return adults;
  }


  @JsonProperty(JSON_PROPERTY_ADULTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAdults(Integer adults) {
    this.adults = adults;
  }


  public DescriptiveRoomConfigurationPrice children(Integer children) {
    
    this.children = children;
    return this;
  }

   /**
   * Get children
   * @return children
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CHILDREN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getChildren() {
    return children;
  }


  @JsonProperty(JSON_PROPERTY_CHILDREN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setChildren(Integer children) {
    this.children = children;
  }


  public DescriptiveRoomConfigurationPrice startDate(LocalDate startDate) {
    
    this.startDate = startDate;
    return this;
  }

   /**
   * Get startDate
   * @return startDate
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalDate getStartDate() {
    return startDate;
  }


  @JsonProperty(JSON_PROPERTY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStartDate(LocalDate startDate) {
    this.startDate = startDate;
  }


  public DescriptiveRoomConfigurationPrice endDate(LocalDate endDate) {
    
    this.endDate = endDate;
    return this;
  }

   /**
   * Get endDate
   * @return endDate
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalDate getEndDate() {
    return endDate;
  }


  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEndDate(LocalDate endDate) {
    this.endDate = endDate;
  }


  public DescriptiveRoomConfigurationPrice roomRateIdentifier(String roomRateIdentifier) {
    
    this.roomRateIdentifier = roomRateIdentifier;
    return this;
  }

   /**
   * Get roomRateIdentifier
   * @return roomRateIdentifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ROOM_RATE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRoomRateIdentifier() {
    return roomRateIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_RATE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRoomRateIdentifier(String roomRateIdentifier) {
    this.roomRateIdentifier = roomRateIdentifier;
  }


  public DescriptiveRoomConfigurationPrice roomRateInternalName(String roomRateInternalName) {
    
    this.roomRateInternalName = roomRateInternalName;
    return this;
  }

   /**
   * Get roomRateInternalName
   * @return roomRateInternalName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ROOM_RATE_INTERNAL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRoomRateInternalName() {
    return roomRateInternalName;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_RATE_INTERNAL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRoomRateInternalName(String roomRateInternalName) {
    this.roomRateInternalName = roomRateInternalName;
  }


  public DescriptiveRoomConfigurationPrice ratePlan(RatePlan ratePlan) {
    
    this.ratePlan = ratePlan;
    return this;
  }

   /**
   * Get ratePlan
   * @return ratePlan
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_RATE_PLAN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public RatePlan getRatePlan() {
    return ratePlan;
  }


  @JsonProperty(JSON_PROPERTY_RATE_PLAN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRatePlan(RatePlan ratePlan) {
    this.ratePlan = ratePlan;
  }


  public DescriptiveRoomConfigurationPrice perkTypes(List<PerkTypesEnum> perkTypes) {
    
    this.perkTypes = perkTypes;
    return this;
  }

  public DescriptiveRoomConfigurationPrice addPerkTypesItem(PerkTypesEnum perkTypesItem) {
    if (this.perkTypes == null) {
      this.perkTypes = new ArrayList<>();
    }
    this.perkTypes.add(perkTypesItem);
    return this;
  }

   /**
   * Get perkTypes
   * @return perkTypes
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PERK_TYPES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<PerkTypesEnum> getPerkTypes() {
    return perkTypes;
  }


  @JsonProperty(JSON_PROPERTY_PERK_TYPES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPerkTypes(List<PerkTypesEnum> perkTypes) {
    this.perkTypes = perkTypes;
  }


  public DescriptiveRoomConfigurationPrice price(DescriptiveStayRate price) {
    
    this.price = price;
    return this;
  }

   /**
   * Get price
   * @return price
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public DescriptiveStayRate getPrice() {
    return price;
  }


  @JsonProperty(JSON_PROPERTY_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPrice(DescriptiveStayRate price) {
    this.price = price;
  }


  public DescriptiveRoomConfigurationPrice extraCharges(ExtraCharges extraCharges) {
    
    this.extraCharges = extraCharges;
    return this;
  }

   /**
   * Get extraCharges
   * @return extraCharges
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_EXTRA_CHARGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ExtraCharges getExtraCharges() {
    return extraCharges;
  }


  @JsonProperty(JSON_PROPERTY_EXTRA_CHARGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExtraCharges(ExtraCharges extraCharges) {
    this.extraCharges = extraCharges;
  }


  public DescriptiveRoomConfigurationPrice _configuration(RoomConfiguration _configuration) {
    
    this._configuration = _configuration;
    return this;
  }

   /**
   * Get _configuration
   * @return _configuration
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CONFIGURATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public RoomConfiguration getConfiguration() {
    return _configuration;
  }


  @JsonProperty(JSON_PROPERTY_CONFIGURATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setConfiguration(RoomConfiguration _configuration) {
    this._configuration = _configuration;
  }


  public DescriptiveRoomConfigurationPrice packageOffers(List<PackageOffer> packageOffers) {
    
    this.packageOffers = packageOffers;
    return this;
  }

  public DescriptiveRoomConfigurationPrice addPackageOffersItem(PackageOffer packageOffersItem) {
    if (this.packageOffers == null) {
      this.packageOffers = new ArrayList<>();
    }
    this.packageOffers.add(packageOffersItem);
    return this;
  }

   /**
   * Get packageOffers
   * @return packageOffers
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PACKAGE_OFFERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<PackageOffer> getPackageOffers() {
    return packageOffers;
  }


  @JsonProperty(JSON_PROPERTY_PACKAGE_OFFERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPackageOffers(List<PackageOffer> packageOffers) {
    this.packageOffers = packageOffers;
  }


  public DescriptiveRoomConfigurationPrice addOnOffers(List<AddOnOffer> addOnOffers) {
    
    this.addOnOffers = addOnOffers;
    return this;
  }

  public DescriptiveRoomConfigurationPrice addAddOnOffersItem(AddOnOffer addOnOffersItem) {
    if (this.addOnOffers == null) {
      this.addOnOffers = new ArrayList<>();
    }
    this.addOnOffers.add(addOnOffersItem);
    return this;
  }

   /**
   * Get addOnOffers
   * @return addOnOffers
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ADD_ON_OFFERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<AddOnOffer> getAddOnOffers() {
    return addOnOffers;
  }


  @JsonProperty(JSON_PROPERTY_ADD_ON_OFFERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAddOnOffers(List<AddOnOffer> addOnOffers) {
    this.addOnOffers = addOnOffers;
  }


  public DescriptiveRoomConfigurationPrice perkValue(Integer perkValue) {
    
    this.perkValue = perkValue;
    return this;
  }

   /**
   * Get perkValue
   * @return perkValue
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PERK_VALUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getPerkValue() {
    return perkValue;
  }


  @JsonProperty(JSON_PROPERTY_PERK_VALUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPerkValue(Integer perkValue) {
    this.perkValue = perkValue;
  }


  public DescriptiveRoomConfigurationPrice activeCancellationPolicy(CancellationPolicy activeCancellationPolicy) {
    
    this.activeCancellationPolicy = activeCancellationPolicy;
    return this;
  }

   /**
   * Get activeCancellationPolicy
   * @return activeCancellationPolicy
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ACTIVE_CANCELLATION_POLICY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CancellationPolicy getActiveCancellationPolicy() {
    return activeCancellationPolicy;
  }


  @JsonProperty(JSON_PROPERTY_ACTIVE_CANCELLATION_POLICY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setActiveCancellationPolicy(CancellationPolicy activeCancellationPolicy) {
    this.activeCancellationPolicy = activeCancellationPolicy;
  }


  public DescriptiveRoomConfigurationPrice roomNights(Long roomNights) {
    
    this.roomNights = roomNights;
    return this;
  }

   /**
   * Get roomNights
   * @return roomNights
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ROOM_NIGHTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getRoomNights() {
    return roomNights;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_NIGHTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRoomNights(Long roomNights) {
    this.roomNights = roomNights;
  }


  public DescriptiveRoomConfigurationPrice commissionnable(Boolean commissionnable) {
    
    this.commissionnable = commissionnable;
    return this;
  }

   /**
   * Get commissionnable
   * @return commissionnable
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_COMMISSIONNABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCommissionnable() {
    return commissionnable;
  }


  @JsonProperty(JSON_PROPERTY_COMMISSIONNABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCommissionnable(Boolean commissionnable) {
    this.commissionnable = commissionnable;
  }


  public DescriptiveRoomConfigurationPrice commission(Float commission) {
    
    this.commission = commission;
    return this;
  }

   /**
   * Get commission
   * @return commission
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_COMMISSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getCommission() {
    return commission;
  }


  @JsonProperty(JSON_PROPERTY_COMMISSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCommission(Float commission) {
    this.commission = commission;
  }


  public DescriptiveRoomConfigurationPrice promotion(List<String> promotion) {
    
    this.promotion = promotion;
    return this;
  }

  public DescriptiveRoomConfigurationPrice addPromotionItem(String promotionItem) {
    if (this.promotion == null) {
      this.promotion = new ArrayList<>();
    }
    this.promotion.add(promotionItem);
    return this;
  }

   /**
   * Get promotion
   * @return promotion
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PROMOTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getPromotion() {
    return promotion;
  }


  @JsonProperty(JSON_PROPERTY_PROMOTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPromotion(List<String> promotion) {
    this.promotion = promotion;
  }


  public DescriptiveRoomConfigurationPrice available(Boolean available) {
    
    this.available = available;
    return this;
  }

   /**
   * Get available
   * @return available
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_AVAILABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getAvailable() {
    return available;
  }


  @JsonProperty(JSON_PROPERTY_AVAILABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAvailable(Boolean available) {
    this.available = available;
  }


  public DescriptiveRoomConfigurationPrice rateSource(RateSourceEnum rateSource) {
    
    this.rateSource = rateSource;
    return this;
  }

   /**
   * Get rateSource
   * @return rateSource
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_RATE_SOURCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public RateSourceEnum getRateSource() {
    return rateSource;
  }


  @JsonProperty(JSON_PROPERTY_RATE_SOURCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRateSource(RateSourceEnum rateSource) {
    this.rateSource = rateSource;
  }


  public DescriptiveRoomConfigurationPrice userSpecifiedCurrencyTotal(Moneys userSpecifiedCurrencyTotal) {
    
    this.userSpecifiedCurrencyTotal = userSpecifiedCurrencyTotal;
    return this;
  }

   /**
   * Get userSpecifiedCurrencyTotal
   * @return userSpecifiedCurrencyTotal
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Moneys getUserSpecifiedCurrencyTotal() {
    return userSpecifiedCurrencyTotal;
  }


  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserSpecifiedCurrencyTotal(Moneys userSpecifiedCurrencyTotal) {
    this.userSpecifiedCurrencyTotal = userSpecifiedCurrencyTotal;
  }


  public DescriptiveRoomConfigurationPrice sourceTotal(Moneys sourceTotal) {
    
    this.sourceTotal = sourceTotal;
    return this;
  }

   /**
   * Get sourceTotal
   * @return sourceTotal
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SOURCE_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Moneys getSourceTotal() {
    return sourceTotal;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceTotal(Moneys sourceTotal) {
    this.sourceTotal = sourceTotal;
  }


  public DescriptiveRoomConfigurationPrice internalTotal(Moneys internalTotal) {
    
    this.internalTotal = internalTotal;
    return this;
  }

   /**
   * Get internalTotal
   * @return internalTotal
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_INTERNAL_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Moneys getInternalTotal() {
    return internalTotal;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalTotal(Moneys internalTotal) {
    this.internalTotal = internalTotal;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DescriptiveRoomConfigurationPrice descriptiveRoomConfigurationPrice = (DescriptiveRoomConfigurationPrice) o;
    return Objects.equals(this.adults, descriptiveRoomConfigurationPrice.adults) &&
        Objects.equals(this.children, descriptiveRoomConfigurationPrice.children) &&
        Objects.equals(this.startDate, descriptiveRoomConfigurationPrice.startDate) &&
        Objects.equals(this.endDate, descriptiveRoomConfigurationPrice.endDate) &&
        Objects.equals(this.roomRateIdentifier, descriptiveRoomConfigurationPrice.roomRateIdentifier) &&
        Objects.equals(this.roomRateInternalName, descriptiveRoomConfigurationPrice.roomRateInternalName) &&
        Objects.equals(this.ratePlan, descriptiveRoomConfigurationPrice.ratePlan) &&
        Objects.equals(this.perkTypes, descriptiveRoomConfigurationPrice.perkTypes) &&
        Objects.equals(this.price, descriptiveRoomConfigurationPrice.price) &&
        Objects.equals(this.extraCharges, descriptiveRoomConfigurationPrice.extraCharges) &&
        Objects.equals(this._configuration, descriptiveRoomConfigurationPrice._configuration) &&
        Objects.equals(this.packageOffers, descriptiveRoomConfigurationPrice.packageOffers) &&
        Objects.equals(this.addOnOffers, descriptiveRoomConfigurationPrice.addOnOffers) &&
        Objects.equals(this.perkValue, descriptiveRoomConfigurationPrice.perkValue) &&
        Objects.equals(this.activeCancellationPolicy, descriptiveRoomConfigurationPrice.activeCancellationPolicy) &&
        Objects.equals(this.roomNights, descriptiveRoomConfigurationPrice.roomNights) &&
        Objects.equals(this.commissionnable, descriptiveRoomConfigurationPrice.commissionnable) &&
        Objects.equals(this.commission, descriptiveRoomConfigurationPrice.commission) &&
        Objects.equals(this.promotion, descriptiveRoomConfigurationPrice.promotion) &&
        Objects.equals(this.available, descriptiveRoomConfigurationPrice.available) &&
        Objects.equals(this.rateSource, descriptiveRoomConfigurationPrice.rateSource) &&
        Objects.equals(this.userSpecifiedCurrencyTotal, descriptiveRoomConfigurationPrice.userSpecifiedCurrencyTotal) &&
        Objects.equals(this.sourceTotal, descriptiveRoomConfigurationPrice.sourceTotal) &&
        Objects.equals(this.internalTotal, descriptiveRoomConfigurationPrice.internalTotal);
  }

  @Override
  public int hashCode() {
    return Objects.hash(adults, children, startDate, endDate, roomRateIdentifier, roomRateInternalName, ratePlan, perkTypes, price, extraCharges, _configuration, packageOffers, addOnOffers, perkValue, activeCancellationPolicy, roomNights, commissionnable, commission, promotion, available, rateSource, userSpecifiedCurrencyTotal, sourceTotal, internalTotal);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DescriptiveRoomConfigurationPrice {\n");
    sb.append("    adults: ").append(toIndentedString(adults)).append("\n");
    sb.append("    children: ").append(toIndentedString(children)).append("\n");
    sb.append("    startDate: ").append(toIndentedString(startDate)).append("\n");
    sb.append("    endDate: ").append(toIndentedString(endDate)).append("\n");
    sb.append("    roomRateIdentifier: ").append(toIndentedString(roomRateIdentifier)).append("\n");
    sb.append("    roomRateInternalName: ").append(toIndentedString(roomRateInternalName)).append("\n");
    sb.append("    ratePlan: ").append(toIndentedString(ratePlan)).append("\n");
    sb.append("    perkTypes: ").append(toIndentedString(perkTypes)).append("\n");
    sb.append("    price: ").append(toIndentedString(price)).append("\n");
    sb.append("    extraCharges: ").append(toIndentedString(extraCharges)).append("\n");
    sb.append("    _configuration: ").append(toIndentedString(_configuration)).append("\n");
    sb.append("    packageOffers: ").append(toIndentedString(packageOffers)).append("\n");
    sb.append("    addOnOffers: ").append(toIndentedString(addOnOffers)).append("\n");
    sb.append("    perkValue: ").append(toIndentedString(perkValue)).append("\n");
    sb.append("    activeCancellationPolicy: ").append(toIndentedString(activeCancellationPolicy)).append("\n");
    sb.append("    roomNights: ").append(toIndentedString(roomNights)).append("\n");
    sb.append("    commissionnable: ").append(toIndentedString(commissionnable)).append("\n");
    sb.append("    commission: ").append(toIndentedString(commission)).append("\n");
    sb.append("    promotion: ").append(toIndentedString(promotion)).append("\n");
    sb.append("    available: ").append(toIndentedString(available)).append("\n");
    sb.append("    rateSource: ").append(toIndentedString(rateSource)).append("\n");
    sb.append("    userSpecifiedCurrencyTotal: ").append(toIndentedString(userSpecifiedCurrencyTotal)).append("\n");
    sb.append("    sourceTotal: ").append(toIndentedString(sourceTotal)).append("\n");
    sb.append("    internalTotal: ").append(toIndentedString(internalTotal)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

