/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.api;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.extranet.invoker.ApiClient;
import travel.wink.sdk.extranet.model.InvoiceCollection;

public class InvoiceApi {
    private ApiClient apiClient;

    public InvoiceApi() {
        this(new ApiClient());
    }

    @Autowired
    public InvoiceApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec showInvoicesForCustomerRequestCreation(String hotelIdentifier, String customerIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showInvoicesForCustomer", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (customerIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'customerIdentifier' when calling showInvoicesForCustomer", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("customerIdentifier", customerIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<InvoiceCollection> localVarReturnType = new ParameterizedTypeReference<InvoiceCollection>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/marketplace/customer/{customerIdentifier}/invoice/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<InvoiceCollection> showInvoicesForCustomer(String hotelIdentifier, String customerIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<InvoiceCollection> localVarReturnType = new ParameterizedTypeReference<InvoiceCollection>(){};
        return this.showInvoicesForCustomerRequestCreation(hotelIdentifier, customerIdentifier, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<InvoiceCollection>> showInvoicesForCustomerWithHttpInfo(String hotelIdentifier, String customerIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<InvoiceCollection> localVarReturnType = new ParameterizedTypeReference<InvoiceCollection>(){};
        return this.showInvoicesForCustomerRequestCreation(hotelIdentifier, customerIdentifier, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showInvoicesForHotelRequestCreation(String hotelIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showInvoicesForHotel", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<InvoiceCollection> localVarReturnType = new ParameterizedTypeReference<InvoiceCollection>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/marketplace/subscription/invoice/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<InvoiceCollection> showInvoicesForHotel(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<InvoiceCollection> localVarReturnType = new ParameterizedTypeReference<InvoiceCollection>(){};
        return this.showInvoicesForHotelRequestCreation(hotelIdentifier, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<InvoiceCollection>>> showInvoicesForHotelWithHttpInfo(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<InvoiceCollection> localVarReturnType = new ParameterizedTypeReference<InvoiceCollection>(){};
        return this.showInvoicesForHotelRequestCreation(hotelIdentifier, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showInvoicesForHotelCustomerRequestCreation(String hotelIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showInvoicesForHotelCustomer", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<InvoiceCollection> localVarReturnType = new ParameterizedTypeReference<InvoiceCollection>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/marketplace/customer/invoice/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<InvoiceCollection> showInvoicesForHotelCustomer(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<InvoiceCollection> localVarReturnType = new ParameterizedTypeReference<InvoiceCollection>(){};
        return this.showInvoicesForHotelCustomerRequestCreation(hotelIdentifier, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<InvoiceCollection>> showInvoicesForHotelCustomerWithHttpInfo(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<InvoiceCollection> localVarReturnType = new ParameterizedTypeReference<InvoiceCollection>(){};
        return this.showInvoicesForHotelCustomerRequestCreation(hotelIdentifier, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showInvoicesForSubscriptionRequestCreation(String hotelIdentifier, String subscriptionIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showInvoicesForSubscription", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (subscriptionIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'subscriptionIdentifier' when calling showInvoicesForSubscription", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("subscriptionIdentifier", subscriptionIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<InvoiceCollection> localVarReturnType = new ParameterizedTypeReference<InvoiceCollection>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/marketplace/subscription/{subscriptionIdentifier}/invoice/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<InvoiceCollection> showInvoicesForSubscription(String hotelIdentifier, String subscriptionIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<InvoiceCollection> localVarReturnType = new ParameterizedTypeReference<InvoiceCollection>(){};
        return this.showInvoicesForSubscriptionRequestCreation(hotelIdentifier, subscriptionIdentifier, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<InvoiceCollection>> showInvoicesForSubscriptionWithHttpInfo(String hotelIdentifier, String subscriptionIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<InvoiceCollection> localVarReturnType = new ParameterizedTypeReference<InvoiceCollection>(){};
        return this.showInvoicesForSubscriptionRequestCreation(hotelIdentifier, subscriptionIdentifier, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }
}

