/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.validation.constraints.NotNull;

@JsonPropertyOrder(value={"currencyCode", "ownerIdentifier"})
public class LeaderboardOwnerRequest {
    public static final String JSON_PROPERTY_CURRENCY_CODE = "currencyCode";
    private String currencyCode = "USD";
    public static final String JSON_PROPERTY_OWNER_IDENTIFIER = "ownerIdentifier";
    private String ownerIdentifier;

    public LeaderboardOwnerRequest currencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="USD", required=true, value="Display leaderboard values in this currency")
    @JsonProperty(value="currencyCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getCurrencyCode() {
        return this.currencyCode;
    }

    @JsonProperty(value="currencyCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public LeaderboardOwnerRequest ownerIdentifier(String ownerIdentifier) {
        this.ownerIdentifier = ownerIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="company-1", required=true, value="The company you wish to track on a leaderboard")
    @JsonProperty(value="ownerIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getOwnerIdentifier() {
        return this.ownerIdentifier;
    }

    @JsonProperty(value="ownerIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setOwnerIdentifier(String ownerIdentifier) {
        this.ownerIdentifier = ownerIdentifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LeaderboardOwnerRequest leaderboardOwnerRequest = (LeaderboardOwnerRequest)o;
        return Objects.equals(this.currencyCode, leaderboardOwnerRequest.currencyCode) && Objects.equals(this.ownerIdentifier, leaderboardOwnerRequest.ownerIdentifier);
    }

    public int hashCode() {
        return Objects.hash(this.currencyCode, this.ownerIdentifier);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LeaderboardOwnerRequest {\n");
        sb.append("    currencyCode: ").append(this.toIndentedString(this.currencyCode)).append("\n");
        sb.append("    ownerIdentifier: ").append(this.toIndentedString(this.ownerIdentifier)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

