package travel.wink.sdk.extranet.api;

import travel.wink.sdk.extranet.invoker.ApiClient;

import travel.wink.sdk.extranet.model.CancellationPolicy;
import travel.wink.sdk.extranet.model.CancellationPolicyRemovableResponse;
import travel.wink.sdk.extranet.model.CancellationPolicyView;
import travel.wink.sdk.extranet.model.GenericErrorMessage;
import travel.wink.sdk.extranet.model.RemoveEntryResponse;
import travel.wink.sdk.extranet.model.ShowHotelStatus400Response;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-06-05T13:54:29.398954+07:00[Asia/Bangkok]")
public class CancellationPolicyApi {
    private ApiClient apiClient;

    public CancellationPolicyApi() {
        this(new ApiClient());
    }

    @Autowired
    public CancellationPolicyApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Verify Removable
     * Check if a cancellation policy is removable. If a cancellation policy is associated / linked with a rate plan, it cannot be removed until the associated entity removes it first.
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>200</b> - OK
     * @param hotelIdentifier Verify if cancellation policy is removable and owned by this hotel identifier.
     * @param cancellationPolicyIdentifier Verify if cancellation policy is removable identified by this identifier.
     * @param accept The accept parameter
     * @return CancellationPolicyRemovableResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removableCancellationPolicyRequestCreation(String hotelIdentifier, String cancellationPolicyIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling removableCancellationPolicy", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'cancellationPolicyIdentifier' is set
        if (cancellationPolicyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'cancellationPolicyIdentifier' when calling removableCancellationPolicy", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("cancellationPolicyIdentifier", cancellationPolicyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<CancellationPolicyRemovableResponse> localVarReturnType = new ParameterizedTypeReference<CancellationPolicyRemovableResponse>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/cancellationpolicy/{cancellationPolicyIdentifier}/removable", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Verify Removable
     * Check if a cancellation policy is removable. If a cancellation policy is associated / linked with a rate plan, it cannot be removed until the associated entity removes it first.
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>200</b> - OK
     * @param hotelIdentifier Verify if cancellation policy is removable and owned by this hotel identifier.
     * @param cancellationPolicyIdentifier Verify if cancellation policy is removable identified by this identifier.
     * @param accept The accept parameter
     * @return CancellationPolicyRemovableResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<CancellationPolicyRemovableResponse> removableCancellationPolicy(String hotelIdentifier, String cancellationPolicyIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<CancellationPolicyRemovableResponse> localVarReturnType = new ParameterizedTypeReference<CancellationPolicyRemovableResponse>() {};
        return removableCancellationPolicyRequestCreation(hotelIdentifier, cancellationPolicyIdentifier, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<CancellationPolicyRemovableResponse>> removableCancellationPolicyWithHttpInfo(String hotelIdentifier, String cancellationPolicyIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<CancellationPolicyRemovableResponse> localVarReturnType = new ParameterizedTypeReference<CancellationPolicyRemovableResponse>() {};
        return removableCancellationPolicyRequestCreation(hotelIdentifier, cancellationPolicyIdentifier, accept).toEntity(localVarReturnType);
    }
    /**
     * Delete Cancellation Policy
     * Delete a cancellation policy by its identifier
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Delete cancellation policy owned by this hotel identifier.
     * @param cancellationPolicyIdentifier Delete cancellation policy with this identifier.
     * @param accept The accept parameter
     * @return RemoveEntryResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeCancellationPolicyRequestCreation(String hotelIdentifier, String cancellationPolicyIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling removeCancellationPolicy", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'cancellationPolicyIdentifier' is set
        if (cancellationPolicyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'cancellationPolicyIdentifier' when calling removeCancellationPolicy", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("cancellationPolicyIdentifier", cancellationPolicyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/cancellationpolicy/{cancellationPolicyIdentifier}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete Cancellation Policy
     * Delete a cancellation policy by its identifier
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Delete cancellation policy owned by this hotel identifier.
     * @param cancellationPolicyIdentifier Delete cancellation policy with this identifier.
     * @param accept The accept parameter
     * @return RemoveEntryResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RemoveEntryResponse> removeCancellationPolicy(String hotelIdentifier, String cancellationPolicyIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return removeCancellationPolicyRequestCreation(hotelIdentifier, cancellationPolicyIdentifier, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<RemoveEntryResponse>> removeCancellationPolicyWithHttpInfo(String hotelIdentifier, String cancellationPolicyIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return removeCancellationPolicyRequestCreation(hotelIdentifier, cancellationPolicyIdentifier, accept).toEntity(localVarReturnType);
    }
    /**
     * Create Cancellation Policy
     * Create a new cancellation policy
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>201</b> - Created
     * @param hotelIdentifier Create cancellation policy and associate it with by this hotel identifier.
     * @param cancellationPolicy The cancellationPolicy parameter
     * @return CancellationPolicyView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec saveCancellationPolicyRequestCreation(String hotelIdentifier, CancellationPolicy cancellationPolicy) throws WebClientResponseException {
        Object postBody = cancellationPolicy;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling saveCancellationPolicy", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'cancellationPolicy' is set
        if (cancellationPolicy == null) {
            throw new WebClientResponseException("Missing the required parameter 'cancellationPolicy' when calling saveCancellationPolicy", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<CancellationPolicyView> localVarReturnType = new ParameterizedTypeReference<CancellationPolicyView>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/cancellationpolicy", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create Cancellation Policy
     * Create a new cancellation policy
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>201</b> - Created
     * @param hotelIdentifier Create cancellation policy and associate it with by this hotel identifier.
     * @param cancellationPolicy The cancellationPolicy parameter
     * @return CancellationPolicyView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<CancellationPolicyView> saveCancellationPolicy(String hotelIdentifier, CancellationPolicy cancellationPolicy) throws WebClientResponseException {
        ParameterizedTypeReference<CancellationPolicyView> localVarReturnType = new ParameterizedTypeReference<CancellationPolicyView>() {};
        return saveCancellationPolicyRequestCreation(hotelIdentifier, cancellationPolicy).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<CancellationPolicyView>> saveCancellationPolicyWithHttpInfo(String hotelIdentifier, CancellationPolicy cancellationPolicy) throws WebClientResponseException {
        ParameterizedTypeReference<CancellationPolicyView> localVarReturnType = new ParameterizedTypeReference<CancellationPolicyView>() {};
        return saveCancellationPolicyRequestCreation(hotelIdentifier, cancellationPolicy).toEntity(localVarReturnType);
    }
    /**
     * Show Cancellation Policies
     * Retrieve list of cancellation policies for property
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>200</b> - OK
     * @param hotelIdentifier List all cancellation policies for this hotel identifier.
     * @param accept The accept parameter
     * @return List&lt;CancellationPolicyView&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showCancellationPoliciesRequestCreation(String hotelIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showCancellationPolicies", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<CancellationPolicyView> localVarReturnType = new ParameterizedTypeReference<CancellationPolicyView>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/cancellationpolicy/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Cancellation Policies
     * Retrieve list of cancellation policies for property
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>200</b> - OK
     * @param hotelIdentifier List all cancellation policies for this hotel identifier.
     * @param accept The accept parameter
     * @return List&lt;CancellationPolicyView&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<CancellationPolicyView> showCancellationPolicies(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<CancellationPolicyView> localVarReturnType = new ParameterizedTypeReference<CancellationPolicyView>() {};
        return showCancellationPoliciesRequestCreation(hotelIdentifier, accept).bodyToFlux(localVarReturnType);
    }

    public Mono<ResponseEntity<List<CancellationPolicyView>>> showCancellationPoliciesWithHttpInfo(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<CancellationPolicyView> localVarReturnType = new ParameterizedTypeReference<CancellationPolicyView>() {};
        return showCancellationPoliciesRequestCreation(hotelIdentifier, accept).toEntityList(localVarReturnType);
    }
    /**
     * Show Cancellation Policy
     * Retrieve a cancellation policy by its identifier.
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show single cancellation policy owned by this hotel identifier.
     * @param cancellationPolicyIdentifier Show single cancellation policy with this identifier.
     * @param accept The accept parameter
     * @return CancellationPolicyView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showCancellationPolicyRequestCreation(String hotelIdentifier, String cancellationPolicyIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showCancellationPolicy", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'cancellationPolicyIdentifier' is set
        if (cancellationPolicyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'cancellationPolicyIdentifier' when calling showCancellationPolicy", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("cancellationPolicyIdentifier", cancellationPolicyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<CancellationPolicyView> localVarReturnType = new ParameterizedTypeReference<CancellationPolicyView>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/cancellationpolicy/{cancellationPolicyIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Cancellation Policy
     * Retrieve a cancellation policy by its identifier.
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show single cancellation policy owned by this hotel identifier.
     * @param cancellationPolicyIdentifier Show single cancellation policy with this identifier.
     * @param accept The accept parameter
     * @return CancellationPolicyView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<CancellationPolicyView> showCancellationPolicy(String hotelIdentifier, String cancellationPolicyIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<CancellationPolicyView> localVarReturnType = new ParameterizedTypeReference<CancellationPolicyView>() {};
        return showCancellationPolicyRequestCreation(hotelIdentifier, cancellationPolicyIdentifier, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<CancellationPolicyView>> showCancellationPolicyWithHttpInfo(String hotelIdentifier, String cancellationPolicyIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<CancellationPolicyView> localVarReturnType = new ParameterizedTypeReference<CancellationPolicyView>() {};
        return showCancellationPolicyRequestCreation(hotelIdentifier, cancellationPolicyIdentifier, accept).toEntity(localVarReturnType);
    }
    /**
     * Update Cancellation Policy
     * Update a cancellation policy by its identifier
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update an existing cancellation policy owned by this hotel identifier.
     * @param cancellationPolicyIdentifier Update an existing cancellation policy with this identifier.
     * @param cancellationPolicy The cancellationPolicy parameter
     * @return CancellationPolicyView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateCancellationPolicyRequestCreation(String hotelIdentifier, String cancellationPolicyIdentifier, CancellationPolicy cancellationPolicy) throws WebClientResponseException {
        Object postBody = cancellationPolicy;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling updateCancellationPolicy", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'cancellationPolicyIdentifier' is set
        if (cancellationPolicyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'cancellationPolicyIdentifier' when calling updateCancellationPolicy", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'cancellationPolicy' is set
        if (cancellationPolicy == null) {
            throw new WebClientResponseException("Missing the required parameter 'cancellationPolicy' when calling updateCancellationPolicy", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("cancellationPolicyIdentifier", cancellationPolicyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<CancellationPolicyView> localVarReturnType = new ParameterizedTypeReference<CancellationPolicyView>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/cancellationpolicy/{cancellationPolicyIdentifier}", HttpMethod.PUT, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Cancellation Policy
     * Update a cancellation policy by its identifier
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update an existing cancellation policy owned by this hotel identifier.
     * @param cancellationPolicyIdentifier Update an existing cancellation policy with this identifier.
     * @param cancellationPolicy The cancellationPolicy parameter
     * @return CancellationPolicyView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<CancellationPolicyView> updateCancellationPolicy(String hotelIdentifier, String cancellationPolicyIdentifier, CancellationPolicy cancellationPolicy) throws WebClientResponseException {
        ParameterizedTypeReference<CancellationPolicyView> localVarReturnType = new ParameterizedTypeReference<CancellationPolicyView>() {};
        return updateCancellationPolicyRequestCreation(hotelIdentifier, cancellationPolicyIdentifier, cancellationPolicy).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<CancellationPolicyView>> updateCancellationPolicyWithHttpInfo(String hotelIdentifier, String cancellationPolicyIdentifier, CancellationPolicy cancellationPolicy) throws WebClientResponseException {
        ParameterizedTypeReference<CancellationPolicyView> localVarReturnType = new ParameterizedTypeReference<CancellationPolicyView>() {};
        return updateCancellationPolicyRequestCreation(hotelIdentifier, cancellationPolicyIdentifier, cancellationPolicy).toEntity(localVarReturnType);
    }
}
