/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/docs?api=affiliate): All APIs related to selling travel inventory as an affiliate. - [Extranet](/docs?api=extranet): All APIs related to managing travel inventory and suppliers. - [Booking Engine](/docs?api=booking-engine): All APIs related to searching for travel inventory and creating bookings. - [Channel Manager](/docs?api=channel-manager): All APIs related to channel managers who want to integrate with our payment.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.payment-v`1`+json.  ## Release history - 2021-07-01: v1 - Initial release  # Extranet API Welcome to the Extranet API - A programmer-friendly way to manage your travel inventory on the wink payment. This API offers a superset of the features you can find at [https://extranet.wink.travel](https://extranet.wink.travel) and gives you all the tools you need to ready your properties and inventory for sale across 10000s of our unique sales channels. What differentiates us from existing Extranets is 1. we make it available for everyone to use and 2. the care we take in only working with properties that have quality, curated content and ways to upsell and cross sell customers with ancillary products and experiences. Content creators have the ability to make their inventory look great and be searchable in a wide variety of ways. You won't find properties with generic inventory, low resolution pictures and little ancillary content that can easily be found everywhere else on the internet.  # Integrations We have already integrated with the most well-known channel managers so you don't have to. Once your properties are set up, you can finish the setup by mapping your property to wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API. - Allotz - CloudBeds / MyAllocator - Comanche - d-edge - FastBooking - HotelLink - HoteliersGuru - Omnibees - RateGain - Rate Tiger - ResAvenue - Siteminder - Sabre SynXis - Travelclick - Yieldplanet  # Intended Audience Programmers are [most likely] a requirement to start integrating with wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible. - Hotel chains - Hotel brands - Travel tech companies - Destination sites - Integrators - Aggregators - Destination management companies - Travel agencies - OTAs  
 *
 * The version of the OpenAPI document: 19.0.14-SNAPSHOT
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.extranet.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import travel.wink.sdk.extranet.model.IdentifierNamePair;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * RatePlanRemovableResponse
 */
@JsonPropertyOrder({
  RatePlanRemovableResponse.JSON_PROPERTY_HOTEL_IDENTIFIER,
  RatePlanRemovableResponse.JSON_PROPERTY_RATE_PLAN_IDENTIFIER,
  RatePlanRemovableResponse.JSON_PROPERTY_REMOVABLE,
  RatePlanRemovableResponse.JSON_PROPERTY_MASTER_RATE_LIST,
  RatePlanRemovableResponse.JSON_PROPERTY_PACKAGE_LIST,
  RatePlanRemovableResponse.JSON_PROPERTY_ADD_ON_LIST
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-06-05T13:54:29.398954+07:00[Asia/Bangkok]")
public class RatePlanRemovableResponse {
  public static final String JSON_PROPERTY_HOTEL_IDENTIFIER = "hotelIdentifier";
  private String hotelIdentifier;

  public static final String JSON_PROPERTY_RATE_PLAN_IDENTIFIER = "ratePlanIdentifier";
  private String ratePlanIdentifier;

  public static final String JSON_PROPERTY_REMOVABLE = "removable";
  private Boolean removable;

  public static final String JSON_PROPERTY_MASTER_RATE_LIST = "masterRateList";
  private List<IdentifierNamePair> masterRateList = null;

  public static final String JSON_PROPERTY_PACKAGE_LIST = "packageList";
  private List<IdentifierNamePair> packageList = null;

  public static final String JSON_PROPERTY_ADD_ON_LIST = "addOnList";
  private List<IdentifierNamePair> addOnList = null;

  public RatePlanRemovableResponse() { 
  }

  public RatePlanRemovableResponse hotelIdentifier(String hotelIdentifier) {
    
    this.hotelIdentifier = hotelIdentifier;
    return this;
  }

   /**
   * Rate plan&#39;s owner.
   * @return hotelIdentifier
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "hotel-1", required = true, value = "Rate plan's owner.")
  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getHotelIdentifier() {
    return hotelIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setHotelIdentifier(String hotelIdentifier) {
    this.hotelIdentifier = hotelIdentifier;
  }


  public RatePlanRemovableResponse ratePlanIdentifier(String ratePlanIdentifier) {
    
    this.ratePlanIdentifier = ratePlanIdentifier;
    return this;
  }

   /**
   * Rate plan identifier seeking to be removed.
   * @return ratePlanIdentifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "rate-plan-1", value = "Rate plan identifier seeking to be removed.")
  @JsonProperty(JSON_PROPERTY_RATE_PLAN_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRatePlanIdentifier() {
    return ratePlanIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_RATE_PLAN_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRatePlanIdentifier(String ratePlanIdentifier) {
    this.ratePlanIdentifier = ratePlanIdentifier;
  }


  public RatePlanRemovableResponse removable(Boolean removable) {
    
    this.removable = removable;
    return this;
  }

   /**
   * Returns true if rate plan can be removed.
   * @return removable
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Returns true if rate plan can be removed.")
  @JsonProperty(JSON_PROPERTY_REMOVABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getRemovable() {
    return removable;
  }


  @JsonProperty(JSON_PROPERTY_REMOVABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRemovable(Boolean removable) {
    this.removable = removable;
  }


  public RatePlanRemovableResponse masterRateList(List<IdentifierNamePair> masterRateList) {
    
    this.masterRateList = masterRateList;
    return this;
  }

  public RatePlanRemovableResponse addMasterRateListItem(IdentifierNamePair masterRateListItem) {
    if (this.masterRateList == null) {
      this.masterRateList = new ArrayList<>();
    }
    this.masterRateList.add(masterRateListItem);
    return this;
  }

   /**
   * Get masterRateList
   * @return masterRateList
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_MASTER_RATE_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<IdentifierNamePair> getMasterRateList() {
    return masterRateList;
  }


  @JsonProperty(JSON_PROPERTY_MASTER_RATE_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMasterRateList(List<IdentifierNamePair> masterRateList) {
    this.masterRateList = masterRateList;
  }


  public RatePlanRemovableResponse packageList(List<IdentifierNamePair> packageList) {
    
    this.packageList = packageList;
    return this;
  }

  public RatePlanRemovableResponse addPackageListItem(IdentifierNamePair packageListItem) {
    if (this.packageList == null) {
      this.packageList = new ArrayList<>();
    }
    this.packageList.add(packageListItem);
    return this;
  }

   /**
   * Get packageList
   * @return packageList
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PACKAGE_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<IdentifierNamePair> getPackageList() {
    return packageList;
  }


  @JsonProperty(JSON_PROPERTY_PACKAGE_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPackageList(List<IdentifierNamePair> packageList) {
    this.packageList = packageList;
  }


  public RatePlanRemovableResponse addOnList(List<IdentifierNamePair> addOnList) {
    
    this.addOnList = addOnList;
    return this;
  }

  public RatePlanRemovableResponse addAddOnListItem(IdentifierNamePair addOnListItem) {
    if (this.addOnList == null) {
      this.addOnList = new ArrayList<>();
    }
    this.addOnList.add(addOnListItem);
    return this;
  }

   /**
   * Get addOnList
   * @return addOnList
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ADD_ON_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<IdentifierNamePair> getAddOnList() {
    return addOnList;
  }


  @JsonProperty(JSON_PROPERTY_ADD_ON_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAddOnList(List<IdentifierNamePair> addOnList) {
    this.addOnList = addOnList;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RatePlanRemovableResponse ratePlanRemovableResponse = (RatePlanRemovableResponse) o;
    return Objects.equals(this.hotelIdentifier, ratePlanRemovableResponse.hotelIdentifier) &&
        Objects.equals(this.ratePlanIdentifier, ratePlanRemovableResponse.ratePlanIdentifier) &&
        Objects.equals(this.removable, ratePlanRemovableResponse.removable) &&
        Objects.equals(this.masterRateList, ratePlanRemovableResponse.masterRateList) &&
        Objects.equals(this.packageList, ratePlanRemovableResponse.packageList) &&
        Objects.equals(this.addOnList, ratePlanRemovableResponse.addOnList);
  }

  @Override
  public int hashCode() {
    return Objects.hash(hotelIdentifier, ratePlanIdentifier, removable, masterRateList, packageList, addOnList);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RatePlanRemovableResponse {\n");
    sb.append("    hotelIdentifier: ").append(toIndentedString(hotelIdentifier)).append("\n");
    sb.append("    ratePlanIdentifier: ").append(toIndentedString(ratePlanIdentifier)).append("\n");
    sb.append("    removable: ").append(toIndentedString(removable)).append("\n");
    sb.append("    masterRateList: ").append(toIndentedString(masterRateList)).append("\n");
    sb.append("    packageList: ").append(toIndentedString(packageList)).append("\n");
    sb.append("    addOnList: ").append(toIndentedString(addOnList)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

