/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/docs?api=affiliate): All APIs related to selling travel inventory as an affiliate. - [Extranet](/docs?api=extranet): All APIs related to managing travel inventory and suppliers. - [Booking Engine](/docs?api=booking-engine): All APIs related to searching for travel inventory and creating bookings. - [Channel Manager](/docs?api=channel-manager): All APIs related to channel managers who want to integrate with our payment.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.payment-v`1`+json.  ## Release history - 2021-07-01: v1 - Initial release  # Extranet API Welcome to the Extranet API - A programmer-friendly way to manage your travel inventory on the wink payment. This API offers a superset of the features you can find at [https://extranet.wink.travel](https://extranet.wink.travel) and gives you all the tools you need to ready your properties and inventory for sale across 10000s of our unique sales channels. What differentiates us from existing Extranets is 1. we make it available for everyone to use and 2. the care we take in only working with properties that have quality, curated content and ways to upsell and cross sell customers with ancillary products and experiences. Content creators have the ability to make their inventory look great and be searchable in a wide variety of ways. You won't find properties with generic inventory, low resolution pictures and little ancillary content that can easily be found everywhere else on the internet.  # Integrations We have already integrated with the most well-known channel managers so you don't have to. Once your properties are set up, you can finish the setup by mapping your property to wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API. - Allotz - CloudBeds / MyAllocator - Comanche - d-edge - FastBooking - HotelLink - HoteliersGuru - Omnibees - RateGain - Rate Tiger - ResAvenue - Siteminder - Sabre SynXis - Travelclick - Yieldplanet  # Intended Audience Programmers are [most likely] a requirement to start integrating with wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible. - Hotel chains - Hotel brands - Travel tech companies - Destination sites - Integrators - Aggregators - Destination management companies - Travel agencies - OTAs  
 *
 * The version of the OpenAPI document: 19.0.14-SNAPSHOT
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.extranet.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Wizard
 */
@JsonPropertyOrder({
  Wizard.JSON_PROPERTY_HOTEL_IDENTIFIER,
  Wizard.JSON_PROPERTY_REGISTRATION_WIZARD_COMPLETE,
  Wizard.JSON_PROPERTY_CONTACTS_COMPLETE,
  Wizard.JSON_PROPERTY_CONTACTS_COMPLETABLE,
  Wizard.JSON_PROPERTY_GENERAL_INFORMATION_COMPLETE,
  Wizard.JSON_PROPERTY_GENERAL_INFORMATION_COMPLETABLE,
  Wizard.JSON_PROPERTY_GEO_LOCATION_COMPLETE,
  Wizard.JSON_PROPERTY_GEO_LOCATION_COMPLETABLE,
  Wizard.JSON_PROPERTY_SERVICES_COMPLETE,
  Wizard.JSON_PROPERTY_SERVICES_COMPLETABLE,
  Wizard.JSON_PROPERTY_LIFESTYLES_COMPLETE,
  Wizard.JSON_PROPERTY_LIFESTYLES_COMPLETABLE,
  Wizard.JSON_PROPERTY_MULTIMEDIA_COMPLETE,
  Wizard.JSON_PROPERTY_MULTIMEDIA_COMPLETABLE,
  Wizard.JSON_PROPERTY_PROPERTY_POLICY_COMPLETE,
  Wizard.JSON_PROPERTY_PROPERTY_POLICY_COMPLETABLE,
  Wizard.JSON_PROPERTY_ROOM_TYPE_COMPLETE,
  Wizard.JSON_PROPERTY_ROOM_TYPE_COMPLETABLE,
  Wizard.JSON_PROPERTY_CANCELLATION_POLICY_COMPLETE,
  Wizard.JSON_PROPERTY_CANCELLATION_POLICY_COMPLETABLE,
  Wizard.JSON_PROPERTY_RATE_PLAN_COMPLETE,
  Wizard.JSON_PROPERTY_RATE_PLAN_COMPLETABLE,
  Wizard.JSON_PROPERTY_MASTER_RATE_COMPLETE,
  Wizard.JSON_PROPERTY_MASTER_RATE_COMPLETABLE,
  Wizard.JSON_PROPERTY_KYC_REQUIRED,
  Wizard.JSON_PROPERTY_KYC_COMPLETE,
  Wizard.JSON_PROPERTY_KYC_COMPLETABLE,
  Wizard.JSON_PROPERTY_EVERYTHING_COMPLETE
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-06-05T13:54:29.398954+07:00[Asia/Bangkok]")
public class Wizard {
  public static final String JSON_PROPERTY_HOTEL_IDENTIFIER = "hotelIdentifier";
  private String hotelIdentifier;

  public static final String JSON_PROPERTY_REGISTRATION_WIZARD_COMPLETE = "registrationWizardComplete";
  private Boolean registrationWizardComplete;

  public static final String JSON_PROPERTY_CONTACTS_COMPLETE = "contactsComplete";
  private Boolean contactsComplete;

  public static final String JSON_PROPERTY_CONTACTS_COMPLETABLE = "contactsCompletable";
  private Boolean contactsCompletable;

  public static final String JSON_PROPERTY_GENERAL_INFORMATION_COMPLETE = "generalInformationComplete";
  private Boolean generalInformationComplete;

  public static final String JSON_PROPERTY_GENERAL_INFORMATION_COMPLETABLE = "generalInformationCompletable";
  private Boolean generalInformationCompletable;

  public static final String JSON_PROPERTY_GEO_LOCATION_COMPLETE = "geoLocationComplete";
  private Boolean geoLocationComplete;

  public static final String JSON_PROPERTY_GEO_LOCATION_COMPLETABLE = "geoLocationCompletable";
  private Boolean geoLocationCompletable;

  public static final String JSON_PROPERTY_SERVICES_COMPLETE = "servicesComplete";
  private Boolean servicesComplete;

  public static final String JSON_PROPERTY_SERVICES_COMPLETABLE = "servicesCompletable";
  private Boolean servicesCompletable;

  public static final String JSON_PROPERTY_LIFESTYLES_COMPLETE = "lifestylesComplete";
  private Boolean lifestylesComplete;

  public static final String JSON_PROPERTY_LIFESTYLES_COMPLETABLE = "lifestylesCompletable";
  private Boolean lifestylesCompletable;

  public static final String JSON_PROPERTY_MULTIMEDIA_COMPLETE = "multimediaComplete";
  private Boolean multimediaComplete;

  public static final String JSON_PROPERTY_MULTIMEDIA_COMPLETABLE = "multimediaCompletable";
  private Boolean multimediaCompletable;

  public static final String JSON_PROPERTY_PROPERTY_POLICY_COMPLETE = "propertyPolicyComplete";
  private Boolean propertyPolicyComplete;

  public static final String JSON_PROPERTY_PROPERTY_POLICY_COMPLETABLE = "propertyPolicyCompletable";
  private Boolean propertyPolicyCompletable;

  public static final String JSON_PROPERTY_ROOM_TYPE_COMPLETE = "roomTypeComplete";
  private Boolean roomTypeComplete;

  public static final String JSON_PROPERTY_ROOM_TYPE_COMPLETABLE = "roomTypeCompletable";
  private Boolean roomTypeCompletable;

  public static final String JSON_PROPERTY_CANCELLATION_POLICY_COMPLETE = "cancellationPolicyComplete";
  private Boolean cancellationPolicyComplete;

  public static final String JSON_PROPERTY_CANCELLATION_POLICY_COMPLETABLE = "cancellationPolicyCompletable";
  private Boolean cancellationPolicyCompletable;

  public static final String JSON_PROPERTY_RATE_PLAN_COMPLETE = "ratePlanComplete";
  private Boolean ratePlanComplete;

  public static final String JSON_PROPERTY_RATE_PLAN_COMPLETABLE = "ratePlanCompletable";
  private Boolean ratePlanCompletable;

  public static final String JSON_PROPERTY_MASTER_RATE_COMPLETE = "masterRateComplete";
  private Boolean masterRateComplete;

  public static final String JSON_PROPERTY_MASTER_RATE_COMPLETABLE = "masterRateCompletable";
  private Boolean masterRateCompletable;

  public static final String JSON_PROPERTY_KYC_REQUIRED = "kycRequired";
  private Boolean kycRequired;

  public static final String JSON_PROPERTY_KYC_COMPLETE = "kycComplete";
  private Boolean kycComplete;

  public static final String JSON_PROPERTY_KYC_COMPLETABLE = "kycCompletable";
  private Boolean kycCompletable;

  public static final String JSON_PROPERTY_EVERYTHING_COMPLETE = "everythingComplete";
  private Boolean everythingComplete;

  public Wizard() { 
  }

  public Wizard hotelIdentifier(String hotelIdentifier) {
    
    this.hotelIdentifier = hotelIdentifier;
    return this;
  }

   /**
   * Get hotelIdentifier
   * @return hotelIdentifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getHotelIdentifier() {
    return hotelIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHotelIdentifier(String hotelIdentifier) {
    this.hotelIdentifier = hotelIdentifier;
  }


  public Wizard registrationWizardComplete(Boolean registrationWizardComplete) {
    
    this.registrationWizardComplete = registrationWizardComplete;
    return this;
  }

   /**
   * Get registrationWizardComplete
   * @return registrationWizardComplete
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_REGISTRATION_WIZARD_COMPLETE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getRegistrationWizardComplete() {
    return registrationWizardComplete;
  }


  @JsonProperty(JSON_PROPERTY_REGISTRATION_WIZARD_COMPLETE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRegistrationWizardComplete(Boolean registrationWizardComplete) {
    this.registrationWizardComplete = registrationWizardComplete;
  }


  public Wizard contactsComplete(Boolean contactsComplete) {
    
    this.contactsComplete = contactsComplete;
    return this;
  }

   /**
   * Get contactsComplete
   * @return contactsComplete
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CONTACTS_COMPLETE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getContactsComplete() {
    return contactsComplete;
  }


  @JsonProperty(JSON_PROPERTY_CONTACTS_COMPLETE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setContactsComplete(Boolean contactsComplete) {
    this.contactsComplete = contactsComplete;
  }


  public Wizard contactsCompletable(Boolean contactsCompletable) {
    
    this.contactsCompletable = contactsCompletable;
    return this;
  }

   /**
   * Get contactsCompletable
   * @return contactsCompletable
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CONTACTS_COMPLETABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getContactsCompletable() {
    return contactsCompletable;
  }


  @JsonProperty(JSON_PROPERTY_CONTACTS_COMPLETABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setContactsCompletable(Boolean contactsCompletable) {
    this.contactsCompletable = contactsCompletable;
  }


  public Wizard generalInformationComplete(Boolean generalInformationComplete) {
    
    this.generalInformationComplete = generalInformationComplete;
    return this;
  }

   /**
   * Get generalInformationComplete
   * @return generalInformationComplete
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_GENERAL_INFORMATION_COMPLETE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getGeneralInformationComplete() {
    return generalInformationComplete;
  }


  @JsonProperty(JSON_PROPERTY_GENERAL_INFORMATION_COMPLETE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGeneralInformationComplete(Boolean generalInformationComplete) {
    this.generalInformationComplete = generalInformationComplete;
  }


  public Wizard generalInformationCompletable(Boolean generalInformationCompletable) {
    
    this.generalInformationCompletable = generalInformationCompletable;
    return this;
  }

   /**
   * Get generalInformationCompletable
   * @return generalInformationCompletable
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_GENERAL_INFORMATION_COMPLETABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getGeneralInformationCompletable() {
    return generalInformationCompletable;
  }


  @JsonProperty(JSON_PROPERTY_GENERAL_INFORMATION_COMPLETABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGeneralInformationCompletable(Boolean generalInformationCompletable) {
    this.generalInformationCompletable = generalInformationCompletable;
  }


  public Wizard geoLocationComplete(Boolean geoLocationComplete) {
    
    this.geoLocationComplete = geoLocationComplete;
    return this;
  }

   /**
   * Get geoLocationComplete
   * @return geoLocationComplete
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_GEO_LOCATION_COMPLETE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getGeoLocationComplete() {
    return geoLocationComplete;
  }


  @JsonProperty(JSON_PROPERTY_GEO_LOCATION_COMPLETE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGeoLocationComplete(Boolean geoLocationComplete) {
    this.geoLocationComplete = geoLocationComplete;
  }


  public Wizard geoLocationCompletable(Boolean geoLocationCompletable) {
    
    this.geoLocationCompletable = geoLocationCompletable;
    return this;
  }

   /**
   * Get geoLocationCompletable
   * @return geoLocationCompletable
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_GEO_LOCATION_COMPLETABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getGeoLocationCompletable() {
    return geoLocationCompletable;
  }


  @JsonProperty(JSON_PROPERTY_GEO_LOCATION_COMPLETABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGeoLocationCompletable(Boolean geoLocationCompletable) {
    this.geoLocationCompletable = geoLocationCompletable;
  }


  public Wizard servicesComplete(Boolean servicesComplete) {
    
    this.servicesComplete = servicesComplete;
    return this;
  }

   /**
   * Get servicesComplete
   * @return servicesComplete
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SERVICES_COMPLETE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getServicesComplete() {
    return servicesComplete;
  }


  @JsonProperty(JSON_PROPERTY_SERVICES_COMPLETE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setServicesComplete(Boolean servicesComplete) {
    this.servicesComplete = servicesComplete;
  }


  public Wizard servicesCompletable(Boolean servicesCompletable) {
    
    this.servicesCompletable = servicesCompletable;
    return this;
  }

   /**
   * Get servicesCompletable
   * @return servicesCompletable
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SERVICES_COMPLETABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getServicesCompletable() {
    return servicesCompletable;
  }


  @JsonProperty(JSON_PROPERTY_SERVICES_COMPLETABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setServicesCompletable(Boolean servicesCompletable) {
    this.servicesCompletable = servicesCompletable;
  }


  public Wizard lifestylesComplete(Boolean lifestylesComplete) {
    
    this.lifestylesComplete = lifestylesComplete;
    return this;
  }

   /**
   * Get lifestylesComplete
   * @return lifestylesComplete
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_LIFESTYLES_COMPLETE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getLifestylesComplete() {
    return lifestylesComplete;
  }


  @JsonProperty(JSON_PROPERTY_LIFESTYLES_COMPLETE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLifestylesComplete(Boolean lifestylesComplete) {
    this.lifestylesComplete = lifestylesComplete;
  }


  public Wizard lifestylesCompletable(Boolean lifestylesCompletable) {
    
    this.lifestylesCompletable = lifestylesCompletable;
    return this;
  }

   /**
   * Get lifestylesCompletable
   * @return lifestylesCompletable
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_LIFESTYLES_COMPLETABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getLifestylesCompletable() {
    return lifestylesCompletable;
  }


  @JsonProperty(JSON_PROPERTY_LIFESTYLES_COMPLETABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLifestylesCompletable(Boolean lifestylesCompletable) {
    this.lifestylesCompletable = lifestylesCompletable;
  }


  public Wizard multimediaComplete(Boolean multimediaComplete) {
    
    this.multimediaComplete = multimediaComplete;
    return this;
  }

   /**
   * Get multimediaComplete
   * @return multimediaComplete
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_MULTIMEDIA_COMPLETE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getMultimediaComplete() {
    return multimediaComplete;
  }


  @JsonProperty(JSON_PROPERTY_MULTIMEDIA_COMPLETE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMultimediaComplete(Boolean multimediaComplete) {
    this.multimediaComplete = multimediaComplete;
  }


  public Wizard multimediaCompletable(Boolean multimediaCompletable) {
    
    this.multimediaCompletable = multimediaCompletable;
    return this;
  }

   /**
   * Get multimediaCompletable
   * @return multimediaCompletable
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_MULTIMEDIA_COMPLETABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getMultimediaCompletable() {
    return multimediaCompletable;
  }


  @JsonProperty(JSON_PROPERTY_MULTIMEDIA_COMPLETABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMultimediaCompletable(Boolean multimediaCompletable) {
    this.multimediaCompletable = multimediaCompletable;
  }


  public Wizard propertyPolicyComplete(Boolean propertyPolicyComplete) {
    
    this.propertyPolicyComplete = propertyPolicyComplete;
    return this;
  }

   /**
   * Get propertyPolicyComplete
   * @return propertyPolicyComplete
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PROPERTY_POLICY_COMPLETE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getPropertyPolicyComplete() {
    return propertyPolicyComplete;
  }


  @JsonProperty(JSON_PROPERTY_PROPERTY_POLICY_COMPLETE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPropertyPolicyComplete(Boolean propertyPolicyComplete) {
    this.propertyPolicyComplete = propertyPolicyComplete;
  }


  public Wizard propertyPolicyCompletable(Boolean propertyPolicyCompletable) {
    
    this.propertyPolicyCompletable = propertyPolicyCompletable;
    return this;
  }

   /**
   * Get propertyPolicyCompletable
   * @return propertyPolicyCompletable
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PROPERTY_POLICY_COMPLETABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getPropertyPolicyCompletable() {
    return propertyPolicyCompletable;
  }


  @JsonProperty(JSON_PROPERTY_PROPERTY_POLICY_COMPLETABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPropertyPolicyCompletable(Boolean propertyPolicyCompletable) {
    this.propertyPolicyCompletable = propertyPolicyCompletable;
  }


  public Wizard roomTypeComplete(Boolean roomTypeComplete) {
    
    this.roomTypeComplete = roomTypeComplete;
    return this;
  }

   /**
   * Get roomTypeComplete
   * @return roomTypeComplete
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ROOM_TYPE_COMPLETE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getRoomTypeComplete() {
    return roomTypeComplete;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_TYPE_COMPLETE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRoomTypeComplete(Boolean roomTypeComplete) {
    this.roomTypeComplete = roomTypeComplete;
  }


  public Wizard roomTypeCompletable(Boolean roomTypeCompletable) {
    
    this.roomTypeCompletable = roomTypeCompletable;
    return this;
  }

   /**
   * Get roomTypeCompletable
   * @return roomTypeCompletable
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ROOM_TYPE_COMPLETABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getRoomTypeCompletable() {
    return roomTypeCompletable;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_TYPE_COMPLETABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRoomTypeCompletable(Boolean roomTypeCompletable) {
    this.roomTypeCompletable = roomTypeCompletable;
  }


  public Wizard cancellationPolicyComplete(Boolean cancellationPolicyComplete) {
    
    this.cancellationPolicyComplete = cancellationPolicyComplete;
    return this;
  }

   /**
   * Get cancellationPolicyComplete
   * @return cancellationPolicyComplete
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CANCELLATION_POLICY_COMPLETE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCancellationPolicyComplete() {
    return cancellationPolicyComplete;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLATION_POLICY_COMPLETE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellationPolicyComplete(Boolean cancellationPolicyComplete) {
    this.cancellationPolicyComplete = cancellationPolicyComplete;
  }


  public Wizard cancellationPolicyCompletable(Boolean cancellationPolicyCompletable) {
    
    this.cancellationPolicyCompletable = cancellationPolicyCompletable;
    return this;
  }

   /**
   * Get cancellationPolicyCompletable
   * @return cancellationPolicyCompletable
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CANCELLATION_POLICY_COMPLETABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCancellationPolicyCompletable() {
    return cancellationPolicyCompletable;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLATION_POLICY_COMPLETABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellationPolicyCompletable(Boolean cancellationPolicyCompletable) {
    this.cancellationPolicyCompletable = cancellationPolicyCompletable;
  }


  public Wizard ratePlanComplete(Boolean ratePlanComplete) {
    
    this.ratePlanComplete = ratePlanComplete;
    return this;
  }

   /**
   * Get ratePlanComplete
   * @return ratePlanComplete
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_RATE_PLAN_COMPLETE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getRatePlanComplete() {
    return ratePlanComplete;
  }


  @JsonProperty(JSON_PROPERTY_RATE_PLAN_COMPLETE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRatePlanComplete(Boolean ratePlanComplete) {
    this.ratePlanComplete = ratePlanComplete;
  }


  public Wizard ratePlanCompletable(Boolean ratePlanCompletable) {
    
    this.ratePlanCompletable = ratePlanCompletable;
    return this;
  }

   /**
   * Get ratePlanCompletable
   * @return ratePlanCompletable
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_RATE_PLAN_COMPLETABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getRatePlanCompletable() {
    return ratePlanCompletable;
  }


  @JsonProperty(JSON_PROPERTY_RATE_PLAN_COMPLETABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRatePlanCompletable(Boolean ratePlanCompletable) {
    this.ratePlanCompletable = ratePlanCompletable;
  }


  public Wizard masterRateComplete(Boolean masterRateComplete) {
    
    this.masterRateComplete = masterRateComplete;
    return this;
  }

   /**
   * Get masterRateComplete
   * @return masterRateComplete
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_MASTER_RATE_COMPLETE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getMasterRateComplete() {
    return masterRateComplete;
  }


  @JsonProperty(JSON_PROPERTY_MASTER_RATE_COMPLETE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMasterRateComplete(Boolean masterRateComplete) {
    this.masterRateComplete = masterRateComplete;
  }


  public Wizard masterRateCompletable(Boolean masterRateCompletable) {
    
    this.masterRateCompletable = masterRateCompletable;
    return this;
  }

   /**
   * Get masterRateCompletable
   * @return masterRateCompletable
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_MASTER_RATE_COMPLETABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getMasterRateCompletable() {
    return masterRateCompletable;
  }


  @JsonProperty(JSON_PROPERTY_MASTER_RATE_COMPLETABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMasterRateCompletable(Boolean masterRateCompletable) {
    this.masterRateCompletable = masterRateCompletable;
  }


  public Wizard kycRequired(Boolean kycRequired) {
    
    this.kycRequired = kycRequired;
    return this;
  }

   /**
   * Get kycRequired
   * @return kycRequired
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_KYC_REQUIRED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getKycRequired() {
    return kycRequired;
  }


  @JsonProperty(JSON_PROPERTY_KYC_REQUIRED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setKycRequired(Boolean kycRequired) {
    this.kycRequired = kycRequired;
  }


  public Wizard kycComplete(Boolean kycComplete) {
    
    this.kycComplete = kycComplete;
    return this;
  }

   /**
   * Get kycComplete
   * @return kycComplete
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_KYC_COMPLETE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getKycComplete() {
    return kycComplete;
  }


  @JsonProperty(JSON_PROPERTY_KYC_COMPLETE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setKycComplete(Boolean kycComplete) {
    this.kycComplete = kycComplete;
  }


  public Wizard kycCompletable(Boolean kycCompletable) {
    
    this.kycCompletable = kycCompletable;
    return this;
  }

   /**
   * Get kycCompletable
   * @return kycCompletable
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_KYC_COMPLETABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getKycCompletable() {
    return kycCompletable;
  }


  @JsonProperty(JSON_PROPERTY_KYC_COMPLETABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setKycCompletable(Boolean kycCompletable) {
    this.kycCompletable = kycCompletable;
  }


  public Wizard everythingComplete(Boolean everythingComplete) {
    
    this.everythingComplete = everythingComplete;
    return this;
  }

   /**
   * Get everythingComplete
   * @return everythingComplete
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_EVERYTHING_COMPLETE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getEverythingComplete() {
    return everythingComplete;
  }


  @JsonProperty(JSON_PROPERTY_EVERYTHING_COMPLETE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEverythingComplete(Boolean everythingComplete) {
    this.everythingComplete = everythingComplete;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Wizard wizard = (Wizard) o;
    return Objects.equals(this.hotelIdentifier, wizard.hotelIdentifier) &&
        Objects.equals(this.registrationWizardComplete, wizard.registrationWizardComplete) &&
        Objects.equals(this.contactsComplete, wizard.contactsComplete) &&
        Objects.equals(this.contactsCompletable, wizard.contactsCompletable) &&
        Objects.equals(this.generalInformationComplete, wizard.generalInformationComplete) &&
        Objects.equals(this.generalInformationCompletable, wizard.generalInformationCompletable) &&
        Objects.equals(this.geoLocationComplete, wizard.geoLocationComplete) &&
        Objects.equals(this.geoLocationCompletable, wizard.geoLocationCompletable) &&
        Objects.equals(this.servicesComplete, wizard.servicesComplete) &&
        Objects.equals(this.servicesCompletable, wizard.servicesCompletable) &&
        Objects.equals(this.lifestylesComplete, wizard.lifestylesComplete) &&
        Objects.equals(this.lifestylesCompletable, wizard.lifestylesCompletable) &&
        Objects.equals(this.multimediaComplete, wizard.multimediaComplete) &&
        Objects.equals(this.multimediaCompletable, wizard.multimediaCompletable) &&
        Objects.equals(this.propertyPolicyComplete, wizard.propertyPolicyComplete) &&
        Objects.equals(this.propertyPolicyCompletable, wizard.propertyPolicyCompletable) &&
        Objects.equals(this.roomTypeComplete, wizard.roomTypeComplete) &&
        Objects.equals(this.roomTypeCompletable, wizard.roomTypeCompletable) &&
        Objects.equals(this.cancellationPolicyComplete, wizard.cancellationPolicyComplete) &&
        Objects.equals(this.cancellationPolicyCompletable, wizard.cancellationPolicyCompletable) &&
        Objects.equals(this.ratePlanComplete, wizard.ratePlanComplete) &&
        Objects.equals(this.ratePlanCompletable, wizard.ratePlanCompletable) &&
        Objects.equals(this.masterRateComplete, wizard.masterRateComplete) &&
        Objects.equals(this.masterRateCompletable, wizard.masterRateCompletable) &&
        Objects.equals(this.kycRequired, wizard.kycRequired) &&
        Objects.equals(this.kycComplete, wizard.kycComplete) &&
        Objects.equals(this.kycCompletable, wizard.kycCompletable) &&
        Objects.equals(this.everythingComplete, wizard.everythingComplete);
  }

  @Override
  public int hashCode() {
    return Objects.hash(hotelIdentifier, registrationWizardComplete, contactsComplete, contactsCompletable, generalInformationComplete, generalInformationCompletable, geoLocationComplete, geoLocationCompletable, servicesComplete, servicesCompletable, lifestylesComplete, lifestylesCompletable, multimediaComplete, multimediaCompletable, propertyPolicyComplete, propertyPolicyCompletable, roomTypeComplete, roomTypeCompletable, cancellationPolicyComplete, cancellationPolicyCompletable, ratePlanComplete, ratePlanCompletable, masterRateComplete, masterRateCompletable, kycRequired, kycComplete, kycCompletable, everythingComplete);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Wizard {\n");
    sb.append("    hotelIdentifier: ").append(toIndentedString(hotelIdentifier)).append("\n");
    sb.append("    registrationWizardComplete: ").append(toIndentedString(registrationWizardComplete)).append("\n");
    sb.append("    contactsComplete: ").append(toIndentedString(contactsComplete)).append("\n");
    sb.append("    contactsCompletable: ").append(toIndentedString(contactsCompletable)).append("\n");
    sb.append("    generalInformationComplete: ").append(toIndentedString(generalInformationComplete)).append("\n");
    sb.append("    generalInformationCompletable: ").append(toIndentedString(generalInformationCompletable)).append("\n");
    sb.append("    geoLocationComplete: ").append(toIndentedString(geoLocationComplete)).append("\n");
    sb.append("    geoLocationCompletable: ").append(toIndentedString(geoLocationCompletable)).append("\n");
    sb.append("    servicesComplete: ").append(toIndentedString(servicesComplete)).append("\n");
    sb.append("    servicesCompletable: ").append(toIndentedString(servicesCompletable)).append("\n");
    sb.append("    lifestylesComplete: ").append(toIndentedString(lifestylesComplete)).append("\n");
    sb.append("    lifestylesCompletable: ").append(toIndentedString(lifestylesCompletable)).append("\n");
    sb.append("    multimediaComplete: ").append(toIndentedString(multimediaComplete)).append("\n");
    sb.append("    multimediaCompletable: ").append(toIndentedString(multimediaCompletable)).append("\n");
    sb.append("    propertyPolicyComplete: ").append(toIndentedString(propertyPolicyComplete)).append("\n");
    sb.append("    propertyPolicyCompletable: ").append(toIndentedString(propertyPolicyCompletable)).append("\n");
    sb.append("    roomTypeComplete: ").append(toIndentedString(roomTypeComplete)).append("\n");
    sb.append("    roomTypeCompletable: ").append(toIndentedString(roomTypeCompletable)).append("\n");
    sb.append("    cancellationPolicyComplete: ").append(toIndentedString(cancellationPolicyComplete)).append("\n");
    sb.append("    cancellationPolicyCompletable: ").append(toIndentedString(cancellationPolicyCompletable)).append("\n");
    sb.append("    ratePlanComplete: ").append(toIndentedString(ratePlanComplete)).append("\n");
    sb.append("    ratePlanCompletable: ").append(toIndentedString(ratePlanCompletable)).append("\n");
    sb.append("    masterRateComplete: ").append(toIndentedString(masterRateComplete)).append("\n");
    sb.append("    masterRateCompletable: ").append(toIndentedString(masterRateCompletable)).append("\n");
    sb.append("    kycRequired: ").append(toIndentedString(kycRequired)).append("\n");
    sb.append("    kycComplete: ").append(toIndentedString(kycComplete)).append("\n");
    sb.append("    kycCompletable: ").append(toIndentedString(kycCompletable)).append("\n");
    sb.append("    everythingComplete: ").append(toIndentedString(everythingComplete)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

