package travel.wink.sdk.extranet.api;

import travel.wink.sdk.extranet.invoker.ApiClient;

import travel.wink.sdk.extranet.model.BookingLeaderboardEntry;
import travel.wink.sdk.extranet.model.GenericErrorMessage;
import travel.wink.sdk.extranet.model.LeaderboardOwnerRequest;
import travel.wink.sdk.extranet.model.LeaderboardRequest;
import travel.wink.sdk.extranet.model.PageBookingLeaderboardEntry;
import travel.wink.sdk.extranet.model.ShowSocialNetworks1400Response;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-06-11T13:46:18.379510+07:00[Asia/Bangkok]")
public class LeaderboardApi {
    private ApiClient apiClient;

    public LeaderboardApi() {
        this(new ApiClient());
    }

    @Autowired
    public LeaderboardApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Show Location Leaderboard
     * Show leaderboard based on location type such as continent.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param leaderboardRequest The leaderboardRequest parameter
     * @return PageBookingLeaderboardEntry
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showLeaderboardRequestCreation(LeaderboardRequest leaderboardRequest) throws WebClientResponseException {
        Object postBody = leaderboardRequest;
        // verify the required parameter 'leaderboardRequest' is set
        if (leaderboardRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'leaderboardRequest' when calling showLeaderboard", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<PageBookingLeaderboardEntry> localVarReturnType = new ParameterizedTypeReference<PageBookingLeaderboardEntry>() {};
        return apiClient.invokeAPI("/api/analytics/leaderboard/list", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Location Leaderboard
     * Show leaderboard based on location type such as continent.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param leaderboardRequest The leaderboardRequest parameter
     * @return PageBookingLeaderboardEntry
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<PageBookingLeaderboardEntry> showLeaderboard(LeaderboardRequest leaderboardRequest) throws WebClientResponseException {
        ParameterizedTypeReference<PageBookingLeaderboardEntry> localVarReturnType = new ParameterizedTypeReference<PageBookingLeaderboardEntry>() {};
        return showLeaderboardRequestCreation(leaderboardRequest).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<PageBookingLeaderboardEntry>> showLeaderboardWithHttpInfo(LeaderboardRequest leaderboardRequest) throws WebClientResponseException {
        ParameterizedTypeReference<PageBookingLeaderboardEntry> localVarReturnType = new ParameterizedTypeReference<PageBookingLeaderboardEntry>() {};
        return showLeaderboardRequestCreation(leaderboardRequest).toEntity(localVarReturnType);
    }
    /**
     * Show Affiliate Leaderboard 
     * Show leaderboard for a specific affiliate.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param leaderboardOwnerRequest The leaderboardOwnerRequest parameter
     * @return BookingLeaderboardEntry
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showLeaderboardByOwnerRequestCreation(LeaderboardOwnerRequest leaderboardOwnerRequest) throws WebClientResponseException {
        Object postBody = leaderboardOwnerRequest;
        // verify the required parameter 'leaderboardOwnerRequest' is set
        if (leaderboardOwnerRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'leaderboardOwnerRequest' when calling showLeaderboardByOwner", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<BookingLeaderboardEntry> localVarReturnType = new ParameterizedTypeReference<BookingLeaderboardEntry>() {};
        return apiClient.invokeAPI("/api/analytics/leaderboard", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Affiliate Leaderboard 
     * Show leaderboard for a specific affiliate.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param leaderboardOwnerRequest The leaderboardOwnerRequest parameter
     * @return BookingLeaderboardEntry
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<BookingLeaderboardEntry> showLeaderboardByOwner(LeaderboardOwnerRequest leaderboardOwnerRequest) throws WebClientResponseException {
        ParameterizedTypeReference<BookingLeaderboardEntry> localVarReturnType = new ParameterizedTypeReference<BookingLeaderboardEntry>() {};
        return showLeaderboardByOwnerRequestCreation(leaderboardOwnerRequest).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<BookingLeaderboardEntry>> showLeaderboardByOwnerWithHttpInfo(LeaderboardOwnerRequest leaderboardOwnerRequest) throws WebClientResponseException {
        ParameterizedTypeReference<BookingLeaderboardEntry> localVarReturnType = new ParameterizedTypeReference<BookingLeaderboardEntry>() {};
        return showLeaderboardByOwnerRequestCreation(leaderboardOwnerRequest).toEntity(localVarReturnType);
    }
}
