package travel.wink.sdk.extranet.api;

import travel.wink.sdk.extranet.invoker.ApiClient;

import travel.wink.sdk.extranet.model.GenericErrorMessage;
import travel.wink.sdk.extranet.model.Recognition;
import travel.wink.sdk.extranet.model.RecognitionView;
import travel.wink.sdk.extranet.model.RemoveEntryResponse;
import travel.wink.sdk.extranet.model.ShowSocialNetworks1400Response;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-06-11T13:46:18.379510+07:00[Asia/Bangkok]")
public class RecognitionApi {
    private ApiClient apiClient;

    public RecognitionApi() {
        this(new ApiClient());
    }

    @Autowired
    public RecognitionApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Delete Recognition
     * Delete a recognition by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Delete recognition record for property with this hotel identifier
     * @param recognitionIdentifier Delete recognition with this identifier
     * @param accept The accept parameter
     * @return RemoveEntryResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeRecognitionRequestCreation(String hotelIdentifier, String recognitionIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling removeRecognition", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'recognitionIdentifier' is set
        if (recognitionIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'recognitionIdentifier' when calling removeRecognition", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("recognitionIdentifier", recognitionIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/recognition/{recognitionIdentifier}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete Recognition
     * Delete a recognition by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Delete recognition record for property with this hotel identifier
     * @param recognitionIdentifier Delete recognition with this identifier
     * @param accept The accept parameter
     * @return RemoveEntryResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RemoveEntryResponse> removeRecognition(String hotelIdentifier, String recognitionIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return removeRecognitionRequestCreation(hotelIdentifier, recognitionIdentifier, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<RemoveEntryResponse>> removeRecognitionWithHttpInfo(String hotelIdentifier, String recognitionIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return removeRecognitionRequestCreation(hotelIdentifier, recognitionIdentifier, accept).toEntity(localVarReturnType);
    }
    /**
     * Create Recognition
     * Create a new recognition
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param hotelIdentifier Associate new recognition record with this hotel identifier
     * @param recognition The recognition parameter
     * @return RecognitionView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec saveRecognitionRequestCreation(String hotelIdentifier, Recognition recognition) throws WebClientResponseException {
        Object postBody = recognition;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling saveRecognition", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'recognition' is set
        if (recognition == null) {
            throw new WebClientResponseException("Missing the required parameter 'recognition' when calling saveRecognition", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<RecognitionView> localVarReturnType = new ParameterizedTypeReference<RecognitionView>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/recognition", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create Recognition
     * Create a new recognition
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param hotelIdentifier Associate new recognition record with this hotel identifier
     * @param recognition The recognition parameter
     * @return RecognitionView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RecognitionView> saveRecognition(String hotelIdentifier, Recognition recognition) throws WebClientResponseException {
        ParameterizedTypeReference<RecognitionView> localVarReturnType = new ParameterizedTypeReference<RecognitionView>() {};
        return saveRecognitionRequestCreation(hotelIdentifier, recognition).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<RecognitionView>> saveRecognitionWithHttpInfo(String hotelIdentifier, Recognition recognition) throws WebClientResponseException {
        ParameterizedTypeReference<RecognitionView> localVarReturnType = new ParameterizedTypeReference<RecognitionView>() {};
        return saveRecognitionRequestCreation(hotelIdentifier, recognition).toEntity(localVarReturnType);
    }
    /**
     * Show Recognition
     * Retrieve a recognition by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show recognition belonging to this hotel identifier
     * @param recognitionIdentifier Show recognition associated with this identifier
     * @param accept The accept parameter
     * @return RecognitionView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showRecognitionRequestCreation(String hotelIdentifier, String recognitionIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showRecognition", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'recognitionIdentifier' is set
        if (recognitionIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'recognitionIdentifier' when calling showRecognition", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("recognitionIdentifier", recognitionIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<RecognitionView> localVarReturnType = new ParameterizedTypeReference<RecognitionView>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/recognition/{recognitionIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Recognition
     * Retrieve a recognition by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show recognition belonging to this hotel identifier
     * @param recognitionIdentifier Show recognition associated with this identifier
     * @param accept The accept parameter
     * @return RecognitionView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RecognitionView> showRecognition(String hotelIdentifier, String recognitionIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RecognitionView> localVarReturnType = new ParameterizedTypeReference<RecognitionView>() {};
        return showRecognitionRequestCreation(hotelIdentifier, recognitionIdentifier, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<RecognitionView>> showRecognitionWithHttpInfo(String hotelIdentifier, String recognitionIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RecognitionView> localVarReturnType = new ParameterizedTypeReference<RecognitionView>() {};
        return showRecognitionRequestCreation(hotelIdentifier, recognitionIdentifier, accept).toEntity(localVarReturnType);
    }
    /**
     * Show Recognitions
     * Retrieve a list of all recognitions for property
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show list of recognitions for this hotel identifier
     * @param accept The accept parameter
     * @return List&lt;RecognitionView&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showRecognitionsRequestCreation(String hotelIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showRecognitions", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<RecognitionView> localVarReturnType = new ParameterizedTypeReference<RecognitionView>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/recognition/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Recognitions
     * Retrieve a list of all recognitions for property
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show list of recognitions for this hotel identifier
     * @param accept The accept parameter
     * @return List&lt;RecognitionView&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<RecognitionView> showRecognitions(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RecognitionView> localVarReturnType = new ParameterizedTypeReference<RecognitionView>() {};
        return showRecognitionsRequestCreation(hotelIdentifier, accept).bodyToFlux(localVarReturnType);
    }

    public Mono<ResponseEntity<List<RecognitionView>>> showRecognitionsWithHttpInfo(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RecognitionView> localVarReturnType = new ParameterizedTypeReference<RecognitionView>() {};
        return showRecognitionsRequestCreation(hotelIdentifier, accept).toEntityList(localVarReturnType);
    }
    /**
     * Show Recognition by Category
     * Retrieve list recognitions by category
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show list of recognitions for this hotel identifier
     * @param category Filter list of recognitions by category
     * @param accept The accept parameter
     * @return List&lt;RecognitionView&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showRecognitionsByCategoryRequestCreation(String hotelIdentifier, String category, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showRecognitionsByCategory", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'category' is set
        if (category == null) {
            throw new WebClientResponseException("Missing the required parameter 'category' when calling showRecognitionsByCategory", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("category", category);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<RecognitionView> localVarReturnType = new ParameterizedTypeReference<RecognitionView>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/recognition/{category}/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Recognition by Category
     * Retrieve list recognitions by category
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show list of recognitions for this hotel identifier
     * @param category Filter list of recognitions by category
     * @param accept The accept parameter
     * @return List&lt;RecognitionView&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<RecognitionView> showRecognitionsByCategory(String hotelIdentifier, String category, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RecognitionView> localVarReturnType = new ParameterizedTypeReference<RecognitionView>() {};
        return showRecognitionsByCategoryRequestCreation(hotelIdentifier, category, accept).bodyToFlux(localVarReturnType);
    }

    public Mono<ResponseEntity<List<RecognitionView>>> showRecognitionsByCategoryWithHttpInfo(String hotelIdentifier, String category, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RecognitionView> localVarReturnType = new ParameterizedTypeReference<RecognitionView>() {};
        return showRecognitionsByCategoryRequestCreation(hotelIdentifier, category, accept).toEntityList(localVarReturnType);
    }
    /**
     * Update Recognition
     * Update a recognition by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update recognition record associated with this hotel identifier
     * @param recognitionIdentifier Update recognition with this identifier
     * @param recognition The recognition parameter
     * @return RecognitionView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateRecognitionRequestCreation(String hotelIdentifier, String recognitionIdentifier, Recognition recognition) throws WebClientResponseException {
        Object postBody = recognition;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling updateRecognition", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'recognitionIdentifier' is set
        if (recognitionIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'recognitionIdentifier' when calling updateRecognition", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'recognition' is set
        if (recognition == null) {
            throw new WebClientResponseException("Missing the required parameter 'recognition' when calling updateRecognition", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("recognitionIdentifier", recognitionIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<RecognitionView> localVarReturnType = new ParameterizedTypeReference<RecognitionView>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/recognition/{recognitionIdentifier}", HttpMethod.PUT, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Recognition
     * Update a recognition by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update recognition record associated with this hotel identifier
     * @param recognitionIdentifier Update recognition with this identifier
     * @param recognition The recognition parameter
     * @return RecognitionView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RecognitionView> updateRecognition(String hotelIdentifier, String recognitionIdentifier, Recognition recognition) throws WebClientResponseException {
        ParameterizedTypeReference<RecognitionView> localVarReturnType = new ParameterizedTypeReference<RecognitionView>() {};
        return updateRecognitionRequestCreation(hotelIdentifier, recognitionIdentifier, recognition).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<RecognitionView>> updateRecognitionWithHttpInfo(String hotelIdentifier, String recognitionIdentifier, Recognition recognition) throws WebClientResponseException {
        ParameterizedTypeReference<RecognitionView> localVarReturnType = new ParameterizedTypeReference<RecognitionView>() {};
        return updateRecognitionRequestCreation(hotelIdentifier, recognitionIdentifier, recognition).toEntity(localVarReturnType);
    }
}
