/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/docs?api=affiliate): All APIs related to selling travel inventory as an affiliate. - [Extranet](/docs?api=extranet): All APIs related to managing travel inventory and suppliers. - [Booking Engine](/docs?api=booking-engine): All APIs related to searching for travel inventory and creating bookings. - [Channel Manager](/docs?api=channel-manager): All APIs related to channel managers who want to integrate with our payment.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.payment-v`1`+json.  ## Release history - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Extranet API Welcome to the Extranet API - A programmer-friendly way to manage your travel inventory on the wink payment. This API offers a superset of the features you can find at [https://extranet.wink.travel](https://extranet.wink.travel) and gives you all the tools you need to ready your properties and inventory for sale across 10000s of our unique sales channels. What differentiates us from existing Extranets is 1. we make it available for everyone to use and 2. the care we take in only working with properties that have quality, curated content and ways to ancillary and cross sell customers with ancillary products and experiences. Content creators have the ability to make their inventory look great and be searchable in a wide variety of ways. You won't find properties with generic inventory, low resolution pictures and little ancillary content that can easily be found everywhere else on the internet.  # Integrations We have already integrated with the most well-known channel managers so you don't have to. Once your properties are set up, you can finish the setup by mapping your property to wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API. - Allotz - CloudBeds / MyAllocator - Comanche - d-edge - FastBooking - HotelLink - HoteliersGuru - Omnibees - RateGain - Rate Tiger - ResAvenue - Siteminder - Sabre SynXis - Travelclick - Yieldplanet  # Intended Audience Programmers are [most likely] a requirement to start integrating with wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible. - Hotel chains - Hotel brands - Travel tech companies - Destination sites - Integrators - Aggregators - Destination management companies - Travel agencies - OTAs  
 *
 * The version of the OpenAPI document: 20.1.2-SNAPSHOT
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.extranet.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import travel.wink.sdk.extranet.model.Contact;
import travel.wink.sdk.extranet.model.DowPatternGroup;
import travel.wink.sdk.extranet.model.GeoJsonPoint;
import travel.wink.sdk.extranet.model.Moneys;
import travel.wink.sdk.extranet.model.Multimedia;
import travel.wink.sdk.extranet.model.SimpleDescription;
import travel.wink.sdk.extranet.model.Social;
import travel.wink.sdk.extranet.model.UpsertAddressRequest;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * UpsertMeetingRoomRequest
 */
@JsonPropertyOrder({
  UpsertMeetingRoomRequest.JSON_PROPERTY_FEATURED_IND,
  UpsertMeetingRoomRequest.JSON_PROPERTY_LIFESTYLE_TYPE,
  UpsertMeetingRoomRequest.JSON_PROPERTY_LOCATION,
  UpsertMeetingRoomRequest.JSON_PROPERTY_DESCRIPTIONS,
  UpsertMeetingRoomRequest.JSON_PROPERTY_MULTIMEDIAS,
  UpsertMeetingRoomRequest.JSON_PROPERTY_GEO_NAME_ID,
  UpsertMeetingRoomRequest.JSON_PROPERTY_COMMISSIONABLE,
  UpsertMeetingRoomRequest.JSON_PROPERTY_NAME,
  UpsertMeetingRoomRequest.JSON_PROPERTY_PROXIMITY_CODE,
  UpsertMeetingRoomRequest.JSON_PROPERTY_SORT,
  UpsertMeetingRoomRequest.JSON_PROPERTY_MIN_AGE_APPROPRIATE_CODE,
  UpsertMeetingRoomRequest.JSON_PROPERTY_BOOKABLE,
  UpsertMeetingRoomRequest.JSON_PROPERTY_ACTIVE,
  UpsertMeetingRoomRequest.JSON_PROPERTY_DISABILITY_FEATURES,
  UpsertMeetingRoomRequest.JSON_PROPERTY_SECURITY_FEATURES,
  UpsertMeetingRoomRequest.JSON_PROPERTY_APPLICABLE_START,
  UpsertMeetingRoomRequest.JSON_PROPERTY_APPLICABLE_END,
  UpsertMeetingRoomRequest.JSON_PROPERTY_RESERVATION_REQUIRED_IND,
  UpsertMeetingRoomRequest.JSON_PROPERTY_OPENS,
  UpsertMeetingRoomRequest.JSON_PROPERTY_CLOSES,
  UpsertMeetingRoomRequest.JSON_PROPERTY_FEE,
  UpsertMeetingRoomRequest.JSON_PROPERTY_PERCENT_DISCOUNT,
  UpsertMeetingRoomRequest.JSON_PROPERTY_CONTACT,
  UpsertMeetingRoomRequest.JSON_PROPERTY_ADDRESS,
  UpsertMeetingRoomRequest.JSON_PROPERTY_DAYS_OF_WEEK,
  UpsertMeetingRoomRequest.JSON_PROPERTY_SOCIALS,
  UpsertMeetingRoomRequest.JSON_PROPERTY_IRREGULAR,
  UpsertMeetingRoomRequest.JSON_PROPERTY_MEETING_ROOM_CAPACITY,
  UpsertMeetingRoomRequest.JSON_PROPERTY_ACCESS,
  UpsertMeetingRoomRequest.JSON_PROPERTY_MEETING_ROOM_TYPE_CODE,
  UpsertMeetingRoomRequest.JSON_PROPERTY_MEETING_ROOM_LEVEL,
  UpsertMeetingRoomRequest.JSON_PROPERTY_DEDICATED_IND,
  UpsertMeetingRoomRequest.JSON_PROPERTY_AREA,
  UpsertMeetingRoomRequest.JSON_PROPERTY_HEIGHT,
  UpsertMeetingRoomRequest.JSON_PROPERTY_WIDTH,
  UpsertMeetingRoomRequest.JSON_PROPERTY_LENGTH,
  UpsertMeetingRoomRequest.JSON_PROPERTY_AMENITIES,
  UpsertMeetingRoomRequest.JSON_PROPERTY_PRICING_TYPE
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-06-11T13:46:18.379510+07:00[Asia/Bangkok]")
public class UpsertMeetingRoomRequest {
  public static final String JSON_PROPERTY_FEATURED_IND = "featuredInd";
  private Boolean featuredInd;

  /**
   * Indicate the type of lifestyle this inventory should be associated with.
   */
  public enum LifestyleTypeEnum {
    HEALTH_FITNESS("LIFESTYLE_HEALTH_FITNESS"),
    
    RELAX("LIFESTYLE_RELAX"),
    
    ADULT_ONLY("LIFESTYLE_ADULT_ONLY"),
    
    ADVENTURE("LIFESTYLE_ADVENTURE"),
    
    BUSINESS("LIFESTYLE_BUSINESS"),
    
    LGBT("LIFESTYLE_LGBT"),
    
    SINGLE_PARENT("LIFESTYLE_SINGLE_PARENT"),
    
    SOLO_FEMALE("LIFESTYLE_SOLO_FEMALE"),
    
    BEAUTY("LIFESTYLE_BEAUTY"),
    
    FOODIE("LIFESTYLE_FOODIE"),
    
    FAMILY("LIFESTYLE_FAMILY"),
    
    ROMANCE("LIFESTYLE_ROMANCE"),
    
    COUPLE("LIFESTYLE_COUPLE"),
    
    SOLO("LIFESTYLE_SOLO"),
    
    BACKPACKER("LIFESTYLE_BACKPACKER"),
    
    SHOPPING("LIFESTYLE_SHOPPING"),
    
    SPORTS("LIFESTYLE_SPORTS"),
    
    MOUNTAIN("LIFESTYLE_MOUNTAIN"),
    
    BEACH("LIFESTYLE_BEACH"),
    
    CITY("LIFESTYLE_CITY"),
    
    COUNTRY("LIFESTYLE_COUNTRY"),
    
    CULTURE("LIFESTYLE_CULTURE"),
    
    ECO("LIFESTYLE_ECO");

    private String value;

    LifestyleTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static LifestyleTypeEnum fromValue(String value) {
      for (LifestyleTypeEnum b : LifestyleTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_LIFESTYLE_TYPE = "lifestyleType";
  private LifestyleTypeEnum lifestyleType;

  public static final String JSON_PROPERTY_LOCATION = "location";
  private GeoJsonPoint location;

  public static final String JSON_PROPERTY_DESCRIPTIONS = "descriptions";
  private List<SimpleDescription> descriptions = new ArrayList<>();

  public static final String JSON_PROPERTY_MULTIMEDIAS = "multimedias";
  private List<Multimedia> multimedias = new ArrayList<>();

  public static final String JSON_PROPERTY_GEO_NAME_ID = "geoNameId";
  private String geoNameId;

  public static final String JSON_PROPERTY_COMMISSIONABLE = "commissionable";
  private Boolean commissionable = true;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_PROXIMITY_CODE = "proximityCode";
  private String proximityCode;

  public static final String JSON_PROPERTY_SORT = "sort";
  private Integer sort;

  public static final String JSON_PROPERTY_MIN_AGE_APPROPRIATE_CODE = "minAgeAppropriateCode";
  private String minAgeAppropriateCode;

  public static final String JSON_PROPERTY_BOOKABLE = "bookable";
  private Boolean bookable = true;

  public static final String JSON_PROPERTY_ACTIVE = "active";
  private Boolean active = true;

  public static final String JSON_PROPERTY_DISABILITY_FEATURES = "disabilityFeatures";
  private List<String> disabilityFeatures = null;

  public static final String JSON_PROPERTY_SECURITY_FEATURES = "securityFeatures";
  private List<String> securityFeatures = null;

  public static final String JSON_PROPERTY_APPLICABLE_START = "applicableStart";
  private LocalDate applicableStart;

  public static final String JSON_PROPERTY_APPLICABLE_END = "applicableEnd";
  private LocalDate applicableEnd;

  public static final String JSON_PROPERTY_RESERVATION_REQUIRED_IND = "reservationRequiredInd";
  private Boolean reservationRequiredInd;

  public static final String JSON_PROPERTY_OPENS = "opens";
  private String opens;

  public static final String JSON_PROPERTY_CLOSES = "closes";
  private String closes;

  public static final String JSON_PROPERTY_FEE = "fee";
  private Moneys fee;

  public static final String JSON_PROPERTY_PERCENT_DISCOUNT = "percentDiscount";
  private Double percentDiscount;

  public static final String JSON_PROPERTY_CONTACT = "contact";
  private Contact contact;

  public static final String JSON_PROPERTY_ADDRESS = "address";
  private UpsertAddressRequest address;

  public static final String JSON_PROPERTY_DAYS_OF_WEEK = "daysOfWeek";
  private DowPatternGroup daysOfWeek;

  public static final String JSON_PROPERTY_SOCIALS = "socials";
  private List<Social> socials = null;

  public static final String JSON_PROPERTY_IRREGULAR = "irregular";
  private Boolean irregular = false;

  public static final String JSON_PROPERTY_MEETING_ROOM_CAPACITY = "meetingRoomCapacity";
  private Integer meetingRoomCapacity = 0;

  public static final String JSON_PROPERTY_ACCESS = "access";
  private String access = "MEETING_ROOM_ACCESS_PRIVATE";

  public static final String JSON_PROPERTY_MEETING_ROOM_TYPE_CODE = "meetingRoomTypeCode";
  private String meetingRoomTypeCode;

  public static final String JSON_PROPERTY_MEETING_ROOM_LEVEL = "meetingRoomLevel";
  private String meetingRoomLevel;

  public static final String JSON_PROPERTY_DEDICATED_IND = "dedicatedInd";
  private Boolean dedicatedInd;

  public static final String JSON_PROPERTY_AREA = "area";
  private Float area;

  public static final String JSON_PROPERTY_HEIGHT = "height";
  private Float height;

  public static final String JSON_PROPERTY_WIDTH = "width";
  private Float width;

  public static final String JSON_PROPERTY_LENGTH = "length";
  private Float length;

  public static final String JSON_PROPERTY_AMENITIES = "amenities";
  private List<String> amenities = null;

  /**
   * How this inventory item should be priced.
   */
  public enum PricingTypeEnum {
    PERSON_PER_USE("PER_PERSON_PER_USE"),
    
    USE("PER_USE"),
    
    PERSON_PER_HOUR("PER_PERSON_PER_HOUR"),
    
    HOUR("PER_HOUR");

    private String value;

    PricingTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PricingTypeEnum fromValue(String value) {
      for (PricingTypeEnum b : PricingTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PRICING_TYPE = "pricingType";
  private PricingTypeEnum pricingType;

  public UpsertMeetingRoomRequest() { 
  }

  public UpsertMeetingRoomRequest featuredInd(Boolean featuredInd) {
    
    this.featuredInd = featuredInd;
    return this;
  }

   /**
   * Indicates whether this inventory is featured. Use this flag as a way to signify that this inventory is special.
   * @return featuredInd
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "false", required = true, value = "Indicates whether this inventory is featured. Use this flag as a way to signify that this inventory is special.")
  @JsonProperty(JSON_PROPERTY_FEATURED_IND)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getFeaturedInd() {
    return featuredInd;
  }


  @JsonProperty(JSON_PROPERTY_FEATURED_IND)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setFeaturedInd(Boolean featuredInd) {
    this.featuredInd = featuredInd;
  }


  public UpsertMeetingRoomRequest lifestyleType(LifestyleTypeEnum lifestyleType) {
    
    this.lifestyleType = lifestyleType;
    return this;
  }

   /**
   * Indicate the type of lifestyle this inventory should be associated with.
   * @return lifestyleType
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "LIFESTYLE_HEALTH_FITNESS", value = "Indicate the type of lifestyle this inventory should be associated with.")
  @JsonProperty(JSON_PROPERTY_LIFESTYLE_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LifestyleTypeEnum getLifestyleType() {
    return lifestyleType;
  }


  @JsonProperty(JSON_PROPERTY_LIFESTYLE_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLifestyleType(LifestyleTypeEnum lifestyleType) {
    this.lifestyleType = lifestyleType;
  }


  public UpsertMeetingRoomRequest location(GeoJsonPoint location) {
    
    this.location = location;
    return this;
  }

   /**
   * Get location
   * @return location
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_LOCATION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public GeoJsonPoint getLocation() {
    return location;
  }


  @JsonProperty(JSON_PROPERTY_LOCATION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setLocation(GeoJsonPoint location) {
    this.location = location;
  }


  public UpsertMeetingRoomRequest descriptions(List<SimpleDescription> descriptions) {
    
    this.descriptions = descriptions;
    return this;
  }

  public UpsertMeetingRoomRequest addDescriptionsItem(SimpleDescription descriptionsItem) {
    this.descriptions.add(descriptionsItem);
    return this;
  }

   /**
   * Localized descriptions describing inventory.
   * @return descriptions
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "Localized descriptions describing inventory.")
  @JsonProperty(JSON_PROPERTY_DESCRIPTIONS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<SimpleDescription> getDescriptions() {
    return descriptions;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTIONS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDescriptions(List<SimpleDescription> descriptions) {
    this.descriptions = descriptions;
  }


  public UpsertMeetingRoomRequest multimedias(List<Multimedia> multimedias) {
    
    this.multimedias = multimedias;
    return this;
  }

  public UpsertMeetingRoomRequest addMultimediasItem(Multimedia multimediasItem) {
    this.multimedias.add(multimediasItem);
    return this;
  }

   /**
   * List of images / videos of inventory.
   * @return multimedias
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "List of images / videos of inventory.")
  @JsonProperty(JSON_PROPERTY_MULTIMEDIAS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<Multimedia> getMultimedias() {
    return multimedias;
  }


  @JsonProperty(JSON_PROPERTY_MULTIMEDIAS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setMultimedias(List<Multimedia> multimedias) {
    this.multimedias = multimedias;
  }


  public UpsertMeetingRoomRequest geoNameId(String geoNameId) {
    
    this.geoNameId = geoNameId;
    return this;
  }

   /**
   * Set this datapoint to control in which city this inventory is located. Defaults to city where property is located.
   * @return geoNameId
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "879798", required = true, value = "Set this datapoint to control in which city this inventory is located. Defaults to city where property is located.")
  @JsonProperty(JSON_PROPERTY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getGeoNameId() {
    return geoNameId;
  }


  @JsonProperty(JSON_PROPERTY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setGeoNameId(String geoNameId) {
    this.geoNameId = geoNameId;
  }


  public UpsertMeetingRoomRequest commissionable(Boolean commissionable) {
    
    this.commissionable = commissionable;
    return this;
  }

   /**
   * Indicate whether sales channels receive commission for selling this inventory.
   * @return commissionable
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "true", required = true, value = "Indicate whether sales channels receive commission for selling this inventory.")
  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getCommissionable() {
    return commissionable;
  }


  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCommissionable(Boolean commissionable) {
    this.commissionable = commissionable;
  }


  public UpsertMeetingRoomRequest name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Internal name of inventory.
   * @return name
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "Archery lesson", required = true, value = "Internal name of inventory.")
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(String name) {
    this.name = name;
  }


  public UpsertMeetingRoomRequest proximityCode(String proximityCode) {
    
    this.proximityCode = proximityCode;
    return this;
  }

   /**
   * Supported OTA specification &#x60;PRX&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return proximityCode
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "1", value = "Supported OTA specification `PRX` code. See [OTA geoname data](#operation/showAvailableCodesForCategory)")
  @JsonProperty(JSON_PROPERTY_PROXIMITY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getProximityCode() {
    return proximityCode;
  }


  @JsonProperty(JSON_PROPERTY_PROXIMITY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProximityCode(String proximityCode) {
    this.proximityCode = proximityCode;
  }


  public UpsertMeetingRoomRequest sort(Integer sort) {
    
    this.sort = sort;
    return this;
  }

   /**
   * Use this property to sort an inventory in a list of activities.
   * @return sort
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "1", value = "Use this property to sort an inventory in a list of activities.")
  @JsonProperty(JSON_PROPERTY_SORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getSort() {
    return sort;
  }


  @JsonProperty(JSON_PROPERTY_SORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSort(Integer sort) {
    this.sort = sort;
  }


  public UpsertMeetingRoomRequest minAgeAppropriateCode(String minAgeAppropriateCode) {
    
    this.minAgeAppropriateCode = minAgeAppropriateCode;
    return this;
  }

   /**
   * Supported OTA specification &#x60;AQC&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return minAgeAppropriateCode
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "1", value = "Supported OTA specification `AQC` code. See [OTA geoname data](#operation/showAvailableCodesForCategory)")
  @JsonProperty(JSON_PROPERTY_MIN_AGE_APPROPRIATE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMinAgeAppropriateCode() {
    return minAgeAppropriateCode;
  }


  @JsonProperty(JSON_PROPERTY_MIN_AGE_APPROPRIATE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMinAgeAppropriateCode(String minAgeAppropriateCode) {
    this.minAgeAppropriateCode = minAgeAppropriateCode;
  }


  public UpsertMeetingRoomRequest bookable(Boolean bookable) {
    
    this.bookable = bookable;
    return this;
  }

   /**
   * Indicates if this inventory can be added to a booking or if it is read-only marketing material only.
   * @return bookable
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "true", required = true, value = "Indicates if this inventory can be added to a booking or if it is read-only marketing material only.")
  @JsonProperty(JSON_PROPERTY_BOOKABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getBookable() {
    return bookable;
  }


  @JsonProperty(JSON_PROPERTY_BOOKABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setBookable(Boolean bookable) {
    this.bookable = bookable;
  }


  public UpsertMeetingRoomRequest active(Boolean active) {
    
    this.active = active;
    return this;
  }

   /**
   * Modify inventory availability with this flag.
   * @return active
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "true", required = true, value = "Modify inventory availability with this flag.")
  @JsonProperty(JSON_PROPERTY_ACTIVE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getActive() {
    return active;
  }


  @JsonProperty(JSON_PROPERTY_ACTIVE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setActive(Boolean active) {
    this.active = active;
  }


  public UpsertMeetingRoomRequest disabilityFeatures(List<String> disabilityFeatures) {
    
    this.disabilityFeatures = disabilityFeatures;
    return this;
  }

  public UpsertMeetingRoomRequest addDisabilityFeaturesItem(String disabilityFeaturesItem) {
    if (this.disabilityFeatures == null) {
      this.disabilityFeatures = new ArrayList<>();
    }
    this.disabilityFeatures.add(disabilityFeaturesItem);
    return this;
  }

   /**
   * Supported OTA specification &#x60;PHY&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return disabilityFeatures
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "[\"1\"]", value = "Supported OTA specification `PHY` code. See [OTA geoname data](#operation/showAvailableCodesForCategory)")
  @JsonProperty(JSON_PROPERTY_DISABILITY_FEATURES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getDisabilityFeatures() {
    return disabilityFeatures;
  }


  @JsonProperty(JSON_PROPERTY_DISABILITY_FEATURES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDisabilityFeatures(List<String> disabilityFeatures) {
    this.disabilityFeatures = disabilityFeatures;
  }


  public UpsertMeetingRoomRequest securityFeatures(List<String> securityFeatures) {
    
    this.securityFeatures = securityFeatures;
    return this;
  }

  public UpsertMeetingRoomRequest addSecurityFeaturesItem(String securityFeaturesItem) {
    if (this.securityFeatures == null) {
      this.securityFeatures = new ArrayList<>();
    }
    this.securityFeatures.add(securityFeaturesItem);
    return this;
  }

   /**
   * Supported OTA specification &#x60;SEC&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return securityFeatures
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "[\"1\"]", value = "Supported OTA specification `SEC` code. See [OTA geoname data](#operation/showAvailableCodesForCategory)")
  @JsonProperty(JSON_PROPERTY_SECURITY_FEATURES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getSecurityFeatures() {
    return securityFeatures;
  }


  @JsonProperty(JSON_PROPERTY_SECURITY_FEATURES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSecurityFeatures(List<String> securityFeatures) {
    this.securityFeatures = securityFeatures;
  }


  public UpsertMeetingRoomRequest applicableStart(LocalDate applicableStart) {
    
    this.applicableStart = applicableStart;
    return this;
  }

   /**
   * Start month and day or date for which the attraction (e.g. the start of a season) is available. This date property signifies that the inventory is recurring and / or seasonal. If the date is in the past, only day and month will be used to infer seasonality. If the date is a future date, it will be interpreted as a starting date.
   * @return applicableStart
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(example = "Thu Jan 01 07:00:00 ICT 1970", value = "Start month and day or date for which the attraction (e.g. the start of a season) is available. This date property signifies that the inventory is recurring and / or seasonal. If the date is in the past, only day and month will be used to infer seasonality. If the date is a future date, it will be interpreted as a starting date.")
  @JsonProperty(JSON_PROPERTY_APPLICABLE_START)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalDate getApplicableStart() {
    return applicableStart;
  }


  @JsonProperty(JSON_PROPERTY_APPLICABLE_START)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setApplicableStart(LocalDate applicableStart) {
    this.applicableStart = applicableStart;
  }


  public UpsertMeetingRoomRequest applicableEnd(LocalDate applicableEnd) {
    
    this.applicableEnd = applicableEnd;
    return this;
  }

   /**
   * End month and day or date for which the attraction (e.g. the start of a season) is available. This date property signifies that the inventory is recurring and / or seasonal. If the date is in the past, only day and month will be used to infer seasonality. If the date is a future date, it will be interpreted as a ending date.
   * @return applicableEnd
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(example = "Tue Dec 01 07:00:00 ICT 1970", value = "End month and day or date for which the attraction (e.g. the start of a season) is available. This date property signifies that the inventory is recurring and / or seasonal. If the date is in the past, only day and month will be used to infer seasonality. If the date is a future date, it will be interpreted as a ending date.")
  @JsonProperty(JSON_PROPERTY_APPLICABLE_END)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalDate getApplicableEnd() {
    return applicableEnd;
  }


  @JsonProperty(JSON_PROPERTY_APPLICABLE_END)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setApplicableEnd(LocalDate applicableEnd) {
    this.applicableEnd = applicableEnd;
  }


  public UpsertMeetingRoomRequest reservationRequiredInd(Boolean reservationRequiredInd) {
    
    this.reservationRequiredInd = reservationRequiredInd;
    return this;
  }

   /**
   * Indicates whether a reservation is required to participate in this inventory.
   * @return reservationRequiredInd
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Indicates whether a reservation is required to participate in this inventory.")
  @JsonProperty(JSON_PROPERTY_RESERVATION_REQUIRED_IND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getReservationRequiredInd() {
    return reservationRequiredInd;
  }


  @JsonProperty(JSON_PROPERTY_RESERVATION_REQUIRED_IND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReservationRequiredInd(Boolean reservationRequiredInd) {
    this.reservationRequiredInd = reservationRequiredInd;
  }


  public UpsertMeetingRoomRequest opens(String opens) {
    
    this.opens = opens;
    return this;
  }

   /**
   * Opening time of inventory (if applicable). Leave empty if inventory is always available.
   * @return opens
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "09:00", value = "Opening time of inventory (if applicable). Leave empty if inventory is always available.")
  @JsonProperty(JSON_PROPERTY_OPENS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getOpens() {
    return opens;
  }


  @JsonProperty(JSON_PROPERTY_OPENS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOpens(String opens) {
    this.opens = opens;
  }


  public UpsertMeetingRoomRequest closes(String closes) {
    
    this.closes = closes;
    return this;
  }

   /**
   * Closing time of inventory (if applicable). Leave empty if inventory is always available.
   * @return closes
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "17:30", value = "Closing time of inventory (if applicable). Leave empty if inventory is always available.")
  @JsonProperty(JSON_PROPERTY_CLOSES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCloses() {
    return closes;
  }


  @JsonProperty(JSON_PROPERTY_CLOSES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCloses(String closes) {
    this.closes = closes;
  }


  public UpsertMeetingRoomRequest fee(Moneys fee) {
    
    this.fee = fee;
    return this;
  }

   /**
   * Get fee
   * @return fee
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_FEE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Moneys getFee() {
    return fee;
  }


  @JsonProperty(JSON_PROPERTY_FEE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFee(Moneys fee) {
    this.fee = fee;
  }


  public UpsertMeetingRoomRequest percentDiscount(Double percentDiscount) {
    
    this.percentDiscount = percentDiscount;
    return this;
  }

   /**
   * Expected savings. Indicate how much the traveler is [usually] saving by booking it through this payment. Example: 20% discount.
   * minimum: 0.0
   * maximum: 1.0
   * @return percentDiscount
  **/
  @javax.annotation.Nonnull
  @NotNull
 @DecimalMin("0.0") @DecimalMax("1.0")  @ApiModelProperty(example = "0.2", required = true, value = "Expected savings. Indicate how much the traveler is [usually] saving by booking it through this payment. Example: 20% discount.")
  @JsonProperty(JSON_PROPERTY_PERCENT_DISCOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Double getPercentDiscount() {
    return percentDiscount;
  }


  @JsonProperty(JSON_PROPERTY_PERCENT_DISCOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPercentDiscount(Double percentDiscount) {
    this.percentDiscount = percentDiscount;
  }


  public UpsertMeetingRoomRequest contact(Contact contact) {
    
    this.contact = contact;
    return this;
  }

   /**
   * Get contact
   * @return contact
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CONTACT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Contact getContact() {
    return contact;
  }


  @JsonProperty(JSON_PROPERTY_CONTACT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setContact(Contact contact) {
    this.contact = contact;
  }


  public UpsertMeetingRoomRequest address(UpsertAddressRequest address) {
    
    this.address = address;
    return this;
  }

   /**
   * Get address
   * @return address
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UpsertAddressRequest getAddress() {
    return address;
  }


  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAddress(UpsertAddressRequest address) {
    this.address = address;
  }


  public UpsertMeetingRoomRequest daysOfWeek(DowPatternGroup daysOfWeek) {
    
    this.daysOfWeek = daysOfWeek;
    return this;
  }

   /**
   * Get daysOfWeek
   * @return daysOfWeek
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DAYS_OF_WEEK)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public DowPatternGroup getDaysOfWeek() {
    return daysOfWeek;
  }


  @JsonProperty(JSON_PROPERTY_DAYS_OF_WEEK)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDaysOfWeek(DowPatternGroup daysOfWeek) {
    this.daysOfWeek = daysOfWeek;
  }


  public UpsertMeetingRoomRequest socials(List<Social> socials) {
    
    this.socials = socials;
    return this;
  }

  public UpsertMeetingRoomRequest addSocialsItem(Social socialsItem) {
    if (this.socials == null) {
      this.socials = new ArrayList<>();
    }
    this.socials.add(socialsItem);
    return this;
  }

   /**
   * Social network accounts for inventory (if applicable).
   * @return socials
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Social network accounts for inventory (if applicable).")
  @JsonProperty(JSON_PROPERTY_SOCIALS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Social> getSocials() {
    return socials;
  }


  @JsonProperty(JSON_PROPERTY_SOCIALS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSocials(List<Social> socials) {
    this.socials = socials;
  }


  public UpsertMeetingRoomRequest irregular(Boolean irregular) {
    
    this.irregular = irregular;
    return this;
  }

   /**
   * Room has an irregular shape. If true, the room would be of a traditional square or rectangular shape.
   * @return irregular
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "true", required = true, value = "Room has an irregular shape. If true, the room would be of a traditional square or rectangular shape.")
  @JsonProperty(JSON_PROPERTY_IRREGULAR)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getIrregular() {
    return irregular;
  }


  @JsonProperty(JSON_PROPERTY_IRREGULAR)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIrregular(Boolean irregular) {
    this.irregular = irregular;
  }


  public UpsertMeetingRoomRequest meetingRoomCapacity(Integer meetingRoomCapacity) {
    
    this.meetingRoomCapacity = meetingRoomCapacity;
    return this;
  }

   /**
   * The total number of people permitted in the meeting room.
   * minimum: 0
   * @return meetingRoomCapacity
  **/
  @javax.annotation.Nonnull
  @NotNull
 @Min(0)  @ApiModelProperty(example = "100", required = true, value = "The total number of people permitted in the meeting room.")
  @JsonProperty(JSON_PROPERTY_MEETING_ROOM_CAPACITY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getMeetingRoomCapacity() {
    return meetingRoomCapacity;
  }


  @JsonProperty(JSON_PROPERTY_MEETING_ROOM_CAPACITY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setMeetingRoomCapacity(Integer meetingRoomCapacity) {
    this.meetingRoomCapacity = meetingRoomCapacity;
  }


  public UpsertMeetingRoomRequest access(String access) {
    
    this.access = access;
    return this;
  }

   /**
   * The type of access to the meeting space.
   * @return access
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "MEETING_ROOM_ACCESS_PUBLIC", value = "The type of access to the meeting space.")
  @JsonProperty(JSON_PROPERTY_ACCESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAccess() {
    return access;
  }


  @JsonProperty(JSON_PROPERTY_ACCESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAccess(String access) {
    this.access = access;
  }


  public UpsertMeetingRoomRequest meetingRoomTypeCode(String meetingRoomTypeCode) {
    
    this.meetingRoomTypeCode = meetingRoomTypeCode;
    return this;
  }

   /**
   * Supported OTA specification &#x60;MRF&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory).
   * @return meetingRoomTypeCode
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "[\"1\"]", required = true, value = "Supported OTA specification `MRF` code. See [OTA geoname data](#operation/showAvailableCodesForCategory).")
  @JsonProperty(JSON_PROPERTY_MEETING_ROOM_TYPE_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getMeetingRoomTypeCode() {
    return meetingRoomTypeCode;
  }


  @JsonProperty(JSON_PROPERTY_MEETING_ROOM_TYPE_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setMeetingRoomTypeCode(String meetingRoomTypeCode) {
    this.meetingRoomTypeCode = meetingRoomTypeCode;
  }


  public UpsertMeetingRoomRequest meetingRoomLevel(String meetingRoomLevel) {
    
    this.meetingRoomLevel = meetingRoomLevel;
    return this;
  }

   /**
   * Defines the level in the facility where the meeting room is located.
   * @return meetingRoomLevel
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "LOBBY", value = "Defines the level in the facility where the meeting room is located.")
  @JsonProperty(JSON_PROPERTY_MEETING_ROOM_LEVEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMeetingRoomLevel() {
    return meetingRoomLevel;
  }


  @JsonProperty(JSON_PROPERTY_MEETING_ROOM_LEVEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMeetingRoomLevel(String meetingRoomLevel) {
    this.meetingRoomLevel = meetingRoomLevel;
  }


  public UpsertMeetingRoomRequest dedicatedInd(Boolean dedicatedInd) {
    
    this.dedicatedInd = dedicatedInd;
    return this;
  }

   /**
   * When true, the room is used for a single purpose as indicated by the MeetingRoomTypeCode attribute.
   * @return dedicatedInd
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "false", required = true, value = "When true, the room is used for a single purpose as indicated by the MeetingRoomTypeCode attribute.")
  @JsonProperty(JSON_PROPERTY_DEDICATED_IND)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getDedicatedInd() {
    return dedicatedInd;
  }


  @JsonProperty(JSON_PROPERTY_DEDICATED_IND)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDedicatedInd(Boolean dedicatedInd) {
    this.dedicatedInd = dedicatedInd;
  }


  public UpsertMeetingRoomRequest area(Float area) {
    
    this.area = area;
    return this;
  }

   /**
   * Area (in square meters) of this meeting room.
   * minimum: 1.0
   * @return area
  **/
  @javax.annotation.Nonnull
  @NotNull
 @DecimalMin("1.0")  @ApiModelProperty(example = "100", required = true, value = "Area (in square meters) of this meeting room.")
  @JsonProperty(JSON_PROPERTY_AREA)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Float getArea() {
    return area;
  }


  @JsonProperty(JSON_PROPERTY_AREA)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setArea(Float area) {
    this.area = area;
  }


  public UpsertMeetingRoomRequest height(Float height) {
    
    this.height = height;
    return this;
  }

   /**
   * Height (in meters) of this meeting room.
   * minimum: 1.0
   * @return height
  **/
  @javax.annotation.Nonnull
  @NotNull
 @DecimalMin("1.0")  @ApiModelProperty(example = "4", required = true, value = "Height (in meters) of this meeting room.")
  @JsonProperty(JSON_PROPERTY_HEIGHT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Float getHeight() {
    return height;
  }


  @JsonProperty(JSON_PROPERTY_HEIGHT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setHeight(Float height) {
    this.height = height;
  }


  public UpsertMeetingRoomRequest width(Float width) {
    
    this.width = width;
    return this;
  }

   /**
   * Width (in meters) of this meeting room.
   * minimum: 1.0
   * @return width
  **/
  @javax.annotation.Nonnull
  @NotNull
 @DecimalMin("1.0")  @ApiModelProperty(example = "5", required = true, value = "Width (in meters) of this meeting room.")
  @JsonProperty(JSON_PROPERTY_WIDTH)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Float getWidth() {
    return width;
  }


  @JsonProperty(JSON_PROPERTY_WIDTH)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setWidth(Float width) {
    this.width = width;
  }


  public UpsertMeetingRoomRequest length(Float length) {
    
    this.length = length;
    return this;
  }

   /**
   * Length (in meters) of this meeting room.
   * minimum: 1.0
   * @return length
  **/
  @javax.annotation.Nonnull
  @NotNull
 @DecimalMin("1.0")  @ApiModelProperty(example = "5", required = true, value = "Length (in meters) of this meeting room.")
  @JsonProperty(JSON_PROPERTY_LENGTH)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Float getLength() {
    return length;
  }


  @JsonProperty(JSON_PROPERTY_LENGTH)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setLength(Float length) {
    this.length = length;
  }


  public UpsertMeetingRoomRequest amenities(List<String> amenities) {
    
    this.amenities = amenities;
    return this;
  }

  public UpsertMeetingRoomRequest addAmenitiesItem(String amenitiesItem) {
    if (this.amenities == null) {
      this.amenities = new ArrayList<>();
    }
    this.amenities.add(amenitiesItem);
    return this;
  }

   /**
   * Supported OTA specification &#x60;MRC&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory).
   * @return amenities
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "[\"1\"]", value = "Supported OTA specification `MRC` code. See [OTA geoname data](#operation/showAvailableCodesForCategory).")
  @JsonProperty(JSON_PROPERTY_AMENITIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getAmenities() {
    return amenities;
  }


  @JsonProperty(JSON_PROPERTY_AMENITIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAmenities(List<String> amenities) {
    this.amenities = amenities;
  }


  public UpsertMeetingRoomRequest pricingType(PricingTypeEnum pricingType) {
    
    this.pricingType = pricingType;
    return this;
  }

   /**
   * How this inventory item should be priced.
   * @return pricingType
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "How this inventory item should be priced.")
  @JsonProperty(JSON_PROPERTY_PRICING_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PricingTypeEnum getPricingType() {
    return pricingType;
  }


  @JsonProperty(JSON_PROPERTY_PRICING_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPricingType(PricingTypeEnum pricingType) {
    this.pricingType = pricingType;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UpsertMeetingRoomRequest upsertMeetingRoomRequest = (UpsertMeetingRoomRequest) o;
    return Objects.equals(this.featuredInd, upsertMeetingRoomRequest.featuredInd) &&
        Objects.equals(this.lifestyleType, upsertMeetingRoomRequest.lifestyleType) &&
        Objects.equals(this.location, upsertMeetingRoomRequest.location) &&
        Objects.equals(this.descriptions, upsertMeetingRoomRequest.descriptions) &&
        Objects.equals(this.multimedias, upsertMeetingRoomRequest.multimedias) &&
        Objects.equals(this.geoNameId, upsertMeetingRoomRequest.geoNameId) &&
        Objects.equals(this.commissionable, upsertMeetingRoomRequest.commissionable) &&
        Objects.equals(this.name, upsertMeetingRoomRequest.name) &&
        Objects.equals(this.proximityCode, upsertMeetingRoomRequest.proximityCode) &&
        Objects.equals(this.sort, upsertMeetingRoomRequest.sort) &&
        Objects.equals(this.minAgeAppropriateCode, upsertMeetingRoomRequest.minAgeAppropriateCode) &&
        Objects.equals(this.bookable, upsertMeetingRoomRequest.bookable) &&
        Objects.equals(this.active, upsertMeetingRoomRequest.active) &&
        Objects.equals(this.disabilityFeatures, upsertMeetingRoomRequest.disabilityFeatures) &&
        Objects.equals(this.securityFeatures, upsertMeetingRoomRequest.securityFeatures) &&
        Objects.equals(this.applicableStart, upsertMeetingRoomRequest.applicableStart) &&
        Objects.equals(this.applicableEnd, upsertMeetingRoomRequest.applicableEnd) &&
        Objects.equals(this.reservationRequiredInd, upsertMeetingRoomRequest.reservationRequiredInd) &&
        Objects.equals(this.opens, upsertMeetingRoomRequest.opens) &&
        Objects.equals(this.closes, upsertMeetingRoomRequest.closes) &&
        Objects.equals(this.fee, upsertMeetingRoomRequest.fee) &&
        Objects.equals(this.percentDiscount, upsertMeetingRoomRequest.percentDiscount) &&
        Objects.equals(this.contact, upsertMeetingRoomRequest.contact) &&
        Objects.equals(this.address, upsertMeetingRoomRequest.address) &&
        Objects.equals(this.daysOfWeek, upsertMeetingRoomRequest.daysOfWeek) &&
        Objects.equals(this.socials, upsertMeetingRoomRequest.socials) &&
        Objects.equals(this.irregular, upsertMeetingRoomRequest.irregular) &&
        Objects.equals(this.meetingRoomCapacity, upsertMeetingRoomRequest.meetingRoomCapacity) &&
        Objects.equals(this.access, upsertMeetingRoomRequest.access) &&
        Objects.equals(this.meetingRoomTypeCode, upsertMeetingRoomRequest.meetingRoomTypeCode) &&
        Objects.equals(this.meetingRoomLevel, upsertMeetingRoomRequest.meetingRoomLevel) &&
        Objects.equals(this.dedicatedInd, upsertMeetingRoomRequest.dedicatedInd) &&
        Objects.equals(this.area, upsertMeetingRoomRequest.area) &&
        Objects.equals(this.height, upsertMeetingRoomRequest.height) &&
        Objects.equals(this.width, upsertMeetingRoomRequest.width) &&
        Objects.equals(this.length, upsertMeetingRoomRequest.length) &&
        Objects.equals(this.amenities, upsertMeetingRoomRequest.amenities) &&
        Objects.equals(this.pricingType, upsertMeetingRoomRequest.pricingType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(featuredInd, lifestyleType, location, descriptions, multimedias, geoNameId, commissionable, name, proximityCode, sort, minAgeAppropriateCode, bookable, active, disabilityFeatures, securityFeatures, applicableStart, applicableEnd, reservationRequiredInd, opens, closes, fee, percentDiscount, contact, address, daysOfWeek, socials, irregular, meetingRoomCapacity, access, meetingRoomTypeCode, meetingRoomLevel, dedicatedInd, area, height, width, length, amenities, pricingType);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UpsertMeetingRoomRequest {\n");
    sb.append("    featuredInd: ").append(toIndentedString(featuredInd)).append("\n");
    sb.append("    lifestyleType: ").append(toIndentedString(lifestyleType)).append("\n");
    sb.append("    location: ").append(toIndentedString(location)).append("\n");
    sb.append("    descriptions: ").append(toIndentedString(descriptions)).append("\n");
    sb.append("    multimedias: ").append(toIndentedString(multimedias)).append("\n");
    sb.append("    geoNameId: ").append(toIndentedString(geoNameId)).append("\n");
    sb.append("    commissionable: ").append(toIndentedString(commissionable)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    proximityCode: ").append(toIndentedString(proximityCode)).append("\n");
    sb.append("    sort: ").append(toIndentedString(sort)).append("\n");
    sb.append("    minAgeAppropriateCode: ").append(toIndentedString(minAgeAppropriateCode)).append("\n");
    sb.append("    bookable: ").append(toIndentedString(bookable)).append("\n");
    sb.append("    active: ").append(toIndentedString(active)).append("\n");
    sb.append("    disabilityFeatures: ").append(toIndentedString(disabilityFeatures)).append("\n");
    sb.append("    securityFeatures: ").append(toIndentedString(securityFeatures)).append("\n");
    sb.append("    applicableStart: ").append(toIndentedString(applicableStart)).append("\n");
    sb.append("    applicableEnd: ").append(toIndentedString(applicableEnd)).append("\n");
    sb.append("    reservationRequiredInd: ").append(toIndentedString(reservationRequiredInd)).append("\n");
    sb.append("    opens: ").append(toIndentedString(opens)).append("\n");
    sb.append("    closes: ").append(toIndentedString(closes)).append("\n");
    sb.append("    fee: ").append(toIndentedString(fee)).append("\n");
    sb.append("    percentDiscount: ").append(toIndentedString(percentDiscount)).append("\n");
    sb.append("    contact: ").append(toIndentedString(contact)).append("\n");
    sb.append("    address: ").append(toIndentedString(address)).append("\n");
    sb.append("    daysOfWeek: ").append(toIndentedString(daysOfWeek)).append("\n");
    sb.append("    socials: ").append(toIndentedString(socials)).append("\n");
    sb.append("    irregular: ").append(toIndentedString(irregular)).append("\n");
    sb.append("    meetingRoomCapacity: ").append(toIndentedString(meetingRoomCapacity)).append("\n");
    sb.append("    access: ").append(toIndentedString(access)).append("\n");
    sb.append("    meetingRoomTypeCode: ").append(toIndentedString(meetingRoomTypeCode)).append("\n");
    sb.append("    meetingRoomLevel: ").append(toIndentedString(meetingRoomLevel)).append("\n");
    sb.append("    dedicatedInd: ").append(toIndentedString(dedicatedInd)).append("\n");
    sb.append("    area: ").append(toIndentedString(area)).append("\n");
    sb.append("    height: ").append(toIndentedString(height)).append("\n");
    sb.append("    width: ").append(toIndentedString(width)).append("\n");
    sb.append("    length: ").append(toIndentedString(length)).append("\n");
    sb.append("    amenities: ").append(toIndentedString(amenities)).append("\n");
    sb.append("    pricingType: ").append(toIndentedString(pricingType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

