/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.api;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.extranet.invoker.ApiClient;
import travel.wink.sdk.extranet.model.KeyValuePair;
import travel.wink.sdk.extranet.model.MeetingRoomView;
import travel.wink.sdk.extranet.model.RemoveEntryResponse;
import travel.wink.sdk.extranet.model.UpsertMeetingRoomRequest;

public class MeetingRoomApi {
    private ApiClient apiClient;

    public MeetingRoomApi() {
        this(new ApiClient());
    }

    @Autowired
    public MeetingRoomApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec createMeetingRoomRequestCreation(String hotelIdentifier, UpsertMeetingRoomRequest upsertMeetingRoomRequest) throws WebClientResponseException {
        UpsertMeetingRoomRequest postBody = upsertMeetingRoomRequest;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling createMeetingRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertMeetingRoomRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertMeetingRoomRequest' when calling createMeetingRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/vnd.platform-v1+json", "application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<MeetingRoomView> localVarReturnType = new ParameterizedTypeReference<MeetingRoomView>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/meetingroom", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<MeetingRoomView> createMeetingRoom(String hotelIdentifier, UpsertMeetingRoomRequest upsertMeetingRoomRequest) throws WebClientResponseException {
        ParameterizedTypeReference<MeetingRoomView> localVarReturnType = new ParameterizedTypeReference<MeetingRoomView>(){};
        return this.createMeetingRoomRequestCreation(hotelIdentifier, upsertMeetingRoomRequest).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<MeetingRoomView>> createMeetingRoomWithHttpInfo(String hotelIdentifier, UpsertMeetingRoomRequest upsertMeetingRoomRequest) throws WebClientResponseException {
        ParameterizedTypeReference<MeetingRoomView> localVarReturnType = new ParameterizedTypeReference<MeetingRoomView>(){};
        return this.createMeetingRoomRequestCreation(hotelIdentifier, upsertMeetingRoomRequest).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec removeMeetingRoomRequestCreation(String hotelIdentifier, String meetingRoomIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling removeMeetingRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (meetingRoomIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'meetingRoomIdentifier' when calling removeMeetingRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("meetingRoomIdentifier", meetingRoomIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/meetingroom/{meetingRoomIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RemoveEntryResponse> removeMeetingRoom(String hotelIdentifier, String meetingRoomIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>(){};
        return this.removeMeetingRoomRequestCreation(hotelIdentifier, meetingRoomIdentifier, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RemoveEntryResponse>> removeMeetingRoomWithHttpInfo(String hotelIdentifier, String meetingRoomIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>(){};
        return this.removeMeetingRoomRequestCreation(hotelIdentifier, meetingRoomIdentifier, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec removeMultimedia4RequestCreation(String hotelIdentifier, String meetingRoomIdentifier, String multimediaIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling removeMultimedia4", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (meetingRoomIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'meetingRoomIdentifier' when calling removeMultimedia4", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (multimediaIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'multimediaIdentifier' when calling removeMultimedia4", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("meetingRoomIdentifier", meetingRoomIdentifier);
        pathParams.put("multimediaIdentifier", multimediaIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<MeetingRoomView> localVarReturnType = new ParameterizedTypeReference<MeetingRoomView>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/meetingroom/{meetingRoomIdentifier}/multimedia/{multimediaIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<MeetingRoomView> removeMultimedia4(String hotelIdentifier, String meetingRoomIdentifier, String multimediaIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<MeetingRoomView> localVarReturnType = new ParameterizedTypeReference<MeetingRoomView>(){};
        return this.removeMultimedia4RequestCreation(hotelIdentifier, meetingRoomIdentifier, multimediaIdentifier, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<MeetingRoomView>> removeMultimedia4WithHttpInfo(String hotelIdentifier, String meetingRoomIdentifier, String multimediaIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<MeetingRoomView> localVarReturnType = new ParameterizedTypeReference<MeetingRoomView>(){};
        return this.removeMultimedia4RequestCreation(hotelIdentifier, meetingRoomIdentifier, multimediaIdentifier, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showMeetingRoomRequestCreation(String hotelIdentifier, String meetingRoomIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showMeetingRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (meetingRoomIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'meetingRoomIdentifier' when calling showMeetingRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("meetingRoomIdentifier", meetingRoomIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<MeetingRoomView> localVarReturnType = new ParameterizedTypeReference<MeetingRoomView>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/meetingroom/{meetingRoomIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<MeetingRoomView> showMeetingRoom(String hotelIdentifier, String meetingRoomIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<MeetingRoomView> localVarReturnType = new ParameterizedTypeReference<MeetingRoomView>(){};
        return this.showMeetingRoomRequestCreation(hotelIdentifier, meetingRoomIdentifier, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<MeetingRoomView>> showMeetingRoomWithHttpInfo(String hotelIdentifier, String meetingRoomIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<MeetingRoomView> localVarReturnType = new ParameterizedTypeReference<MeetingRoomView>(){};
        return this.showMeetingRoomRequestCreation(hotelIdentifier, meetingRoomIdentifier, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showMeetingRoomPairsRequestCreation(String hotelIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showMeetingRoomPairs", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<KeyValuePair> localVarReturnType = new ParameterizedTypeReference<KeyValuePair>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/meetingroom/list/pair", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<KeyValuePair> showMeetingRoomPairs(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePair> localVarReturnType = new ParameterizedTypeReference<KeyValuePair>(){};
        return this.showMeetingRoomPairsRequestCreation(hotelIdentifier, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<KeyValuePair>>> showMeetingRoomPairsWithHttpInfo(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePair> localVarReturnType = new ParameterizedTypeReference<KeyValuePair>(){};
        return this.showMeetingRoomPairsRequestCreation(hotelIdentifier, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showMeetingRoomsRequestCreation(String hotelIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showMeetingRooms", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<MeetingRoomView> localVarReturnType = new ParameterizedTypeReference<MeetingRoomView>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/meetingroom/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<MeetingRoomView> showMeetingRooms(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<MeetingRoomView> localVarReturnType = new ParameterizedTypeReference<MeetingRoomView>(){};
        return this.showMeetingRoomsRequestCreation(hotelIdentifier, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<MeetingRoomView>>> showMeetingRoomsWithHttpInfo(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<MeetingRoomView> localVarReturnType = new ParameterizedTypeReference<MeetingRoomView>(){};
        return this.showMeetingRoomsRequestCreation(hotelIdentifier, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec updateMeetingRoomRequestCreation(String hotelIdentifier, String meetingRoomIdentifier, UpsertMeetingRoomRequest upsertMeetingRoomRequest) throws WebClientResponseException {
        UpsertMeetingRoomRequest postBody = upsertMeetingRoomRequest;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling updateMeetingRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (meetingRoomIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'meetingRoomIdentifier' when calling updateMeetingRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertMeetingRoomRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertMeetingRoomRequest' when calling updateMeetingRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("meetingRoomIdentifier", meetingRoomIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/vnd.platform-v1+json", "application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<MeetingRoomView> localVarReturnType = new ParameterizedTypeReference<MeetingRoomView>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/meetingroom/{meetingRoomIdentifier}", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<MeetingRoomView> updateMeetingRoom(String hotelIdentifier, String meetingRoomIdentifier, UpsertMeetingRoomRequest upsertMeetingRoomRequest) throws WebClientResponseException {
        ParameterizedTypeReference<MeetingRoomView> localVarReturnType = new ParameterizedTypeReference<MeetingRoomView>(){};
        return this.updateMeetingRoomRequestCreation(hotelIdentifier, meetingRoomIdentifier, upsertMeetingRoomRequest).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<MeetingRoomView>> updateMeetingRoomWithHttpInfo(String hotelIdentifier, String meetingRoomIdentifier, UpsertMeetingRoomRequest upsertMeetingRoomRequest) throws WebClientResponseException {
        ParameterizedTypeReference<MeetingRoomView> localVarReturnType = new ParameterizedTypeReference<MeetingRoomView>(){};
        return this.updateMeetingRoomRequestCreation(hotelIdentifier, meetingRoomIdentifier, upsertMeetingRoomRequest).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec uploadMeetingRoomMediaRequestCreation(String hotelIdentifier, String meetingRoomIdentifier, List<File> files) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling uploadMeetingRoomMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (meetingRoomIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'meetingRoomIdentifier' when calling uploadMeetingRoomMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (files == null) {
            throw new WebClientResponseException("Missing the required parameter 'files' when calling uploadMeetingRoomMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("meetingRoomIdentifier", meetingRoomIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (files != null) {
            formParams.addAll((Object)"files", files.stream().map(FileSystemResource::new).collect(Collectors.toList()));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<MeetingRoomView> localVarReturnType = new ParameterizedTypeReference<MeetingRoomView>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/meetingroom/{meetingRoomIdentifier}/multimedia", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<MeetingRoomView> uploadMeetingRoomMedia(String hotelIdentifier, String meetingRoomIdentifier, List<File> files) throws WebClientResponseException {
        ParameterizedTypeReference<MeetingRoomView> localVarReturnType = new ParameterizedTypeReference<MeetingRoomView>(){};
        return this.uploadMeetingRoomMediaRequestCreation(hotelIdentifier, meetingRoomIdentifier, files).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<MeetingRoomView>> uploadMeetingRoomMediaWithHttpInfo(String hotelIdentifier, String meetingRoomIdentifier, List<File> files) throws WebClientResponseException {
        ParameterizedTypeReference<MeetingRoomView> localVarReturnType = new ParameterizedTypeReference<MeetingRoomView>(){};
        return this.uploadMeetingRoomMediaRequestCreation(hotelIdentifier, meetingRoomIdentifier, files).toEntity((ParameterizedTypeReference)localVarReturnType);
    }
}

