package travel.wink.sdk.extranet.api;

import travel.wink.sdk.extranet.invoker.ApiClient;

import java.io.File;
import travel.wink.sdk.extranet.model.GenericErrorMessage;
import travel.wink.sdk.extranet.model.KeyValuePair;
import travel.wink.sdk.extranet.model.RecreationView;
import travel.wink.sdk.extranet.model.RemoveEntryResponse;
import travel.wink.sdk.extranet.model.ShowSocialNetworks1400Response;
import travel.wink.sdk.extranet.model.UpsertActivityRequest;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-06-16T12:47:36.256942+07:00[Asia/Bangkok]")
public class ActivityApi {
    private ApiClient apiClient;

    public ActivityApi() {
        this(new ApiClient());
    }

    @Autowired
    public ActivityApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Delete Activity
     * Delete a activity by its identifier
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Delete activity owned by this hotel identifier
     * @param activityIdentifier Delete activity identified by this identifier
     * @param accept The accept parameter
     * @return RemoveEntryResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeActivityRequestCreation(String hotelIdentifier, String activityIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling removeActivity", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'activityIdentifier' is set
        if (activityIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'activityIdentifier' when calling removeActivity", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("activityIdentifier", activityIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/activity/{activityIdentifier}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete Activity
     * Delete a activity by its identifier
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Delete activity owned by this hotel identifier
     * @param activityIdentifier Delete activity identified by this identifier
     * @param accept The accept parameter
     * @return RemoveEntryResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RemoveEntryResponse> removeActivity(String hotelIdentifier, String activityIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return removeActivityRequestCreation(hotelIdentifier, activityIdentifier, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<RemoveEntryResponse>> removeActivityWithHttpInfo(String hotelIdentifier, String activityIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return removeActivityRequestCreation(hotelIdentifier, activityIdentifier, accept).toEntity(localVarReturnType);
    }
    /**
     * Create Activity
     * Persist new activity record.
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>201</b> - Created
     * @param hotelIdentifier Persist activity owned by this hotel identifier
     * @param upsertActivityRequest The upsertActivityRequest parameter
     * @return RecreationView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec saveActivityRequestCreation(String hotelIdentifier, UpsertActivityRequest upsertActivityRequest) throws WebClientResponseException {
        Object postBody = upsertActivityRequest;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling saveActivity", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertActivityRequest' is set
        if (upsertActivityRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertActivityRequest' when calling saveActivity", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<RecreationView> localVarReturnType = new ParameterizedTypeReference<RecreationView>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/activity", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create Activity
     * Persist new activity record.
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>201</b> - Created
     * @param hotelIdentifier Persist activity owned by this hotel identifier
     * @param upsertActivityRequest The upsertActivityRequest parameter
     * @return RecreationView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RecreationView> saveActivity(String hotelIdentifier, UpsertActivityRequest upsertActivityRequest) throws WebClientResponseException {
        ParameterizedTypeReference<RecreationView> localVarReturnType = new ParameterizedTypeReference<RecreationView>() {};
        return saveActivityRequestCreation(hotelIdentifier, upsertActivityRequest).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<RecreationView>> saveActivityWithHttpInfo(String hotelIdentifier, UpsertActivityRequest upsertActivityRequest) throws WebClientResponseException {
        ParameterizedTypeReference<RecreationView> localVarReturnType = new ParameterizedTypeReference<RecreationView>() {};
        return saveActivityRequestCreation(hotelIdentifier, upsertActivityRequest).toEntity(localVarReturnType);
    }
    /**
     * Show Activities
     * Retrieve list of activities for property.
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show activities associated with this hotel identifier
     * @param accept The accept parameter
     * @return List&lt;RecreationView&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showActivitiesRequestCreation(String hotelIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showActivities", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<RecreationView> localVarReturnType = new ParameterizedTypeReference<RecreationView>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/activity/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Activities
     * Retrieve list of activities for property.
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show activities associated with this hotel identifier
     * @param accept The accept parameter
     * @return List&lt;RecreationView&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<RecreationView> showActivities(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RecreationView> localVarReturnType = new ParameterizedTypeReference<RecreationView>() {};
        return showActivitiesRequestCreation(hotelIdentifier, accept).bodyToFlux(localVarReturnType);
    }

    public Mono<ResponseEntity<List<RecreationView>>> showActivitiesWithHttpInfo(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RecreationView> localVarReturnType = new ParameterizedTypeReference<RecreationView>() {};
        return showActivitiesRequestCreation(hotelIdentifier, accept).toEntityList(localVarReturnType);
    }
    /**
     * Show Activity
     * Retrieve activity record by its identifier.
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show activity owned by this hotel identifier
     * @param activityIdentifier Show activity for identifier
     * @param accept The accept parameter
     * @return RecreationView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showActivityRequestCreation(String hotelIdentifier, String activityIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showActivity", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'activityIdentifier' is set
        if (activityIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'activityIdentifier' when calling showActivity", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("activityIdentifier", activityIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<RecreationView> localVarReturnType = new ParameterizedTypeReference<RecreationView>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/activity/{activityIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Activity
     * Retrieve activity record by its identifier.
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show activity owned by this hotel identifier
     * @param activityIdentifier Show activity for identifier
     * @param accept The accept parameter
     * @return RecreationView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RecreationView> showActivity(String hotelIdentifier, String activityIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RecreationView> localVarReturnType = new ParameterizedTypeReference<RecreationView>() {};
        return showActivityRequestCreation(hotelIdentifier, activityIdentifier, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<RecreationView>> showActivityWithHttpInfo(String hotelIdentifier, String activityIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RecreationView> localVarReturnType = new ParameterizedTypeReference<RecreationView>() {};
        return showActivityRequestCreation(hotelIdentifier, activityIdentifier, accept).toEntity(localVarReturnType);
    }
    /**
     * Show Activities as key/value pairs
     * This is a more performant way to populate activity lists instead of downloading entire activity object.
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show activity key/value pairs associated with this hotel identifier
     * @param accept The accept parameter
     * @return List&lt;KeyValuePair&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showActivityPairsRequestCreation(String hotelIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showActivityPairs", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<KeyValuePair> localVarReturnType = new ParameterizedTypeReference<KeyValuePair>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/activity/list/pair", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Activities as key/value pairs
     * This is a more performant way to populate activity lists instead of downloading entire activity object.
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show activity key/value pairs associated with this hotel identifier
     * @param accept The accept parameter
     * @return List&lt;KeyValuePair&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<KeyValuePair> showActivityPairs(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePair> localVarReturnType = new ParameterizedTypeReference<KeyValuePair>() {};
        return showActivityPairsRequestCreation(hotelIdentifier, accept).bodyToFlux(localVarReturnType);
    }

    public Mono<ResponseEntity<List<KeyValuePair>>> showActivityPairsWithHttpInfo(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePair> localVarReturnType = new ParameterizedTypeReference<KeyValuePair>() {};
        return showActivityPairsRequestCreation(hotelIdentifier, accept).toEntityList(localVarReturnType);
    }
    /**
     * Update Activity
     * Update a recreation by its identifier
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update existing activity record owned by this hotel identifier
     * @param activityIdentifier Update activity record with this identifier
     * @param upsertActivityRequest The upsertActivityRequest parameter
     * @return RecreationView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateActivityRequestCreation(String hotelIdentifier, String activityIdentifier, UpsertActivityRequest upsertActivityRequest) throws WebClientResponseException {
        Object postBody = upsertActivityRequest;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling updateActivity", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'activityIdentifier' is set
        if (activityIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'activityIdentifier' when calling updateActivity", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertActivityRequest' is set
        if (upsertActivityRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertActivityRequest' when calling updateActivity", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("activityIdentifier", activityIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<RecreationView> localVarReturnType = new ParameterizedTypeReference<RecreationView>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/activity/{activityIdentifier}", HttpMethod.PUT, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Activity
     * Update a recreation by its identifier
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update existing activity record owned by this hotel identifier
     * @param activityIdentifier Update activity record with this identifier
     * @param upsertActivityRequest The upsertActivityRequest parameter
     * @return RecreationView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RecreationView> updateActivity(String hotelIdentifier, String activityIdentifier, UpsertActivityRequest upsertActivityRequest) throws WebClientResponseException {
        ParameterizedTypeReference<RecreationView> localVarReturnType = new ParameterizedTypeReference<RecreationView>() {};
        return updateActivityRequestCreation(hotelIdentifier, activityIdentifier, upsertActivityRequest).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<RecreationView>> updateActivityWithHttpInfo(String hotelIdentifier, String activityIdentifier, UpsertActivityRequest upsertActivityRequest) throws WebClientResponseException {
        ParameterizedTypeReference<RecreationView> localVarReturnType = new ParameterizedTypeReference<RecreationView>() {};
        return updateActivityRequestCreation(hotelIdentifier, activityIdentifier, upsertActivityRequest).toEntity(localVarReturnType);
    }
    /**
     * Upload Binary Multimedia
     * Upload a list of binary / multipart videos and/or images to an existing add-on.
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>207</b> - Multi-Status
     * @param hotelIdentifier Upload multipart media for activity owned by this hotel identifier
     * @param activityIdentifier Associate multipart media with activity identified by this identifier
     * @param files The files parameter
     * @return RecreationView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec uploadActivityMediaRequestCreation(String hotelIdentifier, String activityIdentifier, List<File> files) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling uploadActivityMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'activityIdentifier' is set
        if (activityIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'activityIdentifier' when calling uploadActivityMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'files' is set
        if (files == null) {
            throw new WebClientResponseException("Missing the required parameter 'files' when calling uploadActivityMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("activityIdentifier", activityIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (files != null)
            formParams.addAll("files", files.stream().map(FileSystemResource::new).collect(Collectors.toList()));

        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "multipart/form-data"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<RecreationView> localVarReturnType = new ParameterizedTypeReference<RecreationView>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/activity/{activityIdentifier}/multimedia", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Upload Binary Multimedia
     * Upload a list of binary / multipart videos and/or images to an existing add-on.
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>207</b> - Multi-Status
     * @param hotelIdentifier Upload multipart media for activity owned by this hotel identifier
     * @param activityIdentifier Associate multipart media with activity identified by this identifier
     * @param files The files parameter
     * @return RecreationView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RecreationView> uploadActivityMedia(String hotelIdentifier, String activityIdentifier, List<File> files) throws WebClientResponseException {
        ParameterizedTypeReference<RecreationView> localVarReturnType = new ParameterizedTypeReference<RecreationView>() {};
        return uploadActivityMediaRequestCreation(hotelIdentifier, activityIdentifier, files).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<RecreationView>> uploadActivityMediaWithHttpInfo(String hotelIdentifier, String activityIdentifier, List<File> files) throws WebClientResponseException {
        ParameterizedTypeReference<RecreationView> localVarReturnType = new ParameterizedTypeReference<RecreationView>() {};
        return uploadActivityMediaRequestCreation(hotelIdentifier, activityIdentifier, files).toEntity(localVarReturnType);
    }
}
