/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.NotNull;

@JsonPropertyOrder(value={"identifier", "enabled", "blacklisted", "percentDiscount", "commission", "rateModifierIdentifiers", "rateModifierBundleIdentifiers"})
public class SalesChannelUpdateRequest {
    public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
    private String identifier;
    public static final String JSON_PROPERTY_ENABLED = "enabled";
    private Boolean enabled = true;
    public static final String JSON_PROPERTY_BLACKLISTED = "blacklisted";
    private Boolean blacklisted = true;
    public static final String JSON_PROPERTY_PERCENT_DISCOUNT = "percentDiscount";
    private Float percentDiscount;
    public static final String JSON_PROPERTY_COMMISSION = "commission";
    private Float commission;
    public static final String JSON_PROPERTY_RATE_MODIFIER_IDENTIFIERS = "rateModifierIdentifiers";
    private List<String> rateModifierIdentifiers = null;
    public static final String JSON_PROPERTY_RATE_MODIFIER_BUNDLE_IDENTIFIERS = "rateModifierBundleIdentifiers";
    private List<String> rateModifierBundleIdentifiers = null;

    public SalesChannelUpdateRequest identifier(String identifier) {
        this.identifier = identifier;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="sales-channel-1", required=true, value="Unique record identifier")
    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public SalesChannelUpdateRequest enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="true", required=true, value="Flag the supplier can use to enable / disable a sales channel")
    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getEnabled() {
        return this.enabled;
    }

    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public SalesChannelUpdateRequest blacklisted(Boolean blacklisted) {
        this.blacklisted = blacklisted;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="true", required=true, value="Flag the supplier can use to ignore a sales channel")
    @JsonProperty(value="blacklisted")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getBlacklisted() {
        return this.blacklisted;
    }

    @JsonProperty(value="blacklisted")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setBlacklisted(Boolean blacklisted) {
        this.blacklisted = blacklisted;
    }

    public SalesChannelUpdateRequest percentDiscount(Float percentDiscount) {
        this.percentDiscount = percentDiscount;
        return this;
    }

    @Nonnull
    @NotNull
    @DecimalMin(value="0.0")
    @DecimalMax(value="1.0")
    @ApiModelProperty(example="0.15", required=true, value="Percent discount on this channel and all its children [unless configured at the child level].")
    @JsonProperty(value="percentDiscount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @DecimalMin(value="0.0") @DecimalMax(value="1.0") Float getPercentDiscount() {
        return this.percentDiscount;
    }

    @JsonProperty(value="percentDiscount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPercentDiscount(Float percentDiscount) {
        this.percentDiscount = percentDiscount;
    }

    public SalesChannelUpdateRequest commission(Float commission) {
        this.commission = commission;
        return this;
    }

    @Nonnull
    @NotNull
    @DecimalMin(value="0.0")
    @DecimalMax(value="1.0")
    @ApiModelProperty(example="0.2", required=true, value="Amount of sales commission earned through this channel and all its children [unless configured at the child level].")
    @JsonProperty(value="commission")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @DecimalMin(value="0.0") @DecimalMax(value="1.0") Float getCommission() {
        return this.commission;
    }

    @JsonProperty(value="commission")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCommission(Float commission) {
        this.commission = commission;
    }

    public SalesChannelUpdateRequest rateModifierIdentifiers(List<String> rateModifierIdentifiers) {
        this.rateModifierIdentifiers = rateModifierIdentifiers;
        return this;
    }

    public SalesChannelUpdateRequest addRateModifierIdentifiersItem(String rateModifierIdentifiersItem) {
        if (this.rateModifierIdentifiers == null) {
            this.rateModifierIdentifiers = new ArrayList<String>();
        }
        this.rateModifierIdentifiers.add(rateModifierIdentifiersItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"promo-1\",\"promo-2\"]", value="Unique identifiers of promotions you would like to apply to this channel and all its children [unless configured at the child level].")
    @JsonProperty(value="rateModifierIdentifiers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getRateModifierIdentifiers() {
        return this.rateModifierIdentifiers;
    }

    @JsonProperty(value="rateModifierIdentifiers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRateModifierIdentifiers(List<String> rateModifierIdentifiers) {
        this.rateModifierIdentifiers = rateModifierIdentifiers;
    }

    public SalesChannelUpdateRequest rateModifierBundleIdentifiers(List<String> rateModifierBundleIdentifiers) {
        this.rateModifierBundleIdentifiers = rateModifierBundleIdentifiers;
        return this;
    }

    public SalesChannelUpdateRequest addRateModifierBundleIdentifiersItem(String rateModifierBundleIdentifiersItem) {
        if (this.rateModifierBundleIdentifiers == null) {
            this.rateModifierBundleIdentifiers = new ArrayList<String>();
        }
        this.rateModifierBundleIdentifiers.add(rateModifierBundleIdentifiersItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"promo-ancillary-1\",\"promo-ancillary-2\"]", value="Unique identifiers of promotion bundles you would like to apply to this channel and all its children [unless configured at the child level].")
    @JsonProperty(value="rateModifierBundleIdentifiers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getRateModifierBundleIdentifiers() {
        return this.rateModifierBundleIdentifiers;
    }

    @JsonProperty(value="rateModifierBundleIdentifiers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRateModifierBundleIdentifiers(List<String> rateModifierBundleIdentifiers) {
        this.rateModifierBundleIdentifiers = rateModifierBundleIdentifiers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SalesChannelUpdateRequest salesChannelUpdateRequest = (SalesChannelUpdateRequest)o;
        return Objects.equals(this.identifier, salesChannelUpdateRequest.identifier) && Objects.equals(this.enabled, salesChannelUpdateRequest.enabled) && Objects.equals(this.blacklisted, salesChannelUpdateRequest.blacklisted) && Objects.equals(this.percentDiscount, salesChannelUpdateRequest.percentDiscount) && Objects.equals(this.commission, salesChannelUpdateRequest.commission) && Objects.equals(this.rateModifierIdentifiers, salesChannelUpdateRequest.rateModifierIdentifiers) && Objects.equals(this.rateModifierBundleIdentifiers, salesChannelUpdateRequest.rateModifierBundleIdentifiers);
    }

    public int hashCode() {
        return Objects.hash(this.identifier, this.enabled, this.blacklisted, this.percentDiscount, this.commission, this.rateModifierIdentifiers, this.rateModifierBundleIdentifiers);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SalesChannelUpdateRequest {\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    blacklisted: ").append(this.toIndentedString(this.blacklisted)).append("\n");
        sb.append("    percentDiscount: ").append(this.toIndentedString(this.percentDiscount)).append("\n");
        sb.append("    commission: ").append(this.toIndentedString(this.commission)).append("\n");
        sb.append("    rateModifierIdentifiers: ").append(this.toIndentedString(this.rateModifierIdentifiers)).append("\n");
        sb.append("    rateModifierBundleIdentifiers: ").append(this.toIndentedString(this.rateModifierBundleIdentifiers)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

