/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/docs?api=affiliate): All APIs related to selling travel inventory as an affiliate. - [Extranet](/docs?api=extranet): All APIs related to managing travel inventory and suppliers. - [Booking Engine](/docs?api=booking-engine): All APIs related to searching for travel inventory and creating bookings. - [Channel Manager](/docs?api=channel-manager): All APIs related to channel managers who want to integrate with our payment.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.payment-v`1`+json.  ## Release history - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Extranet API Welcome to the Extranet API - A programmer-friendly way to manage your travel inventory on the wink payment. This API offers a superset of the features you can find at [https://extranet.wink.travel](https://extranet.wink.travel) and gives you all the tools you need to ready your properties and inventory for sale across 10000s of our unique sales channels. What differentiates us from existing Extranets is 1. we make it available for everyone to use and 2. the care we take in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Content creators have the ability to make their inventory look great and be searchable in a wide variety of ways. You won't find properties with generic inventory, low resolution pictures and little ancillary content that can easily be found everywhere else on the internet.  # Integrations We have already integrated with the most well-known channel managers so you don't have to. Once your properties are set up, you can finish the setup by mapping your property to wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API. - Allotz - CloudBeds / MyAllocator - Comanche - d-edge - FastBooking - HotelLink - HoteliersGuru - Omnibees - RateGain - Rate Tiger - ResAvenue - Siteminder - Sabre SynXis - Travelclick - Yieldplanet  # Intended Audience Programmers are [most likely] a requirement to start integrating with wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible. - Hotel chains - Hotel brands - Travel tech companies - Destination sites - Integrators - Aggregators - Destination management companies - Travel agencies - OTAs  
 *
 * The version of the OpenAPI document: 20.1.2-SNAPSHOT
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.extranet.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import travel.wink.sdk.extranet.model.Address;
import travel.wink.sdk.extranet.model.AggregateGreendexAnswers;
import travel.wink.sdk.extranet.model.Contact;
import travel.wink.sdk.extranet.model.GeoJsonPoint;
import travel.wink.sdk.extranet.model.Multimedia;
import travel.wink.sdk.extranet.model.PropertyPolicy;
import travel.wink.sdk.extranet.model.SimpleDescription;
import travel.wink.sdk.extranet.model.Social;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Hotel data
 */
@ApiModel(description = "Hotel data")
@JsonPropertyOrder({
  Hotel.JSON_PROPERTY_HOTEL_IDENTIFIER,
  Hotel.JSON_PROPERTY_NAME,
  Hotel.JSON_PROPERTY_HOTEL_CODE,
  Hotel.JSON_PROPERTY_HOTEL_CODE_CONTEXT,
  Hotel.JSON_PROPERTY_LOCAL_NAME,
  Hotel.JSON_PROPERTY_LEGAL_NAME,
  Hotel.JSON_PROPERTY_URL_NAME,
  Hotel.JSON_PROPERTY_CURRENCY_CODE,
  Hotel.JSON_PROPERTY_STATUS,
  Hotel.JSON_PROPERTY_EXTERNAL_STATUS,
  Hotel.JSON_PROPERTY_MULTIMEDIA_IDENTIFIER,
  Hotel.JSON_PROPERTY_IMAGE_IDENTIFIER,
  Hotel.JSON_PROPERTY_IMAGE_ANGLE,
  Hotel.JSON_PROPERTY_LOCATION_CATEGORY,
  Hotel.JSON_PROPERTY_SEGMENT_CATEGORY,
  Hotel.JSON_PROPERTY_HOTEL_CATEGORY,
  Hotel.JSON_PROPERTY_ARCHITECTURAL_STYLE,
  Hotel.JSON_PROPERTY_WHEN_BUILT,
  Hotel.JSON_PROPERTY_HOTEL_CHAIN,
  Hotel.JSON_PROPERTY_HOTEL_BRAND,
  Hotel.JSON_PROPERTY_CHANNEL_MANAGER,
  Hotel.JSON_PROPERTY_OTHER_CHANNEL_MANAGER,
  Hotel.JSON_PROPERTY_LICENSE_NUMBER,
  Hotel.JSON_PROPERTY_STARS,
  Hotel.JSON_PROPERTY_FULL_NAME_OF_GENERAL_MANAGER,
  Hotel.JSON_PROPERTY_PROFILE_PICTURE_IDENTIFIER_GENERAL_MANAGER,
  Hotel.JSON_PROPERTY_MESSAGES_OF_GENERAL_MANAGER,
  Hotel.JSON_PROPERTY_SHORT_DESCRIPTIONS,
  Hotel.JSON_PROPERTY_LONG_DESCRIPTIONS,
  Hotel.JSON_PROPERTY_HOTEL_AMENITY_CODES,
  Hotel.JSON_PROPERTY_PROPERTY_ACCESSIBILITY_CODES,
  Hotel.JSON_PROPERTY_PROPERTY_SECURITY_CODES,
  Hotel.JSON_PROPERTY_LOCATION_POINT,
  Hotel.JSON_PROPERTY_POLICY,
  Hotel.JSON_PROPERTY_SOCIALS,
  Hotel.JSON_PROPERTY_OWNER_CONTACT,
  Hotel.JSON_PROPERTY_RESERVATIONS_CONTACT,
  Hotel.JSON_PROPERTY_ACCOUNTING_CONTACT,
  Hotel.JSON_PROPERTY_ACCOUNTING_ADDRESS,
  Hotel.JSON_PROPERTY_LIFESTYLE_TYPES,
  Hotel.JSON_PROPERTY_AGREEMENT_ACCEPTED,
  Hotel.JSON_PROPERTY_MARKETING_OPTIN_ALLOWED,
  Hotel.JSON_PROPERTY_LOGOS,
  Hotel.JSON_PROPERTY_NUMBER_OF_ROOMS,
  Hotel.JSON_PROPERTY_ADDRESS,
  Hotel.JSON_PROPERTY_ACTIVE,
  Hotel.JSON_PROPERTY_GENERAL_MANAGER_WELCOME_MESSAGE,
  Hotel.JSON_PROPERTY_PROPERTY_ACTIVE,
  Hotel.JSON_PROPERTY_PLATFORM_ACTIVE,
  Hotel.JSON_PROPERTY_CONTRACT_SIGNER_FULL_NAME,
  Hotel.JSON_PROPERTY_FULL_ADDRESS,
  Hotel.JSON_PROPERTY_SOCIAL_NETWORKS,
  Hotel.JSON_PROPERTY_LIFESTYLES,
  Hotel.JSON_PROPERTY_GREEN_INDEX_SCORES
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-06-20T21:56:24.013599+07:00[Asia/Bangkok]")
public class Hotel {
  public static final String JSON_PROPERTY_HOTEL_IDENTIFIER = "hotelIdentifier";
  private String hotelIdentifier;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_HOTEL_CODE = "hotelCode";
  private String hotelCode;

  public static final String JSON_PROPERTY_HOTEL_CODE_CONTEXT = "hotelCodeContext";
  private String hotelCodeContext;

  public static final String JSON_PROPERTY_LOCAL_NAME = "localName";
  private String localName;

  public static final String JSON_PROPERTY_LEGAL_NAME = "legalName";
  private String legalName;

  public static final String JSON_PROPERTY_URL_NAME = "urlName";
  private String urlName;

  public static final String JSON_PROPERTY_CURRENCY_CODE = "currencyCode";
  private String currencyCode;

  /**
   * wink.travel sets this status as the hotel moves through the payment workflow and manually for approval.
   */
  public enum StatusEnum {
    ACTIVE("ACTIVE"),
    
    DISABLED("DISABLED"),
    
    SUSPENDED("SUSPENDED"),
    
    REMOVED("REMOVED"),
    
    WAITING_ON_CONTRACT("WAITING_ON_CONTRACT"),
    
    CONTRACT_SIGNED("CONTRACT_SIGNED");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_STATUS = "status";
  private StatusEnum status = StatusEnum.WAITING_ON_CONTRACT;

  public static final String JSON_PROPERTY_EXTERNAL_STATUS = "externalStatus";
  private String externalStatus = "6";

  public static final String JSON_PROPERTY_MULTIMEDIA_IDENTIFIER = "multimediaIdentifier";
  private String multimediaIdentifier;

  public static final String JSON_PROPERTY_IMAGE_IDENTIFIER = "imageIdentifier";
  private String imageIdentifier;

  public static final String JSON_PROPERTY_IMAGE_ANGLE = "imageAngle";
  private String imageAngle;

  public static final String JSON_PROPERTY_LOCATION_CATEGORY = "locationCategory";
  private String locationCategory;

  public static final String JSON_PROPERTY_SEGMENT_CATEGORY = "segmentCategory";
  private String segmentCategory;

  public static final String JSON_PROPERTY_HOTEL_CATEGORY = "hotelCategory";
  private String hotelCategory;

  public static final String JSON_PROPERTY_ARCHITECTURAL_STYLE = "architecturalStyle";
  private String architecturalStyle;

  public static final String JSON_PROPERTY_WHEN_BUILT = "whenBuilt";
  private String whenBuilt;

  public static final String JSON_PROPERTY_HOTEL_CHAIN = "hotelChain";
  private String hotelChain;

  public static final String JSON_PROPERTY_HOTEL_BRAND = "hotelBrand";
  private String hotelBrand;

  /**
   * Property&#39;s channel manager. Rate ownership is decided based on the channel manager selected. Defaults to &#x60;TRAVELIKO&#x60; which is the same as no channel manager and rate ownership goes to the payment.
   */
  public enum ChannelManagerEnum {
    TRAVELIKO("TRAVELIKO"),
    
    SITEMINDER("SITEMINDER"),
    
    FASTBOOKING("FASTBOOKING"),
    
    RATEGAIN("RATEGAIN"),
    
    CLOUD_BEDS("CLOUD_BEDS"),
    
    YIELD_PLANET("YIELD_PLANET"),
    
    TRAVELCLICK("TRAVELCLICK"),
    
    HOTEL_GURU("HOTEL_GURU"),
    
    OTHER_CHANNEL_MANAGER("OTHER_CHANNEL_MANAGER"),
    
    BOOKING_JINI("BOOKING_JINI"),
    
    HOTEL_LINK_SOLUTIONS("HOTEL_LINK_SOLUTIONS"),
    
    ALLOTZ("ALLOTZ"),
    
    DEDGE("DEDGE"),
    
    RATE_TIGER("RATE_TIGER"),
    
    RESAVENUE("RESAVENUE"),
    
    COMANCHE("COMANCHE"),
    
    OMNIBEES("OMNIBEES"),
    
    EZEE("EZEE"),
    
    SYNXIS("SYNXIS");

    private String value;

    ChannelManagerEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ChannelManagerEnum fromValue(String value) {
      for (ChannelManagerEnum b : ChannelManagerEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_CHANNEL_MANAGER = "channelManager";
  private ChannelManagerEnum channelManager = ChannelManagerEnum.TRAVELIKO;

  public static final String JSON_PROPERTY_OTHER_CHANNEL_MANAGER = "otherChannelManager";
  private String otherChannelManager;

  public static final String JSON_PROPERTY_LICENSE_NUMBER = "licenseNumber";
  private String licenseNumber;

  public static final String JSON_PROPERTY_STARS = "stars";
  private Integer stars;

  public static final String JSON_PROPERTY_FULL_NAME_OF_GENERAL_MANAGER = "fullNameOfGeneralManager";
  private String fullNameOfGeneralManager;

  public static final String JSON_PROPERTY_PROFILE_PICTURE_IDENTIFIER_GENERAL_MANAGER = "profilePictureIdentifierGeneralManager";
  private String profilePictureIdentifierGeneralManager;

  public static final String JSON_PROPERTY_MESSAGES_OF_GENERAL_MANAGER = "messagesOfGeneralManager";
  private List<SimpleDescription> messagesOfGeneralManager = null;

  public static final String JSON_PROPERTY_SHORT_DESCRIPTIONS = "shortDescriptions";
  private List<SimpleDescription> shortDescriptions = null;

  public static final String JSON_PROPERTY_LONG_DESCRIPTIONS = "longDescriptions";
  private List<SimpleDescription> longDescriptions = null;

  public static final String JSON_PROPERTY_HOTEL_AMENITY_CODES = "hotelAmenityCodes";
  private List<String> hotelAmenityCodes = null;

  public static final String JSON_PROPERTY_PROPERTY_ACCESSIBILITY_CODES = "propertyAccessibilityCodes";
  private List<String> propertyAccessibilityCodes = null;

  public static final String JSON_PROPERTY_PROPERTY_SECURITY_CODES = "propertySecurityCodes";
  private List<String> propertySecurityCodes = null;

  public static final String JSON_PROPERTY_LOCATION_POINT = "locationPoint";
  private GeoJsonPoint locationPoint;

  public static final String JSON_PROPERTY_POLICY = "policy";
  private PropertyPolicy policy;

  public static final String JSON_PROPERTY_SOCIALS = "socials";
  private List<Social> socials = null;

  public static final String JSON_PROPERTY_OWNER_CONTACT = "ownerContact";
  private Contact ownerContact;

  public static final String JSON_PROPERTY_RESERVATIONS_CONTACT = "reservationsContact";
  private Contact reservationsContact;

  public static final String JSON_PROPERTY_ACCOUNTING_CONTACT = "accountingContact";
  private Contact accountingContact;

  public static final String JSON_PROPERTY_ACCOUNTING_ADDRESS = "accountingAddress";
  private Address accountingAddress;

  /**
   * List of all lifestyles property has associated with. See [Lifestyle geoname data](#operation/showLifestyles)
   */
  public enum LifestyleTypesEnum {
    HEALTH_FITNESS("LIFESTYLE_HEALTH_FITNESS"),
    
    RELAX("LIFESTYLE_RELAX"),
    
    ADULT_ONLY("LIFESTYLE_ADULT_ONLY"),
    
    ADVENTURE("LIFESTYLE_ADVENTURE"),
    
    BUSINESS("LIFESTYLE_BUSINESS"),
    
    LGBT("LIFESTYLE_LGBT"),
    
    SINGLE_PARENT("LIFESTYLE_SINGLE_PARENT"),
    
    SOLO_FEMALE("LIFESTYLE_SOLO_FEMALE"),
    
    BEAUTY("LIFESTYLE_BEAUTY"),
    
    FOODIE("LIFESTYLE_FOODIE"),
    
    FAMILY("LIFESTYLE_FAMILY"),
    
    ROMANCE("LIFESTYLE_ROMANCE"),
    
    COUPLE("LIFESTYLE_COUPLE"),
    
    SOLO("LIFESTYLE_SOLO"),
    
    BACKPACKER("LIFESTYLE_BACKPACKER"),
    
    SHOPPING("LIFESTYLE_SHOPPING"),
    
    SPORTS("LIFESTYLE_SPORTS"),
    
    MOUNTAIN("LIFESTYLE_MOUNTAIN"),
    
    BEACH("LIFESTYLE_BEACH"),
    
    CITY("LIFESTYLE_CITY"),
    
    COUNTRY("LIFESTYLE_COUNTRY"),
    
    CULTURE("LIFESTYLE_CULTURE"),
    
    ECO("LIFESTYLE_ECO");

    private String value;

    LifestyleTypesEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static LifestyleTypesEnum fromValue(String value) {
      for (LifestyleTypesEnum b : LifestyleTypesEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_LIFESTYLE_TYPES = "lifestyleTypes";
  private List<LifestyleTypesEnum> lifestyleTypes = null;

  public static final String JSON_PROPERTY_AGREEMENT_ACCEPTED = "agreementAccepted";
  private Boolean agreementAccepted;

  public static final String JSON_PROPERTY_MARKETING_OPTIN_ALLOWED = "marketingOptinAllowed";
  private Boolean marketingOptinAllowed;

  public static final String JSON_PROPERTY_LOGOS = "logos";
  private List<Multimedia> logos = null;

  public static final String JSON_PROPERTY_NUMBER_OF_ROOMS = "numberOfRooms";
  private Integer numberOfRooms;

  public static final String JSON_PROPERTY_ADDRESS = "address";
  private Address address;

  public static final String JSON_PROPERTY_ACTIVE = "active";
  private Boolean active;

  public static final String JSON_PROPERTY_GENERAL_MANAGER_WELCOME_MESSAGE = "generalManagerWelcomeMessage";
  private Boolean generalManagerWelcomeMessage;

  public static final String JSON_PROPERTY_PROPERTY_ACTIVE = "propertyActive";
  private Boolean propertyActive;

  public static final String JSON_PROPERTY_PLATFORM_ACTIVE = "platformActive";
  private Boolean platformActive;

  public static final String JSON_PROPERTY_CONTRACT_SIGNER_FULL_NAME = "contractSignerFullName";
  private String contractSignerFullName;

  public static final String JSON_PROPERTY_FULL_ADDRESS = "fullAddress";
  private String fullAddress;

  public static final String JSON_PROPERTY_SOCIAL_NETWORKS = "socialNetworks";
  private Boolean socialNetworks;

  public static final String JSON_PROPERTY_LIFESTYLES = "lifestyles";
  private Boolean lifestyles;

  public static final String JSON_PROPERTY_GREEN_INDEX_SCORES = "greenIndexScores";
  private AggregateGreendexAnswers greenIndexScores;

  public Hotel() { 
  }

  public Hotel hotelIdentifier(String hotelIdentifier) {
    
    this.hotelIdentifier = hotelIdentifier;
    return this;
  }

   /**
   * Unique hotel identifier
   * @return hotelIdentifier
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "hotel-1", required = true, value = "Unique hotel identifier")
  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getHotelIdentifier() {
    return hotelIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setHotelIdentifier(String hotelIdentifier) {
    this.hotelIdentifier = hotelIdentifier;
  }


  public Hotel name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Unique hotel trade name. The hotel name must be unique. If there are multiple hotels with the same name, we recommend appending destination to the name. [Verify uniqueness here](#operation/isHotelNameUnique).
   * @return name
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "The Getaway resort - Ubud", required = true, value = "Unique hotel trade name. The hotel name must be unique. If there are multiple hotels with the same name, we recommend appending destination to the name. [Verify uniqueness here](#operation/isHotelNameUnique).")
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(String name) {
    this.name = name;
  }


  public Hotel hotelCode(String hotelCode) {
    
    this.hotelCode = hotelCode;
    return this;
  }

   /**
   * A shorter unique code to refer to the hotel. Country Code + 5 digit number
   * @return hotelCode
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "IN00011", required = true, value = "A shorter unique code to refer to the hotel. Country Code + 5 digit number")
  @JsonProperty(JSON_PROPERTY_HOTEL_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getHotelCode() {
    return hotelCode;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setHotelCode(String hotelCode) {
    this.hotelCode = hotelCode;
  }


  public Hotel hotelCodeContext(String hotelCodeContext) {
    
    this.hotelCodeContext = hotelCodeContext;
    return this;
  }

   /**
   * Origin of hotel data
   * @return hotelCodeContext
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "wink.travel", required = true, value = "Origin of hotel data")
  @JsonProperty(JSON_PROPERTY_HOTEL_CODE_CONTEXT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getHotelCodeContext() {
    return hotelCodeContext;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_CODE_CONTEXT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setHotelCodeContext(String hotelCodeContext) {
    this.hotelCodeContext = hotelCodeContext;
  }


  public Hotel localName(String localName) {
    
    this.localName = localName;
    return this;
  }

   /**
   * Name of the hotel in its local language if you use it for domestic guests.
   * @return localName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "Resor Ubud Getaway", value = "Name of the hotel in its local language if you use it for domestic guests.")
  @JsonProperty(JSON_PROPERTY_LOCAL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLocalName() {
    return localName;
  }


  @JsonProperty(JSON_PROPERTY_LOCAL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLocalName(String localName) {
    this.localName = localName;
  }


  public Hotel legalName(String legalName) {
    
    this.legalName = legalName;
    return this;
  }

   /**
   * Legal name of your hotel as it is registered.
   * @return legalName
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "Getaway Resorts Limited", required = true, value = "Legal name of your hotel as it is registered.")
  @JsonProperty(JSON_PROPERTY_LEGAL_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getLegalName() {
    return legalName;
  }


  @JsonProperty(JSON_PROPERTY_LEGAL_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setLegalName(String legalName) {
    this.legalName = legalName;
  }


  public Hotel urlName(String urlName) {
    
    this.urlName = urlName;
    return this;
  }

   /**
   * Unique url-friendly slug to identify property
   * @return urlName
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "the-getaway-resort-ubud-indonesia", required = true, value = "Unique url-friendly slug to identify property")
  @JsonProperty(JSON_PROPERTY_URL_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getUrlName() {
    return urlName;
  }


  @JsonProperty(JSON_PROPERTY_URL_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setUrlName(String urlName) {
    this.urlName = urlName;
  }


  public Hotel currencyCode(String currencyCode) {
    
    this.currencyCode = currencyCode;
    return this;
  }

   /**
   * Currency code
   * @return currencyCode
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "INR", required = true, value = "Currency code")
  @JsonProperty(JSON_PROPERTY_CURRENCY_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getCurrencyCode() {
    return currencyCode;
  }


  @JsonProperty(JSON_PROPERTY_CURRENCY_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCurrencyCode(String currencyCode) {
    this.currencyCode = currencyCode;
  }


  public Hotel status(StatusEnum status) {
    
    this.status = status;
    return this;
  }

   /**
   * wink.travel sets this status as the hotel moves through the payment workflow and manually for approval.
   * @return status
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "ACTIVE", required = true, value = "wink.travel sets this status as the hotel moves through the payment workflow and manually for approval.")
  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public StatusEnum getStatus() {
    return status;
  }


  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setStatus(StatusEnum status) {
    this.status = status;
  }


  public Hotel externalStatus(String externalStatus) {
    
    this.externalStatus = externalStatus;
    return this;
  }

   /**
   * Property goes active by changing externalStatus from 6 (Inactive) to 1 (Active) according to OTA property status.
   * @return externalStatus
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "1", required = true, value = "Property goes active by changing externalStatus from 6 (Inactive) to 1 (Active) according to OTA property status.")
  @JsonProperty(JSON_PROPERTY_EXTERNAL_STATUS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getExternalStatus() {
    return externalStatus;
  }


  @JsonProperty(JSON_PROPERTY_EXTERNAL_STATUS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setExternalStatus(String externalStatus) {
    this.externalStatus = externalStatus;
  }


  public Hotel multimediaIdentifier(String multimediaIdentifier) {
    
    this.multimediaIdentifier = multimediaIdentifier;
    return this;
  }

   /**
   * Featured property image document identifier. This is the image that is ordered first in the list of property images.
   * @return multimediaIdentifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "multimedia-1", value = "Featured property image document identifier. This is the image that is ordered first in the list of property images.")
  @JsonProperty(JSON_PROPERTY_MULTIMEDIA_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMultimediaIdentifier() {
    return multimediaIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_MULTIMEDIA_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMultimediaIdentifier(String multimediaIdentifier) {
    this.multimediaIdentifier = multimediaIdentifier;
  }


  public Hotel imageIdentifier(String imageIdentifier) {
    
    this.imageIdentifier = imageIdentifier;
    return this;
  }

   /**
   * Featured Cloudinary identifier that can be used directly to retrieve media from Cloudinary.
   * @return imageIdentifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "cloudinary-image-1", value = "Featured Cloudinary identifier that can be used directly to retrieve media from Cloudinary.")
  @JsonProperty(JSON_PROPERTY_IMAGE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getImageIdentifier() {
    return imageIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_IMAGE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setImageIdentifier(String imageIdentifier) {
    this.imageIdentifier = imageIdentifier;
  }


  public Hotel imageAngle(String imageAngle) {
    
    this.imageAngle = imageAngle;
    return this;
  }

   /**
   * Featured image angle (if available).
   * @return imageAngle
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "-90", value = "Featured image angle (if available).")
  @JsonProperty(JSON_PROPERTY_IMAGE_ANGLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getImageAngle() {
    return imageAngle;
  }


  @JsonProperty(JSON_PROPERTY_IMAGE_ANGLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setImageAngle(String imageAngle) {
    this.imageAngle = imageAngle;
  }


  public Hotel locationCategory(String locationCategory) {
    
    this.locationCategory = locationCategory;
    return this;
  }

   /**
   * Supported OTA specification &#x60;LOC&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return locationCategory
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "34", value = "Supported OTA specification `LOC` code. See [OTA geoname data](#operation/showAvailableCodesForCategory)")
  @JsonProperty(JSON_PROPERTY_LOCATION_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLocationCategory() {
    return locationCategory;
  }


  @JsonProperty(JSON_PROPERTY_LOCATION_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLocationCategory(String locationCategory) {
    this.locationCategory = locationCategory;
  }


  public Hotel segmentCategory(String segmentCategory) {
    
    this.segmentCategory = segmentCategory;
    return this;
  }

   /**
   * Supported OTA specification &#x60;SEG&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return segmentCategory
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "7", value = "Supported OTA specification `SEG` code. See [OTA geoname data](#operation/showAvailableCodesForCategory)")
  @JsonProperty(JSON_PROPERTY_SEGMENT_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSegmentCategory() {
    return segmentCategory;
  }


  @JsonProperty(JSON_PROPERTY_SEGMENT_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSegmentCategory(String segmentCategory) {
    this.segmentCategory = segmentCategory;
  }


  public Hotel hotelCategory(String hotelCategory) {
    
    this.hotelCategory = hotelCategory;
    return this;
  }

   /**
   * Supported OTA specification &#x60;PCT&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return hotelCategory
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "45", value = "Supported OTA specification `PCT` code. See [OTA geoname data](#operation/showAvailableCodesForCategory)")
  @JsonProperty(JSON_PROPERTY_HOTEL_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getHotelCategory() {
    return hotelCategory;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHotelCategory(String hotelCategory) {
    this.hotelCategory = hotelCategory;
  }


  public Hotel architecturalStyle(String architecturalStyle) {
    
    this.architecturalStyle = architecturalStyle;
    return this;
  }

   /**
   * Supported OTA specification &#x60;ARC&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return architecturalStyle
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "7", value = "Supported OTA specification `ARC` code. See [OTA geoname data](#operation/showAvailableCodesForCategory)")
  @JsonProperty(JSON_PROPERTY_ARCHITECTURAL_STYLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getArchitecturalStyle() {
    return architecturalStyle;
  }


  @JsonProperty(JSON_PROPERTY_ARCHITECTURAL_STYLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setArchitecturalStyle(String architecturalStyle) {
    this.architecturalStyle = architecturalStyle;
  }


  public Hotel whenBuilt(String whenBuilt) {
    
    this.whenBuilt = whenBuilt;
    return this;
  }

   /**
   * Year the property was constructed.
   * @return whenBuilt
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "1927", value = "Year the property was constructed.")
  @JsonProperty(JSON_PROPERTY_WHEN_BUILT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getWhenBuilt() {
    return whenBuilt;
  }


  @JsonProperty(JSON_PROPERTY_WHEN_BUILT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWhenBuilt(String whenBuilt) {
    this.whenBuilt = whenBuilt;
  }


  public Hotel hotelChain(String hotelChain) {
    
    this.hotelChain = hotelChain;
    return this;
  }

   /**
   * Hotel chain name if property is part of that chain.
   * @return hotelChain
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "Getaway Resorts", value = "Hotel chain name if property is part of that chain.")
  @JsonProperty(JSON_PROPERTY_HOTEL_CHAIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getHotelChain() {
    return hotelChain;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_CHAIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHotelChain(String hotelChain) {
    this.hotelChain = hotelChain;
  }


  public Hotel hotelBrand(String hotelBrand) {
    
    this.hotelBrand = hotelBrand;
    return this;
  }

   /**
   * Hotel brand name if property is part of that brand.
   * @return hotelBrand
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "Happy Resorts", value = "Hotel brand name if property is part of that brand.")
  @JsonProperty(JSON_PROPERTY_HOTEL_BRAND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getHotelBrand() {
    return hotelBrand;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_BRAND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHotelBrand(String hotelBrand) {
    this.hotelBrand = hotelBrand;
  }


  public Hotel channelManager(ChannelManagerEnum channelManager) {
    
    this.channelManager = channelManager;
    return this;
  }

   /**
   * Property&#39;s channel manager. Rate ownership is decided based on the channel manager selected. Defaults to &#x60;TRAVELIKO&#x60; which is the same as no channel manager and rate ownership goes to the payment.
   * @return channelManager
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "OTHER_CHANNEL_MANAGER", value = "Property's channel manager. Rate ownership is decided based on the channel manager selected. Defaults to `TRAVELIKO` which is the same as no channel manager and rate ownership goes to the payment.")
  @JsonProperty(JSON_PROPERTY_CHANNEL_MANAGER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ChannelManagerEnum getChannelManager() {
    return channelManager;
  }


  @JsonProperty(JSON_PROPERTY_CHANNEL_MANAGER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setChannelManager(ChannelManagerEnum channelManager) {
    this.channelManager = channelManager;
  }


  public Hotel otherChannelManager(String otherChannelManager) {
    
    this.otherChannelManager = otherChannelManager;
    return this;
  }

   /**
   * If the property is currently using a channel manager but it isn&#39;t yet part of our list, chose &#39;OTHER_CHANNEL_MANAGER&#39; as channelManager and fill in the name of the channel manager here
   * @return otherChannelManager
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "CM X", value = "If the property is currently using a channel manager but it isn't yet part of our list, chose 'OTHER_CHANNEL_MANAGER' as channelManager and fill in the name of the channel manager here")
  @JsonProperty(JSON_PROPERTY_OTHER_CHANNEL_MANAGER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getOtherChannelManager() {
    return otherChannelManager;
  }


  @JsonProperty(JSON_PROPERTY_OTHER_CHANNEL_MANAGER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOtherChannelManager(String otherChannelManager) {
    this.otherChannelManager = otherChannelManager;
  }


  public Hotel licenseNumber(String licenseNumber) {
    
    this.licenseNumber = licenseNumber;
    return this;
  }

   /**
   * If the property has a valid license number to run a hotel in their country, add it here.
   * @return licenseNumber
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "ABC1234", value = "If the property has a valid license number to run a hotel in their country, add it here.")
  @JsonProperty(JSON_PROPERTY_LICENSE_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLicenseNumber() {
    return licenseNumber;
  }


  @JsonProperty(JSON_PROPERTY_LICENSE_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLicenseNumber(String licenseNumber) {
    this.licenseNumber = licenseNumber;
  }


  public Hotel stars(Integer stars) {
    
    this.stars = stars;
    return this;
  }

   /**
   * Hotel star rating.
   * minimum: 0
   * maximum: 6
   * @return stars
  **/
  @javax.annotation.Nullable
 @Min(0) @Max(6)  @ApiModelProperty(value = "Hotel star rating.")
  @JsonProperty(JSON_PROPERTY_STARS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getStars() {
    return stars;
  }


  @JsonProperty(JSON_PROPERTY_STARS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStars(Integer stars) {
    this.stars = stars;
  }


  public Hotel fullNameOfGeneralManager(String fullNameOfGeneralManager) {
    
    this.fullNameOfGeneralManager = fullNameOfGeneralManager;
    return this;
  }

   /**
   * Name of GM currently managing the property.
   * @return fullNameOfGeneralManager
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Name of GM currently managing the property.")
  @JsonProperty(JSON_PROPERTY_FULL_NAME_OF_GENERAL_MANAGER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFullNameOfGeneralManager() {
    return fullNameOfGeneralManager;
  }


  @JsonProperty(JSON_PROPERTY_FULL_NAME_OF_GENERAL_MANAGER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFullNameOfGeneralManager(String fullNameOfGeneralManager) {
    this.fullNameOfGeneralManager = fullNameOfGeneralManager;
  }


  public Hotel profilePictureIdentifierGeneralManager(String profilePictureIdentifierGeneralManager) {
    
    this.profilePictureIdentifierGeneralManager = profilePictureIdentifierGeneralManager;
    return this;
  }

   /**
   * Cloudinary image identifier of GM currently managing the property.
   * @return profilePictureIdentifierGeneralManager
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Cloudinary image identifier of GM currently managing the property.")
  @JsonProperty(JSON_PROPERTY_PROFILE_PICTURE_IDENTIFIER_GENERAL_MANAGER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getProfilePictureIdentifierGeneralManager() {
    return profilePictureIdentifierGeneralManager;
  }


  @JsonProperty(JSON_PROPERTY_PROFILE_PICTURE_IDENTIFIER_GENERAL_MANAGER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProfilePictureIdentifierGeneralManager(String profilePictureIdentifierGeneralManager) {
    this.profilePictureIdentifierGeneralManager = profilePictureIdentifierGeneralManager;
  }


  public Hotel messagesOfGeneralManager(List<SimpleDescription> messagesOfGeneralManager) {
    
    this.messagesOfGeneralManager = messagesOfGeneralManager;
    return this;
  }

  public Hotel addMessagesOfGeneralManagerItem(SimpleDescription messagesOfGeneralManagerItem) {
    if (this.messagesOfGeneralManager == null) {
      this.messagesOfGeneralManager = new ArrayList<>();
    }
    this.messagesOfGeneralManager.add(messagesOfGeneralManagerItem);
    return this;
  }

   /**
   * Personal welcome message from GM.
   * @return messagesOfGeneralManager
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Personal welcome message from GM.")
  @JsonProperty(JSON_PROPERTY_MESSAGES_OF_GENERAL_MANAGER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<SimpleDescription> getMessagesOfGeneralManager() {
    return messagesOfGeneralManager;
  }


  @JsonProperty(JSON_PROPERTY_MESSAGES_OF_GENERAL_MANAGER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMessagesOfGeneralManager(List<SimpleDescription> messagesOfGeneralManager) {
    this.messagesOfGeneralManager = messagesOfGeneralManager;
  }


  public Hotel shortDescriptions(List<SimpleDescription> shortDescriptions) {
    
    this.shortDescriptions = shortDescriptions;
    return this;
  }

  public Hotel addShortDescriptionsItem(SimpleDescription shortDescriptionsItem) {
    if (this.shortDescriptions == null) {
      this.shortDescriptions = new ArrayList<>();
    }
    this.shortDescriptions.add(shortDescriptionsItem);
    return this;
  }

   /**
   * Localized short descriptions of property.
   * @return shortDescriptions
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Localized short descriptions of property.")
  @JsonProperty(JSON_PROPERTY_SHORT_DESCRIPTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<SimpleDescription> getShortDescriptions() {
    return shortDescriptions;
  }


  @JsonProperty(JSON_PROPERTY_SHORT_DESCRIPTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShortDescriptions(List<SimpleDescription> shortDescriptions) {
    this.shortDescriptions = shortDescriptions;
  }


  public Hotel longDescriptions(List<SimpleDescription> longDescriptions) {
    
    this.longDescriptions = longDescriptions;
    return this;
  }

  public Hotel addLongDescriptionsItem(SimpleDescription longDescriptionsItem) {
    if (this.longDescriptions == null) {
      this.longDescriptions = new ArrayList<>();
    }
    this.longDescriptions.add(longDescriptionsItem);
    return this;
  }

   /**
   * Localized long descriptions of property.
   * @return longDescriptions
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Localized long descriptions of property.")
  @JsonProperty(JSON_PROPERTY_LONG_DESCRIPTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<SimpleDescription> getLongDescriptions() {
    return longDescriptions;
  }


  @JsonProperty(JSON_PROPERTY_LONG_DESCRIPTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLongDescriptions(List<SimpleDescription> longDescriptions) {
    this.longDescriptions = longDescriptions;
  }


  public Hotel hotelAmenityCodes(List<String> hotelAmenityCodes) {
    
    this.hotelAmenityCodes = hotelAmenityCodes;
    return this;
  }

  public Hotel addHotelAmenityCodesItem(String hotelAmenityCodesItem) {
    if (this.hotelAmenityCodes == null) {
      this.hotelAmenityCodes = new ArrayList<>();
    }
    this.hotelAmenityCodes.add(hotelAmenityCodesItem);
    return this;
  }

   /**
   * Supported OTA specification &#x60;HAC&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory).
   * @return hotelAmenityCodes
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "[\"1\",\"7\"]", value = "Supported OTA specification `HAC` code. See [OTA geoname data](#operation/showAvailableCodesForCategory).")
  @JsonProperty(JSON_PROPERTY_HOTEL_AMENITY_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getHotelAmenityCodes() {
    return hotelAmenityCodes;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_AMENITY_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHotelAmenityCodes(List<String> hotelAmenityCodes) {
    this.hotelAmenityCodes = hotelAmenityCodes;
  }


  public Hotel propertyAccessibilityCodes(List<String> propertyAccessibilityCodes) {
    
    this.propertyAccessibilityCodes = propertyAccessibilityCodes;
    return this;
  }

  public Hotel addPropertyAccessibilityCodesItem(String propertyAccessibilityCodesItem) {
    if (this.propertyAccessibilityCodes == null) {
      this.propertyAccessibilityCodes = new ArrayList<>();
    }
    this.propertyAccessibilityCodes.add(propertyAccessibilityCodesItem);
    return this;
  }

   /**
   * Supported OTA specification &#x60;PHY&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory).
   * @return propertyAccessibilityCodes
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "[\"1\",\"7\"]", value = "Supported OTA specification `PHY` code. See [OTA geoname data](#operation/showAvailableCodesForCategory).")
  @JsonProperty(JSON_PROPERTY_PROPERTY_ACCESSIBILITY_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getPropertyAccessibilityCodes() {
    return propertyAccessibilityCodes;
  }


  @JsonProperty(JSON_PROPERTY_PROPERTY_ACCESSIBILITY_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPropertyAccessibilityCodes(List<String> propertyAccessibilityCodes) {
    this.propertyAccessibilityCodes = propertyAccessibilityCodes;
  }


  public Hotel propertySecurityCodes(List<String> propertySecurityCodes) {
    
    this.propertySecurityCodes = propertySecurityCodes;
    return this;
  }

  public Hotel addPropertySecurityCodesItem(String propertySecurityCodesItem) {
    if (this.propertySecurityCodes == null) {
      this.propertySecurityCodes = new ArrayList<>();
    }
    this.propertySecurityCodes.add(propertySecurityCodesItem);
    return this;
  }

   /**
   * Supported OTA specification &#x60;SEC&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory).
   * @return propertySecurityCodes
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "[\"1\",\"7\"]", value = "Supported OTA specification `SEC` code. See [OTA geoname data](#operation/showAvailableCodesForCategory).")
  @JsonProperty(JSON_PROPERTY_PROPERTY_SECURITY_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getPropertySecurityCodes() {
    return propertySecurityCodes;
  }


  @JsonProperty(JSON_PROPERTY_PROPERTY_SECURITY_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPropertySecurityCodes(List<String> propertySecurityCodes) {
    this.propertySecurityCodes = propertySecurityCodes;
  }


  public Hotel locationPoint(GeoJsonPoint locationPoint) {
    
    this.locationPoint = locationPoint;
    return this;
  }

   /**
   * Get locationPoint
   * @return locationPoint
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_LOCATION_POINT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public GeoJsonPoint getLocationPoint() {
    return locationPoint;
  }


  @JsonProperty(JSON_PROPERTY_LOCATION_POINT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLocationPoint(GeoJsonPoint locationPoint) {
    this.locationPoint = locationPoint;
  }


  public Hotel policy(PropertyPolicy policy) {
    
    this.policy = policy;
    return this;
  }

   /**
   * Get policy
   * @return policy
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_POLICY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PropertyPolicy getPolicy() {
    return policy;
  }


  @JsonProperty(JSON_PROPERTY_POLICY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPolicy(PropertyPolicy policy) {
    this.policy = policy;
  }


  public Hotel socials(List<Social> socials) {
    
    this.socials = socials;
    return this;
  }

  public Hotel addSocialsItem(Social socialsItem) {
    if (this.socials == null) {
      this.socials = new ArrayList<>();
    }
    this.socials.add(socialsItem);
    return this;
  }

   /**
   * List of all social network account property has.
   * @return socials
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "List of all social network account property has.")
  @JsonProperty(JSON_PROPERTY_SOCIALS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Social> getSocials() {
    return socials;
  }


  @JsonProperty(JSON_PROPERTY_SOCIALS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSocials(List<Social> socials) {
    this.socials = socials;
  }


  public Hotel ownerContact(Contact ownerContact) {
    
    this.ownerContact = ownerContact;
    return this;
  }

   /**
   * Get ownerContact
   * @return ownerContact
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_OWNER_CONTACT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Contact getOwnerContact() {
    return ownerContact;
  }


  @JsonProperty(JSON_PROPERTY_OWNER_CONTACT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOwnerContact(Contact ownerContact) {
    this.ownerContact = ownerContact;
  }


  public Hotel reservationsContact(Contact reservationsContact) {
    
    this.reservationsContact = reservationsContact;
    return this;
  }

   /**
   * Get reservationsContact
   * @return reservationsContact
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_RESERVATIONS_CONTACT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Contact getReservationsContact() {
    return reservationsContact;
  }


  @JsonProperty(JSON_PROPERTY_RESERVATIONS_CONTACT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReservationsContact(Contact reservationsContact) {
    this.reservationsContact = reservationsContact;
  }


  public Hotel accountingContact(Contact accountingContact) {
    
    this.accountingContact = accountingContact;
    return this;
  }

   /**
   * Get accountingContact
   * @return accountingContact
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ACCOUNTING_CONTACT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Contact getAccountingContact() {
    return accountingContact;
  }


  @JsonProperty(JSON_PROPERTY_ACCOUNTING_CONTACT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAccountingContact(Contact accountingContact) {
    this.accountingContact = accountingContact;
  }


  public Hotel accountingAddress(Address accountingAddress) {
    
    this.accountingAddress = accountingAddress;
    return this;
  }

   /**
   * Get accountingAddress
   * @return accountingAddress
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ACCOUNTING_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Address getAccountingAddress() {
    return accountingAddress;
  }


  @JsonProperty(JSON_PROPERTY_ACCOUNTING_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAccountingAddress(Address accountingAddress) {
    this.accountingAddress = accountingAddress;
  }


  public Hotel lifestyleTypes(List<LifestyleTypesEnum> lifestyleTypes) {
    
    this.lifestyleTypes = lifestyleTypes;
    return this;
  }

  public Hotel addLifestyleTypesItem(LifestyleTypesEnum lifestyleTypesItem) {
    if (this.lifestyleTypes == null) {
      this.lifestyleTypes = new ArrayList<>();
    }
    this.lifestyleTypes.add(lifestyleTypesItem);
    return this;
  }

   /**
   * List of all lifestyles property has associated with. See [Lifestyle geoname data](#operation/showLifestyles)
   * @return lifestyleTypes
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "List of all lifestyles property has associated with. See [Lifestyle geoname data](#operation/showLifestyles)")
  @JsonProperty(JSON_PROPERTY_LIFESTYLE_TYPES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<LifestyleTypesEnum> getLifestyleTypes() {
    return lifestyleTypes;
  }


  @JsonProperty(JSON_PROPERTY_LIFESTYLE_TYPES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLifestyleTypes(List<LifestyleTypesEnum> lifestyleTypes) {
    this.lifestyleTypes = lifestyleTypes;
  }


  public Hotel agreementAccepted(Boolean agreementAccepted) {
    
    this.agreementAccepted = agreementAccepted;
    return this;
  }

   /**
   * Property has accepted our terms and conditions.
   * @return agreementAccepted
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(required = true, value = "Property has accepted our terms and conditions.")
  @JsonProperty(JSON_PROPERTY_AGREEMENT_ACCEPTED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getAgreementAccepted() {
    return agreementAccepted;
  }


  @JsonProperty(JSON_PROPERTY_AGREEMENT_ACCEPTED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAgreementAccepted(Boolean agreementAccepted) {
    this.agreementAccepted = agreementAccepted;
  }


  public Hotel marketingOptinAllowed(Boolean marketingOptinAllowed) {
    
    this.marketingOptinAllowed = marketingOptinAllowed;
    return this;
  }

   /**
   * Property agreed to let the payment use its logo and images for marketing purposes (with proper credits).
   * @return marketingOptinAllowed
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Property agreed to let the payment use its logo and images for marketing purposes (with proper credits).")
  @JsonProperty(JSON_PROPERTY_MARKETING_OPTIN_ALLOWED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getMarketingOptinAllowed() {
    return marketingOptinAllowed;
  }


  @JsonProperty(JSON_PROPERTY_MARKETING_OPTIN_ALLOWED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMarketingOptinAllowed(Boolean marketingOptinAllowed) {
    this.marketingOptinAllowed = marketingOptinAllowed;
  }


  public Hotel logos(List<Multimedia> logos) {
    
    this.logos = logos;
    return this;
  }

  public Hotel addLogosItem(Multimedia logosItem) {
    if (this.logos == null) {
      this.logos = new ArrayList<>();
    }
    this.logos.add(logosItem);
    return this;
  }

   /**
   * List of logo images of property
   * @return logos
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "List of logo images of property")
  @JsonProperty(JSON_PROPERTY_LOGOS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Multimedia> getLogos() {
    return logos;
  }


  @JsonProperty(JSON_PROPERTY_LOGOS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLogos(List<Multimedia> logos) {
    this.logos = logos;
  }


  public Hotel numberOfRooms(Integer numberOfRooms) {
    
    this.numberOfRooms = numberOfRooms;
    return this;
  }

   /**
   * Number of rooms / keys for property
   * minimum: 1
   * @return numberOfRooms
  **/
  @javax.annotation.Nonnull
  @NotNull
 @Min(1)  @ApiModelProperty(example = "40", required = true, value = "Number of rooms / keys for property")
  @JsonProperty(JSON_PROPERTY_NUMBER_OF_ROOMS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getNumberOfRooms() {
    return numberOfRooms;
  }


  @JsonProperty(JSON_PROPERTY_NUMBER_OF_ROOMS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setNumberOfRooms(Integer numberOfRooms) {
    this.numberOfRooms = numberOfRooms;
  }


  public Hotel address(Address address) {
    
    this.address = address;
    return this;
  }

   /**
   * Get address
   * @return address
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Address getAddress() {
    return address;
  }


  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAddress(Address address) {
    this.address = address;
  }


  public Hotel active(Boolean active) {
    
    this.active = active;
    return this;
  }

   /**
   * Property is both approved and activated.
   * @return active
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "true", value = "Property is both approved and activated.")
  @JsonProperty(JSON_PROPERTY_ACTIVE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getActive() {
    return active;
  }


  @JsonProperty(JSON_PROPERTY_ACTIVE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setActive(Boolean active) {
    this.active = active;
  }


  public Hotel generalManagerWelcomeMessage(Boolean generalManagerWelcomeMessage) {
    
    this.generalManagerWelcomeMessage = generalManagerWelcomeMessage;
    return this;
  }

   /**
   * Whether property has any GM-created welcome messages.
   * @return generalManagerWelcomeMessage
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "true", value = "Whether property has any GM-created welcome messages.")
  @JsonProperty(JSON_PROPERTY_GENERAL_MANAGER_WELCOME_MESSAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getGeneralManagerWelcomeMessage() {
    return generalManagerWelcomeMessage;
  }


  @JsonProperty(JSON_PROPERTY_GENERAL_MANAGER_WELCOME_MESSAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGeneralManagerWelcomeMessage(Boolean generalManagerWelcomeMessage) {
    this.generalManagerWelcomeMessage = generalManagerWelcomeMessage;
  }


  public Hotel propertyActive(Boolean propertyActive) {
    
    this.propertyActive = propertyActive;
    return this;
  }

   /**
   * Property activated itself and went live.
   * @return propertyActive
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "true", value = "Property activated itself and went live.")
  @JsonProperty(JSON_PROPERTY_PROPERTY_ACTIVE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getPropertyActive() {
    return propertyActive;
  }


  @JsonProperty(JSON_PROPERTY_PROPERTY_ACTIVE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPropertyActive(Boolean propertyActive) {
    this.propertyActive = propertyActive;
  }


  public Hotel platformActive(Boolean platformActive) {
    
    this.platformActive = platformActive;
    return this;
  }

   /**
   * Platform approved property.
   * @return platformActive
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "true", value = "Platform approved property.")
  @JsonProperty(JSON_PROPERTY_PLATFORM_ACTIVE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getPlatformActive() {
    return platformActive;
  }


  @JsonProperty(JSON_PROPERTY_PLATFORM_ACTIVE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPlatformActive(Boolean platformActive) {
    this.platformActive = platformActive;
  }


  public Hotel contractSignerFullName(String contractSignerFullName) {
    
    this.contractSignerFullName = contractSignerFullName;
    return this;
  }

   /**
   * Concatenated name of contract signer into one string.
   * @return contractSignerFullName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "Jane Doe", value = "Concatenated name of contract signer into one string.")
  @JsonProperty(JSON_PROPERTY_CONTRACT_SIGNER_FULL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getContractSignerFullName() {
    return contractSignerFullName;
  }


  @JsonProperty(JSON_PROPERTY_CONTRACT_SIGNER_FULL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setContractSignerFullName(String contractSignerFullName) {
    this.contractSignerFullName = contractSignerFullName;
  }


  public Hotel fullAddress(String fullAddress) {
    
    this.fullAddress = fullAddress;
    return this;
  }

   /**
   * Concatenated address into a single string
   * @return fullAddress
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "234 Near da beach, Pebble #5001, Los Angeles, CA 90210", value = "Concatenated address into a single string")
  @JsonProperty(JSON_PROPERTY_FULL_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFullAddress() {
    return fullAddress;
  }


  @JsonProperty(JSON_PROPERTY_FULL_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFullAddress(String fullAddress) {
    this.fullAddress = fullAddress;
  }


  public Hotel socialNetworks(Boolean socialNetworks) {
    
    this.socialNetworks = socialNetworks;
    return this;
  }

   /**
   * Whether property has any social networks associated with her profile.
   * @return socialNetworks
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "true", value = "Whether property has any social networks associated with her profile.")
  @JsonProperty(JSON_PROPERTY_SOCIAL_NETWORKS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSocialNetworks() {
    return socialNetworks;
  }


  @JsonProperty(JSON_PROPERTY_SOCIAL_NETWORKS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSocialNetworks(Boolean socialNetworks) {
    this.socialNetworks = socialNetworks;
  }


  public Hotel lifestyles(Boolean lifestyles) {
    
    this.lifestyles = lifestyles;
    return this;
  }

   /**
   * Whether property has any lifestyles associated with her profile.
   * @return lifestyles
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "true", value = "Whether property has any lifestyles associated with her profile.")
  @JsonProperty(JSON_PROPERTY_LIFESTYLES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getLifestyles() {
    return lifestyles;
  }


  @JsonProperty(JSON_PROPERTY_LIFESTYLES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLifestyles(Boolean lifestyles) {
    this.lifestyles = lifestyles;
  }


  public Hotel greenIndexScores(AggregateGreendexAnswers greenIndexScores) {
    
    this.greenIndexScores = greenIndexScores;
    return this;
  }

   /**
   * Get greenIndexScores
   * @return greenIndexScores
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_GREEN_INDEX_SCORES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public AggregateGreendexAnswers getGreenIndexScores() {
    return greenIndexScores;
  }


  @JsonProperty(JSON_PROPERTY_GREEN_INDEX_SCORES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGreenIndexScores(AggregateGreendexAnswers greenIndexScores) {
    this.greenIndexScores = greenIndexScores;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Hotel hotel = (Hotel) o;
    return Objects.equals(this.hotelIdentifier, hotel.hotelIdentifier) &&
        Objects.equals(this.name, hotel.name) &&
        Objects.equals(this.hotelCode, hotel.hotelCode) &&
        Objects.equals(this.hotelCodeContext, hotel.hotelCodeContext) &&
        Objects.equals(this.localName, hotel.localName) &&
        Objects.equals(this.legalName, hotel.legalName) &&
        Objects.equals(this.urlName, hotel.urlName) &&
        Objects.equals(this.currencyCode, hotel.currencyCode) &&
        Objects.equals(this.status, hotel.status) &&
        Objects.equals(this.externalStatus, hotel.externalStatus) &&
        Objects.equals(this.multimediaIdentifier, hotel.multimediaIdentifier) &&
        Objects.equals(this.imageIdentifier, hotel.imageIdentifier) &&
        Objects.equals(this.imageAngle, hotel.imageAngle) &&
        Objects.equals(this.locationCategory, hotel.locationCategory) &&
        Objects.equals(this.segmentCategory, hotel.segmentCategory) &&
        Objects.equals(this.hotelCategory, hotel.hotelCategory) &&
        Objects.equals(this.architecturalStyle, hotel.architecturalStyle) &&
        Objects.equals(this.whenBuilt, hotel.whenBuilt) &&
        Objects.equals(this.hotelChain, hotel.hotelChain) &&
        Objects.equals(this.hotelBrand, hotel.hotelBrand) &&
        Objects.equals(this.channelManager, hotel.channelManager) &&
        Objects.equals(this.otherChannelManager, hotel.otherChannelManager) &&
        Objects.equals(this.licenseNumber, hotel.licenseNumber) &&
        Objects.equals(this.stars, hotel.stars) &&
        Objects.equals(this.fullNameOfGeneralManager, hotel.fullNameOfGeneralManager) &&
        Objects.equals(this.profilePictureIdentifierGeneralManager, hotel.profilePictureIdentifierGeneralManager) &&
        Objects.equals(this.messagesOfGeneralManager, hotel.messagesOfGeneralManager) &&
        Objects.equals(this.shortDescriptions, hotel.shortDescriptions) &&
        Objects.equals(this.longDescriptions, hotel.longDescriptions) &&
        Objects.equals(this.hotelAmenityCodes, hotel.hotelAmenityCodes) &&
        Objects.equals(this.propertyAccessibilityCodes, hotel.propertyAccessibilityCodes) &&
        Objects.equals(this.propertySecurityCodes, hotel.propertySecurityCodes) &&
        Objects.equals(this.locationPoint, hotel.locationPoint) &&
        Objects.equals(this.policy, hotel.policy) &&
        Objects.equals(this.socials, hotel.socials) &&
        Objects.equals(this.ownerContact, hotel.ownerContact) &&
        Objects.equals(this.reservationsContact, hotel.reservationsContact) &&
        Objects.equals(this.accountingContact, hotel.accountingContact) &&
        Objects.equals(this.accountingAddress, hotel.accountingAddress) &&
        Objects.equals(this.lifestyleTypes, hotel.lifestyleTypes) &&
        Objects.equals(this.agreementAccepted, hotel.agreementAccepted) &&
        Objects.equals(this.marketingOptinAllowed, hotel.marketingOptinAllowed) &&
        Objects.equals(this.logos, hotel.logos) &&
        Objects.equals(this.numberOfRooms, hotel.numberOfRooms) &&
        Objects.equals(this.address, hotel.address) &&
        Objects.equals(this.active, hotel.active) &&
        Objects.equals(this.generalManagerWelcomeMessage, hotel.generalManagerWelcomeMessage) &&
        Objects.equals(this.propertyActive, hotel.propertyActive) &&
        Objects.equals(this.platformActive, hotel.platformActive) &&
        Objects.equals(this.contractSignerFullName, hotel.contractSignerFullName) &&
        Objects.equals(this.fullAddress, hotel.fullAddress) &&
        Objects.equals(this.socialNetworks, hotel.socialNetworks) &&
        Objects.equals(this.lifestyles, hotel.lifestyles) &&
        Objects.equals(this.greenIndexScores, hotel.greenIndexScores);
  }

  @Override
  public int hashCode() {
    return Objects.hash(hotelIdentifier, name, hotelCode, hotelCodeContext, localName, legalName, urlName, currencyCode, status, externalStatus, multimediaIdentifier, imageIdentifier, imageAngle, locationCategory, segmentCategory, hotelCategory, architecturalStyle, whenBuilt, hotelChain, hotelBrand, channelManager, otherChannelManager, licenseNumber, stars, fullNameOfGeneralManager, profilePictureIdentifierGeneralManager, messagesOfGeneralManager, shortDescriptions, longDescriptions, hotelAmenityCodes, propertyAccessibilityCodes, propertySecurityCodes, locationPoint, policy, socials, ownerContact, reservationsContact, accountingContact, accountingAddress, lifestyleTypes, agreementAccepted, marketingOptinAllowed, logos, numberOfRooms, address, active, generalManagerWelcomeMessage, propertyActive, platformActive, contractSignerFullName, fullAddress, socialNetworks, lifestyles, greenIndexScores);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Hotel {\n");
    sb.append("    hotelIdentifier: ").append(toIndentedString(hotelIdentifier)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    hotelCode: ").append(toIndentedString(hotelCode)).append("\n");
    sb.append("    hotelCodeContext: ").append(toIndentedString(hotelCodeContext)).append("\n");
    sb.append("    localName: ").append(toIndentedString(localName)).append("\n");
    sb.append("    legalName: ").append(toIndentedString(legalName)).append("\n");
    sb.append("    urlName: ").append(toIndentedString(urlName)).append("\n");
    sb.append("    currencyCode: ").append(toIndentedString(currencyCode)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    externalStatus: ").append(toIndentedString(externalStatus)).append("\n");
    sb.append("    multimediaIdentifier: ").append(toIndentedString(multimediaIdentifier)).append("\n");
    sb.append("    imageIdentifier: ").append(toIndentedString(imageIdentifier)).append("\n");
    sb.append("    imageAngle: ").append(toIndentedString(imageAngle)).append("\n");
    sb.append("    locationCategory: ").append(toIndentedString(locationCategory)).append("\n");
    sb.append("    segmentCategory: ").append(toIndentedString(segmentCategory)).append("\n");
    sb.append("    hotelCategory: ").append(toIndentedString(hotelCategory)).append("\n");
    sb.append("    architecturalStyle: ").append(toIndentedString(architecturalStyle)).append("\n");
    sb.append("    whenBuilt: ").append(toIndentedString(whenBuilt)).append("\n");
    sb.append("    hotelChain: ").append(toIndentedString(hotelChain)).append("\n");
    sb.append("    hotelBrand: ").append(toIndentedString(hotelBrand)).append("\n");
    sb.append("    channelManager: ").append(toIndentedString(channelManager)).append("\n");
    sb.append("    otherChannelManager: ").append(toIndentedString(otherChannelManager)).append("\n");
    sb.append("    licenseNumber: ").append(toIndentedString(licenseNumber)).append("\n");
    sb.append("    stars: ").append(toIndentedString(stars)).append("\n");
    sb.append("    fullNameOfGeneralManager: ").append(toIndentedString(fullNameOfGeneralManager)).append("\n");
    sb.append("    profilePictureIdentifierGeneralManager: ").append(toIndentedString(profilePictureIdentifierGeneralManager)).append("\n");
    sb.append("    messagesOfGeneralManager: ").append(toIndentedString(messagesOfGeneralManager)).append("\n");
    sb.append("    shortDescriptions: ").append(toIndentedString(shortDescriptions)).append("\n");
    sb.append("    longDescriptions: ").append(toIndentedString(longDescriptions)).append("\n");
    sb.append("    hotelAmenityCodes: ").append(toIndentedString(hotelAmenityCodes)).append("\n");
    sb.append("    propertyAccessibilityCodes: ").append(toIndentedString(propertyAccessibilityCodes)).append("\n");
    sb.append("    propertySecurityCodes: ").append(toIndentedString(propertySecurityCodes)).append("\n");
    sb.append("    locationPoint: ").append(toIndentedString(locationPoint)).append("\n");
    sb.append("    policy: ").append(toIndentedString(policy)).append("\n");
    sb.append("    socials: ").append(toIndentedString(socials)).append("\n");
    sb.append("    ownerContact: ").append(toIndentedString(ownerContact)).append("\n");
    sb.append("    reservationsContact: ").append(toIndentedString(reservationsContact)).append("\n");
    sb.append("    accountingContact: ").append(toIndentedString(accountingContact)).append("\n");
    sb.append("    accountingAddress: ").append(toIndentedString(accountingAddress)).append("\n");
    sb.append("    lifestyleTypes: ").append(toIndentedString(lifestyleTypes)).append("\n");
    sb.append("    agreementAccepted: ").append(toIndentedString(agreementAccepted)).append("\n");
    sb.append("    marketingOptinAllowed: ").append(toIndentedString(marketingOptinAllowed)).append("\n");
    sb.append("    logos: ").append(toIndentedString(logos)).append("\n");
    sb.append("    numberOfRooms: ").append(toIndentedString(numberOfRooms)).append("\n");
    sb.append("    address: ").append(toIndentedString(address)).append("\n");
    sb.append("    active: ").append(toIndentedString(active)).append("\n");
    sb.append("    generalManagerWelcomeMessage: ").append(toIndentedString(generalManagerWelcomeMessage)).append("\n");
    sb.append("    propertyActive: ").append(toIndentedString(propertyActive)).append("\n");
    sb.append("    platformActive: ").append(toIndentedString(platformActive)).append("\n");
    sb.append("    contractSignerFullName: ").append(toIndentedString(contractSignerFullName)).append("\n");
    sb.append("    fullAddress: ").append(toIndentedString(fullAddress)).append("\n");
    sb.append("    socialNetworks: ").append(toIndentedString(socialNetworks)).append("\n");
    sb.append("    lifestyles: ").append(toIndentedString(lifestyles)).append("\n");
    sb.append("    greenIndexScores: ").append(toIndentedString(greenIndexScores)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

