/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/docs?api=affiliate): All APIs related to selling travel inventory as an affiliate. - [Extranet](/docs?api=extranet): All APIs related to managing travel inventory and suppliers. - [Booking Engine](/docs?api=booking-engine): All APIs related to searching for travel inventory and creating bookings. - [Channel Manager](/docs?api=channel-manager): All APIs related to channel managers who want to integrate with our payment.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.payment-v`1`+json.  ## Release history - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Extranet API Welcome to the Extranet API - A programmer-friendly way to manage your travel inventory on the wink payment. This API offers a superset of the features you can find at [https://extranet.wink.travel](https://extranet.wink.travel) and gives you all the tools you need to ready your properties and inventory for sale across 10000s of our unique sales channels. What differentiates us from existing Extranets is 1. we make it available for everyone to use and 2. the care we take in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Content creators have the ability to make their inventory look great and be searchable in a wide variety of ways. You won't find properties with generic inventory, low resolution pictures and little ancillary content that can easily be found everywhere else on the internet.  # Integrations We have already integrated with the most well-known channel managers so you don't have to. Once your properties are set up, you can finish the setup by mapping your property to wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API. - Allotz - CloudBeds / MyAllocator - Comanche - d-edge - FastBooking - HotelLink - HoteliersGuru - Omnibees - RateGain - Rate Tiger - ResAvenue - Siteminder - Sabre SynXis - Travelclick - Yieldplanet  # Intended Audience Programmers are [most likely] a requirement to start integrating with wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible. - Hotel chains - Hotel brands - Travel tech companies - Destination sites - Integrators - Aggregators - Destination management companies - Travel agencies - OTAs  
 *
 * The version of the OpenAPI document: 20.1.2-SNAPSHOT
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.extranet.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import travel.wink.sdk.extranet.model.CancellationPolicy;
import travel.wink.sdk.extranet.model.CancellationPolicyExceptions;
import travel.wink.sdk.extranet.model.RatePlanArrivalDaysOfWeek;
import travel.wink.sdk.extranet.model.RatePlanAvailableDaysOfWeek;
import travel.wink.sdk.extranet.model.RatePlanDepartureDaysOfWeek;
import travel.wink.sdk.extranet.model.RatePlanEarlyCheckInCharge;
import travel.wink.sdk.extranet.model.RatePlanExtraChildRateModifier;
import travel.wink.sdk.extranet.model.RatePlanExtraPaxRateModifier;
import travel.wink.sdk.extranet.model.RatePlanLateCheckOutCharge;
import travel.wink.sdk.extranet.model.RatePlanLevelFee;
import travel.wink.sdk.extranet.model.RatePlanRequiredDaysOfWeek;
import travel.wink.sdk.extranet.model.RatePlanSingleOccupancyRateModifier;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Rate plan associated with this master rate
 */
@ApiModel(description = "Rate plan associated with this master rate")
@JsonPropertyOrder({
  MasterRateRatePlan.JSON_PROPERTY_IDENTIFIER,
  MasterRateRatePlan.JSON_PROPERTY_HOTEL_IDENTIFIER,
  MasterRateRatePlan.JSON_PROPERTY_NAME,
  MasterRateRatePlan.JSON_PROPERTY_PREPAID,
  MasterRateRatePlan.JSON_PROPERTY_ENABLED,
  MasterRateRatePlan.JSON_PROPERTY_BREAKFAST,
  MasterRateRatePlan.JSON_PROPERTY_BRUNCH,
  MasterRateRatePlan.JSON_PROPERTY_LUNCH,
  MasterRateRatePlan.JSON_PROPERTY_DINNER,
  MasterRateRatePlan.JSON_PROPERTY_ALL_INCLUSIVE,
  MasterRateRatePlan.JSON_PROPERTY_ALL_INCLUSIVE_PLUS_ALCOHOL,
  MasterRateRatePlan.JSON_PROPERTY_SELL_START_DATE,
  MasterRateRatePlan.JSON_PROPERTY_SELL_END_DATE,
  MasterRateRatePlan.JSON_PROPERTY_STAY_START_DATE,
  MasterRateRatePlan.JSON_PROPERTY_STAY_END_DATE,
  MasterRateRatePlan.JSON_PROPERTY_LOYALTY_POINTS_ACCRUE,
  MasterRateRatePlan.JSON_PROPERTY_MAX_ADVANCE_BOOKING_OFFSET,
  MasterRateRatePlan.JSON_PROPERTY_MIN_ADVANCE_BOOKING_OFFSET,
  MasterRateRatePlan.JSON_PROPERTY_MIN_TOTAL_OCCUPANCY,
  MasterRateRatePlan.JSON_PROPERTY_MAX_TOTAL_OCCUPANCY,
  MasterRateRatePlan.JSON_PROPERTY_MIN_L_O_S,
  MasterRateRatePlan.JSON_PROPERTY_MAX_L_O_S,
  MasterRateRatePlan.JSON_PROPERTY_MIN_AGE,
  MasterRateRatePlan.JSON_PROPERTY_MAX_AGE,
  MasterRateRatePlan.JSON_PROPERTY_RATE_PLAN_LEVEL_FEES,
  MasterRateRatePlan.JSON_PROPERTY_AVAILABLE_DAYS_OF_WEEK,
  MasterRateRatePlan.JSON_PROPERTY_ARRIVAL_DAYS_OF_WEEK,
  MasterRateRatePlan.JSON_PROPERTY_DEPARTURE_DAYS_OF_WEEK,
  MasterRateRatePlan.JSON_PROPERTY_REQUIRED_DAYS_OF_WEEK,
  MasterRateRatePlan.JSON_PROPERTY_EARLY_CHECK_IN_CHARGE,
  MasterRateRatePlan.JSON_PROPERTY_LATE_CHECK_OUT_CHARGE,
  MasterRateRatePlan.JSON_PROPERTY_CANCELLATION_POLICY_IDENTIFIER,
  MasterRateRatePlan.JSON_PROPERTY_CANCELLATION_POLICY,
  MasterRateRatePlan.JSON_PROPERTY_CANCELLATION_POLICY_EXCEPTIONS,
  MasterRateRatePlan.JSON_PROPERTY_SINGLE_OCCUPANCY_RATE_MODIFIER,
  MasterRateRatePlan.JSON_PROPERTY_EXTRA_PAX_RATE_MODIFIER,
  MasterRateRatePlan.JSON_PROPERTY_EXTRA_CHILD_RATE_MODIFIER
})
@JsonTypeName("masterRateRatePlan")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-06-20T21:56:24.013599+07:00[Asia/Bangkok]")
public class MasterRateRatePlan {
  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  private String identifier;

  public static final String JSON_PROPERTY_HOTEL_IDENTIFIER = "hotelIdentifier";
  private String hotelIdentifier;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_PREPAID = "prepaid";
  private Boolean prepaid = false;

  public static final String JSON_PROPERTY_ENABLED = "enabled";
  private Boolean enabled = false;

  public static final String JSON_PROPERTY_BREAKFAST = "breakfast";
  private Boolean breakfast = false;

  public static final String JSON_PROPERTY_BRUNCH = "brunch";
  private Boolean brunch = false;

  public static final String JSON_PROPERTY_LUNCH = "lunch";
  private Boolean lunch = false;

  public static final String JSON_PROPERTY_DINNER = "dinner";
  private Boolean dinner = false;

  public static final String JSON_PROPERTY_ALL_INCLUSIVE = "allInclusive";
  private Boolean allInclusive = false;

  public static final String JSON_PROPERTY_ALL_INCLUSIVE_PLUS_ALCOHOL = "allInclusivePlusAlcohol";
  private Boolean allInclusivePlusAlcohol = false;

  public static final String JSON_PROPERTY_SELL_START_DATE = "sellStartDate";
  private LocalDate sellStartDate;

  public static final String JSON_PROPERTY_SELL_END_DATE = "sellEndDate";
  private LocalDate sellEndDate;

  public static final String JSON_PROPERTY_STAY_START_DATE = "stayStartDate";
  private LocalDate stayStartDate;

  public static final String JSON_PROPERTY_STAY_END_DATE = "stayEndDate";
  private LocalDate stayEndDate;

  public static final String JSON_PROPERTY_LOYALTY_POINTS_ACCRUE = "loyaltyPointsAccrue";
  private Boolean loyaltyPointsAccrue = false;

  public static final String JSON_PROPERTY_MAX_ADVANCE_BOOKING_OFFSET = "maxAdvanceBookingOffset";
  private Integer maxAdvanceBookingOffset;

  public static final String JSON_PROPERTY_MIN_ADVANCE_BOOKING_OFFSET = "minAdvanceBookingOffset";
  private Integer minAdvanceBookingOffset;

  public static final String JSON_PROPERTY_MIN_TOTAL_OCCUPANCY = "minTotalOccupancy";
  private Integer minTotalOccupancy;

  public static final String JSON_PROPERTY_MAX_TOTAL_OCCUPANCY = "maxTotalOccupancy";
  private Integer maxTotalOccupancy;

  public static final String JSON_PROPERTY_MIN_L_O_S = "minLOS";
  private Integer minLOS;

  public static final String JSON_PROPERTY_MAX_L_O_S = "maxLOS";
  private Integer maxLOS;

  public static final String JSON_PROPERTY_MIN_AGE = "minAge";
  private Integer minAge;

  public static final String JSON_PROPERTY_MAX_AGE = "maxAge";
  private Integer maxAge;

  public static final String JSON_PROPERTY_RATE_PLAN_LEVEL_FEES = "ratePlanLevelFees";
  private List<RatePlanLevelFee> ratePlanLevelFees = null;

  public static final String JSON_PROPERTY_AVAILABLE_DAYS_OF_WEEK = "availableDaysOfWeek";
  private RatePlanAvailableDaysOfWeek availableDaysOfWeek;

  public static final String JSON_PROPERTY_ARRIVAL_DAYS_OF_WEEK = "arrivalDaysOfWeek";
  private RatePlanArrivalDaysOfWeek arrivalDaysOfWeek;

  public static final String JSON_PROPERTY_DEPARTURE_DAYS_OF_WEEK = "departureDaysOfWeek";
  private RatePlanDepartureDaysOfWeek departureDaysOfWeek;

  public static final String JSON_PROPERTY_REQUIRED_DAYS_OF_WEEK = "requiredDaysOfWeek";
  private RatePlanRequiredDaysOfWeek requiredDaysOfWeek;

  public static final String JSON_PROPERTY_EARLY_CHECK_IN_CHARGE = "earlyCheckInCharge";
  private RatePlanEarlyCheckInCharge earlyCheckInCharge;

  public static final String JSON_PROPERTY_LATE_CHECK_OUT_CHARGE = "lateCheckOutCharge";
  private RatePlanLateCheckOutCharge lateCheckOutCharge;

  public static final String JSON_PROPERTY_CANCELLATION_POLICY_IDENTIFIER = "cancellationPolicyIdentifier";
  private String cancellationPolicyIdentifier;

  public static final String JSON_PROPERTY_CANCELLATION_POLICY = "cancellationPolicy";
  private CancellationPolicy cancellationPolicy;

  public static final String JSON_PROPERTY_CANCELLATION_POLICY_EXCEPTIONS = "cancellationPolicyExceptions";
  private CancellationPolicyExceptions cancellationPolicyExceptions;

  public static final String JSON_PROPERTY_SINGLE_OCCUPANCY_RATE_MODIFIER = "singleOccupancyRateModifier";
  private RatePlanSingleOccupancyRateModifier singleOccupancyRateModifier;

  public static final String JSON_PROPERTY_EXTRA_PAX_RATE_MODIFIER = "extraPaxRateModifier";
  private RatePlanExtraPaxRateModifier extraPaxRateModifier;

  public static final String JSON_PROPERTY_EXTRA_CHILD_RATE_MODIFIER = "extraChildRateModifier";
  private RatePlanExtraChildRateModifier extraChildRateModifier;

  public MasterRateRatePlan() { 
  }

  public MasterRateRatePlan identifier(String identifier) {
    
    this.identifier = identifier;
    return this;
  }

   /**
   * Rate plan identifier
   * @return identifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Rate plan identifier")
  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIdentifier(String identifier) {
    this.identifier = identifier;
  }


  public MasterRateRatePlan hotelIdentifier(String hotelIdentifier) {
    
    this.hotelIdentifier = hotelIdentifier;
    return this;
  }

   /**
   * Hotel Identifier
   * @return hotelIdentifier
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(required = true, value = "Hotel Identifier")
  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getHotelIdentifier() {
    return hotelIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setHotelIdentifier(String hotelIdentifier) {
    this.hotelIdentifier = hotelIdentifier;
  }


  public MasterRateRatePlan name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Provides the name of the rate plan.
   * @return name
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "BAR 1", required = true, value = "Provides the name of the rate plan.")
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(String name) {
    this.name = name;
  }


  public MasterRateRatePlan prepaid(Boolean prepaid) {
    
    this.prepaid = prepaid;
    return this;
  }

   /**
   * When true, indicates if the rate is a prepaid rate.
   * @return prepaid
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "false", required = true, value = "When true, indicates if the rate is a prepaid rate.")
  @JsonProperty(JSON_PROPERTY_PREPAID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getPrepaid() {
    return prepaid;
  }


  @JsonProperty(JSON_PROPERTY_PREPAID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPrepaid(Boolean prepaid) {
    this.prepaid = prepaid;
  }


  public MasterRateRatePlan enabled(Boolean enabled) {
    
    this.enabled = enabled;
    return this;
  }

   /**
   * Whether rate plan is active or not.
   * @return enabled
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "false", required = true, value = "Whether rate plan is active or not.")
  @JsonProperty(JSON_PROPERTY_ENABLED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getEnabled() {
    return enabled;
  }


  @JsonProperty(JSON_PROPERTY_ENABLED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setEnabled(Boolean enabled) {
    this.enabled = enabled;
  }


  public MasterRateRatePlan breakfast(Boolean breakfast) {
    
    this.breakfast = breakfast;
    return this;
  }

   /**
   * When true, indicates breakfast is included.
   * @return breakfast
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "false", required = true, value = "When true, indicates breakfast is included.")
  @JsonProperty(JSON_PROPERTY_BREAKFAST)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getBreakfast() {
    return breakfast;
  }


  @JsonProperty(JSON_PROPERTY_BREAKFAST)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setBreakfast(Boolean breakfast) {
    this.breakfast = breakfast;
  }


  public MasterRateRatePlan brunch(Boolean brunch) {
    
    this.brunch = brunch;
    return this;
  }

   /**
   * When true, indicates brunch is included.
   * @return brunch
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "false", required = true, value = "When true, indicates brunch is included.")
  @JsonProperty(JSON_PROPERTY_BRUNCH)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getBrunch() {
    return brunch;
  }


  @JsonProperty(JSON_PROPERTY_BRUNCH)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setBrunch(Boolean brunch) {
    this.brunch = brunch;
  }


  public MasterRateRatePlan lunch(Boolean lunch) {
    
    this.lunch = lunch;
    return this;
  }

   /**
   * When true, indicates lunch is included.
   * @return lunch
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "false", required = true, value = "When true, indicates lunch is included.")
  @JsonProperty(JSON_PROPERTY_LUNCH)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getLunch() {
    return lunch;
  }


  @JsonProperty(JSON_PROPERTY_LUNCH)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setLunch(Boolean lunch) {
    this.lunch = lunch;
  }


  public MasterRateRatePlan dinner(Boolean dinner) {
    
    this.dinner = dinner;
    return this;
  }

   /**
   * When true, indicates dinner is included.
   * @return dinner
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "false", required = true, value = "When true, indicates dinner is included.")
  @JsonProperty(JSON_PROPERTY_DINNER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getDinner() {
    return dinner;
  }


  @JsonProperty(JSON_PROPERTY_DINNER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDinner(Boolean dinner) {
    this.dinner = dinner;
  }


  public MasterRateRatePlan allInclusive(Boolean allInclusive) {
    
    this.allInclusive = allInclusive;
    return this;
  }

   /**
   * Everything included except alcohol
   * @return allInclusive
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "false", required = true, value = "Everything included except alcohol")
  @JsonProperty(JSON_PROPERTY_ALL_INCLUSIVE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getAllInclusive() {
    return allInclusive;
  }


  @JsonProperty(JSON_PROPERTY_ALL_INCLUSIVE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAllInclusive(Boolean allInclusive) {
    this.allInclusive = allInclusive;
  }


  public MasterRateRatePlan allInclusivePlusAlcohol(Boolean allInclusivePlusAlcohol) {
    
    this.allInclusivePlusAlcohol = allInclusivePlusAlcohol;
    return this;
  }

   /**
   * Everything included with alcohol
   * @return allInclusivePlusAlcohol
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "false", required = true, value = "Everything included with alcohol")
  @JsonProperty(JSON_PROPERTY_ALL_INCLUSIVE_PLUS_ALCOHOL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getAllInclusivePlusAlcohol() {
    return allInclusivePlusAlcohol;
  }


  @JsonProperty(JSON_PROPERTY_ALL_INCLUSIVE_PLUS_ALCOHOL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAllInclusivePlusAlcohol(Boolean allInclusivePlusAlcohol) {
    this.allInclusivePlusAlcohol = allInclusivePlusAlcohol;
  }


  public MasterRateRatePlan sellStartDate(LocalDate sellStartDate) {
    
    this.sellStartDate = sellStartDate;
    return this;
  }

   /**
   * Set a start date for when to start selling this rate. When sellStartDate and sellEndDate are set, this rate is only available for sale within that date range.
   * @return sellStartDate
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Set a start date for when to start selling this rate. When sellStartDate and sellEndDate are set, this rate is only available for sale within that date range.")
  @JsonProperty(JSON_PROPERTY_SELL_START_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalDate getSellStartDate() {
    return sellStartDate;
  }


  @JsonProperty(JSON_PROPERTY_SELL_START_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSellStartDate(LocalDate sellStartDate) {
    this.sellStartDate = sellStartDate;
  }


  public MasterRateRatePlan sellEndDate(LocalDate sellEndDate) {
    
    this.sellEndDate = sellEndDate;
    return this;
  }

   /**
   * Set an end date for when to finish selling this rate. When sellStartDate and sellEndDate are set, this rate is only available for sale within that date range.
   * @return sellEndDate
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Set an end date for when to finish selling this rate. When sellStartDate and sellEndDate are set, this rate is only available for sale within that date range.")
  @JsonProperty(JSON_PROPERTY_SELL_END_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalDate getSellEndDate() {
    return sellEndDate;
  }


  @JsonProperty(JSON_PROPERTY_SELL_END_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSellEndDate(LocalDate sellEndDate) {
    this.sellEndDate = sellEndDate;
  }


  public MasterRateRatePlan stayStartDate(LocalDate stayStartDate) {
    
    this.stayStartDate = stayStartDate;
    return this;
  }

   /**
   * Set a start date for when the guest can visit. When stayStartDate and stayEndDate are set, this rate is only available for stay within that date range.
   * @return stayStartDate
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Set a start date for when the guest can visit. When stayStartDate and stayEndDate are set, this rate is only available for stay within that date range.")
  @JsonProperty(JSON_PROPERTY_STAY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalDate getStayStartDate() {
    return stayStartDate;
  }


  @JsonProperty(JSON_PROPERTY_STAY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStayStartDate(LocalDate stayStartDate) {
    this.stayStartDate = stayStartDate;
  }


  public MasterRateRatePlan stayEndDate(LocalDate stayEndDate) {
    
    this.stayEndDate = stayEndDate;
    return this;
  }

   /**
   * Set an end date for when the guest can visit. When stayStartDate and stayEndDate are set, this rate is only available for stay within that date range.
   * @return stayEndDate
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Set an end date for when the guest can visit. When stayStartDate and stayEndDate are set, this rate is only available for stay within that date range.")
  @JsonProperty(JSON_PROPERTY_STAY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalDate getStayEndDate() {
    return stayEndDate;
  }


  @JsonProperty(JSON_PROPERTY_STAY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStayEndDate(LocalDate stayEndDate) {
    this.stayEndDate = stayEndDate;
  }


  public MasterRateRatePlan loyaltyPointsAccrue(Boolean loyaltyPointsAccrue) {
    
    this.loyaltyPointsAccrue = loyaltyPointsAccrue;
    return this;
  }

   /**
   * Property honors loyalty points with this rate plan.
   * @return loyaltyPointsAccrue
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Property honors loyalty points with this rate plan.")
  @JsonProperty(JSON_PROPERTY_LOYALTY_POINTS_ACCRUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getLoyaltyPointsAccrue() {
    return loyaltyPointsAccrue;
  }


  @JsonProperty(JSON_PROPERTY_LOYALTY_POINTS_ACCRUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLoyaltyPointsAccrue(Boolean loyaltyPointsAccrue) {
    this.loyaltyPointsAccrue = loyaltyPointsAccrue;
  }


  public MasterRateRatePlan maxAdvanceBookingOffset(Integer maxAdvanceBookingOffset) {
    
    this.maxAdvanceBookingOffset = maxAdvanceBookingOffset;
    return this;
  }

   /**
   * Maximum days before the arrival date for which this rate plan may be booked.
   * @return maxAdvanceBookingOffset
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "10", value = "Maximum days before the arrival date for which this rate plan may be booked.")
  @JsonProperty(JSON_PROPERTY_MAX_ADVANCE_BOOKING_OFFSET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMaxAdvanceBookingOffset() {
    return maxAdvanceBookingOffset;
  }


  @JsonProperty(JSON_PROPERTY_MAX_ADVANCE_BOOKING_OFFSET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMaxAdvanceBookingOffset(Integer maxAdvanceBookingOffset) {
    this.maxAdvanceBookingOffset = maxAdvanceBookingOffset;
  }


  public MasterRateRatePlan minAdvanceBookingOffset(Integer minAdvanceBookingOffset) {
    
    this.minAdvanceBookingOffset = minAdvanceBookingOffset;
    return this;
  }

   /**
   * Minimum days before the arrival date for which this rate plan may be booked.
   * @return minAdvanceBookingOffset
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "3", value = "Minimum days before the arrival date for which this rate plan may be booked.")
  @JsonProperty(JSON_PROPERTY_MIN_ADVANCE_BOOKING_OFFSET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMinAdvanceBookingOffset() {
    return minAdvanceBookingOffset;
  }


  @JsonProperty(JSON_PROPERTY_MIN_ADVANCE_BOOKING_OFFSET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMinAdvanceBookingOffset(Integer minAdvanceBookingOffset) {
    this.minAdvanceBookingOffset = minAdvanceBookingOffset;
  }


  public MasterRateRatePlan minTotalOccupancy(Integer minTotalOccupancy) {
    
    this.minTotalOccupancy = minTotalOccupancy;
    return this;
  }

   /**
   * Defines the minimum number of total occupants required for this rate plan.
   * @return minTotalOccupancy
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "4", value = "Defines the minimum number of total occupants required for this rate plan.")
  @JsonProperty(JSON_PROPERTY_MIN_TOTAL_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMinTotalOccupancy() {
    return minTotalOccupancy;
  }


  @JsonProperty(JSON_PROPERTY_MIN_TOTAL_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMinTotalOccupancy(Integer minTotalOccupancy) {
    this.minTotalOccupancy = minTotalOccupancy;
  }


  public MasterRateRatePlan maxTotalOccupancy(Integer maxTotalOccupancy) {
    
    this.maxTotalOccupancy = maxTotalOccupancy;
    return this;
  }

   /**
   * Defines the maximum number of total occupants required for this rate plan.
   * @return maxTotalOccupancy
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "4", value = "Defines the maximum number of total occupants required for this rate plan.")
  @JsonProperty(JSON_PROPERTY_MAX_TOTAL_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMaxTotalOccupancy() {
    return maxTotalOccupancy;
  }


  @JsonProperty(JSON_PROPERTY_MAX_TOTAL_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMaxTotalOccupancy(Integer maxTotalOccupancy) {
    this.maxTotalOccupancy = maxTotalOccupancy;
  }


  public MasterRateRatePlan minLOS(Integer minLOS) {
    
    this.minLOS = minLOS;
    return this;
  }

   /**
   * Indicates the minimum length of stay required for this rate plan.
   * @return minLOS
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "3", value = "Indicates the minimum length of stay required for this rate plan.")
  @JsonProperty(JSON_PROPERTY_MIN_L_O_S)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMinLOS() {
    return minLOS;
  }


  @JsonProperty(JSON_PROPERTY_MIN_L_O_S)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMinLOS(Integer minLOS) {
    this.minLOS = minLOS;
  }


  public MasterRateRatePlan maxLOS(Integer maxLOS) {
    
    this.maxLOS = maxLOS;
    return this;
  }

   /**
   * Indicates the maximum length of stay.
   * @return maxLOS
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "5", value = "Indicates the maximum length of stay.")
  @JsonProperty(JSON_PROPERTY_MAX_L_O_S)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMaxLOS() {
    return maxLOS;
  }


  @JsonProperty(JSON_PROPERTY_MAX_L_O_S)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMaxLOS(Integer maxLOS) {
    this.maxLOS = maxLOS;
  }


  public MasterRateRatePlan minAge(Integer minAge) {
    
    this.minAge = minAge;
    return this;
  }

   /**
   * The minimum age to qualify for this rate plan.
   * @return minAge
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "26", value = "The minimum age to qualify for this rate plan.")
  @JsonProperty(JSON_PROPERTY_MIN_AGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMinAge() {
    return minAge;
  }


  @JsonProperty(JSON_PROPERTY_MIN_AGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMinAge(Integer minAge) {
    this.minAge = minAge;
  }


  public MasterRateRatePlan maxAge(Integer maxAge) {
    
    this.maxAge = maxAge;
    return this;
  }

   /**
   * The maximum age to qualify for this rate plan.
   * @return maxAge
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "50", value = "The maximum age to qualify for this rate plan.")
  @JsonProperty(JSON_PROPERTY_MAX_AGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMaxAge() {
    return maxAge;
  }


  @JsonProperty(JSON_PROPERTY_MAX_AGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMaxAge(Integer maxAge) {
    this.maxAge = maxAge;
  }


  public MasterRateRatePlan ratePlanLevelFees(List<RatePlanLevelFee> ratePlanLevelFees) {
    
    this.ratePlanLevelFees = ratePlanLevelFees;
    return this;
  }

  public MasterRateRatePlan addRatePlanLevelFeesItem(RatePlanLevelFee ratePlanLevelFeesItem) {
    if (this.ratePlanLevelFees == null) {
      this.ratePlanLevelFees = new ArrayList<>();
    }
    this.ratePlanLevelFees.add(ratePlanLevelFeesItem);
    return this;
  }

   /**
   * This can be a one-time fee such as a cleaning fee
   * @return ratePlanLevelFees
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "This can be a one-time fee such as a cleaning fee")
  @JsonProperty(JSON_PROPERTY_RATE_PLAN_LEVEL_FEES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<RatePlanLevelFee> getRatePlanLevelFees() {
    return ratePlanLevelFees;
  }


  @JsonProperty(JSON_PROPERTY_RATE_PLAN_LEVEL_FEES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRatePlanLevelFees(List<RatePlanLevelFee> ratePlanLevelFees) {
    this.ratePlanLevelFees = ratePlanLevelFees;
  }


  public MasterRateRatePlan availableDaysOfWeek(RatePlanAvailableDaysOfWeek availableDaysOfWeek) {
    
    this.availableDaysOfWeek = availableDaysOfWeek;
    return this;
  }

   /**
   * Get availableDaysOfWeek
   * @return availableDaysOfWeek
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_AVAILABLE_DAYS_OF_WEEK)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public RatePlanAvailableDaysOfWeek getAvailableDaysOfWeek() {
    return availableDaysOfWeek;
  }


  @JsonProperty(JSON_PROPERTY_AVAILABLE_DAYS_OF_WEEK)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAvailableDaysOfWeek(RatePlanAvailableDaysOfWeek availableDaysOfWeek) {
    this.availableDaysOfWeek = availableDaysOfWeek;
  }


  public MasterRateRatePlan arrivalDaysOfWeek(RatePlanArrivalDaysOfWeek arrivalDaysOfWeek) {
    
    this.arrivalDaysOfWeek = arrivalDaysOfWeek;
    return this;
  }

   /**
   * Get arrivalDaysOfWeek
   * @return arrivalDaysOfWeek
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ARRIVAL_DAYS_OF_WEEK)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public RatePlanArrivalDaysOfWeek getArrivalDaysOfWeek() {
    return arrivalDaysOfWeek;
  }


  @JsonProperty(JSON_PROPERTY_ARRIVAL_DAYS_OF_WEEK)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setArrivalDaysOfWeek(RatePlanArrivalDaysOfWeek arrivalDaysOfWeek) {
    this.arrivalDaysOfWeek = arrivalDaysOfWeek;
  }


  public MasterRateRatePlan departureDaysOfWeek(RatePlanDepartureDaysOfWeek departureDaysOfWeek) {
    
    this.departureDaysOfWeek = departureDaysOfWeek;
    return this;
  }

   /**
   * Get departureDaysOfWeek
   * @return departureDaysOfWeek
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DEPARTURE_DAYS_OF_WEEK)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public RatePlanDepartureDaysOfWeek getDepartureDaysOfWeek() {
    return departureDaysOfWeek;
  }


  @JsonProperty(JSON_PROPERTY_DEPARTURE_DAYS_OF_WEEK)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDepartureDaysOfWeek(RatePlanDepartureDaysOfWeek departureDaysOfWeek) {
    this.departureDaysOfWeek = departureDaysOfWeek;
  }


  public MasterRateRatePlan requiredDaysOfWeek(RatePlanRequiredDaysOfWeek requiredDaysOfWeek) {
    
    this.requiredDaysOfWeek = requiredDaysOfWeek;
    return this;
  }

   /**
   * Get requiredDaysOfWeek
   * @return requiredDaysOfWeek
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_REQUIRED_DAYS_OF_WEEK)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public RatePlanRequiredDaysOfWeek getRequiredDaysOfWeek() {
    return requiredDaysOfWeek;
  }


  @JsonProperty(JSON_PROPERTY_REQUIRED_DAYS_OF_WEEK)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRequiredDaysOfWeek(RatePlanRequiredDaysOfWeek requiredDaysOfWeek) {
    this.requiredDaysOfWeek = requiredDaysOfWeek;
  }


  public MasterRateRatePlan earlyCheckInCharge(RatePlanEarlyCheckInCharge earlyCheckInCharge) {
    
    this.earlyCheckInCharge = earlyCheckInCharge;
    return this;
  }

   /**
   * Get earlyCheckInCharge
   * @return earlyCheckInCharge
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_EARLY_CHECK_IN_CHARGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public RatePlanEarlyCheckInCharge getEarlyCheckInCharge() {
    return earlyCheckInCharge;
  }


  @JsonProperty(JSON_PROPERTY_EARLY_CHECK_IN_CHARGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEarlyCheckInCharge(RatePlanEarlyCheckInCharge earlyCheckInCharge) {
    this.earlyCheckInCharge = earlyCheckInCharge;
  }


  public MasterRateRatePlan lateCheckOutCharge(RatePlanLateCheckOutCharge lateCheckOutCharge) {
    
    this.lateCheckOutCharge = lateCheckOutCharge;
    return this;
  }

   /**
   * Get lateCheckOutCharge
   * @return lateCheckOutCharge
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_LATE_CHECK_OUT_CHARGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public RatePlanLateCheckOutCharge getLateCheckOutCharge() {
    return lateCheckOutCharge;
  }


  @JsonProperty(JSON_PROPERTY_LATE_CHECK_OUT_CHARGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLateCheckOutCharge(RatePlanLateCheckOutCharge lateCheckOutCharge) {
    this.lateCheckOutCharge = lateCheckOutCharge;
  }


  public MasterRateRatePlan cancellationPolicyIdentifier(String cancellationPolicyIdentifier) {
    
    this.cancellationPolicyIdentifier = cancellationPolicyIdentifier;
    return this;
  }

   /**
   * The cancellation policy for this rate plan.
   * @return cancellationPolicyIdentifier
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "cancellation-policy-1", required = true, value = "The cancellation policy for this rate plan.")
  @JsonProperty(JSON_PROPERTY_CANCELLATION_POLICY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getCancellationPolicyIdentifier() {
    return cancellationPolicyIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLATION_POLICY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCancellationPolicyIdentifier(String cancellationPolicyIdentifier) {
    this.cancellationPolicyIdentifier = cancellationPolicyIdentifier;
  }


  public MasterRateRatePlan cancellationPolicy(CancellationPolicy cancellationPolicy) {
    
    this.cancellationPolicy = cancellationPolicy;
    return this;
  }

   /**
   * Get cancellationPolicy
   * @return cancellationPolicy
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CANCELLATION_POLICY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CancellationPolicy getCancellationPolicy() {
    return cancellationPolicy;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLATION_POLICY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellationPolicy(CancellationPolicy cancellationPolicy) {
    this.cancellationPolicy = cancellationPolicy;
  }


  public MasterRateRatePlan cancellationPolicyExceptions(CancellationPolicyExceptions cancellationPolicyExceptions) {
    
    this.cancellationPolicyExceptions = cancellationPolicyExceptions;
    return this;
  }

   /**
   * Get cancellationPolicyExceptions
   * @return cancellationPolicyExceptions
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CANCELLATION_POLICY_EXCEPTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CancellationPolicyExceptions getCancellationPolicyExceptions() {
    return cancellationPolicyExceptions;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLATION_POLICY_EXCEPTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellationPolicyExceptions(CancellationPolicyExceptions cancellationPolicyExceptions) {
    this.cancellationPolicyExceptions = cancellationPolicyExceptions;
  }


  public MasterRateRatePlan singleOccupancyRateModifier(RatePlanSingleOccupancyRateModifier singleOccupancyRateModifier) {
    
    this.singleOccupancyRateModifier = singleOccupancyRateModifier;
    return this;
  }

   /**
   * Get singleOccupancyRateModifier
   * @return singleOccupancyRateModifier
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SINGLE_OCCUPANCY_RATE_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public RatePlanSingleOccupancyRateModifier getSingleOccupancyRateModifier() {
    return singleOccupancyRateModifier;
  }


  @JsonProperty(JSON_PROPERTY_SINGLE_OCCUPANCY_RATE_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSingleOccupancyRateModifier(RatePlanSingleOccupancyRateModifier singleOccupancyRateModifier) {
    this.singleOccupancyRateModifier = singleOccupancyRateModifier;
  }


  public MasterRateRatePlan extraPaxRateModifier(RatePlanExtraPaxRateModifier extraPaxRateModifier) {
    
    this.extraPaxRateModifier = extraPaxRateModifier;
    return this;
  }

   /**
   * Get extraPaxRateModifier
   * @return extraPaxRateModifier
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_EXTRA_PAX_RATE_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public RatePlanExtraPaxRateModifier getExtraPaxRateModifier() {
    return extraPaxRateModifier;
  }


  @JsonProperty(JSON_PROPERTY_EXTRA_PAX_RATE_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExtraPaxRateModifier(RatePlanExtraPaxRateModifier extraPaxRateModifier) {
    this.extraPaxRateModifier = extraPaxRateModifier;
  }


  public MasterRateRatePlan extraChildRateModifier(RatePlanExtraChildRateModifier extraChildRateModifier) {
    
    this.extraChildRateModifier = extraChildRateModifier;
    return this;
  }

   /**
   * Get extraChildRateModifier
   * @return extraChildRateModifier
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_EXTRA_CHILD_RATE_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public RatePlanExtraChildRateModifier getExtraChildRateModifier() {
    return extraChildRateModifier;
  }


  @JsonProperty(JSON_PROPERTY_EXTRA_CHILD_RATE_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExtraChildRateModifier(RatePlanExtraChildRateModifier extraChildRateModifier) {
    this.extraChildRateModifier = extraChildRateModifier;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MasterRateRatePlan masterRateRatePlan = (MasterRateRatePlan) o;
    return Objects.equals(this.identifier, masterRateRatePlan.identifier) &&
        Objects.equals(this.hotelIdentifier, masterRateRatePlan.hotelIdentifier) &&
        Objects.equals(this.name, masterRateRatePlan.name) &&
        Objects.equals(this.prepaid, masterRateRatePlan.prepaid) &&
        Objects.equals(this.enabled, masterRateRatePlan.enabled) &&
        Objects.equals(this.breakfast, masterRateRatePlan.breakfast) &&
        Objects.equals(this.brunch, masterRateRatePlan.brunch) &&
        Objects.equals(this.lunch, masterRateRatePlan.lunch) &&
        Objects.equals(this.dinner, masterRateRatePlan.dinner) &&
        Objects.equals(this.allInclusive, masterRateRatePlan.allInclusive) &&
        Objects.equals(this.allInclusivePlusAlcohol, masterRateRatePlan.allInclusivePlusAlcohol) &&
        Objects.equals(this.sellStartDate, masterRateRatePlan.sellStartDate) &&
        Objects.equals(this.sellEndDate, masterRateRatePlan.sellEndDate) &&
        Objects.equals(this.stayStartDate, masterRateRatePlan.stayStartDate) &&
        Objects.equals(this.stayEndDate, masterRateRatePlan.stayEndDate) &&
        Objects.equals(this.loyaltyPointsAccrue, masterRateRatePlan.loyaltyPointsAccrue) &&
        Objects.equals(this.maxAdvanceBookingOffset, masterRateRatePlan.maxAdvanceBookingOffset) &&
        Objects.equals(this.minAdvanceBookingOffset, masterRateRatePlan.minAdvanceBookingOffset) &&
        Objects.equals(this.minTotalOccupancy, masterRateRatePlan.minTotalOccupancy) &&
        Objects.equals(this.maxTotalOccupancy, masterRateRatePlan.maxTotalOccupancy) &&
        Objects.equals(this.minLOS, masterRateRatePlan.minLOS) &&
        Objects.equals(this.maxLOS, masterRateRatePlan.maxLOS) &&
        Objects.equals(this.minAge, masterRateRatePlan.minAge) &&
        Objects.equals(this.maxAge, masterRateRatePlan.maxAge) &&
        Objects.equals(this.ratePlanLevelFees, masterRateRatePlan.ratePlanLevelFees) &&
        Objects.equals(this.availableDaysOfWeek, masterRateRatePlan.availableDaysOfWeek) &&
        Objects.equals(this.arrivalDaysOfWeek, masterRateRatePlan.arrivalDaysOfWeek) &&
        Objects.equals(this.departureDaysOfWeek, masterRateRatePlan.departureDaysOfWeek) &&
        Objects.equals(this.requiredDaysOfWeek, masterRateRatePlan.requiredDaysOfWeek) &&
        Objects.equals(this.earlyCheckInCharge, masterRateRatePlan.earlyCheckInCharge) &&
        Objects.equals(this.lateCheckOutCharge, masterRateRatePlan.lateCheckOutCharge) &&
        Objects.equals(this.cancellationPolicyIdentifier, masterRateRatePlan.cancellationPolicyIdentifier) &&
        Objects.equals(this.cancellationPolicy, masterRateRatePlan.cancellationPolicy) &&
        Objects.equals(this.cancellationPolicyExceptions, masterRateRatePlan.cancellationPolicyExceptions) &&
        Objects.equals(this.singleOccupancyRateModifier, masterRateRatePlan.singleOccupancyRateModifier) &&
        Objects.equals(this.extraPaxRateModifier, masterRateRatePlan.extraPaxRateModifier) &&
        Objects.equals(this.extraChildRateModifier, masterRateRatePlan.extraChildRateModifier);
  }

  @Override
  public int hashCode() {
    return Objects.hash(identifier, hotelIdentifier, name, prepaid, enabled, breakfast, brunch, lunch, dinner, allInclusive, allInclusivePlusAlcohol, sellStartDate, sellEndDate, stayStartDate, stayEndDate, loyaltyPointsAccrue, maxAdvanceBookingOffset, minAdvanceBookingOffset, minTotalOccupancy, maxTotalOccupancy, minLOS, maxLOS, minAge, maxAge, ratePlanLevelFees, availableDaysOfWeek, arrivalDaysOfWeek, departureDaysOfWeek, requiredDaysOfWeek, earlyCheckInCharge, lateCheckOutCharge, cancellationPolicyIdentifier, cancellationPolicy, cancellationPolicyExceptions, singleOccupancyRateModifier, extraPaxRateModifier, extraChildRateModifier);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MasterRateRatePlan {\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    hotelIdentifier: ").append(toIndentedString(hotelIdentifier)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    prepaid: ").append(toIndentedString(prepaid)).append("\n");
    sb.append("    enabled: ").append(toIndentedString(enabled)).append("\n");
    sb.append("    breakfast: ").append(toIndentedString(breakfast)).append("\n");
    sb.append("    brunch: ").append(toIndentedString(brunch)).append("\n");
    sb.append("    lunch: ").append(toIndentedString(lunch)).append("\n");
    sb.append("    dinner: ").append(toIndentedString(dinner)).append("\n");
    sb.append("    allInclusive: ").append(toIndentedString(allInclusive)).append("\n");
    sb.append("    allInclusivePlusAlcohol: ").append(toIndentedString(allInclusivePlusAlcohol)).append("\n");
    sb.append("    sellStartDate: ").append(toIndentedString(sellStartDate)).append("\n");
    sb.append("    sellEndDate: ").append(toIndentedString(sellEndDate)).append("\n");
    sb.append("    stayStartDate: ").append(toIndentedString(stayStartDate)).append("\n");
    sb.append("    stayEndDate: ").append(toIndentedString(stayEndDate)).append("\n");
    sb.append("    loyaltyPointsAccrue: ").append(toIndentedString(loyaltyPointsAccrue)).append("\n");
    sb.append("    maxAdvanceBookingOffset: ").append(toIndentedString(maxAdvanceBookingOffset)).append("\n");
    sb.append("    minAdvanceBookingOffset: ").append(toIndentedString(minAdvanceBookingOffset)).append("\n");
    sb.append("    minTotalOccupancy: ").append(toIndentedString(minTotalOccupancy)).append("\n");
    sb.append("    maxTotalOccupancy: ").append(toIndentedString(maxTotalOccupancy)).append("\n");
    sb.append("    minLOS: ").append(toIndentedString(minLOS)).append("\n");
    sb.append("    maxLOS: ").append(toIndentedString(maxLOS)).append("\n");
    sb.append("    minAge: ").append(toIndentedString(minAge)).append("\n");
    sb.append("    maxAge: ").append(toIndentedString(maxAge)).append("\n");
    sb.append("    ratePlanLevelFees: ").append(toIndentedString(ratePlanLevelFees)).append("\n");
    sb.append("    availableDaysOfWeek: ").append(toIndentedString(availableDaysOfWeek)).append("\n");
    sb.append("    arrivalDaysOfWeek: ").append(toIndentedString(arrivalDaysOfWeek)).append("\n");
    sb.append("    departureDaysOfWeek: ").append(toIndentedString(departureDaysOfWeek)).append("\n");
    sb.append("    requiredDaysOfWeek: ").append(toIndentedString(requiredDaysOfWeek)).append("\n");
    sb.append("    earlyCheckInCharge: ").append(toIndentedString(earlyCheckInCharge)).append("\n");
    sb.append("    lateCheckOutCharge: ").append(toIndentedString(lateCheckOutCharge)).append("\n");
    sb.append("    cancellationPolicyIdentifier: ").append(toIndentedString(cancellationPolicyIdentifier)).append("\n");
    sb.append("    cancellationPolicy: ").append(toIndentedString(cancellationPolicy)).append("\n");
    sb.append("    cancellationPolicyExceptions: ").append(toIndentedString(cancellationPolicyExceptions)).append("\n");
    sb.append("    singleOccupancyRateModifier: ").append(toIndentedString(singleOccupancyRateModifier)).append("\n");
    sb.append("    extraPaxRateModifier: ").append(toIndentedString(extraPaxRateModifier)).append("\n");
    sb.append("    extraChildRateModifier: ").append(toIndentedString(extraChildRateModifier)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

