/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/docs?api=affiliate): All APIs related to selling travel inventory as an affiliate. - [Extranet](/docs?api=extranet): All APIs related to managing travel inventory and suppliers. - [Booking Engine](/docs?api=booking-engine): All APIs related to searching for travel inventory and creating bookings. - [Channel Manager](/docs?api=channel-manager): All APIs related to channel managers who want to integrate with our payment.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.payment-v`1`+json.  ## Release history - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Extranet API Welcome to the Extranet API - A programmer-friendly way to manage your travel inventory on the wink payment. This API offers a superset of the features you can find at [https://extranet.wink.travel](https://extranet.wink.travel) and gives you all the tools you need to ready your properties and inventory for sale across 10000s of our unique sales channels. What differentiates us from existing Extranets is 1. we make it available for everyone to use and 2. the care we take in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Content creators have the ability to make their inventory look great and be searchable in a wide variety of ways. You won't find properties with generic inventory, low resolution pictures and little ancillary content that can easily be found everywhere else on the internet.  # Integrations We have already integrated with the most well-known channel managers so you don't have to. Once your properties are set up, you can finish the setup by mapping your property to wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API. - Allotz - CloudBeds / MyAllocator - Comanche - d-edge - FastBooking - HotelLink - HoteliersGuru - Omnibees - RateGain - Rate Tiger - ResAvenue - Siteminder - Sabre SynXis - Travelclick - Yieldplanet  # Intended Audience Programmers are [most likely] a requirement to start integrating with wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible. - Hotel chains - Hotel brands - Travel tech companies - Destination sites - Integrators - Aggregators - Destination management companies - Travel agencies - OTAs  
 *
 * The version of the OpenAPI document: 20.1.2-SNAPSHOT
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.extranet.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import travel.wink.sdk.extranet.model.ReviewAnswer;
import travel.wink.sdk.extranet.model.ReviewUser;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * User review created by the traveler after the booking completed.
 */
@ApiModel(description = "User review created by the traveler after the booking completed.")
@JsonPropertyOrder({
  Review.JSON_PROPERTY_IDENTIFIER,
  Review.JSON_PROPERTY_BOOKING_IDENTIFIER,
  Review.JSON_PROPERTY_HOTEL_IDENTIFIER,
  Review.JSON_PROPERTY_USER,
  Review.JSON_PROPERTY_REVIEW_DATE,
  Review.JSON_PROPERTY_AVERAGE_SCORE,
  Review.JSON_PROPERTY_ANSWERS,
  Review.JSON_PROPERTY_MESSAGE_FROM_GUEST,
  Review.JSON_PROPERTY_RESPONSE_FROM_HOTEL,
  Review.JSON_PROPERTY_IMAGE_IDENTIFIER,
  Review.JSON_PROPERTY_TEXT,
  Review.JSON_PROPERTY_APPROVED_TEXT,
  Review.JSON_PROPERTY_APPROVED_IMAGE,
  Review.JSON_PROPERTY_LIKES,
  Review.JSON_PROPERTY_ROOM_NUMBER,
  Review.JSON_PROPERTY_ROOM_RATING,
  Review.JSON_PROPERTY_COMPLETED,
  Review.JSON_PROPERTY_RESPONDED
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-06-20T21:56:24.013599+07:00[Asia/Bangkok]")
public class Review {
  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  private String identifier;

  public static final String JSON_PROPERTY_BOOKING_IDENTIFIER = "bookingIdentifier";
  private String bookingIdentifier;

  public static final String JSON_PROPERTY_HOTEL_IDENTIFIER = "hotelIdentifier";
  private String hotelIdentifier;

  public static final String JSON_PROPERTY_USER = "user";
  private ReviewUser user;

  public static final String JSON_PROPERTY_REVIEW_DATE = "reviewDate";
  private OffsetDateTime reviewDate;

  public static final String JSON_PROPERTY_AVERAGE_SCORE = "averageScore";
  private Double averageScore;

  public static final String JSON_PROPERTY_ANSWERS = "answers";
  private List<ReviewAnswer> answers = null;

  public static final String JSON_PROPERTY_MESSAGE_FROM_GUEST = "messageFromGuest";
  private String messageFromGuest;

  public static final String JSON_PROPERTY_RESPONSE_FROM_HOTEL = "responseFromHotel";
  private String responseFromHotel;

  public static final String JSON_PROPERTY_IMAGE_IDENTIFIER = "imageIdentifier";
  private String imageIdentifier;

  public static final String JSON_PROPERTY_TEXT = "text";
  private String text;

  public static final String JSON_PROPERTY_APPROVED_TEXT = "approvedText";
  private Boolean approvedText;

  public static final String JSON_PROPERTY_APPROVED_IMAGE = "approvedImage";
  private Boolean approvedImage;

  public static final String JSON_PROPERTY_LIKES = "likes";
  private List<String> likes = null;

  public static final String JSON_PROPERTY_ROOM_NUMBER = "roomNumber";
  private String roomNumber;

  public static final String JSON_PROPERTY_ROOM_RATING = "roomRating";
  private Integer roomRating;

  public static final String JSON_PROPERTY_COMPLETED = "completed";
  private Boolean completed;

  public static final String JSON_PROPERTY_RESPONDED = "responded";
  private Boolean responded;

  public Review() { 
  }

  public Review identifier(String identifier) {
    
    this.identifier = identifier;
    return this;
  }

   /**
   * Unique review identifier identifying this record.
   * @return identifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "review-1", value = "Unique review identifier identifying this record.")
  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIdentifier(String identifier) {
    this.identifier = identifier;
  }


  public Review bookingIdentifier(String bookingIdentifier) {
    
    this.bookingIdentifier = bookingIdentifier;
    return this;
  }

   /**
   * Booking identifier identifier booking this review is associated with.
   * @return bookingIdentifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "booking-1", value = "Booking identifier identifier booking this review is associated with.")
  @JsonProperty(JSON_PROPERTY_BOOKING_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getBookingIdentifier() {
    return bookingIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_BOOKING_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBookingIdentifier(String bookingIdentifier) {
    this.bookingIdentifier = bookingIdentifier;
  }


  public Review hotelIdentifier(String hotelIdentifier) {
    
    this.hotelIdentifier = hotelIdentifier;
    return this;
  }

   /**
   * Hotel identifier this booking is associated with.
   * @return hotelIdentifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "hotel-1", value = "Hotel identifier this booking is associated with.")
  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getHotelIdentifier() {
    return hotelIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHotelIdentifier(String hotelIdentifier) {
    this.hotelIdentifier = hotelIdentifier;
  }


  public Review user(ReviewUser user) {
    
    this.user = user;
    return this;
  }

   /**
   * Get user
   * @return user
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_USER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ReviewUser getUser() {
    return user;
  }


  @JsonProperty(JSON_PROPERTY_USER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUser(ReviewUser user) {
    this.user = user;
  }


  public Review reviewDate(OffsetDateTime reviewDate) {
    
    this.reviewDate = reviewDate;
    return this;
  }

   /**
   * Date of review.
   * @return reviewDate
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Date of review.")
  @JsonProperty(JSON_PROPERTY_REVIEW_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getReviewDate() {
    return reviewDate;
  }


  @JsonProperty(JSON_PROPERTY_REVIEW_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReviewDate(OffsetDateTime reviewDate) {
    this.reviewDate = reviewDate;
  }


  public Review averageScore(Double averageScore) {
    
    this.averageScore = averageScore;
    return this;
  }

   /**
   * Total points divided by number of questions.
   * @return averageScore
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "8.7", value = "Total points divided by number of questions.")
  @JsonProperty(JSON_PROPERTY_AVERAGE_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getAverageScore() {
    return averageScore;
  }


  @JsonProperty(JSON_PROPERTY_AVERAGE_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAverageScore(Double averageScore) {
    this.averageScore = averageScore;
  }


  public Review answers(List<ReviewAnswer> answers) {
    
    this.answers = answers;
    return this;
  }

  public Review addAnswersItem(ReviewAnswer answersItem) {
    if (this.answers == null) {
      this.answers = new ArrayList<>();
    }
    this.answers.add(answersItem);
    return this;
  }

   /**
   * List of user review answers.
   * @return answers
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "List of user review answers.")
  @JsonProperty(JSON_PROPERTY_ANSWERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ReviewAnswer> getAnswers() {
    return answers;
  }


  @JsonProperty(JSON_PROPERTY_ANSWERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAnswers(List<ReviewAnswer> answers) {
    this.answers = answers;
  }


  public Review messageFromGuest(String messageFromGuest) {
    
    this.messageFromGuest = messageFromGuest;
    return this;
  }

   /**
   * Private message from guest to the hotel. Is not displayed on property profile.
   * @return messageFromGuest
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "Dear GM, I would like to say thank you so much for taking the time to show my husband and I around the premises and the secret cave behind the property.", value = "Private message from guest to the hotel. Is not displayed on property profile.")
  @JsonProperty(JSON_PROPERTY_MESSAGE_FROM_GUEST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMessageFromGuest() {
    return messageFromGuest;
  }


  @JsonProperty(JSON_PROPERTY_MESSAGE_FROM_GUEST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMessageFromGuest(String messageFromGuest) {
    this.messageFromGuest = messageFromGuest;
  }


  public Review responseFromHotel(String responseFromHotel) {
    
    this.responseFromHotel = responseFromHotel;
    return this;
  }

   /**
   * Property can response to traveler review. Response goes on public review profile and can be seen by others.
   * @return responseFromHotel
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "It was so great to have you at our hotel. Please recommend your friends and come again soon.", value = "Property can response to traveler review. Response goes on public review profile and can be seen by others.")
  @JsonProperty(JSON_PROPERTY_RESPONSE_FROM_HOTEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getResponseFromHotel() {
    return responseFromHotel;
  }


  @JsonProperty(JSON_PROPERTY_RESPONSE_FROM_HOTEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setResponseFromHotel(String responseFromHotel) {
    this.responseFromHotel = responseFromHotel;
  }


  public Review imageIdentifier(String imageIdentifier) {
    
    this.imageIdentifier = imageIdentifier;
    return this;
  }

   /**
   * Reviewer can upload her best picture from the property. Cloudinary image identifier.
   * @return imageIdentifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "cloudinary-image-1", value = "Reviewer can upload her best picture from the property. Cloudinary image identifier.")
  @JsonProperty(JSON_PROPERTY_IMAGE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getImageIdentifier() {
    return imageIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_IMAGE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setImageIdentifier(String imageIdentifier) {
    this.imageIdentifier = imageIdentifier;
  }


  public Review text(String text) {
    
    this.text = text;
    return this;
  }

   /**
   * Free text record created by traveler
   * @return text
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "Our stay was amazing! Can recommend highly to all. Felt like home.", value = "Free text record created by traveler")
  @JsonProperty(JSON_PROPERTY_TEXT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getText() {
    return text;
  }


  @JsonProperty(JSON_PROPERTY_TEXT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setText(String text) {
    this.text = text;
  }


  public Review approvedText(Boolean approvedText) {
    
    this.approvedText = approvedText;
    return this;
  }

   /**
   * Hotel allows the review text to be displayed as part of their profile.
   * @return approvedText
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "true", value = "Hotel allows the review text to be displayed as part of their profile.")
  @JsonProperty(JSON_PROPERTY_APPROVED_TEXT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getApprovedText() {
    return approvedText;
  }


  @JsonProperty(JSON_PROPERTY_APPROVED_TEXT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setApprovedText(Boolean approvedText) {
    this.approvedText = approvedText;
  }


  public Review approvedImage(Boolean approvedImage) {
    
    this.approvedImage = approvedImage;
    return this;
  }

   /**
   * Hotel allows the user-generated image to be displayed as part of their profile.
   * @return approvedImage
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Hotel allows the user-generated image to be displayed as part of their profile.")
  @JsonProperty(JSON_PROPERTY_APPROVED_IMAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getApprovedImage() {
    return approvedImage;
  }


  @JsonProperty(JSON_PROPERTY_APPROVED_IMAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setApprovedImage(Boolean approvedImage) {
    this.approvedImage = approvedImage;
  }


  public Review likes(List<String> likes) {
    
    this.likes = likes;
    return this;
  }

  public Review addLikesItem(String likesItem) {
    if (this.likes == null) {
      this.likes = new ArrayList<>();
    }
    this.likes.add(likesItem);
    return this;
  }

   /**
   * List of member identifiers who liked the textual review
   * @return likes
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "user-1,user-2", value = "List of member identifiers who liked the textual review")
  @JsonProperty(JSON_PROPERTY_LIKES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getLikes() {
    return likes;
  }


  @JsonProperty(JSON_PROPERTY_LIKES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLikes(List<String> likes) {
    this.likes = likes;
  }


  public Review roomNumber(String roomNumber) {
    
    this.roomNumber = roomNumber;
    return this;
  }

   /**
   * Guest&#39;s room number during their stay.
   * @return roomNumber
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "501", value = "Guest's room number during their stay.")
  @JsonProperty(JSON_PROPERTY_ROOM_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRoomNumber() {
    return roomNumber;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRoomNumber(String roomNumber) {
    this.roomNumber = roomNumber;
  }


  public Review roomRating(Integer roomRating) {
    
    this.roomRating = roomRating;
    return this;
  }

   /**
   * Guest&#39;s room rating
   * @return roomRating
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "7", value = "Guest's room rating")
  @JsonProperty(JSON_PROPERTY_ROOM_RATING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getRoomRating() {
    return roomRating;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_RATING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRoomRating(Integer roomRating) {
    this.roomRating = roomRating;
  }


  public Review completed(Boolean completed) {
    
    this.completed = completed;
    return this;
  }

   /**
   * When the guest has completed the first and second part of the review.
   * @return completed
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "When the guest has completed the first and second part of the review.")
  @JsonProperty(JSON_PROPERTY_COMPLETED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCompleted() {
    return completed;
  }


  @JsonProperty(JSON_PROPERTY_COMPLETED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCompleted(Boolean completed) {
    this.completed = completed;
  }


  public Review responded(Boolean responded) {
    
    this.responded = responded;
    return this;
  }

   /**
   * Returns true if property has responded to the review given gy the guest.
   * @return responded
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Returns true if property has responded to the review given gy the guest.")
  @JsonProperty(JSON_PROPERTY_RESPONDED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getResponded() {
    return responded;
  }


  @JsonProperty(JSON_PROPERTY_RESPONDED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setResponded(Boolean responded) {
    this.responded = responded;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Review review = (Review) o;
    return Objects.equals(this.identifier, review.identifier) &&
        Objects.equals(this.bookingIdentifier, review.bookingIdentifier) &&
        Objects.equals(this.hotelIdentifier, review.hotelIdentifier) &&
        Objects.equals(this.user, review.user) &&
        Objects.equals(this.reviewDate, review.reviewDate) &&
        Objects.equals(this.averageScore, review.averageScore) &&
        Objects.equals(this.answers, review.answers) &&
        Objects.equals(this.messageFromGuest, review.messageFromGuest) &&
        Objects.equals(this.responseFromHotel, review.responseFromHotel) &&
        Objects.equals(this.imageIdentifier, review.imageIdentifier) &&
        Objects.equals(this.text, review.text) &&
        Objects.equals(this.approvedText, review.approvedText) &&
        Objects.equals(this.approvedImage, review.approvedImage) &&
        Objects.equals(this.likes, review.likes) &&
        Objects.equals(this.roomNumber, review.roomNumber) &&
        Objects.equals(this.roomRating, review.roomRating) &&
        Objects.equals(this.completed, review.completed) &&
        Objects.equals(this.responded, review.responded);
  }

  @Override
  public int hashCode() {
    return Objects.hash(identifier, bookingIdentifier, hotelIdentifier, user, reviewDate, averageScore, answers, messageFromGuest, responseFromHotel, imageIdentifier, text, approvedText, approvedImage, likes, roomNumber, roomRating, completed, responded);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Review {\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    bookingIdentifier: ").append(toIndentedString(bookingIdentifier)).append("\n");
    sb.append("    hotelIdentifier: ").append(toIndentedString(hotelIdentifier)).append("\n");
    sb.append("    user: ").append(toIndentedString(user)).append("\n");
    sb.append("    reviewDate: ").append(toIndentedString(reviewDate)).append("\n");
    sb.append("    averageScore: ").append(toIndentedString(averageScore)).append("\n");
    sb.append("    answers: ").append(toIndentedString(answers)).append("\n");
    sb.append("    messageFromGuest: ").append(toIndentedString(messageFromGuest)).append("\n");
    sb.append("    responseFromHotel: ").append(toIndentedString(responseFromHotel)).append("\n");
    sb.append("    imageIdentifier: ").append(toIndentedString(imageIdentifier)).append("\n");
    sb.append("    text: ").append(toIndentedString(text)).append("\n");
    sb.append("    approvedText: ").append(toIndentedString(approvedText)).append("\n");
    sb.append("    approvedImage: ").append(toIndentedString(approvedImage)).append("\n");
    sb.append("    likes: ").append(toIndentedString(likes)).append("\n");
    sb.append("    roomNumber: ").append(toIndentedString(roomNumber)).append("\n");
    sb.append("    roomRating: ").append(toIndentedString(roomRating)).append("\n");
    sb.append("    completed: ").append(toIndentedString(completed)).append("\n");
    sb.append("    responded: ").append(toIndentedString(responded)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

