/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/docs?api=affiliate): All APIs related to selling travel inventory as an affiliate. - [Extranet](/docs?api=extranet): All APIs related to managing travel inventory and suppliers. - [Booking Engine](/docs?api=booking-engine): All APIs related to searching for travel inventory and creating bookings. - [Channel Manager](/docs?api=channel-manager): All APIs related to channel managers who want to integrate with our payment.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.payment-v`1`+json.  ## Release history - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Extranet API Welcome to the Extranet API - A programmer-friendly way to manage your travel inventory on the wink payment. This API offers a superset of the features you can find at [https://extranet.wink.travel](https://extranet.wink.travel) and gives you all the tools you need to ready your properties and inventory for sale across 10000s of our unique sales channels. What differentiates us from existing Extranets is 1. we make it available for everyone to use and 2. the care we take in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Content creators have the ability to make their inventory look great and be searchable in a wide variety of ways. You won't find properties with generic inventory, low resolution pictures and little ancillary content that can easily be found everywhere else on the internet.  # Integrations We have already integrated with the most well-known channel managers so you don't have to. Once your properties are set up, you can finish the setup by mapping your property to wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API. - Allotz - CloudBeds / MyAllocator - Comanche - d-edge - FastBooking - HotelLink - HoteliersGuru - Omnibees - RateGain - Rate Tiger - ResAvenue - Siteminder - Sabre SynXis - Travelclick - Yieldplanet  # Intended Audience Programmers are [most likely] a requirement to start integrating with wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible. - Hotel chains - Hotel brands - Travel tech companies - Destination sites - Integrators - Aggregators - Destination management companies - Travel agencies - OTAs  
 *
 * The version of the OpenAPI document: 20.1.2-SNAPSHOT
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.extranet.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import travel.wink.sdk.extranet.model.IdentifierNamePair;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * RoomRateRemovableResponse
 */
@JsonPropertyOrder({
  RoomRateRemovableResponse.JSON_PROPERTY_HOTEL_IDENTIFIER,
  RoomRateRemovableResponse.JSON_PROPERTY_MASTER_RATE_IDENTIFIER,
  RoomRateRemovableResponse.JSON_PROPERTY_REMOVABLE,
  RoomRateRemovableResponse.JSON_PROPERTY_RATE_MODIFIERS
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-06-20T21:56:24.013599+07:00[Asia/Bangkok]")
public class RoomRateRemovableResponse {
  public static final String JSON_PROPERTY_HOTEL_IDENTIFIER = "hotelIdentifier";
  private String hotelIdentifier;

  public static final String JSON_PROPERTY_MASTER_RATE_IDENTIFIER = "masterRateIdentifier";
  private String masterRateIdentifier;

  public static final String JSON_PROPERTY_REMOVABLE = "removable";
  private Boolean removable;

  public static final String JSON_PROPERTY_RATE_MODIFIERS = "rateModifiers";
  private List<IdentifierNamePair> rateModifiers = null;

  public RoomRateRemovableResponse() { 
  }

  public RoomRateRemovableResponse hotelIdentifier(String hotelIdentifier) {
    
    this.hotelIdentifier = hotelIdentifier;
    return this;
  }

   /**
   * Master rate owner identifier.
   * @return hotelIdentifier
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "hotel-1", required = true, value = "Master rate owner identifier.")
  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getHotelIdentifier() {
    return hotelIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setHotelIdentifier(String hotelIdentifier) {
    this.hotelIdentifier = hotelIdentifier;
  }


  public RoomRateRemovableResponse masterRateIdentifier(String masterRateIdentifier) {
    
    this.masterRateIdentifier = masterRateIdentifier;
    return this;
  }

   /**
   * Master rate identifier seeking to be removed.
   * @return masterRateIdentifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "master-rate-1", value = "Master rate identifier seeking to be removed.")
  @JsonProperty(JSON_PROPERTY_MASTER_RATE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMasterRateIdentifier() {
    return masterRateIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_MASTER_RATE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMasterRateIdentifier(String masterRateIdentifier) {
    this.masterRateIdentifier = masterRateIdentifier;
  }


  public RoomRateRemovableResponse removable(Boolean removable) {
    
    this.removable = removable;
    return this;
  }

   /**
   * Returns true if master rate can be removed.
   * @return removable
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Returns true if master rate can be removed.")
  @JsonProperty(JSON_PROPERTY_REMOVABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getRemovable() {
    return removable;
  }


  @JsonProperty(JSON_PROPERTY_REMOVABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRemovable(Boolean removable) {
    this.removable = removable;
  }


  public RoomRateRemovableResponse rateModifiers(List<IdentifierNamePair> rateModifiers) {
    
    this.rateModifiers = rateModifiers;
    return this;
  }

  public RoomRateRemovableResponse addRateModifiersItem(IdentifierNamePair rateModifiersItem) {
    if (this.rateModifiers == null) {
      this.rateModifiers = new ArrayList<>();
    }
    this.rateModifiers.add(rateModifiersItem);
    return this;
  }

   /**
   * Promotions
   * @return rateModifiers
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Promotions")
  @JsonProperty(JSON_PROPERTY_RATE_MODIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<IdentifierNamePair> getRateModifiers() {
    return rateModifiers;
  }


  @JsonProperty(JSON_PROPERTY_RATE_MODIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRateModifiers(List<IdentifierNamePair> rateModifiers) {
    this.rateModifiers = rateModifiers;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RoomRateRemovableResponse roomRateRemovableResponse = (RoomRateRemovableResponse) o;
    return Objects.equals(this.hotelIdentifier, roomRateRemovableResponse.hotelIdentifier) &&
        Objects.equals(this.masterRateIdentifier, roomRateRemovableResponse.masterRateIdentifier) &&
        Objects.equals(this.removable, roomRateRemovableResponse.removable) &&
        Objects.equals(this.rateModifiers, roomRateRemovableResponse.rateModifiers);
  }

  @Override
  public int hashCode() {
    return Objects.hash(hotelIdentifier, masterRateIdentifier, removable, rateModifiers);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RoomRateRemovableResponse {\n");
    sb.append("    hotelIdentifier: ").append(toIndentedString(hotelIdentifier)).append("\n");
    sb.append("    masterRateIdentifier: ").append(toIndentedString(masterRateIdentifier)).append("\n");
    sb.append("    removable: ").append(toIndentedString(removable)).append("\n");
    sb.append("    rateModifiers: ").append(toIndentedString(rateModifiers)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

