/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.api;

import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.extranet.invoker.ApiClient;
import travel.wink.sdk.extranet.model.CreateScheduleItemRequest;
import travel.wink.sdk.extranet.model.RemoveEntryResponse;
import travel.wink.sdk.extranet.model.ScheduleItemView;
import travel.wink.sdk.extranet.model.UpdateScheduleItemRequest;

public class SchedulerApi {
    private ApiClient apiClient;

    public SchedulerApi() {
        this(new ApiClient());
    }

    @Autowired
    public SchedulerApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec createScheduleItemRequestCreation(String hotelIdentifier, String inventoryIdentifier, CreateScheduleItemRequest createScheduleItemRequest) throws WebClientResponseException {
        CreateScheduleItemRequest postBody = createScheduleItemRequest;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling createScheduleItem", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (inventoryIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'inventoryIdentifier' when calling createScheduleItem", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (createScheduleItemRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'createScheduleItemRequest' when calling createScheduleItem", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("inventoryIdentifier", inventoryIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/vnd.platform-v1+json", "application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<ScheduleItemView> localVarReturnType = new ParameterizedTypeReference<ScheduleItemView>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/schedule/{inventoryIdentifier}", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<ScheduleItemView> createScheduleItem(String hotelIdentifier, String inventoryIdentifier, CreateScheduleItemRequest createScheduleItemRequest) throws WebClientResponseException {
        ParameterizedTypeReference<ScheduleItemView> localVarReturnType = new ParameterizedTypeReference<ScheduleItemView>(){};
        return this.createScheduleItemRequestCreation(hotelIdentifier, inventoryIdentifier, createScheduleItemRequest).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<ScheduleItemView>> createScheduleItemWithHttpInfo(String hotelIdentifier, String inventoryIdentifier, CreateScheduleItemRequest createScheduleItemRequest) throws WebClientResponseException {
        ParameterizedTypeReference<ScheduleItemView> localVarReturnType = new ParameterizedTypeReference<ScheduleItemView>(){};
        return this.createScheduleItemRequestCreation(hotelIdentifier, inventoryIdentifier, createScheduleItemRequest).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec removeScheduleItemRequestCreation(String hotelIdentifier, String inventoryIdentifier, String identifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling removeScheduleItem", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (inventoryIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'inventoryIdentifier' when calling removeScheduleItem", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (identifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'identifier' when calling removeScheduleItem", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("inventoryIdentifier", inventoryIdentifier);
        pathParams.put("identifier", identifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/schedule/{inventoryIdentifier}/item/{identifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RemoveEntryResponse> removeScheduleItem(String hotelIdentifier, String inventoryIdentifier, String identifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>(){};
        return this.removeScheduleItemRequestCreation(hotelIdentifier, inventoryIdentifier, identifier, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RemoveEntryResponse>> removeScheduleItemWithHttpInfo(String hotelIdentifier, String inventoryIdentifier, String identifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>(){};
        return this.removeScheduleItemRequestCreation(hotelIdentifier, inventoryIdentifier, identifier, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showScheduleItemsRequestCreation(String hotelIdentifier, String inventoryIdentifier, OffsetDateTime start, OffsetDateTime end, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showScheduleItems", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (inventoryIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'inventoryIdentifier' when calling showScheduleItems", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (start == null) {
            throw new WebClientResponseException("Missing the required parameter 'start' when calling showScheduleItems", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (end == null) {
            throw new WebClientResponseException("Missing the required parameter 'end' when calling showScheduleItems", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("inventoryIdentifier", inventoryIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "start", start));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "end", end));
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<ScheduleItemView> localVarReturnType = new ParameterizedTypeReference<ScheduleItemView>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/schedule/{inventoryIdentifier}/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<ScheduleItemView> showScheduleItems(String hotelIdentifier, String inventoryIdentifier, OffsetDateTime start, OffsetDateTime end, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<ScheduleItemView> localVarReturnType = new ParameterizedTypeReference<ScheduleItemView>(){};
        return this.showScheduleItemsRequestCreation(hotelIdentifier, inventoryIdentifier, start, end, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<ScheduleItemView>>> showScheduleItemsWithHttpInfo(String hotelIdentifier, String inventoryIdentifier, OffsetDateTime start, OffsetDateTime end, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<ScheduleItemView> localVarReturnType = new ParameterizedTypeReference<ScheduleItemView>(){};
        return this.showScheduleItemsRequestCreation(hotelIdentifier, inventoryIdentifier, start, end, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec updateScheduleItemRequestCreation(String hotelIdentifier, String inventoryIdentifier, String identifier, UpdateScheduleItemRequest updateScheduleItemRequest) throws WebClientResponseException {
        UpdateScheduleItemRequest postBody = updateScheduleItemRequest;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling updateScheduleItem", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (inventoryIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'inventoryIdentifier' when calling updateScheduleItem", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (identifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'identifier' when calling updateScheduleItem", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (updateScheduleItemRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'updateScheduleItemRequest' when calling updateScheduleItem", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("inventoryIdentifier", inventoryIdentifier);
        pathParams.put("identifier", identifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/vnd.platform-v1+json", "application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<ScheduleItemView> localVarReturnType = new ParameterizedTypeReference<ScheduleItemView>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/schedule/{inventoryIdentifier}/item/{identifier}", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<ScheduleItemView> updateScheduleItem(String hotelIdentifier, String inventoryIdentifier, String identifier, UpdateScheduleItemRequest updateScheduleItemRequest) throws WebClientResponseException {
        ParameterizedTypeReference<ScheduleItemView> localVarReturnType = new ParameterizedTypeReference<ScheduleItemView>(){};
        return this.updateScheduleItemRequestCreation(hotelIdentifier, inventoryIdentifier, identifier, updateScheduleItemRequest).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<ScheduleItemView>> updateScheduleItemWithHttpInfo(String hotelIdentifier, String inventoryIdentifier, String identifier, UpdateScheduleItemRequest updateScheduleItemRequest) throws WebClientResponseException {
        ParameterizedTypeReference<ScheduleItemView> localVarReturnType = new ParameterizedTypeReference<ScheduleItemView>(){};
        return this.updateScheduleItemRequestCreation(hotelIdentifier, inventoryIdentifier, identifier, updateScheduleItemRequest).toEntity((ParameterizedTypeReference)localVarReturnType);
    }
}

