/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.validation.Valid;
import travel.wink.sdk.extranet.model.AddOnOffers;
import travel.wink.sdk.extranet.model.BookingAddress;
import travel.wink.sdk.extranet.model.BookingContactInfo;
import travel.wink.sdk.extranet.model.BookingContract;
import travel.wink.sdk.extranet.model.BookingInternalTotal;
import travel.wink.sdk.extranet.model.BookingSourceTotal;
import travel.wink.sdk.extranet.model.BookingUser;
import travel.wink.sdk.extranet.model.BookingUserSpecifiedCurrencyTotal;
import travel.wink.sdk.extranet.model.CommissionableEntry;
import travel.wink.sdk.extranet.model.EngineConfigurationBookingReport;
import travel.wink.sdk.extranet.model.ExtraBookingRequest;
import travel.wink.sdk.extranet.model.HotelOnMap;
import travel.wink.sdk.extranet.model.Moneys;
import travel.wink.sdk.extranet.model.PackageOffers;
import travel.wink.sdk.extranet.model.Review;
import travel.wink.sdk.extranet.model.RoomStay;
import travel.wink.sdk.extranet.model.Social;
import travel.wink.sdk.extranet.model.UserSession;

@ApiModel(description="Booking data object")
@JsonPropertyOrder(value={"test", "date", "groupIdentifier", "identifier", "engineConfiguration", "bookingCode", "user", "userSession", "serverUrl", "contactInfo", "address", "socials", "review", "emailHeaderLogoUrl", "logoIdentifier", "hotel", "roomStay", "specialRequests", "comment", "packageOffers", "addOnOffers", "earlyCheckInCharge", "lateCheckOutCharge", "earlyCheckInChargePercent", "lateCheckOutChargePercent", "hotelImageUrl", "roomImageUrl", "commissionList", "bookingContract", "userSpecifiedCurrencyTotal", "status", "endDate", "fullAddress", "sourceTotal", "internalTotal", "rateSource", "startDate", "meetingRooms", "restaurants", "activities", "attractions", "spas", "places"})
public class Booking {
    public static final String JSON_PROPERTY_TEST = "test";
    private Boolean test;
    public static final String JSON_PROPERTY_DATE = "date";
    private OffsetDateTime date;
    public static final String JSON_PROPERTY_GROUP_IDENTIFIER = "groupIdentifier";
    private String groupIdentifier;
    public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
    private String identifier;
    public static final String JSON_PROPERTY_ENGINE_CONFIGURATION = "engineConfiguration";
    private EngineConfigurationBookingReport engineConfiguration;
    public static final String JSON_PROPERTY_BOOKING_CODE = "bookingCode";
    private String bookingCode;
    public static final String JSON_PROPERTY_USER = "user";
    private BookingUser user;
    public static final String JSON_PROPERTY_USER_SESSION = "userSession";
    private UserSession userSession;
    public static final String JSON_PROPERTY_SERVER_URL = "serverUrl";
    private String serverUrl;
    public static final String JSON_PROPERTY_CONTACT_INFO = "contactInfo";
    private BookingContactInfo contactInfo;
    public static final String JSON_PROPERTY_ADDRESS = "address";
    private BookingAddress address;
    public static final String JSON_PROPERTY_SOCIALS = "socials";
    private List<Social> socials = null;
    public static final String JSON_PROPERTY_REVIEW = "review";
    private Review review;
    public static final String JSON_PROPERTY_EMAIL_HEADER_LOGO_URL = "emailHeaderLogoUrl";
    private String emailHeaderLogoUrl;
    public static final String JSON_PROPERTY_LOGO_IDENTIFIER = "logoIdentifier";
    private String logoIdentifier;
    public static final String JSON_PROPERTY_HOTEL = "hotel";
    private HotelOnMap hotel;
    public static final String JSON_PROPERTY_ROOM_STAY = "roomStay";
    private RoomStay roomStay;
    public static final String JSON_PROPERTY_SPECIAL_REQUESTS = "specialRequests";
    private String specialRequests;
    public static final String JSON_PROPERTY_COMMENT = "comment";
    private String comment;
    public static final String JSON_PROPERTY_PACKAGE_OFFERS = "packageOffers";
    private PackageOffers packageOffers;
    public static final String JSON_PROPERTY_ADD_ON_OFFERS = "addOnOffers";
    private AddOnOffers addOnOffers;
    public static final String JSON_PROPERTY_EARLY_CHECK_IN_CHARGE = "earlyCheckInCharge";
    private Moneys earlyCheckInCharge;
    public static final String JSON_PROPERTY_LATE_CHECK_OUT_CHARGE = "lateCheckOutCharge";
    private Moneys lateCheckOutCharge;
    public static final String JSON_PROPERTY_EARLY_CHECK_IN_CHARGE_PERCENT = "earlyCheckInChargePercent";
    private Float earlyCheckInChargePercent;
    public static final String JSON_PROPERTY_LATE_CHECK_OUT_CHARGE_PERCENT = "lateCheckOutChargePercent";
    private Float lateCheckOutChargePercent;
    public static final String JSON_PROPERTY_HOTEL_IMAGE_URL = "hotelImageUrl";
    private String hotelImageUrl;
    public static final String JSON_PROPERTY_ROOM_IMAGE_URL = "roomImageUrl";
    private String roomImageUrl;
    public static final String JSON_PROPERTY_COMMISSION_LIST = "commissionList";
    private List<CommissionableEntry> commissionList = null;
    public static final String JSON_PROPERTY_BOOKING_CONTRACT = "bookingContract";
    private BookingContract bookingContract;
    public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_TOTAL = "userSpecifiedCurrencyTotal";
    private BookingUserSpecifiedCurrencyTotal userSpecifiedCurrencyTotal;
    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status;
    public static final String JSON_PROPERTY_END_DATE = "endDate";
    private LocalDate endDate;
    public static final String JSON_PROPERTY_FULL_ADDRESS = "fullAddress";
    private String fullAddress;
    public static final String JSON_PROPERTY_SOURCE_TOTAL = "sourceTotal";
    private BookingSourceTotal sourceTotal;
    public static final String JSON_PROPERTY_INTERNAL_TOTAL = "internalTotal";
    private BookingInternalTotal internalTotal;
    public static final String JSON_PROPERTY_RATE_SOURCE = "rateSource";
    private RateSourceEnum rateSource;
    public static final String JSON_PROPERTY_START_DATE = "startDate";
    private LocalDate startDate;
    public static final String JSON_PROPERTY_MEETING_ROOMS = "meetingRooms";
    private List<ExtraBookingRequest> meetingRooms = null;
    public static final String JSON_PROPERTY_RESTAURANTS = "restaurants";
    private List<ExtraBookingRequest> restaurants = null;
    public static final String JSON_PROPERTY_ACTIVITIES = "activities";
    private List<ExtraBookingRequest> activities = null;
    public static final String JSON_PROPERTY_ATTRACTIONS = "attractions";
    private List<ExtraBookingRequest> attractions = null;
    public static final String JSON_PROPERTY_SPAS = "spas";
    private List<ExtraBookingRequest> spas = null;
    public static final String JSON_PROPERTY_PLACES = "places";
    private List<ExtraBookingRequest> places = null;

    public Booking test(Boolean test) {
        this.test = test;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Whether this was a test booking by the property than can safely be deleted again")
    @JsonProperty(value="test")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getTest() {
        return this.test;
    }

    @JsonProperty(value="test")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTest(Boolean test) {
        this.test = test;
    }

    public Booking date(OffsetDateTime date) {
        this.date = date;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Date and time the booking was made.")
    @JsonProperty(value="date")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getDate() {
        return this.date;
    }

    @JsonProperty(value="date")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDate(OffsetDateTime date) {
        this.date = date;
    }

    public Booking groupIdentifier(String groupIdentifier) {
        this.groupIdentifier = groupIdentifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="document-1", value="Unique record identifier for the collection of bookings that were made at the same time.")
    @JsonProperty(value="groupIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getGroupIdentifier() {
        return this.groupIdentifier;
    }

    @JsonProperty(value="groupIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGroupIdentifier(String groupIdentifier) {
        this.groupIdentifier = groupIdentifier;
    }

    public Booking identifier(String identifier) {
        this.identifier = identifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="document-1", value="Unique record identifier")
    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public Booking engineConfiguration(EngineConfigurationBookingReport engineConfiguration) {
        this.engineConfiguration = engineConfiguration;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="engineConfiguration")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public EngineConfigurationBookingReport getEngineConfiguration() {
        return this.engineConfiguration;
    }

    @JsonProperty(value="engineConfiguration")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEngineConfiguration(EngineConfigurationBookingReport engineConfiguration) {
        this.engineConfiguration = engineConfiguration;
    }

    public Booking bookingCode(String bookingCode) {
        this.bookingCode = bookingCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="ABC1234", value="Unique user-friendly booking geoname. This code should be used when corresponding with travelers.")
    @JsonProperty(value="bookingCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBookingCode() {
        return this.bookingCode;
    }

    @JsonProperty(value="bookingCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBookingCode(String bookingCode) {
        this.bookingCode = bookingCode;
    }

    public Booking user(BookingUser user) {
        this.user = user;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="user")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BookingUser getUser() {
        return this.user;
    }

    @JsonProperty(value="user")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUser(BookingUser user) {
        this.user = user;
    }

    public Booking userSession(UserSession userSession) {
        this.userSession = userSession;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="userSession")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UserSession getUserSession() {
        return this.userSession;
    }

    @JsonProperty(value="userSession")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUserSession(UserSession userSession) {
        this.userSession = userSession;
    }

    public Booking serverUrl(String serverUrl) {
        this.serverUrl = serverUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The URL the booking occurred")
    @JsonProperty(value="serverUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getServerUrl() {
        return this.serverUrl;
    }

    @JsonProperty(value="serverUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public Booking contactInfo(BookingContactInfo contactInfo) {
        this.contactInfo = contactInfo;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="contactInfo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BookingContactInfo getContactInfo() {
        return this.contactInfo;
    }

    @JsonProperty(value="contactInfo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setContactInfo(BookingContactInfo contactInfo) {
        this.contactInfo = contactInfo;
    }

    public Booking address(BookingAddress address) {
        this.address = address;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BookingAddress getAddress() {
        return this.address;
    }

    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAddress(BookingAddress address) {
        this.address = address;
    }

    public Booking socials(List<Social> socials) {
        this.socials = socials;
        return this;
    }

    public Booking addSocialsItem(Social socialsItem) {
        if (this.socials == null) {
            this.socials = new ArrayList<Social>();
        }
        this.socials.add(socialsItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="List of all social network account property has for the traveler to get in touch.")
    @JsonProperty(value="socials")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Social> getSocials() {
        return this.socials;
    }

    @JsonProperty(value="socials")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSocials(List<Social> socials) {
        this.socials = socials;
    }

    public Booking review(Review review) {
        this.review = review;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="review")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Review getReview() {
        return this.review;
    }

    @JsonProperty(value="review")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReview(Review review) {
        this.review = review;
    }

    public Booking emailHeaderLogoUrl(String emailHeaderLogoUrl) {
        this.emailHeaderLogoUrl = emailHeaderLogoUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Full url of the image logo optimized for emails")
    @JsonProperty(value="emailHeaderLogoUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEmailHeaderLogoUrl() {
        return this.emailHeaderLogoUrl;
    }

    @JsonProperty(value="emailHeaderLogoUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEmailHeaderLogoUrl(String emailHeaderLogoUrl) {
        this.emailHeaderLogoUrl = emailHeaderLogoUrl;
    }

    public Booking logoIdentifier(String logoIdentifier) {
        this.logoIdentifier = logoIdentifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Logo cloudinary identifier for potential reuse")
    @JsonProperty(value="logoIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLogoIdentifier() {
        return this.logoIdentifier;
    }

    @JsonProperty(value="logoIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLogoIdentifier(String logoIdentifier) {
        this.logoIdentifier = logoIdentifier;
    }

    public Booking hotel(HotelOnMap hotel) {
        this.hotel = hotel;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="hotel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public HotelOnMap getHotel() {
        return this.hotel;
    }

    @JsonProperty(value="hotel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHotel(HotelOnMap hotel) {
        this.hotel = hotel;
    }

    public Booking roomStay(RoomStay roomStay) {
        this.roomStay = roomStay;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="roomStay")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public RoomStay getRoomStay() {
        return this.roomStay;
    }

    @JsonProperty(value="roomStay")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRoomStay(RoomStay roomStay) {
        this.roomStay = roomStay;
    }

    public Booking specialRequests(String specialRequests) {
        this.specialRequests = specialRequests;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Free text where the traveler can add a message to the property.")
    @JsonProperty(value="specialRequests")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSpecialRequests() {
        return this.specialRequests;
    }

    @JsonProperty(value="specialRequests")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSpecialRequests(String specialRequests) {
        this.specialRequests = specialRequests;
    }

    public Booking comment(String comment) {
        this.comment = comment;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Internal comment field the payment can add and make available to channel manager partners.")
    @JsonProperty(value="comment")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getComment() {
        return this.comment;
    }

    @JsonProperty(value="comment")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setComment(String comment) {
        this.comment = comment;
    }

    public Booking packageOffers(PackageOffers packageOffers) {
        this.packageOffers = packageOffers;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="packageOffers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PackageOffers getPackageOffers() {
        return this.packageOffers;
    }

    @JsonProperty(value="packageOffers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPackageOffers(PackageOffers packageOffers) {
        this.packageOffers = packageOffers;
    }

    public Booking addOnOffers(AddOnOffers addOnOffers) {
        this.addOnOffers = addOnOffers;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="addOnOffers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AddOnOffers getAddOnOffers() {
        return this.addOnOffers;
    }

    @JsonProperty(value="addOnOffers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAddOnOffers(AddOnOffers addOnOffers) {
        this.addOnOffers = addOnOffers;
    }

    public Booking earlyCheckInCharge(Moneys earlyCheckInCharge) {
        this.earlyCheckInCharge = earlyCheckInCharge;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="earlyCheckInCharge")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Moneys getEarlyCheckInCharge() {
        return this.earlyCheckInCharge;
    }

    @JsonProperty(value="earlyCheckInCharge")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEarlyCheckInCharge(Moneys earlyCheckInCharge) {
        this.earlyCheckInCharge = earlyCheckInCharge;
    }

    public Booking lateCheckOutCharge(Moneys lateCheckOutCharge) {
        this.lateCheckOutCharge = lateCheckOutCharge;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="lateCheckOutCharge")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Moneys getLateCheckOutCharge() {
        return this.lateCheckOutCharge;
    }

    @JsonProperty(value="lateCheckOutCharge")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLateCheckOutCharge(Moneys lateCheckOutCharge) {
        this.lateCheckOutCharge = lateCheckOutCharge;
    }

    public Booking earlyCheckInChargePercent(Float earlyCheckInChargePercent) {
        this.earlyCheckInChargePercent = earlyCheckInChargePercent;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="0.05", value="Early check-in charge calculated in percent of first room night price.")
    @JsonProperty(value="earlyCheckInChargePercent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Float getEarlyCheckInChargePercent() {
        return this.earlyCheckInChargePercent;
    }

    @JsonProperty(value="earlyCheckInChargePercent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEarlyCheckInChargePercent(Float earlyCheckInChargePercent) {
        this.earlyCheckInChargePercent = earlyCheckInChargePercent;
    }

    public Booking lateCheckOutChargePercent(Float lateCheckOutChargePercent) {
        this.lateCheckOutChargePercent = lateCheckOutChargePercent;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="0.05", value="Early check-in charge calculated in percent of first room night price.")
    @JsonProperty(value="lateCheckOutChargePercent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Float getLateCheckOutChargePercent() {
        return this.lateCheckOutChargePercent;
    }

    @JsonProperty(value="lateCheckOutChargePercent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLateCheckOutChargePercent(Float lateCheckOutChargePercent) {
        this.lateCheckOutChargePercent = lateCheckOutChargePercent;
    }

    public Booking hotelImageUrl(String hotelImageUrl) {
        this.hotelImageUrl = hotelImageUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="https://path.to/property-image.jpg", value="Absolute URL of hotel image that can be used as-is")
    @JsonProperty(value="hotelImageUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getHotelImageUrl() {
        return this.hotelImageUrl;
    }

    @JsonProperty(value="hotelImageUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHotelImageUrl(String hotelImageUrl) {
        this.hotelImageUrl = hotelImageUrl;
    }

    public Booking roomImageUrl(String roomImageUrl) {
        this.roomImageUrl = roomImageUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="https://path.to/room-image.jpg", value="Absolute URL of room image that can be used as-is")
    @JsonProperty(value="roomImageUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRoomImageUrl() {
        return this.roomImageUrl;
    }

    @JsonProperty(value="roomImageUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRoomImageUrl(String roomImageUrl) {
        this.roomImageUrl = roomImageUrl;
    }

    public Booking commissionList(List<CommissionableEntry> commissionList) {
        this.commissionList = commissionList;
        return this;
    }

    public Booking addCommissionListItem(CommissionableEntry commissionListItem) {
        if (this.commissionList == null) {
            this.commissionList = new ArrayList<CommissionableEntry>();
        }
        this.commissionList.add(commissionListItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="List of all travel inventory entries that are due a commission to the affiliate.")
    @JsonProperty(value="commissionList")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<CommissionableEntry> getCommissionList() {
        return this.commissionList;
    }

    @JsonProperty(value="commissionList")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCommissionList(List<CommissionableEntry> commissionList) {
        this.commissionList = commissionList;
    }

    public Booking bookingContract(BookingContract bookingContract) {
        this.bookingContract = bookingContract;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="bookingContract")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BookingContract getBookingContract() {
        return this.bookingContract;
    }

    @JsonProperty(value="bookingContract")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBookingContract(BookingContract bookingContract) {
        this.bookingContract = bookingContract;
    }

    public Booking userSpecifiedCurrencyTotal(BookingUserSpecifiedCurrencyTotal userSpecifiedCurrencyTotal) {
        this.userSpecifiedCurrencyTotal = userSpecifiedCurrencyTotal;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="userSpecifiedCurrencyTotal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BookingUserSpecifiedCurrencyTotal getUserSpecifiedCurrencyTotal() {
        return this.userSpecifiedCurrencyTotal;
    }

    @JsonProperty(value="userSpecifiedCurrencyTotal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUserSpecifiedCurrencyTotal(BookingUserSpecifiedCurrencyTotal userSpecifiedCurrencyTotal) {
        this.userSpecifiedCurrencyTotal = userSpecifiedCurrencyTotal;
    }

    public Booking status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="ACTIVE", value="Convenience data point to show which status the booking currently has.")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public Booking endDate(LocalDate endDate) {
        this.endDate = endDate;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(example="Tue Jan 07 07:00:00 ICT 2020", value="Guest departure date.")
    @JsonProperty(value="endDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDate getEndDate() {
        return this.endDate;
    }

    @JsonProperty(value="endDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public Booking fullAddress(String fullAddress) {
        this.fullAddress = fullAddress;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="204 At home lane, Singapore, Singapore 224333", value="Convenience data point to return the full hotel address.")
    @JsonProperty(value="fullAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFullAddress() {
        return this.fullAddress;
    }

    @JsonProperty(value="fullAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFullAddress(String fullAddress) {
        this.fullAddress = fullAddress;
    }

    public Booking sourceTotal(BookingSourceTotal sourceTotal) {
        this.sourceTotal = sourceTotal;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="sourceTotal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BookingSourceTotal getSourceTotal() {
        return this.sourceTotal;
    }

    @JsonProperty(value="sourceTotal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSourceTotal(BookingSourceTotal sourceTotal) {
        this.sourceTotal = sourceTotal;
    }

    public Booking internalTotal(BookingInternalTotal internalTotal) {
        this.internalTotal = internalTotal;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="internalTotal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BookingInternalTotal getInternalTotal() {
        return this.internalTotal;
    }

    @JsonProperty(value="internalTotal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInternalTotal(BookingInternalTotal internalTotal) {
        this.internalTotal = internalTotal;
    }

    public Booking rateSource(RateSourceEnum rateSource) {
        this.rateSource = rateSource;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="SITEMINDER", value="Rate origin. This is usually the property channel manager.")
    @JsonProperty(value="rateSource")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public RateSourceEnum getRateSource() {
        return this.rateSource;
    }

    @JsonProperty(value="rateSource")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRateSource(RateSourceEnum rateSource) {
        this.rateSource = rateSource;
    }

    public Booking startDate(LocalDate startDate) {
        this.startDate = startDate;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(example="Wed Jan 01 07:00:00 ICT 2020", value="Guest arrival date.")
    @JsonProperty(value="startDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDate getStartDate() {
        return this.startDate;
    }

    @JsonProperty(value="startDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public Booking meetingRooms(List<ExtraBookingRequest> meetingRooms) {
        this.meetingRooms = meetingRooms;
        return this;
    }

    public Booking addMeetingRoomsItem(ExtraBookingRequest meetingRoomsItem) {
        if (this.meetingRooms == null) {
            this.meetingRooms = new ArrayList<ExtraBookingRequest>();
        }
        this.meetingRooms.add(meetingRoomsItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Meeting room reservation records.")
    @JsonProperty(value="meetingRooms")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ExtraBookingRequest> getMeetingRooms() {
        return this.meetingRooms;
    }

    @JsonProperty(value="meetingRooms")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMeetingRooms(List<ExtraBookingRequest> meetingRooms) {
        this.meetingRooms = meetingRooms;
    }

    public Booking restaurants(List<ExtraBookingRequest> restaurants) {
        this.restaurants = restaurants;
        return this;
    }

    public Booking addRestaurantsItem(ExtraBookingRequest restaurantsItem) {
        if (this.restaurants == null) {
            this.restaurants = new ArrayList<ExtraBookingRequest>();
        }
        this.restaurants.add(restaurantsItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Restaurant reservation records.")
    @JsonProperty(value="restaurants")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ExtraBookingRequest> getRestaurants() {
        return this.restaurants;
    }

    @JsonProperty(value="restaurants")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRestaurants(List<ExtraBookingRequest> restaurants) {
        this.restaurants = restaurants;
    }

    public Booking activities(List<ExtraBookingRequest> activities) {
        this.activities = activities;
        return this;
    }

    public Booking addActivitiesItem(ExtraBookingRequest activitiesItem) {
        if (this.activities == null) {
            this.activities = new ArrayList<ExtraBookingRequest>();
        }
        this.activities.add(activitiesItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Activity reservation records.")
    @JsonProperty(value="activities")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ExtraBookingRequest> getActivities() {
        return this.activities;
    }

    @JsonProperty(value="activities")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setActivities(List<ExtraBookingRequest> activities) {
        this.activities = activities;
    }

    public Booking attractions(List<ExtraBookingRequest> attractions) {
        this.attractions = attractions;
        return this;
    }

    public Booking addAttractionsItem(ExtraBookingRequest attractionsItem) {
        if (this.attractions == null) {
            this.attractions = new ArrayList<ExtraBookingRequest>();
        }
        this.attractions.add(attractionsItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Attraction reservation records.")
    @JsonProperty(value="attractions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ExtraBookingRequest> getAttractions() {
        return this.attractions;
    }

    @JsonProperty(value="attractions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAttractions(List<ExtraBookingRequest> attractions) {
        this.attractions = attractions;
    }

    public Booking spas(List<ExtraBookingRequest> spas) {
        this.spas = spas;
        return this;
    }

    public Booking addSpasItem(ExtraBookingRequest spasItem) {
        if (this.spas == null) {
            this.spas = new ArrayList<ExtraBookingRequest>();
        }
        this.spas.add(spasItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Spa reservation records.")
    @JsonProperty(value="spas")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ExtraBookingRequest> getSpas() {
        return this.spas;
    }

    @JsonProperty(value="spas")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSpas(List<ExtraBookingRequest> spas) {
        this.spas = spas;
    }

    public Booking places(List<ExtraBookingRequest> places) {
        this.places = places;
        return this;
    }

    public Booking addPlacesItem(ExtraBookingRequest placesItem) {
        if (this.places == null) {
            this.places = new ArrayList<ExtraBookingRequest>();
        }
        this.places.add(placesItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Place reservation records.")
    @JsonProperty(value="places")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ExtraBookingRequest> getPlaces() {
        return this.places;
    }

    @JsonProperty(value="places")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPlaces(List<ExtraBookingRequest> places) {
        this.places = places;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Booking booking = (Booking)o;
        return Objects.equals(this.test, booking.test) && Objects.equals(this.date, booking.date) && Objects.equals(this.groupIdentifier, booking.groupIdentifier) && Objects.equals(this.identifier, booking.identifier) && Objects.equals(this.engineConfiguration, booking.engineConfiguration) && Objects.equals(this.bookingCode, booking.bookingCode) && Objects.equals(this.user, booking.user) && Objects.equals(this.userSession, booking.userSession) && Objects.equals(this.serverUrl, booking.serverUrl) && Objects.equals(this.contactInfo, booking.contactInfo) && Objects.equals(this.address, booking.address) && Objects.equals(this.socials, booking.socials) && Objects.equals(this.review, booking.review) && Objects.equals(this.emailHeaderLogoUrl, booking.emailHeaderLogoUrl) && Objects.equals(this.logoIdentifier, booking.logoIdentifier) && Objects.equals(this.hotel, booking.hotel) && Objects.equals(this.roomStay, booking.roomStay) && Objects.equals(this.specialRequests, booking.specialRequests) && Objects.equals(this.comment, booking.comment) && Objects.equals(this.packageOffers, booking.packageOffers) && Objects.equals(this.addOnOffers, booking.addOnOffers) && Objects.equals(this.earlyCheckInCharge, booking.earlyCheckInCharge) && Objects.equals(this.lateCheckOutCharge, booking.lateCheckOutCharge) && Objects.equals(this.earlyCheckInChargePercent, booking.earlyCheckInChargePercent) && Objects.equals(this.lateCheckOutChargePercent, booking.lateCheckOutChargePercent) && Objects.equals(this.hotelImageUrl, booking.hotelImageUrl) && Objects.equals(this.roomImageUrl, booking.roomImageUrl) && Objects.equals(this.commissionList, booking.commissionList) && Objects.equals(this.bookingContract, booking.bookingContract) && Objects.equals(this.userSpecifiedCurrencyTotal, booking.userSpecifiedCurrencyTotal) && Objects.equals((Object)this.status, (Object)booking.status) && Objects.equals(this.endDate, booking.endDate) && Objects.equals(this.fullAddress, booking.fullAddress) && Objects.equals(this.sourceTotal, booking.sourceTotal) && Objects.equals(this.internalTotal, booking.internalTotal) && Objects.equals((Object)this.rateSource, (Object)booking.rateSource) && Objects.equals(this.startDate, booking.startDate) && Objects.equals(this.meetingRooms, booking.meetingRooms) && Objects.equals(this.restaurants, booking.restaurants) && Objects.equals(this.activities, booking.activities) && Objects.equals(this.attractions, booking.attractions) && Objects.equals(this.spas, booking.spas) && Objects.equals(this.places, booking.places);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.test, this.date, this.groupIdentifier, this.identifier, this.engineConfiguration, this.bookingCode, this.user, this.userSession, this.serverUrl, this.contactInfo, this.address, this.socials, this.review, this.emailHeaderLogoUrl, this.logoIdentifier, this.hotel, this.roomStay, this.specialRequests, this.comment, this.packageOffers, this.addOnOffers, this.earlyCheckInCharge, this.lateCheckOutCharge, this.earlyCheckInChargePercent, this.lateCheckOutChargePercent, this.hotelImageUrl, this.roomImageUrl, this.commissionList, this.bookingContract, this.userSpecifiedCurrencyTotal, this.status, this.endDate, this.fullAddress, this.sourceTotal, this.internalTotal, this.rateSource, this.startDate, this.meetingRooms, this.restaurants, this.activities, this.attractions, this.spas, this.places});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Booking {\n");
        sb.append("    test: ").append(this.toIndentedString(this.test)).append("\n");
        sb.append("    date: ").append(this.toIndentedString(this.date)).append("\n");
        sb.append("    groupIdentifier: ").append(this.toIndentedString(this.groupIdentifier)).append("\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    engineConfiguration: ").append(this.toIndentedString(this.engineConfiguration)).append("\n");
        sb.append("    bookingCode: ").append(this.toIndentedString(this.bookingCode)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    userSession: ").append(this.toIndentedString(this.userSession)).append("\n");
        sb.append("    serverUrl: ").append(this.toIndentedString(this.serverUrl)).append("\n");
        sb.append("    contactInfo: ").append(this.toIndentedString(this.contactInfo)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    socials: ").append(this.toIndentedString(this.socials)).append("\n");
        sb.append("    review: ").append(this.toIndentedString(this.review)).append("\n");
        sb.append("    emailHeaderLogoUrl: ").append(this.toIndentedString(this.emailHeaderLogoUrl)).append("\n");
        sb.append("    logoIdentifier: ").append(this.toIndentedString(this.logoIdentifier)).append("\n");
        sb.append("    hotel: ").append(this.toIndentedString(this.hotel)).append("\n");
        sb.append("    roomStay: ").append(this.toIndentedString(this.roomStay)).append("\n");
        sb.append("    specialRequests: ").append(this.toIndentedString(this.specialRequests)).append("\n");
        sb.append("    comment: ").append(this.toIndentedString(this.comment)).append("\n");
        sb.append("    packageOffers: ").append(this.toIndentedString(this.packageOffers)).append("\n");
        sb.append("    addOnOffers: ").append(this.toIndentedString(this.addOnOffers)).append("\n");
        sb.append("    earlyCheckInCharge: ").append(this.toIndentedString(this.earlyCheckInCharge)).append("\n");
        sb.append("    lateCheckOutCharge: ").append(this.toIndentedString(this.lateCheckOutCharge)).append("\n");
        sb.append("    earlyCheckInChargePercent: ").append(this.toIndentedString(this.earlyCheckInChargePercent)).append("\n");
        sb.append("    lateCheckOutChargePercent: ").append(this.toIndentedString(this.lateCheckOutChargePercent)).append("\n");
        sb.append("    hotelImageUrl: ").append(this.toIndentedString(this.hotelImageUrl)).append("\n");
        sb.append("    roomImageUrl: ").append(this.toIndentedString(this.roomImageUrl)).append("\n");
        sb.append("    commissionList: ").append(this.toIndentedString(this.commissionList)).append("\n");
        sb.append("    bookingContract: ").append(this.toIndentedString(this.bookingContract)).append("\n");
        sb.append("    userSpecifiedCurrencyTotal: ").append(this.toIndentedString(this.userSpecifiedCurrencyTotal)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    fullAddress: ").append(this.toIndentedString(this.fullAddress)).append("\n");
        sb.append("    sourceTotal: ").append(this.toIndentedString(this.sourceTotal)).append("\n");
        sb.append("    internalTotal: ").append(this.toIndentedString(this.internalTotal)).append("\n");
        sb.append("    rateSource: ").append(this.toIndentedString((Object)this.rateSource)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    meetingRooms: ").append(this.toIndentedString(this.meetingRooms)).append("\n");
        sb.append("    restaurants: ").append(this.toIndentedString(this.restaurants)).append("\n");
        sb.append("    activities: ").append(this.toIndentedString(this.activities)).append("\n");
        sb.append("    attractions: ").append(this.toIndentedString(this.attractions)).append("\n");
        sb.append("    spas: ").append(this.toIndentedString(this.spas)).append("\n");
        sb.append("    places: ").append(this.toIndentedString(this.places)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        CANCELLED_BY_HOTEL("CANCELLED_BY_HOTEL"),
        CANCELLED_BY_GUEST("CANCELLED_BY_GUEST"),
        CANCELLED_BY_ADMIN("CANCELLED_BY_ADMIN"),
        CANCELLED_BY_SALES_CHANNEL("CANCELLED_BY_SALES_CHANNEL"),
        PAST("PAST"),
        ACTIVE("ACTIVE");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum RateSourceEnum {
        TRAVELIKO("TRAVELIKO"),
        SITEMINDER("SITEMINDER"),
        FASTBOOKING("FASTBOOKING"),
        RATEGAIN("RATEGAIN"),
        CLOUD_BEDS("CLOUD_BEDS"),
        YIELD_PLANET("YIELD_PLANET"),
        TRAVELCLICK("TRAVELCLICK"),
        HOTEL_GURU("HOTEL_GURU"),
        OTHER_CHANNEL_MANAGER("OTHER_CHANNEL_MANAGER"),
        BOOKING_JINI("BOOKING_JINI"),
        HOTEL_LINK_SOLUTIONS("HOTEL_LINK_SOLUTIONS"),
        ALLOTZ("ALLOTZ"),
        DEDGE("DEDGE"),
        RATE_TIGER("RATE_TIGER"),
        RESAVENUE("RESAVENUE"),
        COMANCHE("COMANCHE"),
        OMNIBEES("OMNIBEES"),
        EZEE("EZEE"),
        SYNXIS("SYNXIS");

        private String value;

        private RateSourceEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static RateSourceEnum fromValue(String value) {
            for (RateSourceEnum b : RateSourceEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

