/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/docs?api=affiliate): All APIs related to selling travel inventory as an affiliate. - [Extranet](/docs?api=extranet): All APIs related to managing travel inventory and suppliers. - [Booking Engine](/docs?api=booking-engine): All APIs related to searching for travel inventory and creating bookings. - [Channel Manager](/docs?api=channel-manager): All APIs related to channel managers who want to integrate with our payment.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.payment-v`1`+json.  ## Release history - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Extranet API Welcome to the Extranet API - A programmer-friendly way to manage your travel inventory on the wink payment. This API offers a superset of the features you can find at [https://extranet.wink.travel](https://extranet.wink.travel) and gives you all the tools you need to ready your properties and inventory for sale across 10000s of our unique sales channels. What differentiates us from existing Extranets is 1. we make it available for everyone to use and 2. the care we take in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Content creators have the ability to make their inventory look great and be searchable in a wide variety of ways. You won't find properties with generic inventory, low resolution pictures and little ancillary content that can easily be found everywhere else on the internet.  # Integrations We have already integrated with the most well-known channel managers so you don't have to. Once your properties are set up, you can finish the setup by mapping your property to wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API. - Allotz - CloudBeds / MyAllocator - Comanche - d-edge - FastBooking - HotelLink - HoteliersGuru - Omnibees - RateGain - Rate Tiger - ResAvenue - Siteminder - Sabre SynXis - Travelclick - Yieldplanet  # Intended Audience Programmers are [most likely] a requirement to start integrating with wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible. - Hotel chains - Hotel brands - Travel tech companies - Destination sites - Integrators - Aggregators - Destination management companies - Travel agencies - OTAs  
 *
 * The version of the OpenAPI document: 20.1.2-SNAPSHOT
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.extranet.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import travel.wink.sdk.extranet.model.Address;
import travel.wink.sdk.extranet.model.CustomerTaxId;
import travel.wink.sdk.extranet.model.Discount;
import travel.wink.sdk.extranet.model.InvoiceLineItemCollection;
import travel.wink.sdk.extranet.model.ShippingDetails;
import travel.wink.sdk.extranet.model.StatusTransitions;
import travel.wink.sdk.extranet.model.TaxAmount;
import travel.wink.sdk.extranet.model.TaxRate;
import travel.wink.sdk.extranet.model.ThresholdReason;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Invoice
 */
@JsonPropertyOrder({
  Invoice.JSON_PROPERTY_ACCOUNT_COUNTRY,
  Invoice.JSON_PROPERTY_ACCOUNT_NAME,
  Invoice.JSON_PROPERTY_AMOUNT_DUE,
  Invoice.JSON_PROPERTY_AMOUNT_PAID,
  Invoice.JSON_PROPERTY_AMOUNT_REMAINING,
  Invoice.JSON_PROPERTY_APPLICATION_FEE_AMOUNT,
  Invoice.JSON_PROPERTY_ATTEMPT_COUNT,
  Invoice.JSON_PROPERTY_ATTEMPTED,
  Invoice.JSON_PROPERTY_AUTO_ADVANCE,
  Invoice.JSON_PROPERTY_BILLING,
  Invoice.JSON_PROPERTY_BILLING_REASON,
  Invoice.JSON_PROPERTY_COLLECTION_METHOD,
  Invoice.JSON_PROPERTY_CREATED,
  Invoice.JSON_PROPERTY_CURRENCY,
  Invoice.JSON_PROPERTY_CUSTOMER_ADDRESS,
  Invoice.JSON_PROPERTY_CUSTOMER_EMAIL,
  Invoice.JSON_PROPERTY_CUSTOMER_NAME,
  Invoice.JSON_PROPERTY_CUSTOMER_PHONE,
  Invoice.JSON_PROPERTY_CUSTOMER_SHIPPING,
  Invoice.JSON_PROPERTY_CUSTOMER_TAX_EXEMPT,
  Invoice.JSON_PROPERTY_CUSTOMER_TAX_IDS,
  Invoice.JSON_PROPERTY_DEFAULT_TAX_RATES,
  Invoice.JSON_PROPERTY_DELETED,
  Invoice.JSON_PROPERTY_DESCRIPTION,
  Invoice.JSON_PROPERTY_DISCOUNT,
  Invoice.JSON_PROPERTY_DUE_DATE,
  Invoice.JSON_PROPERTY_ENDING_BALANCE,
  Invoice.JSON_PROPERTY_FOOTER,
  Invoice.JSON_PROPERTY_HOSTED_INVOICE_URL,
  Invoice.JSON_PROPERTY_ID,
  Invoice.JSON_PROPERTY_INVOICE_PDF,
  Invoice.JSON_PROPERTY_LINES,
  Invoice.JSON_PROPERTY_LIVEMODE,
  Invoice.JSON_PROPERTY_METADATA,
  Invoice.JSON_PROPERTY_NEXT_PAYMENT_ATTEMPT,
  Invoice.JSON_PROPERTY_NUMBER,
  Invoice.JSON_PROPERTY_OBJECT,
  Invoice.JSON_PROPERTY_PAID,
  Invoice.JSON_PROPERTY_PERIOD_END,
  Invoice.JSON_PROPERTY_PERIOD_START,
  Invoice.JSON_PROPERTY_POST_PAYMENT_CREDIT_NOTES_AMOUNT,
  Invoice.JSON_PROPERTY_PRE_PAYMENT_CREDIT_NOTES_AMOUNT,
  Invoice.JSON_PROPERTY_RECEIPT_NUMBER,
  Invoice.JSON_PROPERTY_STARTING_BALANCE,
  Invoice.JSON_PROPERTY_STATEMENT_DESCRIPTOR,
  Invoice.JSON_PROPERTY_STATUS,
  Invoice.JSON_PROPERTY_STATUS_TRANSITIONS,
  Invoice.JSON_PROPERTY_SUBSCRIPTION_PRORATION_DATE,
  Invoice.JSON_PROPERTY_SUBTOTAL,
  Invoice.JSON_PROPERTY_TAX,
  Invoice.JSON_PROPERTY_THRESHOLD_REASON,
  Invoice.JSON_PROPERTY_TOTAL,
  Invoice.JSON_PROPERTY_TOTAL_TAX_AMOUNTS,
  Invoice.JSON_PROPERTY_TRANSFER_DATA,
  Invoice.JSON_PROPERTY_WEBHOOKS_DELIVERED_AT
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-06-20T22:26:49.575007+07:00[Asia/Bangkok]")
public class Invoice {
  public static final String JSON_PROPERTY_ACCOUNT_COUNTRY = "accountCountry";
  private String accountCountry;

  public static final String JSON_PROPERTY_ACCOUNT_NAME = "accountName";
  private String accountName;

  public static final String JSON_PROPERTY_AMOUNT_DUE = "amountDue";
  private Long amountDue;

  public static final String JSON_PROPERTY_AMOUNT_PAID = "amountPaid";
  private Long amountPaid;

  public static final String JSON_PROPERTY_AMOUNT_REMAINING = "amountRemaining";
  private Long amountRemaining;

  public static final String JSON_PROPERTY_APPLICATION_FEE_AMOUNT = "applicationFeeAmount";
  private Long applicationFeeAmount;

  public static final String JSON_PROPERTY_ATTEMPT_COUNT = "attemptCount";
  private Long attemptCount;

  public static final String JSON_PROPERTY_ATTEMPTED = "attempted";
  private Boolean attempted;

  public static final String JSON_PROPERTY_AUTO_ADVANCE = "autoAdvance";
  private Boolean autoAdvance;

  public static final String JSON_PROPERTY_BILLING = "billing";
  private String billing;

  public static final String JSON_PROPERTY_BILLING_REASON = "billingReason";
  private String billingReason;

  public static final String JSON_PROPERTY_COLLECTION_METHOD = "collectionMethod";
  private String collectionMethod;

  public static final String JSON_PROPERTY_CREATED = "created";
  private Long created;

  public static final String JSON_PROPERTY_CURRENCY = "currency";
  private String currency;

  public static final String JSON_PROPERTY_CUSTOMER_ADDRESS = "customerAddress";
  private Address customerAddress;

  public static final String JSON_PROPERTY_CUSTOMER_EMAIL = "customerEmail";
  private String customerEmail;

  public static final String JSON_PROPERTY_CUSTOMER_NAME = "customerName";
  private String customerName;

  public static final String JSON_PROPERTY_CUSTOMER_PHONE = "customerPhone";
  private String customerPhone;

  public static final String JSON_PROPERTY_CUSTOMER_SHIPPING = "customerShipping";
  private ShippingDetails customerShipping;

  public static final String JSON_PROPERTY_CUSTOMER_TAX_EXEMPT = "customerTaxExempt";
  private String customerTaxExempt;

  public static final String JSON_PROPERTY_CUSTOMER_TAX_IDS = "customerTaxIds";
  private List<CustomerTaxId> customerTaxIds = null;

  public static final String JSON_PROPERTY_DEFAULT_TAX_RATES = "defaultTaxRates";
  private List<TaxRate> defaultTaxRates = null;

  public static final String JSON_PROPERTY_DELETED = "deleted";
  private Boolean deleted;

  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  private String description;

  public static final String JSON_PROPERTY_DISCOUNT = "discount";
  private Discount discount;

  public static final String JSON_PROPERTY_DUE_DATE = "dueDate";
  private Long dueDate;

  public static final String JSON_PROPERTY_ENDING_BALANCE = "endingBalance";
  private Long endingBalance;

  public static final String JSON_PROPERTY_FOOTER = "footer";
  private String footer;

  public static final String JSON_PROPERTY_HOSTED_INVOICE_URL = "hostedInvoiceUrl";
  private String hostedInvoiceUrl;

  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_INVOICE_PDF = "invoicePdf";
  private String invoicePdf;

  public static final String JSON_PROPERTY_LINES = "lines";
  private InvoiceLineItemCollection lines;

  public static final String JSON_PROPERTY_LIVEMODE = "livemode";
  private Boolean livemode;

  public static final String JSON_PROPERTY_METADATA = "metadata";
  private Map<String, String> metadata = null;

  public static final String JSON_PROPERTY_NEXT_PAYMENT_ATTEMPT = "nextPaymentAttempt";
  private Long nextPaymentAttempt;

  public static final String JSON_PROPERTY_NUMBER = "number";
  private String number;

  public static final String JSON_PROPERTY_OBJECT = "object";
  private String _object;

  public static final String JSON_PROPERTY_PAID = "paid";
  private Boolean paid;

  public static final String JSON_PROPERTY_PERIOD_END = "periodEnd";
  private Long periodEnd;

  public static final String JSON_PROPERTY_PERIOD_START = "periodStart";
  private Long periodStart;

  public static final String JSON_PROPERTY_POST_PAYMENT_CREDIT_NOTES_AMOUNT = "postPaymentCreditNotesAmount";
  private Long postPaymentCreditNotesAmount;

  public static final String JSON_PROPERTY_PRE_PAYMENT_CREDIT_NOTES_AMOUNT = "prePaymentCreditNotesAmount";
  private Long prePaymentCreditNotesAmount;

  public static final String JSON_PROPERTY_RECEIPT_NUMBER = "receiptNumber";
  private String receiptNumber;

  public static final String JSON_PROPERTY_STARTING_BALANCE = "startingBalance";
  private Long startingBalance;

  public static final String JSON_PROPERTY_STATEMENT_DESCRIPTOR = "statementDescriptor";
  private String statementDescriptor;

  public static final String JSON_PROPERTY_STATUS = "status";
  private String status;

  public static final String JSON_PROPERTY_STATUS_TRANSITIONS = "statusTransitions";
  private StatusTransitions statusTransitions;

  public static final String JSON_PROPERTY_SUBSCRIPTION_PRORATION_DATE = "subscriptionProrationDate";
  private Long subscriptionProrationDate;

  public static final String JSON_PROPERTY_SUBTOTAL = "subtotal";
  private Long subtotal;

  public static final String JSON_PROPERTY_TAX = "tax";
  private Long tax;

  public static final String JSON_PROPERTY_THRESHOLD_REASON = "thresholdReason";
  private ThresholdReason thresholdReason;

  public static final String JSON_PROPERTY_TOTAL = "total";
  private Long total;

  public static final String JSON_PROPERTY_TOTAL_TAX_AMOUNTS = "totalTaxAmounts";
  private List<TaxAmount> totalTaxAmounts = null;

  public static final String JSON_PROPERTY_TRANSFER_DATA = "transferData";
  private Object transferData;

  public static final String JSON_PROPERTY_WEBHOOKS_DELIVERED_AT = "webhooksDeliveredAt";
  private Long webhooksDeliveredAt;

  public Invoice() { 
  }

  public Invoice accountCountry(String accountCountry) {
    
    this.accountCountry = accountCountry;
    return this;
  }

   /**
   * Get accountCountry
   * @return accountCountry
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ACCOUNT_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAccountCountry() {
    return accountCountry;
  }


  @JsonProperty(JSON_PROPERTY_ACCOUNT_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAccountCountry(String accountCountry) {
    this.accountCountry = accountCountry;
  }


  public Invoice accountName(String accountName) {
    
    this.accountName = accountName;
    return this;
  }

   /**
   * Get accountName
   * @return accountName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ACCOUNT_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAccountName() {
    return accountName;
  }


  @JsonProperty(JSON_PROPERTY_ACCOUNT_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAccountName(String accountName) {
    this.accountName = accountName;
  }


  public Invoice amountDue(Long amountDue) {
    
    this.amountDue = amountDue;
    return this;
  }

   /**
   * Get amountDue
   * @return amountDue
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_AMOUNT_DUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getAmountDue() {
    return amountDue;
  }


  @JsonProperty(JSON_PROPERTY_AMOUNT_DUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAmountDue(Long amountDue) {
    this.amountDue = amountDue;
  }


  public Invoice amountPaid(Long amountPaid) {
    
    this.amountPaid = amountPaid;
    return this;
  }

   /**
   * Get amountPaid
   * @return amountPaid
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_AMOUNT_PAID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getAmountPaid() {
    return amountPaid;
  }


  @JsonProperty(JSON_PROPERTY_AMOUNT_PAID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAmountPaid(Long amountPaid) {
    this.amountPaid = amountPaid;
  }


  public Invoice amountRemaining(Long amountRemaining) {
    
    this.amountRemaining = amountRemaining;
    return this;
  }

   /**
   * Get amountRemaining
   * @return amountRemaining
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_AMOUNT_REMAINING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getAmountRemaining() {
    return amountRemaining;
  }


  @JsonProperty(JSON_PROPERTY_AMOUNT_REMAINING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAmountRemaining(Long amountRemaining) {
    this.amountRemaining = amountRemaining;
  }


  public Invoice applicationFeeAmount(Long applicationFeeAmount) {
    
    this.applicationFeeAmount = applicationFeeAmount;
    return this;
  }

   /**
   * Get applicationFeeAmount
   * @return applicationFeeAmount
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_APPLICATION_FEE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getApplicationFeeAmount() {
    return applicationFeeAmount;
  }


  @JsonProperty(JSON_PROPERTY_APPLICATION_FEE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setApplicationFeeAmount(Long applicationFeeAmount) {
    this.applicationFeeAmount = applicationFeeAmount;
  }


  public Invoice attemptCount(Long attemptCount) {
    
    this.attemptCount = attemptCount;
    return this;
  }

   /**
   * Get attemptCount
   * @return attemptCount
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ATTEMPT_COUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getAttemptCount() {
    return attemptCount;
  }


  @JsonProperty(JSON_PROPERTY_ATTEMPT_COUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAttemptCount(Long attemptCount) {
    this.attemptCount = attemptCount;
  }


  public Invoice attempted(Boolean attempted) {
    
    this.attempted = attempted;
    return this;
  }

   /**
   * Get attempted
   * @return attempted
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ATTEMPTED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getAttempted() {
    return attempted;
  }


  @JsonProperty(JSON_PROPERTY_ATTEMPTED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAttempted(Boolean attempted) {
    this.attempted = attempted;
  }


  public Invoice autoAdvance(Boolean autoAdvance) {
    
    this.autoAdvance = autoAdvance;
    return this;
  }

   /**
   * Get autoAdvance
   * @return autoAdvance
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_AUTO_ADVANCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getAutoAdvance() {
    return autoAdvance;
  }


  @JsonProperty(JSON_PROPERTY_AUTO_ADVANCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAutoAdvance(Boolean autoAdvance) {
    this.autoAdvance = autoAdvance;
  }


  public Invoice billing(String billing) {
    
    this.billing = billing;
    return this;
  }

   /**
   * Get billing
   * @return billing
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_BILLING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getBilling() {
    return billing;
  }


  @JsonProperty(JSON_PROPERTY_BILLING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBilling(String billing) {
    this.billing = billing;
  }


  public Invoice billingReason(String billingReason) {
    
    this.billingReason = billingReason;
    return this;
  }

   /**
   * Get billingReason
   * @return billingReason
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_BILLING_REASON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getBillingReason() {
    return billingReason;
  }


  @JsonProperty(JSON_PROPERTY_BILLING_REASON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBillingReason(String billingReason) {
    this.billingReason = billingReason;
  }


  public Invoice collectionMethod(String collectionMethod) {
    
    this.collectionMethod = collectionMethod;
    return this;
  }

   /**
   * Get collectionMethod
   * @return collectionMethod
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_COLLECTION_METHOD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCollectionMethod() {
    return collectionMethod;
  }


  @JsonProperty(JSON_PROPERTY_COLLECTION_METHOD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCollectionMethod(String collectionMethod) {
    this.collectionMethod = collectionMethod;
  }


  public Invoice created(Long created) {
    
    this.created = created;
    return this;
  }

   /**
   * Get created
   * @return created
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CREATED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getCreated() {
    return created;
  }


  @JsonProperty(JSON_PROPERTY_CREATED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCreated(Long created) {
    this.created = created;
  }


  public Invoice currency(String currency) {
    
    this.currency = currency;
    return this;
  }

   /**
   * Get currency
   * @return currency
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCurrency() {
    return currency;
  }


  @JsonProperty(JSON_PROPERTY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCurrency(String currency) {
    this.currency = currency;
  }


  public Invoice customerAddress(Address customerAddress) {
    
    this.customerAddress = customerAddress;
    return this;
  }

   /**
   * Get customerAddress
   * @return customerAddress
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CUSTOMER_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Address getCustomerAddress() {
    return customerAddress;
  }


  @JsonProperty(JSON_PROPERTY_CUSTOMER_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCustomerAddress(Address customerAddress) {
    this.customerAddress = customerAddress;
  }


  public Invoice customerEmail(String customerEmail) {
    
    this.customerEmail = customerEmail;
    return this;
  }

   /**
   * Get customerEmail
   * @return customerEmail
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CUSTOMER_EMAIL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCustomerEmail() {
    return customerEmail;
  }


  @JsonProperty(JSON_PROPERTY_CUSTOMER_EMAIL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCustomerEmail(String customerEmail) {
    this.customerEmail = customerEmail;
  }


  public Invoice customerName(String customerName) {
    
    this.customerName = customerName;
    return this;
  }

   /**
   * Get customerName
   * @return customerName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CUSTOMER_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCustomerName() {
    return customerName;
  }


  @JsonProperty(JSON_PROPERTY_CUSTOMER_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCustomerName(String customerName) {
    this.customerName = customerName;
  }


  public Invoice customerPhone(String customerPhone) {
    
    this.customerPhone = customerPhone;
    return this;
  }

   /**
   * Get customerPhone
   * @return customerPhone
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CUSTOMER_PHONE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCustomerPhone() {
    return customerPhone;
  }


  @JsonProperty(JSON_PROPERTY_CUSTOMER_PHONE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCustomerPhone(String customerPhone) {
    this.customerPhone = customerPhone;
  }


  public Invoice customerShipping(ShippingDetails customerShipping) {
    
    this.customerShipping = customerShipping;
    return this;
  }

   /**
   * Get customerShipping
   * @return customerShipping
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CUSTOMER_SHIPPING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ShippingDetails getCustomerShipping() {
    return customerShipping;
  }


  @JsonProperty(JSON_PROPERTY_CUSTOMER_SHIPPING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCustomerShipping(ShippingDetails customerShipping) {
    this.customerShipping = customerShipping;
  }


  public Invoice customerTaxExempt(String customerTaxExempt) {
    
    this.customerTaxExempt = customerTaxExempt;
    return this;
  }

   /**
   * Get customerTaxExempt
   * @return customerTaxExempt
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CUSTOMER_TAX_EXEMPT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCustomerTaxExempt() {
    return customerTaxExempt;
  }


  @JsonProperty(JSON_PROPERTY_CUSTOMER_TAX_EXEMPT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCustomerTaxExempt(String customerTaxExempt) {
    this.customerTaxExempt = customerTaxExempt;
  }


  public Invoice customerTaxIds(List<CustomerTaxId> customerTaxIds) {
    
    this.customerTaxIds = customerTaxIds;
    return this;
  }

  public Invoice addCustomerTaxIdsItem(CustomerTaxId customerTaxIdsItem) {
    if (this.customerTaxIds == null) {
      this.customerTaxIds = new ArrayList<>();
    }
    this.customerTaxIds.add(customerTaxIdsItem);
    return this;
  }

   /**
   * Get customerTaxIds
   * @return customerTaxIds
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CUSTOMER_TAX_IDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<CustomerTaxId> getCustomerTaxIds() {
    return customerTaxIds;
  }


  @JsonProperty(JSON_PROPERTY_CUSTOMER_TAX_IDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCustomerTaxIds(List<CustomerTaxId> customerTaxIds) {
    this.customerTaxIds = customerTaxIds;
  }


  public Invoice defaultTaxRates(List<TaxRate> defaultTaxRates) {
    
    this.defaultTaxRates = defaultTaxRates;
    return this;
  }

  public Invoice addDefaultTaxRatesItem(TaxRate defaultTaxRatesItem) {
    if (this.defaultTaxRates == null) {
      this.defaultTaxRates = new ArrayList<>();
    }
    this.defaultTaxRates.add(defaultTaxRatesItem);
    return this;
  }

   /**
   * Get defaultTaxRates
   * @return defaultTaxRates
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DEFAULT_TAX_RATES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<TaxRate> getDefaultTaxRates() {
    return defaultTaxRates;
  }


  @JsonProperty(JSON_PROPERTY_DEFAULT_TAX_RATES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDefaultTaxRates(List<TaxRate> defaultTaxRates) {
    this.defaultTaxRates = defaultTaxRates;
  }


  public Invoice deleted(Boolean deleted) {
    
    this.deleted = deleted;
    return this;
  }

   /**
   * Get deleted
   * @return deleted
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DELETED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getDeleted() {
    return deleted;
  }


  @JsonProperty(JSON_PROPERTY_DELETED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDeleted(Boolean deleted) {
    this.deleted = deleted;
  }


  public Invoice description(String description) {
    
    this.description = description;
    return this;
  }

   /**
   * Get description
   * @return description
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDescription() {
    return description;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDescription(String description) {
    this.description = description;
  }


  public Invoice discount(Discount discount) {
    
    this.discount = discount;
    return this;
  }

   /**
   * Get discount
   * @return discount
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DISCOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Discount getDiscount() {
    return discount;
  }


  @JsonProperty(JSON_PROPERTY_DISCOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDiscount(Discount discount) {
    this.discount = discount;
  }


  public Invoice dueDate(Long dueDate) {
    
    this.dueDate = dueDate;
    return this;
  }

   /**
   * Get dueDate
   * @return dueDate
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DUE_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getDueDate() {
    return dueDate;
  }


  @JsonProperty(JSON_PROPERTY_DUE_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDueDate(Long dueDate) {
    this.dueDate = dueDate;
  }


  public Invoice endingBalance(Long endingBalance) {
    
    this.endingBalance = endingBalance;
    return this;
  }

   /**
   * Get endingBalance
   * @return endingBalance
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ENDING_BALANCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getEndingBalance() {
    return endingBalance;
  }


  @JsonProperty(JSON_PROPERTY_ENDING_BALANCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEndingBalance(Long endingBalance) {
    this.endingBalance = endingBalance;
  }


  public Invoice footer(String footer) {
    
    this.footer = footer;
    return this;
  }

   /**
   * Get footer
   * @return footer
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_FOOTER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFooter() {
    return footer;
  }


  @JsonProperty(JSON_PROPERTY_FOOTER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFooter(String footer) {
    this.footer = footer;
  }


  public Invoice hostedInvoiceUrl(String hostedInvoiceUrl) {
    
    this.hostedInvoiceUrl = hostedInvoiceUrl;
    return this;
  }

   /**
   * Get hostedInvoiceUrl
   * @return hostedInvoiceUrl
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_HOSTED_INVOICE_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getHostedInvoiceUrl() {
    return hostedInvoiceUrl;
  }


  @JsonProperty(JSON_PROPERTY_HOSTED_INVOICE_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHostedInvoiceUrl(String hostedInvoiceUrl) {
    this.hostedInvoiceUrl = hostedInvoiceUrl;
  }


  public Invoice id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * Get id
   * @return id
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(String id) {
    this.id = id;
  }


  public Invoice invoicePdf(String invoicePdf) {
    
    this.invoicePdf = invoicePdf;
    return this;
  }

   /**
   * Get invoicePdf
   * @return invoicePdf
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_INVOICE_PDF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getInvoicePdf() {
    return invoicePdf;
  }


  @JsonProperty(JSON_PROPERTY_INVOICE_PDF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInvoicePdf(String invoicePdf) {
    this.invoicePdf = invoicePdf;
  }


  public Invoice lines(InvoiceLineItemCollection lines) {
    
    this.lines = lines;
    return this;
  }

   /**
   * Get lines
   * @return lines
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_LINES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public InvoiceLineItemCollection getLines() {
    return lines;
  }


  @JsonProperty(JSON_PROPERTY_LINES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLines(InvoiceLineItemCollection lines) {
    this.lines = lines;
  }


  public Invoice livemode(Boolean livemode) {
    
    this.livemode = livemode;
    return this;
  }

   /**
   * Get livemode
   * @return livemode
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_LIVEMODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getLivemode() {
    return livemode;
  }


  @JsonProperty(JSON_PROPERTY_LIVEMODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLivemode(Boolean livemode) {
    this.livemode = livemode;
  }


  public Invoice metadata(Map<String, String> metadata) {
    
    this.metadata = metadata;
    return this;
  }

  public Invoice putMetadataItem(String key, String metadataItem) {
    if (this.metadata == null) {
      this.metadata = new HashMap<>();
    }
    this.metadata.put(key, metadataItem);
    return this;
  }

   /**
   * Get metadata
   * @return metadata
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, String> getMetadata() {
    return metadata;
  }


  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMetadata(Map<String, String> metadata) {
    this.metadata = metadata;
  }


  public Invoice nextPaymentAttempt(Long nextPaymentAttempt) {
    
    this.nextPaymentAttempt = nextPaymentAttempt;
    return this;
  }

   /**
   * Get nextPaymentAttempt
   * @return nextPaymentAttempt
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_NEXT_PAYMENT_ATTEMPT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getNextPaymentAttempt() {
    return nextPaymentAttempt;
  }


  @JsonProperty(JSON_PROPERTY_NEXT_PAYMENT_ATTEMPT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNextPaymentAttempt(Long nextPaymentAttempt) {
    this.nextPaymentAttempt = nextPaymentAttempt;
  }


  public Invoice number(String number) {
    
    this.number = number;
    return this;
  }

   /**
   * Get number
   * @return number
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getNumber() {
    return number;
  }


  @JsonProperty(JSON_PROPERTY_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNumber(String number) {
    this.number = number;
  }


  public Invoice _object(String _object) {
    
    this._object = _object;
    return this;
  }

   /**
   * Get _object
   * @return _object
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_OBJECT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getObject() {
    return _object;
  }


  @JsonProperty(JSON_PROPERTY_OBJECT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setObject(String _object) {
    this._object = _object;
  }


  public Invoice paid(Boolean paid) {
    
    this.paid = paid;
    return this;
  }

   /**
   * Get paid
   * @return paid
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PAID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getPaid() {
    return paid;
  }


  @JsonProperty(JSON_PROPERTY_PAID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPaid(Boolean paid) {
    this.paid = paid;
  }


  public Invoice periodEnd(Long periodEnd) {
    
    this.periodEnd = periodEnd;
    return this;
  }

   /**
   * Get periodEnd
   * @return periodEnd
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PERIOD_END)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getPeriodEnd() {
    return periodEnd;
  }


  @JsonProperty(JSON_PROPERTY_PERIOD_END)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPeriodEnd(Long periodEnd) {
    this.periodEnd = periodEnd;
  }


  public Invoice periodStart(Long periodStart) {
    
    this.periodStart = periodStart;
    return this;
  }

   /**
   * Get periodStart
   * @return periodStart
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PERIOD_START)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getPeriodStart() {
    return periodStart;
  }


  @JsonProperty(JSON_PROPERTY_PERIOD_START)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPeriodStart(Long periodStart) {
    this.periodStart = periodStart;
  }


  public Invoice postPaymentCreditNotesAmount(Long postPaymentCreditNotesAmount) {
    
    this.postPaymentCreditNotesAmount = postPaymentCreditNotesAmount;
    return this;
  }

   /**
   * Get postPaymentCreditNotesAmount
   * @return postPaymentCreditNotesAmount
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_POST_PAYMENT_CREDIT_NOTES_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getPostPaymentCreditNotesAmount() {
    return postPaymentCreditNotesAmount;
  }


  @JsonProperty(JSON_PROPERTY_POST_PAYMENT_CREDIT_NOTES_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPostPaymentCreditNotesAmount(Long postPaymentCreditNotesAmount) {
    this.postPaymentCreditNotesAmount = postPaymentCreditNotesAmount;
  }


  public Invoice prePaymentCreditNotesAmount(Long prePaymentCreditNotesAmount) {
    
    this.prePaymentCreditNotesAmount = prePaymentCreditNotesAmount;
    return this;
  }

   /**
   * Get prePaymentCreditNotesAmount
   * @return prePaymentCreditNotesAmount
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PRE_PAYMENT_CREDIT_NOTES_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getPrePaymentCreditNotesAmount() {
    return prePaymentCreditNotesAmount;
  }


  @JsonProperty(JSON_PROPERTY_PRE_PAYMENT_CREDIT_NOTES_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPrePaymentCreditNotesAmount(Long prePaymentCreditNotesAmount) {
    this.prePaymentCreditNotesAmount = prePaymentCreditNotesAmount;
  }


  public Invoice receiptNumber(String receiptNumber) {
    
    this.receiptNumber = receiptNumber;
    return this;
  }

   /**
   * Get receiptNumber
   * @return receiptNumber
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_RECEIPT_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getReceiptNumber() {
    return receiptNumber;
  }


  @JsonProperty(JSON_PROPERTY_RECEIPT_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReceiptNumber(String receiptNumber) {
    this.receiptNumber = receiptNumber;
  }


  public Invoice startingBalance(Long startingBalance) {
    
    this.startingBalance = startingBalance;
    return this;
  }

   /**
   * Get startingBalance
   * @return startingBalance
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_STARTING_BALANCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getStartingBalance() {
    return startingBalance;
  }


  @JsonProperty(JSON_PROPERTY_STARTING_BALANCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStartingBalance(Long startingBalance) {
    this.startingBalance = startingBalance;
  }


  public Invoice statementDescriptor(String statementDescriptor) {
    
    this.statementDescriptor = statementDescriptor;
    return this;
  }

   /**
   * Get statementDescriptor
   * @return statementDescriptor
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_STATEMENT_DESCRIPTOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getStatementDescriptor() {
    return statementDescriptor;
  }


  @JsonProperty(JSON_PROPERTY_STATEMENT_DESCRIPTOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStatementDescriptor(String statementDescriptor) {
    this.statementDescriptor = statementDescriptor;
  }


  public Invoice status(String status) {
    
    this.status = status;
    return this;
  }

   /**
   * Get status
   * @return status
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getStatus() {
    return status;
  }


  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStatus(String status) {
    this.status = status;
  }


  public Invoice statusTransitions(StatusTransitions statusTransitions) {
    
    this.statusTransitions = statusTransitions;
    return this;
  }

   /**
   * Get statusTransitions
   * @return statusTransitions
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_STATUS_TRANSITIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public StatusTransitions getStatusTransitions() {
    return statusTransitions;
  }


  @JsonProperty(JSON_PROPERTY_STATUS_TRANSITIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStatusTransitions(StatusTransitions statusTransitions) {
    this.statusTransitions = statusTransitions;
  }


  public Invoice subscriptionProrationDate(Long subscriptionProrationDate) {
    
    this.subscriptionProrationDate = subscriptionProrationDate;
    return this;
  }

   /**
   * Get subscriptionProrationDate
   * @return subscriptionProrationDate
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SUBSCRIPTION_PRORATION_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getSubscriptionProrationDate() {
    return subscriptionProrationDate;
  }


  @JsonProperty(JSON_PROPERTY_SUBSCRIPTION_PRORATION_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSubscriptionProrationDate(Long subscriptionProrationDate) {
    this.subscriptionProrationDate = subscriptionProrationDate;
  }


  public Invoice subtotal(Long subtotal) {
    
    this.subtotal = subtotal;
    return this;
  }

   /**
   * Get subtotal
   * @return subtotal
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SUBTOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getSubtotal() {
    return subtotal;
  }


  @JsonProperty(JSON_PROPERTY_SUBTOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSubtotal(Long subtotal) {
    this.subtotal = subtotal;
  }


  public Invoice tax(Long tax) {
    
    this.tax = tax;
    return this;
  }

   /**
   * Get tax
   * @return tax
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TAX)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getTax() {
    return tax;
  }


  @JsonProperty(JSON_PROPERTY_TAX)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTax(Long tax) {
    this.tax = tax;
  }


  public Invoice thresholdReason(ThresholdReason thresholdReason) {
    
    this.thresholdReason = thresholdReason;
    return this;
  }

   /**
   * Get thresholdReason
   * @return thresholdReason
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_THRESHOLD_REASON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ThresholdReason getThresholdReason() {
    return thresholdReason;
  }


  @JsonProperty(JSON_PROPERTY_THRESHOLD_REASON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setThresholdReason(ThresholdReason thresholdReason) {
    this.thresholdReason = thresholdReason;
  }


  public Invoice total(Long total) {
    
    this.total = total;
    return this;
  }

   /**
   * Get total
   * @return total
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getTotal() {
    return total;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotal(Long total) {
    this.total = total;
  }


  public Invoice totalTaxAmounts(List<TaxAmount> totalTaxAmounts) {
    
    this.totalTaxAmounts = totalTaxAmounts;
    return this;
  }

  public Invoice addTotalTaxAmountsItem(TaxAmount totalTaxAmountsItem) {
    if (this.totalTaxAmounts == null) {
      this.totalTaxAmounts = new ArrayList<>();
    }
    this.totalTaxAmounts.add(totalTaxAmountsItem);
    return this;
  }

   /**
   * Get totalTaxAmounts
   * @return totalTaxAmounts
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TOTAL_TAX_AMOUNTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<TaxAmount> getTotalTaxAmounts() {
    return totalTaxAmounts;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_TAX_AMOUNTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalTaxAmounts(List<TaxAmount> totalTaxAmounts) {
    this.totalTaxAmounts = totalTaxAmounts;
  }


  public Invoice transferData(Object transferData) {
    
    this.transferData = transferData;
    return this;
  }

   /**
   * Get transferData
   * @return transferData
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TRANSFER_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getTransferData() {
    return transferData;
  }


  @JsonProperty(JSON_PROPERTY_TRANSFER_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTransferData(Object transferData) {
    this.transferData = transferData;
  }


  public Invoice webhooksDeliveredAt(Long webhooksDeliveredAt) {
    
    this.webhooksDeliveredAt = webhooksDeliveredAt;
    return this;
  }

   /**
   * Get webhooksDeliveredAt
   * @return webhooksDeliveredAt
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_WEBHOOKS_DELIVERED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getWebhooksDeliveredAt() {
    return webhooksDeliveredAt;
  }


  @JsonProperty(JSON_PROPERTY_WEBHOOKS_DELIVERED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWebhooksDeliveredAt(Long webhooksDeliveredAt) {
    this.webhooksDeliveredAt = webhooksDeliveredAt;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Invoice invoice = (Invoice) o;
    return Objects.equals(this.accountCountry, invoice.accountCountry) &&
        Objects.equals(this.accountName, invoice.accountName) &&
        Objects.equals(this.amountDue, invoice.amountDue) &&
        Objects.equals(this.amountPaid, invoice.amountPaid) &&
        Objects.equals(this.amountRemaining, invoice.amountRemaining) &&
        Objects.equals(this.applicationFeeAmount, invoice.applicationFeeAmount) &&
        Objects.equals(this.attemptCount, invoice.attemptCount) &&
        Objects.equals(this.attempted, invoice.attempted) &&
        Objects.equals(this.autoAdvance, invoice.autoAdvance) &&
        Objects.equals(this.billing, invoice.billing) &&
        Objects.equals(this.billingReason, invoice.billingReason) &&
        Objects.equals(this.collectionMethod, invoice.collectionMethod) &&
        Objects.equals(this.created, invoice.created) &&
        Objects.equals(this.currency, invoice.currency) &&
        Objects.equals(this.customerAddress, invoice.customerAddress) &&
        Objects.equals(this.customerEmail, invoice.customerEmail) &&
        Objects.equals(this.customerName, invoice.customerName) &&
        Objects.equals(this.customerPhone, invoice.customerPhone) &&
        Objects.equals(this.customerShipping, invoice.customerShipping) &&
        Objects.equals(this.customerTaxExempt, invoice.customerTaxExempt) &&
        Objects.equals(this.customerTaxIds, invoice.customerTaxIds) &&
        Objects.equals(this.defaultTaxRates, invoice.defaultTaxRates) &&
        Objects.equals(this.deleted, invoice.deleted) &&
        Objects.equals(this.description, invoice.description) &&
        Objects.equals(this.discount, invoice.discount) &&
        Objects.equals(this.dueDate, invoice.dueDate) &&
        Objects.equals(this.endingBalance, invoice.endingBalance) &&
        Objects.equals(this.footer, invoice.footer) &&
        Objects.equals(this.hostedInvoiceUrl, invoice.hostedInvoiceUrl) &&
        Objects.equals(this.id, invoice.id) &&
        Objects.equals(this.invoicePdf, invoice.invoicePdf) &&
        Objects.equals(this.lines, invoice.lines) &&
        Objects.equals(this.livemode, invoice.livemode) &&
        Objects.equals(this.metadata, invoice.metadata) &&
        Objects.equals(this.nextPaymentAttempt, invoice.nextPaymentAttempt) &&
        Objects.equals(this.number, invoice.number) &&
        Objects.equals(this._object, invoice._object) &&
        Objects.equals(this.paid, invoice.paid) &&
        Objects.equals(this.periodEnd, invoice.periodEnd) &&
        Objects.equals(this.periodStart, invoice.periodStart) &&
        Objects.equals(this.postPaymentCreditNotesAmount, invoice.postPaymentCreditNotesAmount) &&
        Objects.equals(this.prePaymentCreditNotesAmount, invoice.prePaymentCreditNotesAmount) &&
        Objects.equals(this.receiptNumber, invoice.receiptNumber) &&
        Objects.equals(this.startingBalance, invoice.startingBalance) &&
        Objects.equals(this.statementDescriptor, invoice.statementDescriptor) &&
        Objects.equals(this.status, invoice.status) &&
        Objects.equals(this.statusTransitions, invoice.statusTransitions) &&
        Objects.equals(this.subscriptionProrationDate, invoice.subscriptionProrationDate) &&
        Objects.equals(this.subtotal, invoice.subtotal) &&
        Objects.equals(this.tax, invoice.tax) &&
        Objects.equals(this.thresholdReason, invoice.thresholdReason) &&
        Objects.equals(this.total, invoice.total) &&
        Objects.equals(this.totalTaxAmounts, invoice.totalTaxAmounts) &&
        Objects.equals(this.transferData, invoice.transferData) &&
        Objects.equals(this.webhooksDeliveredAt, invoice.webhooksDeliveredAt);
  }

  @Override
  public int hashCode() {
    return Objects.hash(accountCountry, accountName, amountDue, amountPaid, amountRemaining, applicationFeeAmount, attemptCount, attempted, autoAdvance, billing, billingReason, collectionMethod, created, currency, customerAddress, customerEmail, customerName, customerPhone, customerShipping, customerTaxExempt, customerTaxIds, defaultTaxRates, deleted, description, discount, dueDate, endingBalance, footer, hostedInvoiceUrl, id, invoicePdf, lines, livemode, metadata, nextPaymentAttempt, number, _object, paid, periodEnd, periodStart, postPaymentCreditNotesAmount, prePaymentCreditNotesAmount, receiptNumber, startingBalance, statementDescriptor, status, statusTransitions, subscriptionProrationDate, subtotal, tax, thresholdReason, total, totalTaxAmounts, transferData, webhooksDeliveredAt);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Invoice {\n");
    sb.append("    accountCountry: ").append(toIndentedString(accountCountry)).append("\n");
    sb.append("    accountName: ").append(toIndentedString(accountName)).append("\n");
    sb.append("    amountDue: ").append(toIndentedString(amountDue)).append("\n");
    sb.append("    amountPaid: ").append(toIndentedString(amountPaid)).append("\n");
    sb.append("    amountRemaining: ").append(toIndentedString(amountRemaining)).append("\n");
    sb.append("    applicationFeeAmount: ").append(toIndentedString(applicationFeeAmount)).append("\n");
    sb.append("    attemptCount: ").append(toIndentedString(attemptCount)).append("\n");
    sb.append("    attempted: ").append(toIndentedString(attempted)).append("\n");
    sb.append("    autoAdvance: ").append(toIndentedString(autoAdvance)).append("\n");
    sb.append("    billing: ").append(toIndentedString(billing)).append("\n");
    sb.append("    billingReason: ").append(toIndentedString(billingReason)).append("\n");
    sb.append("    collectionMethod: ").append(toIndentedString(collectionMethod)).append("\n");
    sb.append("    created: ").append(toIndentedString(created)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    customerAddress: ").append(toIndentedString(customerAddress)).append("\n");
    sb.append("    customerEmail: ").append(toIndentedString(customerEmail)).append("\n");
    sb.append("    customerName: ").append(toIndentedString(customerName)).append("\n");
    sb.append("    customerPhone: ").append(toIndentedString(customerPhone)).append("\n");
    sb.append("    customerShipping: ").append(toIndentedString(customerShipping)).append("\n");
    sb.append("    customerTaxExempt: ").append(toIndentedString(customerTaxExempt)).append("\n");
    sb.append("    customerTaxIds: ").append(toIndentedString(customerTaxIds)).append("\n");
    sb.append("    defaultTaxRates: ").append(toIndentedString(defaultTaxRates)).append("\n");
    sb.append("    deleted: ").append(toIndentedString(deleted)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    discount: ").append(toIndentedString(discount)).append("\n");
    sb.append("    dueDate: ").append(toIndentedString(dueDate)).append("\n");
    sb.append("    endingBalance: ").append(toIndentedString(endingBalance)).append("\n");
    sb.append("    footer: ").append(toIndentedString(footer)).append("\n");
    sb.append("    hostedInvoiceUrl: ").append(toIndentedString(hostedInvoiceUrl)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    invoicePdf: ").append(toIndentedString(invoicePdf)).append("\n");
    sb.append("    lines: ").append(toIndentedString(lines)).append("\n");
    sb.append("    livemode: ").append(toIndentedString(livemode)).append("\n");
    sb.append("    metadata: ").append(toIndentedString(metadata)).append("\n");
    sb.append("    nextPaymentAttempt: ").append(toIndentedString(nextPaymentAttempt)).append("\n");
    sb.append("    number: ").append(toIndentedString(number)).append("\n");
    sb.append("    _object: ").append(toIndentedString(_object)).append("\n");
    sb.append("    paid: ").append(toIndentedString(paid)).append("\n");
    sb.append("    periodEnd: ").append(toIndentedString(periodEnd)).append("\n");
    sb.append("    periodStart: ").append(toIndentedString(periodStart)).append("\n");
    sb.append("    postPaymentCreditNotesAmount: ").append(toIndentedString(postPaymentCreditNotesAmount)).append("\n");
    sb.append("    prePaymentCreditNotesAmount: ").append(toIndentedString(prePaymentCreditNotesAmount)).append("\n");
    sb.append("    receiptNumber: ").append(toIndentedString(receiptNumber)).append("\n");
    sb.append("    startingBalance: ").append(toIndentedString(startingBalance)).append("\n");
    sb.append("    statementDescriptor: ").append(toIndentedString(statementDescriptor)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    statusTransitions: ").append(toIndentedString(statusTransitions)).append("\n");
    sb.append("    subscriptionProrationDate: ").append(toIndentedString(subscriptionProrationDate)).append("\n");
    sb.append("    subtotal: ").append(toIndentedString(subtotal)).append("\n");
    sb.append("    tax: ").append(toIndentedString(tax)).append("\n");
    sb.append("    thresholdReason: ").append(toIndentedString(thresholdReason)).append("\n");
    sb.append("    total: ").append(toIndentedString(total)).append("\n");
    sb.append("    totalTaxAmounts: ").append(toIndentedString(totalTaxAmounts)).append("\n");
    sb.append("    transferData: ").append(toIndentedString(transferData)).append("\n");
    sb.append("    webhooksDeliveredAt: ").append(toIndentedString(webhooksDeliveredAt)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

