/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import travel.wink.sdk.extranet.model.Address;
import travel.wink.sdk.extranet.model.Contact;
import travel.wink.sdk.extranet.model.DowPatternGroup;
import travel.wink.sdk.extranet.model.GeoJsonPoint;
import travel.wink.sdk.extranet.model.Moneys;
import travel.wink.sdk.extranet.model.Multimedia;
import travel.wink.sdk.extranet.model.SimpleDescription;
import travel.wink.sdk.extranet.model.Social;

@JsonPropertyOrder(value={"identifier", "hotelIdentifier", "featuredInd", "lifestyleType", "location", "descriptions", "multimedias", "contact", "address", "commissionable", "name", "proximityCode", "sort", "minAgeAppropriateCode", "bookable", "active", "disabilityFeatures", "securityFeatures", "socials", "applicableStart", "applicableEnd", "reservationRequiredInd", "opens", "closes", "fee", "percentDiscount", "daysOfWeek", "maxSeatingCapacity", "maxSingleParty", "offerBreakfast", "offerLunch", "offerDinner", "offerBrunch", "amenities", "infoCodes", "cuisineCodes", "pricingType"})
public class Restaurant {
    public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
    private String identifier;
    public static final String JSON_PROPERTY_HOTEL_IDENTIFIER = "hotelIdentifier";
    private String hotelIdentifier;
    public static final String JSON_PROPERTY_FEATURED_IND = "featuredInd";
    private Boolean featuredInd;
    public static final String JSON_PROPERTY_LIFESTYLE_TYPE = "lifestyleType";
    private LifestyleTypeEnum lifestyleType;
    public static final String JSON_PROPERTY_LOCATION = "location";
    private GeoJsonPoint location;
    public static final String JSON_PROPERTY_DESCRIPTIONS = "descriptions";
    private List<SimpleDescription> descriptions = new ArrayList<SimpleDescription>();
    public static final String JSON_PROPERTY_MULTIMEDIAS = "multimedias";
    private List<Multimedia> multimedias = new ArrayList<Multimedia>();
    public static final String JSON_PROPERTY_CONTACT = "contact";
    private Contact contact;
    public static final String JSON_PROPERTY_ADDRESS = "address";
    private Address address;
    public static final String JSON_PROPERTY_COMMISSIONABLE = "commissionable";
    private Boolean commissionable = true;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_PROXIMITY_CODE = "proximityCode";
    private String proximityCode;
    public static final String JSON_PROPERTY_SORT = "sort";
    private Integer sort;
    public static final String JSON_PROPERTY_MIN_AGE_APPROPRIATE_CODE = "minAgeAppropriateCode";
    private String minAgeAppropriateCode;
    public static final String JSON_PROPERTY_BOOKABLE = "bookable";
    private Boolean bookable = true;
    public static final String JSON_PROPERTY_ACTIVE = "active";
    private Boolean active = true;
    public static final String JSON_PROPERTY_DISABILITY_FEATURES = "disabilityFeatures";
    private List<String> disabilityFeatures = null;
    public static final String JSON_PROPERTY_SECURITY_FEATURES = "securityFeatures";
    private List<String> securityFeatures = null;
    public static final String JSON_PROPERTY_SOCIALS = "socials";
    private List<Social> socials = null;
    public static final String JSON_PROPERTY_APPLICABLE_START = "applicableStart";
    private LocalDate applicableStart;
    public static final String JSON_PROPERTY_APPLICABLE_END = "applicableEnd";
    private LocalDate applicableEnd;
    public static final String JSON_PROPERTY_RESERVATION_REQUIRED_IND = "reservationRequiredInd";
    private Boolean reservationRequiredInd;
    public static final String JSON_PROPERTY_OPENS = "opens";
    private String opens;
    public static final String JSON_PROPERTY_CLOSES = "closes";
    private String closes;
    public static final String JSON_PROPERTY_FEE = "fee";
    private Moneys fee;
    public static final String JSON_PROPERTY_PERCENT_DISCOUNT = "percentDiscount";
    private Double percentDiscount;
    public static final String JSON_PROPERTY_DAYS_OF_WEEK = "daysOfWeek";
    private DowPatternGroup daysOfWeek;
    public static final String JSON_PROPERTY_MAX_SEATING_CAPACITY = "maxSeatingCapacity";
    private Integer maxSeatingCapacity;
    public static final String JSON_PROPERTY_MAX_SINGLE_PARTY = "maxSingleParty";
    private Integer maxSingleParty;
    public static final String JSON_PROPERTY_OFFER_BREAKFAST = "offerBreakfast";
    private Boolean offerBreakfast = false;
    public static final String JSON_PROPERTY_OFFER_LUNCH = "offerLunch";
    private Boolean offerLunch = false;
    public static final String JSON_PROPERTY_OFFER_DINNER = "offerDinner";
    private Boolean offerDinner = false;
    public static final String JSON_PROPERTY_OFFER_BRUNCH = "offerBrunch";
    private Boolean offerBrunch = false;
    public static final String JSON_PROPERTY_AMENITIES = "amenities";
    private List<String> amenities = null;
    public static final String JSON_PROPERTY_INFO_CODES = "infoCodes";
    private List<String> infoCodes = null;
    public static final String JSON_PROPERTY_CUISINE_CODES = "cuisineCodes";
    private List<String> cuisineCodes = null;
    public static final String JSON_PROPERTY_PRICING_TYPE = "pricingType";
    private PricingTypeEnum pricingType;

    public Restaurant identifier(String identifier) {
        this.identifier = identifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="document-1", value="Unique record identifier")
    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public Restaurant hotelIdentifier(String hotelIdentifier) {
        this.hotelIdentifier = hotelIdentifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="hotel-1", value="Hotel identifier.")
    @JsonProperty(value="hotelIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getHotelIdentifier() {
        return this.hotelIdentifier;
    }

    @JsonProperty(value="hotelIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHotelIdentifier(String hotelIdentifier) {
        this.hotelIdentifier = hotelIdentifier;
    }

    public Restaurant featuredInd(Boolean featuredInd) {
        this.featuredInd = featuredInd;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="false", required=true, value="Indicates whether this inventory is featured. Use this flag as a way to signify that this inventory is special.")
    @JsonProperty(value="featuredInd")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getFeaturedInd() {
        return this.featuredInd;
    }

    @JsonProperty(value="featuredInd")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setFeaturedInd(Boolean featuredInd) {
        this.featuredInd = featuredInd;
    }

    public Restaurant lifestyleType(LifestyleTypeEnum lifestyleType) {
        this.lifestyleType = lifestyleType;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="LIFESTYLE_HEALTH_FITNESS", value="Indicate the type of lifestyle this inventory should be associated with.")
    @JsonProperty(value="lifestyleType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LifestyleTypeEnum getLifestyleType() {
        return this.lifestyleType;
    }

    @JsonProperty(value="lifestyleType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLifestyleType(LifestyleTypeEnum lifestyleType) {
        this.lifestyleType = lifestyleType;
    }

    public Restaurant location(GeoJsonPoint location) {
        this.location = location;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="location")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public GeoJsonPoint getLocation() {
        return this.location;
    }

    @JsonProperty(value="location")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setLocation(GeoJsonPoint location) {
        this.location = location;
    }

    public Restaurant descriptions(List<SimpleDescription> descriptions) {
        this.descriptions = descriptions;
        return this;
    }

    public Restaurant addDescriptionsItem(SimpleDescription descriptionsItem) {
        this.descriptions.add(descriptionsItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Localized descriptions describing inventory.")
    @JsonProperty(value="descriptions")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<SimpleDescription> getDescriptions() {
        return this.descriptions;
    }

    @JsonProperty(value="descriptions")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDescriptions(List<SimpleDescription> descriptions) {
        this.descriptions = descriptions;
    }

    public Restaurant multimedias(List<Multimedia> multimedias) {
        this.multimedias = multimedias;
        return this;
    }

    public Restaurant addMultimediasItem(Multimedia multimediasItem) {
        this.multimedias.add(multimediasItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="List of images / videos of inventory.")
    @JsonProperty(value="multimedias")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<Multimedia> getMultimedias() {
        return this.multimedias;
    }

    @JsonProperty(value="multimedias")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMultimedias(List<Multimedia> multimedias) {
        this.multimedias = multimedias;
    }

    public Restaurant contact(Contact contact) {
        this.contact = contact;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="contact")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Contact getContact() {
        return this.contact;
    }

    @JsonProperty(value="contact")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setContact(Contact contact) {
        this.contact = contact;
    }

    public Restaurant address(Address address) {
        this.address = address;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Address getAddress() {
        return this.address;
    }

    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAddress(Address address) {
        this.address = address;
    }

    public Restaurant commissionable(Boolean commissionable) {
        this.commissionable = commissionable;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="true", required=true, value="Indicate whether sales channels receive commission for selling this inventory.")
    @JsonProperty(value="commissionable")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getCommissionable() {
        return this.commissionable;
    }

    @JsonProperty(value="commissionable")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCommissionable(Boolean commissionable) {
        this.commissionable = commissionable;
    }

    public Restaurant name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="Archery lesson", required=true, value="Internal name of inventory.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public Restaurant proximityCode(String proximityCode) {
        this.proximityCode = proximityCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1", value="Supported OTA specification `PRX` code. See [OTA geoname data](#operation/showAvailableCodesForCategory)")
    @JsonProperty(value="proximityCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getProximityCode() {
        return this.proximityCode;
    }

    @JsonProperty(value="proximityCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProximityCode(String proximityCode) {
        this.proximityCode = proximityCode;
    }

    public Restaurant sort(Integer sort) {
        this.sort = sort;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1", value="Use this property to sort an inventory in a list of activities.")
    @JsonProperty(value="sort")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getSort() {
        return this.sort;
    }

    @JsonProperty(value="sort")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSort(Integer sort) {
        this.sort = sort;
    }

    public Restaurant minAgeAppropriateCode(String minAgeAppropriateCode) {
        this.minAgeAppropriateCode = minAgeAppropriateCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1", value="Supported OTA specification `AQC` code. See [OTA geoname data](#operation/showAvailableCodesForCategory)")
    @JsonProperty(value="minAgeAppropriateCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMinAgeAppropriateCode() {
        return this.minAgeAppropriateCode;
    }

    @JsonProperty(value="minAgeAppropriateCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMinAgeAppropriateCode(String minAgeAppropriateCode) {
        this.minAgeAppropriateCode = minAgeAppropriateCode;
    }

    public Restaurant bookable(Boolean bookable) {
        this.bookable = bookable;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="true", required=true, value="Indicates if this inventory can be added to a booking or if it is read-only marketing material only.")
    @JsonProperty(value="bookable")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getBookable() {
        return this.bookable;
    }

    @JsonProperty(value="bookable")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setBookable(Boolean bookable) {
        this.bookable = bookable;
    }

    public Restaurant active(Boolean active) {
        this.active = active;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="true", required=true, value="Modify inventory availability with this flag.")
    @JsonProperty(value="active")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getActive() {
        return this.active;
    }

    @JsonProperty(value="active")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setActive(Boolean active) {
        this.active = active;
    }

    public Restaurant disabilityFeatures(List<String> disabilityFeatures) {
        this.disabilityFeatures = disabilityFeatures;
        return this;
    }

    public Restaurant addDisabilityFeaturesItem(String disabilityFeaturesItem) {
        if (this.disabilityFeatures == null) {
            this.disabilityFeatures = new ArrayList<String>();
        }
        this.disabilityFeatures.add(disabilityFeaturesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"1\"]", value="Supported OTA specification `PHY` code. See [OTA geoname data](#operation/showAvailableCodesForCategory)")
    @JsonProperty(value="disabilityFeatures")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getDisabilityFeatures() {
        return this.disabilityFeatures;
    }

    @JsonProperty(value="disabilityFeatures")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDisabilityFeatures(List<String> disabilityFeatures) {
        this.disabilityFeatures = disabilityFeatures;
    }

    public Restaurant securityFeatures(List<String> securityFeatures) {
        this.securityFeatures = securityFeatures;
        return this;
    }

    public Restaurant addSecurityFeaturesItem(String securityFeaturesItem) {
        if (this.securityFeatures == null) {
            this.securityFeatures = new ArrayList<String>();
        }
        this.securityFeatures.add(securityFeaturesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"1\"]", value="Supported OTA specification `SEC` code. See [OTA geoname data](#operation/showAvailableCodesForCategory)")
    @JsonProperty(value="securityFeatures")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getSecurityFeatures() {
        return this.securityFeatures;
    }

    @JsonProperty(value="securityFeatures")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSecurityFeatures(List<String> securityFeatures) {
        this.securityFeatures = securityFeatures;
    }

    public Restaurant socials(List<Social> socials) {
        this.socials = socials;
        return this;
    }

    public Restaurant addSocialsItem(Social socialsItem) {
        if (this.socials == null) {
            this.socials = new ArrayList<Social>();
        }
        this.socials.add(socialsItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Social network accounts for inventory (if applicable).")
    @JsonProperty(value="socials")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Social> getSocials() {
        return this.socials;
    }

    @JsonProperty(value="socials")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSocials(List<Social> socials) {
        this.socials = socials;
    }

    public Restaurant applicableStart(LocalDate applicableStart) {
        this.applicableStart = applicableStart;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(example="Thu Jan 01 07:00:00 ICT 1970", value="Start month and day or date for which the attraction (e.g. the start of a season) is available. This date property signifies that the inventory is recurring and / or seasonal. If the date is in the past, only day and month will be used to infer seasonality. If the date is a future date, it will be interpreted as a starting date.")
    @JsonProperty(value="applicableStart")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDate getApplicableStart() {
        return this.applicableStart;
    }

    @JsonProperty(value="applicableStart")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setApplicableStart(LocalDate applicableStart) {
        this.applicableStart = applicableStart;
    }

    public Restaurant applicableEnd(LocalDate applicableEnd) {
        this.applicableEnd = applicableEnd;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(example="Tue Dec 01 07:00:00 ICT 1970", value="End month and day or date for which the attraction (e.g. the start of a season) is available. This date property signifies that the inventory is recurring and / or seasonal. If the date is in the past, only day and month will be used to infer seasonality. If the date is a future date, it will be interpreted as a ending date.")
    @JsonProperty(value="applicableEnd")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDate getApplicableEnd() {
        return this.applicableEnd;
    }

    @JsonProperty(value="applicableEnd")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setApplicableEnd(LocalDate applicableEnd) {
        this.applicableEnd = applicableEnd;
    }

    public Restaurant reservationRequiredInd(Boolean reservationRequiredInd) {
        this.reservationRequiredInd = reservationRequiredInd;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Indicates whether a reservation is required to participate in this inventory.")
    @JsonProperty(value="reservationRequiredInd")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getReservationRequiredInd() {
        return this.reservationRequiredInd;
    }

    @JsonProperty(value="reservationRequiredInd")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReservationRequiredInd(Boolean reservationRequiredInd) {
        this.reservationRequiredInd = reservationRequiredInd;
    }

    public Restaurant opens(String opens) {
        this.opens = opens;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="09:00", value="Opening time of inventory (if applicable). Leave empty if inventory is always available.")
    @JsonProperty(value="opens")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOpens() {
        return this.opens;
    }

    @JsonProperty(value="opens")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOpens(String opens) {
        this.opens = opens;
    }

    public Restaurant closes(String closes) {
        this.closes = closes;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="17:30", value="Closing time of inventory (if applicable). Leave empty if inventory is always available.")
    @JsonProperty(value="closes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCloses() {
        return this.closes;
    }

    @JsonProperty(value="closes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCloses(String closes) {
        this.closes = closes;
    }

    public Restaurant fee(Moneys fee) {
        this.fee = fee;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="fee")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Moneys getFee() {
        return this.fee;
    }

    @JsonProperty(value="fee")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFee(Moneys fee) {
        this.fee = fee;
    }

    public Restaurant percentDiscount(Double percentDiscount) {
        this.percentDiscount = percentDiscount;
        return this;
    }

    @Nonnull
    @NotNull
    @DecimalMin(value="0.0")
    @DecimalMax(value="1.0")
    @ApiModelProperty(example="0.2", required=true, value="Expected savings. Indicate how much the traveler is [usually] saving by booking it through this payment. Example: 20% discount.")
    @JsonProperty(value="percentDiscount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @DecimalMin(value="0.0") @DecimalMax(value="1.0") Double getPercentDiscount() {
        return this.percentDiscount;
    }

    @JsonProperty(value="percentDiscount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPercentDiscount(Double percentDiscount) {
        this.percentDiscount = percentDiscount;
    }

    public Restaurant daysOfWeek(DowPatternGroup daysOfWeek) {
        this.daysOfWeek = daysOfWeek;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="daysOfWeek")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DowPatternGroup getDaysOfWeek() {
        return this.daysOfWeek;
    }

    @JsonProperty(value="daysOfWeek")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDaysOfWeek(DowPatternGroup daysOfWeek) {
        this.daysOfWeek = daysOfWeek;
    }

    public Restaurant maxSeatingCapacity(Integer maxSeatingCapacity) {
        this.maxSeatingCapacity = maxSeatingCapacity;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=1L)
    @ApiModelProperty(example="100", required=true, value="Restaurant supports these many people.")
    @JsonProperty(value="maxSeatingCapacity")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=1L) Integer getMaxSeatingCapacity() {
        return this.maxSeatingCapacity;
    }

    @JsonProperty(value="maxSeatingCapacity")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMaxSeatingCapacity(Integer maxSeatingCapacity) {
        this.maxSeatingCapacity = maxSeatingCapacity;
    }

    public Restaurant maxSingleParty(Integer maxSingleParty) {
        this.maxSingleParty = maxSingleParty;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=1L)
    @ApiModelProperty(example="10", required=true, value="Largest table at restaurant.")
    @JsonProperty(value="maxSingleParty")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=1L) Integer getMaxSingleParty() {
        return this.maxSingleParty;
    }

    @JsonProperty(value="maxSingleParty")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMaxSingleParty(Integer maxSingleParty) {
        this.maxSingleParty = maxSingleParty;
    }

    public Restaurant offerBreakfast(Boolean offerBreakfast) {
        this.offerBreakfast = offerBreakfast;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="true", required=true, value="Restaurant offers breakfast.")
    @JsonProperty(value="offerBreakfast")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getOfferBreakfast() {
        return this.offerBreakfast;
    }

    @JsonProperty(value="offerBreakfast")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setOfferBreakfast(Boolean offerBreakfast) {
        this.offerBreakfast = offerBreakfast;
    }

    public Restaurant offerLunch(Boolean offerLunch) {
        this.offerLunch = offerLunch;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="true", required=true, value="Restaurant offers lunch.")
    @JsonProperty(value="offerLunch")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getOfferLunch() {
        return this.offerLunch;
    }

    @JsonProperty(value="offerLunch")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setOfferLunch(Boolean offerLunch) {
        this.offerLunch = offerLunch;
    }

    public Restaurant offerDinner(Boolean offerDinner) {
        this.offerDinner = offerDinner;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="true", required=true, value="Restaurant offers dinner.")
    @JsonProperty(value="offerDinner")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getOfferDinner() {
        return this.offerDinner;
    }

    @JsonProperty(value="offerDinner")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setOfferDinner(Boolean offerDinner) {
        this.offerDinner = offerDinner;
    }

    public Restaurant offerBrunch(Boolean offerBrunch) {
        this.offerBrunch = offerBrunch;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="true", required=true, value="Restaurant offers brunch.")
    @JsonProperty(value="offerBrunch")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getOfferBrunch() {
        return this.offerBrunch;
    }

    @JsonProperty(value="offerBrunch")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setOfferBrunch(Boolean offerBrunch) {
        this.offerBrunch = offerBrunch;
    }

    public Restaurant amenities(List<String> amenities) {
        this.amenities = amenities;
        return this;
    }

    public Restaurant addAmenitiesItem(String amenitiesItem) {
        if (this.amenities == null) {
            this.amenities = new ArrayList<String>();
        }
        this.amenities.add(amenitiesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"1\"]", value="Supported OTA specification `RSI` code. See [OTA geoname data](#operation/showAvailableCodesForCategory).")
    @JsonProperty(value="amenities")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getAmenities() {
        return this.amenities;
    }

    @JsonProperty(value="amenities")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmenities(List<String> amenities) {
        this.amenities = amenities;
    }

    public Restaurant infoCodes(List<String> infoCodes) {
        this.infoCodes = infoCodes;
        return this;
    }

    public Restaurant addInfoCodesItem(String infoCodesItem) {
        if (this.infoCodes == null) {
            this.infoCodes = new ArrayList<String>();
        }
        this.infoCodes.add(infoCodesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"1\"]", value="Supported OTA specification `RES` code. See [OTA geoname data](#operation/showAvailableCodesForCategory).")
    @JsonProperty(value="infoCodes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getInfoCodes() {
        return this.infoCodes;
    }

    @JsonProperty(value="infoCodes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInfoCodes(List<String> infoCodes) {
        this.infoCodes = infoCodes;
    }

    public Restaurant cuisineCodes(List<String> cuisineCodes) {
        this.cuisineCodes = cuisineCodes;
        return this;
    }

    public Restaurant addCuisineCodesItem(String cuisineCodesItem) {
        if (this.cuisineCodes == null) {
            this.cuisineCodes = new ArrayList<String>();
        }
        this.cuisineCodes.add(cuisineCodesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"1\"]", value="Supported OTA specification `CUI` code. See [OTA geoname data](#operation/showAvailableCodesForCategory).")
    @JsonProperty(value="cuisineCodes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getCuisineCodes() {
        return this.cuisineCodes;
    }

    @JsonProperty(value="cuisineCodes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCuisineCodes(List<String> cuisineCodes) {
        this.cuisineCodes = cuisineCodes;
    }

    public Restaurant pricingType(PricingTypeEnum pricingType) {
        this.pricingType = pricingType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="How this inventory item should be priced.")
    @JsonProperty(value="pricingType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PricingTypeEnum getPricingType() {
        return this.pricingType;
    }

    @JsonProperty(value="pricingType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPricingType(PricingTypeEnum pricingType) {
        this.pricingType = pricingType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Restaurant restaurant = (Restaurant)o;
        return Objects.equals(this.identifier, restaurant.identifier) && Objects.equals(this.hotelIdentifier, restaurant.hotelIdentifier) && Objects.equals(this.featuredInd, restaurant.featuredInd) && Objects.equals((Object)this.lifestyleType, (Object)restaurant.lifestyleType) && Objects.equals(this.location, restaurant.location) && Objects.equals(this.descriptions, restaurant.descriptions) && Objects.equals(this.multimedias, restaurant.multimedias) && Objects.equals(this.contact, restaurant.contact) && Objects.equals(this.address, restaurant.address) && Objects.equals(this.commissionable, restaurant.commissionable) && Objects.equals(this.name, restaurant.name) && Objects.equals(this.proximityCode, restaurant.proximityCode) && Objects.equals(this.sort, restaurant.sort) && Objects.equals(this.minAgeAppropriateCode, restaurant.minAgeAppropriateCode) && Objects.equals(this.bookable, restaurant.bookable) && Objects.equals(this.active, restaurant.active) && Objects.equals(this.disabilityFeatures, restaurant.disabilityFeatures) && Objects.equals(this.securityFeatures, restaurant.securityFeatures) && Objects.equals(this.socials, restaurant.socials) && Objects.equals(this.applicableStart, restaurant.applicableStart) && Objects.equals(this.applicableEnd, restaurant.applicableEnd) && Objects.equals(this.reservationRequiredInd, restaurant.reservationRequiredInd) && Objects.equals(this.opens, restaurant.opens) && Objects.equals(this.closes, restaurant.closes) && Objects.equals(this.fee, restaurant.fee) && Objects.equals(this.percentDiscount, restaurant.percentDiscount) && Objects.equals(this.daysOfWeek, restaurant.daysOfWeek) && Objects.equals(this.maxSeatingCapacity, restaurant.maxSeatingCapacity) && Objects.equals(this.maxSingleParty, restaurant.maxSingleParty) && Objects.equals(this.offerBreakfast, restaurant.offerBreakfast) && Objects.equals(this.offerLunch, restaurant.offerLunch) && Objects.equals(this.offerDinner, restaurant.offerDinner) && Objects.equals(this.offerBrunch, restaurant.offerBrunch) && Objects.equals(this.amenities, restaurant.amenities) && Objects.equals(this.infoCodes, restaurant.infoCodes) && Objects.equals(this.cuisineCodes, restaurant.cuisineCodes) && Objects.equals((Object)this.pricingType, (Object)restaurant.pricingType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.identifier, this.hotelIdentifier, this.featuredInd, this.lifestyleType, this.location, this.descriptions, this.multimedias, this.contact, this.address, this.commissionable, this.name, this.proximityCode, this.sort, this.minAgeAppropriateCode, this.bookable, this.active, this.disabilityFeatures, this.securityFeatures, this.socials, this.applicableStart, this.applicableEnd, this.reservationRequiredInd, this.opens, this.closes, this.fee, this.percentDiscount, this.daysOfWeek, this.maxSeatingCapacity, this.maxSingleParty, this.offerBreakfast, this.offerLunch, this.offerDinner, this.offerBrunch, this.amenities, this.infoCodes, this.cuisineCodes, this.pricingType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Restaurant {\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    hotelIdentifier: ").append(this.toIndentedString(this.hotelIdentifier)).append("\n");
        sb.append("    featuredInd: ").append(this.toIndentedString(this.featuredInd)).append("\n");
        sb.append("    lifestyleType: ").append(this.toIndentedString((Object)this.lifestyleType)).append("\n");
        sb.append("    location: ").append(this.toIndentedString(this.location)).append("\n");
        sb.append("    descriptions: ").append(this.toIndentedString(this.descriptions)).append("\n");
        sb.append("    multimedias: ").append(this.toIndentedString(this.multimedias)).append("\n");
        sb.append("    contact: ").append(this.toIndentedString(this.contact)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    commissionable: ").append(this.toIndentedString(this.commissionable)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    proximityCode: ").append(this.toIndentedString(this.proximityCode)).append("\n");
        sb.append("    sort: ").append(this.toIndentedString(this.sort)).append("\n");
        sb.append("    minAgeAppropriateCode: ").append(this.toIndentedString(this.minAgeAppropriateCode)).append("\n");
        sb.append("    bookable: ").append(this.toIndentedString(this.bookable)).append("\n");
        sb.append("    active: ").append(this.toIndentedString(this.active)).append("\n");
        sb.append("    disabilityFeatures: ").append(this.toIndentedString(this.disabilityFeatures)).append("\n");
        sb.append("    securityFeatures: ").append(this.toIndentedString(this.securityFeatures)).append("\n");
        sb.append("    socials: ").append(this.toIndentedString(this.socials)).append("\n");
        sb.append("    applicableStart: ").append(this.toIndentedString(this.applicableStart)).append("\n");
        sb.append("    applicableEnd: ").append(this.toIndentedString(this.applicableEnd)).append("\n");
        sb.append("    reservationRequiredInd: ").append(this.toIndentedString(this.reservationRequiredInd)).append("\n");
        sb.append("    opens: ").append(this.toIndentedString(this.opens)).append("\n");
        sb.append("    closes: ").append(this.toIndentedString(this.closes)).append("\n");
        sb.append("    fee: ").append(this.toIndentedString(this.fee)).append("\n");
        sb.append("    percentDiscount: ").append(this.toIndentedString(this.percentDiscount)).append("\n");
        sb.append("    daysOfWeek: ").append(this.toIndentedString(this.daysOfWeek)).append("\n");
        sb.append("    maxSeatingCapacity: ").append(this.toIndentedString(this.maxSeatingCapacity)).append("\n");
        sb.append("    maxSingleParty: ").append(this.toIndentedString(this.maxSingleParty)).append("\n");
        sb.append("    offerBreakfast: ").append(this.toIndentedString(this.offerBreakfast)).append("\n");
        sb.append("    offerLunch: ").append(this.toIndentedString(this.offerLunch)).append("\n");
        sb.append("    offerDinner: ").append(this.toIndentedString(this.offerDinner)).append("\n");
        sb.append("    offerBrunch: ").append(this.toIndentedString(this.offerBrunch)).append("\n");
        sb.append("    amenities: ").append(this.toIndentedString(this.amenities)).append("\n");
        sb.append("    infoCodes: ").append(this.toIndentedString(this.infoCodes)).append("\n");
        sb.append("    cuisineCodes: ").append(this.toIndentedString(this.cuisineCodes)).append("\n");
        sb.append("    pricingType: ").append(this.toIndentedString((Object)this.pricingType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum LifestyleTypeEnum {
        HEALTH_FITNESS("LIFESTYLE_HEALTH_FITNESS"),
        RELAX("LIFESTYLE_RELAX"),
        ADULT_ONLY("LIFESTYLE_ADULT_ONLY"),
        ADVENTURE("LIFESTYLE_ADVENTURE"),
        BUSINESS("LIFESTYLE_BUSINESS"),
        LGBT("LIFESTYLE_LGBT"),
        SINGLE_PARENT("LIFESTYLE_SINGLE_PARENT"),
        SOLO_FEMALE("LIFESTYLE_SOLO_FEMALE"),
        BEAUTY("LIFESTYLE_BEAUTY"),
        FOODIE("LIFESTYLE_FOODIE"),
        FAMILY("LIFESTYLE_FAMILY"),
        ROMANCE("LIFESTYLE_ROMANCE"),
        COUPLE("LIFESTYLE_COUPLE"),
        SOLO("LIFESTYLE_SOLO"),
        BACKPACKER("LIFESTYLE_BACKPACKER"),
        SHOPPING("LIFESTYLE_SHOPPING"),
        SPORTS("LIFESTYLE_SPORTS"),
        MOUNTAIN("LIFESTYLE_MOUNTAIN"),
        BEACH("LIFESTYLE_BEACH"),
        CITY("LIFESTYLE_CITY"),
        COUNTRY("LIFESTYLE_COUNTRY"),
        CULTURE("LIFESTYLE_CULTURE"),
        ECO("LIFESTYLE_ECO");

        private String value;

        private LifestyleTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static LifestyleTypeEnum fromValue(String value) {
            for (LifestyleTypeEnum b : LifestyleTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum PricingTypeEnum {
        PERSON_PER_USE("PER_PERSON_PER_USE"),
        USE("PER_USE"),
        PERSON_PER_HOUR("PER_PERSON_PER_HOUR"),
        HOUR("PER_HOUR");

        private String value;

        private PricingTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PricingTypeEnum fromValue(String value) {
            for (PricingTypeEnum b : PricingTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

