/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import travel.wink.sdk.extranet.model.RateModifierBundleModifierOverride;

@JsonPropertyOrder(value={"name", "enabled", "itemIdentifiers", "modifierOverride", "type", "pricingType"})
public class UpsertRateModifierBundleRequest {
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_ENABLED = "enabled";
    private Boolean enabled = true;
    public static final String JSON_PROPERTY_ITEM_IDENTIFIERS = "itemIdentifiers";
    private List<String> itemIdentifiers = new ArrayList<String>();
    public static final String JSON_PROPERTY_MODIFIER_OVERRIDE = "modifierOverride";
    private RateModifierBundleModifierOverride modifierOverride;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_PRICING_TYPE = "pricingType";
    private PricingTypeEnum pricingType;

    public UpsertRateModifierBundleRequest name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="Early bird - Long Term", required=true, value="Internal name of promotion ancillary.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public UpsertRateModifierBundleRequest enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="true", required=true, value="Whether this promotion ancillary is enabled or not.")
    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getEnabled() {
        return this.enabled;
    }

    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public UpsertRateModifierBundleRequest itemIdentifiers(List<String> itemIdentifiers) {
        this.itemIdentifiers = itemIdentifiers;
        return this;
    }

    public UpsertRateModifierBundleRequest addItemIdentifiersItem(String itemIdentifiersItem) {
        this.itemIdentifiers.add(itemIdentifiersItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=2, max=0x7FFFFFFF)
    @ApiModelProperty(example="[\"rate-modifier-1\",\"rate-modifier-2\"]", required=true, value="Promotion identifiers that go together to make up this ancillary.")
    @JsonProperty(value="itemIdentifiers")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=2, max=0x7FFFFFFF) List<String> getItemIdentifiers() {
        return this.itemIdentifiers;
    }

    @JsonProperty(value="itemIdentifiers")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setItemIdentifiers(List<String> itemIdentifiers) {
        this.itemIdentifiers = itemIdentifiers;
    }

    public UpsertRateModifierBundleRequest modifierOverride(RateModifierBundleModifierOverride modifierOverride) {
        this.modifierOverride = modifierOverride;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="modifierOverride")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public RateModifierBundleModifierOverride getModifierOverride() {
        return this.modifierOverride;
    }

    @JsonProperty(value="modifierOverride")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setModifierOverride(RateModifierBundleModifierOverride modifierOverride) {
        this.modifierOverride = modifierOverride;
    }

    public UpsertRateModifierBundleRequest type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="DISCOUNT", required=true, value="Required if manual override modifier is not null")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public UpsertRateModifierBundleRequest pricingType(PricingTypeEnum pricingType) {
        this.pricingType = pricingType;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(required=true, value="Determines whether this discount should be applied per night, per stay or per person - per night; Required if amount override is not null")
    @JsonProperty(value="pricingType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public PricingTypeEnum getPricingType() {
        return this.pricingType;
    }

    @JsonProperty(value="pricingType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPricingType(PricingTypeEnum pricingType) {
        this.pricingType = pricingType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpsertRateModifierBundleRequest upsertRateModifierBundleRequest = (UpsertRateModifierBundleRequest)o;
        return Objects.equals(this.name, upsertRateModifierBundleRequest.name) && Objects.equals(this.enabled, upsertRateModifierBundleRequest.enabled) && Objects.equals(this.itemIdentifiers, upsertRateModifierBundleRequest.itemIdentifiers) && Objects.equals(this.modifierOverride, upsertRateModifierBundleRequest.modifierOverride) && Objects.equals((Object)this.type, (Object)upsertRateModifierBundleRequest.type) && Objects.equals((Object)this.pricingType, (Object)upsertRateModifierBundleRequest.pricingType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.enabled, this.itemIdentifiers, this.modifierOverride, this.type, this.pricingType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpsertRateModifierBundleRequest {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    itemIdentifiers: ").append(this.toIndentedString(this.itemIdentifiers)).append("\n");
        sb.append("    modifierOverride: ").append(this.toIndentedString(this.modifierOverride)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    pricingType: ").append(this.toIndentedString((Object)this.pricingType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        PREMIUM("PREMIUM"),
        DISCOUNT("DISCOUNT");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum PricingTypeEnum {
        HOUR("PER_HOUR"),
        PERSON_PER_HOUR("PER_PERSON_PER_HOUR"),
        STAY("PER_STAY"),
        PERSON("PER_PERSON"),
        NIGHT("PER_NIGHT"),
        PERSON_PER_NIGHT("PER_PERSON_PER_NIGHT"),
        PERSON_PER_STAY("PER_PERSON_PER_STAY"),
        USE("PER_USE");

        private String value;

        private PricingTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PricingTypeEnum fromValue(String value) {
            for (PricingTypeEnum b : PricingTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

