package travel.wink.sdk.extranet.api;

import travel.wink.sdk.extranet.invoker.ApiClient;

import travel.wink.sdk.extranet.model.GenericErrorMessage;
import travel.wink.sdk.extranet.model.HotelView;
import travel.wink.sdk.extranet.model.ShowPropertyPolicy400Response;
import travel.wink.sdk.extranet.model.UpdateChannelManagerRequest;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-06-29T13:20:57.452361+07:00[Asia/Bangkok]")
public class ChannelManagerApi {
    private ApiClient apiClient;

    public ChannelManagerApi() {
        this(new ApiClient());
    }

    @Autowired
    public ChannelManagerApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Set channel manager
     * Set which channel manager this property uses. Channel managers are not allowed access to rates until the property selects them as their channel manager.
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>200</b> - OK
     * @param hotelIdentifier Set channel manager for this hotel identifier
     * @param updateChannelManagerRequest The updateChannelManagerRequest parameter
     * @return HotelView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateChannelManagerRequestCreation(String hotelIdentifier, UpdateChannelManagerRequest updateChannelManagerRequest) throws WebClientResponseException {
        Object postBody = updateChannelManagerRequest;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling updateChannelManager", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'updateChannelManagerRequest' is set
        if (updateChannelManagerRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'updateChannelManagerRequest' when calling updateChannelManager", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<HotelView> localVarReturnType = new ParameterizedTypeReference<HotelView>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/channelmanager", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Set channel manager
     * Set which channel manager this property uses. Channel managers are not allowed access to rates until the property selects them as their channel manager.
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>200</b> - OK
     * @param hotelIdentifier Set channel manager for this hotel identifier
     * @param updateChannelManagerRequest The updateChannelManagerRequest parameter
     * @return HotelView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<HotelView> updateChannelManager(String hotelIdentifier, UpdateChannelManagerRequest updateChannelManagerRequest) throws WebClientResponseException {
        ParameterizedTypeReference<HotelView> localVarReturnType = new ParameterizedTypeReference<HotelView>() {};
        return updateChannelManagerRequestCreation(hotelIdentifier, updateChannelManagerRequest).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<HotelView>> updateChannelManagerWithHttpInfo(String hotelIdentifier, UpdateChannelManagerRequest updateChannelManagerRequest) throws WebClientResponseException {
        ParameterizedTypeReference<HotelView> localVarReturnType = new ParameterizedTypeReference<HotelView>() {};
        return updateChannelManagerRequestCreation(hotelIdentifier, updateChannelManagerRequest).toEntity(localVarReturnType);
    }
}
