/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/docs?api=affiliate): All APIs related to selling travel inventory as an affiliate. - [Extranet](/docs?api=extranet): All APIs related to managing travel inventory and suppliers. - [Booking Engine](/docs?api=booking-engine): All APIs related to searching for travel inventory and creating bookings. - [Channel Manager](https://integration.wink.travel/docs?api=channel-manager): All APIs related to channel managers who want to integrate with our payment.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.payment-v`1`+json.  ## Release history - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Extranet API Welcome to the Extranet API - A programmer-friendly way to manage your travel inventory on the wink payment. This API offers a superset of the features you can find at [https://extranet.wink.travel](https://extranet.wink.travel) and gives you all the tools you need to ready your properties and inventory for sale across 10000s of our unique sales channels. What differentiates us from existing Extranets is 1. we make it available for everyone to use and 2. the care we take in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Content creators have the ability to make their inventory look great and be searchable in a wide variety of ways. You won't find properties with generic inventory, low resolution pictures and little ancillary content that can easily be found everywhere else on the internet.  # Integrations We have already integrated with the most well-known channel managers so you don't have to. Once your properties are set up, you can finish the setup by mapping your property to wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API. - Allotz - CloudBeds / MyAllocator - Comanche - d-edge - FastBooking - HotelLink - HoteliersGuru - Omnibees - RateGain - Rate Tiger - ResAvenue - Siteminder - Sabre SynXis - Travelclick - Yieldplanet  # Intended Audience Programmers are [most likely] a requirement to start integrating with wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible. - Hotel chains - Hotel brands - Travel tech companies - Destination sites - Integrators - Aggregators - Destination management companies - Travel agencies - OTAs  
 *
 * The version of the OpenAPI document: 20.3.2-SNAPSHOT
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.extranet.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import travel.wink.sdk.extranet.model.RateModifier;
import travel.wink.sdk.extranet.model.RateModifierBundle;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Parent sales channel
 */
@ApiModel(description = "Parent sales channel")
@JsonPropertyOrder({
  SalesChannel.JSON_PROPERTY_IDENTIFIER,
  SalesChannel.JSON_PROPERTY_SUPPLIER_IDENTIFIER,
  SalesChannel.JSON_PROPERTY_SUPPLIER_NAME,
  SalesChannel.JSON_PROPERTY_SUPPLIER_AVAILABLE,
  SalesChannel.JSON_PROPERTY_SUB_TYPE,
  SalesChannel.JSON_PROPERTY_OWNER_IDENTIFIER,
  SalesChannel.JSON_PROPERTY_OWNER_NAME,
  SalesChannel.JSON_PROPERTY_ENABLED,
  SalesChannel.JSON_PROPERTY_CHANNEL_DISABLED,
  SalesChannel.JSON_PROPERTY_BLACKLISTED,
  SalesChannel.JSON_PROPERTY_PERCENT_DISCOUNT,
  SalesChannel.JSON_PROPERTY_COMMISSION,
  SalesChannel.JSON_PROPERTY_RATE_MODIFIERS,
  SalesChannel.JSON_PROPERTY_RATE_MODIFIER_BUNDLES
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-06-29T13:20:57.452361+07:00[Asia/Bangkok]")
public class SalesChannel {
  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  private String identifier;

  public static final String JSON_PROPERTY_SUPPLIER_IDENTIFIER = "supplierIdentifier";
  private String supplierIdentifier;

  public static final String JSON_PROPERTY_SUPPLIER_NAME = "supplierName";
  private String supplierName;

  public static final String JSON_PROPERTY_SUPPLIER_AVAILABLE = "supplierAvailable";
  private Boolean supplierAvailable = true;

  /**
   * What type of segment of channel is this.
   */
  public enum SubTypeEnum {
    DIRECT("DIRECT"),
    
    APPLICATION("APPLICATION"),
    
    HOTEL("HOTEL"),
    
    TRAVELIKO("TRAVELIKO"),
    
    CORPORATE("CORPORATE"),
    
    TRAVEL_AGENT("TRAVEL_AGENT"),
    
    INFLUENCER("INFLUENCER"),
    
    BLOGGER("BLOGGER"),
    
    DESTINATION("DESTINATION");

    private String value;

    SubTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static SubTypeEnum fromValue(String value) {
      for (SubTypeEnum b : SubTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_SUB_TYPE = "subType";
  private SubTypeEnum subType;

  public static final String JSON_PROPERTY_OWNER_IDENTIFIER = "ownerIdentifier";
  private String ownerIdentifier;

  public static final String JSON_PROPERTY_OWNER_NAME = "ownerName";
  private String ownerName;

  public static final String JSON_PROPERTY_ENABLED = "enabled";
  private Boolean enabled = true;

  public static final String JSON_PROPERTY_CHANNEL_DISABLED = "channelDisabled";
  private Boolean channelDisabled;

  public static final String JSON_PROPERTY_BLACKLISTED = "blacklisted";
  private Boolean blacklisted;

  public static final String JSON_PROPERTY_PERCENT_DISCOUNT = "percentDiscount";
  private Float percentDiscount;

  public static final String JSON_PROPERTY_COMMISSION = "commission";
  private Float commission;

  public static final String JSON_PROPERTY_RATE_MODIFIERS = "rateModifiers";
  private List<RateModifier> rateModifiers = null;

  public static final String JSON_PROPERTY_RATE_MODIFIER_BUNDLES = "rateModifierBundles";
  private List<RateModifierBundle> rateModifierBundles = null;

  public SalesChannel() { 
  }

  @JsonCreator
  public SalesChannel(
    @JsonProperty(JSON_PROPERTY_SUPPLIER_NAME) String supplierName
  ) {
    this();
    this.supplierName = supplierName;
  }

  public SalesChannel identifier(String identifier) {
    
    this.identifier = identifier;
    return this;
  }

   /**
   * Unique record identifier of this segment / account
   * @return identifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "segment-1", value = "Unique record identifier of this segment / account")
  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIdentifier(String identifier) {
    this.identifier = identifier;
  }


  public SalesChannel supplierIdentifier(String supplierIdentifier) {
    
    this.supplierIdentifier = supplierIdentifier;
    return this;
  }

   /**
   * Channel is owned by this supplier identifier.
   * @return supplierIdentifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "hotel-1", value = "Channel is owned by this supplier identifier.")
  @JsonProperty(JSON_PROPERTY_SUPPLIER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSupplierIdentifier() {
    return supplierIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSupplierIdentifier(String supplierIdentifier) {
    this.supplierIdentifier = supplierIdentifier;
  }


   /**
   * Name of property / supplier that owns this channel
   * @return supplierName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "Hotel 1", value = "Name of property / supplier that owns this channel")
  @JsonProperty(JSON_PROPERTY_SUPPLIER_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSupplierName() {
    return supplierName;
  }




  public SalesChannel supplierAvailable(Boolean supplierAvailable) {
    
    this.supplierAvailable = supplierAvailable;
    return this;
  }

   /**
   * Flag when supplier not available. E.g. Hotel disables property
   * @return supplierAvailable
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "true", value = "Flag when supplier not available. E.g. Hotel disables property")
  @JsonProperty(JSON_PROPERTY_SUPPLIER_AVAILABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSupplierAvailable() {
    return supplierAvailable;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_AVAILABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSupplierAvailable(Boolean supplierAvailable) {
    this.supplierAvailable = supplierAvailable;
  }


  public SalesChannel subType(SubTypeEnum subType) {
    
    this.subType = subType;
    return this;
  }

   /**
   * What type of segment of channel is this.
   * @return subType
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "DIRECT", required = true, value = "What type of segment of channel is this.")
  @JsonProperty(JSON_PROPERTY_SUB_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public SubTypeEnum getSubType() {
    return subType;
  }


  @JsonProperty(JSON_PROPERTY_SUB_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSubType(SubTypeEnum subType) {
    this.subType = subType;
  }


  public SalesChannel ownerIdentifier(String ownerIdentifier) {
    
    this.ownerIdentifier = ownerIdentifier;
    return this;
  }

   /**
   * A specific identifier for the company / corporation / travel agency that is retrieving the rates
   * @return ownerIdentifier
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "owner-1", required = true, value = "A specific identifier for the company / corporation / travel agency that is retrieving the rates")
  @JsonProperty(JSON_PROPERTY_OWNER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getOwnerIdentifier() {
    return ownerIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_OWNER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setOwnerIdentifier(String ownerIdentifier) {
    this.ownerIdentifier = ownerIdentifier;
  }


  public SalesChannel ownerName(String ownerName) {
    
    this.ownerName = ownerName;
    return this;
  }

   /**
   * Name of the owner / affiliate. &#x60;Hotel booking engine&#x60; when it&#39;s the booking engine.
   * @return ownerName
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "Owner 1", required = true, value = "Name of the owner / affiliate. `Hotel booking engine` when it's the booking engine.")
  @JsonProperty(JSON_PROPERTY_OWNER_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getOwnerName() {
    return ownerName;
  }


  @JsonProperty(JSON_PROPERTY_OWNER_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setOwnerName(String ownerName) {
    this.ownerName = ownerName;
  }


  public SalesChannel enabled(Boolean enabled) {
    
    this.enabled = enabled;
    return this;
  }

   /**
   * Flag the supplier can use to enable / disable this channel
   * @return enabled
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "true", required = true, value = "Flag the supplier can use to enable / disable this channel")
  @JsonProperty(JSON_PROPERTY_ENABLED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getEnabled() {
    return enabled;
  }


  @JsonProperty(JSON_PROPERTY_ENABLED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setEnabled(Boolean enabled) {
    this.enabled = enabled;
  }


  public SalesChannel channelDisabled(Boolean channelDisabled) {
    
    this.channelDisabled = channelDisabled;
    return this;
  }

   /**
   * System override by payment to disable. E.g. Platform disables supplier.
   * @return channelDisabled
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "System override by payment to disable. E.g. Platform disables supplier.")
  @JsonProperty(JSON_PROPERTY_CHANNEL_DISABLED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getChannelDisabled() {
    return channelDisabled;
  }


  @JsonProperty(JSON_PROPERTY_CHANNEL_DISABLED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setChannelDisabled(Boolean channelDisabled) {
    this.channelDisabled = channelDisabled;
  }


  public SalesChannel blacklisted(Boolean blacklisted) {
    
    this.blacklisted = blacklisted;
    return this;
  }

   /**
   * A way to blacklist a specific channel a property doesn&#39;t want to send inventory to.
   * @return blacklisted
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(required = true, value = "A way to blacklist a specific channel a property doesn't want to send inventory to.")
  @JsonProperty(JSON_PROPERTY_BLACKLISTED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getBlacklisted() {
    return blacklisted;
  }


  @JsonProperty(JSON_PROPERTY_BLACKLISTED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setBlacklisted(Boolean blacklisted) {
    this.blacklisted = blacklisted;
  }


  public SalesChannel percentDiscount(Float percentDiscount) {
    
    this.percentDiscount = percentDiscount;
    return this;
  }

   /**
   * Percent discount on this channel and all its children [unless configured at the child level].
   * minimum: 0.0
   * maximum: 1.0
   * @return percentDiscount
  **/
  @javax.annotation.Nullable
 @DecimalMin("0.0") @DecimalMax("1.0")  @ApiModelProperty(example = "0.15", value = "Percent discount on this channel and all its children [unless configured at the child level].")
  @JsonProperty(JSON_PROPERTY_PERCENT_DISCOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getPercentDiscount() {
    return percentDiscount;
  }


  @JsonProperty(JSON_PROPERTY_PERCENT_DISCOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPercentDiscount(Float percentDiscount) {
    this.percentDiscount = percentDiscount;
  }


  public SalesChannel commission(Float commission) {
    
    this.commission = commission;
    return this;
  }

   /**
   * Amount of sales commission earned through this channel and all its children [unless configured at the child level].
   * minimum: 0.0
   * maximum: 1.0
   * @return commission
  **/
  @javax.annotation.Nullable
 @DecimalMin("0.0") @DecimalMax("1.0")  @ApiModelProperty(example = "0.2", value = "Amount of sales commission earned through this channel and all its children [unless configured at the child level].")
  @JsonProperty(JSON_PROPERTY_COMMISSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getCommission() {
    return commission;
  }


  @JsonProperty(JSON_PROPERTY_COMMISSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCommission(Float commission) {
    this.commission = commission;
  }


  public SalesChannel rateModifiers(List<RateModifier> rateModifiers) {
    
    this.rateModifiers = rateModifiers;
    return this;
  }

  public SalesChannel addRateModifiersItem(RateModifier rateModifiersItem) {
    if (this.rateModifiers == null) {
      this.rateModifiers = new ArrayList<>();
    }
    this.rateModifiers.add(rateModifiersItem);
    return this;
  }

   /**
   * Promotions for this channel
   * @return rateModifiers
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Promotions for this channel")
  @JsonProperty(JSON_PROPERTY_RATE_MODIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<RateModifier> getRateModifiers() {
    return rateModifiers;
  }


  @JsonProperty(JSON_PROPERTY_RATE_MODIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRateModifiers(List<RateModifier> rateModifiers) {
    this.rateModifiers = rateModifiers;
  }


  public SalesChannel rateModifierBundles(List<RateModifierBundle> rateModifierBundles) {
    
    this.rateModifierBundles = rateModifierBundles;
    return this;
  }

  public SalesChannel addRateModifierBundlesItem(RateModifierBundle rateModifierBundlesItem) {
    if (this.rateModifierBundles == null) {
      this.rateModifierBundles = new ArrayList<>();
    }
    this.rateModifierBundles.add(rateModifierBundlesItem);
    return this;
  }

   /**
   * Promotion bundles for this channel
   * @return rateModifierBundles
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Promotion bundles for this channel")
  @JsonProperty(JSON_PROPERTY_RATE_MODIFIER_BUNDLES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<RateModifierBundle> getRateModifierBundles() {
    return rateModifierBundles;
  }


  @JsonProperty(JSON_PROPERTY_RATE_MODIFIER_BUNDLES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRateModifierBundles(List<RateModifierBundle> rateModifierBundles) {
    this.rateModifierBundles = rateModifierBundles;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SalesChannel salesChannel = (SalesChannel) o;
    return Objects.equals(this.identifier, salesChannel.identifier) &&
        Objects.equals(this.supplierIdentifier, salesChannel.supplierIdentifier) &&
        Objects.equals(this.supplierName, salesChannel.supplierName) &&
        Objects.equals(this.supplierAvailable, salesChannel.supplierAvailable) &&
        Objects.equals(this.subType, salesChannel.subType) &&
        Objects.equals(this.ownerIdentifier, salesChannel.ownerIdentifier) &&
        Objects.equals(this.ownerName, salesChannel.ownerName) &&
        Objects.equals(this.enabled, salesChannel.enabled) &&
        Objects.equals(this.channelDisabled, salesChannel.channelDisabled) &&
        Objects.equals(this.blacklisted, salesChannel.blacklisted) &&
        Objects.equals(this.percentDiscount, salesChannel.percentDiscount) &&
        Objects.equals(this.commission, salesChannel.commission) &&
        Objects.equals(this.rateModifiers, salesChannel.rateModifiers) &&
        Objects.equals(this.rateModifierBundles, salesChannel.rateModifierBundles);
  }

  @Override
  public int hashCode() {
    return Objects.hash(identifier, supplierIdentifier, supplierName, supplierAvailable, subType, ownerIdentifier, ownerName, enabled, channelDisabled, blacklisted, percentDiscount, commission, rateModifiers, rateModifierBundles);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SalesChannel {\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    supplierIdentifier: ").append(toIndentedString(supplierIdentifier)).append("\n");
    sb.append("    supplierName: ").append(toIndentedString(supplierName)).append("\n");
    sb.append("    supplierAvailable: ").append(toIndentedString(supplierAvailable)).append("\n");
    sb.append("    subType: ").append(toIndentedString(subType)).append("\n");
    sb.append("    ownerIdentifier: ").append(toIndentedString(ownerIdentifier)).append("\n");
    sb.append("    ownerName: ").append(toIndentedString(ownerName)).append("\n");
    sb.append("    enabled: ").append(toIndentedString(enabled)).append("\n");
    sb.append("    channelDisabled: ").append(toIndentedString(channelDisabled)).append("\n");
    sb.append("    blacklisted: ").append(toIndentedString(blacklisted)).append("\n");
    sb.append("    percentDiscount: ").append(toIndentedString(percentDiscount)).append("\n");
    sb.append("    commission: ").append(toIndentedString(commission)).append("\n");
    sb.append("    rateModifiers: ").append(toIndentedString(rateModifiers)).append("\n");
    sb.append("    rateModifierBundles: ").append(toIndentedString(rateModifierBundles)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

