/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/docs?api=affiliate): All APIs related to selling travel inventory as an affiliate. - [Extranet](/docs?api=extranet): All APIs related to managing travel inventory and suppliers. - [Booking Engine](/docs?api=booking-engine): All APIs related to searching for travel inventory and creating bookings. - [Channel Manager](https://integration.wink.travel/docs?api=channel-manager): All APIs related to channel managers who want to integrate with our payment.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.payment-v`1`+json.  ## Release history - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Extranet API Welcome to the Extranet API - A programmer-friendly way to manage your travel inventory on the wink payment. This API offers a superset of the features you can find at [https://extranet.wink.travel](https://extranet.wink.travel) and gives you all the tools you need to ready your properties and inventory for sale across 10000s of our unique sales channels. What differentiates us from existing Extranets is 1. we make it available for everyone to use and 2. the care we take in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Content creators have the ability to make their inventory look great and be searchable in a wide variety of ways. You won't find properties with generic inventory, low resolution pictures and little ancillary content that can easily be found everywhere else on the internet.  # Integrations We have already integrated with the most well-known channel managers so you don't have to. Once your properties are set up, you can finish the setup by mapping your property to wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API. - Allotz - CloudBeds / MyAllocator - Comanche - d-edge - FastBooking - HotelLink - HoteliersGuru - Omnibees - RateGain - Rate Tiger - ResAvenue - Siteminder - Sabre SynXis - Travelclick - Yieldplanet  # Intended Audience Programmers are [most likely] a requirement to start integrating with wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible. - Hotel chains - Hotel brands - Travel tech companies - Destination sites - Integrators - Aggregators - Destination management companies - Travel agencies - OTAs  
 *
 * The version of the OpenAPI document: 20.3.2-SNAPSHOT
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.extranet.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import travel.wink.sdk.extranet.model.RateModifierBundleModifierOverride;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * UpsertRateModifierBundleRequest
 */
@JsonPropertyOrder({
  UpsertRateModifierBundleRequest.JSON_PROPERTY_NAME,
  UpsertRateModifierBundleRequest.JSON_PROPERTY_ENABLED,
  UpsertRateModifierBundleRequest.JSON_PROPERTY_ITEM_IDENTIFIERS,
  UpsertRateModifierBundleRequest.JSON_PROPERTY_MODIFIER_OVERRIDE,
  UpsertRateModifierBundleRequest.JSON_PROPERTY_TYPE,
  UpsertRateModifierBundleRequest.JSON_PROPERTY_PRICING_TYPE
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-06-29T13:20:57.452361+07:00[Asia/Bangkok]")
public class UpsertRateModifierBundleRequest {
  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_ENABLED = "enabled";
  private Boolean enabled = true;

  public static final String JSON_PROPERTY_ITEM_IDENTIFIERS = "itemIdentifiers";
  private List<String> itemIdentifiers = new ArrayList<>();

  public static final String JSON_PROPERTY_MODIFIER_OVERRIDE = "modifierOverride";
  private RateModifierBundleModifierOverride modifierOverride;

  /**
   * Required if manual override modifier is not null
   */
  public enum TypeEnum {
    PREMIUM("PREMIUM"),
    
    DISCOUNT("DISCOUNT");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  /**
   * Determines whether this discount should be applied per night, per stay or per person - per night; Required if amount override is not null
   */
  public enum PricingTypeEnum {
    HOUR("PER_HOUR"),
    
    PERSON_PER_HOUR("PER_PERSON_PER_HOUR"),
    
    STAY("PER_STAY"),
    
    PERSON("PER_PERSON"),
    
    NIGHT("PER_NIGHT"),
    
    PERSON_PER_NIGHT("PER_PERSON_PER_NIGHT"),
    
    PERSON_PER_STAY("PER_PERSON_PER_STAY"),
    
    USE("PER_USE");

    private String value;

    PricingTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PricingTypeEnum fromValue(String value) {
      for (PricingTypeEnum b : PricingTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PRICING_TYPE = "pricingType";
  private PricingTypeEnum pricingType;

  public UpsertRateModifierBundleRequest() { 
  }

  public UpsertRateModifierBundleRequest name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Internal name of promotion ancillary.
   * @return name
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "Early bird - Long Term", required = true, value = "Internal name of promotion ancillary.")
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(String name) {
    this.name = name;
  }


  public UpsertRateModifierBundleRequest enabled(Boolean enabled) {
    
    this.enabled = enabled;
    return this;
  }

   /**
   * Whether this promotion ancillary is enabled or not.
   * @return enabled
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "true", required = true, value = "Whether this promotion ancillary is enabled or not.")
  @JsonProperty(JSON_PROPERTY_ENABLED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getEnabled() {
    return enabled;
  }


  @JsonProperty(JSON_PROPERTY_ENABLED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setEnabled(Boolean enabled) {
    this.enabled = enabled;
  }


  public UpsertRateModifierBundleRequest itemIdentifiers(List<String> itemIdentifiers) {
    
    this.itemIdentifiers = itemIdentifiers;
    return this;
  }

  public UpsertRateModifierBundleRequest addItemIdentifiersItem(String itemIdentifiersItem) {
    this.itemIdentifiers.add(itemIdentifiersItem);
    return this;
  }

   /**
   * Promotion identifiers that go together to make up this ancillary.
   * @return itemIdentifiers
  **/
  @javax.annotation.Nonnull
  @NotNull
 @Size(min=2,max=2147483647)  @ApiModelProperty(example = "[\"rate-modifier-1\",\"rate-modifier-2\"]", required = true, value = "Promotion identifiers that go together to make up this ancillary.")
  @JsonProperty(JSON_PROPERTY_ITEM_IDENTIFIERS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<String> getItemIdentifiers() {
    return itemIdentifiers;
  }


  @JsonProperty(JSON_PROPERTY_ITEM_IDENTIFIERS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setItemIdentifiers(List<String> itemIdentifiers) {
    this.itemIdentifiers = itemIdentifiers;
  }


  public UpsertRateModifierBundleRequest modifierOverride(RateModifierBundleModifierOverride modifierOverride) {
    
    this.modifierOverride = modifierOverride;
    return this;
  }

   /**
   * Get modifierOverride
   * @return modifierOverride
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_MODIFIER_OVERRIDE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public RateModifierBundleModifierOverride getModifierOverride() {
    return modifierOverride;
  }


  @JsonProperty(JSON_PROPERTY_MODIFIER_OVERRIDE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setModifierOverride(RateModifierBundleModifierOverride modifierOverride) {
    this.modifierOverride = modifierOverride;
  }


  public UpsertRateModifierBundleRequest type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * Required if manual override modifier is not null
   * @return type
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "DISCOUNT", required = true, value = "Required if manual override modifier is not null")
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  public UpsertRateModifierBundleRequest pricingType(PricingTypeEnum pricingType) {
    
    this.pricingType = pricingType;
    return this;
  }

   /**
   * Determines whether this discount should be applied per night, per stay or per person - per night; Required if amount override is not null
   * @return pricingType
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(required = true, value = "Determines whether this discount should be applied per night, per stay or per person - per night; Required if amount override is not null")
  @JsonProperty(JSON_PROPERTY_PRICING_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public PricingTypeEnum getPricingType() {
    return pricingType;
  }


  @JsonProperty(JSON_PROPERTY_PRICING_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPricingType(PricingTypeEnum pricingType) {
    this.pricingType = pricingType;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UpsertRateModifierBundleRequest upsertRateModifierBundleRequest = (UpsertRateModifierBundleRequest) o;
    return Objects.equals(this.name, upsertRateModifierBundleRequest.name) &&
        Objects.equals(this.enabled, upsertRateModifierBundleRequest.enabled) &&
        Objects.equals(this.itemIdentifiers, upsertRateModifierBundleRequest.itemIdentifiers) &&
        Objects.equals(this.modifierOverride, upsertRateModifierBundleRequest.modifierOverride) &&
        Objects.equals(this.type, upsertRateModifierBundleRequest.type) &&
        Objects.equals(this.pricingType, upsertRateModifierBundleRequest.pricingType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, enabled, itemIdentifiers, modifierOverride, type, pricingType);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UpsertRateModifierBundleRequest {\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    enabled: ").append(toIndentedString(enabled)).append("\n");
    sb.append("    itemIdentifiers: ").append(toIndentedString(itemIdentifiers)).append("\n");
    sb.append("    modifierOverride: ").append(toIndentedString(modifierOverride)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    pricingType: ").append(toIndentedString(pricingType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

