package travel.wink.sdk.extranet.api;

import travel.wink.sdk.extranet.invoker.ApiClient;

import travel.wink.sdk.extranet.model.AddOnRemovableResponse;
import java.io.File;
import travel.wink.sdk.extranet.model.GenericErrorMessage;
import travel.wink.sdk.extranet.model.Multimedia;
import travel.wink.sdk.extranet.model.RemoveEntryResponse;
import travel.wink.sdk.extranet.model.ShowPropertyPolicy400Response;
import travel.wink.sdk.extranet.model.UpgradeView;
import travel.wink.sdk.extranet.model.UpsertAddOnRequest;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-07-03T20:10:33.906080+07:00[Asia/Bangkok]")
public class AddOnApi {
    private ApiClient apiClient;

    public AddOnApi() {
        this(new ApiClient());
    }

    @Autowired
    public AddOnApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Add Multimedia
     * Uploads a videos and/or images to an add-on identified by its identifier
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Add multimedia record to add-on record owned by this hotel identifier
     * @param addOnIdentifier Add multimedia record to add-on with this identifier
     * @param multimedia The multimedia parameter
     * @return UpgradeView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec addMultimediaRequestCreation(String hotelIdentifier, String addOnIdentifier, Multimedia multimedia) throws WebClientResponseException {
        Object postBody = multimedia;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling addMultimedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'addOnIdentifier' is set
        if (addOnIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'addOnIdentifier' when calling addMultimedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'multimedia' is set
        if (multimedia == null) {
            throw new WebClientResponseException("Missing the required parameter 'multimedia' when calling addMultimedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("addOnIdentifier", addOnIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<UpgradeView> localVarReturnType = new ParameterizedTypeReference<UpgradeView>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/upgrade/{addOnIdentifier}/multimedia", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Add Multimedia
     * Uploads a videos and/or images to an add-on identified by its identifier
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Add multimedia record to add-on record owned by this hotel identifier
     * @param addOnIdentifier Add multimedia record to add-on with this identifier
     * @param multimedia The multimedia parameter
     * @return UpgradeView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<UpgradeView> addMultimedia(String hotelIdentifier, String addOnIdentifier, Multimedia multimedia) throws WebClientResponseException {
        ParameterizedTypeReference<UpgradeView> localVarReturnType = new ParameterizedTypeReference<UpgradeView>() {};
        return addMultimediaRequestCreation(hotelIdentifier, addOnIdentifier, multimedia).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<UpgradeView>> addMultimediaWithHttpInfo(String hotelIdentifier, String addOnIdentifier, Multimedia multimedia) throws WebClientResponseException {
        ParameterizedTypeReference<UpgradeView> localVarReturnType = new ParameterizedTypeReference<UpgradeView>() {};
        return addMultimediaRequestCreation(hotelIdentifier, addOnIdentifier, multimedia).toEntity(localVarReturnType);
    }
    /**
     * Create Add-On
     * Create a new add-on.
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param hotelIdentifier Create a new add-on record owned by this hotel identifier
     * @param upsertAddOnRequest The upsertAddOnRequest parameter
     * @return UpgradeView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createAddOnRequestCreation(String hotelIdentifier, UpsertAddOnRequest upsertAddOnRequest) throws WebClientResponseException {
        Object postBody = upsertAddOnRequest;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling createAddOn", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertAddOnRequest' is set
        if (upsertAddOnRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertAddOnRequest' when calling createAddOn", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<UpgradeView> localVarReturnType = new ParameterizedTypeReference<UpgradeView>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/upgrade", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create Add-On
     * Create a new add-on.
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param hotelIdentifier Create a new add-on record owned by this hotel identifier
     * @param upsertAddOnRequest The upsertAddOnRequest parameter
     * @return UpgradeView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<UpgradeView> createAddOn(String hotelIdentifier, UpsertAddOnRequest upsertAddOnRequest) throws WebClientResponseException {
        ParameterizedTypeReference<UpgradeView> localVarReturnType = new ParameterizedTypeReference<UpgradeView>() {};
        return createAddOnRequestCreation(hotelIdentifier, upsertAddOnRequest).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<UpgradeView>> createAddOnWithHttpInfo(String hotelIdentifier, UpsertAddOnRequest upsertAddOnRequest) throws WebClientResponseException {
        ParameterizedTypeReference<UpgradeView> localVarReturnType = new ParameterizedTypeReference<UpgradeView>() {};
        return createAddOnRequestCreation(hotelIdentifier, upsertAddOnRequest).toEntity(localVarReturnType);
    }
    /**
     * Delete Add-On
     * Delete an add-on by its identifier
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Remove add-on record owned by this hotel identifier
     * @param addOnIdentifier Remove add-on record identified by this identifier
     * @param accept The accept parameter
     * @return RemoveEntryResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeAddOnRequestCreation(String hotelIdentifier, String addOnIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling removeAddOn", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'addOnIdentifier' is set
        if (addOnIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'addOnIdentifier' when calling removeAddOn", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("addOnIdentifier", addOnIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/upgrade/{addOnIdentifier}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete Add-On
     * Delete an add-on by its identifier
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Remove add-on record owned by this hotel identifier
     * @param addOnIdentifier Remove add-on record identified by this identifier
     * @param accept The accept parameter
     * @return RemoveEntryResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RemoveEntryResponse> removeAddOn(String hotelIdentifier, String addOnIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return removeAddOnRequestCreation(hotelIdentifier, addOnIdentifier, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<RemoveEntryResponse>> removeAddOnWithHttpInfo(String hotelIdentifier, String addOnIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return removeAddOnRequestCreation(hotelIdentifier, addOnIdentifier, accept).toEntity(localVarReturnType);
    }
    /**
     * Delete Multimedia
     * Remove media from an existing add-on.
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Remove a media record from an existing add-on owned by this hotel identifier.
     * @param addOnIdentifier Remove a media record from an existing add-on identified by this identifier.
     * @param multimediaIdentifier Remove a media record with this identifier
     * @param accept The accept parameter
     * @return UpgradeView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeMultimedia1RequestCreation(String hotelIdentifier, String addOnIdentifier, String multimediaIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling removeMultimedia1", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'addOnIdentifier' is set
        if (addOnIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'addOnIdentifier' when calling removeMultimedia1", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'multimediaIdentifier' is set
        if (multimediaIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'multimediaIdentifier' when calling removeMultimedia1", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("addOnIdentifier", addOnIdentifier);
        pathParams.put("multimediaIdentifier", multimediaIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<UpgradeView> localVarReturnType = new ParameterizedTypeReference<UpgradeView>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/upgrade/{addOnIdentifier}/multimedia/{multimediaIdentifier}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete Multimedia
     * Remove media from an existing add-on.
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Remove a media record from an existing add-on owned by this hotel identifier.
     * @param addOnIdentifier Remove a media record from an existing add-on identified by this identifier.
     * @param multimediaIdentifier Remove a media record with this identifier
     * @param accept The accept parameter
     * @return UpgradeView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<UpgradeView> removeMultimedia1(String hotelIdentifier, String addOnIdentifier, String multimediaIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<UpgradeView> localVarReturnType = new ParameterizedTypeReference<UpgradeView>() {};
        return removeMultimedia1RequestCreation(hotelIdentifier, addOnIdentifier, multimediaIdentifier, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<UpgradeView>> removeMultimedia1WithHttpInfo(String hotelIdentifier, String addOnIdentifier, String multimediaIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<UpgradeView> localVarReturnType = new ParameterizedTypeReference<UpgradeView>() {};
        return removeMultimedia1RequestCreation(hotelIdentifier, addOnIdentifier, multimediaIdentifier, accept).toEntity(localVarReturnType);
    }
    /**
     * Show Add-On
     * Retrieve an add-on by its identifier
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show single add-on owned by this hotel identifier
     * @param addOnIdentifier Show add-on record identified by this identifier
     * @param accept The accept parameter
     * @return UpgradeView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showAddOnRequestCreation(String hotelIdentifier, String addOnIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showAddOn", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'addOnIdentifier' is set
        if (addOnIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'addOnIdentifier' when calling showAddOn", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("addOnIdentifier", addOnIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<UpgradeView> localVarReturnType = new ParameterizedTypeReference<UpgradeView>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/upgrade/{addOnIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Add-On
     * Retrieve an add-on by its identifier
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show single add-on owned by this hotel identifier
     * @param addOnIdentifier Show add-on record identified by this identifier
     * @param accept The accept parameter
     * @return UpgradeView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<UpgradeView> showAddOn(String hotelIdentifier, String addOnIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<UpgradeView> localVarReturnType = new ParameterizedTypeReference<UpgradeView>() {};
        return showAddOnRequestCreation(hotelIdentifier, addOnIdentifier, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<UpgradeView>> showAddOnWithHttpInfo(String hotelIdentifier, String addOnIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<UpgradeView> localVarReturnType = new ParameterizedTypeReference<UpgradeView>() {};
        return showAddOnRequestCreation(hotelIdentifier, addOnIdentifier, accept).toEntity(localVarReturnType);
    }
    /**
     * Show Add-Ons
     * Retrieve a list of all add-ons for property.
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show add-ons owned by this hotel identifier
     * @param accept The accept parameter
     * @return List&lt;UpgradeView&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showAddOnsRequestCreation(String hotelIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showAddOns", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<UpgradeView> localVarReturnType = new ParameterizedTypeReference<UpgradeView>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/upgrade/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Add-Ons
     * Retrieve a list of all add-ons for property.
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show add-ons owned by this hotel identifier
     * @param accept The accept parameter
     * @return List&lt;UpgradeView&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<UpgradeView> showAddOns(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<UpgradeView> localVarReturnType = new ParameterizedTypeReference<UpgradeView>() {};
        return showAddOnsRequestCreation(hotelIdentifier, accept).bodyToFlux(localVarReturnType);
    }

    public Mono<ResponseEntity<List<UpgradeView>>> showAddOnsWithHttpInfo(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<UpgradeView> localVarReturnType = new ParameterizedTypeReference<UpgradeView>() {};
        return showAddOnsRequestCreation(hotelIdentifier, accept).toEntityList(localVarReturnType);
    }
    /**
     * Update Add-On
     * Update an existing add-on.
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update an existing add-on record owned by this hotel identifier
     * @param addOnIdentifier Update an existing add-on record identified by this identifier
     * @param upsertAddOnRequest The upsertAddOnRequest parameter
     * @return UpgradeView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateAddOnRequestCreation(String hotelIdentifier, String addOnIdentifier, UpsertAddOnRequest upsertAddOnRequest) throws WebClientResponseException {
        Object postBody = upsertAddOnRequest;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling updateAddOn", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'addOnIdentifier' is set
        if (addOnIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'addOnIdentifier' when calling updateAddOn", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertAddOnRequest' is set
        if (upsertAddOnRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertAddOnRequest' when calling updateAddOn", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("addOnIdentifier", addOnIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<UpgradeView> localVarReturnType = new ParameterizedTypeReference<UpgradeView>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/upgrade/{addOnIdentifier}", HttpMethod.PUT, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Add-On
     * Update an existing add-on.
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update an existing add-on record owned by this hotel identifier
     * @param addOnIdentifier Update an existing add-on record identified by this identifier
     * @param upsertAddOnRequest The upsertAddOnRequest parameter
     * @return UpgradeView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<UpgradeView> updateAddOn(String hotelIdentifier, String addOnIdentifier, UpsertAddOnRequest upsertAddOnRequest) throws WebClientResponseException {
        ParameterizedTypeReference<UpgradeView> localVarReturnType = new ParameterizedTypeReference<UpgradeView>() {};
        return updateAddOnRequestCreation(hotelIdentifier, addOnIdentifier, upsertAddOnRequest).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<UpgradeView>> updateAddOnWithHttpInfo(String hotelIdentifier, String addOnIdentifier, UpsertAddOnRequest upsertAddOnRequest) throws WebClientResponseException {
        ParameterizedTypeReference<UpgradeView> localVarReturnType = new ParameterizedTypeReference<UpgradeView>() {};
        return updateAddOnRequestCreation(hotelIdentifier, addOnIdentifier, upsertAddOnRequest).toEntity(localVarReturnType);
    }
    /**
     * Update Multimedia
     * Update media meta data for a specific package media entry.
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update existing multimedia record on add-on record owned by this hotel identifier
     * @param addOnIdentifier Update existing multimedia record on add-on with this identifier
     * @param multimediaIdentifier Update existing multimedia record with this identifier
     * @param multimedia The multimedia parameter
     * @return UpgradeView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateAddOnMultimediaRequestCreation(String hotelIdentifier, String addOnIdentifier, String multimediaIdentifier, Multimedia multimedia) throws WebClientResponseException {
        Object postBody = multimedia;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling updateAddOnMultimedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'addOnIdentifier' is set
        if (addOnIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'addOnIdentifier' when calling updateAddOnMultimedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'multimediaIdentifier' is set
        if (multimediaIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'multimediaIdentifier' when calling updateAddOnMultimedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'multimedia' is set
        if (multimedia == null) {
            throw new WebClientResponseException("Missing the required parameter 'multimedia' when calling updateAddOnMultimedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("addOnIdentifier", addOnIdentifier);
        pathParams.put("multimediaIdentifier", multimediaIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<UpgradeView> localVarReturnType = new ParameterizedTypeReference<UpgradeView>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/upgrade/{addOnIdentifier}/multimedia/{multimediaIdentifier}", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Multimedia
     * Update media meta data for a specific package media entry.
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update existing multimedia record on add-on record owned by this hotel identifier
     * @param addOnIdentifier Update existing multimedia record on add-on with this identifier
     * @param multimediaIdentifier Update existing multimedia record with this identifier
     * @param multimedia The multimedia parameter
     * @return UpgradeView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<UpgradeView> updateAddOnMultimedia(String hotelIdentifier, String addOnIdentifier, String multimediaIdentifier, Multimedia multimedia) throws WebClientResponseException {
        ParameterizedTypeReference<UpgradeView> localVarReturnType = new ParameterizedTypeReference<UpgradeView>() {};
        return updateAddOnMultimediaRequestCreation(hotelIdentifier, addOnIdentifier, multimediaIdentifier, multimedia).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<UpgradeView>> updateAddOnMultimediaWithHttpInfo(String hotelIdentifier, String addOnIdentifier, String multimediaIdentifier, Multimedia multimedia) throws WebClientResponseException {
        ParameterizedTypeReference<UpgradeView> localVarReturnType = new ParameterizedTypeReference<UpgradeView>() {};
        return updateAddOnMultimediaRequestCreation(hotelIdentifier, addOnIdentifier, multimediaIdentifier, multimedia).toEntity(localVarReturnType);
    }
    /**
     * Upload Binary Multimedia
     * Upload a list of binary / multipart videos and/or images to an existing add-on.
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>207</b> - Multi-Status
     * @param hotelIdentifier Upload multipart files and associate them with an existing add-on owned by this hotel identifier
     * @param addOnIdentifier Upload multipart files and associate them with an existing add-on with this identifier
     * @param files The files parameter
     * @return UpgradeView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec uploadBinaryAddOnMediaRequestCreation(String hotelIdentifier, String addOnIdentifier, List<File> files) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling uploadBinaryAddOnMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'addOnIdentifier' is set
        if (addOnIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'addOnIdentifier' when calling uploadBinaryAddOnMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'files' is set
        if (files == null) {
            throw new WebClientResponseException("Missing the required parameter 'files' when calling uploadBinaryAddOnMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("addOnIdentifier", addOnIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (files != null)
            formParams.addAll("files", files.stream().map(FileSystemResource::new).collect(Collectors.toList()));

        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "multipart/form-data"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<UpgradeView> localVarReturnType = new ParameterizedTypeReference<UpgradeView>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/upgrade/{addOnIdentifier}/multimedia", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Upload Binary Multimedia
     * Upload a list of binary / multipart videos and/or images to an existing add-on.
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>207</b> - Multi-Status
     * @param hotelIdentifier Upload multipart files and associate them with an existing add-on owned by this hotel identifier
     * @param addOnIdentifier Upload multipart files and associate them with an existing add-on with this identifier
     * @param files The files parameter
     * @return UpgradeView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<UpgradeView> uploadBinaryAddOnMedia(String hotelIdentifier, String addOnIdentifier, List<File> files) throws WebClientResponseException {
        ParameterizedTypeReference<UpgradeView> localVarReturnType = new ParameterizedTypeReference<UpgradeView>() {};
        return uploadBinaryAddOnMediaRequestCreation(hotelIdentifier, addOnIdentifier, files).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<UpgradeView>> uploadBinaryAddOnMediaWithHttpInfo(String hotelIdentifier, String addOnIdentifier, List<File> files) throws WebClientResponseException {
        ParameterizedTypeReference<UpgradeView> localVarReturnType = new ParameterizedTypeReference<UpgradeView>() {};
        return uploadBinaryAddOnMediaRequestCreation(hotelIdentifier, addOnIdentifier, files).toEntity(localVarReturnType);
    }
    /**
     * Verify Removable
     * Check if an add-on is removable. If an add-on is associated / linked with a promotion or rate plan, it cannot be removed until the associated entity removes it first.
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Add-on record is owned by this hotel identifier.
     * @param addOnIdentifier Add-on record is identified by this identifier.
     * @param accept The accept parameter
     * @return AddOnRemovableResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec verifyAddOnRemovableRequestCreation(String hotelIdentifier, String addOnIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling verifyAddOnRemovable", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'addOnIdentifier' is set
        if (addOnIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'addOnIdentifier' when calling verifyAddOnRemovable", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("addOnIdentifier", addOnIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<AddOnRemovableResponse> localVarReturnType = new ParameterizedTypeReference<AddOnRemovableResponse>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/upgrade/{addOnIdentifier}/removable", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Verify Removable
     * Check if an add-on is removable. If an add-on is associated / linked with a promotion or rate plan, it cannot be removed until the associated entity removes it first.
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Add-on record is owned by this hotel identifier.
     * @param addOnIdentifier Add-on record is identified by this identifier.
     * @param accept The accept parameter
     * @return AddOnRemovableResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<AddOnRemovableResponse> verifyAddOnRemovable(String hotelIdentifier, String addOnIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<AddOnRemovableResponse> localVarReturnType = new ParameterizedTypeReference<AddOnRemovableResponse>() {};
        return verifyAddOnRemovableRequestCreation(hotelIdentifier, addOnIdentifier, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<AddOnRemovableResponse>> verifyAddOnRemovableWithHttpInfo(String hotelIdentifier, String addOnIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<AddOnRemovableResponse> localVarReturnType = new ParameterizedTypeReference<AddOnRemovableResponse>() {};
        return verifyAddOnRemovableRequestCreation(hotelIdentifier, addOnIdentifier, accept).toEntity(localVarReturnType);
    }
}
