package travel.wink.sdk.extranet.api;

import travel.wink.sdk.extranet.invoker.ApiClient;

import travel.wink.sdk.extranet.model.ChartRequestView;
import travel.wink.sdk.extranet.model.ChartRequestWrapper;
import travel.wink.sdk.extranet.model.GenericErrorMessage;
import travel.wink.sdk.extranet.model.LineChart;
import travel.wink.sdk.extranet.model.RemoveEntryResponse;
import travel.wink.sdk.extranet.model.ShowPropertyPolicy400Response;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-07-21T13:34:57.633677+07:00[Asia/Bangkok]")
public class AnalyticsApi {
    private ApiClient apiClient;

    public AnalyticsApi() {
        this(new ApiClient());
    }

    @Autowired
    public AnalyticsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Create Chart
     * Creates a new chart request.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param chartRequestWrapper The chartRequestWrapper parameter
     * @return ChartRequestView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createChartRequestRequestCreation(ChartRequestWrapper chartRequestWrapper) throws WebClientResponseException {
        Object postBody = chartRequestWrapper;
        // verify the required parameter 'chartRequestWrapper' is set
        if (chartRequestWrapper == null) {
            throw new WebClientResponseException("Missing the required parameter 'chartRequestWrapper' when calling createChartRequest", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<ChartRequestView> localVarReturnType = new ParameterizedTypeReference<ChartRequestView>() {};
        return apiClient.invokeAPI("/api/analytics/chart", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create Chart
     * Creates a new chart request.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param chartRequestWrapper The chartRequestWrapper parameter
     * @return ChartRequestView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ChartRequestView> createChartRequest(ChartRequestWrapper chartRequestWrapper) throws WebClientResponseException {
        ParameterizedTypeReference<ChartRequestView> localVarReturnType = new ParameterizedTypeReference<ChartRequestView>() {};
        return createChartRequestRequestCreation(chartRequestWrapper).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<ChartRequestView>> createChartRequestWithHttpInfo(ChartRequestWrapper chartRequestWrapper) throws WebClientResponseException {
        ParameterizedTypeReference<ChartRequestView> localVarReturnType = new ParameterizedTypeReference<ChartRequestView>() {};
        return createChartRequestRequestCreation(chartRequestWrapper).toEntity(localVarReturnType);
    }
    /**
     * Remove Chart
     * Remove chart request for specific identifier.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param chartIdentifier Chart identifier
     * @param accept The accept parameter
     * @return RemoveEntryResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeChartRequestRequestCreation(String chartIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'chartIdentifier' is set
        if (chartIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'chartIdentifier' when calling removeChartRequest", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("chartIdentifier", chartIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return apiClient.invokeAPI("/api/analytics/chart/{chartIdentifier}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Remove Chart
     * Remove chart request for specific identifier.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param chartIdentifier Chart identifier
     * @param accept The accept parameter
     * @return RemoveEntryResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RemoveEntryResponse> removeChartRequest(String chartIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return removeChartRequestRequestCreation(chartIdentifier, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<RemoveEntryResponse>> removeChartRequestWithHttpInfo(String chartIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return removeChartRequestRequestCreation(chartIdentifier, accept).toEntity(localVarReturnType);
    }
    /**
     * Show Analytics
     * Show analytics the authenticated entity has previously created
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param accept The accept parameter
     * @return List&lt;LineChart&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showAnalyticsRequestCreation(String accept) throws WebClientResponseException {
        Object postBody = null;
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<LineChart> localVarReturnType = new ParameterizedTypeReference<LineChart>() {};
        return apiClient.invokeAPI("/api/analytics/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Analytics
     * Show analytics the authenticated entity has previously created
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param accept The accept parameter
     * @return List&lt;LineChart&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<LineChart> showAnalytics(String accept) throws WebClientResponseException {
        ParameterizedTypeReference<LineChart> localVarReturnType = new ParameterizedTypeReference<LineChart>() {};
        return showAnalyticsRequestCreation(accept).bodyToFlux(localVarReturnType);
    }

    public Mono<ResponseEntity<List<LineChart>>> showAnalyticsWithHttpInfo(String accept) throws WebClientResponseException {
        ParameterizedTypeReference<LineChart> localVarReturnType = new ParameterizedTypeReference<LineChart>() {};
        return showAnalyticsRequestCreation(accept).toEntityList(localVarReturnType);
    }
    /**
     * Show Chart
     * Displays a single chart request by identifier.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param chartIdentifier Chart identifier
     * @param accept The accept parameter
     * @return ChartRequestView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showChartRequestRequestCreation(String chartIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'chartIdentifier' is set
        if (chartIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'chartIdentifier' when calling showChartRequest", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("chartIdentifier", chartIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<ChartRequestView> localVarReturnType = new ParameterizedTypeReference<ChartRequestView>() {};
        return apiClient.invokeAPI("/api/analytics/chart/{chartIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Chart
     * Displays a single chart request by identifier.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param chartIdentifier Chart identifier
     * @param accept The accept parameter
     * @return ChartRequestView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ChartRequestView> showChartRequest(String chartIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<ChartRequestView> localVarReturnType = new ParameterizedTypeReference<ChartRequestView>() {};
        return showChartRequestRequestCreation(chartIdentifier, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<ChartRequestView>> showChartRequestWithHttpInfo(String chartIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<ChartRequestView> localVarReturnType = new ParameterizedTypeReference<ChartRequestView>() {};
        return showChartRequestRequestCreation(chartIdentifier, accept).toEntity(localVarReturnType);
    }
    /**
     * Show Charts
     * Displays all charts for caller.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param accept The accept parameter
     * @return List&lt;ChartRequestView&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showChartRequestsRequestCreation(String accept) throws WebClientResponseException {
        Object postBody = null;
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<ChartRequestView> localVarReturnType = new ParameterizedTypeReference<ChartRequestView>() {};
        return apiClient.invokeAPI("/api/analytics/chart/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Charts
     * Displays all charts for caller.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param accept The accept parameter
     * @return List&lt;ChartRequestView&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<ChartRequestView> showChartRequests(String accept) throws WebClientResponseException {
        ParameterizedTypeReference<ChartRequestView> localVarReturnType = new ParameterizedTypeReference<ChartRequestView>() {};
        return showChartRequestsRequestCreation(accept).bodyToFlux(localVarReturnType);
    }

    public Mono<ResponseEntity<List<ChartRequestView>>> showChartRequestsWithHttpInfo(String accept) throws WebClientResponseException {
        ParameterizedTypeReference<ChartRequestView> localVarReturnType = new ParameterizedTypeReference<ChartRequestView>() {};
        return showChartRequestsRequestCreation(accept).toEntityList(localVarReturnType);
    }
    /**
     * Update Chart
     * Updates an existing chart request by identifier.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param chartIdentifier Chart identifier
     * @param chartRequestWrapper The chartRequestWrapper parameter
     * @return ChartRequestView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateChartRequestRequestCreation(String chartIdentifier, ChartRequestWrapper chartRequestWrapper) throws WebClientResponseException {
        Object postBody = chartRequestWrapper;
        // verify the required parameter 'chartIdentifier' is set
        if (chartIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'chartIdentifier' when calling updateChartRequest", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'chartRequestWrapper' is set
        if (chartRequestWrapper == null) {
            throw new WebClientResponseException("Missing the required parameter 'chartRequestWrapper' when calling updateChartRequest", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("chartIdentifier", chartIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<ChartRequestView> localVarReturnType = new ParameterizedTypeReference<ChartRequestView>() {};
        return apiClient.invokeAPI("/api/analytics/chart/{chartIdentifier}", HttpMethod.PUT, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Chart
     * Updates an existing chart request by identifier.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param chartIdentifier Chart identifier
     * @param chartRequestWrapper The chartRequestWrapper parameter
     * @return ChartRequestView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ChartRequestView> updateChartRequest(String chartIdentifier, ChartRequestWrapper chartRequestWrapper) throws WebClientResponseException {
        ParameterizedTypeReference<ChartRequestView> localVarReturnType = new ParameterizedTypeReference<ChartRequestView>() {};
        return updateChartRequestRequestCreation(chartIdentifier, chartRequestWrapper).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<ChartRequestView>> updateChartRequestWithHttpInfo(String chartIdentifier, ChartRequestWrapper chartRequestWrapper) throws WebClientResponseException {
        ParameterizedTypeReference<ChartRequestView> localVarReturnType = new ParameterizedTypeReference<ChartRequestView>() {};
        return updateChartRequestRequestCreation(chartIdentifier, chartRequestWrapper).toEntity(localVarReturnType);
    }
}
