package travel.wink.sdk.extranet.api;

import travel.wink.sdk.extranet.invoker.ApiClient;

import java.io.File;
import travel.wink.sdk.extranet.model.GenericErrorMessage;
import travel.wink.sdk.extranet.model.GuestRoomRemovableResponse;
import travel.wink.sdk.extranet.model.GuestRoomView;
import travel.wink.sdk.extranet.model.RemoveEntryResponse;
import travel.wink.sdk.extranet.model.ShowPropertyPolicy400Response;
import travel.wink.sdk.extranet.model.UpsertGuestRoomRequest;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-07-21T13:34:57.633677+07:00[Asia/Bangkok]")
public class GuestRoomApi {
    private ApiClient apiClient;

    public GuestRoomApi() {
        this(new ApiClient());
    }

    @Autowired
    public GuestRoomApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Create Guest Room
     * create a new room type
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param hotelIdentifier Create room type owned by this hotel identifier
     * @param upsertGuestRoomRequest The upsertGuestRoomRequest parameter
     * @return GuestRoomView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createGuestRoomRequestCreation(String hotelIdentifier, UpsertGuestRoomRequest upsertGuestRoomRequest) throws WebClientResponseException {
        Object postBody = upsertGuestRoomRequest;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling createGuestRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertGuestRoomRequest' is set
        if (upsertGuestRoomRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertGuestRoomRequest' when calling createGuestRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<GuestRoomView> localVarReturnType = new ParameterizedTypeReference<GuestRoomView>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/room", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create Guest Room
     * create a new room type
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param hotelIdentifier Create room type owned by this hotel identifier
     * @param upsertGuestRoomRequest The upsertGuestRoomRequest parameter
     * @return GuestRoomView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<GuestRoomView> createGuestRoom(String hotelIdentifier, UpsertGuestRoomRequest upsertGuestRoomRequest) throws WebClientResponseException {
        ParameterizedTypeReference<GuestRoomView> localVarReturnType = new ParameterizedTypeReference<GuestRoomView>() {};
        return createGuestRoomRequestCreation(hotelIdentifier, upsertGuestRoomRequest).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<GuestRoomView>> createGuestRoomWithHttpInfo(String hotelIdentifier, UpsertGuestRoomRequest upsertGuestRoomRequest) throws WebClientResponseException {
        ParameterizedTypeReference<GuestRoomView> localVarReturnType = new ParameterizedTypeReference<GuestRoomView>() {};
        return createGuestRoomRequestCreation(hotelIdentifier, upsertGuestRoomRequest).toEntity(localVarReturnType);
    }
    /**
     * Duplicate Guest Room
     * Create a new duplicate of a room by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param hotelIdentifier Duplicate room type owned by this hotel identifier
     * @param guestRoomIdentifier Duplicate room type with this identifier
     * @return GuestRoomView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec duplicateGuestRoomRequestCreation(String hotelIdentifier, String guestRoomIdentifier) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling duplicateGuestRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'guestRoomIdentifier' is set
        if (guestRoomIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'guestRoomIdentifier' when calling duplicateGuestRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("guestRoomIdentifier", guestRoomIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<GuestRoomView> localVarReturnType = new ParameterizedTypeReference<GuestRoomView>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/room/{guestRoomIdentifier}/duplicate", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Duplicate Guest Room
     * Create a new duplicate of a room by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param hotelIdentifier Duplicate room type owned by this hotel identifier
     * @param guestRoomIdentifier Duplicate room type with this identifier
     * @return GuestRoomView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<GuestRoomView> duplicateGuestRoom(String hotelIdentifier, String guestRoomIdentifier) throws WebClientResponseException {
        ParameterizedTypeReference<GuestRoomView> localVarReturnType = new ParameterizedTypeReference<GuestRoomView>() {};
        return duplicateGuestRoomRequestCreation(hotelIdentifier, guestRoomIdentifier).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<GuestRoomView>> duplicateGuestRoomWithHttpInfo(String hotelIdentifier, String guestRoomIdentifier) throws WebClientResponseException {
        ParameterizedTypeReference<GuestRoomView> localVarReturnType = new ParameterizedTypeReference<GuestRoomView>() {};
        return duplicateGuestRoomRequestCreation(hotelIdentifier, guestRoomIdentifier).toEntity(localVarReturnType);
    }
    /**
     * Show Guest Room is Removable
     * Check if a room is removable by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Verify if room type owned by this hotel identifier is removable
     * @param guestRoomIdentifier Verify if room type with this identifier is removable
     * @param accept The accept parameter
     * @return GuestRoomRemovableResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removableGuestRoomRequestCreation(String hotelIdentifier, String guestRoomIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling removableGuestRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'guestRoomIdentifier' is set
        if (guestRoomIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'guestRoomIdentifier' when calling removableGuestRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("guestRoomIdentifier", guestRoomIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<GuestRoomRemovableResponse> localVarReturnType = new ParameterizedTypeReference<GuestRoomRemovableResponse>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/room/{guestRoomIdentifier}/removable", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Guest Room is Removable
     * Check if a room is removable by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Verify if room type owned by this hotel identifier is removable
     * @param guestRoomIdentifier Verify if room type with this identifier is removable
     * @param accept The accept parameter
     * @return GuestRoomRemovableResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<GuestRoomRemovableResponse> removableGuestRoom(String hotelIdentifier, String guestRoomIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<GuestRoomRemovableResponse> localVarReturnType = new ParameterizedTypeReference<GuestRoomRemovableResponse>() {};
        return removableGuestRoomRequestCreation(hotelIdentifier, guestRoomIdentifier, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<GuestRoomRemovableResponse>> removableGuestRoomWithHttpInfo(String hotelIdentifier, String guestRoomIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<GuestRoomRemovableResponse> localVarReturnType = new ParameterizedTypeReference<GuestRoomRemovableResponse>() {};
        return removableGuestRoomRequestCreation(hotelIdentifier, guestRoomIdentifier, accept).toEntity(localVarReturnType);
    }
    /**
     * Delete Guest Room
     * Remove a room by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Remove room type owned by this hotel identifier
     * @param guestRoomIdentifier Remove room type with this identifier
     * @param accept The accept parameter
     * @return RemoveEntryResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeGuestRoomRequestCreation(String hotelIdentifier, String guestRoomIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling removeGuestRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'guestRoomIdentifier' is set
        if (guestRoomIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'guestRoomIdentifier' when calling removeGuestRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("guestRoomIdentifier", guestRoomIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/room/{guestRoomIdentifier}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete Guest Room
     * Remove a room by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Remove room type owned by this hotel identifier
     * @param guestRoomIdentifier Remove room type with this identifier
     * @param accept The accept parameter
     * @return RemoveEntryResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RemoveEntryResponse> removeGuestRoom(String hotelIdentifier, String guestRoomIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return removeGuestRoomRequestCreation(hotelIdentifier, guestRoomIdentifier, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<RemoveEntryResponse>> removeGuestRoomWithHttpInfo(String hotelIdentifier, String guestRoomIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return removeGuestRoomRequestCreation(hotelIdentifier, guestRoomIdentifier, accept).toEntity(localVarReturnType);
    }
    /**
     * Delete Guest Room&#39;s Multimedia
     * Remove a room&#39;s video or image by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Remove room type media owned by this hotel identifier
     * @param guestRoomIdentifier Remove room type media with this identifier
     * @param multimediaIdentifier Remove media with this identifier
     * @param accept The accept parameter
     * @return GuestRoomView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeMultimedia2RequestCreation(String hotelIdentifier, String guestRoomIdentifier, String multimediaIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling removeMultimedia2", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'guestRoomIdentifier' is set
        if (guestRoomIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'guestRoomIdentifier' when calling removeMultimedia2", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'multimediaIdentifier' is set
        if (multimediaIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'multimediaIdentifier' when calling removeMultimedia2", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("guestRoomIdentifier", guestRoomIdentifier);
        pathParams.put("multimediaIdentifier", multimediaIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<GuestRoomView> localVarReturnType = new ParameterizedTypeReference<GuestRoomView>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/room/{guestRoomIdentifier}/multimedia/{multimediaIdentifier}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete Guest Room&#39;s Multimedia
     * Remove a room&#39;s video or image by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Remove room type media owned by this hotel identifier
     * @param guestRoomIdentifier Remove room type media with this identifier
     * @param multimediaIdentifier Remove media with this identifier
     * @param accept The accept parameter
     * @return GuestRoomView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<GuestRoomView> removeMultimedia2(String hotelIdentifier, String guestRoomIdentifier, String multimediaIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<GuestRoomView> localVarReturnType = new ParameterizedTypeReference<GuestRoomView>() {};
        return removeMultimedia2RequestCreation(hotelIdentifier, guestRoomIdentifier, multimediaIdentifier, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<GuestRoomView>> removeMultimedia2WithHttpInfo(String hotelIdentifier, String guestRoomIdentifier, String multimediaIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<GuestRoomView> localVarReturnType = new ParameterizedTypeReference<GuestRoomView>() {};
        return removeMultimedia2RequestCreation(hotelIdentifier, guestRoomIdentifier, multimediaIdentifier, accept).toEntity(localVarReturnType);
    }
    /**
     * Show Guest Room
     * Retrieve a room type by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show room type owned by this hotel identifier
     * @param guestRoomIdentifier Show room type identified by this identifier
     * @param accept The accept parameter
     * @return GuestRoomView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showGuestRoomRequestCreation(String hotelIdentifier, String guestRoomIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showGuestRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'guestRoomIdentifier' is set
        if (guestRoomIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'guestRoomIdentifier' when calling showGuestRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("guestRoomIdentifier", guestRoomIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<GuestRoomView> localVarReturnType = new ParameterizedTypeReference<GuestRoomView>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/room/{guestRoomIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Guest Room
     * Retrieve a room type by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show room type owned by this hotel identifier
     * @param guestRoomIdentifier Show room type identified by this identifier
     * @param accept The accept parameter
     * @return GuestRoomView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<GuestRoomView> showGuestRoom(String hotelIdentifier, String guestRoomIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<GuestRoomView> localVarReturnType = new ParameterizedTypeReference<GuestRoomView>() {};
        return showGuestRoomRequestCreation(hotelIdentifier, guestRoomIdentifier, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<GuestRoomView>> showGuestRoomWithHttpInfo(String hotelIdentifier, String guestRoomIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<GuestRoomView> localVarReturnType = new ParameterizedTypeReference<GuestRoomView>() {};
        return showGuestRoomRequestCreation(hotelIdentifier, guestRoomIdentifier, accept).toEntity(localVarReturnType);
    }
    /**
     * Show Guest Rooms
     * Retrieve list of rooms
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show list of room types owned by this hotel identifier
     * @param accept The accept parameter
     * @return List&lt;GuestRoomView&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showGuestRoomsRequestCreation(String hotelIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showGuestRooms", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<GuestRoomView> localVarReturnType = new ParameterizedTypeReference<GuestRoomView>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/room/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Guest Rooms
     * Retrieve list of rooms
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show list of room types owned by this hotel identifier
     * @param accept The accept parameter
     * @return List&lt;GuestRoomView&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<GuestRoomView> showGuestRooms(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<GuestRoomView> localVarReturnType = new ParameterizedTypeReference<GuestRoomView>() {};
        return showGuestRoomsRequestCreation(hotelIdentifier, accept).bodyToFlux(localVarReturnType);
    }

    public Mono<ResponseEntity<List<GuestRoomView>>> showGuestRoomsWithHttpInfo(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<GuestRoomView> localVarReturnType = new ParameterizedTypeReference<GuestRoomView>() {};
        return showGuestRoomsRequestCreation(hotelIdentifier, accept).toEntityList(localVarReturnType);
    }
    /**
     * Update Guest Room
     * Update a room by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update room type owned by this hotel identifier
     * @param guestRoomIdentifier Update room type with this identifier
     * @param upsertGuestRoomRequest The upsertGuestRoomRequest parameter
     * @return GuestRoomView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateGuestRoomRequestCreation(String hotelIdentifier, String guestRoomIdentifier, UpsertGuestRoomRequest upsertGuestRoomRequest) throws WebClientResponseException {
        Object postBody = upsertGuestRoomRequest;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling updateGuestRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'guestRoomIdentifier' is set
        if (guestRoomIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'guestRoomIdentifier' when calling updateGuestRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertGuestRoomRequest' is set
        if (upsertGuestRoomRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertGuestRoomRequest' when calling updateGuestRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("guestRoomIdentifier", guestRoomIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<GuestRoomView> localVarReturnType = new ParameterizedTypeReference<GuestRoomView>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/room/{guestRoomIdentifier}", HttpMethod.PUT, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Guest Room
     * Update a room by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update room type owned by this hotel identifier
     * @param guestRoomIdentifier Update room type with this identifier
     * @param upsertGuestRoomRequest The upsertGuestRoomRequest parameter
     * @return GuestRoomView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<GuestRoomView> updateGuestRoom(String hotelIdentifier, String guestRoomIdentifier, UpsertGuestRoomRequest upsertGuestRoomRequest) throws WebClientResponseException {
        ParameterizedTypeReference<GuestRoomView> localVarReturnType = new ParameterizedTypeReference<GuestRoomView>() {};
        return updateGuestRoomRequestCreation(hotelIdentifier, guestRoomIdentifier, upsertGuestRoomRequest).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<GuestRoomView>> updateGuestRoomWithHttpInfo(String hotelIdentifier, String guestRoomIdentifier, UpsertGuestRoomRequest upsertGuestRoomRequest) throws WebClientResponseException {
        ParameterizedTypeReference<GuestRoomView> localVarReturnType = new ParameterizedTypeReference<GuestRoomView>() {};
        return updateGuestRoomRequestCreation(hotelIdentifier, guestRoomIdentifier, upsertGuestRoomRequest).toEntity(localVarReturnType);
    }
    /**
     * Add Multimedia to Room
     * Uploads a videos and/or images to a room identified by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>207</b> - Multi-Status
     * @param hotelIdentifier Upload media for room type owned by this hotel identifier
     * @param guestRoomIdentifier Upload media for room type with this identifier
     * @param files The files parameter
     * @return GuestRoomView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec uploadGuestRoomMediaRequestCreation(String hotelIdentifier, String guestRoomIdentifier, List<File> files) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling uploadGuestRoomMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'guestRoomIdentifier' is set
        if (guestRoomIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'guestRoomIdentifier' when calling uploadGuestRoomMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'files' is set
        if (files == null) {
            throw new WebClientResponseException("Missing the required parameter 'files' when calling uploadGuestRoomMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("guestRoomIdentifier", guestRoomIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (files != null)
            formParams.addAll("files", files.stream().map(FileSystemResource::new).collect(Collectors.toList()));

        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "multipart/form-data"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<GuestRoomView> localVarReturnType = new ParameterizedTypeReference<GuestRoomView>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/room/{guestRoomIdentifier}/multimedia", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Add Multimedia to Room
     * Uploads a videos and/or images to a room identified by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>207</b> - Multi-Status
     * @param hotelIdentifier Upload media for room type owned by this hotel identifier
     * @param guestRoomIdentifier Upload media for room type with this identifier
     * @param files The files parameter
     * @return GuestRoomView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<GuestRoomView> uploadGuestRoomMedia(String hotelIdentifier, String guestRoomIdentifier, List<File> files) throws WebClientResponseException {
        ParameterizedTypeReference<GuestRoomView> localVarReturnType = new ParameterizedTypeReference<GuestRoomView>() {};
        return uploadGuestRoomMediaRequestCreation(hotelIdentifier, guestRoomIdentifier, files).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<GuestRoomView>> uploadGuestRoomMediaWithHttpInfo(String hotelIdentifier, String guestRoomIdentifier, List<File> files) throws WebClientResponseException {
        ParameterizedTypeReference<GuestRoomView> localVarReturnType = new ParameterizedTypeReference<GuestRoomView>() {};
        return uploadGuestRoomMediaRequestCreation(hotelIdentifier, guestRoomIdentifier, files).toEntity(localVarReturnType);
    }
}
