package travel.wink.sdk.extranet.api;

import travel.wink.sdk.extranet.invoker.ApiClient;

import travel.wink.sdk.extranet.model.GenericErrorMessage;
import travel.wink.sdk.extranet.model.HotelView;
import travel.wink.sdk.extranet.model.ShowPropertyPolicy400Response;
import travel.wink.sdk.extranet.model.UniqueResult;
import travel.wink.sdk.extranet.model.UpdateExternalHotelStatusRequest;
import travel.wink.sdk.extranet.model.UpdatePropertyAmenitiesAndServicesRequest;
import travel.wink.sdk.extranet.model.UpsertGeneralManagerRequest;
import travel.wink.sdk.extranet.model.UpsertPropertyDescriptionsRequest;
import travel.wink.sdk.extranet.model.UpsertPropertyProfileRequest;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-07-21T13:34:57.633677+07:00[Asia/Bangkok]")
public class PropertyApi {
    private ApiClient apiClient;

    public PropertyApi() {
        this(new ApiClient());
    }

    @Autowired
    public PropertyApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Check hotel name uniqueness
     * Check if hotel name is a unique.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param key Search for uniqueness for this hotel name.
     * @param hotelIdentifier Optional, existing hotel identifier
     * @param accept The accept parameter
     * @return UniqueResult
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec isHotelNameUniqueRequestCreation(String key, String hotelIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'key' is set
        if (key == null) {
            throw new WebClientResponseException("Missing the required parameter 'key' when calling isHotelNameUnique", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "key", key));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "hotelIdentifier", hotelIdentifier));

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<UniqueResult> localVarReturnType = new ParameterizedTypeReference<UniqueResult>() {};
        return apiClient.invokeAPI("/api/hotel/uniquename", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Check hotel name uniqueness
     * Check if hotel name is a unique.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param key Search for uniqueness for this hotel name.
     * @param hotelIdentifier Optional, existing hotel identifier
     * @param accept The accept parameter
     * @return UniqueResult
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<UniqueResult> isHotelNameUnique(String key, String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<UniqueResult> localVarReturnType = new ParameterizedTypeReference<UniqueResult>() {};
        return isHotelNameUniqueRequestCreation(key, hotelIdentifier, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<UniqueResult>> isHotelNameUniqueWithHttpInfo(String key, String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<UniqueResult> localVarReturnType = new ParameterizedTypeReference<UniqueResult>() {};
        return isHotelNameUniqueRequestCreation(key, hotelIdentifier, accept).toEntity(localVarReturnType);
    }
    /**
     * Show hotel
     * Retrieve hotel by hotel identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Retrieve property record for this hotel identifier
     * @param accept The accept parameter
     * @return HotelView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showHotelByManagerRequestCreation(String hotelIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showHotelByManager", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<HotelView> localVarReturnType = new ParameterizedTypeReference<HotelView>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show hotel
     * Retrieve hotel by hotel identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Retrieve property record for this hotel identifier
     * @param accept The accept parameter
     * @return HotelView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<HotelView> showHotelByManager(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<HotelView> localVarReturnType = new ParameterizedTypeReference<HotelView>() {};
        return showHotelByManagerRequestCreation(hotelIdentifier, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<HotelView>> showHotelByManagerWithHttpInfo(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<HotelView> localVarReturnType = new ParameterizedTypeReference<HotelView>() {};
        return showHotelByManagerRequestCreation(hotelIdentifier, accept).toEntity(localVarReturnType);
    }
    /**
     * Show hotel status
     * Retrieve hotel status
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show property status for this hotel identifier
     * @param accept The accept parameter
     * @return UpdateExternalHotelStatusRequest
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showHotelStatusRequestCreation(String hotelIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showHotelStatus", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<UpdateExternalHotelStatusRequest> localVarReturnType = new ParameterizedTypeReference<UpdateExternalHotelStatusRequest>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/status", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show hotel status
     * Retrieve hotel status
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show property status for this hotel identifier
     * @param accept The accept parameter
     * @return UpdateExternalHotelStatusRequest
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<UpdateExternalHotelStatusRequest> showHotelStatus(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<UpdateExternalHotelStatusRequest> localVarReturnType = new ParameterizedTypeReference<UpdateExternalHotelStatusRequest>() {};
        return showHotelStatusRequestCreation(hotelIdentifier, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<UpdateExternalHotelStatusRequest>> showHotelStatusWithHttpInfo(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<UpdateExternalHotelStatusRequest> localVarReturnType = new ParameterizedTypeReference<UpdateExternalHotelStatusRequest>() {};
        return showHotelStatusRequestCreation(hotelIdentifier, accept).toEntity(localVarReturnType);
    }
    /**
     * Show hotels
     * Retrieve a list of all your hotels
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param accept The accept parameter
     * @return List&lt;HotelView&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showHotelsByManagerRequestCreation(String accept) throws WebClientResponseException {
        Object postBody = null;
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<HotelView> localVarReturnType = new ParameterizedTypeReference<HotelView>() {};
        return apiClient.invokeAPI("/api/hotel/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show hotels
     * Retrieve a list of all your hotels
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param accept The accept parameter
     * @return List&lt;HotelView&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<HotelView> showHotelsByManager(String accept) throws WebClientResponseException {
        ParameterizedTypeReference<HotelView> localVarReturnType = new ParameterizedTypeReference<HotelView>() {};
        return showHotelsByManagerRequestCreation(accept).bodyToFlux(localVarReturnType);
    }

    public Mono<ResponseEntity<List<HotelView>>> showHotelsByManagerWithHttpInfo(String accept) throws WebClientResponseException {
        ParameterizedTypeReference<HotelView> localVarReturnType = new ParameterizedTypeReference<HotelView>() {};
        return showHotelsByManagerRequestCreation(accept).toEntityList(localVarReturnType);
    }
    /**
     * Update General Manager
     * Update general manager information
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update basic information for this hotel identifier
     * @param upsertGeneralManagerRequest The upsertGeneralManagerRequest parameter
     * @return HotelView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateGeneralManagerRequestCreation(String hotelIdentifier, UpsertGeneralManagerRequest upsertGeneralManagerRequest) throws WebClientResponseException {
        Object postBody = upsertGeneralManagerRequest;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling updateGeneralManager", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertGeneralManagerRequest' is set
        if (upsertGeneralManagerRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertGeneralManagerRequest' when calling updateGeneralManager", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<HotelView> localVarReturnType = new ParameterizedTypeReference<HotelView>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/generalmanager", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update General Manager
     * Update general manager information
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update basic information for this hotel identifier
     * @param upsertGeneralManagerRequest The upsertGeneralManagerRequest parameter
     * @return HotelView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<HotelView> updateGeneralManager(String hotelIdentifier, UpsertGeneralManagerRequest upsertGeneralManagerRequest) throws WebClientResponseException {
        ParameterizedTypeReference<HotelView> localVarReturnType = new ParameterizedTypeReference<HotelView>() {};
        return updateGeneralManagerRequestCreation(hotelIdentifier, upsertGeneralManagerRequest).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<HotelView>> updateGeneralManagerWithHttpInfo(String hotelIdentifier, UpsertGeneralManagerRequest upsertGeneralManagerRequest) throws WebClientResponseException {
        ParameterizedTypeReference<HotelView> localVarReturnType = new ParameterizedTypeReference<HotelView>() {};
        return updateGeneralManagerRequestCreation(hotelIdentifier, upsertGeneralManagerRequest).toEntity(localVarReturnType);
    }
    /**
     * Update hotel status
     * Update hotel status
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Change status for this hotel identifier
     * @param updateExternalHotelStatusRequest The updateExternalHotelStatusRequest parameter
     * @return HotelView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateHotelStatusRequestCreation(String hotelIdentifier, UpdateExternalHotelStatusRequest updateExternalHotelStatusRequest) throws WebClientResponseException {
        Object postBody = updateExternalHotelStatusRequest;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling updateHotelStatus", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'updateExternalHotelStatusRequest' is set
        if (updateExternalHotelStatusRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'updateExternalHotelStatusRequest' when calling updateHotelStatus", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<HotelView> localVarReturnType = new ParameterizedTypeReference<HotelView>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/status", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update hotel status
     * Update hotel status
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Change status for this hotel identifier
     * @param updateExternalHotelStatusRequest The updateExternalHotelStatusRequest parameter
     * @return HotelView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<HotelView> updateHotelStatus(String hotelIdentifier, UpdateExternalHotelStatusRequest updateExternalHotelStatusRequest) throws WebClientResponseException {
        ParameterizedTypeReference<HotelView> localVarReturnType = new ParameterizedTypeReference<HotelView>() {};
        return updateHotelStatusRequestCreation(hotelIdentifier, updateExternalHotelStatusRequest).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<HotelView>> updateHotelStatusWithHttpInfo(String hotelIdentifier, UpdateExternalHotelStatusRequest updateExternalHotelStatusRequest) throws WebClientResponseException {
        ParameterizedTypeReference<HotelView> localVarReturnType = new ParameterizedTypeReference<HotelView>() {};
        return updateHotelStatusRequestCreation(hotelIdentifier, updateExternalHotelStatusRequest).toEntity(localVarReturnType);
    }
    /**
     * Update property text
     * Update localized welcome text
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update basic information for this hotel identifier
     * @param upsertPropertyDescriptionsRequest The upsertPropertyDescriptionsRequest parameter
     * @return HotelView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateLocalizedDescriptionsRequestCreation(String hotelIdentifier, UpsertPropertyDescriptionsRequest upsertPropertyDescriptionsRequest) throws WebClientResponseException {
        Object postBody = upsertPropertyDescriptionsRequest;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling updateLocalizedDescriptions", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertPropertyDescriptionsRequest' is set
        if (upsertPropertyDescriptionsRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertPropertyDescriptionsRequest' when calling updateLocalizedDescriptions", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<HotelView> localVarReturnType = new ParameterizedTypeReference<HotelView>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/descriptions", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update property text
     * Update localized welcome text
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update basic information for this hotel identifier
     * @param upsertPropertyDescriptionsRequest The upsertPropertyDescriptionsRequest parameter
     * @return HotelView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<HotelView> updateLocalizedDescriptions(String hotelIdentifier, UpsertPropertyDescriptionsRequest upsertPropertyDescriptionsRequest) throws WebClientResponseException {
        ParameterizedTypeReference<HotelView> localVarReturnType = new ParameterizedTypeReference<HotelView>() {};
        return updateLocalizedDescriptionsRequestCreation(hotelIdentifier, upsertPropertyDescriptionsRequest).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<HotelView>> updateLocalizedDescriptionsWithHttpInfo(String hotelIdentifier, UpsertPropertyDescriptionsRequest upsertPropertyDescriptionsRequest) throws WebClientResponseException {
        ParameterizedTypeReference<HotelView> localVarReturnType = new ParameterizedTypeReference<HotelView>() {};
        return updateLocalizedDescriptionsRequestCreation(hotelIdentifier, upsertPropertyDescriptionsRequest).toEntity(localVarReturnType);
    }
    /**
     * Update property profile
     * Update basic property information
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update basic information for this hotel identifier
     * @param upsertPropertyProfileRequest The upsertPropertyProfileRequest parameter
     * @return HotelView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updatePropertyProfileRequestCreation(String hotelIdentifier, UpsertPropertyProfileRequest upsertPropertyProfileRequest) throws WebClientResponseException {
        Object postBody = upsertPropertyProfileRequest;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling updatePropertyProfile", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertPropertyProfileRequest' is set
        if (upsertPropertyProfileRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertPropertyProfileRequest' when calling updatePropertyProfile", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<HotelView> localVarReturnType = new ParameterizedTypeReference<HotelView>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/profile", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update property profile
     * Update basic property information
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update basic information for this hotel identifier
     * @param upsertPropertyProfileRequest The upsertPropertyProfileRequest parameter
     * @return HotelView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<HotelView> updatePropertyProfile(String hotelIdentifier, UpsertPropertyProfileRequest upsertPropertyProfileRequest) throws WebClientResponseException {
        ParameterizedTypeReference<HotelView> localVarReturnType = new ParameterizedTypeReference<HotelView>() {};
        return updatePropertyProfileRequestCreation(hotelIdentifier, upsertPropertyProfileRequest).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<HotelView>> updatePropertyProfileWithHttpInfo(String hotelIdentifier, UpsertPropertyProfileRequest upsertPropertyProfileRequest) throws WebClientResponseException {
        ParameterizedTypeReference<HotelView> localVarReturnType = new ParameterizedTypeReference<HotelView>() {};
        return updatePropertyProfileRequestCreation(hotelIdentifier, upsertPropertyProfileRequest).toEntity(localVarReturnType);
    }
    /**
     * Update property services
     * Manage property amenity, accessibility and security features.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Set amenities for this hotel identifier
     * @param updatePropertyAmenitiesAndServicesRequest The updatePropertyAmenitiesAndServicesRequest parameter
     * @return HotelView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateServicesRequestCreation(String hotelIdentifier, UpdatePropertyAmenitiesAndServicesRequest updatePropertyAmenitiesAndServicesRequest) throws WebClientResponseException {
        Object postBody = updatePropertyAmenitiesAndServicesRequest;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling updateServices", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'updatePropertyAmenitiesAndServicesRequest' is set
        if (updatePropertyAmenitiesAndServicesRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'updatePropertyAmenitiesAndServicesRequest' when calling updateServices", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<HotelView> localVarReturnType = new ParameterizedTypeReference<HotelView>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/services", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update property services
     * Manage property amenity, accessibility and security features.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Set amenities for this hotel identifier
     * @param updatePropertyAmenitiesAndServicesRequest The updatePropertyAmenitiesAndServicesRequest parameter
     * @return HotelView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<HotelView> updateServices(String hotelIdentifier, UpdatePropertyAmenitiesAndServicesRequest updatePropertyAmenitiesAndServicesRequest) throws WebClientResponseException {
        ParameterizedTypeReference<HotelView> localVarReturnType = new ParameterizedTypeReference<HotelView>() {};
        return updateServicesRequestCreation(hotelIdentifier, updatePropertyAmenitiesAndServicesRequest).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<HotelView>> updateServicesWithHttpInfo(String hotelIdentifier, UpdatePropertyAmenitiesAndServicesRequest updatePropertyAmenitiesAndServicesRequest) throws WebClientResponseException {
        ParameterizedTypeReference<HotelView> localVarReturnType = new ParameterizedTypeReference<HotelView>() {};
        return updateServicesRequestCreation(hotelIdentifier, updatePropertyAmenitiesAndServicesRequest).toEntity(localVarReturnType);
    }
}
