package travel.wink.sdk.extranet.api;

import travel.wink.sdk.extranet.invoker.ApiClient;

import travel.wink.sdk.extranet.model.GenericErrorMessage;
import travel.wink.sdk.extranet.model.RatePlanRemovableResponse;
import travel.wink.sdk.extranet.model.RatePlanView;
import travel.wink.sdk.extranet.model.RemoveEntryResponse;
import travel.wink.sdk.extranet.model.ShowPropertyPolicy400Response;
import travel.wink.sdk.extranet.model.UpsertRatePlanRequest;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-07-21T13:34:57.633677+07:00[Asia/Bangkok]")
public class RatePlanApi {
    private ApiClient apiClient;

    public RatePlanApi() {
        this(new ApiClient());
    }

    @Autowired
    public RatePlanApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Create Rate Plan
     * Create a new rate plan
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Create a new rate plan and associate it with this hotel identifier.
     * @param upsertRatePlanRequest The upsertRatePlanRequest parameter
     * @return RatePlanView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createRatePlanRequestCreation(String hotelIdentifier, UpsertRatePlanRequest upsertRatePlanRequest) throws WebClientResponseException {
        Object postBody = upsertRatePlanRequest;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling createRatePlan", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertRatePlanRequest' is set
        if (upsertRatePlanRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertRatePlanRequest' when calling createRatePlan", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<RatePlanView> localVarReturnType = new ParameterizedTypeReference<RatePlanView>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/rateplan", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create Rate Plan
     * Create a new rate plan
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Create a new rate plan and associate it with this hotel identifier.
     * @param upsertRatePlanRequest The upsertRatePlanRequest parameter
     * @return RatePlanView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RatePlanView> createRatePlan(String hotelIdentifier, UpsertRatePlanRequest upsertRatePlanRequest) throws WebClientResponseException {
        ParameterizedTypeReference<RatePlanView> localVarReturnType = new ParameterizedTypeReference<RatePlanView>() {};
        return createRatePlanRequestCreation(hotelIdentifier, upsertRatePlanRequest).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<RatePlanView>> createRatePlanWithHttpInfo(String hotelIdentifier, UpsertRatePlanRequest upsertRatePlanRequest) throws WebClientResponseException {
        ParameterizedTypeReference<RatePlanView> localVarReturnType = new ParameterizedTypeReference<RatePlanView>() {};
        return createRatePlanRequestCreation(hotelIdentifier, upsertRatePlanRequest).toEntity(localVarReturnType);
    }
    /**
     * Verify Removable
     * Check if a rate plan is removable. If a rate plan is associated / linked with a master rate, package or add-on, it cannot be removed until the associated entity removes it first.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Verify if rate plan, owned by this hotel identifier, is removable.
     * @param ratePlanIdentifier Verify if rate plan, identified by this identifier, is removable.
     * @param accept The accept parameter
     * @return RatePlanRemovableResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removableRatePlanRequestCreation(String hotelIdentifier, String ratePlanIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling removableRatePlan", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'ratePlanIdentifier' is set
        if (ratePlanIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'ratePlanIdentifier' when calling removableRatePlan", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("ratePlanIdentifier", ratePlanIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<RatePlanRemovableResponse> localVarReturnType = new ParameterizedTypeReference<RatePlanRemovableResponse>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/rateplan/{ratePlanIdentifier}/removable", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Verify Removable
     * Check if a rate plan is removable. If a rate plan is associated / linked with a master rate, package or add-on, it cannot be removed until the associated entity removes it first.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Verify if rate plan, owned by this hotel identifier, is removable.
     * @param ratePlanIdentifier Verify if rate plan, identified by this identifier, is removable.
     * @param accept The accept parameter
     * @return RatePlanRemovableResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RatePlanRemovableResponse> removableRatePlan(String hotelIdentifier, String ratePlanIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RatePlanRemovableResponse> localVarReturnType = new ParameterizedTypeReference<RatePlanRemovableResponse>() {};
        return removableRatePlanRequestCreation(hotelIdentifier, ratePlanIdentifier, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<RatePlanRemovableResponse>> removableRatePlanWithHttpInfo(String hotelIdentifier, String ratePlanIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RatePlanRemovableResponse> localVarReturnType = new ParameterizedTypeReference<RatePlanRemovableResponse>() {};
        return removableRatePlanRequestCreation(hotelIdentifier, ratePlanIdentifier, accept).toEntity(localVarReturnType);
    }
    /**
     * Delete Rate Plan
     * Remove a rate plan by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Remove rate plan owned by this hotel identifier.
     * @param ratePlanIdentifier Remove rate plan with this identifier.
     * @param accept The accept parameter
     * @return RemoveEntryResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeRatePlanRequestCreation(String hotelIdentifier, String ratePlanIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling removeRatePlan", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'ratePlanIdentifier' is set
        if (ratePlanIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'ratePlanIdentifier' when calling removeRatePlan", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("ratePlanIdentifier", ratePlanIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/rateplan/{ratePlanIdentifier}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete Rate Plan
     * Remove a rate plan by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Remove rate plan owned by this hotel identifier.
     * @param ratePlanIdentifier Remove rate plan with this identifier.
     * @param accept The accept parameter
     * @return RemoveEntryResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RemoveEntryResponse> removeRatePlan(String hotelIdentifier, String ratePlanIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return removeRatePlanRequestCreation(hotelIdentifier, ratePlanIdentifier, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<RemoveEntryResponse>> removeRatePlanWithHttpInfo(String hotelIdentifier, String ratePlanIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return removeRatePlanRequestCreation(hotelIdentifier, ratePlanIdentifier, accept).toEntity(localVarReturnType);
    }
    /**
     * Show Rate Plan
     * Retrieve a single rate plan identified by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show single rate plan owned by this hotel identifier.
     * @param ratePlanIdentifier Show rate plan with this hotel identifier.
     * @param accept The accept parameter
     * @return RatePlanView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showRatePlanRequestCreation(String hotelIdentifier, String ratePlanIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showRatePlan", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'ratePlanIdentifier' is set
        if (ratePlanIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'ratePlanIdentifier' when calling showRatePlan", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("ratePlanIdentifier", ratePlanIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<RatePlanView> localVarReturnType = new ParameterizedTypeReference<RatePlanView>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/rateplan/{ratePlanIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Rate Plan
     * Retrieve a single rate plan identified by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show single rate plan owned by this hotel identifier.
     * @param ratePlanIdentifier Show rate plan with this hotel identifier.
     * @param accept The accept parameter
     * @return RatePlanView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RatePlanView> showRatePlan(String hotelIdentifier, String ratePlanIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RatePlanView> localVarReturnType = new ParameterizedTypeReference<RatePlanView>() {};
        return showRatePlanRequestCreation(hotelIdentifier, ratePlanIdentifier, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<RatePlanView>> showRatePlanWithHttpInfo(String hotelIdentifier, String ratePlanIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RatePlanView> localVarReturnType = new ParameterizedTypeReference<RatePlanView>() {};
        return showRatePlanRequestCreation(hotelIdentifier, ratePlanIdentifier, accept).toEntity(localVarReturnType);
    }
    /**
     * Show Rate Plans
     * Retrieve list of rate plans for property.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show list of rate plans owned by this hotel identifier.
     * @param accept The accept parameter
     * @return List&lt;RatePlanView&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showRatePlansRequestCreation(String hotelIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showRatePlans", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<RatePlanView> localVarReturnType = new ParameterizedTypeReference<RatePlanView>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/rateplan/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Rate Plans
     * Retrieve list of rate plans for property.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show list of rate plans owned by this hotel identifier.
     * @param accept The accept parameter
     * @return List&lt;RatePlanView&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<RatePlanView> showRatePlans(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RatePlanView> localVarReturnType = new ParameterizedTypeReference<RatePlanView>() {};
        return showRatePlansRequestCreation(hotelIdentifier, accept).bodyToFlux(localVarReturnType);
    }

    public Mono<ResponseEntity<List<RatePlanView>>> showRatePlansWithHttpInfo(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RatePlanView> localVarReturnType = new ParameterizedTypeReference<RatePlanView>() {};
        return showRatePlansRequestCreation(hotelIdentifier, accept).toEntityList(localVarReturnType);
    }
    /**
     * Update Rate Plan
     * Update an existing rate plan by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update an existing rate plan owned by this hotel identifier.
     * @param ratePlanIdentifier Update an existing rate plan identified with this identifier.
     * @param upsertRatePlanRequest The upsertRatePlanRequest parameter
     * @return RatePlanView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateRatePlanRequestCreation(String hotelIdentifier, String ratePlanIdentifier, UpsertRatePlanRequest upsertRatePlanRequest) throws WebClientResponseException {
        Object postBody = upsertRatePlanRequest;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling updateRatePlan", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'ratePlanIdentifier' is set
        if (ratePlanIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'ratePlanIdentifier' when calling updateRatePlan", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertRatePlanRequest' is set
        if (upsertRatePlanRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertRatePlanRequest' when calling updateRatePlan", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("ratePlanIdentifier", ratePlanIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<RatePlanView> localVarReturnType = new ParameterizedTypeReference<RatePlanView>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/rateplan/{ratePlanIdentifier}", HttpMethod.PUT, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Rate Plan
     * Update an existing rate plan by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update an existing rate plan owned by this hotel identifier.
     * @param ratePlanIdentifier Update an existing rate plan identified with this identifier.
     * @param upsertRatePlanRequest The upsertRatePlanRequest parameter
     * @return RatePlanView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RatePlanView> updateRatePlan(String hotelIdentifier, String ratePlanIdentifier, UpsertRatePlanRequest upsertRatePlanRequest) throws WebClientResponseException {
        ParameterizedTypeReference<RatePlanView> localVarReturnType = new ParameterizedTypeReference<RatePlanView>() {};
        return updateRatePlanRequestCreation(hotelIdentifier, ratePlanIdentifier, upsertRatePlanRequest).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<RatePlanView>> updateRatePlanWithHttpInfo(String hotelIdentifier, String ratePlanIdentifier, UpsertRatePlanRequest upsertRatePlanRequest) throws WebClientResponseException {
        ParameterizedTypeReference<RatePlanView> localVarReturnType = new ParameterizedTypeReference<RatePlanView>() {};
        return updateRatePlanRequestCreation(hotelIdentifier, ratePlanIdentifier, upsertRatePlanRequest).toEntity(localVarReturnType);
    }
}
