/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/docs?api=affiliate): All APIs related to selling travel inventory as an affiliate. - [Extranet](/docs?api=extranet): All APIs related to managing travel inventory and suppliers. - [Booking Engine](/docs?api=booking-engine): All APIs related to searching for travel inventory and creating bookings. - [Channel Manager](https://integration.wink.travel/docs?api=channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Events](https://integration.wink.travel/docs?api=events):  All APIs related to Integration events.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.payment-v`1`+json.  ## Release history - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Extranet API Welcome to the Extranet API - A programmer-friendly way to manage your travel inventory on the wink payment. This API offers a superset of the features you can find at [https://extranet.wink.travel](https://extranet.wink.travel) and gives you all the tools you need to ready your properties and inventory for sale across 10000s of our unique sales channels. What differentiates us from existing Extranets is 1. we make it available for everyone to use and 2. the care we take in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Content creators have the ability to make their inventory look great and be searchable in a wide variety of ways. You won't find properties with generic inventory, low resolution pictures and little ancillary content that can easily be found everywhere else on the internet.  # Integrations We have already integrated with the most well-known channel managers so you don't have to. Once your properties are set up, you can finish the setup by mapping your property to wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API. - Allotz - CloudBeds / MyAllocator - Comanche - d-edge - FastBooking - HotelLink - HoteliersGuru - Omnibees - RateGain - Rate Tiger - ResAvenue - Siteminder - Sabre SynXis - Travelclick - Yieldplanet  # Intended Audience Programmers are [most likely] a requirement to start integrating with wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible. - Hotel chains - Hotel brands - Travel tech companies - Destination sites - Integrators - Aggregators - Destination management companies - Travel agencies - OTAs  
 *
 * The version of the OpenAPI document: 21.2.8-SNAPSHOT
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.extranet.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import travel.wink.sdk.extranet.model.InternalMessageRecipient;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * HotelInternalMessage
 */
@JsonPropertyOrder({
  HotelInternalMessage.JSON_PROPERTY_INTERNAL_MESSAGE_IDENTIFIER,
  HotelInternalMessage.JSON_PROPERTY_IDENTIFIERS,
  HotelInternalMessage.JSON_PROPERTY_PRIORITY,
  HotelInternalMessage.JSON_PROPERTY_TYPE,
  HotelInternalMessage.JSON_PROPERTY_RECIPIENT_TYPE,
  HotelInternalMessage.JSON_PROPERTY_SUBJECT,
  HotelInternalMessage.JSON_PROPERTY_BODY,
  HotelInternalMessage.JSON_PROPERTY_NOTIFY_VIA_EMAIL,
  HotelInternalMessage.JSON_PROPERTY_RECIPIENTS,
  HotelInternalMessage.JSON_PROPERTY_HOTEL_INTERNAL_MESSAGE_IDENTIFIER,
  HotelInternalMessage.JSON_PROPERTY_HOTEL_IDENTIFIER,
  HotelInternalMessage.JSON_PROPERTY_READ,
  HotelInternalMessage.JSON_PROPERTY_MARKED_AS_REMOVED
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-07-21T13:34:57.633677+07:00[Asia/Bangkok]")
public class HotelInternalMessage {
  public static final String JSON_PROPERTY_INTERNAL_MESSAGE_IDENTIFIER = "internalMessageIdentifier";
  private String internalMessageIdentifier;

  public static final String JSON_PROPERTY_IDENTIFIERS = "identifiers";
  private List<String> identifiers = null;

  /**
   * Gets or Sets priority
   */
  public enum PriorityEnum {
    HIGH("HIGH"),
    
    MEDIUM("MEDIUM"),
    
    LOW("LOW");

    private String value;

    PriorityEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PriorityEnum fromValue(String value) {
      for (PriorityEnum b : PriorityEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PRIORITY = "priority";
  private PriorityEnum priority;

  /**
   * Gets or Sets type
   */
  public enum TypeEnum {
    ALERT("ALERT"),
    
    MESSAGE("MESSAGE");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  /**
   * Gets or Sets recipientType
   */
  public enum RecipientTypeEnum {
    USER("USER"),
    
    HOTEL("HOTEL");

    private String value;

    RecipientTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static RecipientTypeEnum fromValue(String value) {
      for (RecipientTypeEnum b : RecipientTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_RECIPIENT_TYPE = "recipientType";
  private RecipientTypeEnum recipientType;

  public static final String JSON_PROPERTY_SUBJECT = "subject";
  private String subject;

  public static final String JSON_PROPERTY_BODY = "body";
  private String body;

  public static final String JSON_PROPERTY_NOTIFY_VIA_EMAIL = "notifyViaEmail";
  private Boolean notifyViaEmail;

  public static final String JSON_PROPERTY_RECIPIENTS = "recipients";
  private List<InternalMessageRecipient> recipients = null;

  public static final String JSON_PROPERTY_HOTEL_INTERNAL_MESSAGE_IDENTIFIER = "hotelInternalMessageIdentifier";
  private UUID hotelInternalMessageIdentifier;

  public static final String JSON_PROPERTY_HOTEL_IDENTIFIER = "hotelIdentifier";
  private UUID hotelIdentifier;

  public static final String JSON_PROPERTY_READ = "read";
  private Boolean read;

  public static final String JSON_PROPERTY_MARKED_AS_REMOVED = "markedAsRemoved";
  private Boolean markedAsRemoved;

  public HotelInternalMessage() { 
  }

  public HotelInternalMessage internalMessageIdentifier(String internalMessageIdentifier) {
    
    this.internalMessageIdentifier = internalMessageIdentifier;
    return this;
  }

   /**
   * Get internalMessageIdentifier
   * @return internalMessageIdentifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_INTERNAL_MESSAGE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getInternalMessageIdentifier() {
    return internalMessageIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_MESSAGE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalMessageIdentifier(String internalMessageIdentifier) {
    this.internalMessageIdentifier = internalMessageIdentifier;
  }


  public HotelInternalMessage identifiers(List<String> identifiers) {
    
    this.identifiers = identifiers;
    return this;
  }

  public HotelInternalMessage addIdentifiersItem(String identifiersItem) {
    if (this.identifiers == null) {
      this.identifiers = new ArrayList<>();
    }
    this.identifiers.add(identifiersItem);
    return this;
  }

   /**
   * Get identifiers
   * @return identifiers
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_IDENTIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getIdentifiers() {
    return identifiers;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIdentifiers(List<String> identifiers) {
    this.identifiers = identifiers;
  }


  public HotelInternalMessage priority(PriorityEnum priority) {
    
    this.priority = priority;
    return this;
  }

   /**
   * Get priority
   * @return priority
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PRIORITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PriorityEnum getPriority() {
    return priority;
  }


  @JsonProperty(JSON_PROPERTY_PRIORITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPriority(PriorityEnum priority) {
    this.priority = priority;
  }


  public HotelInternalMessage type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * Get type
   * @return type
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  public HotelInternalMessage recipientType(RecipientTypeEnum recipientType) {
    
    this.recipientType = recipientType;
    return this;
  }

   /**
   * Get recipientType
   * @return recipientType
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_RECIPIENT_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public RecipientTypeEnum getRecipientType() {
    return recipientType;
  }


  @JsonProperty(JSON_PROPERTY_RECIPIENT_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRecipientType(RecipientTypeEnum recipientType) {
    this.recipientType = recipientType;
  }


  public HotelInternalMessage subject(String subject) {
    
    this.subject = subject;
    return this;
  }

   /**
   * Get subject
   * @return subject
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SUBJECT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSubject() {
    return subject;
  }


  @JsonProperty(JSON_PROPERTY_SUBJECT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSubject(String subject) {
    this.subject = subject;
  }


  public HotelInternalMessage body(String body) {
    
    this.body = body;
    return this;
  }

   /**
   * Get body
   * @return body
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_BODY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getBody() {
    return body;
  }


  @JsonProperty(JSON_PROPERTY_BODY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBody(String body) {
    this.body = body;
  }


  public HotelInternalMessage notifyViaEmail(Boolean notifyViaEmail) {
    
    this.notifyViaEmail = notifyViaEmail;
    return this;
  }

   /**
   * Get notifyViaEmail
   * @return notifyViaEmail
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_NOTIFY_VIA_EMAIL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getNotifyViaEmail() {
    return notifyViaEmail;
  }


  @JsonProperty(JSON_PROPERTY_NOTIFY_VIA_EMAIL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNotifyViaEmail(Boolean notifyViaEmail) {
    this.notifyViaEmail = notifyViaEmail;
  }


  public HotelInternalMessage recipients(List<InternalMessageRecipient> recipients) {
    
    this.recipients = recipients;
    return this;
  }

  public HotelInternalMessage addRecipientsItem(InternalMessageRecipient recipientsItem) {
    if (this.recipients == null) {
      this.recipients = new ArrayList<>();
    }
    this.recipients.add(recipientsItem);
    return this;
  }

   /**
   * Get recipients
   * @return recipients
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_RECIPIENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<InternalMessageRecipient> getRecipients() {
    return recipients;
  }


  @JsonProperty(JSON_PROPERTY_RECIPIENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRecipients(List<InternalMessageRecipient> recipients) {
    this.recipients = recipients;
  }


  public HotelInternalMessage hotelInternalMessageIdentifier(UUID hotelInternalMessageIdentifier) {
    
    this.hotelInternalMessageIdentifier = hotelInternalMessageIdentifier;
    return this;
  }

   /**
   * Hotel internal message identifier
   * @return hotelInternalMessageIdentifier
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Hotel internal message identifier")
  @JsonProperty(JSON_PROPERTY_HOTEL_INTERNAL_MESSAGE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getHotelInternalMessageIdentifier() {
    return hotelInternalMessageIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_INTERNAL_MESSAGE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHotelInternalMessageIdentifier(UUID hotelInternalMessageIdentifier) {
    this.hotelInternalMessageIdentifier = hotelInternalMessageIdentifier;
  }


  public HotelInternalMessage hotelIdentifier(UUID hotelIdentifier) {
    
    this.hotelIdentifier = hotelIdentifier;
    return this;
  }

   /**
   * Hotel identifier
   * @return hotelIdentifier
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Hotel identifier")
  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getHotelIdentifier() {
    return hotelIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHotelIdentifier(UUID hotelIdentifier) {
    this.hotelIdentifier = hotelIdentifier;
  }


  public HotelInternalMessage read(Boolean read) {
    
    this.read = read;
    return this;
  }

   /**
   * Is read flag
   * @return read
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Is read flag")
  @JsonProperty(JSON_PROPERTY_READ)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getRead() {
    return read;
  }


  @JsonProperty(JSON_PROPERTY_READ)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRead(Boolean read) {
    this.read = read;
  }


  public HotelInternalMessage markedAsRemoved(Boolean markedAsRemoved) {
    
    this.markedAsRemoved = markedAsRemoved;
    return this;
  }

   /**
   * Remove
   * @return markedAsRemoved
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Remove")
  @JsonProperty(JSON_PROPERTY_MARKED_AS_REMOVED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getMarkedAsRemoved() {
    return markedAsRemoved;
  }


  @JsonProperty(JSON_PROPERTY_MARKED_AS_REMOVED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMarkedAsRemoved(Boolean markedAsRemoved) {
    this.markedAsRemoved = markedAsRemoved;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    HotelInternalMessage hotelInternalMessage = (HotelInternalMessage) o;
    return Objects.equals(this.internalMessageIdentifier, hotelInternalMessage.internalMessageIdentifier) &&
        Objects.equals(this.identifiers, hotelInternalMessage.identifiers) &&
        Objects.equals(this.priority, hotelInternalMessage.priority) &&
        Objects.equals(this.type, hotelInternalMessage.type) &&
        Objects.equals(this.recipientType, hotelInternalMessage.recipientType) &&
        Objects.equals(this.subject, hotelInternalMessage.subject) &&
        Objects.equals(this.body, hotelInternalMessage.body) &&
        Objects.equals(this.notifyViaEmail, hotelInternalMessage.notifyViaEmail) &&
        Objects.equals(this.recipients, hotelInternalMessage.recipients) &&
        Objects.equals(this.hotelInternalMessageIdentifier, hotelInternalMessage.hotelInternalMessageIdentifier) &&
        Objects.equals(this.hotelIdentifier, hotelInternalMessage.hotelIdentifier) &&
        Objects.equals(this.read, hotelInternalMessage.read) &&
        Objects.equals(this.markedAsRemoved, hotelInternalMessage.markedAsRemoved);
  }

  @Override
  public int hashCode() {
    return Objects.hash(internalMessageIdentifier, identifiers, priority, type, recipientType, subject, body, notifyViaEmail, recipients, hotelInternalMessageIdentifier, hotelIdentifier, read, markedAsRemoved);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class HotelInternalMessage {\n");
    sb.append("    internalMessageIdentifier: ").append(toIndentedString(internalMessageIdentifier)).append("\n");
    sb.append("    identifiers: ").append(toIndentedString(identifiers)).append("\n");
    sb.append("    priority: ").append(toIndentedString(priority)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    recipientType: ").append(toIndentedString(recipientType)).append("\n");
    sb.append("    subject: ").append(toIndentedString(subject)).append("\n");
    sb.append("    body: ").append(toIndentedString(body)).append("\n");
    sb.append("    notifyViaEmail: ").append(toIndentedString(notifyViaEmail)).append("\n");
    sb.append("    recipients: ").append(toIndentedString(recipients)).append("\n");
    sb.append("    hotelInternalMessageIdentifier: ").append(toIndentedString(hotelInternalMessageIdentifier)).append("\n");
    sb.append("    hotelIdentifier: ").append(toIndentedString(hotelIdentifier)).append("\n");
    sb.append("    read: ").append(toIndentedString(read)).append("\n");
    sb.append("    markedAsRemoved: ").append(toIndentedString(markedAsRemoved)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

