/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/docs?api=affiliate): All APIs related to selling travel inventory as an affiliate. - [Extranet](/docs?api=extranet): All APIs related to managing travel inventory and suppliers. - [Booking Engine](/docs?api=booking-engine): All APIs related to searching for travel inventory and creating bookings. - [Channel Manager](https://integration.wink.travel/docs?api=channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Events](https://integration.wink.travel/docs?api=events):  All APIs related to Integration events.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.payment-v`1`+json.  ## Release history - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Extranet API Welcome to the Extranet API - A programmer-friendly way to manage your travel inventory on the wink payment. This API offers a superset of the features you can find at [https://extranet.wink.travel](https://extranet.wink.travel) and gives you all the tools you need to ready your properties and inventory for sale across 10000s of our unique sales channels. What differentiates us from existing Extranets is 1. we make it available for everyone to use and 2. the care we take in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Content creators have the ability to make their inventory look great and be searchable in a wide variety of ways. You won't find properties with generic inventory, low resolution pictures and little ancillary content that can easily be found everywhere else on the internet.  # Integrations We have already integrated with the most well-known channel managers so you don't have to. Once your properties are set up, you can finish the setup by mapping your property to wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API. - Allotz - CloudBeds / MyAllocator - Comanche - d-edge - FastBooking - HotelLink - HoteliersGuru - Omnibees - RateGain - Rate Tiger - ResAvenue - Siteminder - Sabre SynXis - Travelclick - Yieldplanet  # Intended Audience Programmers are [most likely] a requirement to start integrating with wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible. - Hotel chains - Hotel brands - Travel tech companies - Destination sites - Integrators - Aggregators - Destination management companies - Travel agencies - OTAs  
 *
 * The version of the OpenAPI document: 21.4.3-SNAPSHOT
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.extranet.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import travel.wink.sdk.extranet.model.AddOnDescriptive;
import travel.wink.sdk.extranet.model.LocalizedPriceDescriptive;
import travel.wink.sdk.extranet.model.SimpleDescriptionDescriptive;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * AddOnOfferDescriptive
 */
@JsonPropertyOrder({
  AddOnOfferDescriptive.JSON_PROPERTY_PRICE,
  AddOnOfferDescriptive.JSON_PROPERTY_UNIT_PRICE,
  AddOnOfferDescriptive.JSON_PROPERTY_ADD_ON_IMAGE_URL,
  AddOnOfferDescriptive.JSON_PROPERTY_UPGRADE,
  AddOnOfferDescriptive.JSON_PROPERTY_OFFER_DETAILS,
  AddOnOfferDescriptive.JSON_PROPERTY_PROMOTION,
  AddOnOfferDescriptive.JSON_PROPERTY_GUESTS,
  AddOnOfferDescriptive.JSON_PROPERTY_NIGHTS
})
@JsonTypeName("AddOnOffer_Descriptive")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-08-07T09:37:10.042040+07:00[Asia/Bangkok]")
public class AddOnOfferDescriptive {
  public static final String JSON_PROPERTY_PRICE = "price";
  private LocalizedPriceDescriptive price;

  public static final String JSON_PROPERTY_UNIT_PRICE = "unitPrice";
  private LocalizedPriceDescriptive unitPrice;

  public static final String JSON_PROPERTY_ADD_ON_IMAGE_URL = "addOnImageUrl";
  private String addOnImageUrl;

  public static final String JSON_PROPERTY_UPGRADE = "upgrade";
  private AddOnDescriptive upgrade;

  public static final String JSON_PROPERTY_OFFER_DETAILS = "offerDetails";
  private List<SimpleDescriptionDescriptive> offerDetails = null;

  public static final String JSON_PROPERTY_PROMOTION = "promotion";
  private String promotion;

  public static final String JSON_PROPERTY_GUESTS = "guests";
  private Integer guests;

  public static final String JSON_PROPERTY_NIGHTS = "nights";
  private Integer nights;

  public AddOnOfferDescriptive() { 
  }

  public AddOnOfferDescriptive price(LocalizedPriceDescriptive price) {
    
    this.price = price;
    return this;
  }

   /**
   * Get price
   * @return price
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalizedPriceDescriptive getPrice() {
    return price;
  }


  @JsonProperty(JSON_PROPERTY_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPrice(LocalizedPriceDescriptive price) {
    this.price = price;
  }


  public AddOnOfferDescriptive unitPrice(LocalizedPriceDescriptive unitPrice) {
    
    this.unitPrice = unitPrice;
    return this;
  }

   /**
   * Get unitPrice
   * @return unitPrice
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_UNIT_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalizedPriceDescriptive getUnitPrice() {
    return unitPrice;
  }


  @JsonProperty(JSON_PROPERTY_UNIT_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUnitPrice(LocalizedPriceDescriptive unitPrice) {
    this.unitPrice = unitPrice;
  }


  public AddOnOfferDescriptive addOnImageUrl(String addOnImageUrl) {
    
    this.addOnImageUrl = addOnImageUrl;
    return this;
  }

   /**
   * Populated for when we send out confirmation emails to travelers.
   * @return addOnImageUrl
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Populated for when we send out confirmation emails to travelers.")
  @JsonProperty(JSON_PROPERTY_ADD_ON_IMAGE_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAddOnImageUrl() {
    return addOnImageUrl;
  }


  @JsonProperty(JSON_PROPERTY_ADD_ON_IMAGE_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAddOnImageUrl(String addOnImageUrl) {
    this.addOnImageUrl = addOnImageUrl;
  }


  public AddOnOfferDescriptive upgrade(AddOnDescriptive upgrade) {
    
    this.upgrade = upgrade;
    return this;
  }

   /**
   * Get upgrade
   * @return upgrade
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_UPGRADE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public AddOnDescriptive getUpgrade() {
    return upgrade;
  }


  @JsonProperty(JSON_PROPERTY_UPGRADE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUpgrade(AddOnDescriptive upgrade) {
    this.upgrade = upgrade;
  }


  public AddOnOfferDescriptive offerDetails(List<SimpleDescriptionDescriptive> offerDetails) {
    
    this.offerDetails = offerDetails;
    return this;
  }

  public AddOnOfferDescriptive addOfferDetailsItem(SimpleDescriptionDescriptive offerDetailsItem) {
    if (this.offerDetails == null) {
      this.offerDetails = new ArrayList<>();
    }
    this.offerDetails.add(offerDetailsItem);
    return this;
  }

   /**
   * Localized offer details if any apply
   * @return offerDetails
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Localized offer details if any apply")
  @JsonProperty(JSON_PROPERTY_OFFER_DETAILS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<SimpleDescriptionDescriptive> getOfferDetails() {
    return offerDetails;
  }


  @JsonProperty(JSON_PROPERTY_OFFER_DETAILS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOfferDetails(List<SimpleDescriptionDescriptive> offerDetails) {
    this.offerDetails = offerDetails;
  }


  public AddOnOfferDescriptive promotion(String promotion) {
    
    this.promotion = promotion;
    return this;
  }

   /**
   * If an add-on is linked to a rate plan the user could be entitled to a promotional discount if she enters a code. When this field is populated, it means the discount was applied to the add-on.
   * @return promotion
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "If an add-on is linked to a rate plan the user could be entitled to a promotional discount if she enters a code. When this field is populated, it means the discount was applied to the add-on.")
  @JsonProperty(JSON_PROPERTY_PROMOTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPromotion() {
    return promotion;
  }


  @JsonProperty(JSON_PROPERTY_PROMOTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPromotion(String promotion) {
    this.promotion = promotion;
  }


  public AddOnOfferDescriptive guests(Integer guests) {
    
    this.guests = guests;
    return this;
  }

   /**
   * Number of guest that will be using this add-on.
   * @return guests
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Number of guest that will be using this add-on.")
  @JsonProperty(JSON_PROPERTY_GUESTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getGuests() {
    return guests;
  }


  @JsonProperty(JSON_PROPERTY_GUESTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGuests(Integer guests) {
    this.guests = guests;
  }


  public AddOnOfferDescriptive nights(Integer nights) {
    
    this.nights = nights;
    return this;
  }

   /**
   * Number of nights the guests will be staying.
   * @return nights
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Number of nights the guests will be staying.")
  @JsonProperty(JSON_PROPERTY_NIGHTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getNights() {
    return nights;
  }


  @JsonProperty(JSON_PROPERTY_NIGHTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNights(Integer nights) {
    this.nights = nights;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AddOnOfferDescriptive addOnOfferDescriptive = (AddOnOfferDescriptive) o;
    return Objects.equals(this.price, addOnOfferDescriptive.price) &&
        Objects.equals(this.unitPrice, addOnOfferDescriptive.unitPrice) &&
        Objects.equals(this.addOnImageUrl, addOnOfferDescriptive.addOnImageUrl) &&
        Objects.equals(this.upgrade, addOnOfferDescriptive.upgrade) &&
        Objects.equals(this.offerDetails, addOnOfferDescriptive.offerDetails) &&
        Objects.equals(this.promotion, addOnOfferDescriptive.promotion) &&
        Objects.equals(this.guests, addOnOfferDescriptive.guests) &&
        Objects.equals(this.nights, addOnOfferDescriptive.nights);
  }

  @Override
  public int hashCode() {
    return Objects.hash(price, unitPrice, addOnImageUrl, upgrade, offerDetails, promotion, guests, nights);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AddOnOfferDescriptive {\n");
    sb.append("    price: ").append(toIndentedString(price)).append("\n");
    sb.append("    unitPrice: ").append(toIndentedString(unitPrice)).append("\n");
    sb.append("    addOnImageUrl: ").append(toIndentedString(addOnImageUrl)).append("\n");
    sb.append("    upgrade: ").append(toIndentedString(upgrade)).append("\n");
    sb.append("    offerDetails: ").append(toIndentedString(offerDetails)).append("\n");
    sb.append("    promotion: ").append(toIndentedString(promotion)).append("\n");
    sb.append("    guests: ").append(toIndentedString(guests)).append("\n");
    sb.append("    nights: ").append(toIndentedString(nights)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

