/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/docs?api=affiliate): All APIs related to selling travel inventory as an affiliate. - [Extranet](/docs?api=extranet): All APIs related to managing travel inventory and suppliers. - [Booking Engine](/docs?api=booking-engine): All APIs related to searching for travel inventory and creating bookings. - [Channel Manager](https://integration.wink.travel/docs?api=channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Events](https://integration.wink.travel/docs?api=events):  All APIs related to Integration events.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.payment-v`1`+json.  ## Release history - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Extranet API Welcome to the Extranet API - A programmer-friendly way to manage your travel inventory on the wink payment. This API offers a superset of the features you can find at [https://extranet.wink.travel](https://extranet.wink.travel) and gives you all the tools you need to ready your properties and inventory for sale across 10000s of our unique sales channels. What differentiates us from existing Extranets is 1. we make it available for everyone to use and 2. the care we take in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Content creators have the ability to make their inventory look great and be searchable in a wide variety of ways. You won't find properties with generic inventory, low resolution pictures and little ancillary content that can easily be found everywhere else on the internet.  # Integrations We have already integrated with the most well-known channel managers so you don't have to. Once your properties are set up, you can finish the setup by mapping your property to wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API. - Allotz - CloudBeds / MyAllocator - Comanche - d-edge - FastBooking - HotelLink - HoteliersGuru - Omnibees - RateGain - Rate Tiger - ResAvenue - Siteminder - Sabre SynXis - Travelclick - Yieldplanet  # Intended Audience Programmers are [most likely] a requirement to start integrating with wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible. - Hotel chains - Hotel brands - Travel tech companies - Destination sites - Integrators - Aggregators - Destination management companies - Travel agencies - OTAs  
 *
 * The version of the OpenAPI document: 21.4.3-SNAPSHOT
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.extranet.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * GeoNameDescriptive
 */
@JsonPropertyOrder({
  GeoNameDescriptive.JSON_PROPERTY_GEO_NAME_ID,
  GeoNameDescriptive.JSON_PROPERTY_LOCALE_CODE,
  GeoNameDescriptive.JSON_PROPERTY_CONTINENT_CODE,
  GeoNameDescriptive.JSON_PROPERTY_CONTINENT_NAME,
  GeoNameDescriptive.JSON_PROPERTY_COUNTRY_ISO_CODE,
  GeoNameDescriptive.JSON_PROPERTY_COUNTRY_NAME,
  GeoNameDescriptive.JSON_PROPERTY_CITY_NAME,
  GeoNameDescriptive.JSON_PROPERTY_TIMEZONE,
  GeoNameDescriptive.JSON_PROPERTY_SUB_DIVISION1_CODE,
  GeoNameDescriptive.JSON_PROPERTY_SUB_DIVISION1_NAME,
  GeoNameDescriptive.JSON_PROPERTY_SUB_DIVISION2_CODE,
  GeoNameDescriptive.JSON_PROPERTY_SUB_DIVISION2_NAME
})
@JsonTypeName("GeoName_Descriptive")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-08-07T09:37:10.042040+07:00[Asia/Bangkok]")
public class GeoNameDescriptive {
  public static final String JSON_PROPERTY_GEO_NAME_ID = "geoNameId";
  private String geoNameId;

  public static final String JSON_PROPERTY_LOCALE_CODE = "localeCode";
  private String localeCode;

  public static final String JSON_PROPERTY_CONTINENT_CODE = "continentCode";
  private String continentCode;

  public static final String JSON_PROPERTY_CONTINENT_NAME = "continentName";
  private String continentName;

  public static final String JSON_PROPERTY_COUNTRY_ISO_CODE = "countryIsoCode";
  private String countryIsoCode;

  public static final String JSON_PROPERTY_COUNTRY_NAME = "countryName";
  private String countryName;

  public static final String JSON_PROPERTY_CITY_NAME = "cityName";
  private String cityName;

  public static final String JSON_PROPERTY_TIMEZONE = "timezone";
  private String timezone;

  public static final String JSON_PROPERTY_SUB_DIVISION1_CODE = "subDivision1Code";
  private String subDivision1Code;

  public static final String JSON_PROPERTY_SUB_DIVISION1_NAME = "subDivision1Name";
  private String subDivision1Name;

  public static final String JSON_PROPERTY_SUB_DIVISION2_CODE = "subDivision2Code";
  private String subDivision2Code;

  public static final String JSON_PROPERTY_SUB_DIVISION2_NAME = "subDivision2Name";
  private String subDivision2Name;

  public GeoNameDescriptive() { 
  }

  public GeoNameDescriptive geoNameId(String geoNameId) {
    
    this.geoNameId = geoNameId;
    return this;
  }

   /**
   * GeoName identifiers taken from [https://geonames.org](https://geonames.org).
   * @return geoNameId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "8798734", value = "GeoName identifiers taken from [https://geonames.org](https://geonames.org).")
  @JsonProperty(JSON_PROPERTY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getGeoNameId() {
    return geoNameId;
  }


  @JsonProperty(JSON_PROPERTY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGeoNameId(String geoNameId) {
    this.geoNameId = geoNameId;
  }


  public GeoNameDescriptive localeCode(String localeCode) {
    
    this.localeCode = localeCode;
    return this;
  }

   /**
   * Locale code
   * @return localeCode
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "en", value = "Locale code")
  @JsonProperty(JSON_PROPERTY_LOCALE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLocaleCode() {
    return localeCode;
  }


  @JsonProperty(JSON_PROPERTY_LOCALE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLocaleCode(String localeCode) {
    this.localeCode = localeCode;
  }


  public GeoNameDescriptive continentCode(String continentCode) {
    
    this.continentCode = continentCode;
    return this;
  }

   /**
   * Continent code
   * @return continentCode
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "NA", value = "Continent code")
  @JsonProperty(JSON_PROPERTY_CONTINENT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getContinentCode() {
    return continentCode;
  }


  @JsonProperty(JSON_PROPERTY_CONTINENT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setContinentCode(String continentCode) {
    this.continentCode = continentCode;
  }


  public GeoNameDescriptive continentName(String continentName) {
    
    this.continentName = continentName;
    return this;
  }

   /**
   * Continent name
   * @return continentName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "North America", value = "Continent name")
  @JsonProperty(JSON_PROPERTY_CONTINENT_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getContinentName() {
    return continentName;
  }


  @JsonProperty(JSON_PROPERTY_CONTINENT_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setContinentName(String continentName) {
    this.continentName = continentName;
  }


  public GeoNameDescriptive countryIsoCode(String countryIsoCode) {
    
    this.countryIsoCode = countryIsoCode;
    return this;
  }

   /**
   * Country ISO code
   * @return countryIsoCode
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "US", value = "Country ISO code")
  @JsonProperty(JSON_PROPERTY_COUNTRY_ISO_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCountryIsoCode() {
    return countryIsoCode;
  }


  @JsonProperty(JSON_PROPERTY_COUNTRY_ISO_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCountryIsoCode(String countryIsoCode) {
    this.countryIsoCode = countryIsoCode;
  }


  public GeoNameDescriptive countryName(String countryName) {
    
    this.countryName = countryName;
    return this;
  }

   /**
   * Country name
   * @return countryName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "United States", value = "Country name")
  @JsonProperty(JSON_PROPERTY_COUNTRY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCountryName() {
    return countryName;
  }


  @JsonProperty(JSON_PROPERTY_COUNTRY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCountryName(String countryName) {
    this.countryName = countryName;
  }


  public GeoNameDescriptive cityName(String cityName) {
    
    this.cityName = cityName;
    return this;
  }

   /**
   * City name
   * @return cityName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "New York", value = "City name")
  @JsonProperty(JSON_PROPERTY_CITY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCityName() {
    return cityName;
  }


  @JsonProperty(JSON_PROPERTY_CITY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCityName(String cityName) {
    this.cityName = cityName;
  }


  public GeoNameDescriptive timezone(String timezone) {
    
    this.timezone = timezone;
    return this;
  }

   /**
   * Timezone
   * @return timezone
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "America/New_York", value = "Timezone")
  @JsonProperty(JSON_PROPERTY_TIMEZONE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTimezone() {
    return timezone;
  }


  @JsonProperty(JSON_PROPERTY_TIMEZONE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTimezone(String timezone) {
    this.timezone = timezone;
  }


  public GeoNameDescriptive subDivision1Code(String subDivision1Code) {
    
    this.subDivision1Code = subDivision1Code;
    return this;
  }

   /**
   * Sub-division 1 code
   * @return subDivision1Code
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "NY", value = "Sub-division 1 code")
  @JsonProperty(JSON_PROPERTY_SUB_DIVISION1_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSubDivision1Code() {
    return subDivision1Code;
  }


  @JsonProperty(JSON_PROPERTY_SUB_DIVISION1_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSubDivision1Code(String subDivision1Code) {
    this.subDivision1Code = subDivision1Code;
  }


  public GeoNameDescriptive subDivision1Name(String subDivision1Name) {
    
    this.subDivision1Name = subDivision1Name;
    return this;
  }

   /**
   * Sub-division 1 name
   * @return subDivision1Name
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "NY", value = "Sub-division 1 name")
  @JsonProperty(JSON_PROPERTY_SUB_DIVISION1_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSubDivision1Name() {
    return subDivision1Name;
  }


  @JsonProperty(JSON_PROPERTY_SUB_DIVISION1_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSubDivision1Name(String subDivision1Name) {
    this.subDivision1Name = subDivision1Name;
  }


  public GeoNameDescriptive subDivision2Code(String subDivision2Code) {
    
    this.subDivision2Code = subDivision2Code;
    return this;
  }

   /**
   * Sub-division 2 code
   * @return subDivision2Code
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Sub-division 2 code")
  @JsonProperty(JSON_PROPERTY_SUB_DIVISION2_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSubDivision2Code() {
    return subDivision2Code;
  }


  @JsonProperty(JSON_PROPERTY_SUB_DIVISION2_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSubDivision2Code(String subDivision2Code) {
    this.subDivision2Code = subDivision2Code;
  }


  public GeoNameDescriptive subDivision2Name(String subDivision2Name) {
    
    this.subDivision2Name = subDivision2Name;
    return this;
  }

   /**
   * Sub-division 2 name
   * @return subDivision2Name
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Sub-division 2 name")
  @JsonProperty(JSON_PROPERTY_SUB_DIVISION2_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSubDivision2Name() {
    return subDivision2Name;
  }


  @JsonProperty(JSON_PROPERTY_SUB_DIVISION2_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSubDivision2Name(String subDivision2Name) {
    this.subDivision2Name = subDivision2Name;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GeoNameDescriptive geoNameDescriptive = (GeoNameDescriptive) o;
    return Objects.equals(this.geoNameId, geoNameDescriptive.geoNameId) &&
        Objects.equals(this.localeCode, geoNameDescriptive.localeCode) &&
        Objects.equals(this.continentCode, geoNameDescriptive.continentCode) &&
        Objects.equals(this.continentName, geoNameDescriptive.continentName) &&
        Objects.equals(this.countryIsoCode, geoNameDescriptive.countryIsoCode) &&
        Objects.equals(this.countryName, geoNameDescriptive.countryName) &&
        Objects.equals(this.cityName, geoNameDescriptive.cityName) &&
        Objects.equals(this.timezone, geoNameDescriptive.timezone) &&
        Objects.equals(this.subDivision1Code, geoNameDescriptive.subDivision1Code) &&
        Objects.equals(this.subDivision1Name, geoNameDescriptive.subDivision1Name) &&
        Objects.equals(this.subDivision2Code, geoNameDescriptive.subDivision2Code) &&
        Objects.equals(this.subDivision2Name, geoNameDescriptive.subDivision2Name);
  }

  @Override
  public int hashCode() {
    return Objects.hash(geoNameId, localeCode, continentCode, continentName, countryIsoCode, countryName, cityName, timezone, subDivision1Code, subDivision1Name, subDivision2Code, subDivision2Name);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GeoNameDescriptive {\n");
    sb.append("    geoNameId: ").append(toIndentedString(geoNameId)).append("\n");
    sb.append("    localeCode: ").append(toIndentedString(localeCode)).append("\n");
    sb.append("    continentCode: ").append(toIndentedString(continentCode)).append("\n");
    sb.append("    continentName: ").append(toIndentedString(continentName)).append("\n");
    sb.append("    countryIsoCode: ").append(toIndentedString(countryIsoCode)).append("\n");
    sb.append("    countryName: ").append(toIndentedString(countryName)).append("\n");
    sb.append("    cityName: ").append(toIndentedString(cityName)).append("\n");
    sb.append("    timezone: ").append(toIndentedString(timezone)).append("\n");
    sb.append("    subDivision1Code: ").append(toIndentedString(subDivision1Code)).append("\n");
    sb.append("    subDivision1Name: ").append(toIndentedString(subDivision1Name)).append("\n");
    sb.append("    subDivision2Code: ").append(toIndentedString(subDivision2Code)).append("\n");
    sb.append("    subDivision2Name: ").append(toIndentedString(subDivision2Name)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

