/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/docs?api=affiliate): All APIs related to selling travel inventory as an affiliate. - [Extranet](/docs?api=extranet): All APIs related to managing travel inventory and suppliers. - [Booking Engine](/docs?api=booking-engine): All APIs related to searching for travel inventory and creating bookings. - [Channel Manager](https://integration.wink.travel/docs?api=channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Events](https://integration.wink.travel/docs?api=events):  All APIs related to Integration events.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.payment-v`1`+json.  ## Release history - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Extranet API Welcome to the Extranet API - A programmer-friendly way to manage your travel inventory on the wink payment. This API offers a superset of the features you can find at [https://extranet.wink.travel](https://extranet.wink.travel) and gives you all the tools you need to ready your properties and inventory for sale across 10000s of our unique sales channels. What differentiates us from existing Extranets is 1. we make it available for everyone to use and 2. the care we take in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Content creators have the ability to make their inventory look great and be searchable in a wide variety of ways. You won't find properties with generic inventory, low resolution pictures and little ancillary content that can easily be found everywhere else on the internet.  # Integrations We have already integrated with the most well-known channel managers so you don't have to. Once your properties are set up, you can finish the setup by mapping your property to wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API. - Allotz - CloudBeds / MyAllocator - Comanche - d-edge - FastBooking - HotelLink - HoteliersGuru - Omnibees - RateGain - Rate Tiger - ResAvenue - Siteminder - Sabre SynXis - Travelclick - Yieldplanet  # Intended Audience Programmers are [most likely] a requirement to start integrating with wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible. - Hotel chains - Hotel brands - Travel tech companies - Destination sites - Integrators - Aggregators - Destination management companies - Travel agencies - OTAs  
 *
 * The version of the OpenAPI document: 21.4.3-SNAPSHOT
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.extranet.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import travel.wink.sdk.extranet.model.RateModifierBundleModifierOverride;
import travel.wink.sdk.extranet.model.RateModifierDescriptive;
import travel.wink.sdk.extranet.model.SimpleDescriptionDescriptive;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Promotion bundles for this channel
 */
@ApiModel(description = "Promotion bundles for this channel")
@JsonPropertyOrder({
  RateModifierBundleDescriptive.JSON_PROPERTY_IDENTIFIER,
  RateModifierBundleDescriptive.JSON_PROPERTY_HOTEL_IDENTIFIER,
  RateModifierBundleDescriptive.JSON_PROPERTY_NAME,
  RateModifierBundleDescriptive.JSON_PROPERTY_ENABLED,
  RateModifierBundleDescriptive.JSON_PROPERTY_ITEMS,
  RateModifierBundleDescriptive.JSON_PROPERTY_MODIFIER_OVERRIDE,
  RateModifierBundleDescriptive.JSON_PROPERTY_TYPE,
  RateModifierBundleDescriptive.JSON_PROPERTY_PRICING_TYPE,
  RateModifierBundleDescriptive.JSON_PROPERTY_DESCRIPTION
})
@JsonTypeName("RateModifierBundle_Descriptive")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-08-07T09:37:10.042040+07:00[Asia/Bangkok]")
public class RateModifierBundleDescriptive {
  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  private UUID identifier;

  public static final String JSON_PROPERTY_HOTEL_IDENTIFIER = "hotelIdentifier";
  private UUID hotelIdentifier;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_ENABLED = "enabled";
  private Boolean enabled = true;

  public static final String JSON_PROPERTY_ITEMS = "items";
  private List<RateModifierDescriptive> items = null;

  public static final String JSON_PROPERTY_MODIFIER_OVERRIDE = "modifierOverride";
  private RateModifierBundleModifierOverride modifierOverride;

  /**
   * Required if manual override modifier is not null
   */
  public enum TypeEnum {
    PREMIUM("PREMIUM"),
    
    DISCOUNT("DISCOUNT");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  /**
   * Determines whether this discount should be applied per night, per stay or per person - per night; Required if amount override is not null
   */
  public enum PricingTypeEnum {
    STAY("PER_STAY"),
    
    ADULT("PER_ADULT"),
    
    CHILD("PER_CHILD"),
    
    NIGHT("PER_NIGHT"),
    
    PERSON("PER_PERSON"),
    
    PERSON_PER_NIGHT("PER_PERSON_PER_NIGHT"),
    
    PERSON_PER_HOUR("PER_PERSON_PER_HOUR"),
    
    HOUR("PER_HOUR"),
    
    PERSON_PER_STAY("PER_PERSON_PER_STAY"),
    
    ADULT_PER_NIGHT("PER_ADULT_PER_NIGHT"),
    
    ADULT_PER_STAY("PER_ADULT_PER_STAY"),
    
    CHILD_PER_NIGHT("PER_CHILD_PER_NIGHT"),
    
    CHILD_PER_STAY("PER_CHILD_PER_STAY"),
    
    USE("PER_USE"),
    
    PERSON_PER_USE("PER_PERSON_PER_USE");

    private String value;

    PricingTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PricingTypeEnum fromValue(String value) {
      for (PricingTypeEnum b : PricingTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PRICING_TYPE = "pricingType";
  private PricingTypeEnum pricingType;

  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  private List<SimpleDescriptionDescriptive> description = null;

  public RateModifierBundleDescriptive() { 
  }

  @JsonCreator
  public RateModifierBundleDescriptive(
    @JsonProperty(JSON_PROPERTY_ITEMS) List<RateModifierDescriptive> items
  ) {
    this();
    this.items = items;
  }

  public RateModifierBundleDescriptive identifier(UUID identifier) {
    
    this.identifier = identifier;
    return this;
  }

   /**
   * Unique record identifier
   * @return identifier
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Unique record identifier")
  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIdentifier(UUID identifier) {
    this.identifier = identifier;
  }


  public RateModifierBundleDescriptive hotelIdentifier(UUID hotelIdentifier) {
    
    this.hotelIdentifier = hotelIdentifier;
    return this;
  }

   /**
   * Hotel identifier.
   * @return hotelIdentifier
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Hotel identifier.")
  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getHotelIdentifier() {
    return hotelIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHotelIdentifier(UUID hotelIdentifier) {
    this.hotelIdentifier = hotelIdentifier;
  }


  public RateModifierBundleDescriptive name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Internal name of promotion ancillary.
   * @return name
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "Early bird - Long Term", required = true, value = "Internal name of promotion ancillary.")
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(String name) {
    this.name = name;
  }


  public RateModifierBundleDescriptive enabled(Boolean enabled) {
    
    this.enabled = enabled;
    return this;
  }

   /**
   * Whether this promotion ancillary is enabled or not.
   * @return enabled
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "true", required = true, value = "Whether this promotion ancillary is enabled or not.")
  @JsonProperty(JSON_PROPERTY_ENABLED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getEnabled() {
    return enabled;
  }


  @JsonProperty(JSON_PROPERTY_ENABLED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setEnabled(Boolean enabled) {
    this.enabled = enabled;
  }


   /**
   * Get items
   * @return items
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ITEMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<RateModifierDescriptive> getItems() {
    return items;
  }




  public RateModifierBundleDescriptive modifierOverride(RateModifierBundleModifierOverride modifierOverride) {
    
    this.modifierOverride = modifierOverride;
    return this;
  }

   /**
   * Get modifierOverride
   * @return modifierOverride
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_MODIFIER_OVERRIDE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public RateModifierBundleModifierOverride getModifierOverride() {
    return modifierOverride;
  }


  @JsonProperty(JSON_PROPERTY_MODIFIER_OVERRIDE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setModifierOverride(RateModifierBundleModifierOverride modifierOverride) {
    this.modifierOverride = modifierOverride;
  }


  public RateModifierBundleDescriptive type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * Required if manual override modifier is not null
   * @return type
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "DISCOUNT", value = "Required if manual override modifier is not null")
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  public RateModifierBundleDescriptive pricingType(PricingTypeEnum pricingType) {
    
    this.pricingType = pricingType;
    return this;
  }

   /**
   * Determines whether this discount should be applied per night, per stay or per person - per night; Required if amount override is not null
   * @return pricingType
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Determines whether this discount should be applied per night, per stay or per person - per night; Required if amount override is not null")
  @JsonProperty(JSON_PROPERTY_PRICING_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PricingTypeEnum getPricingType() {
    return pricingType;
  }


  @JsonProperty(JSON_PROPERTY_PRICING_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPricingType(PricingTypeEnum pricingType) {
    this.pricingType = pricingType;
  }


  public RateModifierBundleDescriptive description(List<SimpleDescriptionDescriptive> description) {
    
    this.description = description;
    return this;
  }

  public RateModifierBundleDescriptive addDescriptionItem(SimpleDescriptionDescriptive descriptionItem) {
    if (this.description == null) {
      this.description = new ArrayList<>();
    }
    this.description.add(descriptionItem);
    return this;
  }

   /**
   * Get description
   * @return description
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<SimpleDescriptionDescriptive> getDescription() {
    return description;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDescription(List<SimpleDescriptionDescriptive> description) {
    this.description = description;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RateModifierBundleDescriptive rateModifierBundleDescriptive = (RateModifierBundleDescriptive) o;
    return Objects.equals(this.identifier, rateModifierBundleDescriptive.identifier) &&
        Objects.equals(this.hotelIdentifier, rateModifierBundleDescriptive.hotelIdentifier) &&
        Objects.equals(this.name, rateModifierBundleDescriptive.name) &&
        Objects.equals(this.enabled, rateModifierBundleDescriptive.enabled) &&
        Objects.equals(this.items, rateModifierBundleDescriptive.items) &&
        Objects.equals(this.modifierOverride, rateModifierBundleDescriptive.modifierOverride) &&
        Objects.equals(this.type, rateModifierBundleDescriptive.type) &&
        Objects.equals(this.pricingType, rateModifierBundleDescriptive.pricingType) &&
        Objects.equals(this.description, rateModifierBundleDescriptive.description);
  }

  @Override
  public int hashCode() {
    return Objects.hash(identifier, hotelIdentifier, name, enabled, items, modifierOverride, type, pricingType, description);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RateModifierBundleDescriptive {\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    hotelIdentifier: ").append(toIndentedString(hotelIdentifier)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    enabled: ").append(toIndentedString(enabled)).append("\n");
    sb.append("    items: ").append(toIndentedString(items)).append("\n");
    sb.append("    modifierOverride: ").append(toIndentedString(modifierOverride)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    pricingType: ").append(toIndentedString(pricingType)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

