/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/docs?api=affiliate): All APIs related to selling travel inventory as an affiliate. - [Extranet](/docs?api=extranet): All APIs related to managing travel inventory and suppliers. - [Booking Engine](/docs?api=booking-engine): All APIs related to searching for travel inventory and creating bookings. - [Channel Manager](https://integration.wink.travel/docs?api=channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Events](https://integration.wink.travel/docs?api=events):  All APIs related to Integration events.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.payment-v`1`+json.  ## Release history - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Extranet API Welcome to the Extranet API - A programmer-friendly way to manage your travel inventory on the wink payment. This API offers a superset of the features you can find at [https://extranet.wink.travel](https://extranet.wink.travel) and gives you all the tools you need to ready your properties and inventory for sale across 10000s of our unique sales channels. What differentiates us from existing Extranets is 1. we make it available for everyone to use and 2. the care we take in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Content creators have the ability to make their inventory look great and be searchable in a wide variety of ways. You won't find properties with generic inventory, low resolution pictures and little ancillary content that can easily be found everywhere else on the internet.  # Integrations We have already integrated with the most well-known channel managers so you don't have to. Once your properties are set up, you can finish the setup by mapping your property to wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API. - Allotz - CloudBeds / MyAllocator - Comanche - d-edge - FastBooking - HotelLink - HoteliersGuru - Omnibees - RateGain - Rate Tiger - ResAvenue - Siteminder - Sabre SynXis - Travelclick - Yieldplanet  # Intended Audience Programmers are [most likely] a requirement to start integrating with wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible. - Hotel chains - Hotel brands - Travel tech companies - Destination sites - Integrators - Aggregators - Destination management companies - Travel agencies - OTAs  
 *
 * The version of the OpenAPI document: 21.4.3-SNAPSHOT
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.extranet.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import travel.wink.sdk.extranet.model.ChannelNameDescriptive;
import travel.wink.sdk.extranet.model.GeoNameCountryDescriptive;
import travel.wink.sdk.extranet.model.GeoNameDescriptive;
import travel.wink.sdk.extranet.model.PropertyPolicyDescriptive;
import travel.wink.sdk.extranet.model.RoomConfigurationDescriptive;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * RateTesterDescriptive
 */
@JsonPropertyOrder({
  RateTesterDescriptive.JSON_PROPERTY_HOTEL_IDENTIFIER,
  RateTesterDescriptive.JSON_PROPERTY_CHANNEL,
  RateTesterDescriptive.JSON_PROPERTY_STAY_START_DATE,
  RateTesterDescriptive.JSON_PROPERTY_STAY_END_DATE,
  RateTesterDescriptive.JSON_PROPERTY_ROOM_CONFIGURATIONS,
  RateTesterDescriptive.JSON_PROPERTY_CURRENCY,
  RateTesterDescriptive.JSON_PROPERTY_AUTHENTICATED,
  RateTesterDescriptive.JSON_PROPERTY_BOOKING_DATE,
  RateTesterDescriptive.JSON_PROPERTY_SELL_START_DATE,
  RateTesterDescriptive.JSON_PROPERTY_SELL_END_DATE,
  RateTesterDescriptive.JSON_PROPERTY_PROMOTION,
  RateTesterDescriptive.JSON_PROPERTY_SOURCE_CURRENCY,
  RateTesterDescriptive.JSON_PROPERTY_CITY,
  RateTesterDescriptive.JSON_PROPERTY_COUNTRY,
  RateTesterDescriptive.JSON_PROPERTY_CONTINENT,
  RateTesterDescriptive.JSON_PROPERTY_IP_NUMBER,
  RateTesterDescriptive.JSON_PROPERTY_TIMEZONE,
  RateTesterDescriptive.JSON_PROPERTY_LATITUDE,
  RateTesterDescriptive.JSON_PROPERTY_LONGITUDE,
  RateTesterDescriptive.JSON_PROPERTY_POLICY
})
@JsonTypeName("RateTester_Descriptive")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-08-07T09:37:10.042040+07:00[Asia/Bangkok]")
public class RateTesterDescriptive {
  public static final String JSON_PROPERTY_HOTEL_IDENTIFIER = "hotelIdentifier";
  private String hotelIdentifier;

  public static final String JSON_PROPERTY_CHANNEL = "channel";
  private ChannelNameDescriptive channel;

  public static final String JSON_PROPERTY_STAY_START_DATE = "stayStartDate";
  private LocalDate stayStartDate;

  public static final String JSON_PROPERTY_STAY_END_DATE = "stayEndDate";
  private LocalDate stayEndDate;

  public static final String JSON_PROPERTY_ROOM_CONFIGURATIONS = "roomConfigurations";
  private List<RoomConfigurationDescriptive> roomConfigurations = new ArrayList<>();

  public static final String JSON_PROPERTY_CURRENCY = "currency";
  private String currency;

  public static final String JSON_PROPERTY_AUTHENTICATED = "authenticated";
  private Boolean authenticated;

  public static final String JSON_PROPERTY_BOOKING_DATE = "bookingDate";
  private LocalDate bookingDate;

  public static final String JSON_PROPERTY_SELL_START_DATE = "sellStartDate";
  private LocalDate sellStartDate;

  public static final String JSON_PROPERTY_SELL_END_DATE = "sellEndDate";
  private LocalDate sellEndDate;

  public static final String JSON_PROPERTY_PROMOTION = "promotion";
  private String promotion;

  public static final String JSON_PROPERTY_SOURCE_CURRENCY = "sourceCurrency";
  private String sourceCurrency;

  public static final String JSON_PROPERTY_CITY = "city";
  private GeoNameDescriptive city;

  public static final String JSON_PROPERTY_COUNTRY = "country";
  private GeoNameCountryDescriptive country;

  public static final String JSON_PROPERTY_CONTINENT = "continent";
  private String continent;

  public static final String JSON_PROPERTY_IP_NUMBER = "ipNumber";
  private String ipNumber;

  public static final String JSON_PROPERTY_TIMEZONE = "timezone";
  private String timezone;

  public static final String JSON_PROPERTY_LATITUDE = "latitude";
  private Double latitude;

  public static final String JSON_PROPERTY_LONGITUDE = "longitude";
  private Double longitude;

  public static final String JSON_PROPERTY_POLICY = "policy";
  private PropertyPolicyDescriptive policy;

  public RateTesterDescriptive() { 
  }

  public RateTesterDescriptive hotelIdentifier(String hotelIdentifier) {
    
    this.hotelIdentifier = hotelIdentifier;
    return this;
  }

   /**
   * Get hotelIdentifier
   * @return hotelIdentifier
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getHotelIdentifier() {
    return hotelIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setHotelIdentifier(String hotelIdentifier) {
    this.hotelIdentifier = hotelIdentifier;
  }


  public RateTesterDescriptive channel(ChannelNameDescriptive channel) {
    
    this.channel = channel;
    return this;
  }

   /**
   * Get channel
   * @return channel
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_CHANNEL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public ChannelNameDescriptive getChannel() {
    return channel;
  }


  @JsonProperty(JSON_PROPERTY_CHANNEL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setChannel(ChannelNameDescriptive channel) {
    this.channel = channel;
  }


  public RateTesterDescriptive stayStartDate(LocalDate stayStartDate) {
    
    this.stayStartDate = stayStartDate;
    return this;
  }

   /**
   * Get stayStartDate
   * @return stayStartDate
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_STAY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public LocalDate getStayStartDate() {
    return stayStartDate;
  }


  @JsonProperty(JSON_PROPERTY_STAY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setStayStartDate(LocalDate stayStartDate) {
    this.stayStartDate = stayStartDate;
  }


  public RateTesterDescriptive stayEndDate(LocalDate stayEndDate) {
    
    this.stayEndDate = stayEndDate;
    return this;
  }

   /**
   * Get stayEndDate
   * @return stayEndDate
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_STAY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public LocalDate getStayEndDate() {
    return stayEndDate;
  }


  @JsonProperty(JSON_PROPERTY_STAY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setStayEndDate(LocalDate stayEndDate) {
    this.stayEndDate = stayEndDate;
  }


  public RateTesterDescriptive roomConfigurations(List<RoomConfigurationDescriptive> roomConfigurations) {
    
    this.roomConfigurations = roomConfigurations;
    return this;
  }

  public RateTesterDescriptive addRoomConfigurationsItem(RoomConfigurationDescriptive roomConfigurationsItem) {
    this.roomConfigurations.add(roomConfigurationsItem);
    return this;
  }

   /**
   * Get roomConfigurations
   * @return roomConfigurations
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_ROOM_CONFIGURATIONS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<RoomConfigurationDescriptive> getRoomConfigurations() {
    return roomConfigurations;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_CONFIGURATIONS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRoomConfigurations(List<RoomConfigurationDescriptive> roomConfigurations) {
    this.roomConfigurations = roomConfigurations;
  }


  public RateTesterDescriptive currency(String currency) {
    
    this.currency = currency;
    return this;
  }

   /**
   * Get currency
   * @return currency
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getCurrency() {
    return currency;
  }


  @JsonProperty(JSON_PROPERTY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCurrency(String currency) {
    this.currency = currency;
  }


  public RateTesterDescriptive authenticated(Boolean authenticated) {
    
    this.authenticated = authenticated;
    return this;
  }

   /**
   * Get authenticated
   * @return authenticated
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_AUTHENTICATED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getAuthenticated() {
    return authenticated;
  }


  @JsonProperty(JSON_PROPERTY_AUTHENTICATED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAuthenticated(Boolean authenticated) {
    this.authenticated = authenticated;
  }


  public RateTesterDescriptive bookingDate(LocalDate bookingDate) {
    
    this.bookingDate = bookingDate;
    return this;
  }

   /**
   * Get bookingDate
   * @return bookingDate
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_BOOKING_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalDate getBookingDate() {
    return bookingDate;
  }


  @JsonProperty(JSON_PROPERTY_BOOKING_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBookingDate(LocalDate bookingDate) {
    this.bookingDate = bookingDate;
  }


  public RateTesterDescriptive sellStartDate(LocalDate sellStartDate) {
    
    this.sellStartDate = sellStartDate;
    return this;
  }

   /**
   * Get sellStartDate
   * @return sellStartDate
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SELL_START_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalDate getSellStartDate() {
    return sellStartDate;
  }


  @JsonProperty(JSON_PROPERTY_SELL_START_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSellStartDate(LocalDate sellStartDate) {
    this.sellStartDate = sellStartDate;
  }


  public RateTesterDescriptive sellEndDate(LocalDate sellEndDate) {
    
    this.sellEndDate = sellEndDate;
    return this;
  }

   /**
   * Get sellEndDate
   * @return sellEndDate
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SELL_END_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalDate getSellEndDate() {
    return sellEndDate;
  }


  @JsonProperty(JSON_PROPERTY_SELL_END_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSellEndDate(LocalDate sellEndDate) {
    this.sellEndDate = sellEndDate;
  }


  public RateTesterDescriptive promotion(String promotion) {
    
    this.promotion = promotion;
    return this;
  }

   /**
   * Get promotion
   * @return promotion
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PROMOTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPromotion() {
    return promotion;
  }


  @JsonProperty(JSON_PROPERTY_PROMOTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPromotion(String promotion) {
    this.promotion = promotion;
  }


  public RateTesterDescriptive sourceCurrency(String sourceCurrency) {
    
    this.sourceCurrency = sourceCurrency;
    return this;
  }

   /**
   * Get sourceCurrency
   * @return sourceCurrency
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SOURCE_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSourceCurrency() {
    return sourceCurrency;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceCurrency(String sourceCurrency) {
    this.sourceCurrency = sourceCurrency;
  }


  public RateTesterDescriptive city(GeoNameDescriptive city) {
    
    this.city = city;
    return this;
  }

   /**
   * Get city
   * @return city
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public GeoNameDescriptive getCity() {
    return city;
  }


  @JsonProperty(JSON_PROPERTY_CITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCity(GeoNameDescriptive city) {
    this.city = city;
  }


  public RateTesterDescriptive country(GeoNameCountryDescriptive country) {
    
    this.country = country;
    return this;
  }

   /**
   * Get country
   * @return country
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public GeoNameCountryDescriptive getCountry() {
    return country;
  }


  @JsonProperty(JSON_PROPERTY_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCountry(GeoNameCountryDescriptive country) {
    this.country = country;
  }


  public RateTesterDescriptive continent(String continent) {
    
    this.continent = continent;
    return this;
  }

   /**
   * Get continent
   * @return continent
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CONTINENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getContinent() {
    return continent;
  }


  @JsonProperty(JSON_PROPERTY_CONTINENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setContinent(String continent) {
    this.continent = continent;
  }


  public RateTesterDescriptive ipNumber(String ipNumber) {
    
    this.ipNumber = ipNumber;
    return this;
  }

   /**
   * Get ipNumber
   * @return ipNumber
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_IP_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getIpNumber() {
    return ipNumber;
  }


  @JsonProperty(JSON_PROPERTY_IP_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIpNumber(String ipNumber) {
    this.ipNumber = ipNumber;
  }


  public RateTesterDescriptive timezone(String timezone) {
    
    this.timezone = timezone;
    return this;
  }

   /**
   * Get timezone
   * @return timezone
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TIMEZONE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTimezone() {
    return timezone;
  }


  @JsonProperty(JSON_PROPERTY_TIMEZONE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTimezone(String timezone) {
    this.timezone = timezone;
  }


  public RateTesterDescriptive latitude(Double latitude) {
    
    this.latitude = latitude;
    return this;
  }

   /**
   * Get latitude
   * @return latitude
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_LATITUDE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getLatitude() {
    return latitude;
  }


  @JsonProperty(JSON_PROPERTY_LATITUDE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLatitude(Double latitude) {
    this.latitude = latitude;
  }


  public RateTesterDescriptive longitude(Double longitude) {
    
    this.longitude = longitude;
    return this;
  }

   /**
   * Get longitude
   * @return longitude
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_LONGITUDE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getLongitude() {
    return longitude;
  }


  @JsonProperty(JSON_PROPERTY_LONGITUDE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLongitude(Double longitude) {
    this.longitude = longitude;
  }


  public RateTesterDescriptive policy(PropertyPolicyDescriptive policy) {
    
    this.policy = policy;
    return this;
  }

   /**
   * Get policy
   * @return policy
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_POLICY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PropertyPolicyDescriptive getPolicy() {
    return policy;
  }


  @JsonProperty(JSON_PROPERTY_POLICY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPolicy(PropertyPolicyDescriptive policy) {
    this.policy = policy;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RateTesterDescriptive rateTesterDescriptive = (RateTesterDescriptive) o;
    return Objects.equals(this.hotelIdentifier, rateTesterDescriptive.hotelIdentifier) &&
        Objects.equals(this.channel, rateTesterDescriptive.channel) &&
        Objects.equals(this.stayStartDate, rateTesterDescriptive.stayStartDate) &&
        Objects.equals(this.stayEndDate, rateTesterDescriptive.stayEndDate) &&
        Objects.equals(this.roomConfigurations, rateTesterDescriptive.roomConfigurations) &&
        Objects.equals(this.currency, rateTesterDescriptive.currency) &&
        Objects.equals(this.authenticated, rateTesterDescriptive.authenticated) &&
        Objects.equals(this.bookingDate, rateTesterDescriptive.bookingDate) &&
        Objects.equals(this.sellStartDate, rateTesterDescriptive.sellStartDate) &&
        Objects.equals(this.sellEndDate, rateTesterDescriptive.sellEndDate) &&
        Objects.equals(this.promotion, rateTesterDescriptive.promotion) &&
        Objects.equals(this.sourceCurrency, rateTesterDescriptive.sourceCurrency) &&
        Objects.equals(this.city, rateTesterDescriptive.city) &&
        Objects.equals(this.country, rateTesterDescriptive.country) &&
        Objects.equals(this.continent, rateTesterDescriptive.continent) &&
        Objects.equals(this.ipNumber, rateTesterDescriptive.ipNumber) &&
        Objects.equals(this.timezone, rateTesterDescriptive.timezone) &&
        Objects.equals(this.latitude, rateTesterDescriptive.latitude) &&
        Objects.equals(this.longitude, rateTesterDescriptive.longitude) &&
        Objects.equals(this.policy, rateTesterDescriptive.policy);
  }

  @Override
  public int hashCode() {
    return Objects.hash(hotelIdentifier, channel, stayStartDate, stayEndDate, roomConfigurations, currency, authenticated, bookingDate, sellStartDate, sellEndDate, promotion, sourceCurrency, city, country, continent, ipNumber, timezone, latitude, longitude, policy);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RateTesterDescriptive {\n");
    sb.append("    hotelIdentifier: ").append(toIndentedString(hotelIdentifier)).append("\n");
    sb.append("    channel: ").append(toIndentedString(channel)).append("\n");
    sb.append("    stayStartDate: ").append(toIndentedString(stayStartDate)).append("\n");
    sb.append("    stayEndDate: ").append(toIndentedString(stayEndDate)).append("\n");
    sb.append("    roomConfigurations: ").append(toIndentedString(roomConfigurations)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    authenticated: ").append(toIndentedString(authenticated)).append("\n");
    sb.append("    bookingDate: ").append(toIndentedString(bookingDate)).append("\n");
    sb.append("    sellStartDate: ").append(toIndentedString(sellStartDate)).append("\n");
    sb.append("    sellEndDate: ").append(toIndentedString(sellEndDate)).append("\n");
    sb.append("    promotion: ").append(toIndentedString(promotion)).append("\n");
    sb.append("    sourceCurrency: ").append(toIndentedString(sourceCurrency)).append("\n");
    sb.append("    city: ").append(toIndentedString(city)).append("\n");
    sb.append("    country: ").append(toIndentedString(country)).append("\n");
    sb.append("    continent: ").append(toIndentedString(continent)).append("\n");
    sb.append("    ipNumber: ").append(toIndentedString(ipNumber)).append("\n");
    sb.append("    timezone: ").append(toIndentedString(timezone)).append("\n");
    sb.append("    latitude: ").append(toIndentedString(latitude)).append("\n");
    sb.append("    longitude: ").append(toIndentedString(longitude)).append("\n");
    sb.append("    policy: ").append(toIndentedString(policy)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

