/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/docs?api=affiliate): All APIs related to selling travel inventory as an affiliate. - [Extranet](/docs?api=extranet): All APIs related to managing travel inventory and suppliers. - [Booking Engine](/docs?api=booking-engine): All APIs related to searching for travel inventory and creating bookings. - [Channel Manager](https://integration.wink.travel/docs?api=channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Events](https://integration.wink.travel/docs?api=events):  All APIs related to Integration events.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.payment-v`1`+json.  ## Release history - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Extranet API Welcome to the Extranet API - A programmer-friendly way to manage your travel inventory on the wink payment. This API offers a superset of the features you can find at [https://extranet.wink.travel](https://extranet.wink.travel) and gives you all the tools you need to ready your properties and inventory for sale across 10000s of our unique sales channels. What differentiates us from existing Extranets is 1. we make it available for everyone to use and 2. the care we take in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Content creators have the ability to make their inventory look great and be searchable in a wide variety of ways. You won't find properties with generic inventory, low resolution pictures and little ancillary content that can easily be found everywhere else on the internet.  # Integrations We have already integrated with the most well-known channel managers so you don't have to. Once your properties are set up, you can finish the setup by mapping your property to wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API. - Allotz - CloudBeds / MyAllocator - Comanche - d-edge - FastBooking - HotelLink - HoteliersGuru - Omnibees - RateGain - Rate Tiger - ResAvenue - Siteminder - Sabre SynXis - Travelclick - Yieldplanet  # Intended Audience Programmers are [most likely] a requirement to start integrating with wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible. - Hotel chains - Hotel brands - Travel tech companies - Destination sites - Integrators - Aggregators - Destination management companies - Travel agencies - OTAs  
 *
 * The version of the OpenAPI document: 21.4.3-SNAPSHOT
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.extranet.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import travel.wink.sdk.extranet.model.AddOnOfferDescriptive;
import travel.wink.sdk.extranet.model.CancellationPolicyDescriptive;
import travel.wink.sdk.extranet.model.ExtraChargesDescriptive;
import travel.wink.sdk.extranet.model.MoneysDescriptive;
import travel.wink.sdk.extranet.model.PackageOfferDescriptive;
import travel.wink.sdk.extranet.model.RatePlanDescriptive;
import travel.wink.sdk.extranet.model.RoomConfigurationDescriptive;
import travel.wink.sdk.extranet.model.SimpleDescriptionDescriptive;
import travel.wink.sdk.extranet.model.StayRateDescriptive;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * RoomConfigurationPriceDescriptive
 */
@JsonPropertyOrder({
  RoomConfigurationPriceDescriptive.JSON_PROPERTY_ADULTS,
  RoomConfigurationPriceDescriptive.JSON_PROPERTY_CHILDREN,
  RoomConfigurationPriceDescriptive.JSON_PROPERTY_START_DATE,
  RoomConfigurationPriceDescriptive.JSON_PROPERTY_END_DATE,
  RoomConfigurationPriceDescriptive.JSON_PROPERTY_ROOM_RATE_IDENTIFIER,
  RoomConfigurationPriceDescriptive.JSON_PROPERTY_ROOM_RATE_INTERNAL_NAME,
  RoomConfigurationPriceDescriptive.JSON_PROPERTY_RATE_PLAN,
  RoomConfigurationPriceDescriptive.JSON_PROPERTY_PERK_TYPES,
  RoomConfigurationPriceDescriptive.JSON_PROPERTY_PRICE,
  RoomConfigurationPriceDescriptive.JSON_PROPERTY_EXTRA_CHARGES,
  RoomConfigurationPriceDescriptive.JSON_PROPERTY_CONFIGURATION,
  RoomConfigurationPriceDescriptive.JSON_PROPERTY_PACKAGE_OFFERS,
  RoomConfigurationPriceDescriptive.JSON_PROPERTY_ADD_ON_OFFERS,
  RoomConfigurationPriceDescriptive.JSON_PROPERTY_PERK_VALUE,
  RoomConfigurationPriceDescriptive.JSON_PROPERTY_ACTIVE_CANCELLATION_POLICY,
  RoomConfigurationPriceDescriptive.JSON_PROPERTY_ROOM_NIGHTS,
  RoomConfigurationPriceDescriptive.JSON_PROPERTY_AVAILABLE,
  RoomConfigurationPriceDescriptive.JSON_PROPERTY_PROMOTION,
  RoomConfigurationPriceDescriptive.JSON_PROPERTY_SOURCE_TOTAL,
  RoomConfigurationPriceDescriptive.JSON_PROPERTY_INTERNAL_TOTAL,
  RoomConfigurationPriceDescriptive.JSON_PROPERTY_OFFER_DETAILS,
  RoomConfigurationPriceDescriptive.JSON_PROPERTY_RATE_SOURCE,
  RoomConfigurationPriceDescriptive.JSON_PROPERTY_USER_SPECIFIED_CURRENCY_TOTAL
})
@JsonTypeName("RoomConfigurationPrice_Descriptive")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-08-07T09:37:10.042040+07:00[Asia/Bangkok]")
public class RoomConfigurationPriceDescriptive {
  public static final String JSON_PROPERTY_ADULTS = "adults";
  private Integer adults;

  public static final String JSON_PROPERTY_CHILDREN = "children";
  private Integer children;

  public static final String JSON_PROPERTY_START_DATE = "startDate";
  private LocalDate startDate;

  public static final String JSON_PROPERTY_END_DATE = "endDate";
  private LocalDate endDate;

  public static final String JSON_PROPERTY_ROOM_RATE_IDENTIFIER = "roomRateIdentifier";
  private String roomRateIdentifier;

  public static final String JSON_PROPERTY_ROOM_RATE_INTERNAL_NAME = "roomRateInternalName";
  private String roomRateInternalName;

  public static final String JSON_PROPERTY_RATE_PLAN = "ratePlan";
  private RatePlanDescriptive ratePlan;

  /**
   * Gets or Sets perkTypes
   */
  public enum PerkTypesEnum {
    LOYALTY_POINTS("PERK_LOYALTY_POINTS"),
    
    WINE("PERK_WINE"),
    
    FREE_DRINK_VOUCHER("PERK_FREE_DRINK_VOUCHER"),
    
    FREE_MEAL_TWO_PEOPLE("PERK_FREE_MEAL_TWO_PEOPLE"),
    
    FREE_ONE_HOUR_MASSAGE("PERK_FREE_ONE_HOUR_MASSAGE"),
    
    TWENTY_PERCENT_FOOD_BEVERAGE_DISCOUNT("PERK_TWENTY_PERCENT_FOOD_BEVERAGE_DISCOUNT"),
    
    TWENTY_PERCENT_SPA_DISCOUNT_VOUCHER("PERK_TWENTY_PERCENT_SPA_DISCOUNT_VOUCHER"),
    
    GUARANTEED_UPGRADE("PERK_GUARANTEED_UPGRADE"),
    
    EARLY_CHECKIN("PERK_EARLY_CHECKIN"),
    
    ROOM_UPGRADE("PERK_ROOM_UPGRADE"),
    
    LATE_CHECKOUT("PERK_LATE_CHECKOUT"),
    
    AIRPORT_TRANSFER("PERK_AIRPORT_TRANSFER"),
    
    AIRPORT_PICK_UP("PERK_AIRPORT_PICK_UP"),
    
    BOTTLE_CHAMPAGNE_ON_ARRIVAL("PERK_BOTTLE_CHAMPAGNE_ON_ARRIVAL"),
    
    BOTTLE_SPARKLING_WINE_ON_ARRIVAL("PERK_BOTTLE_SPARKLING_WINE_ON_ARRIVAL"),
    
    BOTTLE_WINE_ON_ARRIVAL("PERK_BOTTLE_WINE_ON_ARRIVAL");

    private String value;

    PerkTypesEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PerkTypesEnum fromValue(String value) {
      for (PerkTypesEnum b : PerkTypesEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PERK_TYPES = "perkTypes";
  private List<PerkTypesEnum> perkTypes = null;

  public static final String JSON_PROPERTY_PRICE = "price";
  private StayRateDescriptive price;

  public static final String JSON_PROPERTY_EXTRA_CHARGES = "extraCharges";
  private ExtraChargesDescriptive extraCharges;

  public static final String JSON_PROPERTY_CONFIGURATION = "configuration";
  private RoomConfigurationDescriptive _configuration;

  public static final String JSON_PROPERTY_PACKAGE_OFFERS = "packageOffers";
  private List<PackageOfferDescriptive> packageOffers = null;

  public static final String JSON_PROPERTY_ADD_ON_OFFERS = "addOnOffers";
  private List<AddOnOfferDescriptive> addOnOffers = null;

  public static final String JSON_PROPERTY_PERK_VALUE = "perkValue";
  private Integer perkValue;

  public static final String JSON_PROPERTY_ACTIVE_CANCELLATION_POLICY = "activeCancellationPolicy";
  private CancellationPolicyDescriptive activeCancellationPolicy;

  public static final String JSON_PROPERTY_ROOM_NIGHTS = "roomNights";
  private Long roomNights;

  public static final String JSON_PROPERTY_AVAILABLE = "available";
  private Boolean available;

  public static final String JSON_PROPERTY_PROMOTION = "promotion";
  private List<String> promotion = null;

  public static final String JSON_PROPERTY_SOURCE_TOTAL = "sourceTotal";
  private MoneysDescriptive sourceTotal;

  public static final String JSON_PROPERTY_INTERNAL_TOTAL = "internalTotal";
  private MoneysDescriptive internalTotal;

  public static final String JSON_PROPERTY_OFFER_DETAILS = "offerDetails";
  private List<SimpleDescriptionDescriptive> offerDetails = null;

  /**
   * Gets or Sets rateSource
   */
  public enum RateSourceEnum {
    TRAVELIKO("TRAVELIKO"),
    
    SITEMINDER("SITEMINDER"),
    
    FASTBOOKING("FASTBOOKING"),
    
    RATEGAIN("RATEGAIN"),
    
    CLOUD_BEDS("CLOUD_BEDS"),
    
    YIELD_PLANET("YIELD_PLANET"),
    
    TRAVELCLICK("TRAVELCLICK"),
    
    HOTEL_GURU("HOTEL_GURU"),
    
    OTHER_CHANNEL_MANAGER("OTHER_CHANNEL_MANAGER"),
    
    BOOKING_JINI("BOOKING_JINI"),
    
    HOTEL_LINK_SOLUTIONS("HOTEL_LINK_SOLUTIONS"),
    
    ALLOTZ("ALLOTZ"),
    
    DEDGE("DEDGE"),
    
    RATE_TIGER("RATE_TIGER"),
    
    RESAVENUE("RESAVENUE"),
    
    COMANCHE("COMANCHE"),
    
    OMNIBEES("OMNIBEES"),
    
    EZEE("EZEE"),
    
    SYNXIS("SYNXIS");

    private String value;

    RateSourceEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static RateSourceEnum fromValue(String value) {
      for (RateSourceEnum b : RateSourceEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_RATE_SOURCE = "rateSource";
  private RateSourceEnum rateSource;

  public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_TOTAL = "userSpecifiedCurrencyTotal";
  private MoneysDescriptive userSpecifiedCurrencyTotal;

  public RoomConfigurationPriceDescriptive() { 
  }

  public RoomConfigurationPriceDescriptive adults(Integer adults) {
    
    this.adults = adults;
    return this;
  }

   /**
   * Get adults
   * @return adults
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ADULTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getAdults() {
    return adults;
  }


  @JsonProperty(JSON_PROPERTY_ADULTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAdults(Integer adults) {
    this.adults = adults;
  }


  public RoomConfigurationPriceDescriptive children(Integer children) {
    
    this.children = children;
    return this;
  }

   /**
   * Get children
   * @return children
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CHILDREN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getChildren() {
    return children;
  }


  @JsonProperty(JSON_PROPERTY_CHILDREN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setChildren(Integer children) {
    this.children = children;
  }


  public RoomConfigurationPriceDescriptive startDate(LocalDate startDate) {
    
    this.startDate = startDate;
    return this;
  }

   /**
   * Get startDate
   * @return startDate
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalDate getStartDate() {
    return startDate;
  }


  @JsonProperty(JSON_PROPERTY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStartDate(LocalDate startDate) {
    this.startDate = startDate;
  }


  public RoomConfigurationPriceDescriptive endDate(LocalDate endDate) {
    
    this.endDate = endDate;
    return this;
  }

   /**
   * Get endDate
   * @return endDate
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalDate getEndDate() {
    return endDate;
  }


  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEndDate(LocalDate endDate) {
    this.endDate = endDate;
  }


  public RoomConfigurationPriceDescriptive roomRateIdentifier(String roomRateIdentifier) {
    
    this.roomRateIdentifier = roomRateIdentifier;
    return this;
  }

   /**
   * Get roomRateIdentifier
   * @return roomRateIdentifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ROOM_RATE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRoomRateIdentifier() {
    return roomRateIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_RATE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRoomRateIdentifier(String roomRateIdentifier) {
    this.roomRateIdentifier = roomRateIdentifier;
  }


  public RoomConfigurationPriceDescriptive roomRateInternalName(String roomRateInternalName) {
    
    this.roomRateInternalName = roomRateInternalName;
    return this;
  }

   /**
   * Get roomRateInternalName
   * @return roomRateInternalName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ROOM_RATE_INTERNAL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRoomRateInternalName() {
    return roomRateInternalName;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_RATE_INTERNAL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRoomRateInternalName(String roomRateInternalName) {
    this.roomRateInternalName = roomRateInternalName;
  }


  public RoomConfigurationPriceDescriptive ratePlan(RatePlanDescriptive ratePlan) {
    
    this.ratePlan = ratePlan;
    return this;
  }

   /**
   * Get ratePlan
   * @return ratePlan
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_RATE_PLAN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public RatePlanDescriptive getRatePlan() {
    return ratePlan;
  }


  @JsonProperty(JSON_PROPERTY_RATE_PLAN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRatePlan(RatePlanDescriptive ratePlan) {
    this.ratePlan = ratePlan;
  }


  public RoomConfigurationPriceDescriptive perkTypes(List<PerkTypesEnum> perkTypes) {
    
    this.perkTypes = perkTypes;
    return this;
  }

  public RoomConfigurationPriceDescriptive addPerkTypesItem(PerkTypesEnum perkTypesItem) {
    if (this.perkTypes == null) {
      this.perkTypes = new ArrayList<>();
    }
    this.perkTypes.add(perkTypesItem);
    return this;
  }

   /**
   * Get perkTypes
   * @return perkTypes
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PERK_TYPES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<PerkTypesEnum> getPerkTypes() {
    return perkTypes;
  }


  @JsonProperty(JSON_PROPERTY_PERK_TYPES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPerkTypes(List<PerkTypesEnum> perkTypes) {
    this.perkTypes = perkTypes;
  }


  public RoomConfigurationPriceDescriptive price(StayRateDescriptive price) {
    
    this.price = price;
    return this;
  }

   /**
   * Get price
   * @return price
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public StayRateDescriptive getPrice() {
    return price;
  }


  @JsonProperty(JSON_PROPERTY_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPrice(StayRateDescriptive price) {
    this.price = price;
  }


  public RoomConfigurationPriceDescriptive extraCharges(ExtraChargesDescriptive extraCharges) {
    
    this.extraCharges = extraCharges;
    return this;
  }

   /**
   * Get extraCharges
   * @return extraCharges
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_EXTRA_CHARGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ExtraChargesDescriptive getExtraCharges() {
    return extraCharges;
  }


  @JsonProperty(JSON_PROPERTY_EXTRA_CHARGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExtraCharges(ExtraChargesDescriptive extraCharges) {
    this.extraCharges = extraCharges;
  }


  public RoomConfigurationPriceDescriptive _configuration(RoomConfigurationDescriptive _configuration) {
    
    this._configuration = _configuration;
    return this;
  }

   /**
   * Get _configuration
   * @return _configuration
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CONFIGURATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public RoomConfigurationDescriptive getConfiguration() {
    return _configuration;
  }


  @JsonProperty(JSON_PROPERTY_CONFIGURATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setConfiguration(RoomConfigurationDescriptive _configuration) {
    this._configuration = _configuration;
  }


  public RoomConfigurationPriceDescriptive packageOffers(List<PackageOfferDescriptive> packageOffers) {
    
    this.packageOffers = packageOffers;
    return this;
  }

  public RoomConfigurationPriceDescriptive addPackageOffersItem(PackageOfferDescriptive packageOffersItem) {
    if (this.packageOffers == null) {
      this.packageOffers = new ArrayList<>();
    }
    this.packageOffers.add(packageOffersItem);
    return this;
  }

   /**
   * Get packageOffers
   * @return packageOffers
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PACKAGE_OFFERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<PackageOfferDescriptive> getPackageOffers() {
    return packageOffers;
  }


  @JsonProperty(JSON_PROPERTY_PACKAGE_OFFERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPackageOffers(List<PackageOfferDescriptive> packageOffers) {
    this.packageOffers = packageOffers;
  }


  public RoomConfigurationPriceDescriptive addOnOffers(List<AddOnOfferDescriptive> addOnOffers) {
    
    this.addOnOffers = addOnOffers;
    return this;
  }

  public RoomConfigurationPriceDescriptive addAddOnOffersItem(AddOnOfferDescriptive addOnOffersItem) {
    if (this.addOnOffers == null) {
      this.addOnOffers = new ArrayList<>();
    }
    this.addOnOffers.add(addOnOffersItem);
    return this;
  }

   /**
   * Get addOnOffers
   * @return addOnOffers
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ADD_ON_OFFERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<AddOnOfferDescriptive> getAddOnOffers() {
    return addOnOffers;
  }


  @JsonProperty(JSON_PROPERTY_ADD_ON_OFFERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAddOnOffers(List<AddOnOfferDescriptive> addOnOffers) {
    this.addOnOffers = addOnOffers;
  }


  public RoomConfigurationPriceDescriptive perkValue(Integer perkValue) {
    
    this.perkValue = perkValue;
    return this;
  }

   /**
   * Get perkValue
   * @return perkValue
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PERK_VALUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getPerkValue() {
    return perkValue;
  }


  @JsonProperty(JSON_PROPERTY_PERK_VALUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPerkValue(Integer perkValue) {
    this.perkValue = perkValue;
  }


  public RoomConfigurationPriceDescriptive activeCancellationPolicy(CancellationPolicyDescriptive activeCancellationPolicy) {
    
    this.activeCancellationPolicy = activeCancellationPolicy;
    return this;
  }

   /**
   * Get activeCancellationPolicy
   * @return activeCancellationPolicy
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ACTIVE_CANCELLATION_POLICY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CancellationPolicyDescriptive getActiveCancellationPolicy() {
    return activeCancellationPolicy;
  }


  @JsonProperty(JSON_PROPERTY_ACTIVE_CANCELLATION_POLICY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setActiveCancellationPolicy(CancellationPolicyDescriptive activeCancellationPolicy) {
    this.activeCancellationPolicy = activeCancellationPolicy;
  }


  public RoomConfigurationPriceDescriptive roomNights(Long roomNights) {
    
    this.roomNights = roomNights;
    return this;
  }

   /**
   * Get roomNights
   * @return roomNights
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ROOM_NIGHTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getRoomNights() {
    return roomNights;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_NIGHTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRoomNights(Long roomNights) {
    this.roomNights = roomNights;
  }


  public RoomConfigurationPriceDescriptive available(Boolean available) {
    
    this.available = available;
    return this;
  }

   /**
   * Get available
   * @return available
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_AVAILABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getAvailable() {
    return available;
  }


  @JsonProperty(JSON_PROPERTY_AVAILABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAvailable(Boolean available) {
    this.available = available;
  }


  public RoomConfigurationPriceDescriptive promotion(List<String> promotion) {
    
    this.promotion = promotion;
    return this;
  }

  public RoomConfigurationPriceDescriptive addPromotionItem(String promotionItem) {
    if (this.promotion == null) {
      this.promotion = new ArrayList<>();
    }
    this.promotion.add(promotionItem);
    return this;
  }

   /**
   * Get promotion
   * @return promotion
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PROMOTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getPromotion() {
    return promotion;
  }


  @JsonProperty(JSON_PROPERTY_PROMOTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPromotion(List<String> promotion) {
    this.promotion = promotion;
  }


  public RoomConfigurationPriceDescriptive sourceTotal(MoneysDescriptive sourceTotal) {
    
    this.sourceTotal = sourceTotal;
    return this;
  }

   /**
   * Get sourceTotal
   * @return sourceTotal
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SOURCE_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MoneysDescriptive getSourceTotal() {
    return sourceTotal;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceTotal(MoneysDescriptive sourceTotal) {
    this.sourceTotal = sourceTotal;
  }


  public RoomConfigurationPriceDescriptive internalTotal(MoneysDescriptive internalTotal) {
    
    this.internalTotal = internalTotal;
    return this;
  }

   /**
   * Get internalTotal
   * @return internalTotal
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_INTERNAL_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MoneysDescriptive getInternalTotal() {
    return internalTotal;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalTotal(MoneysDescriptive internalTotal) {
    this.internalTotal = internalTotal;
  }


  public RoomConfigurationPriceDescriptive offerDetails(List<SimpleDescriptionDescriptive> offerDetails) {
    
    this.offerDetails = offerDetails;
    return this;
  }

  public RoomConfigurationPriceDescriptive addOfferDetailsItem(SimpleDescriptionDescriptive offerDetailsItem) {
    if (this.offerDetails == null) {
      this.offerDetails = new ArrayList<>();
    }
    this.offerDetails.add(offerDetailsItem);
    return this;
  }

   /**
   * Get offerDetails
   * @return offerDetails
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_OFFER_DETAILS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<SimpleDescriptionDescriptive> getOfferDetails() {
    return offerDetails;
  }


  @JsonProperty(JSON_PROPERTY_OFFER_DETAILS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOfferDetails(List<SimpleDescriptionDescriptive> offerDetails) {
    this.offerDetails = offerDetails;
  }


  public RoomConfigurationPriceDescriptive rateSource(RateSourceEnum rateSource) {
    
    this.rateSource = rateSource;
    return this;
  }

   /**
   * Get rateSource
   * @return rateSource
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_RATE_SOURCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public RateSourceEnum getRateSource() {
    return rateSource;
  }


  @JsonProperty(JSON_PROPERTY_RATE_SOURCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRateSource(RateSourceEnum rateSource) {
    this.rateSource = rateSource;
  }


  public RoomConfigurationPriceDescriptive userSpecifiedCurrencyTotal(MoneysDescriptive userSpecifiedCurrencyTotal) {
    
    this.userSpecifiedCurrencyTotal = userSpecifiedCurrencyTotal;
    return this;
  }

   /**
   * Get userSpecifiedCurrencyTotal
   * @return userSpecifiedCurrencyTotal
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MoneysDescriptive getUserSpecifiedCurrencyTotal() {
    return userSpecifiedCurrencyTotal;
  }


  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserSpecifiedCurrencyTotal(MoneysDescriptive userSpecifiedCurrencyTotal) {
    this.userSpecifiedCurrencyTotal = userSpecifiedCurrencyTotal;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RoomConfigurationPriceDescriptive roomConfigurationPriceDescriptive = (RoomConfigurationPriceDescriptive) o;
    return Objects.equals(this.adults, roomConfigurationPriceDescriptive.adults) &&
        Objects.equals(this.children, roomConfigurationPriceDescriptive.children) &&
        Objects.equals(this.startDate, roomConfigurationPriceDescriptive.startDate) &&
        Objects.equals(this.endDate, roomConfigurationPriceDescriptive.endDate) &&
        Objects.equals(this.roomRateIdentifier, roomConfigurationPriceDescriptive.roomRateIdentifier) &&
        Objects.equals(this.roomRateInternalName, roomConfigurationPriceDescriptive.roomRateInternalName) &&
        Objects.equals(this.ratePlan, roomConfigurationPriceDescriptive.ratePlan) &&
        Objects.equals(this.perkTypes, roomConfigurationPriceDescriptive.perkTypes) &&
        Objects.equals(this.price, roomConfigurationPriceDescriptive.price) &&
        Objects.equals(this.extraCharges, roomConfigurationPriceDescriptive.extraCharges) &&
        Objects.equals(this._configuration, roomConfigurationPriceDescriptive._configuration) &&
        Objects.equals(this.packageOffers, roomConfigurationPriceDescriptive.packageOffers) &&
        Objects.equals(this.addOnOffers, roomConfigurationPriceDescriptive.addOnOffers) &&
        Objects.equals(this.perkValue, roomConfigurationPriceDescriptive.perkValue) &&
        Objects.equals(this.activeCancellationPolicy, roomConfigurationPriceDescriptive.activeCancellationPolicy) &&
        Objects.equals(this.roomNights, roomConfigurationPriceDescriptive.roomNights) &&
        Objects.equals(this.available, roomConfigurationPriceDescriptive.available) &&
        Objects.equals(this.promotion, roomConfigurationPriceDescriptive.promotion) &&
        Objects.equals(this.sourceTotal, roomConfigurationPriceDescriptive.sourceTotal) &&
        Objects.equals(this.internalTotal, roomConfigurationPriceDescriptive.internalTotal) &&
        Objects.equals(this.offerDetails, roomConfigurationPriceDescriptive.offerDetails) &&
        Objects.equals(this.rateSource, roomConfigurationPriceDescriptive.rateSource) &&
        Objects.equals(this.userSpecifiedCurrencyTotal, roomConfigurationPriceDescriptive.userSpecifiedCurrencyTotal);
  }

  @Override
  public int hashCode() {
    return Objects.hash(adults, children, startDate, endDate, roomRateIdentifier, roomRateInternalName, ratePlan, perkTypes, price, extraCharges, _configuration, packageOffers, addOnOffers, perkValue, activeCancellationPolicy, roomNights, available, promotion, sourceTotal, internalTotal, offerDetails, rateSource, userSpecifiedCurrencyTotal);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RoomConfigurationPriceDescriptive {\n");
    sb.append("    adults: ").append(toIndentedString(adults)).append("\n");
    sb.append("    children: ").append(toIndentedString(children)).append("\n");
    sb.append("    startDate: ").append(toIndentedString(startDate)).append("\n");
    sb.append("    endDate: ").append(toIndentedString(endDate)).append("\n");
    sb.append("    roomRateIdentifier: ").append(toIndentedString(roomRateIdentifier)).append("\n");
    sb.append("    roomRateInternalName: ").append(toIndentedString(roomRateInternalName)).append("\n");
    sb.append("    ratePlan: ").append(toIndentedString(ratePlan)).append("\n");
    sb.append("    perkTypes: ").append(toIndentedString(perkTypes)).append("\n");
    sb.append("    price: ").append(toIndentedString(price)).append("\n");
    sb.append("    extraCharges: ").append(toIndentedString(extraCharges)).append("\n");
    sb.append("    _configuration: ").append(toIndentedString(_configuration)).append("\n");
    sb.append("    packageOffers: ").append(toIndentedString(packageOffers)).append("\n");
    sb.append("    addOnOffers: ").append(toIndentedString(addOnOffers)).append("\n");
    sb.append("    perkValue: ").append(toIndentedString(perkValue)).append("\n");
    sb.append("    activeCancellationPolicy: ").append(toIndentedString(activeCancellationPolicy)).append("\n");
    sb.append("    roomNights: ").append(toIndentedString(roomNights)).append("\n");
    sb.append("    available: ").append(toIndentedString(available)).append("\n");
    sb.append("    promotion: ").append(toIndentedString(promotion)).append("\n");
    sb.append("    sourceTotal: ").append(toIndentedString(sourceTotal)).append("\n");
    sb.append("    internalTotal: ").append(toIndentedString(internalTotal)).append("\n");
    sb.append("    offerDetails: ").append(toIndentedString(offerDetails)).append("\n");
    sb.append("    rateSource: ").append(toIndentedString(rateSource)).append("\n");
    sb.append("    userSpecifiedCurrencyTotal: ").append(toIndentedString(userSpecifiedCurrencyTotal)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

