/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.api;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.extranet.invoker.ApiClient;
import travel.wink.sdk.extranet.model.InventoryUpdateRequest;
import travel.wink.sdk.extranet.model.RemoveEntryResponse;
import travel.wink.sdk.extranet.model.SalesChannel;
import travel.wink.sdk.extranet.model.SalesChannelCreateRequest;
import travel.wink.sdk.extranet.model.SalesChannelUpdateRequest;
import travel.wink.sdk.extranet.model.SelectableKeyValuePair;

public class SalesChannelsApi {
    private ApiClient apiClient;

    public SalesChannelsApi() {
        this(new ApiClient());
    }

    @Autowired
    public SalesChannelsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec createSalesChannelRequestCreation(String hotelIdentifier, SalesChannelCreateRequest salesChannelCreateRequest) throws WebClientResponseException {
        SalesChannelCreateRequest postBody = salesChannelCreateRequest;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling createSalesChannel", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (salesChannelCreateRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'salesChannelCreateRequest' when calling createSalesChannel", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/vnd.platform-v1+json", "application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<SalesChannel> localVarReturnType = new ParameterizedTypeReference<SalesChannel>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/sales/account", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SalesChannel> createSalesChannel(String hotelIdentifier, SalesChannelCreateRequest salesChannelCreateRequest) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannel> localVarReturnType = new ParameterizedTypeReference<SalesChannel>(){};
        return this.createSalesChannelRequestCreation(hotelIdentifier, salesChannelCreateRequest).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SalesChannel>> createSalesChannelWithHttpInfo(String hotelIdentifier, SalesChannelCreateRequest salesChannelCreateRequest) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannel> localVarReturnType = new ParameterizedTypeReference<SalesChannel>(){};
        return this.createSalesChannelRequestCreation(hotelIdentifier, salesChannelCreateRequest).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec removeSalesChannelRequestCreation(String hotelIdentifier, String salesChannelIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling removeSalesChannel", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (salesChannelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'salesChannelIdentifier' when calling removeSalesChannel", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("salesChannelIdentifier", salesChannelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/sales/account/{salesChannelIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RemoveEntryResponse> removeSalesChannel(String hotelIdentifier, String salesChannelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>(){};
        return this.removeSalesChannelRequestCreation(hotelIdentifier, salesChannelIdentifier, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RemoveEntryResponse>> removeSalesChannelWithHttpInfo(String hotelIdentifier, String salesChannelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>(){};
        return this.removeSalesChannelRequestCreation(hotelIdentifier, salesChannelIdentifier, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showAccountsRequestCreation(String hotelIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showAccounts", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<SalesChannel> localVarReturnType = new ParameterizedTypeReference<SalesChannel>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/sales/account/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<SalesChannel> showAccounts(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannel> localVarReturnType = new ParameterizedTypeReference<SalesChannel>(){};
        return this.showAccountsRequestCreation(hotelIdentifier, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<SalesChannel>>> showAccountsWithHttpInfo(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannel> localVarReturnType = new ParameterizedTypeReference<SalesChannel>(){};
        return this.showAccountsRequestCreation(hotelIdentifier, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showSalesChannelRequestCreation(String hotelIdentifier, String salesChannelIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showSalesChannel", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (salesChannelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'salesChannelIdentifier' when calling showSalesChannel", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("salesChannelIdentifier", salesChannelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<SalesChannel> localVarReturnType = new ParameterizedTypeReference<SalesChannel>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/sales/account/{salesChannelIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SalesChannel> showSalesChannel(String hotelIdentifier, String salesChannelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannel> localVarReturnType = new ParameterizedTypeReference<SalesChannel>(){};
        return this.showSalesChannelRequestCreation(hotelIdentifier, salesChannelIdentifier, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SalesChannel>> showSalesChannelWithHttpInfo(String hotelIdentifier, String salesChannelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannel> localVarReturnType = new ParameterizedTypeReference<SalesChannel>(){};
        return this.showSalesChannelRequestCreation(hotelIdentifier, salesChannelIdentifier, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showSalesChannelContextRateModifierBundlePairsRequestCreation(String hotelIdentifier, String rateModifierBundleIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showSalesChannelContextRateModifierBundlePairs", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (rateModifierBundleIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'rateModifierBundleIdentifier' when calling showSalesChannelContextRateModifierBundlePairs", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("rateModifierBundleIdentifier", rateModifierBundleIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<SelectableKeyValuePair> localVarReturnType = new ParameterizedTypeReference<SelectableKeyValuePair>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/sales/account/promobundle/{rateModifierBundleIdentifier}/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<SelectableKeyValuePair> showSalesChannelContextRateModifierBundlePairs(String hotelIdentifier, String rateModifierBundleIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SelectableKeyValuePair> localVarReturnType = new ParameterizedTypeReference<SelectableKeyValuePair>(){};
        return this.showSalesChannelContextRateModifierBundlePairsRequestCreation(hotelIdentifier, rateModifierBundleIdentifier, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<SelectableKeyValuePair>>> showSalesChannelContextRateModifierBundlePairsWithHttpInfo(String hotelIdentifier, String rateModifierBundleIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SelectableKeyValuePair> localVarReturnType = new ParameterizedTypeReference<SelectableKeyValuePair>(){};
        return this.showSalesChannelContextRateModifierBundlePairsRequestCreation(hotelIdentifier, rateModifierBundleIdentifier, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showSalesChannelContextRateModifierPairsRequestCreation(String hotelIdentifier, String rateModifierIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showSalesChannelContextRateModifierPairs", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (rateModifierIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'rateModifierIdentifier' when calling showSalesChannelContextRateModifierPairs", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("rateModifierIdentifier", rateModifierIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<SelectableKeyValuePair> localVarReturnType = new ParameterizedTypeReference<SelectableKeyValuePair>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/sales/account/promo/{rateModifierIdentifier}/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<SelectableKeyValuePair> showSalesChannelContextRateModifierPairs(String hotelIdentifier, String rateModifierIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SelectableKeyValuePair> localVarReturnType = new ParameterizedTypeReference<SelectableKeyValuePair>(){};
        return this.showSalesChannelContextRateModifierPairsRequestCreation(hotelIdentifier, rateModifierIdentifier, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<SelectableKeyValuePair>>> showSalesChannelContextRateModifierPairsWithHttpInfo(String hotelIdentifier, String rateModifierIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SelectableKeyValuePair> localVarReturnType = new ParameterizedTypeReference<SelectableKeyValuePair>(){};
        return this.showSalesChannelContextRateModifierPairsRequestCreation(hotelIdentifier, rateModifierIdentifier, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec toggleSalesChannelPromoAvailabilityRequestCreation(String hotelIdentifier, String rateModifierIdentifier, List<InventoryUpdateRequest> inventoryUpdateRequest) throws WebClientResponseException {
        List<InventoryUpdateRequest> postBody = inventoryUpdateRequest;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling toggleSalesChannelPromoAvailability", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (rateModifierIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'rateModifierIdentifier' when calling toggleSalesChannelPromoAvailability", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (inventoryUpdateRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'inventoryUpdateRequest' when calling toggleSalesChannelPromoAvailability", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("rateModifierIdentifier", rateModifierIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/vnd.platform-v1+json", "application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<SalesChannel> localVarReturnType = new ParameterizedTypeReference<SalesChannel>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/sales/account/promo/{rateModifierIdentifier}/list", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<SalesChannel> toggleSalesChannelPromoAvailability(String hotelIdentifier, String rateModifierIdentifier, List<InventoryUpdateRequest> inventoryUpdateRequest) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannel> localVarReturnType = new ParameterizedTypeReference<SalesChannel>(){};
        return this.toggleSalesChannelPromoAvailabilityRequestCreation(hotelIdentifier, rateModifierIdentifier, inventoryUpdateRequest).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<SalesChannel>>> toggleSalesChannelPromoAvailabilityWithHttpInfo(String hotelIdentifier, String rateModifierIdentifier, List<InventoryUpdateRequest> inventoryUpdateRequest) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannel> localVarReturnType = new ParameterizedTypeReference<SalesChannel>(){};
        return this.toggleSalesChannelPromoAvailabilityRequestCreation(hotelIdentifier, rateModifierIdentifier, inventoryUpdateRequest).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec toggleSalesChannelPromoBundleAvailabilityRequestCreation(String hotelIdentifier, String rateModifierBundleIdentifier, List<InventoryUpdateRequest> inventoryUpdateRequest) throws WebClientResponseException {
        List<InventoryUpdateRequest> postBody = inventoryUpdateRequest;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling toggleSalesChannelPromoBundleAvailability", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (rateModifierBundleIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'rateModifierBundleIdentifier' when calling toggleSalesChannelPromoBundleAvailability", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (inventoryUpdateRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'inventoryUpdateRequest' when calling toggleSalesChannelPromoBundleAvailability", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("rateModifierBundleIdentifier", rateModifierBundleIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/vnd.platform-v1+json", "application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<SalesChannel> localVarReturnType = new ParameterizedTypeReference<SalesChannel>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/sales/account/promobundle/{rateModifierBundleIdentifier}/list", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<SalesChannel> toggleSalesChannelPromoBundleAvailability(String hotelIdentifier, String rateModifierBundleIdentifier, List<InventoryUpdateRequest> inventoryUpdateRequest) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannel> localVarReturnType = new ParameterizedTypeReference<SalesChannel>(){};
        return this.toggleSalesChannelPromoBundleAvailabilityRequestCreation(hotelIdentifier, rateModifierBundleIdentifier, inventoryUpdateRequest).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<SalesChannel>>> toggleSalesChannelPromoBundleAvailabilityWithHttpInfo(String hotelIdentifier, String rateModifierBundleIdentifier, List<InventoryUpdateRequest> inventoryUpdateRequest) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannel> localVarReturnType = new ParameterizedTypeReference<SalesChannel>(){};
        return this.toggleSalesChannelPromoBundleAvailabilityRequestCreation(hotelIdentifier, rateModifierBundleIdentifier, inventoryUpdateRequest).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec updateSalesChannelRequestCreation(String hotelIdentifier, String salesChannelIdentifier, SalesChannelUpdateRequest salesChannelUpdateRequest) throws WebClientResponseException {
        SalesChannelUpdateRequest postBody = salesChannelUpdateRequest;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling updateSalesChannel", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (salesChannelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'salesChannelIdentifier' when calling updateSalesChannel", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (salesChannelUpdateRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'salesChannelUpdateRequest' when calling updateSalesChannel", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("salesChannelIdentifier", salesChannelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/vnd.platform-v1+json", "application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<SalesChannel> localVarReturnType = new ParameterizedTypeReference<SalesChannel>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/sales/account/{salesChannelIdentifier}", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SalesChannel> updateSalesChannel(String hotelIdentifier, String salesChannelIdentifier, SalesChannelUpdateRequest salesChannelUpdateRequest) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannel> localVarReturnType = new ParameterizedTypeReference<SalesChannel>(){};
        return this.updateSalesChannelRequestCreation(hotelIdentifier, salesChannelIdentifier, salesChannelUpdateRequest).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SalesChannel>> updateSalesChannelWithHttpInfo(String hotelIdentifier, String salesChannelIdentifier, SalesChannelUpdateRequest salesChannelUpdateRequest) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannel> localVarReturnType = new ParameterizedTypeReference<SalesChannel>(){};
        return this.updateSalesChannelRequestCreation(hotelIdentifier, salesChannelIdentifier, salesChannelUpdateRequest).toEntity((ParameterizedTypeReference)localVarReturnType);
    }
}

