/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The configuration options of the Chart series tooltips. The tooltip of the Chart series is displayed when the `tooltip.visible` option is set to `true`.")
@JsonPropertyOrder(value={"visible", "format"})
public class ChartTooltip {
    public static final String JSON_PROPERTY_VISIBLE = "visible";
    private Boolean visible;
    public static final String JSON_PROPERTY_FORMAT = "format";
    private String format;

    public ChartTooltip visible(Boolean visible) {
        this.visible = visible;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If set to `true`, the Chart displays the series tooltip. By default, the series tooltip is not displayed.")
    @JsonProperty(value="visible")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getVisible() {
        return this.visible;
    }

    @JsonProperty(value="visible")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVisible(Boolean visible) {
        this.visible = visible;
    }

    public ChartTooltip format(String format) {
        this.format = format;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The format of the labels. Uses the format method of IntlService. The available format placeholders are:  - Area, Bar, Column, Funnel, Line, and Pie {0} - value - Bubble {0} - x value{1} - y value{2} - size value{3} - category name - Scatter and scatterLine {0} - x value{1} - y value - Candlestick and OHLC {0} - open value{1} - high value{2} - low value{3} - close value{4} - category name")
    @JsonProperty(value="format")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFormat() {
        return this.format;
    }

    @JsonProperty(value="format")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFormat(String format) {
        this.format = format;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChartTooltip chartTooltip = (ChartTooltip)o;
        return Objects.equals(this.visible, chartTooltip.visible) && Objects.equals(this.format, chartTooltip.format);
    }

    public int hashCode() {
        return Objects.hash(this.visible, this.format);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ChartTooltip {\n");
        sb.append("    visible: ").append(this.toIndentedString(this.visible)).append("\n");
        sb.append("    format: ").append(this.toIndentedString(this.format)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

