/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import travel.wink.sdk.extranet.model.IdentifierNamePair;

@JsonPropertyOrder(value={"hotelIdentifier", "packageIdentifier", "removable", "rateModifiers"})
public class PackageRemovableResponse {
    public static final String JSON_PROPERTY_HOTEL_IDENTIFIER = "hotelIdentifier";
    private UUID hotelIdentifier;
    public static final String JSON_PROPERTY_PACKAGE_IDENTIFIER = "packageIdentifier";
    private UUID packageIdentifier;
    public static final String JSON_PROPERTY_REMOVABLE = "removable";
    private Boolean removable = false;
    public static final String JSON_PROPERTY_RATE_MODIFIERS = "rateModifiers";
    private List<IdentifierNamePair> rateModifiers = null;

    public PackageRemovableResponse hotelIdentifier(UUID hotelIdentifier) {
        this.hotelIdentifier = hotelIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Package owner identifier")
    @JsonProperty(value="hotelIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getHotelIdentifier() {
        return this.hotelIdentifier;
    }

    @JsonProperty(value="hotelIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setHotelIdentifier(UUID hotelIdentifier) {
        this.hotelIdentifier = hotelIdentifier;
    }

    public PackageRemovableResponse packageIdentifier(UUID packageIdentifier) {
        this.packageIdentifier = packageIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Package identifier to verify removable")
    @JsonProperty(value="packageIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getPackageIdentifier() {
        return this.packageIdentifier;
    }

    @JsonProperty(value="packageIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPackageIdentifier(UUID packageIdentifier) {
        this.packageIdentifier = packageIdentifier;
    }

    public PackageRemovableResponse removable(Boolean removable) {
        this.removable = removable;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="true", required=true, value="Whether package is removable or not")
    @JsonProperty(value="removable")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getRemovable() {
        return this.removable;
    }

    @JsonProperty(value="removable")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRemovable(Boolean removable) {
        this.removable = removable;
    }

    public PackageRemovableResponse rateModifiers(List<IdentifierNamePair> rateModifiers) {
        this.rateModifiers = rateModifiers;
        return this;
    }

    public PackageRemovableResponse addRateModifiersItem(IdentifierNamePair rateModifiersItem) {
        if (this.rateModifiers == null) {
            this.rateModifiers = new ArrayList<IdentifierNamePair>();
        }
        this.rateModifiers.add(rateModifiersItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="If package is not removable, this list will show promotions are currently linked to this package.")
    @JsonProperty(value="rateModifiers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<IdentifierNamePair> getRateModifiers() {
        return this.rateModifiers;
    }

    @JsonProperty(value="rateModifiers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRateModifiers(List<IdentifierNamePair> rateModifiers) {
        this.rateModifiers = rateModifiers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PackageRemovableResponse packageRemovableResponse = (PackageRemovableResponse)o;
        return Objects.equals(this.hotelIdentifier, packageRemovableResponse.hotelIdentifier) && Objects.equals(this.packageIdentifier, packageRemovableResponse.packageIdentifier) && Objects.equals(this.removable, packageRemovableResponse.removable) && Objects.equals(this.rateModifiers, packageRemovableResponse.rateModifiers);
    }

    public int hashCode() {
        return Objects.hash(this.hotelIdentifier, this.packageIdentifier, this.removable, this.rateModifiers);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PackageRemovableResponse {\n");
        sb.append("    hotelIdentifier: ").append(this.toIndentedString(this.hotelIdentifier)).append("\n");
        sb.append("    packageIdentifier: ").append(this.toIndentedString(this.packageIdentifier)).append("\n");
        sb.append("    removable: ").append(this.toIndentedString(this.removable)).append("\n");
        sb.append("    rateModifiers: ").append(this.toIndentedString(this.rateModifiers)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

