/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@ApiModel(description="Property response to review.")
@JsonPropertyOrder(value={"hotelIdentifier", "reviewIdentifier", "userIdentifier", "responseFromHotel", "approvedText", "approvedImage"})
public class ReviewResponse {
    public static final String JSON_PROPERTY_HOTEL_IDENTIFIER = "hotelIdentifier";
    private UUID hotelIdentifier;
    public static final String JSON_PROPERTY_REVIEW_IDENTIFIER = "reviewIdentifier";
    private UUID reviewIdentifier;
    public static final String JSON_PROPERTY_USER_IDENTIFIER = "userIdentifier";
    private UUID userIdentifier;
    public static final String JSON_PROPERTY_RESPONSE_FROM_HOTEL = "responseFromHotel";
    private String responseFromHotel;
    public static final String JSON_PROPERTY_APPROVED_TEXT = "approvedText";
    private Boolean approvedText;
    public static final String JSON_PROPERTY_APPROVED_IMAGE = "approvedImage";
    private Boolean approvedImage;

    public ReviewResponse hotelIdentifier(UUID hotelIdentifier) {
        this.hotelIdentifier = hotelIdentifier;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Hotel identifier associated with review.")
    @JsonProperty(value="hotelIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getHotelIdentifier() {
        return this.hotelIdentifier;
    }

    @JsonProperty(value="hotelIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHotelIdentifier(UUID hotelIdentifier) {
        this.hotelIdentifier = hotelIdentifier;
    }

    public ReviewResponse reviewIdentifier(UUID reviewIdentifier) {
        this.reviewIdentifier = reviewIdentifier;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Review identifier of review being responded to.")
    @JsonProperty(value="reviewIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getReviewIdentifier() {
        return this.reviewIdentifier;
    }

    @JsonProperty(value="reviewIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReviewIdentifier(UUID reviewIdentifier) {
        this.reviewIdentifier = reviewIdentifier;
    }

    public ReviewResponse userIdentifier(UUID userIdentifier) {
        this.userIdentifier = userIdentifier;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="User identifier of property manager who responded to the review.")
    @JsonProperty(value="userIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getUserIdentifier() {
        return this.userIdentifier;
    }

    @JsonProperty(value="userIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUserIdentifier(UUID userIdentifier) {
        this.userIdentifier = userIdentifier;
    }

    public ReviewResponse responseFromHotel(String responseFromHotel) {
        this.responseFromHotel = responseFromHotel;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="Thank you for coming. Lovely to hear you enjoyed your stay.", required=true, value="User identifier of property manager who responded to the review.")
    @JsonProperty(value="responseFromHotel")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getResponseFromHotel() {
        return this.responseFromHotel;
    }

    @JsonProperty(value="responseFromHotel")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setResponseFromHotel(String responseFromHotel) {
        this.responseFromHotel = responseFromHotel;
    }

    public ReviewResponse approvedText(Boolean approvedText) {
        this.approvedText = approvedText;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Property approves the use of guest review text with property profile.")
    @JsonProperty(value="approvedText")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getApprovedText() {
        return this.approvedText;
    }

    @JsonProperty(value="approvedText")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setApprovedText(Boolean approvedText) {
        this.approvedText = approvedText;
    }

    public ReviewResponse approvedImage(Boolean approvedImage) {
        this.approvedImage = approvedImage;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Property approves the use of guest generated image with property profile.")
    @JsonProperty(value="approvedImage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getApprovedImage() {
        return this.approvedImage;
    }

    @JsonProperty(value="approvedImage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setApprovedImage(Boolean approvedImage) {
        this.approvedImage = approvedImage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReviewResponse reviewResponse = (ReviewResponse)o;
        return Objects.equals(this.hotelIdentifier, reviewResponse.hotelIdentifier) && Objects.equals(this.reviewIdentifier, reviewResponse.reviewIdentifier) && Objects.equals(this.userIdentifier, reviewResponse.userIdentifier) && Objects.equals(this.responseFromHotel, reviewResponse.responseFromHotel) && Objects.equals(this.approvedText, reviewResponse.approvedText) && Objects.equals(this.approvedImage, reviewResponse.approvedImage);
    }

    public int hashCode() {
        return Objects.hash(this.hotelIdentifier, this.reviewIdentifier, this.userIdentifier, this.responseFromHotel, this.approvedText, this.approvedImage);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ReviewResponse {\n");
        sb.append("    hotelIdentifier: ").append(this.toIndentedString(this.hotelIdentifier)).append("\n");
        sb.append("    reviewIdentifier: ").append(this.toIndentedString(this.reviewIdentifier)).append("\n");
        sb.append("    userIdentifier: ").append(this.toIndentedString(this.userIdentifier)).append("\n");
        sb.append("    responseFromHotel: ").append(this.toIndentedString(this.responseFromHotel)).append("\n");
        sb.append("    approvedText: ").append(this.toIndentedString(this.approvedText)).append("\n");
        sb.append("    approvedImage: ").append(this.toIndentedString(this.approvedImage)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

