/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Booking Engine](/booking-engine): All APIs related to searching for travel inventory and creating bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [TripPay Acquiring](/payment-acquiring): All APIs related to how our Web Components work. - [TripPay](/payment): All APIs related to account management, mapping and integrator features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.payment-v`1`+json.  ## Release history - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Extranet API Welcome to the Extranet API - A programmer-friendly way to manage your travel inventory on the wink payment. This API offers a superset of the features you can find at [https://extranet.wink.travel](https://extranet.wink.travel) and gives you all the tools you need to ready your properties and inventory for sale across 10000s of our unique sales channels. What differentiates us from existing Extranets is 1. we make it available for everyone to use and 2. the care we take in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Content creators have the ability to make their inventory look great and be searchable in a wide variety of ways. You won't find properties with generic inventory, low resolution pictures and little ancillary content that can easily be found everywhere else on the internet.  # Integrations We have already integrated with the most well-known channel managers so you don't have to. Once your properties are set up, you can finish the setup by mapping your property to wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API. - Allotz - CloudBeds / MyAllocator - Comanche - d-edge - FastBooking - HotelLink - HoteliersGuru - Omnibees - RateGain - Rate Tiger - ResAvenue - Siteminder - Sabre SynXis - Travelclick - Yieldplanet  # Intended Audience Programmers are [most likely] a requirement to start integrating with wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible. - Hotel chains - Hotel brands - Travel tech companies - Destination sites - Integrators - Aggregators - Destination management companies - Travel agencies - OTAs  
 *
 * The version of the OpenAPI document: 21.15.1
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.extranet.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import travel.wink.sdk.extranet.model.KeyValuePair;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Chart properties allow you to choose how to visualize available data points. Choose how you want to:   - filter your data  - sort your data  - group your data  - include data in your data sets  - display currency amounts
 */
@ApiModel(description = "Chart properties allow you to choose how to visualize available data points. Choose how you want to:   - filter your data  - sort your data  - group your data  - include data in your data sets  - display currency amounts")
@JsonPropertyOrder({
  ChartRequest.JSON_PROPERTY_SERIES,
  ChartRequest.JSON_PROPERTY_TIME_SERIES_UNITS,
  ChartRequest.JSON_PROPERTY_START_DATE,
  ChartRequest.JSON_PROPERTY_END_DATE,
  ChartRequest.JSON_PROPERTY_FILTER_ON_HOTEL_IDENTIFIER,
  ChartRequest.JSON_PROPERTY_FILTER_ON_CHANNEL_SUB_TYPE,
  ChartRequest.JSON_PROPERTY_FILTER_ON_OWNER_IDENTIFIER,
  ChartRequest.JSON_PROPERTY_FILTER_ON_ENGINE_COUNTRY_GEO_NAME_ID,
  ChartRequest.JSON_PROPERTY_FILTER_ON_ENGINE_CITY_GEO_NAME_ID,
  ChartRequest.JSON_PROPERTY_FILTER_ON_ENGINE_CONTINENT_CODE,
  ChartRequest.JSON_PROPERTY_FILTER_ON_ENGINE_CONFIGURATION_IDENTIFIER,
  ChartRequest.JSON_PROPERTY_FILTER_ON_COUNTRY_GEO_NAME_ID,
  ChartRequest.JSON_PROPERTY_FILTER_ON_CITY_GEO_NAME_ID,
  ChartRequest.JSON_PROPERTY_FILTER_ON_CONTINENT_CODE,
  ChartRequest.JSON_PROPERTY_FILTER_ON_USER_IDENTIFIER,
  ChartRequest.JSON_PROPERTY_SORT_ON_PAGE_VISITS,
  ChartRequest.JSON_PROPERTY_SORT_ON_MAP_MARKER_VISITS,
  ChartRequest.JSON_PROPERTY_SORT_ON_CARD_VISITS,
  ChartRequest.JSON_PROPERTY_SORT_ON_BOOKINGS,
  ChartRequest.JSON_PROPERTY_SORT_ON_CANCELLATIONS,
  ChartRequest.JSON_PROPERTY_SORT_ON_ROOM_NIGHTS,
  ChartRequest.JSON_PROPERTY_SORT_ON_MEETING_ROOMS,
  ChartRequest.JSON_PROPERTY_SORT_ON_RESTAURANTS,
  ChartRequest.JSON_PROPERTY_SORT_ON_SPAS,
  ChartRequest.JSON_PROPERTY_SORT_ON_ACTIVITIES,
  ChartRequest.JSON_PROPERTY_SORT_ON_ATTRACTIONS,
  ChartRequest.JSON_PROPERTY_SORT_ON_PLACES,
  ChartRequest.JSON_PROPERTY_SORT_ON_PACKAGES,
  ChartRequest.JSON_PROPERTY_SORT_ON_ADD_ONS,
  ChartRequest.JSON_PROPERTY_SORT_ON_TOTAL_ROOM_REVENUE,
  ChartRequest.JSON_PROPERTY_SORT_ON_PACKAGES_REVENUE,
  ChartRequest.JSON_PROPERTY_SORT_ON_ADDONS_REVENUE,
  ChartRequest.JSON_PROPERTY_SORT_ON_PACKAGES_AND_ADDONS_REVENUE,
  ChartRequest.JSON_PROPERTY_SORT_ON_TOTAL_NET_REVENUE,
  ChartRequest.JSON_PROPERTY_SORT_ON_CANCELLED_ROOM_NIGHTS,
  ChartRequest.JSON_PROPERTY_SORT_ON_CANCELLED_MEETING_ROOMS,
  ChartRequest.JSON_PROPERTY_SORT_ON_CANCELLED_RESTAURANTS,
  ChartRequest.JSON_PROPERTY_SORT_ON_CANCELLED_SPAS,
  ChartRequest.JSON_PROPERTY_SORT_ON_CANCELLED_ACTIVITIES,
  ChartRequest.JSON_PROPERTY_SORT_ON_CANCELLED_ATTRACTIONS,
  ChartRequest.JSON_PROPERTY_SORT_ON_CANCELLED_PLACES,
  ChartRequest.JSON_PROPERTY_SORT_ON_CANCELLED_PACKAGES,
  ChartRequest.JSON_PROPERTY_SORT_ON_CANCELLED_ADD_ONS,
  ChartRequest.JSON_PROPERTY_SORT_ON_CANCELLED_TOTAL_ROOM_REVENUE,
  ChartRequest.JSON_PROPERTY_SORT_ON_CANCELLED_PACKAGES_AND_ADDONS_REVENUE,
  ChartRequest.JSON_PROPERTY_SORT_ON_CANCELLED_PACKAGES_REVENUE,
  ChartRequest.JSON_PROPERTY_SORT_ON_CANCELLED_ADDONS_REVENUE,
  ChartRequest.JSON_PROPERTY_SORT_ON_CANCELLED_TOTAL_NET_REVENUE,
  ChartRequest.JSON_PROPERTY_INCLUDE_PAGE_VISITS,
  ChartRequest.JSON_PROPERTY_INCLUDE_MAP_MARKER_VISITS,
  ChartRequest.JSON_PROPERTY_INCLUDE_CARD_VISITS,
  ChartRequest.JSON_PROPERTY_INCLUDE_BOOKINGS,
  ChartRequest.JSON_PROPERTY_INCLUDE_CANCELLATIONS,
  ChartRequest.JSON_PROPERTY_INCLUDE_ROOM_NIGHTS,
  ChartRequest.JSON_PROPERTY_INCLUDE_MEETING_ROOMS,
  ChartRequest.JSON_PROPERTY_INCLUDE_RESTAURANTS,
  ChartRequest.JSON_PROPERTY_INCLUDE_SPAS,
  ChartRequest.JSON_PROPERTY_INCLUDE_ACTIVITIES,
  ChartRequest.JSON_PROPERTY_INCLUDE_ATTRACTIONS,
  ChartRequest.JSON_PROPERTY_INCLUDE_PLACES,
  ChartRequest.JSON_PROPERTY_INCLUDE_PACKAGES,
  ChartRequest.JSON_PROPERTY_INCLUDE_ADD_ONS,
  ChartRequest.JSON_PROPERTY_INCLUDE_TOTAL_ROOM_REVENUE,
  ChartRequest.JSON_PROPERTY_INCLUDE_AVERAGE_ROOM_RATE,
  ChartRequest.JSON_PROPERTY_INCLUDE_PACKAGES_REVENUE,
  ChartRequest.JSON_PROPERTY_INCLUDE_ADDONS_REVENUE,
  ChartRequest.JSON_PROPERTY_INCLUDE_PACKAGES_AND_ADDONS_REVENUE,
  ChartRequest.JSON_PROPERTY_INCLUDE_TOTAL_NET_REVENUE,
  ChartRequest.JSON_PROPERTY_INCLUDE_CANCELLED_ROOM_NIGHTS,
  ChartRequest.JSON_PROPERTY_INCLUDE_CANCELLED_MEETING_ROOMS,
  ChartRequest.JSON_PROPERTY_INCLUDE_CANCELLED_RESTAURANTS,
  ChartRequest.JSON_PROPERTY_INCLUDE_CANCELLED_SPAS,
  ChartRequest.JSON_PROPERTY_INCLUDE_CANCELLED_ACTIVITIES,
  ChartRequest.JSON_PROPERTY_INCLUDE_CANCELLED_ATTRACTIONS,
  ChartRequest.JSON_PROPERTY_INCLUDE_CANCELLED_PLACES,
  ChartRequest.JSON_PROPERTY_INCLUDE_CANCELLED_PACKAGES,
  ChartRequest.JSON_PROPERTY_INCLUDE_CANCELLED_ADD_ONS,
  ChartRequest.JSON_PROPERTY_INCLUDE_CANCELLED_TOTAL_ROOM_REVENUE,
  ChartRequest.JSON_PROPERTY_INCLUDE_CANCELLED_PACKAGES_AND_ADDONS_REVENUE,
  ChartRequest.JSON_PROPERTY_INCLUDE_CANCELLED_PACKAGES_REVENUE,
  ChartRequest.JSON_PROPERTY_INCLUDE_CANCELLED_ADDONS_REVENUE,
  ChartRequest.JSON_PROPERTY_INCLUDE_CANCELLED_TOTAL_NET_REVENUE,
  ChartRequest.JSON_PROPERTY_GROUP_ON_CHANNEL_SUB_TYPE,
  ChartRequest.JSON_PROPERTY_GROUP_ON_OWNER_IDENTIFIER,
  ChartRequest.JSON_PROPERTY_GROUP_ON_ENGINE_IDENTIFIER,
  ChartRequest.JSON_PROPERTY_GROUP_ON_ENGINE_COUNTRY_GEO_NAME_ID,
  ChartRequest.JSON_PROPERTY_GROUP_ON_ENGINE_CITY_GEO_NAME_ID,
  ChartRequest.JSON_PROPERTY_GROUP_ON_ENGINE_CONTINENT_CODE,
  ChartRequest.JSON_PROPERTY_GROUP_ON_ENGINE_CONFIGURATION_IDENTIFIER,
  ChartRequest.JSON_PROPERTY_GROUP_ON_COUNTRY_GEO_NAME_ID,
  ChartRequest.JSON_PROPERTY_GROUP_ON_CITY_GEO_NAME_ID,
  ChartRequest.JSON_PROPERTY_GROUP_ON_CONTINENT_CODE,
  ChartRequest.JSON_PROPERTY_GROUP_ON_HOTEL_IDENTIFIER,
  ChartRequest.JSON_PROPERTY_GROUP_ON_USER_IDENTIFIER,
  ChartRequest.JSON_PROPERTY_CURRENCY_CODE
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-09-08T16:32:28.411222+07:00[Asia/Bangkok]")
public class ChartRequest {
  /**
   * The time series to visualize
   */
  public enum SeriesEnum {
    HOUR("HOUR"),
    
    DAY("DAY"),
    
    MONTH("MONTH"),
    
    YEAR("YEAR");

    private String value;

    SeriesEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static SeriesEnum fromValue(String value) {
      for (SeriesEnum b : SeriesEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_SERIES = "series";
  private SeriesEnum series;

  public static final String JSON_PROPERTY_TIME_SERIES_UNITS = "timeSeriesUnits";
  private Long timeSeriesUnits;

  public static final String JSON_PROPERTY_START_DATE = "startDate";
  private OffsetDateTime startDate;

  public static final String JSON_PROPERTY_END_DATE = "endDate";
  private OffsetDateTime endDate;

  public static final String JSON_PROPERTY_FILTER_ON_HOTEL_IDENTIFIER = "filterOnHotelIdentifier";
  private KeyValuePair filterOnHotelIdentifier;

  /**
   * Filter on channel sub type. What channel sub-type helped make the booking.
   */
  public enum FilterOnChannelSubTypeEnum {
    DIRECT("DIRECT"),
    
    APPLICATION("APPLICATION"),
    
    HOTEL("HOTEL"),
    
    TRAVELIKO("TRAVELIKO"),
    
    CORPORATE("CORPORATE"),
    
    TRAVEL_AGENT("TRAVEL_AGENT"),
    
    INFLUENCER("INFLUENCER"),
    
    BLOGGER("BLOGGER"),
    
    DESTINATION("DESTINATION");

    private String value;

    FilterOnChannelSubTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static FilterOnChannelSubTypeEnum fromValue(String value) {
      for (FilterOnChannelSubTypeEnum b : FilterOnChannelSubTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_FILTER_ON_CHANNEL_SUB_TYPE = "filterOnChannelSubType";
  private FilterOnChannelSubTypeEnum filterOnChannelSubType;

  public static final String JSON_PROPERTY_FILTER_ON_OWNER_IDENTIFIER = "filterOnOwnerIdentifier";
  private KeyValuePair filterOnOwnerIdentifier;

  public static final String JSON_PROPERTY_FILTER_ON_ENGINE_COUNTRY_GEO_NAME_ID = "filterOnEngineCountryGeoNameId";
  private KeyValuePair filterOnEngineCountryGeoNameId;

  public static final String JSON_PROPERTY_FILTER_ON_ENGINE_CITY_GEO_NAME_ID = "filterOnEngineCityGeoNameId";
  private KeyValuePair filterOnEngineCityGeoNameId;

  public static final String JSON_PROPERTY_FILTER_ON_ENGINE_CONTINENT_CODE = "filterOnEngineContinentCode";
  private KeyValuePair filterOnEngineContinentCode;

  public static final String JSON_PROPERTY_FILTER_ON_ENGINE_CONFIGURATION_IDENTIFIER = "filterOnEngineConfigurationIdentifier";
  private KeyValuePair filterOnEngineConfigurationIdentifier;

  public static final String JSON_PROPERTY_FILTER_ON_COUNTRY_GEO_NAME_ID = "filterOnCountryGeoNameId";
  private KeyValuePair filterOnCountryGeoNameId;

  public static final String JSON_PROPERTY_FILTER_ON_CITY_GEO_NAME_ID = "filterOnCityGeoNameId";
  private KeyValuePair filterOnCityGeoNameId;

  public static final String JSON_PROPERTY_FILTER_ON_CONTINENT_CODE = "filterOnContinentCode";
  private KeyValuePair filterOnContinentCode;

  public static final String JSON_PROPERTY_FILTER_ON_USER_IDENTIFIER = "filterOnUserIdentifier";
  private KeyValuePair filterOnUserIdentifier;

  public static final String JSON_PROPERTY_SORT_ON_PAGE_VISITS = "sortOnPageVisits";
  private Boolean sortOnPageVisits = false;

  public static final String JSON_PROPERTY_SORT_ON_MAP_MARKER_VISITS = "sortOnMapMarkerVisits";
  private Boolean sortOnMapMarkerVisits = false;

  public static final String JSON_PROPERTY_SORT_ON_CARD_VISITS = "sortOnCardVisits";
  private Boolean sortOnCardVisits = false;

  public static final String JSON_PROPERTY_SORT_ON_BOOKINGS = "sortOnBookings";
  private Boolean sortOnBookings = false;

  public static final String JSON_PROPERTY_SORT_ON_CANCELLATIONS = "sortOnCancellations";
  private Boolean sortOnCancellations = false;

  public static final String JSON_PROPERTY_SORT_ON_ROOM_NIGHTS = "sortOnRoomNights";
  private Boolean sortOnRoomNights = false;

  public static final String JSON_PROPERTY_SORT_ON_MEETING_ROOMS = "sortOnMeetingRooms";
  private Boolean sortOnMeetingRooms = false;

  public static final String JSON_PROPERTY_SORT_ON_RESTAURANTS = "sortOnRestaurants";
  private Boolean sortOnRestaurants = false;

  public static final String JSON_PROPERTY_SORT_ON_SPAS = "sortOnSpas";
  private Boolean sortOnSpas = false;

  public static final String JSON_PROPERTY_SORT_ON_ACTIVITIES = "sortOnActivities";
  private Boolean sortOnActivities = false;

  public static final String JSON_PROPERTY_SORT_ON_ATTRACTIONS = "sortOnAttractions";
  private Boolean sortOnAttractions = false;

  public static final String JSON_PROPERTY_SORT_ON_PLACES = "sortOnPlaces";
  private Boolean sortOnPlaces = false;

  public static final String JSON_PROPERTY_SORT_ON_PACKAGES = "sortOnPackages";
  private Boolean sortOnPackages = false;

  public static final String JSON_PROPERTY_SORT_ON_ADD_ONS = "sortOnAddOns";
  private Boolean sortOnAddOns = false;

  public static final String JSON_PROPERTY_SORT_ON_TOTAL_ROOM_REVENUE = "sortOnTotalRoomRevenue";
  private Boolean sortOnTotalRoomRevenue = false;

  public static final String JSON_PROPERTY_SORT_ON_PACKAGES_REVENUE = "sortOnPackagesRevenue";
  private Boolean sortOnPackagesRevenue = false;

  public static final String JSON_PROPERTY_SORT_ON_ADDONS_REVENUE = "sortOnAddonsRevenue";
  private Boolean sortOnAddonsRevenue = false;

  public static final String JSON_PROPERTY_SORT_ON_PACKAGES_AND_ADDONS_REVENUE = "sortOnPackagesAndAddonsRevenue";
  private Boolean sortOnPackagesAndAddonsRevenue = false;

  public static final String JSON_PROPERTY_SORT_ON_TOTAL_NET_REVENUE = "sortOnTotalNetRevenue";
  private Boolean sortOnTotalNetRevenue = false;

  public static final String JSON_PROPERTY_SORT_ON_CANCELLED_ROOM_NIGHTS = "sortOnCancelledRoomNights";
  private Boolean sortOnCancelledRoomNights = false;

  public static final String JSON_PROPERTY_SORT_ON_CANCELLED_MEETING_ROOMS = "sortOnCancelledMeetingRooms";
  private Boolean sortOnCancelledMeetingRooms = false;

  public static final String JSON_PROPERTY_SORT_ON_CANCELLED_RESTAURANTS = "sortOnCancelledRestaurants";
  private Boolean sortOnCancelledRestaurants = false;

  public static final String JSON_PROPERTY_SORT_ON_CANCELLED_SPAS = "sortOnCancelledSpas";
  private Boolean sortOnCancelledSpas = false;

  public static final String JSON_PROPERTY_SORT_ON_CANCELLED_ACTIVITIES = "sortOnCancelledActivities";
  private Boolean sortOnCancelledActivities = false;

  public static final String JSON_PROPERTY_SORT_ON_CANCELLED_ATTRACTIONS = "sortOnCancelledAttractions";
  private Boolean sortOnCancelledAttractions = false;

  public static final String JSON_PROPERTY_SORT_ON_CANCELLED_PLACES = "sortOnCancelledPlaces";
  private Boolean sortOnCancelledPlaces = false;

  public static final String JSON_PROPERTY_SORT_ON_CANCELLED_PACKAGES = "sortOnCancelledPackages";
  private Boolean sortOnCancelledPackages = false;

  public static final String JSON_PROPERTY_SORT_ON_CANCELLED_ADD_ONS = "sortOnCancelledAddOns";
  private Boolean sortOnCancelledAddOns = false;

  public static final String JSON_PROPERTY_SORT_ON_CANCELLED_TOTAL_ROOM_REVENUE = "sortOnCancelledTotalRoomRevenue";
  private Boolean sortOnCancelledTotalRoomRevenue = false;

  public static final String JSON_PROPERTY_SORT_ON_CANCELLED_PACKAGES_AND_ADDONS_REVENUE = "sortOnCancelledPackagesAndAddonsRevenue";
  private Boolean sortOnCancelledPackagesAndAddonsRevenue = false;

  public static final String JSON_PROPERTY_SORT_ON_CANCELLED_PACKAGES_REVENUE = "sortOnCancelledPackagesRevenue";
  private Boolean sortOnCancelledPackagesRevenue = false;

  public static final String JSON_PROPERTY_SORT_ON_CANCELLED_ADDONS_REVENUE = "sortOnCancelledAddonsRevenue";
  private Boolean sortOnCancelledAddonsRevenue = false;

  public static final String JSON_PROPERTY_SORT_ON_CANCELLED_TOTAL_NET_REVENUE = "sortOnCancelledTotalNetRevenue";
  private Boolean sortOnCancelledTotalNetRevenue = false;

  public static final String JSON_PROPERTY_INCLUDE_PAGE_VISITS = "includePageVisits";
  private Boolean includePageVisits = false;

  public static final String JSON_PROPERTY_INCLUDE_MAP_MARKER_VISITS = "includeMapMarkerVisits";
  private Boolean includeMapMarkerVisits = false;

  public static final String JSON_PROPERTY_INCLUDE_CARD_VISITS = "includeCardVisits";
  private Boolean includeCardVisits = false;

  public static final String JSON_PROPERTY_INCLUDE_BOOKINGS = "includeBookings";
  private Boolean includeBookings = false;

  public static final String JSON_PROPERTY_INCLUDE_CANCELLATIONS = "includeCancellations";
  private Boolean includeCancellations = false;

  public static final String JSON_PROPERTY_INCLUDE_ROOM_NIGHTS = "includeRoomNights";
  private Boolean includeRoomNights = false;

  public static final String JSON_PROPERTY_INCLUDE_MEETING_ROOMS = "includeMeetingRooms";
  private Boolean includeMeetingRooms = false;

  public static final String JSON_PROPERTY_INCLUDE_RESTAURANTS = "includeRestaurants";
  private Boolean includeRestaurants = false;

  public static final String JSON_PROPERTY_INCLUDE_SPAS = "includeSpas";
  private Boolean includeSpas = false;

  public static final String JSON_PROPERTY_INCLUDE_ACTIVITIES = "includeActivities";
  private Boolean includeActivities = false;

  public static final String JSON_PROPERTY_INCLUDE_ATTRACTIONS = "includeAttractions";
  private Boolean includeAttractions = false;

  public static final String JSON_PROPERTY_INCLUDE_PLACES = "includePlaces";
  private Boolean includePlaces = false;

  public static final String JSON_PROPERTY_INCLUDE_PACKAGES = "includePackages";
  private Boolean includePackages = false;

  public static final String JSON_PROPERTY_INCLUDE_ADD_ONS = "includeAddOns";
  private Boolean includeAddOns = false;

  public static final String JSON_PROPERTY_INCLUDE_TOTAL_ROOM_REVENUE = "includeTotalRoomRevenue";
  private Boolean includeTotalRoomRevenue = false;

  public static final String JSON_PROPERTY_INCLUDE_AVERAGE_ROOM_RATE = "includeAverageRoomRate";
  private Boolean includeAverageRoomRate = false;

  public static final String JSON_PROPERTY_INCLUDE_PACKAGES_REVENUE = "includePackagesRevenue";
  private Boolean includePackagesRevenue = false;

  public static final String JSON_PROPERTY_INCLUDE_ADDONS_REVENUE = "includeAddonsRevenue";
  private Boolean includeAddonsRevenue = false;

  public static final String JSON_PROPERTY_INCLUDE_PACKAGES_AND_ADDONS_REVENUE = "includePackagesAndAddonsRevenue";
  private Boolean includePackagesAndAddonsRevenue = false;

  public static final String JSON_PROPERTY_INCLUDE_TOTAL_NET_REVENUE = "includeTotalNetRevenue";
  private Boolean includeTotalNetRevenue = false;

  public static final String JSON_PROPERTY_INCLUDE_CANCELLED_ROOM_NIGHTS = "includeCancelledRoomNights";
  private Boolean includeCancelledRoomNights = false;

  public static final String JSON_PROPERTY_INCLUDE_CANCELLED_MEETING_ROOMS = "includeCancelledMeetingRooms";
  private Boolean includeCancelledMeetingRooms = false;

  public static final String JSON_PROPERTY_INCLUDE_CANCELLED_RESTAURANTS = "includeCancelledRestaurants";
  private Boolean includeCancelledRestaurants = false;

  public static final String JSON_PROPERTY_INCLUDE_CANCELLED_SPAS = "includeCancelledSpas";
  private Boolean includeCancelledSpas = false;

  public static final String JSON_PROPERTY_INCLUDE_CANCELLED_ACTIVITIES = "includeCancelledActivities";
  private Boolean includeCancelledActivities = false;

  public static final String JSON_PROPERTY_INCLUDE_CANCELLED_ATTRACTIONS = "includeCancelledAttractions";
  private Boolean includeCancelledAttractions = false;

  public static final String JSON_PROPERTY_INCLUDE_CANCELLED_PLACES = "includeCancelledPlaces";
  private Boolean includeCancelledPlaces = false;

  public static final String JSON_PROPERTY_INCLUDE_CANCELLED_PACKAGES = "includeCancelledPackages";
  private Boolean includeCancelledPackages = false;

  public static final String JSON_PROPERTY_INCLUDE_CANCELLED_ADD_ONS = "includeCancelledAddOns";
  private Boolean includeCancelledAddOns = false;

  public static final String JSON_PROPERTY_INCLUDE_CANCELLED_TOTAL_ROOM_REVENUE = "includeCancelledTotalRoomRevenue";
  private Boolean includeCancelledTotalRoomRevenue = false;

  public static final String JSON_PROPERTY_INCLUDE_CANCELLED_PACKAGES_AND_ADDONS_REVENUE = "includeCancelledPackagesAndAddonsRevenue";
  private Boolean includeCancelledPackagesAndAddonsRevenue = false;

  public static final String JSON_PROPERTY_INCLUDE_CANCELLED_PACKAGES_REVENUE = "includeCancelledPackagesRevenue";
  private Boolean includeCancelledPackagesRevenue = false;

  public static final String JSON_PROPERTY_INCLUDE_CANCELLED_ADDONS_REVENUE = "includeCancelledAddonsRevenue";
  private Boolean includeCancelledAddonsRevenue = false;

  public static final String JSON_PROPERTY_INCLUDE_CANCELLED_TOTAL_NET_REVENUE = "includeCancelledTotalNetRevenue";
  private Boolean includeCancelledTotalNetRevenue = false;

  public static final String JSON_PROPERTY_GROUP_ON_CHANNEL_SUB_TYPE = "groupOnChannelSubType";
  private Boolean groupOnChannelSubType = false;

  public static final String JSON_PROPERTY_GROUP_ON_OWNER_IDENTIFIER = "groupOnOwnerIdentifier";
  private Boolean groupOnOwnerIdentifier = false;

  public static final String JSON_PROPERTY_GROUP_ON_ENGINE_IDENTIFIER = "groupOnEngineIdentifier";
  private Boolean groupOnEngineIdentifier = false;

  public static final String JSON_PROPERTY_GROUP_ON_ENGINE_COUNTRY_GEO_NAME_ID = "groupOnEngineCountryGeoNameId";
  private Boolean groupOnEngineCountryGeoNameId = false;

  public static final String JSON_PROPERTY_GROUP_ON_ENGINE_CITY_GEO_NAME_ID = "groupOnEngineCityGeoNameId";
  private Boolean groupOnEngineCityGeoNameId = false;

  public static final String JSON_PROPERTY_GROUP_ON_ENGINE_CONTINENT_CODE = "groupOnEngineContinentCode";
  private Boolean groupOnEngineContinentCode = false;

  public static final String JSON_PROPERTY_GROUP_ON_ENGINE_CONFIGURATION_IDENTIFIER = "groupOnEngineConfigurationIdentifier";
  private Boolean groupOnEngineConfigurationIdentifier = false;

  public static final String JSON_PROPERTY_GROUP_ON_COUNTRY_GEO_NAME_ID = "groupOnCountryGeoNameId";
  private Boolean groupOnCountryGeoNameId = false;

  public static final String JSON_PROPERTY_GROUP_ON_CITY_GEO_NAME_ID = "groupOnCityGeoNameId";
  private Boolean groupOnCityGeoNameId = false;

  public static final String JSON_PROPERTY_GROUP_ON_CONTINENT_CODE = "groupOnContinentCode";
  private Boolean groupOnContinentCode = false;

  public static final String JSON_PROPERTY_GROUP_ON_HOTEL_IDENTIFIER = "groupOnHotelIdentifier";
  private Boolean groupOnHotelIdentifier = false;

  public static final String JSON_PROPERTY_GROUP_ON_USER_IDENTIFIER = "groupOnUserIdentifier";
  private Boolean groupOnUserIdentifier = false;

  public static final String JSON_PROPERTY_CURRENCY_CODE = "currencyCode";
  private String currencyCode = "USD";

  public ChartRequest() { 
  }

  public ChartRequest series(SeriesEnum series) {
    
    this.series = series;
    return this;
  }

   /**
   * The time series to visualize
   * @return series
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "HOUR", required = true, value = "The time series to visualize")
  @JsonProperty(JSON_PROPERTY_SERIES)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public SeriesEnum getSeries() {
    return series;
  }


  @JsonProperty(JSON_PROPERTY_SERIES)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSeries(SeriesEnum series) {
    this.series = series;
  }


  public ChartRequest timeSeriesUnits(Long timeSeriesUnits) {
    
    this.timeSeriesUnits = timeSeriesUnits;
    return this;
  }

   /**
   * How many units of the time series type to visualize. Only required if start / end date not populated.
   * @return timeSeriesUnits
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "24", value = "How many units of the time series type to visualize. Only required if start / end date not populated.")
  @JsonProperty(JSON_PROPERTY_TIME_SERIES_UNITS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getTimeSeriesUnits() {
    return timeSeriesUnits;
  }


  @JsonProperty(JSON_PROPERTY_TIME_SERIES_UNITS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTimeSeriesUnits(Long timeSeriesUnits) {
    this.timeSeriesUnits = timeSeriesUnits;
  }


  public ChartRequest startDate(OffsetDateTime startDate) {
    
    this.startDate = startDate;
    return this;
  }

   /**
   * Fixed date to start visualizations on
   * @return startDate
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Fixed date to start visualizations on")
  @JsonProperty(JSON_PROPERTY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getStartDate() {
    return startDate;
  }


  @JsonProperty(JSON_PROPERTY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStartDate(OffsetDateTime startDate) {
    this.startDate = startDate;
  }


  public ChartRequest endDate(OffsetDateTime endDate) {
    
    this.endDate = endDate;
    return this;
  }

   /**
   * Fixed date to end visualizations on
   * @return endDate
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Fixed date to end visualizations on")
  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getEndDate() {
    return endDate;
  }


  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEndDate(OffsetDateTime endDate) {
    this.endDate = endDate;
  }


  public ChartRequest filterOnHotelIdentifier(KeyValuePair filterOnHotelIdentifier) {
    
    this.filterOnHotelIdentifier = filterOnHotelIdentifier;
    return this;
  }

   /**
   * Get filterOnHotelIdentifier
   * @return filterOnHotelIdentifier
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_FILTER_ON_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public KeyValuePair getFilterOnHotelIdentifier() {
    return filterOnHotelIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_FILTER_ON_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFilterOnHotelIdentifier(KeyValuePair filterOnHotelIdentifier) {
    this.filterOnHotelIdentifier = filterOnHotelIdentifier;
  }


  public ChartRequest filterOnChannelSubType(FilterOnChannelSubTypeEnum filterOnChannelSubType) {
    
    this.filterOnChannelSubType = filterOnChannelSubType;
    return this;
  }

   /**
   * Filter on channel sub type. What channel sub-type helped make the booking.
   * @return filterOnChannelSubType
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "APPLICATION", value = "Filter on channel sub type. What channel sub-type helped make the booking.")
  @JsonProperty(JSON_PROPERTY_FILTER_ON_CHANNEL_SUB_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public FilterOnChannelSubTypeEnum getFilterOnChannelSubType() {
    return filterOnChannelSubType;
  }


  @JsonProperty(JSON_PROPERTY_FILTER_ON_CHANNEL_SUB_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFilterOnChannelSubType(FilterOnChannelSubTypeEnum filterOnChannelSubType) {
    this.filterOnChannelSubType = filterOnChannelSubType;
  }


  public ChartRequest filterOnOwnerIdentifier(KeyValuePair filterOnOwnerIdentifier) {
    
    this.filterOnOwnerIdentifier = filterOnOwnerIdentifier;
    return this;
  }

   /**
   * Get filterOnOwnerIdentifier
   * @return filterOnOwnerIdentifier
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_FILTER_ON_OWNER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public KeyValuePair getFilterOnOwnerIdentifier() {
    return filterOnOwnerIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_FILTER_ON_OWNER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFilterOnOwnerIdentifier(KeyValuePair filterOnOwnerIdentifier) {
    this.filterOnOwnerIdentifier = filterOnOwnerIdentifier;
  }


  public ChartRequest filterOnEngineCountryGeoNameId(KeyValuePair filterOnEngineCountryGeoNameId) {
    
    this.filterOnEngineCountryGeoNameId = filterOnEngineCountryGeoNameId;
    return this;
  }

   /**
   * Get filterOnEngineCountryGeoNameId
   * @return filterOnEngineCountryGeoNameId
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_FILTER_ON_ENGINE_COUNTRY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public KeyValuePair getFilterOnEngineCountryGeoNameId() {
    return filterOnEngineCountryGeoNameId;
  }


  @JsonProperty(JSON_PROPERTY_FILTER_ON_ENGINE_COUNTRY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFilterOnEngineCountryGeoNameId(KeyValuePair filterOnEngineCountryGeoNameId) {
    this.filterOnEngineCountryGeoNameId = filterOnEngineCountryGeoNameId;
  }


  public ChartRequest filterOnEngineCityGeoNameId(KeyValuePair filterOnEngineCityGeoNameId) {
    
    this.filterOnEngineCityGeoNameId = filterOnEngineCityGeoNameId;
    return this;
  }

   /**
   * Get filterOnEngineCityGeoNameId
   * @return filterOnEngineCityGeoNameId
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_FILTER_ON_ENGINE_CITY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public KeyValuePair getFilterOnEngineCityGeoNameId() {
    return filterOnEngineCityGeoNameId;
  }


  @JsonProperty(JSON_PROPERTY_FILTER_ON_ENGINE_CITY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFilterOnEngineCityGeoNameId(KeyValuePair filterOnEngineCityGeoNameId) {
    this.filterOnEngineCityGeoNameId = filterOnEngineCityGeoNameId;
  }


  public ChartRequest filterOnEngineContinentCode(KeyValuePair filterOnEngineContinentCode) {
    
    this.filterOnEngineContinentCode = filterOnEngineContinentCode;
    return this;
  }

   /**
   * Get filterOnEngineContinentCode
   * @return filterOnEngineContinentCode
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_FILTER_ON_ENGINE_CONTINENT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public KeyValuePair getFilterOnEngineContinentCode() {
    return filterOnEngineContinentCode;
  }


  @JsonProperty(JSON_PROPERTY_FILTER_ON_ENGINE_CONTINENT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFilterOnEngineContinentCode(KeyValuePair filterOnEngineContinentCode) {
    this.filterOnEngineContinentCode = filterOnEngineContinentCode;
  }


  public ChartRequest filterOnEngineConfigurationIdentifier(KeyValuePair filterOnEngineConfigurationIdentifier) {
    
    this.filterOnEngineConfigurationIdentifier = filterOnEngineConfigurationIdentifier;
    return this;
  }

   /**
   * Get filterOnEngineConfigurationIdentifier
   * @return filterOnEngineConfigurationIdentifier
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_FILTER_ON_ENGINE_CONFIGURATION_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public KeyValuePair getFilterOnEngineConfigurationIdentifier() {
    return filterOnEngineConfigurationIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_FILTER_ON_ENGINE_CONFIGURATION_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFilterOnEngineConfigurationIdentifier(KeyValuePair filterOnEngineConfigurationIdentifier) {
    this.filterOnEngineConfigurationIdentifier = filterOnEngineConfigurationIdentifier;
  }


  public ChartRequest filterOnCountryGeoNameId(KeyValuePair filterOnCountryGeoNameId) {
    
    this.filterOnCountryGeoNameId = filterOnCountryGeoNameId;
    return this;
  }

   /**
   * Get filterOnCountryGeoNameId
   * @return filterOnCountryGeoNameId
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_FILTER_ON_COUNTRY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public KeyValuePair getFilterOnCountryGeoNameId() {
    return filterOnCountryGeoNameId;
  }


  @JsonProperty(JSON_PROPERTY_FILTER_ON_COUNTRY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFilterOnCountryGeoNameId(KeyValuePair filterOnCountryGeoNameId) {
    this.filterOnCountryGeoNameId = filterOnCountryGeoNameId;
  }


  public ChartRequest filterOnCityGeoNameId(KeyValuePair filterOnCityGeoNameId) {
    
    this.filterOnCityGeoNameId = filterOnCityGeoNameId;
    return this;
  }

   /**
   * Get filterOnCityGeoNameId
   * @return filterOnCityGeoNameId
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_FILTER_ON_CITY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public KeyValuePair getFilterOnCityGeoNameId() {
    return filterOnCityGeoNameId;
  }


  @JsonProperty(JSON_PROPERTY_FILTER_ON_CITY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFilterOnCityGeoNameId(KeyValuePair filterOnCityGeoNameId) {
    this.filterOnCityGeoNameId = filterOnCityGeoNameId;
  }


  public ChartRequest filterOnContinentCode(KeyValuePair filterOnContinentCode) {
    
    this.filterOnContinentCode = filterOnContinentCode;
    return this;
  }

   /**
   * Get filterOnContinentCode
   * @return filterOnContinentCode
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_FILTER_ON_CONTINENT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public KeyValuePair getFilterOnContinentCode() {
    return filterOnContinentCode;
  }


  @JsonProperty(JSON_PROPERTY_FILTER_ON_CONTINENT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFilterOnContinentCode(KeyValuePair filterOnContinentCode) {
    this.filterOnContinentCode = filterOnContinentCode;
  }


  public ChartRequest filterOnUserIdentifier(KeyValuePair filterOnUserIdentifier) {
    
    this.filterOnUserIdentifier = filterOnUserIdentifier;
    return this;
  }

   /**
   * Get filterOnUserIdentifier
   * @return filterOnUserIdentifier
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_FILTER_ON_USER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public KeyValuePair getFilterOnUserIdentifier() {
    return filterOnUserIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_FILTER_ON_USER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFilterOnUserIdentifier(KeyValuePair filterOnUserIdentifier) {
    this.filterOnUserIdentifier = filterOnUserIdentifier;
  }


  public ChartRequest sortOnPageVisits(Boolean sortOnPageVisits) {
    
    this.sortOnPageVisits = sortOnPageVisits;
    return this;
  }

   /**
   * Sort on page visits
   * @return sortOnPageVisits
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "true", value = "Sort on page visits")
  @JsonProperty(JSON_PROPERTY_SORT_ON_PAGE_VISITS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnPageVisits() {
    return sortOnPageVisits;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_PAGE_VISITS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnPageVisits(Boolean sortOnPageVisits) {
    this.sortOnPageVisits = sortOnPageVisits;
  }


  public ChartRequest sortOnMapMarkerVisits(Boolean sortOnMapMarkerVisits) {
    
    this.sortOnMapMarkerVisits = sortOnMapMarkerVisits;
    return this;
  }

   /**
   * Sort on map marker visits
   * @return sortOnMapMarkerVisits
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Sort on map marker visits")
  @JsonProperty(JSON_PROPERTY_SORT_ON_MAP_MARKER_VISITS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnMapMarkerVisits() {
    return sortOnMapMarkerVisits;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_MAP_MARKER_VISITS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnMapMarkerVisits(Boolean sortOnMapMarkerVisits) {
    this.sortOnMapMarkerVisits = sortOnMapMarkerVisits;
  }


  public ChartRequest sortOnCardVisits(Boolean sortOnCardVisits) {
    
    this.sortOnCardVisits = sortOnCardVisits;
    return this;
  }

   /**
   * Sort on card visits
   * @return sortOnCardVisits
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Sort on card visits")
  @JsonProperty(JSON_PROPERTY_SORT_ON_CARD_VISITS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnCardVisits() {
    return sortOnCardVisits;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_CARD_VISITS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnCardVisits(Boolean sortOnCardVisits) {
    this.sortOnCardVisits = sortOnCardVisits;
  }


  public ChartRequest sortOnBookings(Boolean sortOnBookings) {
    
    this.sortOnBookings = sortOnBookings;
    return this;
  }

   /**
   * Sort on bookings
   * @return sortOnBookings
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Sort on bookings")
  @JsonProperty(JSON_PROPERTY_SORT_ON_BOOKINGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnBookings() {
    return sortOnBookings;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_BOOKINGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnBookings(Boolean sortOnBookings) {
    this.sortOnBookings = sortOnBookings;
  }


  public ChartRequest sortOnCancellations(Boolean sortOnCancellations) {
    
    this.sortOnCancellations = sortOnCancellations;
    return this;
  }

   /**
   * Sort on cancellations
   * @return sortOnCancellations
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Sort on cancellations")
  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnCancellations() {
    return sortOnCancellations;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnCancellations(Boolean sortOnCancellations) {
    this.sortOnCancellations = sortOnCancellations;
  }


  public ChartRequest sortOnRoomNights(Boolean sortOnRoomNights) {
    
    this.sortOnRoomNights = sortOnRoomNights;
    return this;
  }

   /**
   * Sort on room nights
   * @return sortOnRoomNights
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Sort on room nights")
  @JsonProperty(JSON_PROPERTY_SORT_ON_ROOM_NIGHTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnRoomNights() {
    return sortOnRoomNights;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_ROOM_NIGHTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnRoomNights(Boolean sortOnRoomNights) {
    this.sortOnRoomNights = sortOnRoomNights;
  }


  public ChartRequest sortOnMeetingRooms(Boolean sortOnMeetingRooms) {
    
    this.sortOnMeetingRooms = sortOnMeetingRooms;
    return this;
  }

   /**
   * Sort on meeting rooms
   * @return sortOnMeetingRooms
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Sort on meeting rooms")
  @JsonProperty(JSON_PROPERTY_SORT_ON_MEETING_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnMeetingRooms() {
    return sortOnMeetingRooms;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_MEETING_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnMeetingRooms(Boolean sortOnMeetingRooms) {
    this.sortOnMeetingRooms = sortOnMeetingRooms;
  }


  public ChartRequest sortOnRestaurants(Boolean sortOnRestaurants) {
    
    this.sortOnRestaurants = sortOnRestaurants;
    return this;
  }

   /**
   * Sort on restaurants
   * @return sortOnRestaurants
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Sort on restaurants")
  @JsonProperty(JSON_PROPERTY_SORT_ON_RESTAURANTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnRestaurants() {
    return sortOnRestaurants;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_RESTAURANTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnRestaurants(Boolean sortOnRestaurants) {
    this.sortOnRestaurants = sortOnRestaurants;
  }


  public ChartRequest sortOnSpas(Boolean sortOnSpas) {
    
    this.sortOnSpas = sortOnSpas;
    return this;
  }

   /**
   * Sort on spas
   * @return sortOnSpas
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Sort on spas")
  @JsonProperty(JSON_PROPERTY_SORT_ON_SPAS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnSpas() {
    return sortOnSpas;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_SPAS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnSpas(Boolean sortOnSpas) {
    this.sortOnSpas = sortOnSpas;
  }


  public ChartRequest sortOnActivities(Boolean sortOnActivities) {
    
    this.sortOnActivities = sortOnActivities;
    return this;
  }

   /**
   * Sort on activities
   * @return sortOnActivities
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Sort on activities")
  @JsonProperty(JSON_PROPERTY_SORT_ON_ACTIVITIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnActivities() {
    return sortOnActivities;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_ACTIVITIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnActivities(Boolean sortOnActivities) {
    this.sortOnActivities = sortOnActivities;
  }


  public ChartRequest sortOnAttractions(Boolean sortOnAttractions) {
    
    this.sortOnAttractions = sortOnAttractions;
    return this;
  }

   /**
   * Sort on attractions
   * @return sortOnAttractions
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Sort on attractions")
  @JsonProperty(JSON_PROPERTY_SORT_ON_ATTRACTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnAttractions() {
    return sortOnAttractions;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_ATTRACTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnAttractions(Boolean sortOnAttractions) {
    this.sortOnAttractions = sortOnAttractions;
  }


  public ChartRequest sortOnPlaces(Boolean sortOnPlaces) {
    
    this.sortOnPlaces = sortOnPlaces;
    return this;
  }

   /**
   * Sort on places
   * @return sortOnPlaces
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Sort on places")
  @JsonProperty(JSON_PROPERTY_SORT_ON_PLACES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnPlaces() {
    return sortOnPlaces;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_PLACES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnPlaces(Boolean sortOnPlaces) {
    this.sortOnPlaces = sortOnPlaces;
  }


  public ChartRequest sortOnPackages(Boolean sortOnPackages) {
    
    this.sortOnPackages = sortOnPackages;
    return this;
  }

   /**
   * Sort on packages
   * @return sortOnPackages
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Sort on packages")
  @JsonProperty(JSON_PROPERTY_SORT_ON_PACKAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnPackages() {
    return sortOnPackages;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_PACKAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnPackages(Boolean sortOnPackages) {
    this.sortOnPackages = sortOnPackages;
  }


  public ChartRequest sortOnAddOns(Boolean sortOnAddOns) {
    
    this.sortOnAddOns = sortOnAddOns;
    return this;
  }

   /**
   * Sort on add-ons
   * @return sortOnAddOns
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Sort on add-ons")
  @JsonProperty(JSON_PROPERTY_SORT_ON_ADD_ONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnAddOns() {
    return sortOnAddOns;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_ADD_ONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnAddOns(Boolean sortOnAddOns) {
    this.sortOnAddOns = sortOnAddOns;
  }


  public ChartRequest sortOnTotalRoomRevenue(Boolean sortOnTotalRoomRevenue) {
    
    this.sortOnTotalRoomRevenue = sortOnTotalRoomRevenue;
    return this;
  }

   /**
   * Sort on total room revenue
   * @return sortOnTotalRoomRevenue
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Sort on total room revenue")
  @JsonProperty(JSON_PROPERTY_SORT_ON_TOTAL_ROOM_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnTotalRoomRevenue() {
    return sortOnTotalRoomRevenue;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_TOTAL_ROOM_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnTotalRoomRevenue(Boolean sortOnTotalRoomRevenue) {
    this.sortOnTotalRoomRevenue = sortOnTotalRoomRevenue;
  }


  public ChartRequest sortOnPackagesRevenue(Boolean sortOnPackagesRevenue) {
    
    this.sortOnPackagesRevenue = sortOnPackagesRevenue;
    return this;
  }

   /**
   * Sort on packag revenue
   * @return sortOnPackagesRevenue
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Sort on packag revenue")
  @JsonProperty(JSON_PROPERTY_SORT_ON_PACKAGES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnPackagesRevenue() {
    return sortOnPackagesRevenue;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_PACKAGES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnPackagesRevenue(Boolean sortOnPackagesRevenue) {
    this.sortOnPackagesRevenue = sortOnPackagesRevenue;
  }


  public ChartRequest sortOnAddonsRevenue(Boolean sortOnAddonsRevenue) {
    
    this.sortOnAddonsRevenue = sortOnAddonsRevenue;
    return this;
  }

   /**
   * Sort on add-on revenue
   * @return sortOnAddonsRevenue
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Sort on add-on revenue")
  @JsonProperty(JSON_PROPERTY_SORT_ON_ADDONS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnAddonsRevenue() {
    return sortOnAddonsRevenue;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_ADDONS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnAddonsRevenue(Boolean sortOnAddonsRevenue) {
    this.sortOnAddonsRevenue = sortOnAddonsRevenue;
  }


  public ChartRequest sortOnPackagesAndAddonsRevenue(Boolean sortOnPackagesAndAddonsRevenue) {
    
    this.sortOnPackagesAndAddonsRevenue = sortOnPackagesAndAddonsRevenue;
    return this;
  }

   /**
   * Sort on combined packages and add-on revenue
   * @return sortOnPackagesAndAddonsRevenue
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Sort on combined packages and add-on revenue")
  @JsonProperty(JSON_PROPERTY_SORT_ON_PACKAGES_AND_ADDONS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnPackagesAndAddonsRevenue() {
    return sortOnPackagesAndAddonsRevenue;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_PACKAGES_AND_ADDONS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnPackagesAndAddonsRevenue(Boolean sortOnPackagesAndAddonsRevenue) {
    this.sortOnPackagesAndAddonsRevenue = sortOnPackagesAndAddonsRevenue;
  }


  public ChartRequest sortOnTotalNetRevenue(Boolean sortOnTotalNetRevenue) {
    
    this.sortOnTotalNetRevenue = sortOnTotalNetRevenue;
    return this;
  }

   /**
   * Sort on total net revenue
   * @return sortOnTotalNetRevenue
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Sort on total net revenue")
  @JsonProperty(JSON_PROPERTY_SORT_ON_TOTAL_NET_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnTotalNetRevenue() {
    return sortOnTotalNetRevenue;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_TOTAL_NET_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnTotalNetRevenue(Boolean sortOnTotalNetRevenue) {
    this.sortOnTotalNetRevenue = sortOnTotalNetRevenue;
  }


  public ChartRequest sortOnCancelledRoomNights(Boolean sortOnCancelledRoomNights) {
    
    this.sortOnCancelledRoomNights = sortOnCancelledRoomNights;
    return this;
  }

   /**
   * Sort on cancelled room nights
   * @return sortOnCancelledRoomNights
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Sort on cancelled room nights")
  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_ROOM_NIGHTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnCancelledRoomNights() {
    return sortOnCancelledRoomNights;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_ROOM_NIGHTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnCancelledRoomNights(Boolean sortOnCancelledRoomNights) {
    this.sortOnCancelledRoomNights = sortOnCancelledRoomNights;
  }


  public ChartRequest sortOnCancelledMeetingRooms(Boolean sortOnCancelledMeetingRooms) {
    
    this.sortOnCancelledMeetingRooms = sortOnCancelledMeetingRooms;
    return this;
  }

   /**
   * Sort on cancelled meeting rooms
   * @return sortOnCancelledMeetingRooms
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Sort on cancelled meeting rooms")
  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_MEETING_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnCancelledMeetingRooms() {
    return sortOnCancelledMeetingRooms;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_MEETING_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnCancelledMeetingRooms(Boolean sortOnCancelledMeetingRooms) {
    this.sortOnCancelledMeetingRooms = sortOnCancelledMeetingRooms;
  }


  public ChartRequest sortOnCancelledRestaurants(Boolean sortOnCancelledRestaurants) {
    
    this.sortOnCancelledRestaurants = sortOnCancelledRestaurants;
    return this;
  }

   /**
   * Sort on cancelled restaurants
   * @return sortOnCancelledRestaurants
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Sort on cancelled restaurants")
  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_RESTAURANTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnCancelledRestaurants() {
    return sortOnCancelledRestaurants;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_RESTAURANTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnCancelledRestaurants(Boolean sortOnCancelledRestaurants) {
    this.sortOnCancelledRestaurants = sortOnCancelledRestaurants;
  }


  public ChartRequest sortOnCancelledSpas(Boolean sortOnCancelledSpas) {
    
    this.sortOnCancelledSpas = sortOnCancelledSpas;
    return this;
  }

   /**
   * Sort on cancelled spas
   * @return sortOnCancelledSpas
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Sort on cancelled spas")
  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_SPAS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnCancelledSpas() {
    return sortOnCancelledSpas;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_SPAS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnCancelledSpas(Boolean sortOnCancelledSpas) {
    this.sortOnCancelledSpas = sortOnCancelledSpas;
  }


  public ChartRequest sortOnCancelledActivities(Boolean sortOnCancelledActivities) {
    
    this.sortOnCancelledActivities = sortOnCancelledActivities;
    return this;
  }

   /**
   * Sort on cancelled activities
   * @return sortOnCancelledActivities
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Sort on cancelled activities")
  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_ACTIVITIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnCancelledActivities() {
    return sortOnCancelledActivities;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_ACTIVITIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnCancelledActivities(Boolean sortOnCancelledActivities) {
    this.sortOnCancelledActivities = sortOnCancelledActivities;
  }


  public ChartRequest sortOnCancelledAttractions(Boolean sortOnCancelledAttractions) {
    
    this.sortOnCancelledAttractions = sortOnCancelledAttractions;
    return this;
  }

   /**
   * Sort on cancelled attractions
   * @return sortOnCancelledAttractions
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Sort on cancelled attractions")
  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_ATTRACTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnCancelledAttractions() {
    return sortOnCancelledAttractions;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_ATTRACTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnCancelledAttractions(Boolean sortOnCancelledAttractions) {
    this.sortOnCancelledAttractions = sortOnCancelledAttractions;
  }


  public ChartRequest sortOnCancelledPlaces(Boolean sortOnCancelledPlaces) {
    
    this.sortOnCancelledPlaces = sortOnCancelledPlaces;
    return this;
  }

   /**
   * Sort on cancelled places
   * @return sortOnCancelledPlaces
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Sort on cancelled places")
  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_PLACES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnCancelledPlaces() {
    return sortOnCancelledPlaces;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_PLACES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnCancelledPlaces(Boolean sortOnCancelledPlaces) {
    this.sortOnCancelledPlaces = sortOnCancelledPlaces;
  }


  public ChartRequest sortOnCancelledPackages(Boolean sortOnCancelledPackages) {
    
    this.sortOnCancelledPackages = sortOnCancelledPackages;
    return this;
  }

   /**
   * Sort on cancelled packages
   * @return sortOnCancelledPackages
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Sort on cancelled packages")
  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_PACKAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnCancelledPackages() {
    return sortOnCancelledPackages;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_PACKAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnCancelledPackages(Boolean sortOnCancelledPackages) {
    this.sortOnCancelledPackages = sortOnCancelledPackages;
  }


  public ChartRequest sortOnCancelledAddOns(Boolean sortOnCancelledAddOns) {
    
    this.sortOnCancelledAddOns = sortOnCancelledAddOns;
    return this;
  }

   /**
   * Sort on cancelled add-ons
   * @return sortOnCancelledAddOns
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Sort on cancelled add-ons")
  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_ADD_ONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnCancelledAddOns() {
    return sortOnCancelledAddOns;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_ADD_ONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnCancelledAddOns(Boolean sortOnCancelledAddOns) {
    this.sortOnCancelledAddOns = sortOnCancelledAddOns;
  }


  public ChartRequest sortOnCancelledTotalRoomRevenue(Boolean sortOnCancelledTotalRoomRevenue) {
    
    this.sortOnCancelledTotalRoomRevenue = sortOnCancelledTotalRoomRevenue;
    return this;
  }

   /**
   * Sort on cancelled total room revenue
   * @return sortOnCancelledTotalRoomRevenue
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Sort on cancelled total room revenue")
  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_TOTAL_ROOM_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnCancelledTotalRoomRevenue() {
    return sortOnCancelledTotalRoomRevenue;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_TOTAL_ROOM_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnCancelledTotalRoomRevenue(Boolean sortOnCancelledTotalRoomRevenue) {
    this.sortOnCancelledTotalRoomRevenue = sortOnCancelledTotalRoomRevenue;
  }


  public ChartRequest sortOnCancelledPackagesAndAddonsRevenue(Boolean sortOnCancelledPackagesAndAddonsRevenue) {
    
    this.sortOnCancelledPackagesAndAddonsRevenue = sortOnCancelledPackagesAndAddonsRevenue;
    return this;
  }

   /**
   * Sort on cancelled packages revenue
   * @return sortOnCancelledPackagesAndAddonsRevenue
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Sort on cancelled packages revenue")
  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_PACKAGES_AND_ADDONS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnCancelledPackagesAndAddonsRevenue() {
    return sortOnCancelledPackagesAndAddonsRevenue;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_PACKAGES_AND_ADDONS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnCancelledPackagesAndAddonsRevenue(Boolean sortOnCancelledPackagesAndAddonsRevenue) {
    this.sortOnCancelledPackagesAndAddonsRevenue = sortOnCancelledPackagesAndAddonsRevenue;
  }


  public ChartRequest sortOnCancelledPackagesRevenue(Boolean sortOnCancelledPackagesRevenue) {
    
    this.sortOnCancelledPackagesRevenue = sortOnCancelledPackagesRevenue;
    return this;
  }

   /**
   * Sort on cancelled packages revenue
   * @return sortOnCancelledPackagesRevenue
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Sort on cancelled packages revenue")
  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_PACKAGES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnCancelledPackagesRevenue() {
    return sortOnCancelledPackagesRevenue;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_PACKAGES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnCancelledPackagesRevenue(Boolean sortOnCancelledPackagesRevenue) {
    this.sortOnCancelledPackagesRevenue = sortOnCancelledPackagesRevenue;
  }


  public ChartRequest sortOnCancelledAddonsRevenue(Boolean sortOnCancelledAddonsRevenue) {
    
    this.sortOnCancelledAddonsRevenue = sortOnCancelledAddonsRevenue;
    return this;
  }

   /**
   * Sort on cancelled add-o revenue
   * @return sortOnCancelledAddonsRevenue
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Sort on cancelled add-o revenue")
  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_ADDONS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnCancelledAddonsRevenue() {
    return sortOnCancelledAddonsRevenue;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_ADDONS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnCancelledAddonsRevenue(Boolean sortOnCancelledAddonsRevenue) {
    this.sortOnCancelledAddonsRevenue = sortOnCancelledAddonsRevenue;
  }


  public ChartRequest sortOnCancelledTotalNetRevenue(Boolean sortOnCancelledTotalNetRevenue) {
    
    this.sortOnCancelledTotalNetRevenue = sortOnCancelledTotalNetRevenue;
    return this;
  }

   /**
   * Sort on cancelled total net revenue
   * @return sortOnCancelledTotalNetRevenue
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Sort on cancelled total net revenue")
  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_TOTAL_NET_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnCancelledTotalNetRevenue() {
    return sortOnCancelledTotalNetRevenue;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_TOTAL_NET_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnCancelledTotalNetRevenue(Boolean sortOnCancelledTotalNetRevenue) {
    this.sortOnCancelledTotalNetRevenue = sortOnCancelledTotalNetRevenue;
  }


  public ChartRequest includePageVisits(Boolean includePageVisits) {
    
    this.includePageVisits = includePageVisits;
    return this;
  }

   /**
   * Include page visits
   * @return includePageVisits
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Include page visits")
  @JsonProperty(JSON_PROPERTY_INCLUDE_PAGE_VISITS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludePageVisits() {
    return includePageVisits;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_PAGE_VISITS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludePageVisits(Boolean includePageVisits) {
    this.includePageVisits = includePageVisits;
  }


  public ChartRequest includeMapMarkerVisits(Boolean includeMapMarkerVisits) {
    
    this.includeMapMarkerVisits = includeMapMarkerVisits;
    return this;
  }

   /**
   * Include map marker visits
   * @return includeMapMarkerVisits
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Include map marker visits")
  @JsonProperty(JSON_PROPERTY_INCLUDE_MAP_MARKER_VISITS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeMapMarkerVisits() {
    return includeMapMarkerVisits;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_MAP_MARKER_VISITS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeMapMarkerVisits(Boolean includeMapMarkerVisits) {
    this.includeMapMarkerVisits = includeMapMarkerVisits;
  }


  public ChartRequest includeCardVisits(Boolean includeCardVisits) {
    
    this.includeCardVisits = includeCardVisits;
    return this;
  }

   /**
   * Include card visits
   * @return includeCardVisits
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Include card visits")
  @JsonProperty(JSON_PROPERTY_INCLUDE_CARD_VISITS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeCardVisits() {
    return includeCardVisits;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_CARD_VISITS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeCardVisits(Boolean includeCardVisits) {
    this.includeCardVisits = includeCardVisits;
  }


  public ChartRequest includeBookings(Boolean includeBookings) {
    
    this.includeBookings = includeBookings;
    return this;
  }

   /**
   * Include bookings
   * @return includeBookings
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Include bookings")
  @JsonProperty(JSON_PROPERTY_INCLUDE_BOOKINGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeBookings() {
    return includeBookings;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_BOOKINGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeBookings(Boolean includeBookings) {
    this.includeBookings = includeBookings;
  }


  public ChartRequest includeCancellations(Boolean includeCancellations) {
    
    this.includeCancellations = includeCancellations;
    return this;
  }

   /**
   * Include cancellations
   * @return includeCancellations
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Include cancellations")
  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeCancellations() {
    return includeCancellations;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeCancellations(Boolean includeCancellations) {
    this.includeCancellations = includeCancellations;
  }


  public ChartRequest includeRoomNights(Boolean includeRoomNights) {
    
    this.includeRoomNights = includeRoomNights;
    return this;
  }

   /**
   * Include room nights
   * @return includeRoomNights
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Include room nights")
  @JsonProperty(JSON_PROPERTY_INCLUDE_ROOM_NIGHTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeRoomNights() {
    return includeRoomNights;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_ROOM_NIGHTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeRoomNights(Boolean includeRoomNights) {
    this.includeRoomNights = includeRoomNights;
  }


  public ChartRequest includeMeetingRooms(Boolean includeMeetingRooms) {
    
    this.includeMeetingRooms = includeMeetingRooms;
    return this;
  }

   /**
   * Include meeting rooms
   * @return includeMeetingRooms
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Include meeting rooms")
  @JsonProperty(JSON_PROPERTY_INCLUDE_MEETING_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeMeetingRooms() {
    return includeMeetingRooms;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_MEETING_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeMeetingRooms(Boolean includeMeetingRooms) {
    this.includeMeetingRooms = includeMeetingRooms;
  }


  public ChartRequest includeRestaurants(Boolean includeRestaurants) {
    
    this.includeRestaurants = includeRestaurants;
    return this;
  }

   /**
   * Include restaurants
   * @return includeRestaurants
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Include restaurants")
  @JsonProperty(JSON_PROPERTY_INCLUDE_RESTAURANTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeRestaurants() {
    return includeRestaurants;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_RESTAURANTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeRestaurants(Boolean includeRestaurants) {
    this.includeRestaurants = includeRestaurants;
  }


  public ChartRequest includeSpas(Boolean includeSpas) {
    
    this.includeSpas = includeSpas;
    return this;
  }

   /**
   * Include spas
   * @return includeSpas
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Include spas")
  @JsonProperty(JSON_PROPERTY_INCLUDE_SPAS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeSpas() {
    return includeSpas;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_SPAS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeSpas(Boolean includeSpas) {
    this.includeSpas = includeSpas;
  }


  public ChartRequest includeActivities(Boolean includeActivities) {
    
    this.includeActivities = includeActivities;
    return this;
  }

   /**
   * Include activities
   * @return includeActivities
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Include activities")
  @JsonProperty(JSON_PROPERTY_INCLUDE_ACTIVITIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeActivities() {
    return includeActivities;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_ACTIVITIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeActivities(Boolean includeActivities) {
    this.includeActivities = includeActivities;
  }


  public ChartRequest includeAttractions(Boolean includeAttractions) {
    
    this.includeAttractions = includeAttractions;
    return this;
  }

   /**
   * Include attractions
   * @return includeAttractions
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Include attractions")
  @JsonProperty(JSON_PROPERTY_INCLUDE_ATTRACTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeAttractions() {
    return includeAttractions;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_ATTRACTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeAttractions(Boolean includeAttractions) {
    this.includeAttractions = includeAttractions;
  }


  public ChartRequest includePlaces(Boolean includePlaces) {
    
    this.includePlaces = includePlaces;
    return this;
  }

   /**
   * Include places
   * @return includePlaces
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Include places")
  @JsonProperty(JSON_PROPERTY_INCLUDE_PLACES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludePlaces() {
    return includePlaces;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_PLACES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludePlaces(Boolean includePlaces) {
    this.includePlaces = includePlaces;
  }


  public ChartRequest includePackages(Boolean includePackages) {
    
    this.includePackages = includePackages;
    return this;
  }

   /**
   * Include packages
   * @return includePackages
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Include packages")
  @JsonProperty(JSON_PROPERTY_INCLUDE_PACKAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludePackages() {
    return includePackages;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_PACKAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludePackages(Boolean includePackages) {
    this.includePackages = includePackages;
  }


  public ChartRequest includeAddOns(Boolean includeAddOns) {
    
    this.includeAddOns = includeAddOns;
    return this;
  }

   /**
   * Include add-ons
   * @return includeAddOns
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Include add-ons")
  @JsonProperty(JSON_PROPERTY_INCLUDE_ADD_ONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeAddOns() {
    return includeAddOns;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_ADD_ONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeAddOns(Boolean includeAddOns) {
    this.includeAddOns = includeAddOns;
  }


  public ChartRequest includeTotalRoomRevenue(Boolean includeTotalRoomRevenue) {
    
    this.includeTotalRoomRevenue = includeTotalRoomRevenue;
    return this;
  }

   /**
   * Include total room revenue
   * @return includeTotalRoomRevenue
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Include total room revenue")
  @JsonProperty(JSON_PROPERTY_INCLUDE_TOTAL_ROOM_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeTotalRoomRevenue() {
    return includeTotalRoomRevenue;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_TOTAL_ROOM_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeTotalRoomRevenue(Boolean includeTotalRoomRevenue) {
    this.includeTotalRoomRevenue = includeTotalRoomRevenue;
  }


  public ChartRequest includeAverageRoomRate(Boolean includeAverageRoomRate) {
    
    this.includeAverageRoomRate = includeAverageRoomRate;
    return this;
  }

   /**
   * Include average room rate
   * @return includeAverageRoomRate
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Include average room rate")
  @JsonProperty(JSON_PROPERTY_INCLUDE_AVERAGE_ROOM_RATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeAverageRoomRate() {
    return includeAverageRoomRate;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_AVERAGE_ROOM_RATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeAverageRoomRate(Boolean includeAverageRoomRate) {
    this.includeAverageRoomRate = includeAverageRoomRate;
  }


  public ChartRequest includePackagesRevenue(Boolean includePackagesRevenue) {
    
    this.includePackagesRevenue = includePackagesRevenue;
    return this;
  }

   /**
   * Include packages revenue
   * @return includePackagesRevenue
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Include packages revenue")
  @JsonProperty(JSON_PROPERTY_INCLUDE_PACKAGES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludePackagesRevenue() {
    return includePackagesRevenue;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_PACKAGES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludePackagesRevenue(Boolean includePackagesRevenue) {
    this.includePackagesRevenue = includePackagesRevenue;
  }


  public ChartRequest includeAddonsRevenue(Boolean includeAddonsRevenue) {
    
    this.includeAddonsRevenue = includeAddonsRevenue;
    return this;
  }

   /**
   * Include add-ons revenue
   * @return includeAddonsRevenue
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Include add-ons revenue")
  @JsonProperty(JSON_PROPERTY_INCLUDE_ADDONS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeAddonsRevenue() {
    return includeAddonsRevenue;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_ADDONS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeAddonsRevenue(Boolean includeAddonsRevenue) {
    this.includeAddonsRevenue = includeAddonsRevenue;
  }


  public ChartRequest includePackagesAndAddonsRevenue(Boolean includePackagesAndAddonsRevenue) {
    
    this.includePackagesAndAddonsRevenue = includePackagesAndAddonsRevenue;
    return this;
  }

   /**
   * Include combined packages and add-os revenue
   * @return includePackagesAndAddonsRevenue
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Include combined packages and add-os revenue")
  @JsonProperty(JSON_PROPERTY_INCLUDE_PACKAGES_AND_ADDONS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludePackagesAndAddonsRevenue() {
    return includePackagesAndAddonsRevenue;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_PACKAGES_AND_ADDONS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludePackagesAndAddonsRevenue(Boolean includePackagesAndAddonsRevenue) {
    this.includePackagesAndAddonsRevenue = includePackagesAndAddonsRevenue;
  }


  public ChartRequest includeTotalNetRevenue(Boolean includeTotalNetRevenue) {
    
    this.includeTotalNetRevenue = includeTotalNetRevenue;
    return this;
  }

   /**
   * Include total net revenue
   * @return includeTotalNetRevenue
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Include total net revenue")
  @JsonProperty(JSON_PROPERTY_INCLUDE_TOTAL_NET_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeTotalNetRevenue() {
    return includeTotalNetRevenue;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_TOTAL_NET_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeTotalNetRevenue(Boolean includeTotalNetRevenue) {
    this.includeTotalNetRevenue = includeTotalNetRevenue;
  }


  public ChartRequest includeCancelledRoomNights(Boolean includeCancelledRoomNights) {
    
    this.includeCancelledRoomNights = includeCancelledRoomNights;
    return this;
  }

   /**
   * Include cancelled room nights
   * @return includeCancelledRoomNights
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Include cancelled room nights")
  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_ROOM_NIGHTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeCancelledRoomNights() {
    return includeCancelledRoomNights;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_ROOM_NIGHTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeCancelledRoomNights(Boolean includeCancelledRoomNights) {
    this.includeCancelledRoomNights = includeCancelledRoomNights;
  }


  public ChartRequest includeCancelledMeetingRooms(Boolean includeCancelledMeetingRooms) {
    
    this.includeCancelledMeetingRooms = includeCancelledMeetingRooms;
    return this;
  }

   /**
   * Include cancelled meeting rooms
   * @return includeCancelledMeetingRooms
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Include cancelled meeting rooms")
  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_MEETING_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeCancelledMeetingRooms() {
    return includeCancelledMeetingRooms;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_MEETING_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeCancelledMeetingRooms(Boolean includeCancelledMeetingRooms) {
    this.includeCancelledMeetingRooms = includeCancelledMeetingRooms;
  }


  public ChartRequest includeCancelledRestaurants(Boolean includeCancelledRestaurants) {
    
    this.includeCancelledRestaurants = includeCancelledRestaurants;
    return this;
  }

   /**
   * Include cancelled restaurants
   * @return includeCancelledRestaurants
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Include cancelled restaurants")
  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_RESTAURANTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeCancelledRestaurants() {
    return includeCancelledRestaurants;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_RESTAURANTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeCancelledRestaurants(Boolean includeCancelledRestaurants) {
    this.includeCancelledRestaurants = includeCancelledRestaurants;
  }


  public ChartRequest includeCancelledSpas(Boolean includeCancelledSpas) {
    
    this.includeCancelledSpas = includeCancelledSpas;
    return this;
  }

   /**
   * Include cancelled spas
   * @return includeCancelledSpas
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Include cancelled spas")
  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_SPAS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeCancelledSpas() {
    return includeCancelledSpas;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_SPAS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeCancelledSpas(Boolean includeCancelledSpas) {
    this.includeCancelledSpas = includeCancelledSpas;
  }


  public ChartRequest includeCancelledActivities(Boolean includeCancelledActivities) {
    
    this.includeCancelledActivities = includeCancelledActivities;
    return this;
  }

   /**
   * Include cancelled activities
   * @return includeCancelledActivities
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Include cancelled activities")
  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_ACTIVITIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeCancelledActivities() {
    return includeCancelledActivities;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_ACTIVITIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeCancelledActivities(Boolean includeCancelledActivities) {
    this.includeCancelledActivities = includeCancelledActivities;
  }


  public ChartRequest includeCancelledAttractions(Boolean includeCancelledAttractions) {
    
    this.includeCancelledAttractions = includeCancelledAttractions;
    return this;
  }

   /**
   * Include cancelled attractions
   * @return includeCancelledAttractions
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Include cancelled attractions")
  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_ATTRACTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeCancelledAttractions() {
    return includeCancelledAttractions;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_ATTRACTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeCancelledAttractions(Boolean includeCancelledAttractions) {
    this.includeCancelledAttractions = includeCancelledAttractions;
  }


  public ChartRequest includeCancelledPlaces(Boolean includeCancelledPlaces) {
    
    this.includeCancelledPlaces = includeCancelledPlaces;
    return this;
  }

   /**
   * Include cancelled places
   * @return includeCancelledPlaces
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Include cancelled places")
  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_PLACES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeCancelledPlaces() {
    return includeCancelledPlaces;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_PLACES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeCancelledPlaces(Boolean includeCancelledPlaces) {
    this.includeCancelledPlaces = includeCancelledPlaces;
  }


  public ChartRequest includeCancelledPackages(Boolean includeCancelledPackages) {
    
    this.includeCancelledPackages = includeCancelledPackages;
    return this;
  }

   /**
   * Include cancelled packages
   * @return includeCancelledPackages
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Include cancelled packages")
  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_PACKAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeCancelledPackages() {
    return includeCancelledPackages;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_PACKAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeCancelledPackages(Boolean includeCancelledPackages) {
    this.includeCancelledPackages = includeCancelledPackages;
  }


  public ChartRequest includeCancelledAddOns(Boolean includeCancelledAddOns) {
    
    this.includeCancelledAddOns = includeCancelledAddOns;
    return this;
  }

   /**
   * Include cancelled add-ons
   * @return includeCancelledAddOns
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Include cancelled add-ons")
  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_ADD_ONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeCancelledAddOns() {
    return includeCancelledAddOns;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_ADD_ONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeCancelledAddOns(Boolean includeCancelledAddOns) {
    this.includeCancelledAddOns = includeCancelledAddOns;
  }


  public ChartRequest includeCancelledTotalRoomRevenue(Boolean includeCancelledTotalRoomRevenue) {
    
    this.includeCancelledTotalRoomRevenue = includeCancelledTotalRoomRevenue;
    return this;
  }

   /**
   * Include cancelled total room revenue
   * @return includeCancelledTotalRoomRevenue
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Include cancelled total room revenue")
  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_TOTAL_ROOM_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeCancelledTotalRoomRevenue() {
    return includeCancelledTotalRoomRevenue;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_TOTAL_ROOM_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeCancelledTotalRoomRevenue(Boolean includeCancelledTotalRoomRevenue) {
    this.includeCancelledTotalRoomRevenue = includeCancelledTotalRoomRevenue;
  }


  public ChartRequest includeCancelledPackagesAndAddonsRevenue(Boolean includeCancelledPackagesAndAddonsRevenue) {
    
    this.includeCancelledPackagesAndAddonsRevenue = includeCancelledPackagesAndAddonsRevenue;
    return this;
  }

   /**
   * Include combined cancelled package and add-on revenue
   * @return includeCancelledPackagesAndAddonsRevenue
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Include combined cancelled package and add-on revenue")
  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_PACKAGES_AND_ADDONS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeCancelledPackagesAndAddonsRevenue() {
    return includeCancelledPackagesAndAddonsRevenue;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_PACKAGES_AND_ADDONS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeCancelledPackagesAndAddonsRevenue(Boolean includeCancelledPackagesAndAddonsRevenue) {
    this.includeCancelledPackagesAndAddonsRevenue = includeCancelledPackagesAndAddonsRevenue;
  }


  public ChartRequest includeCancelledPackagesRevenue(Boolean includeCancelledPackagesRevenue) {
    
    this.includeCancelledPackagesRevenue = includeCancelledPackagesRevenue;
    return this;
  }

   /**
   * Include cancelled packages revenue
   * @return includeCancelledPackagesRevenue
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Include cancelled packages revenue")
  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_PACKAGES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeCancelledPackagesRevenue() {
    return includeCancelledPackagesRevenue;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_PACKAGES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeCancelledPackagesRevenue(Boolean includeCancelledPackagesRevenue) {
    this.includeCancelledPackagesRevenue = includeCancelledPackagesRevenue;
  }


  public ChartRequest includeCancelledAddonsRevenue(Boolean includeCancelledAddonsRevenue) {
    
    this.includeCancelledAddonsRevenue = includeCancelledAddonsRevenue;
    return this;
  }

   /**
   * Include cancelled add-ons revenue
   * @return includeCancelledAddonsRevenue
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Include cancelled add-ons revenue")
  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_ADDONS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeCancelledAddonsRevenue() {
    return includeCancelledAddonsRevenue;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_ADDONS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeCancelledAddonsRevenue(Boolean includeCancelledAddonsRevenue) {
    this.includeCancelledAddonsRevenue = includeCancelledAddonsRevenue;
  }


  public ChartRequest includeCancelledTotalNetRevenue(Boolean includeCancelledTotalNetRevenue) {
    
    this.includeCancelledTotalNetRevenue = includeCancelledTotalNetRevenue;
    return this;
  }

   /**
   * Include cancelled total net revenue
   * @return includeCancelledTotalNetRevenue
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Include cancelled total net revenue")
  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_TOTAL_NET_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeCancelledTotalNetRevenue() {
    return includeCancelledTotalNetRevenue;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_TOTAL_NET_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeCancelledTotalNetRevenue(Boolean includeCancelledTotalNetRevenue) {
    this.includeCancelledTotalNetRevenue = includeCancelledTotalNetRevenue;
  }


  public ChartRequest groupOnChannelSubType(Boolean groupOnChannelSubType) {
    
    this.groupOnChannelSubType = groupOnChannelSubType;
    return this;
  }

   /**
   * Group on  channel sub type
   * @return groupOnChannelSubType
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Group on  channel sub type")
  @JsonProperty(JSON_PROPERTY_GROUP_ON_CHANNEL_SUB_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getGroupOnChannelSubType() {
    return groupOnChannelSubType;
  }


  @JsonProperty(JSON_PROPERTY_GROUP_ON_CHANNEL_SUB_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGroupOnChannelSubType(Boolean groupOnChannelSubType) {
    this.groupOnChannelSubType = groupOnChannelSubType;
  }


  public ChartRequest groupOnOwnerIdentifier(Boolean groupOnOwnerIdentifier) {
    
    this.groupOnOwnerIdentifier = groupOnOwnerIdentifier;
    return this;
  }

   /**
   * Group on owner identifier
   * @return groupOnOwnerIdentifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Group on owner identifier")
  @JsonProperty(JSON_PROPERTY_GROUP_ON_OWNER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getGroupOnOwnerIdentifier() {
    return groupOnOwnerIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_GROUP_ON_OWNER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGroupOnOwnerIdentifier(Boolean groupOnOwnerIdentifier) {
    this.groupOnOwnerIdentifier = groupOnOwnerIdentifier;
  }


  public ChartRequest groupOnEngineIdentifier(Boolean groupOnEngineIdentifier) {
    
    this.groupOnEngineIdentifier = groupOnEngineIdentifier;
    return this;
  }

   /**
   * Group on application identifier
   * @return groupOnEngineIdentifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Group on application identifier")
  @JsonProperty(JSON_PROPERTY_GROUP_ON_ENGINE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getGroupOnEngineIdentifier() {
    return groupOnEngineIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_GROUP_ON_ENGINE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGroupOnEngineIdentifier(Boolean groupOnEngineIdentifier) {
    this.groupOnEngineIdentifier = groupOnEngineIdentifier;
  }


  public ChartRequest groupOnEngineCountryGeoNameId(Boolean groupOnEngineCountryGeoNameId) {
    
    this.groupOnEngineCountryGeoNameId = groupOnEngineCountryGeoNameId;
    return this;
  }

   /**
   * Group on application country geoNameId
   * @return groupOnEngineCountryGeoNameId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Group on application country geoNameId")
  @JsonProperty(JSON_PROPERTY_GROUP_ON_ENGINE_COUNTRY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getGroupOnEngineCountryGeoNameId() {
    return groupOnEngineCountryGeoNameId;
  }


  @JsonProperty(JSON_PROPERTY_GROUP_ON_ENGINE_COUNTRY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGroupOnEngineCountryGeoNameId(Boolean groupOnEngineCountryGeoNameId) {
    this.groupOnEngineCountryGeoNameId = groupOnEngineCountryGeoNameId;
  }


  public ChartRequest groupOnEngineCityGeoNameId(Boolean groupOnEngineCityGeoNameId) {
    
    this.groupOnEngineCityGeoNameId = groupOnEngineCityGeoNameId;
    return this;
  }

   /**
   * Group on application city geoNameId
   * @return groupOnEngineCityGeoNameId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Group on application city geoNameId")
  @JsonProperty(JSON_PROPERTY_GROUP_ON_ENGINE_CITY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getGroupOnEngineCityGeoNameId() {
    return groupOnEngineCityGeoNameId;
  }


  @JsonProperty(JSON_PROPERTY_GROUP_ON_ENGINE_CITY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGroupOnEngineCityGeoNameId(Boolean groupOnEngineCityGeoNameId) {
    this.groupOnEngineCityGeoNameId = groupOnEngineCityGeoNameId;
  }


  public ChartRequest groupOnEngineContinentCode(Boolean groupOnEngineContinentCode) {
    
    this.groupOnEngineContinentCode = groupOnEngineContinentCode;
    return this;
  }

   /**
   * Group on application continent code
   * @return groupOnEngineContinentCode
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Group on application continent code")
  @JsonProperty(JSON_PROPERTY_GROUP_ON_ENGINE_CONTINENT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getGroupOnEngineContinentCode() {
    return groupOnEngineContinentCode;
  }


  @JsonProperty(JSON_PROPERTY_GROUP_ON_ENGINE_CONTINENT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGroupOnEngineContinentCode(Boolean groupOnEngineContinentCode) {
    this.groupOnEngineContinentCode = groupOnEngineContinentCode;
  }


  public ChartRequest groupOnEngineConfigurationIdentifier(Boolean groupOnEngineConfigurationIdentifier) {
    
    this.groupOnEngineConfigurationIdentifier = groupOnEngineConfigurationIdentifier;
    return this;
  }

   /**
   * Group on customization identifier
   * @return groupOnEngineConfigurationIdentifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Group on customization identifier")
  @JsonProperty(JSON_PROPERTY_GROUP_ON_ENGINE_CONFIGURATION_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getGroupOnEngineConfigurationIdentifier() {
    return groupOnEngineConfigurationIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_GROUP_ON_ENGINE_CONFIGURATION_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGroupOnEngineConfigurationIdentifier(Boolean groupOnEngineConfigurationIdentifier) {
    this.groupOnEngineConfigurationIdentifier = groupOnEngineConfigurationIdentifier;
  }


  public ChartRequest groupOnCountryGeoNameId(Boolean groupOnCountryGeoNameId) {
    
    this.groupOnCountryGeoNameId = groupOnCountryGeoNameId;
    return this;
  }

   /**
   * Group on country geoNameId
   * @return groupOnCountryGeoNameId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Group on country geoNameId")
  @JsonProperty(JSON_PROPERTY_GROUP_ON_COUNTRY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getGroupOnCountryGeoNameId() {
    return groupOnCountryGeoNameId;
  }


  @JsonProperty(JSON_PROPERTY_GROUP_ON_COUNTRY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGroupOnCountryGeoNameId(Boolean groupOnCountryGeoNameId) {
    this.groupOnCountryGeoNameId = groupOnCountryGeoNameId;
  }


  public ChartRequest groupOnCityGeoNameId(Boolean groupOnCityGeoNameId) {
    
    this.groupOnCityGeoNameId = groupOnCityGeoNameId;
    return this;
  }

   /**
   * Group on city geoNameId
   * @return groupOnCityGeoNameId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Group on city geoNameId")
  @JsonProperty(JSON_PROPERTY_GROUP_ON_CITY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getGroupOnCityGeoNameId() {
    return groupOnCityGeoNameId;
  }


  @JsonProperty(JSON_PROPERTY_GROUP_ON_CITY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGroupOnCityGeoNameId(Boolean groupOnCityGeoNameId) {
    this.groupOnCityGeoNameId = groupOnCityGeoNameId;
  }


  public ChartRequest groupOnContinentCode(Boolean groupOnContinentCode) {
    
    this.groupOnContinentCode = groupOnContinentCode;
    return this;
  }

   /**
   * Group on continent code
   * @return groupOnContinentCode
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Group on continent code")
  @JsonProperty(JSON_PROPERTY_GROUP_ON_CONTINENT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getGroupOnContinentCode() {
    return groupOnContinentCode;
  }


  @JsonProperty(JSON_PROPERTY_GROUP_ON_CONTINENT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGroupOnContinentCode(Boolean groupOnContinentCode) {
    this.groupOnContinentCode = groupOnContinentCode;
  }


  public ChartRequest groupOnHotelIdentifier(Boolean groupOnHotelIdentifier) {
    
    this.groupOnHotelIdentifier = groupOnHotelIdentifier;
    return this;
  }

   /**
   * Group on hotel identifier
   * @return groupOnHotelIdentifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Group on hotel identifier")
  @JsonProperty(JSON_PROPERTY_GROUP_ON_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getGroupOnHotelIdentifier() {
    return groupOnHotelIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_GROUP_ON_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGroupOnHotelIdentifier(Boolean groupOnHotelIdentifier) {
    this.groupOnHotelIdentifier = groupOnHotelIdentifier;
  }


  public ChartRequest groupOnUserIdentifier(Boolean groupOnUserIdentifier) {
    
    this.groupOnUserIdentifier = groupOnUserIdentifier;
    return this;
  }

   /**
   * Group on user identifier
   * @return groupOnUserIdentifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Group on user identifier")
  @JsonProperty(JSON_PROPERTY_GROUP_ON_USER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getGroupOnUserIdentifier() {
    return groupOnUserIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_GROUP_ON_USER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGroupOnUserIdentifier(Boolean groupOnUserIdentifier) {
    this.groupOnUserIdentifier = groupOnUserIdentifier;
  }


  public ChartRequest currencyCode(String currencyCode) {
    
    this.currencyCode = currencyCode;
    return this;
  }

   /**
   * Currency code
   * @return currencyCode
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "EUR", value = "Currency code")
  @JsonProperty(JSON_PROPERTY_CURRENCY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCurrencyCode() {
    return currencyCode;
  }


  @JsonProperty(JSON_PROPERTY_CURRENCY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCurrencyCode(String currencyCode) {
    this.currencyCode = currencyCode;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ChartRequest chartRequest = (ChartRequest) o;
    return Objects.equals(this.series, chartRequest.series) &&
        Objects.equals(this.timeSeriesUnits, chartRequest.timeSeriesUnits) &&
        Objects.equals(this.startDate, chartRequest.startDate) &&
        Objects.equals(this.endDate, chartRequest.endDate) &&
        Objects.equals(this.filterOnHotelIdentifier, chartRequest.filterOnHotelIdentifier) &&
        Objects.equals(this.filterOnChannelSubType, chartRequest.filterOnChannelSubType) &&
        Objects.equals(this.filterOnOwnerIdentifier, chartRequest.filterOnOwnerIdentifier) &&
        Objects.equals(this.filterOnEngineCountryGeoNameId, chartRequest.filterOnEngineCountryGeoNameId) &&
        Objects.equals(this.filterOnEngineCityGeoNameId, chartRequest.filterOnEngineCityGeoNameId) &&
        Objects.equals(this.filterOnEngineContinentCode, chartRequest.filterOnEngineContinentCode) &&
        Objects.equals(this.filterOnEngineConfigurationIdentifier, chartRequest.filterOnEngineConfigurationIdentifier) &&
        Objects.equals(this.filterOnCountryGeoNameId, chartRequest.filterOnCountryGeoNameId) &&
        Objects.equals(this.filterOnCityGeoNameId, chartRequest.filterOnCityGeoNameId) &&
        Objects.equals(this.filterOnContinentCode, chartRequest.filterOnContinentCode) &&
        Objects.equals(this.filterOnUserIdentifier, chartRequest.filterOnUserIdentifier) &&
        Objects.equals(this.sortOnPageVisits, chartRequest.sortOnPageVisits) &&
        Objects.equals(this.sortOnMapMarkerVisits, chartRequest.sortOnMapMarkerVisits) &&
        Objects.equals(this.sortOnCardVisits, chartRequest.sortOnCardVisits) &&
        Objects.equals(this.sortOnBookings, chartRequest.sortOnBookings) &&
        Objects.equals(this.sortOnCancellations, chartRequest.sortOnCancellations) &&
        Objects.equals(this.sortOnRoomNights, chartRequest.sortOnRoomNights) &&
        Objects.equals(this.sortOnMeetingRooms, chartRequest.sortOnMeetingRooms) &&
        Objects.equals(this.sortOnRestaurants, chartRequest.sortOnRestaurants) &&
        Objects.equals(this.sortOnSpas, chartRequest.sortOnSpas) &&
        Objects.equals(this.sortOnActivities, chartRequest.sortOnActivities) &&
        Objects.equals(this.sortOnAttractions, chartRequest.sortOnAttractions) &&
        Objects.equals(this.sortOnPlaces, chartRequest.sortOnPlaces) &&
        Objects.equals(this.sortOnPackages, chartRequest.sortOnPackages) &&
        Objects.equals(this.sortOnAddOns, chartRequest.sortOnAddOns) &&
        Objects.equals(this.sortOnTotalRoomRevenue, chartRequest.sortOnTotalRoomRevenue) &&
        Objects.equals(this.sortOnPackagesRevenue, chartRequest.sortOnPackagesRevenue) &&
        Objects.equals(this.sortOnAddonsRevenue, chartRequest.sortOnAddonsRevenue) &&
        Objects.equals(this.sortOnPackagesAndAddonsRevenue, chartRequest.sortOnPackagesAndAddonsRevenue) &&
        Objects.equals(this.sortOnTotalNetRevenue, chartRequest.sortOnTotalNetRevenue) &&
        Objects.equals(this.sortOnCancelledRoomNights, chartRequest.sortOnCancelledRoomNights) &&
        Objects.equals(this.sortOnCancelledMeetingRooms, chartRequest.sortOnCancelledMeetingRooms) &&
        Objects.equals(this.sortOnCancelledRestaurants, chartRequest.sortOnCancelledRestaurants) &&
        Objects.equals(this.sortOnCancelledSpas, chartRequest.sortOnCancelledSpas) &&
        Objects.equals(this.sortOnCancelledActivities, chartRequest.sortOnCancelledActivities) &&
        Objects.equals(this.sortOnCancelledAttractions, chartRequest.sortOnCancelledAttractions) &&
        Objects.equals(this.sortOnCancelledPlaces, chartRequest.sortOnCancelledPlaces) &&
        Objects.equals(this.sortOnCancelledPackages, chartRequest.sortOnCancelledPackages) &&
        Objects.equals(this.sortOnCancelledAddOns, chartRequest.sortOnCancelledAddOns) &&
        Objects.equals(this.sortOnCancelledTotalRoomRevenue, chartRequest.sortOnCancelledTotalRoomRevenue) &&
        Objects.equals(this.sortOnCancelledPackagesAndAddonsRevenue, chartRequest.sortOnCancelledPackagesAndAddonsRevenue) &&
        Objects.equals(this.sortOnCancelledPackagesRevenue, chartRequest.sortOnCancelledPackagesRevenue) &&
        Objects.equals(this.sortOnCancelledAddonsRevenue, chartRequest.sortOnCancelledAddonsRevenue) &&
        Objects.equals(this.sortOnCancelledTotalNetRevenue, chartRequest.sortOnCancelledTotalNetRevenue) &&
        Objects.equals(this.includePageVisits, chartRequest.includePageVisits) &&
        Objects.equals(this.includeMapMarkerVisits, chartRequest.includeMapMarkerVisits) &&
        Objects.equals(this.includeCardVisits, chartRequest.includeCardVisits) &&
        Objects.equals(this.includeBookings, chartRequest.includeBookings) &&
        Objects.equals(this.includeCancellations, chartRequest.includeCancellations) &&
        Objects.equals(this.includeRoomNights, chartRequest.includeRoomNights) &&
        Objects.equals(this.includeMeetingRooms, chartRequest.includeMeetingRooms) &&
        Objects.equals(this.includeRestaurants, chartRequest.includeRestaurants) &&
        Objects.equals(this.includeSpas, chartRequest.includeSpas) &&
        Objects.equals(this.includeActivities, chartRequest.includeActivities) &&
        Objects.equals(this.includeAttractions, chartRequest.includeAttractions) &&
        Objects.equals(this.includePlaces, chartRequest.includePlaces) &&
        Objects.equals(this.includePackages, chartRequest.includePackages) &&
        Objects.equals(this.includeAddOns, chartRequest.includeAddOns) &&
        Objects.equals(this.includeTotalRoomRevenue, chartRequest.includeTotalRoomRevenue) &&
        Objects.equals(this.includeAverageRoomRate, chartRequest.includeAverageRoomRate) &&
        Objects.equals(this.includePackagesRevenue, chartRequest.includePackagesRevenue) &&
        Objects.equals(this.includeAddonsRevenue, chartRequest.includeAddonsRevenue) &&
        Objects.equals(this.includePackagesAndAddonsRevenue, chartRequest.includePackagesAndAddonsRevenue) &&
        Objects.equals(this.includeTotalNetRevenue, chartRequest.includeTotalNetRevenue) &&
        Objects.equals(this.includeCancelledRoomNights, chartRequest.includeCancelledRoomNights) &&
        Objects.equals(this.includeCancelledMeetingRooms, chartRequest.includeCancelledMeetingRooms) &&
        Objects.equals(this.includeCancelledRestaurants, chartRequest.includeCancelledRestaurants) &&
        Objects.equals(this.includeCancelledSpas, chartRequest.includeCancelledSpas) &&
        Objects.equals(this.includeCancelledActivities, chartRequest.includeCancelledActivities) &&
        Objects.equals(this.includeCancelledAttractions, chartRequest.includeCancelledAttractions) &&
        Objects.equals(this.includeCancelledPlaces, chartRequest.includeCancelledPlaces) &&
        Objects.equals(this.includeCancelledPackages, chartRequest.includeCancelledPackages) &&
        Objects.equals(this.includeCancelledAddOns, chartRequest.includeCancelledAddOns) &&
        Objects.equals(this.includeCancelledTotalRoomRevenue, chartRequest.includeCancelledTotalRoomRevenue) &&
        Objects.equals(this.includeCancelledPackagesAndAddonsRevenue, chartRequest.includeCancelledPackagesAndAddonsRevenue) &&
        Objects.equals(this.includeCancelledPackagesRevenue, chartRequest.includeCancelledPackagesRevenue) &&
        Objects.equals(this.includeCancelledAddonsRevenue, chartRequest.includeCancelledAddonsRevenue) &&
        Objects.equals(this.includeCancelledTotalNetRevenue, chartRequest.includeCancelledTotalNetRevenue) &&
        Objects.equals(this.groupOnChannelSubType, chartRequest.groupOnChannelSubType) &&
        Objects.equals(this.groupOnOwnerIdentifier, chartRequest.groupOnOwnerIdentifier) &&
        Objects.equals(this.groupOnEngineIdentifier, chartRequest.groupOnEngineIdentifier) &&
        Objects.equals(this.groupOnEngineCountryGeoNameId, chartRequest.groupOnEngineCountryGeoNameId) &&
        Objects.equals(this.groupOnEngineCityGeoNameId, chartRequest.groupOnEngineCityGeoNameId) &&
        Objects.equals(this.groupOnEngineContinentCode, chartRequest.groupOnEngineContinentCode) &&
        Objects.equals(this.groupOnEngineConfigurationIdentifier, chartRequest.groupOnEngineConfigurationIdentifier) &&
        Objects.equals(this.groupOnCountryGeoNameId, chartRequest.groupOnCountryGeoNameId) &&
        Objects.equals(this.groupOnCityGeoNameId, chartRequest.groupOnCityGeoNameId) &&
        Objects.equals(this.groupOnContinentCode, chartRequest.groupOnContinentCode) &&
        Objects.equals(this.groupOnHotelIdentifier, chartRequest.groupOnHotelIdentifier) &&
        Objects.equals(this.groupOnUserIdentifier, chartRequest.groupOnUserIdentifier) &&
        Objects.equals(this.currencyCode, chartRequest.currencyCode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(series, timeSeriesUnits, startDate, endDate, filterOnHotelIdentifier, filterOnChannelSubType, filterOnOwnerIdentifier, filterOnEngineCountryGeoNameId, filterOnEngineCityGeoNameId, filterOnEngineContinentCode, filterOnEngineConfigurationIdentifier, filterOnCountryGeoNameId, filterOnCityGeoNameId, filterOnContinentCode, filterOnUserIdentifier, sortOnPageVisits, sortOnMapMarkerVisits, sortOnCardVisits, sortOnBookings, sortOnCancellations, sortOnRoomNights, sortOnMeetingRooms, sortOnRestaurants, sortOnSpas, sortOnActivities, sortOnAttractions, sortOnPlaces, sortOnPackages, sortOnAddOns, sortOnTotalRoomRevenue, sortOnPackagesRevenue, sortOnAddonsRevenue, sortOnPackagesAndAddonsRevenue, sortOnTotalNetRevenue, sortOnCancelledRoomNights, sortOnCancelledMeetingRooms, sortOnCancelledRestaurants, sortOnCancelledSpas, sortOnCancelledActivities, sortOnCancelledAttractions, sortOnCancelledPlaces, sortOnCancelledPackages, sortOnCancelledAddOns, sortOnCancelledTotalRoomRevenue, sortOnCancelledPackagesAndAddonsRevenue, sortOnCancelledPackagesRevenue, sortOnCancelledAddonsRevenue, sortOnCancelledTotalNetRevenue, includePageVisits, includeMapMarkerVisits, includeCardVisits, includeBookings, includeCancellations, includeRoomNights, includeMeetingRooms, includeRestaurants, includeSpas, includeActivities, includeAttractions, includePlaces, includePackages, includeAddOns, includeTotalRoomRevenue, includeAverageRoomRate, includePackagesRevenue, includeAddonsRevenue, includePackagesAndAddonsRevenue, includeTotalNetRevenue, includeCancelledRoomNights, includeCancelledMeetingRooms, includeCancelledRestaurants, includeCancelledSpas, includeCancelledActivities, includeCancelledAttractions, includeCancelledPlaces, includeCancelledPackages, includeCancelledAddOns, includeCancelledTotalRoomRevenue, includeCancelledPackagesAndAddonsRevenue, includeCancelledPackagesRevenue, includeCancelledAddonsRevenue, includeCancelledTotalNetRevenue, groupOnChannelSubType, groupOnOwnerIdentifier, groupOnEngineIdentifier, groupOnEngineCountryGeoNameId, groupOnEngineCityGeoNameId, groupOnEngineContinentCode, groupOnEngineConfigurationIdentifier, groupOnCountryGeoNameId, groupOnCityGeoNameId, groupOnContinentCode, groupOnHotelIdentifier, groupOnUserIdentifier, currencyCode);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ChartRequest {\n");
    sb.append("    series: ").append(toIndentedString(series)).append("\n");
    sb.append("    timeSeriesUnits: ").append(toIndentedString(timeSeriesUnits)).append("\n");
    sb.append("    startDate: ").append(toIndentedString(startDate)).append("\n");
    sb.append("    endDate: ").append(toIndentedString(endDate)).append("\n");
    sb.append("    filterOnHotelIdentifier: ").append(toIndentedString(filterOnHotelIdentifier)).append("\n");
    sb.append("    filterOnChannelSubType: ").append(toIndentedString(filterOnChannelSubType)).append("\n");
    sb.append("    filterOnOwnerIdentifier: ").append(toIndentedString(filterOnOwnerIdentifier)).append("\n");
    sb.append("    filterOnEngineCountryGeoNameId: ").append(toIndentedString(filterOnEngineCountryGeoNameId)).append("\n");
    sb.append("    filterOnEngineCityGeoNameId: ").append(toIndentedString(filterOnEngineCityGeoNameId)).append("\n");
    sb.append("    filterOnEngineContinentCode: ").append(toIndentedString(filterOnEngineContinentCode)).append("\n");
    sb.append("    filterOnEngineConfigurationIdentifier: ").append(toIndentedString(filterOnEngineConfigurationIdentifier)).append("\n");
    sb.append("    filterOnCountryGeoNameId: ").append(toIndentedString(filterOnCountryGeoNameId)).append("\n");
    sb.append("    filterOnCityGeoNameId: ").append(toIndentedString(filterOnCityGeoNameId)).append("\n");
    sb.append("    filterOnContinentCode: ").append(toIndentedString(filterOnContinentCode)).append("\n");
    sb.append("    filterOnUserIdentifier: ").append(toIndentedString(filterOnUserIdentifier)).append("\n");
    sb.append("    sortOnPageVisits: ").append(toIndentedString(sortOnPageVisits)).append("\n");
    sb.append("    sortOnMapMarkerVisits: ").append(toIndentedString(sortOnMapMarkerVisits)).append("\n");
    sb.append("    sortOnCardVisits: ").append(toIndentedString(sortOnCardVisits)).append("\n");
    sb.append("    sortOnBookings: ").append(toIndentedString(sortOnBookings)).append("\n");
    sb.append("    sortOnCancellations: ").append(toIndentedString(sortOnCancellations)).append("\n");
    sb.append("    sortOnRoomNights: ").append(toIndentedString(sortOnRoomNights)).append("\n");
    sb.append("    sortOnMeetingRooms: ").append(toIndentedString(sortOnMeetingRooms)).append("\n");
    sb.append("    sortOnRestaurants: ").append(toIndentedString(sortOnRestaurants)).append("\n");
    sb.append("    sortOnSpas: ").append(toIndentedString(sortOnSpas)).append("\n");
    sb.append("    sortOnActivities: ").append(toIndentedString(sortOnActivities)).append("\n");
    sb.append("    sortOnAttractions: ").append(toIndentedString(sortOnAttractions)).append("\n");
    sb.append("    sortOnPlaces: ").append(toIndentedString(sortOnPlaces)).append("\n");
    sb.append("    sortOnPackages: ").append(toIndentedString(sortOnPackages)).append("\n");
    sb.append("    sortOnAddOns: ").append(toIndentedString(sortOnAddOns)).append("\n");
    sb.append("    sortOnTotalRoomRevenue: ").append(toIndentedString(sortOnTotalRoomRevenue)).append("\n");
    sb.append("    sortOnPackagesRevenue: ").append(toIndentedString(sortOnPackagesRevenue)).append("\n");
    sb.append("    sortOnAddonsRevenue: ").append(toIndentedString(sortOnAddonsRevenue)).append("\n");
    sb.append("    sortOnPackagesAndAddonsRevenue: ").append(toIndentedString(sortOnPackagesAndAddonsRevenue)).append("\n");
    sb.append("    sortOnTotalNetRevenue: ").append(toIndentedString(sortOnTotalNetRevenue)).append("\n");
    sb.append("    sortOnCancelledRoomNights: ").append(toIndentedString(sortOnCancelledRoomNights)).append("\n");
    sb.append("    sortOnCancelledMeetingRooms: ").append(toIndentedString(sortOnCancelledMeetingRooms)).append("\n");
    sb.append("    sortOnCancelledRestaurants: ").append(toIndentedString(sortOnCancelledRestaurants)).append("\n");
    sb.append("    sortOnCancelledSpas: ").append(toIndentedString(sortOnCancelledSpas)).append("\n");
    sb.append("    sortOnCancelledActivities: ").append(toIndentedString(sortOnCancelledActivities)).append("\n");
    sb.append("    sortOnCancelledAttractions: ").append(toIndentedString(sortOnCancelledAttractions)).append("\n");
    sb.append("    sortOnCancelledPlaces: ").append(toIndentedString(sortOnCancelledPlaces)).append("\n");
    sb.append("    sortOnCancelledPackages: ").append(toIndentedString(sortOnCancelledPackages)).append("\n");
    sb.append("    sortOnCancelledAddOns: ").append(toIndentedString(sortOnCancelledAddOns)).append("\n");
    sb.append("    sortOnCancelledTotalRoomRevenue: ").append(toIndentedString(sortOnCancelledTotalRoomRevenue)).append("\n");
    sb.append("    sortOnCancelledPackagesAndAddonsRevenue: ").append(toIndentedString(sortOnCancelledPackagesAndAddonsRevenue)).append("\n");
    sb.append("    sortOnCancelledPackagesRevenue: ").append(toIndentedString(sortOnCancelledPackagesRevenue)).append("\n");
    sb.append("    sortOnCancelledAddonsRevenue: ").append(toIndentedString(sortOnCancelledAddonsRevenue)).append("\n");
    sb.append("    sortOnCancelledTotalNetRevenue: ").append(toIndentedString(sortOnCancelledTotalNetRevenue)).append("\n");
    sb.append("    includePageVisits: ").append(toIndentedString(includePageVisits)).append("\n");
    sb.append("    includeMapMarkerVisits: ").append(toIndentedString(includeMapMarkerVisits)).append("\n");
    sb.append("    includeCardVisits: ").append(toIndentedString(includeCardVisits)).append("\n");
    sb.append("    includeBookings: ").append(toIndentedString(includeBookings)).append("\n");
    sb.append("    includeCancellations: ").append(toIndentedString(includeCancellations)).append("\n");
    sb.append("    includeRoomNights: ").append(toIndentedString(includeRoomNights)).append("\n");
    sb.append("    includeMeetingRooms: ").append(toIndentedString(includeMeetingRooms)).append("\n");
    sb.append("    includeRestaurants: ").append(toIndentedString(includeRestaurants)).append("\n");
    sb.append("    includeSpas: ").append(toIndentedString(includeSpas)).append("\n");
    sb.append("    includeActivities: ").append(toIndentedString(includeActivities)).append("\n");
    sb.append("    includeAttractions: ").append(toIndentedString(includeAttractions)).append("\n");
    sb.append("    includePlaces: ").append(toIndentedString(includePlaces)).append("\n");
    sb.append("    includePackages: ").append(toIndentedString(includePackages)).append("\n");
    sb.append("    includeAddOns: ").append(toIndentedString(includeAddOns)).append("\n");
    sb.append("    includeTotalRoomRevenue: ").append(toIndentedString(includeTotalRoomRevenue)).append("\n");
    sb.append("    includeAverageRoomRate: ").append(toIndentedString(includeAverageRoomRate)).append("\n");
    sb.append("    includePackagesRevenue: ").append(toIndentedString(includePackagesRevenue)).append("\n");
    sb.append("    includeAddonsRevenue: ").append(toIndentedString(includeAddonsRevenue)).append("\n");
    sb.append("    includePackagesAndAddonsRevenue: ").append(toIndentedString(includePackagesAndAddonsRevenue)).append("\n");
    sb.append("    includeTotalNetRevenue: ").append(toIndentedString(includeTotalNetRevenue)).append("\n");
    sb.append("    includeCancelledRoomNights: ").append(toIndentedString(includeCancelledRoomNights)).append("\n");
    sb.append("    includeCancelledMeetingRooms: ").append(toIndentedString(includeCancelledMeetingRooms)).append("\n");
    sb.append("    includeCancelledRestaurants: ").append(toIndentedString(includeCancelledRestaurants)).append("\n");
    sb.append("    includeCancelledSpas: ").append(toIndentedString(includeCancelledSpas)).append("\n");
    sb.append("    includeCancelledActivities: ").append(toIndentedString(includeCancelledActivities)).append("\n");
    sb.append("    includeCancelledAttractions: ").append(toIndentedString(includeCancelledAttractions)).append("\n");
    sb.append("    includeCancelledPlaces: ").append(toIndentedString(includeCancelledPlaces)).append("\n");
    sb.append("    includeCancelledPackages: ").append(toIndentedString(includeCancelledPackages)).append("\n");
    sb.append("    includeCancelledAddOns: ").append(toIndentedString(includeCancelledAddOns)).append("\n");
    sb.append("    includeCancelledTotalRoomRevenue: ").append(toIndentedString(includeCancelledTotalRoomRevenue)).append("\n");
    sb.append("    includeCancelledPackagesAndAddonsRevenue: ").append(toIndentedString(includeCancelledPackagesAndAddonsRevenue)).append("\n");
    sb.append("    includeCancelledPackagesRevenue: ").append(toIndentedString(includeCancelledPackagesRevenue)).append("\n");
    sb.append("    includeCancelledAddonsRevenue: ").append(toIndentedString(includeCancelledAddonsRevenue)).append("\n");
    sb.append("    includeCancelledTotalNetRevenue: ").append(toIndentedString(includeCancelledTotalNetRevenue)).append("\n");
    sb.append("    groupOnChannelSubType: ").append(toIndentedString(groupOnChannelSubType)).append("\n");
    sb.append("    groupOnOwnerIdentifier: ").append(toIndentedString(groupOnOwnerIdentifier)).append("\n");
    sb.append("    groupOnEngineIdentifier: ").append(toIndentedString(groupOnEngineIdentifier)).append("\n");
    sb.append("    groupOnEngineCountryGeoNameId: ").append(toIndentedString(groupOnEngineCountryGeoNameId)).append("\n");
    sb.append("    groupOnEngineCityGeoNameId: ").append(toIndentedString(groupOnEngineCityGeoNameId)).append("\n");
    sb.append("    groupOnEngineContinentCode: ").append(toIndentedString(groupOnEngineContinentCode)).append("\n");
    sb.append("    groupOnEngineConfigurationIdentifier: ").append(toIndentedString(groupOnEngineConfigurationIdentifier)).append("\n");
    sb.append("    groupOnCountryGeoNameId: ").append(toIndentedString(groupOnCountryGeoNameId)).append("\n");
    sb.append("    groupOnCityGeoNameId: ").append(toIndentedString(groupOnCityGeoNameId)).append("\n");
    sb.append("    groupOnContinentCode: ").append(toIndentedString(groupOnContinentCode)).append("\n");
    sb.append("    groupOnHotelIdentifier: ").append(toIndentedString(groupOnHotelIdentifier)).append("\n");
    sb.append("    groupOnUserIdentifier: ").append(toIndentedString(groupOnUserIdentifier)).append("\n");
    sb.append("    currencyCode: ").append(toIndentedString(currencyCode)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

