/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Booking Engine](/booking-engine): All APIs related to searching for travel inventory and creating bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [TripPay Acquiring](/payment-acquiring): All APIs related to how our Web Components work. - [TripPay](/payment): All APIs related to account management, mapping and integrator features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.payment-v`1`+json.  ## Release history - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Extranet API Welcome to the Extranet API - A programmer-friendly way to manage your travel inventory on the wink payment. This API offers a superset of the features you can find at [https://extranet.wink.travel](https://extranet.wink.travel) and gives you all the tools you need to ready your properties and inventory for sale across 10000s of our unique sales channels. What differentiates us from existing Extranets is 1. we make it available for everyone to use and 2. the care we take in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Content creators have the ability to make their inventory look great and be searchable in a wide variety of ways. You won't find properties with generic inventory, low resolution pictures and little ancillary content that can easily be found everywhere else on the internet.  # Integrations We have already integrated with the most well-known channel managers so you don't have to. Once your properties are set up, you can finish the setup by mapping your property to wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API. - Allotz - CloudBeds / MyAllocator - Comanche - d-edge - FastBooking - HotelLink - HoteliersGuru - Omnibees - RateGain - Rate Tiger - ResAvenue - Siteminder - Sabre SynXis - Travelclick - Yieldplanet  # Intended Audience Programmers are [most likely] a requirement to start integrating with wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible. - Hotel chains - Hotel brands - Travel tech companies - Destination sites - Integrators - Aggregators - Destination management companies - Travel agencies - OTAs  
 *
 * The version of the OpenAPI document: 21.15.1
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.extranet.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Property information.
 */
@ApiModel(description = "Property information.")
@JsonPropertyOrder({
  HotelInformation.JSON_PROPERTY_NAME,
  HotelInformation.JSON_PROPERTY_LOCAL_NAME,
  HotelInformation.JSON_PROPERTY_LEGAL_NAME,
  HotelInformation.JSON_PROPERTY_CURRENCY_CODE,
  HotelInformation.JSON_PROPERTY_NUMBER_OF_ROOMS,
  HotelInformation.JSON_PROPERTY_LOCATION_CATEGORY,
  HotelInformation.JSON_PROPERTY_SEGMENT_CATEGORY,
  HotelInformation.JSON_PROPERTY_HOTEL_CATEGORY,
  HotelInformation.JSON_PROPERTY_ARCHITECTURAL_STYLE,
  HotelInformation.JSON_PROPERTY_WHEN_BUILT,
  HotelInformation.JSON_PROPERTY_HOTEL_CHAIN,
  HotelInformation.JSON_PROPERTY_HOTEL_BRAND,
  HotelInformation.JSON_PROPERTY_CHANNEL_MANAGER,
  HotelInformation.JSON_PROPERTY_OTHER_CHANNEL_MANAGER,
  HotelInformation.JSON_PROPERTY_LICENSE_NUMBER
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-09-08T16:32:28.411222+07:00[Asia/Bangkok]")
public class HotelInformation {
  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_LOCAL_NAME = "localName";
  private String localName;

  public static final String JSON_PROPERTY_LEGAL_NAME = "legalName";
  private String legalName;

  public static final String JSON_PROPERTY_CURRENCY_CODE = "currencyCode";
  private String currencyCode;

  public static final String JSON_PROPERTY_NUMBER_OF_ROOMS = "numberOfRooms";
  private Integer numberOfRooms;

  public static final String JSON_PROPERTY_LOCATION_CATEGORY = "locationCategory";
  private String locationCategory;

  public static final String JSON_PROPERTY_SEGMENT_CATEGORY = "segmentCategory";
  private String segmentCategory;

  public static final String JSON_PROPERTY_HOTEL_CATEGORY = "hotelCategory";
  private String hotelCategory;

  public static final String JSON_PROPERTY_ARCHITECTURAL_STYLE = "architecturalStyle";
  private String architecturalStyle;

  public static final String JSON_PROPERTY_WHEN_BUILT = "whenBuilt";
  private String whenBuilt;

  public static final String JSON_PROPERTY_HOTEL_CHAIN = "hotelChain";
  private String hotelChain;

  public static final String JSON_PROPERTY_HOTEL_BRAND = "hotelBrand";
  private String hotelBrand;

  /**
   * Property&#39;s channel manager. Rate ownership is decided based on the channel manager selected. Defaults to &#x60;TRAVELIKO&#x60; which is the same as no channel manager and rate ownership goes to the payment.
   */
  public enum ChannelManagerEnum {
    TRAVELIKO("TRAVELIKO"),
    
    SITEMINDER("SITEMINDER"),
    
    FASTBOOKING("FASTBOOKING"),
    
    RATEGAIN("RATEGAIN"),
    
    CLOUD_BEDS("CLOUD_BEDS"),
    
    YIELD_PLANET("YIELD_PLANET"),
    
    TRAVELCLICK("TRAVELCLICK"),
    
    HOTEL_GURU("HOTEL_GURU"),
    
    OTHER_CHANNEL_MANAGER("OTHER_CHANNEL_MANAGER"),
    
    BOOKING_JINI("BOOKING_JINI"),
    
    HOTEL_LINK_SOLUTIONS("HOTEL_LINK_SOLUTIONS"),
    
    ALLOTZ("ALLOTZ"),
    
    DEDGE("DEDGE"),
    
    RATE_TIGER("RATE_TIGER"),
    
    RESAVENUE("RESAVENUE"),
    
    COMANCHE("COMANCHE"),
    
    OMNIBEES("OMNIBEES"),
    
    EZEE("EZEE"),
    
    SYNXIS("SYNXIS");

    private String value;

    ChannelManagerEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ChannelManagerEnum fromValue(String value) {
      for (ChannelManagerEnum b : ChannelManagerEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_CHANNEL_MANAGER = "channelManager";
  private ChannelManagerEnum channelManager = ChannelManagerEnum.TRAVELIKO;

  public static final String JSON_PROPERTY_OTHER_CHANNEL_MANAGER = "otherChannelManager";
  private String otherChannelManager;

  public static final String JSON_PROPERTY_LICENSE_NUMBER = "licenseNumber";
  private String licenseNumber;

  public HotelInformation() { 
  }

  public HotelInformation name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Unique hotel trade name. The hotel name must be unique. If there are multiple hotels with the same name, we recommend appending destination to the name. [Verify uniqueness here](#operation/isHotelNameUnique).
   * @return name
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "The Getaway resort - Ubud", required = true, value = "Unique hotel trade name. The hotel name must be unique. If there are multiple hotels with the same name, we recommend appending destination to the name. [Verify uniqueness here](#operation/isHotelNameUnique).")
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(String name) {
    this.name = name;
  }


  public HotelInformation localName(String localName) {
    
    this.localName = localName;
    return this;
  }

   /**
   * Name of the hotel in its local language if you use it for domestic guests.
   * @return localName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "Resor Ubud Getaway", value = "Name of the hotel in its local language if you use it for domestic guests.")
  @JsonProperty(JSON_PROPERTY_LOCAL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLocalName() {
    return localName;
  }


  @JsonProperty(JSON_PROPERTY_LOCAL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLocalName(String localName) {
    this.localName = localName;
  }


  public HotelInformation legalName(String legalName) {
    
    this.legalName = legalName;
    return this;
  }

   /**
   * Legal name of your hotel as it is registered.
   * @return legalName
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "Getaway Resorts Limited", required = true, value = "Legal name of your hotel as it is registered.")
  @JsonProperty(JSON_PROPERTY_LEGAL_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getLegalName() {
    return legalName;
  }


  @JsonProperty(JSON_PROPERTY_LEGAL_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setLegalName(String legalName) {
    this.legalName = legalName;
  }


  public HotelInformation currencyCode(String currencyCode) {
    
    this.currencyCode = currencyCode;
    return this;
  }

   /**
   * Valid 3-character ISO currency code. Find our [supported currency codes here](#operation/showCurrencies).
   * @return currencyCode
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "INR", required = true, value = "Valid 3-character ISO currency code. Find our [supported currency codes here](#operation/showCurrencies).")
  @JsonProperty(JSON_PROPERTY_CURRENCY_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getCurrencyCode() {
    return currencyCode;
  }


  @JsonProperty(JSON_PROPERTY_CURRENCY_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCurrencyCode(String currencyCode) {
    this.currencyCode = currencyCode;
  }


  public HotelInformation numberOfRooms(Integer numberOfRooms) {
    
    this.numberOfRooms = numberOfRooms;
    return this;
  }

   /**
   * Number of rooms / keys for property
   * minimum: 1
   * @return numberOfRooms
  **/
  @javax.annotation.Nonnull
  @NotNull
 @Min(1)  @ApiModelProperty(example = "40", required = true, value = "Number of rooms / keys for property")
  @JsonProperty(JSON_PROPERTY_NUMBER_OF_ROOMS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getNumberOfRooms() {
    return numberOfRooms;
  }


  @JsonProperty(JSON_PROPERTY_NUMBER_OF_ROOMS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setNumberOfRooms(Integer numberOfRooms) {
    this.numberOfRooms = numberOfRooms;
  }


  public HotelInformation locationCategory(String locationCategory) {
    
    this.locationCategory = locationCategory;
    return this;
  }

   /**
   * Supported OTA specification &#x60;LOC&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return locationCategory
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "34", value = "Supported OTA specification `LOC` code. See [OTA geoname data](#operation/showAvailableCodesForCategory)")
  @JsonProperty(JSON_PROPERTY_LOCATION_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLocationCategory() {
    return locationCategory;
  }


  @JsonProperty(JSON_PROPERTY_LOCATION_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLocationCategory(String locationCategory) {
    this.locationCategory = locationCategory;
  }


  public HotelInformation segmentCategory(String segmentCategory) {
    
    this.segmentCategory = segmentCategory;
    return this;
  }

   /**
   * Supported OTA specification &#x60;SEG&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return segmentCategory
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "7", value = "Supported OTA specification `SEG` code. See [OTA geoname data](#operation/showAvailableCodesForCategory)")
  @JsonProperty(JSON_PROPERTY_SEGMENT_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSegmentCategory() {
    return segmentCategory;
  }


  @JsonProperty(JSON_PROPERTY_SEGMENT_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSegmentCategory(String segmentCategory) {
    this.segmentCategory = segmentCategory;
  }


  public HotelInformation hotelCategory(String hotelCategory) {
    
    this.hotelCategory = hotelCategory;
    return this;
  }

   /**
   * Supported OTA specification &#x60;PCT&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return hotelCategory
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "45", value = "Supported OTA specification `PCT` code. See [OTA geoname data](#operation/showAvailableCodesForCategory)")
  @JsonProperty(JSON_PROPERTY_HOTEL_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getHotelCategory() {
    return hotelCategory;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHotelCategory(String hotelCategory) {
    this.hotelCategory = hotelCategory;
  }


  public HotelInformation architecturalStyle(String architecturalStyle) {
    
    this.architecturalStyle = architecturalStyle;
    return this;
  }

   /**
   * Supported OTA specification &#x60;ARC&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return architecturalStyle
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "7", value = "Supported OTA specification `ARC` code. See [OTA geoname data](#operation/showAvailableCodesForCategory)")
  @JsonProperty(JSON_PROPERTY_ARCHITECTURAL_STYLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getArchitecturalStyle() {
    return architecturalStyle;
  }


  @JsonProperty(JSON_PROPERTY_ARCHITECTURAL_STYLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setArchitecturalStyle(String architecturalStyle) {
    this.architecturalStyle = architecturalStyle;
  }


  public HotelInformation whenBuilt(String whenBuilt) {
    
    this.whenBuilt = whenBuilt;
    return this;
  }

   /**
   * Year the property was constructed.
   * @return whenBuilt
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "1927", value = "Year the property was constructed.")
  @JsonProperty(JSON_PROPERTY_WHEN_BUILT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getWhenBuilt() {
    return whenBuilt;
  }


  @JsonProperty(JSON_PROPERTY_WHEN_BUILT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWhenBuilt(String whenBuilt) {
    this.whenBuilt = whenBuilt;
  }


  public HotelInformation hotelChain(String hotelChain) {
    
    this.hotelChain = hotelChain;
    return this;
  }

   /**
   * Hotel chain name if property is part of that chain.
   * @return hotelChain
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "Getaway Resorts", value = "Hotel chain name if property is part of that chain.")
  @JsonProperty(JSON_PROPERTY_HOTEL_CHAIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getHotelChain() {
    return hotelChain;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_CHAIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHotelChain(String hotelChain) {
    this.hotelChain = hotelChain;
  }


  public HotelInformation hotelBrand(String hotelBrand) {
    
    this.hotelBrand = hotelBrand;
    return this;
  }

   /**
   * Hotel brand name if property is part of that brand.
   * @return hotelBrand
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "Happy Resorts", value = "Hotel brand name if property is part of that brand.")
  @JsonProperty(JSON_PROPERTY_HOTEL_BRAND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getHotelBrand() {
    return hotelBrand;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_BRAND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHotelBrand(String hotelBrand) {
    this.hotelBrand = hotelBrand;
  }


  public HotelInformation channelManager(ChannelManagerEnum channelManager) {
    
    this.channelManager = channelManager;
    return this;
  }

   /**
   * Property&#39;s channel manager. Rate ownership is decided based on the channel manager selected. Defaults to &#x60;TRAVELIKO&#x60; which is the same as no channel manager and rate ownership goes to the payment.
   * @return channelManager
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "OTHER_CHANNEL_MANAGER", value = "Property's channel manager. Rate ownership is decided based on the channel manager selected. Defaults to `TRAVELIKO` which is the same as no channel manager and rate ownership goes to the payment.")
  @JsonProperty(JSON_PROPERTY_CHANNEL_MANAGER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ChannelManagerEnum getChannelManager() {
    return channelManager;
  }


  @JsonProperty(JSON_PROPERTY_CHANNEL_MANAGER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setChannelManager(ChannelManagerEnum channelManager) {
    this.channelManager = channelManager;
  }


  public HotelInformation otherChannelManager(String otherChannelManager) {
    
    this.otherChannelManager = otherChannelManager;
    return this;
  }

   /**
   * If the property is currently using a channel manager but it isn&#39;t yet part of our list, chose &#39;OTHER_CHANNEL_MANAGER&#39; as channelManager and fill in the name of the channel manager here
   * @return otherChannelManager
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "CM X", value = "If the property is currently using a channel manager but it isn't yet part of our list, chose 'OTHER_CHANNEL_MANAGER' as channelManager and fill in the name of the channel manager here")
  @JsonProperty(JSON_PROPERTY_OTHER_CHANNEL_MANAGER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getOtherChannelManager() {
    return otherChannelManager;
  }


  @JsonProperty(JSON_PROPERTY_OTHER_CHANNEL_MANAGER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOtherChannelManager(String otherChannelManager) {
    this.otherChannelManager = otherChannelManager;
  }


  public HotelInformation licenseNumber(String licenseNumber) {
    
    this.licenseNumber = licenseNumber;
    return this;
  }

   /**
   * If the property has a valid license number to run a hotel in their country, add it here.
   * @return licenseNumber
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "ABC1234", value = "If the property has a valid license number to run a hotel in their country, add it here.")
  @JsonProperty(JSON_PROPERTY_LICENSE_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLicenseNumber() {
    return licenseNumber;
  }


  @JsonProperty(JSON_PROPERTY_LICENSE_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLicenseNumber(String licenseNumber) {
    this.licenseNumber = licenseNumber;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    HotelInformation hotelInformation = (HotelInformation) o;
    return Objects.equals(this.name, hotelInformation.name) &&
        Objects.equals(this.localName, hotelInformation.localName) &&
        Objects.equals(this.legalName, hotelInformation.legalName) &&
        Objects.equals(this.currencyCode, hotelInformation.currencyCode) &&
        Objects.equals(this.numberOfRooms, hotelInformation.numberOfRooms) &&
        Objects.equals(this.locationCategory, hotelInformation.locationCategory) &&
        Objects.equals(this.segmentCategory, hotelInformation.segmentCategory) &&
        Objects.equals(this.hotelCategory, hotelInformation.hotelCategory) &&
        Objects.equals(this.architecturalStyle, hotelInformation.architecturalStyle) &&
        Objects.equals(this.whenBuilt, hotelInformation.whenBuilt) &&
        Objects.equals(this.hotelChain, hotelInformation.hotelChain) &&
        Objects.equals(this.hotelBrand, hotelInformation.hotelBrand) &&
        Objects.equals(this.channelManager, hotelInformation.channelManager) &&
        Objects.equals(this.otherChannelManager, hotelInformation.otherChannelManager) &&
        Objects.equals(this.licenseNumber, hotelInformation.licenseNumber);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, localName, legalName, currencyCode, numberOfRooms, locationCategory, segmentCategory, hotelCategory, architecturalStyle, whenBuilt, hotelChain, hotelBrand, channelManager, otherChannelManager, licenseNumber);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class HotelInformation {\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    localName: ").append(toIndentedString(localName)).append("\n");
    sb.append("    legalName: ").append(toIndentedString(legalName)).append("\n");
    sb.append("    currencyCode: ").append(toIndentedString(currencyCode)).append("\n");
    sb.append("    numberOfRooms: ").append(toIndentedString(numberOfRooms)).append("\n");
    sb.append("    locationCategory: ").append(toIndentedString(locationCategory)).append("\n");
    sb.append("    segmentCategory: ").append(toIndentedString(segmentCategory)).append("\n");
    sb.append("    hotelCategory: ").append(toIndentedString(hotelCategory)).append("\n");
    sb.append("    architecturalStyle: ").append(toIndentedString(architecturalStyle)).append("\n");
    sb.append("    whenBuilt: ").append(toIndentedString(whenBuilt)).append("\n");
    sb.append("    hotelChain: ").append(toIndentedString(hotelChain)).append("\n");
    sb.append("    hotelBrand: ").append(toIndentedString(hotelBrand)).append("\n");
    sb.append("    channelManager: ").append(toIndentedString(channelManager)).append("\n");
    sb.append("    otherChannelManager: ").append(toIndentedString(otherChannelManager)).append("\n");
    sb.append("    licenseNumber: ").append(toIndentedString(licenseNumber)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

