/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Booking Engine](/booking-engine): All APIs related to searching for travel inventory and creating bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [TripPay Acquiring](/payment-acquiring): All APIs related to how our Web Components work. - [TripPay](/payment): All APIs related to account management, mapping and integrator features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.payment-v`1`+json.  ## Release history - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Extranet API Welcome to the Extranet API - A programmer-friendly way to manage your travel inventory on the wink payment. This API offers a superset of the features you can find at [https://extranet.wink.travel](https://extranet.wink.travel) and gives you all the tools you need to ready your properties and inventory for sale across 10000s of our unique sales channels. What differentiates us from existing Extranets is 1. we make it available for everyone to use and 2. the care we take in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Content creators have the ability to make their inventory look great and be searchable in a wide variety of ways. You won't find properties with generic inventory, low resolution pictures and little ancillary content that can easily be found everywhere else on the internet.  # Integrations We have already integrated with the most well-known channel managers so you don't have to. Once your properties are set up, you can finish the setup by mapping your property to wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API. - Allotz - CloudBeds / MyAllocator - Comanche - d-edge - FastBooking - HotelLink - HoteliersGuru - Omnibees - RateGain - Rate Tiger - ResAvenue - Siteminder - Sabre SynXis - Travelclick - Yieldplanet  # Intended Audience Programmers are [most likely] a requirement to start integrating with wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible. - Hotel chains - Hotel brands - Travel tech companies - Destination sites - Integrators - Aggregators - Destination management companies - Travel agencies - OTAs  
 *
 * The version of the OpenAPI document: 21.15.1
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.extranet.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import travel.wink.sdk.extranet.model.Address;
import travel.wink.sdk.extranet.model.Contact;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * ScheduleItem
 */
@JsonPropertyOrder({
  ScheduleItem.JSON_PROPERTY_IDENTIFIER,
  ScheduleItem.JSON_PROPERTY_START,
  ScheduleItem.JSON_PROPERTY_START_TIMEZONE,
  ScheduleItem.JSON_PROPERTY_END,
  ScheduleItem.JSON_PROPERTY_END_TIMEZONE,
  ScheduleItem.JSON_PROPERTY_TITLE,
  ScheduleItem.JSON_PROPERTY_DESCRIPTION,
  ScheduleItem.JSON_PROPERTY_RECURRENCE_RULE,
  ScheduleItem.JSON_PROPERTY_RECURRENCE_ID,
  ScheduleItem.JSON_PROPERTY_RECURRENCE_EXCEPTION,
  ScheduleItem.JSON_PROPERTY_OWNER_IDENTIFIER,
  ScheduleItem.JSON_PROPERTY_BOOKING_IDENTIFIER,
  ScheduleItem.JSON_PROPERTY_BOOKING_OWNER_IDENTIFIER,
  ScheduleItem.JSON_PROPERTY_HOTEL_IDENTIFIER,
  ScheduleItem.JSON_PROPERTY_TYPE,
  ScheduleItem.JSON_PROPERTY_ATTENDEES,
  ScheduleItem.JSON_PROPERTY_EMAIL,
  ScheduleItem.JSON_PROPERTY_FULL_NAME,
  ScheduleItem.JSON_PROPERTY_FIRST_NAME,
  ScheduleItem.JSON_PROPERTY_LAST_NAME,
  ScheduleItem.JSON_PROPERTY_VENUE_NAME,
  ScheduleItem.JSON_PROPERTY_LOCALIZED_VENUE_NAME,
  ScheduleItem.JSON_PROPERTY_CONTACT,
  ScheduleItem.JSON_PROPERTY_ADDRESS,
  ScheduleItem.JSON_PROPERTY_CREATED,
  ScheduleItem.JSON_PROPERTY_LAST_MODIFIED,
  ScheduleItem.JSON_PROPERTY_SEQUENCE,
  ScheduleItem.JSON_PROPERTY_EMAIL_HEADER_LOGO_URL,
  ScheduleItem.JSON_PROPERTY_LOGO_IDENTIFIER,
  ScheduleItem.JSON_PROPERTY_ALL_DAY
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-09-08T16:32:28.411222+07:00[Asia/Bangkok]")
public class ScheduleItem {
  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  private UUID identifier;

  public static final String JSON_PROPERTY_START = "start";
  private OffsetDateTime start;

  public static final String JSON_PROPERTY_START_TIMEZONE = "startTimezone";
  private String startTimezone;

  public static final String JSON_PROPERTY_END = "end";
  private OffsetDateTime end;

  public static final String JSON_PROPERTY_END_TIMEZONE = "endTimezone";
  private String endTimezone;

  public static final String JSON_PROPERTY_TITLE = "title";
  private String title;

  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  private String description;

  public static final String JSON_PROPERTY_RECURRENCE_RULE = "recurrenceRule";
  private String recurrenceRule;

  public static final String JSON_PROPERTY_RECURRENCE_ID = "recurrenceId";
  private String recurrenceId;

  public static final String JSON_PROPERTY_RECURRENCE_EXCEPTION = "recurrenceException";
  private List<OffsetDateTime> recurrenceException = null;

  public static final String JSON_PROPERTY_OWNER_IDENTIFIER = "ownerIdentifier";
  private UUID ownerIdentifier;

  public static final String JSON_PROPERTY_BOOKING_IDENTIFIER = "bookingIdentifier";
  private UUID bookingIdentifier;

  public static final String JSON_PROPERTY_BOOKING_OWNER_IDENTIFIER = "bookingOwnerIdentifier";
  private UUID bookingOwnerIdentifier;

  public static final String JSON_PROPERTY_HOTEL_IDENTIFIER = "hotelIdentifier";
  private UUID hotelIdentifier;

  /**
   * The type of travel inventory.
   */
  public enum TypeEnum {
    MEETING_ROOM("MEETING_ROOM"),
    
    SPA("SPA"),
    
    RESTAURANT("RESTAURANT"),
    
    ACTIVITY("ACTIVITY"),
    
    ATTRACTION("ATTRACTION"),
    
    PLACE("PLACE");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public static final String JSON_PROPERTY_ATTENDEES = "attendees";
  private Integer attendees = 1;

  public static final String JSON_PROPERTY_EMAIL = "email";
  private String email;

  public static final String JSON_PROPERTY_FULL_NAME = "fullName";
  private String fullName;

  public static final String JSON_PROPERTY_FIRST_NAME = "firstName";
  private String firstName;

  public static final String JSON_PROPERTY_LAST_NAME = "lastName";
  private String lastName;

  public static final String JSON_PROPERTY_VENUE_NAME = "venueName";
  private String venueName;

  public static final String JSON_PROPERTY_LOCALIZED_VENUE_NAME = "localizedVenueName";
  private String localizedVenueName;

  public static final String JSON_PROPERTY_CONTACT = "contact";
  private Contact contact;

  public static final String JSON_PROPERTY_ADDRESS = "address";
  private Address address;

  public static final String JSON_PROPERTY_CREATED = "created";
  private OffsetDateTime created;

  public static final String JSON_PROPERTY_LAST_MODIFIED = "lastModified";
  private OffsetDateTime lastModified;

  public static final String JSON_PROPERTY_SEQUENCE = "sequence";
  private Long sequence;

  public static final String JSON_PROPERTY_EMAIL_HEADER_LOGO_URL = "emailHeaderLogoUrl";
  private String emailHeaderLogoUrl;

  public static final String JSON_PROPERTY_LOGO_IDENTIFIER = "logoIdentifier";
  private String logoIdentifier;

  public static final String JSON_PROPERTY_ALL_DAY = "allDay";
  private Boolean allDay;

  public ScheduleItem() { 
  }

  public ScheduleItem identifier(UUID identifier) {
    
    this.identifier = identifier;
    return this;
  }

   /**
   * Unique schedule identifier
   * @return identifier
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Unique schedule identifier")
  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIdentifier(UUID identifier) {
    this.identifier = identifier;
  }


  public ScheduleItem start(OffsetDateTime start) {
    
    this.start = start;
    return this;
  }

   /**
   * Start date time of scheduled event
   * @return start
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Start date time of scheduled event")
  @JsonProperty(JSON_PROPERTY_START)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getStart() {
    return start;
  }


  @JsonProperty(JSON_PROPERTY_START)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStart(OffsetDateTime start) {
    this.start = start;
  }


  public ScheduleItem startTimezone(String startTimezone) {
    
    this.startTimezone = startTimezone;
    return this;
  }

   /**
   * Schedule timezone
   * @return startTimezone
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Schedule timezone")
  @JsonProperty(JSON_PROPERTY_START_TIMEZONE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getStartTimezone() {
    return startTimezone;
  }


  @JsonProperty(JSON_PROPERTY_START_TIMEZONE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStartTimezone(String startTimezone) {
    this.startTimezone = startTimezone;
  }


  public ScheduleItem end(OffsetDateTime end) {
    
    this.end = end;
    return this;
  }

   /**
   * End date time of scheduled event
   * @return end
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "End date time of scheduled event")
  @JsonProperty(JSON_PROPERTY_END)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getEnd() {
    return end;
  }


  @JsonProperty(JSON_PROPERTY_END)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEnd(OffsetDateTime end) {
    this.end = end;
  }


  public ScheduleItem endTimezone(String endTimezone) {
    
    this.endTimezone = endTimezone;
    return this;
  }

   /**
   * Schedule timezone
   * @return endTimezone
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Schedule timezone")
  @JsonProperty(JSON_PROPERTY_END_TIMEZONE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getEndTimezone() {
    return endTimezone;
  }


  @JsonProperty(JSON_PROPERTY_END_TIMEZONE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEndTimezone(String endTimezone) {
    this.endTimezone = endTimezone;
  }


  public ScheduleItem title(String title) {
    
    this.title = title;
    return this;
  }

   /**
   * Title of scheduled event.
   * @return title
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "Jane Doe +1", value = "Title of scheduled event.")
  @JsonProperty(JSON_PROPERTY_TITLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTitle() {
    return title;
  }


  @JsonProperty(JSON_PROPERTY_TITLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTitle(String title) {
    this.title = title;
  }


  public ScheduleItem description(String description) {
    
    this.description = description;
    return this;
  }

   /**
   * Description of scheduled event.
   * @return description
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "Reservation for Jane Doe - 2 PAX", value = "Description of scheduled event.")
  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDescription() {
    return description;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDescription(String description) {
    this.description = description;
  }


  public ScheduleItem recurrenceRule(String recurrenceRule) {
    
    this.recurrenceRule = recurrenceRule;
    return this;
  }

   /**
   * If rule is present, indicates that scheduled event is a recurring event. For more details go to the [iCalendar website](https://icalendar.org/)
   * @return recurrenceRule
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "FREQ=DAILY;COUNT=5;", value = "If rule is present, indicates that scheduled event is a recurring event. For more details go to the [iCalendar website](https://icalendar.org/)")
  @JsonProperty(JSON_PROPERTY_RECURRENCE_RULE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRecurrenceRule() {
    return recurrenceRule;
  }


  @JsonProperty(JSON_PROPERTY_RECURRENCE_RULE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRecurrenceRule(String recurrenceRule) {
    this.recurrenceRule = recurrenceRule;
  }


  public ScheduleItem recurrenceId(String recurrenceId) {
    
    this.recurrenceId = recurrenceId;
    return this;
  }

   /**
   * The parent ID of the recurring event.
   * @return recurrenceId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "schedule-parent-1", value = "The parent ID of the recurring event.")
  @JsonProperty(JSON_PROPERTY_RECURRENCE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRecurrenceId() {
    return recurrenceId;
  }


  @JsonProperty(JSON_PROPERTY_RECURRENCE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRecurrenceId(String recurrenceId) {
    this.recurrenceId = recurrenceId;
  }


  public ScheduleItem recurrenceException(List<OffsetDateTime> recurrenceException) {
    
    this.recurrenceException = recurrenceException;
    return this;
  }

  public ScheduleItem addRecurrenceExceptionItem(OffsetDateTime recurrenceExceptionItem) {
    if (this.recurrenceException == null) {
      this.recurrenceException = new ArrayList<>();
    }
    this.recurrenceException.add(recurrenceExceptionItem);
    return this;
  }

   /**
   * Exceptions to the recurrence rule.
   * @return recurrenceException
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(example = "[\"2017-12-22T03:07:58.742+0000\"]", value = "Exceptions to the recurrence rule.")
  @JsonProperty(JSON_PROPERTY_RECURRENCE_EXCEPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<OffsetDateTime> getRecurrenceException() {
    return recurrenceException;
  }


  @JsonProperty(JSON_PROPERTY_RECURRENCE_EXCEPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRecurrenceException(List<OffsetDateTime> recurrenceException) {
    this.recurrenceException = recurrenceException;
  }


  public ScheduleItem ownerIdentifier(UUID ownerIdentifier) {
    
    this.ownerIdentifier = ownerIdentifier;
    return this;
  }

   /**
   * The unique identifier of the travel inventory you are creating a scheduled event for.
   * @return ownerIdentifier
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "The unique identifier of the travel inventory you are creating a scheduled event for.")
  @JsonProperty(JSON_PROPERTY_OWNER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getOwnerIdentifier() {
    return ownerIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_OWNER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOwnerIdentifier(UUID ownerIdentifier) {
    this.ownerIdentifier = ownerIdentifier;
  }


  public ScheduleItem bookingIdentifier(UUID bookingIdentifier) {
    
    this.bookingIdentifier = bookingIdentifier;
    return this;
  }

   /**
   * Booking identifier this scheduled event was created as part of.
   * @return bookingIdentifier
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Booking identifier this scheduled event was created as part of.")
  @JsonProperty(JSON_PROPERTY_BOOKING_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getBookingIdentifier() {
    return bookingIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_BOOKING_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBookingIdentifier(UUID bookingIdentifier) {
    this.bookingIdentifier = bookingIdentifier;
  }


  public ScheduleItem bookingOwnerIdentifier(UUID bookingOwnerIdentifier) {
    
    this.bookingOwnerIdentifier = bookingOwnerIdentifier;
    return this;
  }

   /**
   * Which company owns this schedule. (Owner of the engine)
   * @return bookingOwnerIdentifier
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Which company owns this schedule. (Owner of the engine)")
  @JsonProperty(JSON_PROPERTY_BOOKING_OWNER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getBookingOwnerIdentifier() {
    return bookingOwnerIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_BOOKING_OWNER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBookingOwnerIdentifier(UUID bookingOwnerIdentifier) {
    this.bookingOwnerIdentifier = bookingOwnerIdentifier;
  }


  public ScheduleItem hotelIdentifier(UUID hotelIdentifier) {
    
    this.hotelIdentifier = hotelIdentifier;
    return this;
  }

   /**
   * Hotel identifier that owns the travel inventory.
   * @return hotelIdentifier
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Hotel identifier that owns the travel inventory.")
  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getHotelIdentifier() {
    return hotelIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHotelIdentifier(UUID hotelIdentifier) {
    this.hotelIdentifier = hotelIdentifier;
  }


  public ScheduleItem type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * The type of travel inventory.
   * @return type
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "MEETING_ROOM", value = "The type of travel inventory.")
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  public ScheduleItem attendees(Integer attendees) {
    
    this.attendees = attendees;
    return this;
  }

   /**
   * Number of guests attending this event.
   * minimum: 1
   * @return attendees
  **/
  @javax.annotation.Nullable
 @Min(1)  @ApiModelProperty(example = "2", value = "Number of guests attending this event.")
  @JsonProperty(JSON_PROPERTY_ATTENDEES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getAttendees() {
    return attendees;
  }


  @JsonProperty(JSON_PROPERTY_ATTENDEES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAttendees(Integer attendees) {
    this.attendees = attendees;
  }


  public ScheduleItem email(String email) {
    
    this.email = email;
    return this;
  }

   /**
   * Email of the person scheduling this event.
   * @return email
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "jane@doe.com", required = true, value = "Email of the person scheduling this event.")
  @JsonProperty(JSON_PROPERTY_EMAIL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getEmail() {
    return email;
  }


  @JsonProperty(JSON_PROPERTY_EMAIL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setEmail(String email) {
    this.email = email;
  }


  public ScheduleItem fullName(String fullName) {
    
    this.fullName = fullName;
    return this;
  }

   /**
   * Full name of person scheduling this event.
   * @return fullName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "Jane Doe", value = "Full name of person scheduling this event.")
  @JsonProperty(JSON_PROPERTY_FULL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFullName() {
    return fullName;
  }


  @JsonProperty(JSON_PROPERTY_FULL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFullName(String fullName) {
    this.fullName = fullName;
  }


  public ScheduleItem firstName(String firstName) {
    
    this.firstName = firstName;
    return this;
  }

   /**
   * First name of person scheduling this event.
   * @return firstName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "Jane", value = "First name of person scheduling this event.")
  @JsonProperty(JSON_PROPERTY_FIRST_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFirstName() {
    return firstName;
  }


  @JsonProperty(JSON_PROPERTY_FIRST_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFirstName(String firstName) {
    this.firstName = firstName;
  }


  public ScheduleItem lastName(String lastName) {
    
    this.lastName = lastName;
    return this;
  }

   /**
   * Last name of person scheduling this event.
   * @return lastName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "Doe", value = "Last name of person scheduling this event.")
  @JsonProperty(JSON_PROPERTY_LAST_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLastName() {
    return lastName;
  }


  @JsonProperty(JSON_PROPERTY_LAST_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLastName(String lastName) {
    this.lastName = lastName;
  }


  public ScheduleItem venueName(String venueName) {
    
    this.venueName = venueName;
    return this;
  }

   /**
   * Name of venue attendees will visit.
   * @return venueName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "Restaurant 1", value = "Name of venue attendees will visit.")
  @JsonProperty(JSON_PROPERTY_VENUE_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getVenueName() {
    return venueName;
  }


  @JsonProperty(JSON_PROPERTY_VENUE_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVenueName(String venueName) {
    this.venueName = venueName;
  }


  public ScheduleItem localizedVenueName(String localizedVenueName) {
    
    this.localizedVenueName = localizedVenueName;
    return this;
  }

   /**
   * Localized name of venue attendees will visit.
   * @return localizedVenueName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "The Great Angus", value = "Localized name of venue attendees will visit.")
  @JsonProperty(JSON_PROPERTY_LOCALIZED_VENUE_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLocalizedVenueName() {
    return localizedVenueName;
  }


  @JsonProperty(JSON_PROPERTY_LOCALIZED_VENUE_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLocalizedVenueName(String localizedVenueName) {
    this.localizedVenueName = localizedVenueName;
  }


  public ScheduleItem contact(Contact contact) {
    
    this.contact = contact;
    return this;
  }

   /**
   * Get contact
   * @return contact
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CONTACT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Contact getContact() {
    return contact;
  }


  @JsonProperty(JSON_PROPERTY_CONTACT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setContact(Contact contact) {
    this.contact = contact;
  }


  public ScheduleItem address(Address address) {
    
    this.address = address;
    return this;
  }

   /**
   * Get address
   * @return address
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Address getAddress() {
    return address;
  }


  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAddress(Address address) {
    this.address = address;
  }


  public ScheduleItem created(OffsetDateTime created) {
    
    this.created = created;
    return this;
  }

   /**
   * Date time this schedule event was created.
   * @return created
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Date time this schedule event was created.")
  @JsonProperty(JSON_PROPERTY_CREATED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getCreated() {
    return created;
  }


  @JsonProperty(JSON_PROPERTY_CREATED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCreated(OffsetDateTime created) {
    this.created = created;
  }


  public ScheduleItem lastModified(OffsetDateTime lastModified) {
    
    this.lastModified = lastModified;
    return this;
  }

   /**
   * Last date time this scheduled event was modified.
   * @return lastModified
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Last date time this scheduled event was modified.")
  @JsonProperty(JSON_PROPERTY_LAST_MODIFIED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getLastModified() {
    return lastModified;
  }


  @JsonProperty(JSON_PROPERTY_LAST_MODIFIED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLastModified(OffsetDateTime lastModified) {
    this.lastModified = lastModified;
  }


  public ScheduleItem sequence(Long sequence) {
    
    this.sequence = sequence;
    return this;
  }

   /**
   * Schedule event recurring sequence
   * @return sequence
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "0", value = "Schedule event recurring sequence")
  @JsonProperty(JSON_PROPERTY_SEQUENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getSequence() {
    return sequence;
  }


  @JsonProperty(JSON_PROPERTY_SEQUENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSequence(Long sequence) {
    this.sequence = sequence;
  }


  public ScheduleItem emailHeaderLogoUrl(String emailHeaderLogoUrl) {
    
    this.emailHeaderLogoUrl = emailHeaderLogoUrl;
    return this;
  }

   /**
   * Venue owner logo
   * @return emailHeaderLogoUrl
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "https://path.to/my-image.jpg", value = "Venue owner logo")
  @JsonProperty(JSON_PROPERTY_EMAIL_HEADER_LOGO_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getEmailHeaderLogoUrl() {
    return emailHeaderLogoUrl;
  }


  @JsonProperty(JSON_PROPERTY_EMAIL_HEADER_LOGO_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEmailHeaderLogoUrl(String emailHeaderLogoUrl) {
    this.emailHeaderLogoUrl = emailHeaderLogoUrl;
  }


  public ScheduleItem logoIdentifier(String logoIdentifier) {
    
    this.logoIdentifier = logoIdentifier;
    return this;
  }

   /**
   * Cloudinary image identifier of logo
   * @return logoIdentifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "my-image", value = "Cloudinary image identifier of logo")
  @JsonProperty(JSON_PROPERTY_LOGO_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLogoIdentifier() {
    return logoIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_LOGO_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLogoIdentifier(String logoIdentifier) {
    this.logoIdentifier = logoIdentifier;
  }


  public ScheduleItem allDay(Boolean allDay) {
    
    this.allDay = allDay;
    return this;
  }

   /**
   * Get allDay
   * @return allDay
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ALL_DAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getAllDay() {
    return allDay;
  }


  @JsonProperty(JSON_PROPERTY_ALL_DAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAllDay(Boolean allDay) {
    this.allDay = allDay;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ScheduleItem scheduleItem = (ScheduleItem) o;
    return Objects.equals(this.identifier, scheduleItem.identifier) &&
        Objects.equals(this.start, scheduleItem.start) &&
        Objects.equals(this.startTimezone, scheduleItem.startTimezone) &&
        Objects.equals(this.end, scheduleItem.end) &&
        Objects.equals(this.endTimezone, scheduleItem.endTimezone) &&
        Objects.equals(this.title, scheduleItem.title) &&
        Objects.equals(this.description, scheduleItem.description) &&
        Objects.equals(this.recurrenceRule, scheduleItem.recurrenceRule) &&
        Objects.equals(this.recurrenceId, scheduleItem.recurrenceId) &&
        Objects.equals(this.recurrenceException, scheduleItem.recurrenceException) &&
        Objects.equals(this.ownerIdentifier, scheduleItem.ownerIdentifier) &&
        Objects.equals(this.bookingIdentifier, scheduleItem.bookingIdentifier) &&
        Objects.equals(this.bookingOwnerIdentifier, scheduleItem.bookingOwnerIdentifier) &&
        Objects.equals(this.hotelIdentifier, scheduleItem.hotelIdentifier) &&
        Objects.equals(this.type, scheduleItem.type) &&
        Objects.equals(this.attendees, scheduleItem.attendees) &&
        Objects.equals(this.email, scheduleItem.email) &&
        Objects.equals(this.fullName, scheduleItem.fullName) &&
        Objects.equals(this.firstName, scheduleItem.firstName) &&
        Objects.equals(this.lastName, scheduleItem.lastName) &&
        Objects.equals(this.venueName, scheduleItem.venueName) &&
        Objects.equals(this.localizedVenueName, scheduleItem.localizedVenueName) &&
        Objects.equals(this.contact, scheduleItem.contact) &&
        Objects.equals(this.address, scheduleItem.address) &&
        Objects.equals(this.created, scheduleItem.created) &&
        Objects.equals(this.lastModified, scheduleItem.lastModified) &&
        Objects.equals(this.sequence, scheduleItem.sequence) &&
        Objects.equals(this.emailHeaderLogoUrl, scheduleItem.emailHeaderLogoUrl) &&
        Objects.equals(this.logoIdentifier, scheduleItem.logoIdentifier) &&
        Objects.equals(this.allDay, scheduleItem.allDay);
  }

  @Override
  public int hashCode() {
    return Objects.hash(identifier, start, startTimezone, end, endTimezone, title, description, recurrenceRule, recurrenceId, recurrenceException, ownerIdentifier, bookingIdentifier, bookingOwnerIdentifier, hotelIdentifier, type, attendees, email, fullName, firstName, lastName, venueName, localizedVenueName, contact, address, created, lastModified, sequence, emailHeaderLogoUrl, logoIdentifier, allDay);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ScheduleItem {\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    start: ").append(toIndentedString(start)).append("\n");
    sb.append("    startTimezone: ").append(toIndentedString(startTimezone)).append("\n");
    sb.append("    end: ").append(toIndentedString(end)).append("\n");
    sb.append("    endTimezone: ").append(toIndentedString(endTimezone)).append("\n");
    sb.append("    title: ").append(toIndentedString(title)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    recurrenceRule: ").append(toIndentedString(recurrenceRule)).append("\n");
    sb.append("    recurrenceId: ").append(toIndentedString(recurrenceId)).append("\n");
    sb.append("    recurrenceException: ").append(toIndentedString(recurrenceException)).append("\n");
    sb.append("    ownerIdentifier: ").append(toIndentedString(ownerIdentifier)).append("\n");
    sb.append("    bookingIdentifier: ").append(toIndentedString(bookingIdentifier)).append("\n");
    sb.append("    bookingOwnerIdentifier: ").append(toIndentedString(bookingOwnerIdentifier)).append("\n");
    sb.append("    hotelIdentifier: ").append(toIndentedString(hotelIdentifier)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    attendees: ").append(toIndentedString(attendees)).append("\n");
    sb.append("    email: ").append(toIndentedString(email)).append("\n");
    sb.append("    fullName: ").append(toIndentedString(fullName)).append("\n");
    sb.append("    firstName: ").append(toIndentedString(firstName)).append("\n");
    sb.append("    lastName: ").append(toIndentedString(lastName)).append("\n");
    sb.append("    venueName: ").append(toIndentedString(venueName)).append("\n");
    sb.append("    localizedVenueName: ").append(toIndentedString(localizedVenueName)).append("\n");
    sb.append("    contact: ").append(toIndentedString(contact)).append("\n");
    sb.append("    address: ").append(toIndentedString(address)).append("\n");
    sb.append("    created: ").append(toIndentedString(created)).append("\n");
    sb.append("    lastModified: ").append(toIndentedString(lastModified)).append("\n");
    sb.append("    sequence: ").append(toIndentedString(sequence)).append("\n");
    sb.append("    emailHeaderLogoUrl: ").append(toIndentedString(emailHeaderLogoUrl)).append("\n");
    sb.append("    logoIdentifier: ").append(toIndentedString(logoIdentifier)).append("\n");
    sb.append("    allDay: ").append(toIndentedString(allDay)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

