/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.validation.Valid;
import travel.wink.sdk.extranet.model.CancellationPolicy;
import travel.wink.sdk.extranet.model.ExtraCharges;
import travel.wink.sdk.extranet.model.MasterRateRoom;
import travel.wink.sdk.extranet.model.MoneySetInternalTotal;
import travel.wink.sdk.extranet.model.MoneySetSourceTotal;
import travel.wink.sdk.extranet.model.MoneySetUserSpecifiedCurrencyTotal;
import travel.wink.sdk.extranet.model.PropertyPolicy;
import travel.wink.sdk.extranet.model.RatePlan;
import travel.wink.sdk.extranet.model.StayRate;

@ApiModel(description="All information about the room that was booked.")
@JsonPropertyOrder(value={"policy", "room", "rooms", "bedType", "adults", "children", "startDate", "endDate", "price", "roomRateIdentifier", "roomRateInternalName", "ratePlan", "perkTypes", "extraCharges", "activeCancellationPolicy", "sourceTotal", "internalTotal", "roomNights", "userSpecifiedCurrencyTotal", "guests", "rateSource", "cancellable", "cancellableByHotel", "cancellableWithPotentialCharge"})
public class RoomStay {
    public static final String JSON_PROPERTY_POLICY = "policy";
    private PropertyPolicy policy;
    public static final String JSON_PROPERTY_ROOM = "room";
    private MasterRateRoom room;
    public static final String JSON_PROPERTY_ROOMS = "rooms";
    private Integer rooms = 1;
    public static final String JSON_PROPERTY_BED_TYPE = "bedType";
    private String bedType;
    public static final String JSON_PROPERTY_ADULTS = "adults";
    private Integer adults = 0;
    public static final String JSON_PROPERTY_CHILDREN = "children";
    private Integer children = 0;
    public static final String JSON_PROPERTY_START_DATE = "startDate";
    private LocalDate startDate;
    public static final String JSON_PROPERTY_END_DATE = "endDate";
    private LocalDate endDate;
    public static final String JSON_PROPERTY_PRICE = "price";
    private StayRate price;
    public static final String JSON_PROPERTY_ROOM_RATE_IDENTIFIER = "roomRateIdentifier";
    private UUID roomRateIdentifier;
    public static final String JSON_PROPERTY_ROOM_RATE_INTERNAL_NAME = "roomRateInternalName";
    private String roomRateInternalName;
    public static final String JSON_PROPERTY_RATE_PLAN = "ratePlan";
    private RatePlan ratePlan;
    public static final String JSON_PROPERTY_PERK_TYPES = "perkTypes";
    private List<PerkTypesEnum> perkTypes = null;
    public static final String JSON_PROPERTY_EXTRA_CHARGES = "extraCharges";
    private ExtraCharges extraCharges;
    public static final String JSON_PROPERTY_ACTIVE_CANCELLATION_POLICY = "activeCancellationPolicy";
    private CancellationPolicy activeCancellationPolicy;
    public static final String JSON_PROPERTY_SOURCE_TOTAL = "sourceTotal";
    private MoneySetSourceTotal sourceTotal;
    public static final String JSON_PROPERTY_INTERNAL_TOTAL = "internalTotal";
    private MoneySetInternalTotal internalTotal;
    public static final String JSON_PROPERTY_ROOM_NIGHTS = "roomNights";
    private Long roomNights;
    public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_TOTAL = "userSpecifiedCurrencyTotal";
    private MoneySetUserSpecifiedCurrencyTotal userSpecifiedCurrencyTotal;
    public static final String JSON_PROPERTY_GUESTS = "guests";
    private Integer guests;
    public static final String JSON_PROPERTY_RATE_SOURCE = "rateSource";
    private RateSourceEnum rateSource;
    public static final String JSON_PROPERTY_CANCELLABLE = "cancellable";
    private Boolean cancellable;
    public static final String JSON_PROPERTY_CANCELLABLE_BY_HOTEL = "cancellableByHotel";
    private Boolean cancellableByHotel;
    public static final String JSON_PROPERTY_CANCELLABLE_WITH_POTENTIAL_CHARGE = "cancellableWithPotentialCharge";
    private Boolean cancellableWithPotentialCharge;

    public RoomStay policy(PropertyPolicy policy) {
        this.policy = policy;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="policy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PropertyPolicy getPolicy() {
        return this.policy;
    }

    @JsonProperty(value="policy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPolicy(PropertyPolicy policy) {
        this.policy = policy;
    }

    public RoomStay room(MasterRateRoom room) {
        this.room = room;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="room")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MasterRateRoom getRoom() {
        return this.room;
    }

    @JsonProperty(value="room")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRoom(MasterRateRoom room) {
        this.room = room;
    }

    public RoomStay rooms(Integer rooms) {
        this.rooms = rooms;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1", value="Number of rooms. Always 1 since we switched to creating one booking per room.")
    @JsonProperty(value="rooms")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getRooms() {
        return this.rooms;
    }

    @JsonProperty(value="rooms")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRooms(Integer rooms) {
        this.rooms = rooms;
    }

    public RoomStay bedType(String bedType) {
        this.bedType = bedType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Supported OTA specification `BED` code. See [OTA geoname data](#operation/showAvailableCodesForCategory)")
    @JsonProperty(value="bedType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBedType() {
        return this.bedType;
    }

    @JsonProperty(value="bedType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBedType(String bedType) {
        this.bedType = bedType;
    }

    public RoomStay adults(Integer adults) {
        this.adults = adults;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2", value="The actual amount of adults as determined by the hotel's policy.")
    @JsonProperty(value="adults")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getAdults() {
        return this.adults;
    }

    @JsonProperty(value="adults")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAdults(Integer adults) {
        this.adults = adults;
    }

    public RoomStay children(Integer children) {
        this.children = children;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="0", value="The actual amount of children as determined by the hotel's policy.")
    @JsonProperty(value="children")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getChildren() {
        return this.children;
    }

    @JsonProperty(value="children")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setChildren(Integer children) {
        this.children = children;
    }

    public RoomStay startDate(LocalDate startDate) {
        this.startDate = startDate;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(example="Fri Dec 24 07:00:00 ICT 2021", value="Stay start date")
    @JsonProperty(value="startDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDate getStartDate() {
        return this.startDate;
    }

    @JsonProperty(value="startDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public RoomStay endDate(LocalDate endDate) {
        this.endDate = endDate;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(example="Fri Dec 31 07:00:00 ICT 2021", value="Stay end date")
    @JsonProperty(value="endDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDate getEndDate() {
        return this.endDate;
    }

    @JsonProperty(value="endDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public RoomStay price(StayRate price) {
        this.price = price;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="price")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StayRate getPrice() {
        return this.price;
    }

    @JsonProperty(value="price")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPrice(StayRate price) {
        this.price = price;
    }

    public RoomStay roomRateIdentifier(UUID roomRateIdentifier) {
        this.roomRateIdentifier = roomRateIdentifier;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Master rate identifier")
    @JsonProperty(value="roomRateIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getRoomRateIdentifier() {
        return this.roomRateIdentifier;
    }

    @JsonProperty(value="roomRateIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRoomRateIdentifier(UUID roomRateIdentifier) {
        this.roomRateIdentifier = roomRateIdentifier;
    }

    public RoomStay roomRateInternalName(String roomRateInternalName) {
        this.roomRateInternalName = roomRateInternalName;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Master Rate 1", value="Master rate internal name")
    @JsonProperty(value="roomRateInternalName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRoomRateInternalName() {
        return this.roomRateInternalName;
    }

    @JsonProperty(value="roomRateInternalName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRoomRateInternalName(String roomRateInternalName) {
        this.roomRateInternalName = roomRateInternalName;
    }

    public RoomStay ratePlan(RatePlan ratePlan) {
        this.ratePlan = ratePlan;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="ratePlan")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public RatePlan getRatePlan() {
        return this.ratePlan;
    }

    @JsonProperty(value="ratePlan")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRatePlan(RatePlan ratePlan) {
        this.ratePlan = ratePlan;
    }

    public RoomStay perkTypes(List<PerkTypesEnum> perkTypes) {
        this.perkTypes = perkTypes;
        return this;
    }

    public RoomStay addPerkTypesItem(PerkTypesEnum perkTypesItem) {
        if (this.perkTypes == null) {
            this.perkTypes = new ArrayList<PerkTypesEnum>();
        }
        this.perkTypes.add(perkTypesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"PERK_FREE_DRINK_VOUCHER\",\"PERK_EARLY_CHECKIN\"]", value="List of perks that came with the master rate")
    @JsonProperty(value="perkTypes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<PerkTypesEnum> getPerkTypes() {
        return this.perkTypes;
    }

    @JsonProperty(value="perkTypes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPerkTypes(List<PerkTypesEnum> perkTypes) {
        this.perkTypes = perkTypes;
    }

    public RoomStay extraCharges(ExtraCharges extraCharges) {
        this.extraCharges = extraCharges;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="extraCharges")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ExtraCharges getExtraCharges() {
        return this.extraCharges;
    }

    @JsonProperty(value="extraCharges")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExtraCharges(ExtraCharges extraCharges) {
        this.extraCharges = extraCharges;
    }

    public RoomStay activeCancellationPolicy(CancellationPolicy activeCancellationPolicy) {
        this.activeCancellationPolicy = activeCancellationPolicy;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="activeCancellationPolicy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CancellationPolicy getActiveCancellationPolicy() {
        return this.activeCancellationPolicy;
    }

    @JsonProperty(value="activeCancellationPolicy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setActiveCancellationPolicy(CancellationPolicy activeCancellationPolicy) {
        this.activeCancellationPolicy = activeCancellationPolicy;
    }

    public RoomStay sourceTotal(MoneySetSourceTotal sourceTotal) {
        this.sourceTotal = sourceTotal;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="sourceTotal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MoneySetSourceTotal getSourceTotal() {
        return this.sourceTotal;
    }

    @JsonProperty(value="sourceTotal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSourceTotal(MoneySetSourceTotal sourceTotal) {
        this.sourceTotal = sourceTotal;
    }

    public RoomStay internalTotal(MoneySetInternalTotal internalTotal) {
        this.internalTotal = internalTotal;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="internalTotal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MoneySetInternalTotal getInternalTotal() {
        return this.internalTotal;
    }

    @JsonProperty(value="internalTotal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInternalTotal(MoneySetInternalTotal internalTotal) {
        this.internalTotal = internalTotal;
    }

    public RoomStay roomNights(Long roomNights) {
        this.roomNights = roomNights;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2", value="Total number of nights the guest stays at the hotel. -1 indicates there is an error.")
    @JsonProperty(value="roomNights")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getRoomNights() {
        return this.roomNights;
    }

    @JsonProperty(value="roomNights")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRoomNights(Long roomNights) {
        this.roomNights = roomNights;
    }

    public RoomStay userSpecifiedCurrencyTotal(MoneySetUserSpecifiedCurrencyTotal userSpecifiedCurrencyTotal) {
        this.userSpecifiedCurrencyTotal = userSpecifiedCurrencyTotal;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="userSpecifiedCurrencyTotal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MoneySetUserSpecifiedCurrencyTotal getUserSpecifiedCurrencyTotal() {
        return this.userSpecifiedCurrencyTotal;
    }

    @JsonProperty(value="userSpecifiedCurrencyTotal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUserSpecifiedCurrencyTotal(MoneySetUserSpecifiedCurrencyTotal userSpecifiedCurrencyTotal) {
        this.userSpecifiedCurrencyTotal = userSpecifiedCurrencyTotal;
    }

    public RoomStay guests(Integer guests) {
        this.guests = guests;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="guests")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getGuests() {
        return this.guests;
    }

    @JsonProperty(value="guests")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGuests(Integer guests) {
        this.guests = guests;
    }

    public RoomStay rateSource(RateSourceEnum rateSource) {
        this.rateSource = rateSource;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="rateSource")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public RateSourceEnum getRateSource() {
        return this.rateSource;
    }

    @JsonProperty(value="rateSource")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRateSource(RateSourceEnum rateSource) {
        this.rateSource = rateSource;
    }

    public RoomStay cancellable(Boolean cancellable) {
        this.cancellable = cancellable;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="cancellable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getCancellable() {
        return this.cancellable;
    }

    @JsonProperty(value="cancellable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCancellable(Boolean cancellable) {
        this.cancellable = cancellable;
    }

    public RoomStay cancellableByHotel(Boolean cancellableByHotel) {
        this.cancellableByHotel = cancellableByHotel;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="cancellableByHotel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getCancellableByHotel() {
        return this.cancellableByHotel;
    }

    @JsonProperty(value="cancellableByHotel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCancellableByHotel(Boolean cancellableByHotel) {
        this.cancellableByHotel = cancellableByHotel;
    }

    public RoomStay cancellableWithPotentialCharge(Boolean cancellableWithPotentialCharge) {
        this.cancellableWithPotentialCharge = cancellableWithPotentialCharge;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="cancellableWithPotentialCharge")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getCancellableWithPotentialCharge() {
        return this.cancellableWithPotentialCharge;
    }

    @JsonProperty(value="cancellableWithPotentialCharge")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCancellableWithPotentialCharge(Boolean cancellableWithPotentialCharge) {
        this.cancellableWithPotentialCharge = cancellableWithPotentialCharge;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RoomStay roomStay = (RoomStay)o;
        return Objects.equals(this.policy, roomStay.policy) && Objects.equals(this.room, roomStay.room) && Objects.equals(this.rooms, roomStay.rooms) && Objects.equals(this.bedType, roomStay.bedType) && Objects.equals(this.adults, roomStay.adults) && Objects.equals(this.children, roomStay.children) && Objects.equals(this.startDate, roomStay.startDate) && Objects.equals(this.endDate, roomStay.endDate) && Objects.equals(this.price, roomStay.price) && Objects.equals(this.roomRateIdentifier, roomStay.roomRateIdentifier) && Objects.equals(this.roomRateInternalName, roomStay.roomRateInternalName) && Objects.equals(this.ratePlan, roomStay.ratePlan) && Objects.equals(this.perkTypes, roomStay.perkTypes) && Objects.equals(this.extraCharges, roomStay.extraCharges) && Objects.equals(this.activeCancellationPolicy, roomStay.activeCancellationPolicy) && Objects.equals(this.sourceTotal, roomStay.sourceTotal) && Objects.equals(this.internalTotal, roomStay.internalTotal) && Objects.equals(this.roomNights, roomStay.roomNights) && Objects.equals(this.userSpecifiedCurrencyTotal, roomStay.userSpecifiedCurrencyTotal) && Objects.equals(this.guests, roomStay.guests) && Objects.equals((Object)this.rateSource, (Object)roomStay.rateSource) && Objects.equals(this.cancellable, roomStay.cancellable) && Objects.equals(this.cancellableByHotel, roomStay.cancellableByHotel) && Objects.equals(this.cancellableWithPotentialCharge, roomStay.cancellableWithPotentialCharge);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.policy, this.room, this.rooms, this.bedType, this.adults, this.children, this.startDate, this.endDate, this.price, this.roomRateIdentifier, this.roomRateInternalName, this.ratePlan, this.perkTypes, this.extraCharges, this.activeCancellationPolicy, this.sourceTotal, this.internalTotal, this.roomNights, this.userSpecifiedCurrencyTotal, this.guests, this.rateSource, this.cancellable, this.cancellableByHotel, this.cancellableWithPotentialCharge});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RoomStay {\n");
        sb.append("    policy: ").append(this.toIndentedString(this.policy)).append("\n");
        sb.append("    room: ").append(this.toIndentedString(this.room)).append("\n");
        sb.append("    rooms: ").append(this.toIndentedString(this.rooms)).append("\n");
        sb.append("    bedType: ").append(this.toIndentedString(this.bedType)).append("\n");
        sb.append("    adults: ").append(this.toIndentedString(this.adults)).append("\n");
        sb.append("    children: ").append(this.toIndentedString(this.children)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    price: ").append(this.toIndentedString(this.price)).append("\n");
        sb.append("    roomRateIdentifier: ").append(this.toIndentedString(this.roomRateIdentifier)).append("\n");
        sb.append("    roomRateInternalName: ").append(this.toIndentedString(this.roomRateInternalName)).append("\n");
        sb.append("    ratePlan: ").append(this.toIndentedString(this.ratePlan)).append("\n");
        sb.append("    perkTypes: ").append(this.toIndentedString(this.perkTypes)).append("\n");
        sb.append("    extraCharges: ").append(this.toIndentedString(this.extraCharges)).append("\n");
        sb.append("    activeCancellationPolicy: ").append(this.toIndentedString(this.activeCancellationPolicy)).append("\n");
        sb.append("    sourceTotal: ").append(this.toIndentedString(this.sourceTotal)).append("\n");
        sb.append("    internalTotal: ").append(this.toIndentedString(this.internalTotal)).append("\n");
        sb.append("    roomNights: ").append(this.toIndentedString(this.roomNights)).append("\n");
        sb.append("    userSpecifiedCurrencyTotal: ").append(this.toIndentedString(this.userSpecifiedCurrencyTotal)).append("\n");
        sb.append("    guests: ").append(this.toIndentedString(this.guests)).append("\n");
        sb.append("    rateSource: ").append(this.toIndentedString((Object)this.rateSource)).append("\n");
        sb.append("    cancellable: ").append(this.toIndentedString(this.cancellable)).append("\n");
        sb.append("    cancellableByHotel: ").append(this.toIndentedString(this.cancellableByHotel)).append("\n");
        sb.append("    cancellableWithPotentialCharge: ").append(this.toIndentedString(this.cancellableWithPotentialCharge)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum RateSourceEnum {
        TRAVELIKO("TRAVELIKO"),
        SITEMINDER("SITEMINDER"),
        FASTBOOKING("FASTBOOKING"),
        RATEGAIN("RATEGAIN"),
        CLOUD_BEDS("CLOUD_BEDS"),
        YIELD_PLANET("YIELD_PLANET"),
        TRAVELCLICK("TRAVELCLICK"),
        HOTEL_GURU("HOTEL_GURU"),
        OTHER_CHANNEL_MANAGER("OTHER_CHANNEL_MANAGER"),
        BOOKING_JINI("BOOKING_JINI"),
        HOTEL_LINK_SOLUTIONS("HOTEL_LINK_SOLUTIONS"),
        ALLOTZ("ALLOTZ"),
        DEDGE("DEDGE"),
        RATE_TIGER("RATE_TIGER"),
        RESAVENUE("RESAVENUE"),
        COMANCHE("COMANCHE"),
        OMNIBEES("OMNIBEES"),
        EZEE("EZEE"),
        SYNXIS("SYNXIS");

        private String value;

        private RateSourceEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static RateSourceEnum fromValue(String value) {
            for (RateSourceEnum b : RateSourceEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum PerkTypesEnum {
        LOYALTY_POINTS("PERK_LOYALTY_POINTS"),
        WINE("PERK_WINE"),
        FREE_DRINK_VOUCHER("PERK_FREE_DRINK_VOUCHER"),
        FREE_MEAL_TWO_PEOPLE("PERK_FREE_MEAL_TWO_PEOPLE"),
        FREE_ONE_HOUR_MASSAGE("PERK_FREE_ONE_HOUR_MASSAGE"),
        TWENTY_PERCENT_FOOD_BEVERAGE_DISCOUNT("PERK_TWENTY_PERCENT_FOOD_BEVERAGE_DISCOUNT"),
        TWENTY_PERCENT_SPA_DISCOUNT_VOUCHER("PERK_TWENTY_PERCENT_SPA_DISCOUNT_VOUCHER"),
        GUARANTEED_UPGRADE("PERK_GUARANTEED_UPGRADE"),
        EARLY_CHECKIN("PERK_EARLY_CHECKIN"),
        ROOM_UPGRADE("PERK_ROOM_UPGRADE"),
        LATE_CHECKOUT("PERK_LATE_CHECKOUT"),
        AIRPORT_TRANSFER("PERK_AIRPORT_TRANSFER"),
        AIRPORT_PICK_UP("PERK_AIRPORT_PICK_UP"),
        BOTTLE_CHAMPAGNE_ON_ARRIVAL("PERK_BOTTLE_CHAMPAGNE_ON_ARRIVAL"),
        BOTTLE_SPARKLING_WINE_ON_ARRIVAL("PERK_BOTTLE_SPARKLING_WINE_ON_ARRIVAL"),
        BOTTLE_WINE_ON_ARRIVAL("PERK_BOTTLE_WINE_ON_ARRIVAL");

        private String value;

        private PerkTypesEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PerkTypesEnum fromValue(String value) {
            for (PerkTypesEnum b : PerkTypesEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

