package travel.wink.sdk.extranet.api;

import travel.wink.sdk.extranet.invoker.ApiClient;

import travel.wink.sdk.extranet.model.BookingTestRequest;
import travel.wink.sdk.extranet.model.BookingView;
import travel.wink.sdk.extranet.model.ChannelName;
import travel.wink.sdk.extranet.model.DailyRateListUpdate;
import travel.wink.sdk.extranet.model.DailyRateUpdate;
import travel.wink.sdk.extranet.model.DateRange;
import travel.wink.sdk.extranet.model.DescriptiveRoomDescriptive;
import travel.wink.sdk.extranet.model.GenericErrorMessage;
import travel.wink.sdk.extranet.model.PageRate;
import travel.wink.sdk.extranet.model.Rate;
import travel.wink.sdk.extranet.model.RateTesterDescriptive;
import travel.wink.sdk.extranet.model.ShowPropertyPolicy400Response;
import travel.wink.sdk.extranet.model.State;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-09-16T10:42:12.086235846+07:00[Asia/Bangkok]")
public class DailyRateApi {
    private ApiClient apiClient;

    public DailyRateApi() {
        this(new ApiClient());
    }

    @Autowired
    public DailyRateApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Update Daily Rates by Range
     * Bulk update daily rates by date range
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update daily rates by date range owned by this hotel identifier.
     * @param masterRateIdentifier Update daily rates by date range owned by this master rate.
     * @param dailyRateUpdate The dailyRateUpdate parameter
     * @return List&lt;Rate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec bulkUpdateRateRequestCreation(String hotelIdentifier, String masterRateIdentifier, DailyRateUpdate dailyRateUpdate) throws WebClientResponseException {
        Object postBody = dailyRateUpdate;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling bulkUpdateRate", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'masterRateIdentifier' is set
        if (masterRateIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'masterRateIdentifier' when calling bulkUpdateRate", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'dailyRateUpdate' is set
        if (dailyRateUpdate == null) {
            throw new WebClientResponseException("Missing the required parameter 'dailyRateUpdate' when calling bulkUpdateRate", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("masterRateIdentifier", masterRateIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<Rate> localVarReturnType = new ParameterizedTypeReference<Rate>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/roomrate/{masterRateIdentifier}/rate/update", HttpMethod.PUT, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Daily Rates by Range
     * Bulk update daily rates by date range
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update daily rates by date range owned by this hotel identifier.
     * @param masterRateIdentifier Update daily rates by date range owned by this master rate.
     * @param dailyRateUpdate The dailyRateUpdate parameter
     * @return List&lt;Rate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<Rate> bulkUpdateRate(String hotelIdentifier, String masterRateIdentifier, DailyRateUpdate dailyRateUpdate) throws WebClientResponseException {
        ParameterizedTypeReference<Rate> localVarReturnType = new ParameterizedTypeReference<Rate>() {};
        return bulkUpdateRateRequestCreation(hotelIdentifier, masterRateIdentifier, dailyRateUpdate).bodyToFlux(localVarReturnType);
    }

    public Mono<ResponseEntity<List<Rate>>> bulkUpdateRateWithHttpInfo(String hotelIdentifier, String masterRateIdentifier, DailyRateUpdate dailyRateUpdate) throws WebClientResponseException {
        ParameterizedTypeReference<Rate> localVarReturnType = new ParameterizedTypeReference<Rate>() {};
        return bulkUpdateRateRequestCreation(hotelIdentifier, masterRateIdentifier, dailyRateUpdate).toEntityList(localVarReturnType);
    }
    /**
     * Update Daily Rates by List
     * Update daily rates with list of daily rate records.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update daily rates list owned by this hotel identifier.
     * @param masterRateIdentifier Update daily rates list owned by this master rate.
     * @param dailyRateListUpdate The dailyRateListUpdate parameter
     * @return List&lt;Rate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec bulkUpdateRate1RequestCreation(String hotelIdentifier, String masterRateIdentifier, DailyRateListUpdate dailyRateListUpdate) throws WebClientResponseException {
        Object postBody = dailyRateListUpdate;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling bulkUpdateRate1", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'masterRateIdentifier' is set
        if (masterRateIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'masterRateIdentifier' when calling bulkUpdateRate1", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'dailyRateListUpdate' is set
        if (dailyRateListUpdate == null) {
            throw new WebClientResponseException("Missing the required parameter 'dailyRateListUpdate' when calling bulkUpdateRate1", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("masterRateIdentifier", masterRateIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<Rate> localVarReturnType = new ParameterizedTypeReference<Rate>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/roomrate/{masterRateIdentifier}/rate/list/update", HttpMethod.PUT, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Daily Rates by List
     * Update daily rates with list of daily rate records.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update daily rates list owned by this hotel identifier.
     * @param masterRateIdentifier Update daily rates list owned by this master rate.
     * @param dailyRateListUpdate The dailyRateListUpdate parameter
     * @return List&lt;Rate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<Rate> bulkUpdateRate1(String hotelIdentifier, String masterRateIdentifier, DailyRateListUpdate dailyRateListUpdate) throws WebClientResponseException {
        ParameterizedTypeReference<Rate> localVarReturnType = new ParameterizedTypeReference<Rate>() {};
        return bulkUpdateRate1RequestCreation(hotelIdentifier, masterRateIdentifier, dailyRateListUpdate).bodyToFlux(localVarReturnType);
    }

    public Mono<ResponseEntity<List<Rate>>> bulkUpdateRate1WithHttpInfo(String hotelIdentifier, String masterRateIdentifier, DailyRateListUpdate dailyRateListUpdate) throws WebClientResponseException {
        ParameterizedTypeReference<Rate> localVarReturnType = new ParameterizedTypeReference<Rate>() {};
        return bulkUpdateRate1RequestCreation(hotelIdentifier, masterRateIdentifier, dailyRateListUpdate).toEntityList(localVarReturnType);
    }
    /**
     * Test Rate / Availability
     * Test whether the rates and availability for a sales channel is coming backing the way the property wants
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param hotelIdentifier The hotelIdentifier parameter
     * @param bookingTestRequest The bookingTestRequest parameter
     * @return BookingView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createTestBookingRequestCreation(String hotelIdentifier, BookingTestRequest bookingTestRequest) throws WebClientResponseException {
        Object postBody = bookingTestRequest;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling createTestBooking", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'bookingTestRequest' is set
        if (bookingTestRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'bookingTestRequest' when calling createTestBooking", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<BookingView> localVarReturnType = new ParameterizedTypeReference<BookingView>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/sandbox/booking", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Test Rate / Availability
     * Test whether the rates and availability for a sales channel is coming backing the way the property wants
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param hotelIdentifier The hotelIdentifier parameter
     * @param bookingTestRequest The bookingTestRequest parameter
     * @return BookingView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<BookingView> createTestBooking(String hotelIdentifier, BookingTestRequest bookingTestRequest) throws WebClientResponseException {
        ParameterizedTypeReference<BookingView> localVarReturnType = new ParameterizedTypeReference<BookingView>() {};
        return createTestBookingRequestCreation(hotelIdentifier, bookingTestRequest).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<BookingView>> createTestBookingWithHttpInfo(String hotelIdentifier, BookingTestRequest bookingTestRequest) throws WebClientResponseException {
        ParameterizedTypeReference<BookingView> localVarReturnType = new ParameterizedTypeReference<BookingView>() {};
        return createTestBookingRequestCreation(hotelIdentifier, bookingTestRequest).toEntity(localVarReturnType);
    }
    /**
     * Daily Rates by Hotel
     * Retrieve daily rates for all master rates by date range
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show daily rate list owned by this hotel identifier.
     * @param dateRange The dateRange parameter
     * @return List&lt;Rate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showAllHotelRatesRequestCreation(String hotelIdentifier, DateRange dateRange) throws WebClientResponseException {
        Object postBody = dateRange;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showAllHotelRates", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'dateRange' is set
        if (dateRange == null) {
            throw new WebClientResponseException("Missing the required parameter 'dateRange' when calling showAllHotelRates", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<Rate> localVarReturnType = new ParameterizedTypeReference<Rate>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/roomrate/rates/dates", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Daily Rates by Hotel
     * Retrieve daily rates for all master rates by date range
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show daily rate list owned by this hotel identifier.
     * @param dateRange The dateRange parameter
     * @return List&lt;Rate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<Rate> showAllHotelRates(String hotelIdentifier, DateRange dateRange) throws WebClientResponseException {
        ParameterizedTypeReference<Rate> localVarReturnType = new ParameterizedTypeReference<Rate>() {};
        return showAllHotelRatesRequestCreation(hotelIdentifier, dateRange).bodyToFlux(localVarReturnType);
    }

    public Mono<ResponseEntity<List<Rate>>> showAllHotelRatesWithHttpInfo(String hotelIdentifier, DateRange dateRange) throws WebClientResponseException {
        ParameterizedTypeReference<Rate> localVarReturnType = new ParameterizedTypeReference<Rate>() {};
        return showAllHotelRatesRequestCreation(hotelIdentifier, dateRange).toEntityList(localVarReturnType);
    }
    /**
     * Daily Rates by Master Rate
     * Retrieve daily rates for a master rate for date range
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show daily rate list owned by this hotel identifier.
     * @param masterRateIdentifier Show daily rate list owned by this master rate.
     * @param dateRange The dateRange parameter
     * @return List&lt;Rate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showAllMasterRatesRatesRequestCreation(String hotelIdentifier, String masterRateIdentifier, DateRange dateRange) throws WebClientResponseException {
        Object postBody = dateRange;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showAllMasterRatesRates", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'masterRateIdentifier' is set
        if (masterRateIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'masterRateIdentifier' when calling showAllMasterRatesRates", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'dateRange' is set
        if (dateRange == null) {
            throw new WebClientResponseException("Missing the required parameter 'dateRange' when calling showAllMasterRatesRates", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("masterRateIdentifier", masterRateIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<Rate> localVarReturnType = new ParameterizedTypeReference<Rate>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/roomrate/{masterRateIdentifier}/rates/dates", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Daily Rates by Master Rate
     * Retrieve daily rates for a master rate for date range
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show daily rate list owned by this hotel identifier.
     * @param masterRateIdentifier Show daily rate list owned by this master rate.
     * @param dateRange The dateRange parameter
     * @return List&lt;Rate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<Rate> showAllMasterRatesRates(String hotelIdentifier, String masterRateIdentifier, DateRange dateRange) throws WebClientResponseException {
        ParameterizedTypeReference<Rate> localVarReturnType = new ParameterizedTypeReference<Rate>() {};
        return showAllMasterRatesRatesRequestCreation(hotelIdentifier, masterRateIdentifier, dateRange).bodyToFlux(localVarReturnType);
    }

    public Mono<ResponseEntity<List<Rate>>> showAllMasterRatesRatesWithHttpInfo(String hotelIdentifier, String masterRateIdentifier, DateRange dateRange) throws WebClientResponseException {
        ParameterizedTypeReference<Rate> localVarReturnType = new ParameterizedTypeReference<Rate>() {};
        return showAllMasterRatesRatesRequestCreation(hotelIdentifier, masterRateIdentifier, dateRange).toEntityList(localVarReturnType);
    }
    /**
     * List Sales Channels
     * List sales channels for property
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier The hotelIdentifier parameter
     * @param accept The accept parameter
     * @return List&lt;ChannelName&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showChannelsRequestCreation(String hotelIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showChannels", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<ChannelName> localVarReturnType = new ParameterizedTypeReference<ChannelName>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/sandbox/channel/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List Sales Channels
     * List sales channels for property
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier The hotelIdentifier parameter
     * @param accept The accept parameter
     * @return List&lt;ChannelName&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<ChannelName> showChannels(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<ChannelName> localVarReturnType = new ParameterizedTypeReference<ChannelName>() {};
        return showChannelsRequestCreation(hotelIdentifier, accept).bodyToFlux(localVarReturnType);
    }

    public Mono<ResponseEntity<List<ChannelName>>> showChannelsWithHttpInfo(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<ChannelName> localVarReturnType = new ParameterizedTypeReference<ChannelName>() {};
        return showChannelsRequestCreation(hotelIdentifier, accept).toEntityList(localVarReturnType);
    }
    /**
     * Show Daily Rate Page
     * Retrieve daily rates for a master rate within a certain date range.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show daily rate page owned by this hotel identifier.
     * @param masterRateIdentifier Show daily rate page owned by this master rate.
     * @param state The state parameter
     * @return PageRate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showDailyRatesPageRequestCreation(String hotelIdentifier, String masterRateIdentifier, State state) throws WebClientResponseException {
        Object postBody = state;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showDailyRatesPage", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'masterRateIdentifier' is set
        if (masterRateIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'masterRateIdentifier' when calling showDailyRatesPage", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'state' is set
        if (state == null) {
            throw new WebClientResponseException("Missing the required parameter 'state' when calling showDailyRatesPage", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("masterRateIdentifier", masterRateIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<PageRate> localVarReturnType = new ParameterizedTypeReference<PageRate>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/roomrate/{masterRateIdentifier}/rate/grid", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Daily Rate Page
     * Retrieve daily rates for a master rate within a certain date range.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show daily rate page owned by this hotel identifier.
     * @param masterRateIdentifier Show daily rate page owned by this master rate.
     * @param state The state parameter
     * @return PageRate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<PageRate> showDailyRatesPage(String hotelIdentifier, String masterRateIdentifier, State state) throws WebClientResponseException {
        ParameterizedTypeReference<PageRate> localVarReturnType = new ParameterizedTypeReference<PageRate>() {};
        return showDailyRatesPageRequestCreation(hotelIdentifier, masterRateIdentifier, state).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<PageRate>> showDailyRatesPageWithHttpInfo(String hotelIdentifier, String masterRateIdentifier, State state) throws WebClientResponseException {
        ParameterizedTypeReference<PageRate> localVarReturnType = new ParameterizedTypeReference<PageRate>() {};
        return showDailyRatesPageRequestCreation(hotelIdentifier, masterRateIdentifier, state).toEntity(localVarReturnType);
    }
    /**
     * Test Rate / Availability
     * Test whether the rates and availability for a sales channel is coming backing the way the property wants
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier The hotelIdentifier parameter
     * @param rateTesterDescriptive The rateTesterDescriptive parameter
     * @return List&lt;DescriptiveRoomDescriptive&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showDescriptiveInventoryRequestCreation(String hotelIdentifier, RateTesterDescriptive rateTesterDescriptive) throws WebClientResponseException {
        Object postBody = rateTesterDescriptive;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showDescriptiveInventory", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'rateTesterDescriptive' is set
        if (rateTesterDescriptive == null) {
            throw new WebClientResponseException("Missing the required parameter 'rateTesterDescriptive' when calling showDescriptiveInventory", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<DescriptiveRoomDescriptive> localVarReturnType = new ParameterizedTypeReference<DescriptiveRoomDescriptive>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/sandbox/room/list", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Test Rate / Availability
     * Test whether the rates and availability for a sales channel is coming backing the way the property wants
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier The hotelIdentifier parameter
     * @param rateTesterDescriptive The rateTesterDescriptive parameter
     * @return List&lt;DescriptiveRoomDescriptive&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<DescriptiveRoomDescriptive> showDescriptiveInventory(String hotelIdentifier, RateTesterDescriptive rateTesterDescriptive) throws WebClientResponseException {
        ParameterizedTypeReference<DescriptiveRoomDescriptive> localVarReturnType = new ParameterizedTypeReference<DescriptiveRoomDescriptive>() {};
        return showDescriptiveInventoryRequestCreation(hotelIdentifier, rateTesterDescriptive).bodyToFlux(localVarReturnType);
    }

    public Mono<ResponseEntity<List<DescriptiveRoomDescriptive>>> showDescriptiveInventoryWithHttpInfo(String hotelIdentifier, RateTesterDescriptive rateTesterDescriptive) throws WebClientResponseException {
        ParameterizedTypeReference<DescriptiveRoomDescriptive> localVarReturnType = new ParameterizedTypeReference<DescriptiveRoomDescriptive>() {};
        return showDescriptiveInventoryRequestCreation(hotelIdentifier, rateTesterDescriptive).toEntityList(localVarReturnType);
    }
}
