package travel.wink.sdk.extranet.api;

import travel.wink.sdk.extranet.invoker.ApiClient;

import travel.wink.sdk.extranet.model.CountResponse;
import travel.wink.sdk.extranet.model.GenericErrorMessage;
import travel.wink.sdk.extranet.model.PageReviewView;
import travel.wink.sdk.extranet.model.ReviewResponse;
import travel.wink.sdk.extranet.model.ReviewView;
import travel.wink.sdk.extranet.model.ShowPropertyPolicy400Response;
import travel.wink.sdk.extranet.model.State;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-09-16T10:42:12.086235846+07:00[Asia/Bangkok]")
public class ReviewApi {
    private ApiClient apiClient;

    public ReviewApi() {
        this(new ApiClient());
    }

    @Autowired
    public ReviewApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Respond to Review
     * Respond to a unique review for a hotel identified by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Respond to review given hotel with this identifier
     * @param reviewIdentifier Respond to review with this identifier
     * @param reviewResponse The reviewResponse parameter
     * @return ReviewView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec respondToReviewRequestCreation(String hotelIdentifier, String reviewIdentifier, ReviewResponse reviewResponse) throws WebClientResponseException {
        Object postBody = reviewResponse;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling respondToReview", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'reviewIdentifier' is set
        if (reviewIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'reviewIdentifier' when calling respondToReview", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'reviewResponse' is set
        if (reviewResponse == null) {
            throw new WebClientResponseException("Missing the required parameter 'reviewResponse' when calling respondToReview", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("reviewIdentifier", reviewIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<ReviewView> localVarReturnType = new ParameterizedTypeReference<ReviewView>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/review/{reviewIdentifier}/response", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Respond to Review
     * Respond to a unique review for a hotel identified by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Respond to review given hotel with this identifier
     * @param reviewIdentifier Respond to review with this identifier
     * @param reviewResponse The reviewResponse parameter
     * @return ReviewView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ReviewView> respondToReview(String hotelIdentifier, String reviewIdentifier, ReviewResponse reviewResponse) throws WebClientResponseException {
        ParameterizedTypeReference<ReviewView> localVarReturnType = new ParameterizedTypeReference<ReviewView>() {};
        return respondToReviewRequestCreation(hotelIdentifier, reviewIdentifier, reviewResponse).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<ReviewView>> respondToReviewWithHttpInfo(String hotelIdentifier, String reviewIdentifier, ReviewResponse reviewResponse) throws WebClientResponseException {
        ParameterizedTypeReference<ReviewView> localVarReturnType = new ParameterizedTypeReference<ReviewView>() {};
        return respondToReviewRequestCreation(hotelIdentifier, reviewIdentifier, reviewResponse).toEntity(localVarReturnType);
    }
    /**
     * Show Review
     * Retrieve a unique review of a hotel identified by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show review given to hotel with this identifier
     * @param reviewIdentifier Show review for this identifier
     * @param accept The accept parameter
     * @return ReviewView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showReviewRequestCreation(String hotelIdentifier, String reviewIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showReview", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'reviewIdentifier' is set
        if (reviewIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'reviewIdentifier' when calling showReview", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("reviewIdentifier", reviewIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<ReviewView> localVarReturnType = new ParameterizedTypeReference<ReviewView>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/review/{reviewIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Review
     * Retrieve a unique review of a hotel identified by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show review given to hotel with this identifier
     * @param reviewIdentifier Show review for this identifier
     * @param accept The accept parameter
     * @return ReviewView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ReviewView> showReview(String hotelIdentifier, String reviewIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<ReviewView> localVarReturnType = new ParameterizedTypeReference<ReviewView>() {};
        return showReviewRequestCreation(hotelIdentifier, reviewIdentifier, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<ReviewView>> showReviewWithHttpInfo(String hotelIdentifier, String reviewIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<ReviewView> localVarReturnType = new ParameterizedTypeReference<ReviewView>() {};
        return showReviewRequestCreation(hotelIdentifier, reviewIdentifier, accept).toEntity(localVarReturnType);
    }
    /**
     * Show Review Count
     * Retrieve a count of all reviews for a hotel identified by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show review count for hotel with this identifier
     * @param accept The accept parameter
     * @return CountResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showReviewCountRequestCreation(String hotelIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showReviewCount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<CountResponse> localVarReturnType = new ParameterizedTypeReference<CountResponse>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/review/count", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Review Count
     * Retrieve a count of all reviews for a hotel identified by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show review count for hotel with this identifier
     * @param accept The accept parameter
     * @return CountResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<CountResponse> showReviewCount(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<CountResponse> localVarReturnType = new ParameterizedTypeReference<CountResponse>() {};
        return showReviewCountRequestCreation(hotelIdentifier, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<CountResponse>> showReviewCountWithHttpInfo(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<CountResponse> localVarReturnType = new ParameterizedTypeReference<CountResponse>() {};
        return showReviewCountRequestCreation(hotelIdentifier, accept).toEntity(localVarReturnType);
    }
    /**
     * Show Reviews
     * Retrieve a paginated list of reviews for specified property
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show reviews for hotel with this identifier
     * @param state The state parameter
     * @return PageReviewView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showReviewsRequestCreation(String hotelIdentifier, State state) throws WebClientResponseException {
        Object postBody = state;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showReviews", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'state' is set
        if (state == null) {
            throw new WebClientResponseException("Missing the required parameter 'state' when calling showReviews", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<PageReviewView> localVarReturnType = new ParameterizedTypeReference<PageReviewView>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/review/grid", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Reviews
     * Retrieve a paginated list of reviews for specified property
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show reviews for hotel with this identifier
     * @param state The state parameter
     * @return PageReviewView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<PageReviewView> showReviews(String hotelIdentifier, State state) throws WebClientResponseException {
        ParameterizedTypeReference<PageReviewView> localVarReturnType = new ParameterizedTypeReference<PageReviewView>() {};
        return showReviewsRequestCreation(hotelIdentifier, state).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<PageReviewView>> showReviewsWithHttpInfo(String hotelIdentifier, State state) throws WebClientResponseException {
        ParameterizedTypeReference<PageReviewView> localVarReturnType = new ParameterizedTypeReference<PageReviewView>() {};
        return showReviewsRequestCreation(hotelIdentifier, state).toEntity(localVarReturnType);
    }
}
